

# [derive (Copy , Clone , Debug , PartialEq , Eq)]
pub enum Interrupt { # [doc = "0 - WWDG"]
WWDG = 0 , # [doc = "1 - PVD"]
PVD = 1 , # [doc = "2 - TAMP_STAMP"]
TAMP_STAMP = 2 , # [doc = "3 - RTC_WKUP"]
RTC_WKUP = 3 , # [doc = "4 - FLASH"]
FLASH = 4 , # [doc = "5 - RCC"]
RCC = 5 , # [doc = "6 - EXTI0"]
EXTI0 = 6 , # [doc = "7 - EXTI1"]
EXTI1 = 7 , # [doc = "8 - EXTI2_TSC"]
EXTI2_TSC = 8 , # [doc = "9 - EXTI3"]
EXTI3 = 9 , # [doc = "10 - EXTI4"]
EXTI4 = 10 , # [doc = "11 - DMA1_CHANNEL1"]
DMA1_CHANNEL1 = 11 , # [doc = "12 - DMA1_CHANNEL2"]
DMA1_CHANNEL2 = 12 , # [doc = "13 - DMA1_CHANNEL3"]
DMA1_CHANNEL3 = 13 , # [doc = "14 - DMA1_CHANNEL4"]
DMA1_CHANNEL4 = 14 , # [doc = "15 - DMA1_CHANNEL5"]
DMA1_CHANNEL5 = 15 , # [doc = "16 - DMA1_CHANNEL6"]
DMA1_CHANNEL6 = 16 , # [doc = "17 - DMA1_CHANNEL7"]
DMA1_CHANNEL7 = 17 , # [doc = "18 - ADC1_2"]
ADC1_2 = 18 , # [doc = "19 - CAN_TX"]
CAN_TX = 19 , # [doc = "20 - CAN_RX0"]
CAN_RX0 = 20 , # [doc = "21 - CAN_RX1"]
CAN_RX1 = 21 , # [doc = "22 - CAN_SCE"]
CAN_SCE = 22 , # [doc = "23 - EXTI9_5"]
EXTI9_5 = 23 , # [doc = "24 - TIM1_BRK_TIM15"]
TIM1_BRK_TIM15 = 24 , # [doc = "25 - TIM1_UP_TIM16"]
TIM1_UP_TIM16 = 25 , # [doc = "26 - TIM1_TRG_COM_TIM17"]
TIM1_TRG_COM_TIM17 = 26 , # [doc = "27 - TIM1_CC"]
TIM1_CC = 27 , # [doc = "28 - TIM2"]
TIM2 = 28 , # [doc = "29 - TIM3"]
TIM3 = 29 , # [doc = "31 - I2C1_EV"]
I2C1_EV = 31 , # [doc = "32 - I2C1_ER"]
I2C1_ER = 32 , # [doc = "35 - SPI1"]
SPI1 = 35 , # [doc = "37 - USART1"]
USART1 = 37 , # [doc = "38 - USART2"]
USART2 = 38 , # [doc = "39 - USART3"]
USART3 = 39 , # [doc = "40 - EXTI15_10"]
EXTI15_10 = 40 , # [doc = "41 - RTC_ALARM"]
RTC_ALARM = 41 , # [doc = "55 - TIM7_DAC2"]
TIM7_DAC2 = 55 , # [doc = "64 - COMP2"]
COMP2 = 64 , # [doc = "65 - COMP4_6"]
COMP4_6 = 65 , # [doc = "81 - FPU"]
FPU = 81 , } unsafe impl cortex_m :: interrupt :: InterruptNumber for Interrupt { # [inline (always)]
fn number (self) -> u16 { self as u16 } } # [cfg (feature = "rt")]
mod _vectors { extern "C" { fn WWDG () ; fn PVD () ; fn TAMP_STAMP () ; fn RTC_WKUP () ; fn FLASH () ; fn RCC () ; fn EXTI0 () ; fn EXTI1 () ; fn EXTI2_TSC () ; fn EXTI3 () ; fn EXTI4 () ; fn DMA1_CHANNEL1 () ; fn DMA1_CHANNEL2 () ; fn DMA1_CHANNEL3 () ; fn DMA1_CHANNEL4 () ; fn DMA1_CHANNEL5 () ; fn DMA1_CHANNEL6 () ; fn DMA1_CHANNEL7 () ; fn ADC1_2 () ; fn CAN_TX () ; fn CAN_RX0 () ; fn CAN_RX1 () ; fn CAN_SCE () ; fn EXTI9_5 () ; fn TIM1_BRK_TIM15 () ; fn TIM1_UP_TIM16 () ; fn TIM1_TRG_COM_TIM17 () ; fn TIM1_CC () ; fn TIM2 () ; fn TIM3 () ; fn I2C1_EV () ; fn I2C1_ER () ; fn SPI1 () ; fn USART1 () ; fn USART2 () ; fn USART3 () ; fn EXTI15_10 () ; fn RTC_ALARM () ; fn TIM7_DAC2 () ; fn COMP2 () ; fn COMP4_6 () ; fn FPU () ; } pub union Vector { _handler : unsafe extern "C" fn () , _reserved : u32 , } # [link_section = ".vector_table.interrupts"]
# [no_mangle]
pub static __INTERRUPTS : [Vector ; 82]
= [Vector { _handler : WWDG } , Vector { _handler : PVD } , Vector { _handler : TAMP_STAMP } , Vector { _handler : RTC_WKUP } , Vector { _handler : FLASH } , Vector { _handler : RCC } , Vector { _handler : EXTI0 } , Vector { _handler : EXTI1 } , Vector { _handler : EXTI2_TSC } , Vector { _handler : EXTI3 } , Vector { _handler : EXTI4 } , Vector { _handler : DMA1_CHANNEL1 } , Vector { _handler : DMA1_CHANNEL2 } , Vector { _handler : DMA1_CHANNEL3 } , Vector { _handler : DMA1_CHANNEL4 } , Vector { _handler : DMA1_CHANNEL5 } , Vector { _handler : DMA1_CHANNEL6 } , Vector { _handler : DMA1_CHANNEL7 } , Vector { _handler : ADC1_2 } , Vector { _handler : CAN_TX } , Vector { _handler : CAN_RX0 } , Vector { _handler : CAN_RX1 } , Vector { _handler : CAN_SCE } , Vector { _handler : EXTI9_5 } , Vector { _handler : TIM1_BRK_TIM15 } , Vector { _handler : TIM1_UP_TIM16 } , Vector { _handler : TIM1_TRG_COM_TIM17 } , Vector { _handler : TIM1_CC } , Vector { _handler : TIM2 } , Vector { _handler : TIM3 } , Vector { _reserved : 0 } , Vector { _handler : I2C1_EV } , Vector { _handler : I2C1_ER } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : SPI1 } , Vector { _reserved : 0 } , Vector { _handler : USART1 } , Vector { _handler : USART2 } , Vector { _handler : USART3 } , Vector { _handler : EXTI15_10 } , Vector { _handler : RTC_ALARM } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : TIM7_DAC2 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : COMP2 } , Vector { _handler : COMP4_6 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : FPU } ,]
; } pub const ADC1 : * mut () = 0x5000_0000 as u32 as _ ; pub const ADC2 : * mut () = 0x5000_0100 as u32 as _ ; pub const ADC_COMMON : * mut () = 0x5000_0300 as u32 as _ ; pub const CAN : can :: Can = can :: Can (0x4000_6400 as u32 as _) ; pub const COMP2 : * mut () = 0x4001_0020 as u32 as _ ; pub const COMP4 : * mut () = 0x4001_0028 as u32 as _ ; pub const CRC : crc :: Crc = crc :: Crc (0x4002_3000 as u32 as _) ; pub const DAC1 : * mut () = 0x4000_7400 as u32 as _ ; pub const DAC2 : * mut () = 0x4000_9800 as u32 as _ ; pub const DBGMCU : dbgmcu :: Dbgmcu = dbgmcu :: Dbgmcu (0xe004_2000 as u32 as _) ; pub const DMA1 : bdma :: Dma = bdma :: Dma (0x4002_0000 as u32 as _) ; pub const EXTI : exti :: Exti = exti :: Exti (0x4001_0400 as u32 as _) ; pub const FLASH : flash :: Flash = flash :: Flash (0x4002_2000 as u32 as _) ; pub const GPIOA : gpio :: Gpio = gpio :: Gpio (0x4800_0000 as u32 as _) ; pub const GPIOB : gpio :: Gpio = gpio :: Gpio (0x4800_0400 as u32 as _) ; pub const GPIOC : gpio :: Gpio = gpio :: Gpio (0x4800_0800 as u32 as _) ; pub const GPIOD : gpio :: Gpio = gpio :: Gpio (0x4800_0c00 as u32 as _) ; pub const GPIOF : gpio :: Gpio = gpio :: Gpio (0x4800_1400 as u32 as _) ; pub const I2C1 : i2c :: I2c = i2c :: I2c (0x4000_5400 as u32 as _) ; pub const IWDG : iwdg :: Iwdg = iwdg :: Iwdg (0x4000_3000 as u32 as _) ; pub const OPAMP2 : * mut () = 0x4001_003c as u32 as _ ; pub const PWR : pwr :: Pwr = pwr :: Pwr (0x4000_7000 as u32 as _) ; pub const RCC : rcc :: Rcc = rcc :: Rcc (0x4002_1000 as u32 as _) ; pub const RTC : * mut () = 0x4000_2800 as u32 as _ ; pub const SPI1 : spi :: Spi = spi :: Spi (0x4001_3000 as u32 as _) ; pub const SYSCFG : syscfg :: Syscfg = syscfg :: Syscfg (0x4001_0000 as u32 as _) ; pub const TIM1 : timer :: TimAdv = timer :: TimAdv (0x4001_2c00 as u32 as _) ; pub const TIM15 : timer :: TimGp16 = timer :: TimGp16 (0x4001_4000 as u32 as _) ; pub const TIM16 : timer :: TimGp16 = timer :: TimGp16 (0x4001_4400 as u32 as _) ; pub const TIM17 : timer :: TimGp16 = timer :: TimGp16 (0x4001_4800 as u32 as _) ; pub const TIM2 : timer :: TimGp32 = timer :: TimGp32 (0x4000_0000 as u32 as _) ; pub const TIM3 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0400 as u32 as _) ; pub const TIM6 : timer :: TimBasic = timer :: TimBasic (0x4000_1000 as u32 as _) ; pub const TIM7 : timer :: TimBasic = timer :: TimBasic (0x4000_1400 as u32 as _) ; pub const TSC : * mut () = 0x4002_4000 as u32 as _ ; pub const USART1 : usart :: Usart = usart :: Usart (0x4001_3800 as u32 as _) ; pub const USART2 : usart :: Usart = usart :: Usart (0x4000_4400 as u32 as _) ; pub const WWDG : wwdg :: Wwdg = wwdg :: Wwdg (0x4000_2c00 as u32 as _) ;pub fn GPIO(n: usize) -> gpio::Gpio {
            gpio::Gpio((1207959552 + 1024*n) as _)
        }#[path="../../peripherals/bdma_v1.rs"] pub mod bdma;
#[path="../../peripherals/can_bxcan.rs"] pub mod can;
#[path="../../peripherals/crc_v2.rs"] pub mod crc;
#[path="../../peripherals/dbgmcu_f3.rs"] pub mod dbgmcu;
#[path="../../peripherals/exti_v1.rs"] pub mod exti;
#[path="../../peripherals/flash_f3.rs"] pub mod flash;
#[path="../../peripherals/gpio_v2.rs"] pub mod gpio;
#[path="../../peripherals/i2c_v2.rs"] pub mod i2c;
#[path="../../peripherals/iwdg_v2.rs"] pub mod iwdg;
#[path="../../peripherals/pwr_f3.rs"] pub mod pwr;
#[path="../../peripherals/rcc_f3.rs"] pub mod rcc;
#[path="../../peripherals/spi_v2.rs"] pub mod spi;
#[path="../../peripherals/syscfg_f3.rs"] pub mod syscfg;
#[path="../../peripherals/timer_v1.rs"] pub mod timer;
#[path="../../peripherals/usart_v2.rs"] pub mod usart;
#[path="../../peripherals/wwdg_v1.rs"] pub mod wwdg;
pub const CORE_INDEX: usize = 0;
