

# [derive (Copy , Clone , Debug , PartialEq , Eq)]
pub enum Interrupt { # [doc = "0 - WWDG"]
WWDG = 0 , # [doc = "1 - PVD"]
PVD = 1 , # [doc = "2 - TAMPER"]
TAMPER = 2 , # [doc = "3 - RTC"]
RTC = 3 , # [doc = "4 - FLASH"]
FLASH = 4 , # [doc = "5 - RCC"]
RCC = 5 , # [doc = "6 - EXTI0"]
EXTI0 = 6 , # [doc = "7 - EXTI1"]
EXTI1 = 7 , # [doc = "8 - EXTI2"]
EXTI2 = 8 , # [doc = "9 - EXTI3"]
EXTI3 = 9 , # [doc = "10 - EXTI4"]
EXTI4 = 10 , # [doc = "11 - DMA1_CHANNEL1"]
DMA1_CHANNEL1 = 11 , # [doc = "12 - DMA1_CHANNEL2"]
DMA1_CHANNEL2 = 12 , # [doc = "13 - DMA1_CHANNEL3"]
DMA1_CHANNEL3 = 13 , # [doc = "14 - DMA1_CHANNEL4"]
DMA1_CHANNEL4 = 14 , # [doc = "15 - DMA1_CHANNEL5"]
DMA1_CHANNEL5 = 15 , # [doc = "16 - DMA1_CHANNEL6"]
DMA1_CHANNEL6 = 16 , # [doc = "17 - DMA1_CHANNEL7"]
DMA1_CHANNEL7 = 17 , # [doc = "18 - ADC1"]
ADC1 = 18 , # [doc = "23 - EXTI9_5"]
EXTI9_5 = 23 , # [doc = "28 - TIM2"]
TIM2 = 28 , # [doc = "29 - TIM3"]
TIM3 = 29 , # [doc = "30 - TIM4"]
TIM4 = 30 , # [doc = "31 - I2C1_EV"]
I2C1_EV = 31 , # [doc = "32 - I2C1_ER"]
I2C1_ER = 32 , # [doc = "33 - I2C2_EV"]
I2C2_EV = 33 , # [doc = "34 - I2C2_ER"]
I2C2_ER = 34 , # [doc = "35 - SPI1"]
SPI1 = 35 , # [doc = "36 - SPI2"]
SPI2 = 36 , # [doc = "37 - USART1"]
USART1 = 37 , # [doc = "38 - USART2"]
USART2 = 38 , # [doc = "39 - USART3"]
USART3 = 39 , # [doc = "40 - EXTI15_10"]
EXTI15_10 = 40 , # [doc = "41 - RTC_ALARM"]
RTC_ALARM = 41 , # [doc = "48 - FSMC"]
FSMC = 48 , # [doc = "50 - TIM5"]
TIM5 = 50 , # [doc = "51 - SPI3"]
SPI3 = 51 , # [doc = "52 - UART4"]
UART4 = 52 , # [doc = "53 - UART5"]
UART5 = 53 , # [doc = "54 - TIM6"]
TIM6 = 54 , # [doc = "55 - TIM7"]
TIM7 = 55 , # [doc = "56 - DMA2_CHANNEL1"]
DMA2_CHANNEL1 = 56 , # [doc = "57 - DMA2_CHANNEL2"]
DMA2_CHANNEL2 = 57 , # [doc = "58 - DMA2_CHANNEL3"]
DMA2_CHANNEL3 = 58 , # [doc = "59 - DMA2_CHANNEL4_5"]
DMA2_CHANNEL4_5 = 59 , } unsafe impl cortex_m :: interrupt :: InterruptNumber for Interrupt { # [inline (always)]
fn number (self) -> u16 { self as u16 } } # [cfg (feature = "rt")]
mod _vectors { extern "C" { fn WWDG () ; fn PVD () ; fn TAMPER () ; fn RTC () ; fn FLASH () ; fn RCC () ; fn EXTI0 () ; fn EXTI1 () ; fn EXTI2 () ; fn EXTI3 () ; fn EXTI4 () ; fn DMA1_CHANNEL1 () ; fn DMA1_CHANNEL2 () ; fn DMA1_CHANNEL3 () ; fn DMA1_CHANNEL4 () ; fn DMA1_CHANNEL5 () ; fn DMA1_CHANNEL6 () ; fn DMA1_CHANNEL7 () ; fn ADC1 () ; fn EXTI9_5 () ; fn TIM2 () ; fn TIM3 () ; fn TIM4 () ; fn I2C1_EV () ; fn I2C1_ER () ; fn I2C2_EV () ; fn I2C2_ER () ; fn SPI1 () ; fn SPI2 () ; fn USART1 () ; fn USART2 () ; fn USART3 () ; fn EXTI15_10 () ; fn RTC_ALARM () ; fn FSMC () ; fn TIM5 () ; fn SPI3 () ; fn UART4 () ; fn UART5 () ; fn TIM6 () ; fn TIM7 () ; fn DMA2_CHANNEL1 () ; fn DMA2_CHANNEL2 () ; fn DMA2_CHANNEL3 () ; fn DMA2_CHANNEL4_5 () ; } pub union Vector { _handler : unsafe extern "C" fn () , _reserved : u32 , } # [link_section = ".vector_table.interrupts"]
# [no_mangle]
pub static __INTERRUPTS : [Vector ; 60]
= [Vector { _handler : WWDG } , Vector { _handler : PVD } , Vector { _handler : TAMPER } , Vector { _handler : RTC } , Vector { _handler : FLASH } , Vector { _handler : RCC } , Vector { _handler : EXTI0 } , Vector { _handler : EXTI1 } , Vector { _handler : EXTI2 } , Vector { _handler : EXTI3 } , Vector { _handler : EXTI4 } , Vector { _handler : DMA1_CHANNEL1 } , Vector { _handler : DMA1_CHANNEL2 } , Vector { _handler : DMA1_CHANNEL3 } , Vector { _handler : DMA1_CHANNEL4 } , Vector { _handler : DMA1_CHANNEL5 } , Vector { _handler : DMA1_CHANNEL6 } , Vector { _handler : DMA1_CHANNEL7 } , Vector { _handler : ADC1 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : EXTI9_5 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : TIM2 } , Vector { _handler : TIM3 } , Vector { _handler : TIM4 } , Vector { _handler : I2C1_EV } , Vector { _handler : I2C1_ER } , Vector { _handler : I2C2_EV } , Vector { _handler : I2C2_ER } , Vector { _handler : SPI1 } , Vector { _handler : SPI2 } , Vector { _handler : USART1 } , Vector { _handler : USART2 } , Vector { _handler : USART3 } , Vector { _handler : EXTI15_10 } , Vector { _handler : RTC_ALARM } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _reserved : 0 } , Vector { _handler : FSMC } , Vector { _reserved : 0 } , Vector { _handler : TIM5 } , Vector { _handler : SPI3 } , Vector { _handler : UART4 } , Vector { _handler : UART5 } , Vector { _handler : TIM6 } , Vector { _handler : TIM7 } , Vector { _handler : DMA2_CHANNEL1 } , Vector { _handler : DMA2_CHANNEL2 } , Vector { _handler : DMA2_CHANNEL3 } , Vector { _handler : DMA2_CHANNEL4_5 } ,]
; } pub const ADC1 : adc :: Adc = adc :: Adc (0x4001_2400 as u32 as _) ; pub const ADC_COMMON : * mut () = 0x4001_2400 as u32 as _ ; pub const AFIO : afio :: Afio = afio :: Afio (0x4001_0000 as u32 as _) ; pub const CRC : crc :: Crc = crc :: Crc (0x4002_3000 as u32 as _) ; pub const DAC : * mut () = 0x4000_7400 as u32 as _ ; pub const DBGMCU : dbgmcu :: Dbgmcu = dbgmcu :: Dbgmcu (0xe004_2000 as u32 as _) ; pub const DMA1 : bdma :: Dma = bdma :: Dma (0x4002_0000 as u32 as _) ; pub const DMA2 : bdma :: Dma = bdma :: Dma (0x4002_0400 as u32 as _) ; pub const EXTI : exti :: Exti = exti :: Exti (0x4001_0400 as u32 as _) ; pub const FLASH : flash :: Flash = flash :: Flash (0x4002_2000 as u32 as _) ; pub const GPIOA : gpio :: Gpio = gpio :: Gpio (0x4001_0800 as u32 as _) ; pub const GPIOB : gpio :: Gpio = gpio :: Gpio (0x4001_0c00 as u32 as _) ; pub const GPIOC : gpio :: Gpio = gpio :: Gpio (0x4001_1000 as u32 as _) ; pub const GPIOD : gpio :: Gpio = gpio :: Gpio (0x4001_1400 as u32 as _) ; pub const GPIOE : gpio :: Gpio = gpio :: Gpio (0x4001_1800 as u32 as _) ; pub const GPIOF : gpio :: Gpio = gpio :: Gpio (0x4001_1c00 as u32 as _) ; pub const GPIOG : gpio :: Gpio = gpio :: Gpio (0x4001_2000 as u32 as _) ; pub const I2C1 : i2c :: I2c = i2c :: I2c (0x4000_5400 as u32 as _) ; pub const I2C2 : i2c :: I2c = i2c :: I2c (0x4000_5800 as u32 as _) ; pub const IWDG : * mut () = 0x4000_3000 as u32 as _ ; pub const PWR : * mut () = 0x4000_7000 as u32 as _ ; pub const RCC : rcc :: Rcc = rcc :: Rcc (0x4002_1000 as u32 as _) ; pub const RTC : * mut () = 0x4000_2800 as u32 as _ ; pub const SPI1 : * mut () = 0x4001_3000 as u32 as _ ; pub const SPI2 : * mut () = 0x4000_3800 as u32 as _ ; pub const SPI3 : * mut () = 0x4000_3c00 as u32 as _ ; pub const TIM2 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0000 as u32 as _) ; pub const TIM3 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0400 as u32 as _) ; pub const TIM4 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0800 as u32 as _) ; pub const TIM5 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0c00 as u32 as _) ; pub const TIM6 : timer :: TimGp16 = timer :: TimGp16 (0x4000_1000 as u32 as _) ; pub const TIM7 : timer :: TimGp16 = timer :: TimGp16 (0x4000_1400 as u32 as _) ; pub const UART4 : * mut () = 0x4000_4c00 as u32 as _ ; pub const UART5 : * mut () = 0x4000_5000 as u32 as _ ; pub const USART1 : usart :: Usart = usart :: Usart (0x4001_3800 as u32 as _) ; pub const USART2 : usart :: Usart = usart :: Usart (0x4000_4400 as u32 as _) ; pub const USART3 : usart :: Usart = usart :: Usart (0x4000_4800 as u32 as _) ; pub const WWDG : wwdg :: Wwdg = wwdg :: Wwdg (0x4000_2c00 as u32 as _) ;pub fn GPIO(n: usize) -> gpio::Gpio {
            gpio::Gpio((1073809408 + 1024*n) as _)
        }#[path="../../peripherals/adc_f1.rs"] pub mod adc;
#[path="../../peripherals/afio_f1.rs"] pub mod afio;
#[path="../../peripherals/bdma_v1.rs"] pub mod bdma;
#[path="../../peripherals/crc_v1.rs"] pub mod crc;
#[path="../../peripherals/dbgmcu_f1.rs"] pub mod dbgmcu;
#[path="../../peripherals/exti_v1.rs"] pub mod exti;
#[path="../../peripherals/flash_f1.rs"] pub mod flash;
#[path="../../peripherals/gpio_v1.rs"] pub mod gpio;
#[path="../../peripherals/i2c_v1.rs"] pub mod i2c;
#[path="../../peripherals/rcc_f1.rs"] pub mod rcc;
#[path="../../peripherals/timer_v1.rs"] pub mod timer;
#[path="../../peripherals/usart_v1.rs"] pub mod usart;
#[path="../../peripherals/wwdg_v1.rs"] pub mod wwdg;
pub const CORE_INDEX: usize = 0;
