

# [derive (Copy , Clone , Debug , PartialEq , Eq)]
pub enum Interrupt { # [doc = "0 - WWDG"]
WWDG = 0 , # [doc = "1 - PVD_VDDIO2"]
PVD_VDDIO2 = 1 , # [doc = "2 - RTC"]
RTC = 2 , # [doc = "3 - FLASH"]
FLASH = 3 , # [doc = "4 - RCC_CRS"]
RCC_CRS = 4 , # [doc = "5 - EXTI0_1"]
EXTI0_1 = 5 , # [doc = "6 - EXTI2_3"]
EXTI2_3 = 6 , # [doc = "7 - EXTI4_15"]
EXTI4_15 = 7 , # [doc = "8 - TSC"]
TSC = 8 , # [doc = "9 - DMA1_CH1"]
DMA1_CH1 = 9 , # [doc = "10 - DMA1_CH2_3_DMA2_CH1_2"]
DMA1_CH2_3_DMA2_CH1_2 = 10 , # [doc = "11 - DMA1_CH4_7_DMA2_CH3_5"]
DMA1_CH4_7_DMA2_CH3_5 = 11 , # [doc = "12 - ADC1_COMP"]
ADC1_COMP = 12 , # [doc = "13 - TIM1_BRK_UP_TRG_COM"]
TIM1_BRK_UP_TRG_COM = 13 , # [doc = "14 - TIM1_CC"]
TIM1_CC = 14 , # [doc = "15 - TIM2"]
TIM2 = 15 , # [doc = "16 - TIM3"]
TIM3 = 16 , # [doc = "17 - TIM6_DAC"]
TIM6_DAC = 17 , # [doc = "18 - TIM7"]
TIM7 = 18 , # [doc = "19 - TIM14"]
TIM14 = 19 , # [doc = "20 - TIM15"]
TIM15 = 20 , # [doc = "21 - TIM16"]
TIM16 = 21 , # [doc = "22 - TIM17"]
TIM17 = 22 , # [doc = "23 - I2C1"]
I2C1 = 23 , # [doc = "24 - I2C2"]
I2C2 = 24 , # [doc = "25 - SPI1"]
SPI1 = 25 , # [doc = "26 - SPI2"]
SPI2 = 26 , # [doc = "27 - USART1"]
USART1 = 27 , # [doc = "28 - USART2"]
USART2 = 28 , # [doc = "29 - USART3_8"]
USART3_8 = 29 , # [doc = "30 - CEC_CAN"]
CEC_CAN = 30 , } unsafe impl cortex_m :: interrupt :: InterruptNumber for Interrupt { # [inline (always)]
fn number (self) -> u16 { self as u16 } } # [cfg (feature = "rt")]
mod _vectors { extern "C" { fn WWDG () ; fn PVD_VDDIO2 () ; fn RTC () ; fn FLASH () ; fn RCC_CRS () ; fn EXTI0_1 () ; fn EXTI2_3 () ; fn EXTI4_15 () ; fn TSC () ; fn DMA1_CH1 () ; fn DMA1_CH2_3_DMA2_CH1_2 () ; fn DMA1_CH4_7_DMA2_CH3_5 () ; fn ADC1_COMP () ; fn TIM1_BRK_UP_TRG_COM () ; fn TIM1_CC () ; fn TIM2 () ; fn TIM3 () ; fn TIM6_DAC () ; fn TIM7 () ; fn TIM14 () ; fn TIM15 () ; fn TIM16 () ; fn TIM17 () ; fn I2C1 () ; fn I2C2 () ; fn SPI1 () ; fn SPI2 () ; fn USART1 () ; fn USART2 () ; fn USART3_8 () ; fn CEC_CAN () ; } pub union Vector { _handler : unsafe extern "C" fn () , _reserved : u32 , } # [link_section = ".vector_table.interrupts"]
# [no_mangle]
pub static __INTERRUPTS : [Vector ; 31]
= [Vector { _handler : WWDG } , Vector { _handler : PVD_VDDIO2 } , Vector { _handler : RTC } , Vector { _handler : FLASH } , Vector { _handler : RCC_CRS } , Vector { _handler : EXTI0_1 } , Vector { _handler : EXTI2_3 } , Vector { _handler : EXTI4_15 } , Vector { _handler : TSC } , Vector { _handler : DMA1_CH1 } , Vector { _handler : DMA1_CH2_3_DMA2_CH1_2 } , Vector { _handler : DMA1_CH4_7_DMA2_CH3_5 } , Vector { _handler : ADC1_COMP } , Vector { _handler : TIM1_BRK_UP_TRG_COM } , Vector { _handler : TIM1_CC } , Vector { _handler : TIM2 } , Vector { _handler : TIM3 } , Vector { _handler : TIM6_DAC } , Vector { _handler : TIM7 } , Vector { _handler : TIM14 } , Vector { _handler : TIM15 } , Vector { _handler : TIM16 } , Vector { _handler : TIM17 } , Vector { _handler : I2C1 } , Vector { _handler : I2C2 } , Vector { _handler : SPI1 } , Vector { _handler : SPI2 } , Vector { _handler : USART1 } , Vector { _handler : USART2 } , Vector { _handler : USART3_8 } , Vector { _handler : CEC_CAN } ,]
; } pub const ADC : * mut () = 0x4001_2708 as u32 as _ ; pub const ADC_COMMON : * mut () = 0x4001_2708 as u32 as _ ; pub const CAN : can :: Can = can :: Can (0x4000_6400 as u32 as _) ; pub const CEC : * mut () = 0x4000_7800 as u32 as _ ; pub const COMP1 : * mut () = 0x4001_001c as u32 as _ ; pub const COMP2 : * mut () = 0x4001_001e as u32 as _ ; pub const CRC : crc :: Crc = crc :: Crc (0x4002_3000 as u32 as _) ; pub const CRS : * mut () = 0x4000_6c00 as u32 as _ ; pub const DAC : * mut () = 0x4000_7400 as u32 as _ ; pub const DBGMCU : dbgmcu :: Dbgmcu = dbgmcu :: Dbgmcu (0x4001_5800 as u32 as _) ; pub const DMA1 : bdma :: Dma = bdma :: Dma (0x4002_0000 as u32 as _) ; pub const DMA2 : bdma :: Dma = bdma :: Dma (0x4002_0400 as u32 as _) ; pub const EXTI : exti :: Exti = exti :: Exti (0x4001_0400 as u32 as _) ; pub const FLASH : flash :: Flash = flash :: Flash (0x4002_2000 as u32 as _) ; pub const GPIOA : gpio :: Gpio = gpio :: Gpio (0x4800_0000 as u32 as _) ; pub const GPIOB : gpio :: Gpio = gpio :: Gpio (0x4800_0400 as u32 as _) ; pub const GPIOC : gpio :: Gpio = gpio :: Gpio (0x4800_0800 as u32 as _) ; pub const GPIOD : gpio :: Gpio = gpio :: Gpio (0x4800_0c00 as u32 as _) ; pub const GPIOE : gpio :: Gpio = gpio :: Gpio (0x4800_1000 as u32 as _) ; pub const GPIOF : gpio :: Gpio = gpio :: Gpio (0x4800_1400 as u32 as _) ; pub const I2C1 : i2c :: I2c = i2c :: I2c (0x4000_5400 as u32 as _) ; pub const I2C2 : * mut () = 0x4000_5800 as u32 as _ ; pub const IWDG : iwdg :: Iwdg = iwdg :: Iwdg (0x4000_3000 as u32 as _) ; pub const PWR : * mut () = 0x4000_7000 as u32 as _ ; pub const RCC : rcc :: Rcc = rcc :: Rcc (0x4002_1000 as u32 as _) ; pub const RTC : * mut () = 0x4000_2800 as u32 as _ ; pub const SPI1 : * mut () = 0x4001_3000 as u32 as _ ; pub const SPI2 : * mut () = 0x4000_3800 as u32 as _ ; pub const SYSCFG : syscfg :: Syscfg = syscfg :: Syscfg (0x4001_0000 as u32 as _) ; pub const TIM1 : timer :: TimGp16 = timer :: TimGp16 (0x4001_2c00 as u32 as _) ; pub const TIM14 : timer :: TimGp16 = timer :: TimGp16 (0x4000_2000 as u32 as _) ; pub const TIM15 : timer :: TimGp16 = timer :: TimGp16 (0x4001_4000 as u32 as _) ; pub const TIM16 : timer :: TimGp16 = timer :: TimGp16 (0x4001_4400 as u32 as _) ; pub const TIM17 : timer :: TimGp16 = timer :: TimGp16 (0x4001_4800 as u32 as _) ; pub const TIM2 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0000 as u32 as _) ; pub const TIM3 : timer :: TimGp16 = timer :: TimGp16 (0x4000_0400 as u32 as _) ; pub const TIM6 : timer :: TimGp16 = timer :: TimGp16 (0x4000_1000 as u32 as _) ; pub const TIM7 : timer :: TimGp16 = timer :: TimGp16 (0x4000_1400 as u32 as _) ; pub const TSC : * mut () = 0x4002_4000 as u32 as _ ; pub const USART1 : usart :: Usart = usart :: Usart (0x4001_3800 as u32 as _) ; pub const USART2 : usart :: Usart = usart :: Usart (0x4000_4400 as u32 as _) ; pub const USART3 : usart :: Usart = usart :: Usart (0x4000_4800 as u32 as _) ; pub const USART4 : usart :: Usart = usart :: Usart (0x4000_4c00 as u32 as _) ; pub const USART5 : usart :: Usart = usart :: Usart (0x4000_5000 as u32 as _) ; pub const USART6 : usart :: Usart = usart :: Usart (0x4001_1400 as u32 as _) ; pub const USART7 : usart :: Usart = usart :: Usart (0x4001_1800 as u32 as _) ; pub const USART8 : usart :: Usart = usart :: Usart (0x4001_1c00 as u32 as _) ; pub const WWDG : wwdg :: Wwdg = wwdg :: Wwdg (0x4000_2c00 as u32 as _) ;pub fn GPIO(n: usize) -> gpio::Gpio {
            gpio::Gpio((1207959552 + 1024*n) as _)
        }#[path="../../peripherals/bdma_v2.rs"] pub mod bdma;
#[path="../../peripherals/can_bxcan.rs"] pub mod can;
#[path="../../peripherals/crc_v2.rs"] pub mod crc;
#[path="../../peripherals/dbgmcu_f0.rs"] pub mod dbgmcu;
#[path="../../peripherals/exti_v1.rs"] pub mod exti;
#[path="../../peripherals/flash_f0.rs"] pub mod flash;
#[path="../../peripherals/gpio_v2.rs"] pub mod gpio;
#[path="../../peripherals/i2c_v2.rs"] pub mod i2c;
#[path="../../peripherals/iwdg_v2.rs"] pub mod iwdg;
#[path="../../peripherals/rcc_f0.rs"] pub mod rcc;
#[path="../../peripherals/syscfg_f0.rs"] pub mod syscfg;
#[path="../../peripherals/timer_v1.rs"] pub mod timer;
#[path="../../peripherals/usart_v2.rs"] pub mod usart;
#[path="../../peripherals/wwdg_v1.rs"] pub mod wwdg;
pub const CORE_INDEX: usize = 0;
