// Generated by rust.ts; do not edit

#![allow(clippy::large_enum_variant)]

use crate::{impl_enum, impl_struct};
use crate::prelude::*;

/*********************************************************************
 * Structs for "interface" schemas
 ********************************************************************/


/// The most simple compound (ie. non-atomic like `number`, `string` etc) type.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Entity {
    /// The name of this type
    #[def = "Entity_::Entity"]
    pub type_: Entity_,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Entity_ {
  Entity
}

impl_struct!(Entity);

/// A reference to a CreativeWork that is cited in another CreativeWork.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Cite {
    /// The name of this type
    #[def = "Cite_::Cite"]
    pub type_: Cite_,

    /// The target of the citation (URL or reference ID).
    pub target: String,

    /// The type/s of the citation, both factually and rhetorically.
    pub citation_intent: Option<Vec<CitationIntentEnumeration>>,

    /// Determines how the citation is shown within the surrounding text.
    pub citation_mode: Option<CiteCitationMode>,

    /// Text to show before the citation.
    pub citation_prefix: Option<Box<String>>,

    /// Text to show after the citation.
    pub citation_suffix: Option<Box<String>>,

    /// Optional structured content/text of this citation.
    pub content: Option<Vec<InlineContent>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// The page on which the work ends; for example "138" or "xvi".
    pub page_end: Option<Box<CitePageEnd>>,

    /// The page on which the work starts; for example "135" or "xiii".
    pub page_start: Option<Box<CitePageStart>>,

    /// Any description of pages that is not separated into pageStart and pageEnd; for example, "1-6, 9, 55".
    pub pagination: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Cite_ {
  Cite
}

impl_struct!(Cite);

/// A group of Cite nodes.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct CiteGroup {
    /// The name of this type
    #[def = "CiteGroup_::CiteGroup"]
    pub type_: CiteGroup_,

    /// One or more `Cite`s to be referenced in the same surrounding text.
    pub items: Vec<Cite>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum CiteGroup_ {
  CiteGroup
}

impl_struct!(CiteGroup);

/// Base type for code nodes e.g. CodeBlock, CodeExpression.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Code {
    /// The name of this type
    #[def = "Code_::Code"]
    pub type_: Code_,

    /// The text of the code.
    pub text: String,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Media type, typically expressed using a MIME format, of the code.
    pub media_type: Option<Box<String>>,

    /// The programming language of the code.
    pub programming_language: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Code_ {
  Code
}

impl_struct!(Code);

/// A code block.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct CodeBlock {
    /// The name of this type
    #[def = "CodeBlock_::CodeBlock"]
    pub type_: CodeBlock_,

    /// The text of the code.
    pub text: String,

    /// A compilation directive giving the name of the variable to export into the content of the code block.
    pub export_from: Option<Box<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// A compilation directive giving the name of the variable to import the content of the code block as.
    pub import_to: Option<Box<String>>,

    /// Media type, typically expressed using a MIME format, of the code.
    pub media_type: Option<Box<String>>,

    /// The programming language of the code.
    pub programming_language: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum CodeBlock_ {
  CodeBlock
}

impl_struct!(CodeBlock);

/// A executable chunk of code.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct CodeChunk {
    /// The name of this type
    #[def = "CodeChunk_::CodeChunk"]
    pub type_: CodeChunk_,

    /// The text of the code.
    pub text: String,

    /// Names of variables that the code chunk alters.
    pub alters: Option<Vec<String>>,

    /// Variables that the code chunk assigns to.
    pub assigns: Option<Vec<CodeChunkAssigns>>,

    /// A caption for the CodeChunk.
    pub caption: Option<Box<CodeChunkCaption>>,

    /// Variables that the code chunk declares.
    pub declares: Option<Vec<CodeChunkDeclares>>,

    /// Duration in seconds of the last execution of the chunk.
    pub duration: Option<Number>,

    /// Errors when compiling or executing the chunk.
    pub errors: Option<Vec<CodeError>>,

    /// A compilation directive giving the name of the variable to export into the content of the code block.
    pub export_from: Option<Box<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// A compilation directive giving the name of the variable to import the content of the code block as.
    pub import_to: Option<Box<String>>,

    /// Software packages that the code chunk imports
    pub imports: Option<Vec<CodeChunkImports>>,

    /// A short label for the CodeChunk.
    pub label: Option<Box<String>>,

    /// Media type, typically expressed using a MIME format, of the code.
    pub media_type: Option<Box<String>>,

    /// Outputs from executing the chunk.
    pub outputs: Option<Vec<Node>>,

    /// The programming language of the code.
    pub programming_language: Option<Box<String>>,

    /// Filesystem paths that this code chunk reads from.
    pub reads: Option<Vec<String>>,

    /// Names of variables that the code chunk uses (but does not alter).
    pub uses: Option<Vec<CodeChunkUses>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum CodeChunk_ {
  CodeChunk
}

impl_struct!(CodeChunk);

/// Inline code.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct CodeFragment {
    /// The name of this type
    #[def = "CodeFragment_::CodeFragment"]
    pub type_: CodeFragment_,

    /// The text of the code.
    pub text: String,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Media type, typically expressed using a MIME format, of the code.
    pub media_type: Option<Box<String>>,

    /// The programming language of the code.
    pub programming_language: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum CodeFragment_ {
  CodeFragment
}

impl_struct!(CodeFragment);

/// An expression defined in programming language source code.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct CodeExpression {
    /// The name of this type
    #[def = "CodeExpression_::CodeExpression"]
    pub type_: CodeExpression_,

    /// The text of the code.
    pub text: String,

    /// Errors when compiling or executing the chunk.
    pub errors: Option<Vec<CodeError>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Media type, typically expressed using a MIME format, of the code.
    pub media_type: Option<Box<String>>,

    /// The value of the expression when it was last evaluated.
    #[serde(skip)]
    pub output: Option<Box<Node>>,

    /// The programming language of the code.
    pub programming_language: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum CodeExpression_ {
  CodeExpression
}

impl_struct!(CodeExpression);

/// An error that occurred when parsing, compiling or executing a Code node.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct CodeError {
    /// The name of this type
    #[def = "CodeError_::CodeError"]
    pub type_: CodeError_,

    /// The error message or brief description of the error.
    pub error_message: String,

    /// The type of error e.g. "SyntaxError", "ZeroDivisionError".
    pub error_type: Option<Box<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Stack trace leading up to the error.
    pub stack_trace: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum CodeError_ {
  CodeError
}

impl_struct!(CodeError);

/// A date encoded as a ISO 8601 string.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Date {
    /// The name of this type
    #[def = "Date_::Date"]
    pub type_: Date_,

    /// The date as an ISO 8601 string.
    #[def = "chrono::Utc::now().to_rfc3339()"]
    pub value: String,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Date_ {
  Date
}

impl_struct!(Date);

/// A base class for nodes that mark some other inline content in some way (e.g. as being emphasised, or quoted).
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Mark {
    /// The name of this type
    #[def = "Mark_::Mark"]
    pub type_: Mark_,

    /// The content that is marked.
    pub content: Vec<InlineContent>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Mark_ {
  Mark
}

impl_struct!(Mark);

/// Content that is marked for deletion
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Delete {
    /// The name of this type
    #[def = "Delete_::Delete"]
    pub type_: Delete_,

    /// The content that is marked.
    pub content: Vec<InlineContent>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Delete_ {
  Delete
}

impl_struct!(Delete);

/// Emphasised content.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Emphasis {
    /// The name of this type
    #[def = "Emphasis_::Emphasis"]
    pub type_: Emphasis_,

    /// The content that is marked.
    pub content: Vec<InlineContent>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Emphasis_ {
  Emphasis
}

impl_struct!(Emphasis);

/// The most generic type of item.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Thing {
    /// The name of this type
    #[def = "Thing_::Thing"]
    pub type_: Thing_,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Thing_ {
  Thing
}

impl_struct!(Thing);

/// A brand used by an organization or person for labeling a product, product group, or similar.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Brand {
    /// The name of this type
    #[def = "Brand_::Brand"]
    pub type_: Brand_,

    /// The name of the item.
    pub name: String,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// A logo associated with the brand.
    pub logo: Option<Box<BrandLogo>>,

    /// Reviews of the brand.
    pub reviews: Option<Vec<String>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Brand_ {
  Brand
}

impl_struct!(Brand);

/// A contact point, usually within an organization.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct ContactPoint {
    /// The name of this type
    #[def = "ContactPoint_::ContactPoint"]
    pub type_: ContactPoint_,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// Languages (human not programming) in which it is possible to communicate with the organization/department etc.
    pub available_languages: Option<Vec<String>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// Email address for correspondence.
    pub emails: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Telephone numbers for the contact point.
    pub telephone_numbers: Option<Vec<String>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum ContactPoint_ {
  ContactPoint
}

impl_struct!(ContactPoint);

/// A creative work, including books, movies, photographs, software programs, etc.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct CreativeWork {
    /// The name of this type
    #[def = "CreativeWork_::CreativeWork"]
    pub type_: CreativeWork_,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum CreativeWork_ {
  CreativeWork
}

impl_struct!(CreativeWork);

/// An article, including news and scholarly articles.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Article {
    /// The name of this type
    #[def = "Article_::Article"]
    pub type_: Article_,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this article.
    pub content: Option<Vec<BlockContent>>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// The page on which the article ends; for example "138" or "xvi".
    pub page_end: Option<Box<ArticlePageEnd>>,

    /// The page on which the article starts; for example "135" or "xiii".
    pub page_start: Option<Box<ArticlePageStart>>,

    /// Any description of pages that is not separated into pageStart and pageEnd; for example, "1-6, 9, 55".
    pub pagination: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Article_ {
  Article
}

impl_struct!(Article);

/// A claim represents specific reviewable facts or statements.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Claim {
    /// The name of this type
    #[def = "Claim_::Claim"]
    pub type_: Claim_,

    /// Content of the claim, usually a single paragraph.
    pub content: Vec<BlockContent>,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// Kind of the claim.
    pub claim_type: Option<ClaimClaimType>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// A short label for the claim.
    pub label: Option<Box<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Claim_ {
  Claim
}

impl_struct!(Claim);
/// A claim represents specific reviewable facts or statements.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct ClaimSimple {
    /// The name of this type
    #[def = "ClaimSimple_::Claim"]
    pub type_: ClaimSimple_,

    /// Content of the claim, usually a single paragraph.
    pub content: Vec<BlockContent>,

    /// Kind of the claim.
    pub claim_type: Option<ClaimClaimType>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// A short label for the claim.
    pub label: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum ClaimSimple_ {
  Claim
}

impl_struct!(ClaimSimple);

/// A collection of CreativeWorks or other artifacts.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Collection {
    /// The name of this type
    #[def = "Collection_::Collection"]
    pub type_: Collection_,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Vec<CreativeWorkTypes>,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Collection_ {
  Collection
}

impl_struct!(Collection);
/// A collection of CreativeWorks or other artifacts.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct CollectionSimple {
    /// The name of this type
    #[def = "CollectionSimple_::Collection"]
    pub type_: CollectionSimple_,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Vec<CreativeWorkTypes>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum CollectionSimple_ {
  Collection
}

impl_struct!(CollectionSimple);

/// A comment on an item, e.g on a Article, or SoftwareSourceCode.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Comment {
    /// The name of this type
    #[def = "Comment_::Comment"]
    pub type_: Comment_,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// The part or facet of the item that is being commented on.
    pub comment_aspect: Option<Box<String>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// The parent comment of this comment.
    #[serde(skip)]
    pub parent_item: Option<Box<Comment>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Comment_ {
  Comment
}

impl_struct!(Comment);

/// A table of data.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Datatable {
    /// The name of this type
    #[def = "Datatable_::Datatable"]
    pub type_: Datatable_,

    /// The columns of data.
    pub columns: Vec<DatatableColumn>,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Datatable_ {
  Datatable
}

impl_struct!(Datatable);

/// A media object, such as an image, video, or audio object embedded in a web page or a downloadable dataset.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct MediaObject {
    /// The name of this type
    #[def = "MediaObject_::MediaObject"]
    pub type_: MediaObject_,

    /// URL for the actual bytes of the media object, for example the image file or video file.
    pub content_url: String,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// Bitrate in megabits per second (Mbit/s, Mb/s, Mbps).
    pub bitrate: Option<Number>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// File size in megabits (Mbit, Mb).
    pub content_size: Option<Number>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// URL that can be used to embed the media on a web page via a specific media player.
    pub embed_url: Option<Box<String>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// IANA media type (MIME type).
    pub media_type: Option<Box<String>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum MediaObject_ {
  MediaObject
}

impl_struct!(MediaObject);

/// An audio file
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct AudioObject {
    /// The name of this type
    #[def = "AudioObject_::AudioObject"]
    pub type_: AudioObject_,

    /// URL for the actual bytes of the media object, for example the image file or video file.
    pub content_url: String,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// Bitrate in megabits per second (Mbit/s, Mb/s, Mbps).
    pub bitrate: Option<Number>,

    /// The caption for this audio recording.
    pub caption: Option<Box<String>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// File size in megabits (Mbit, Mb).
    pub content_size: Option<Number>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// URL that can be used to embed the media on a web page via a specific media player.
    pub embed_url: Option<Box<String>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// IANA media type (MIME type).
    pub media_type: Option<Box<String>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The transcript of this audio recording.
    pub transcript: Option<Box<String>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum AudioObject_ {
  AudioObject
}

impl_struct!(AudioObject);
/// An audio file
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct AudioObjectSimple {
    /// The name of this type
    #[def = "AudioObjectSimple_::AudioObject"]
    pub type_: AudioObjectSimple_,

    /// URL for the actual bytes of the media object, for example the image file or video file.
    pub content_url: String,

    /// Bitrate in megabits per second (Mbit/s, Mb/s, Mbps).
    pub bitrate: Option<Number>,

    /// The caption for this audio recording.
    pub caption: Option<Box<String>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// File size in megabits (Mbit, Mb).
    pub content_size: Option<Number>,

    /// URL that can be used to embed the media on a web page via a specific media player.
    pub embed_url: Option<Box<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// IANA media type (MIME type).
    pub media_type: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// The transcript of this audio recording.
    pub transcript: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum AudioObjectSimple_ {
  AudioObject
}

impl_struct!(AudioObjectSimple);

/// A column of data within a Datatable.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct DatatableColumn {
    /// The name of this type
    #[def = "DatatableColumn_::DatatableColumn"]
    pub type_: DatatableColumn_,

    /// The name of the item.
    pub name: String,

    /// The data values of the column.
    pub values: Vec<Node>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The validator to use to validate data in the column.
    pub validator: Option<Box<ArrayValidator>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum DatatableColumn_ {
  DatatableColumn
}

impl_struct!(DatatableColumn);

/// A word, name, acronym, phrase, etc. with a formal definition.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct DefinedTerm {
    /// The name of this type
    #[def = "DefinedTerm_::DefinedTerm"]
    pub type_: DefinedTerm_,

    /// The name of the item.
    pub name: String,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// A code that identifies this DefinedTerm within a DefinedTermSet
    pub term_code: Option<Box<String>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum DefinedTerm_ {
  DefinedTerm
}

impl_struct!(DefinedTerm);

/// A base for all validator types.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Validator {
    /// The name of this type
    #[def = "Validator_::Validator"]
    pub type_: Validator_,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Validator_ {
  Validator
}

impl_struct!(Validator);

/// A validator specifying constraints on an array node.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct ArrayValidator {
    /// The name of this type
    #[def = "ArrayValidator_::ArrayValidator"]
    pub type_: ArrayValidator_,

    /// An array node is valid if at least one of its items is valid against the `contains` schema.
    #[serde(skip)]
    pub contains: Option<Box<ValidatorTypes>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Another validator node specifying the constraints on all items in the array.
    #[serde(skip)]
    pub items_validator: Option<Box<ValidatorTypes>>,

    /// An array node is valid if its size is less than, or equal to, this value.
    pub max_items: Option<Integer>,

    /// An array node is valid if its size is greater than, or equal to, this value.
    pub min_items: Option<Integer>,

    /// A flag to indicate that each value in the array should be unique.
    pub unique_items: Option<Boolean>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum ArrayValidator_ {
  ArrayValidator
}

impl_struct!(ArrayValidator);

/// A schema specifying that a node must be a boolean value.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct BooleanValidator {
    /// The name of this type
    #[def = "BooleanValidator_::BooleanValidator"]
    pub type_: BooleanValidator_,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum BooleanValidator_ {
  BooleanValidator
}

impl_struct!(BooleanValidator);

/// A validator specifying a constant value that a node must have.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct ConstantValidator {
    /// The name of this type
    #[def = "ConstantValidator_::ConstantValidator"]
    pub type_: ConstantValidator_,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// The value that the node must have.
    #[serde(skip)]
    pub value: Option<Box<Node>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum ConstantValidator_ {
  ConstantValidator
}

impl_struct!(ConstantValidator);

/// A schema specifying that a node must be one of several values.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct EnumValidator {
    /// The name of this type
    #[def = "EnumValidator_::EnumValidator"]
    pub type_: EnumValidator_,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// A node is valid if it is equal to any of these values.
    pub values: Option<Vec<Node>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum EnumValidator_ {
  EnumValidator
}

impl_struct!(EnumValidator);

/// Lists or enumerations, for example, a list of cuisines or music genres, etc.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Enumeration {
    /// The name of this type
    #[def = "Enumeration_::Enumeration"]
    pub type_: Enumeration_,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Enumeration_ {
  Enumeration
}

impl_struct!(Enumeration);

/// Encapsulates one or more images, videos, tables, etc, and provides captions and labels for them.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Figure {
    /// The name of this type
    #[def = "Figure_::Figure"]
    pub type_: Figure_,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// A caption for the figure.
    pub caption: Option<Box<FigureCaption>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// A short label for the figure.
    pub label: Option<Box<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Figure_ {
  Figure
}

impl_struct!(Figure);
/// Encapsulates one or more images, videos, tables, etc, and provides captions and labels for them.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct FigureSimple {
    /// The name of this type
    #[def = "FigureSimple_::Figure"]
    pub type_: FigureSimple_,

    /// A caption for the figure.
    pub caption: Option<Box<FigureCaption>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// A short label for the figure.
    pub label: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum FigureSimple_ {
  Figure
}

impl_struct!(FigureSimple);

/// A function with a name, which might take Parameters and return a value of a certain type.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Function {
    /// The name of this type
    #[def = "Function_::Function"]
    pub type_: Function_,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// The name of the function.
    pub name: Option<Box<String>>,

    /// The parameters of the function.
    pub parameters: Option<Vec<Parameter>>,

    /// The return type of the function.
    pub returns: Option<Box<ValidatorTypes>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Function_ {
  Function
}

impl_struct!(Function);

/// A grant, typically financial or otherwise quantifiable, of resources.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Grant {
    /// The name of this type
    #[def = "Grant_::Grant"]
    pub type_: Grant_,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// Indicates an item funded or sponsored through a Grant.
    pub funded_items: Option<Vec<Thing>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// A person or organization that supports a thing through a pledge, promise, or financial contribution.
    pub sponsors: Option<Vec<GrantSponsors>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Grant_ {
  Grant
}

impl_struct!(Grant);

/// A heading.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Heading {
    /// The name of this type
    #[def = "Heading_::Heading"]
    pub type_: Heading_,

    /// Content of the heading.
    pub content: Vec<InlineContent>,

    /// The depth of the heading.
    pub depth: Option<u8>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Heading_ {
  Heading
}

impl_struct!(Heading);

/// An image file.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct ImageObject {
    /// The name of this type
    #[def = "ImageObject_::ImageObject"]
    pub type_: ImageObject_,

    /// URL for the actual bytes of the media object, for example the image file or video file.
    pub content_url: String,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// Bitrate in megabits per second (Mbit/s, Mb/s, Mbps).
    pub bitrate: Option<Number>,

    /// The caption for this image.
    pub caption: Option<Box<String>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// File size in megabits (Mbit, Mb).
    pub content_size: Option<Number>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// URL that can be used to embed the media on a web page via a specific media player.
    pub embed_url: Option<Box<String>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// IANA media type (MIME type).
    pub media_type: Option<Box<String>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    #[serde(skip)]
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// Thumbnail image of this image.
    #[serde(skip)]
    pub thumbnail: Option<Box<ImageObject>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum ImageObject_ {
  ImageObject
}

impl_struct!(ImageObject);
/// An image file.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct ImageObjectSimple {
    /// The name of this type
    #[def = "ImageObjectSimple_::ImageObject"]
    pub type_: ImageObjectSimple_,

    /// URL for the actual bytes of the media object, for example the image file or video file.
    pub content_url: String,

    /// Bitrate in megabits per second (Mbit/s, Mb/s, Mbps).
    pub bitrate: Option<Number>,

    /// The caption for this image.
    pub caption: Option<Box<String>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// File size in megabits (Mbit, Mb).
    pub content_size: Option<Number>,

    /// URL that can be used to embed the media on a web page via a specific media player.
    pub embed_url: Option<Box<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// IANA media type (MIME type).
    pub media_type: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// Thumbnail image of this image.
    pub thumbnail: Option<Box<ImageObject>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum ImageObjectSimple_ {
  ImageObject
}

impl_struct!(ImageObjectSimple);

/// A directive to include content from an external source (e.g. file, URL) or content.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Include {
    /// The name of this type
    #[def = "Include_::Include"]
    pub type_: Include_,

    /// The source of the content, a URL or file path, or the content itself.
    pub source: String,

    /// The content to be included.
    pub content: Option<Vec<BlockContent>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Media type, typically expressed using a MIME format, of the source content.
    pub media_type: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Include_ {
  Include
}

impl_struct!(Include);

/// A validator specifying the constraints on an integer node.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct IntegerValidator {
    /// The name of this type
    #[def = "IntegerValidator_::IntegerValidator"]
    pub type_: IntegerValidator_,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum IntegerValidator_ {
  IntegerValidator
}

impl_struct!(IntegerValidator);

/// A hyperlink to other pages, sections within the same document, resources, or any URL.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Link {
    /// The name of this type
    #[def = "Link_::Link"]
    pub type_: Link_,

    /// The textual content of the link.
    pub content: Vec<InlineContent>,

    /// The target of the link.
    pub target: String,

    /// A compilation directive giving the name of the variable to export to the link target.
    pub export_from: Option<Box<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// A compilation directive giving the name of the variable to import the link target as.
    pub import_to: Option<Box<String>>,

    /// The relation between the target and the current thing.
    pub relation: Option<Box<String>>,

    /// A title for the link.
    pub title: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Link_ {
  Link
}

impl_struct!(Link);

/// A list of items.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct List {
    /// The name of this type
    #[def = "List_::List"]
    pub type_: List_,

    /// The items in the list
    pub items: Vec<ListItem>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Type of ordering.
    pub order: Option<ListOrder>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum List_ {
  List
}

impl_struct!(List);

/// A single item in a list.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct ListItem {
    /// The name of this type
    #[def = "ListItem_::ListItem"]
    pub type_: ListItem_,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The content of the list item.
    pub content: Option<ListItemContent>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// A flag to indicate if this list item is checked.
    pub is_checked: Option<Boolean>,

    /// The item represented by this list item.
    #[serde(skip)]
    pub item: Option<Box<Node>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// The position of the item in a series or sequence of items.
    pub position: Option<u32>,

    /// The URL of the item.
    pub url: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum ListItem_ {
  ListItem
}

impl_struct!(ListItem);

/// A mathematical variable or equation.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Math {
    /// The name of this type
    #[def = "Math_::Math"]
    pub type_: Math_,

    /// The text of the equation in the language.
    pub text: String,

    /// Errors that occurred when parsing the math equation.
    pub errors: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// The language used for the equation e.g tex, mathml, asciimath.
    pub math_language: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Math_ {
  Math
}

impl_struct!(Math);

/// A block of math, e.g an equation, to be treated as block content.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct MathBlock {
    /// The name of this type
    #[def = "MathBlock_::MathBlock"]
    pub type_: MathBlock_,

    /// The text of the equation in the language.
    pub text: String,

    /// Errors that occurred when parsing the math equation.
    pub errors: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// A short label for the math block.
    pub label: Option<Box<String>>,

    /// The language used for the equation e.g tex, mathml, asciimath.
    pub math_language: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum MathBlock_ {
  MathBlock
}

impl_struct!(MathBlock);

/// A fragment of math, e.g a variable name, to be treated as inline content.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct MathFragment {
    /// The name of this type
    #[def = "MathFragment_::MathFragment"]
    pub type_: MathFragment_,

    /// The text of the equation in the language.
    pub text: String,

    /// Errors that occurred when parsing the math equation.
    pub errors: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// The language used for the equation e.g tex, mathml, asciimath.
    pub math_language: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum MathFragment_ {
  MathFragment
}

impl_struct!(MathFragment);

/// A monetary grant.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct MonetaryGrant {
    /// The name of this type
    #[def = "MonetaryGrant_::MonetaryGrant"]
    pub type_: MonetaryGrant_,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The amount of money.
    pub amounts: Option<Number>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// Indicates an item funded or sponsored through a Grant.
    pub funded_items: Option<Vec<Thing>>,

    /// A person or organization that supports (sponsors) something through some kind of financial contribution.
    pub funders: Option<Vec<MonetaryGrantFunders>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// A person or organization that supports a thing through a pledge, promise, or financial contribution.
    pub sponsors: Option<Vec<GrantSponsors>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum MonetaryGrant_ {
  MonetaryGrant
}

impl_struct!(MonetaryGrant);

/// Inline text that has a non-textual annotation.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct NontextualAnnotation {
    /// The name of this type
    #[def = "NontextualAnnotation_::NontextualAnnotation"]
    pub type_: NontextualAnnotation_,

    /// The content that is marked.
    pub content: Vec<InlineContent>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum NontextualAnnotation_ {
  NontextualAnnotation
}

impl_struct!(NontextualAnnotation);

/// Additional content which is not part of the main content of a document.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Note {
    /// The name of this type
    #[def = "Note_::Note"]
    pub type_: Note_,

    /// Content of the note, usually a paragraph.
    pub content: Vec<BlockContent>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Determines where the note content is displayed within the document.
    pub note_type: Option<NoteNoteType>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Note_ {
  Note
}

impl_struct!(Note);

/// A validator specifying the constraints on a numeric node.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct NumberValidator {
    /// The name of this type
    #[def = "NumberValidator_::NumberValidator"]
    pub type_: NumberValidator_,

    /// The exclusive upper limit for a numeric node.
    pub exclusive_maximum: Option<Number>,

    /// The exclusive lower limit for a numeric node.
    pub exclusive_minimum: Option<Number>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// The inclusive upper limit for a numeric node.
    pub maximum: Option<Number>,

    /// The inclusive lower limit for a numeric node.
    pub minimum: Option<Number>,

    /// A number that a numeric node must be a multiple of.
    pub multiple_of: Option<Number>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum NumberValidator_ {
  NumberValidator
}

impl_struct!(NumberValidator);

/// An organization such as a school, NGO, corporation, club, etc.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Organization {
    /// The name of this type
    #[def = "Organization_::Organization"]
    pub type_: Organization_,

    /// Postal address for the organization.
    pub address: Option<Box<OrganizationAddress>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// Brands that the organization is connected with.
    pub brands: Option<Vec<Brand>>,

    /// Correspondence/Contact points for the organization.
    pub contact_points: Option<Vec<ContactPoint>>,

    /// Departments within the organization. For example, Department of Computer Science, Research & Development etc.
    pub departments: Option<Vec<Organization>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// Organization(s) or person(s) funding the organization.
    pub funders: Option<Vec<OrganizationFunders>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// Legal name for the Organization. Should only include letters and spaces.
    pub legal_name: Option<Box<String>>,

    /// The logo of the organization.
    pub logo: Option<Box<OrganizationLogo>>,

    /// Person(s) or organization(s) who are members of this organization.
    pub members: Option<Vec<OrganizationMembers>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Entity that the Organization is a part of. For example, parentOrganization to a department is a university.
    #[serde(skip)]
    pub parent_organization: Option<Box<Organization>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Organization_ {
  Organization
}

impl_struct!(Organization);

/// Paragraph
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Paragraph {
    /// The name of this type
    #[def = "Paragraph_::Paragraph"]
    pub type_: Paragraph_,

    /// The contents of the paragraph.
    pub content: Vec<InlineContent>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Paragraph_ {
  Paragraph
}

impl_struct!(Paragraph);

/// A variable representing a name / value pair.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Variable {
    /// The name of this type
    #[def = "Variable_::Variable"]
    pub type_: Variable_,

    /// The name of the variable.
    pub name: String,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Whether or not a property is mutable. Default is false.
    pub is_readonly: Option<Boolean>,

    /// The validator that the value is validated against.
    pub validator: Option<Box<ValidatorTypes>>,

    /// The value of the variable.
    #[serde(skip)]
    pub value: Option<Box<Node>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Variable_ {
  Variable
}

impl_struct!(Variable);

/// A parameter that can be set and used in evaluated code.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Parameter {
    /// The name of this type
    #[def = "Parameter_::Parameter"]
    pub type_: Parameter_,

    /// The name of the variable.
    pub name: String,

    /// The default value of the parameter.
    #[serde(skip)]
    pub default: Option<Box<Node>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Indicates that this parameter is variadic and can accept multiple named arguments.
    pub is_extensible: Option<Boolean>,

    /// Whether or not a property is mutable. Default is false.
    pub is_readonly: Option<Boolean>,

    /// Is this parameter required, if not it should have a default or default is assumed to be null.
    pub is_required: Option<Boolean>,

    /// Indicates that this parameter is variadic and can accept multiple arguments.
    pub is_variadic: Option<Boolean>,

    /// The validator that the value is validated against.
    pub validator: Option<Box<ValidatorTypes>>,

    /// The value of the variable.
    #[serde(skip)]
    pub value: Option<Box<Node>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Parameter_ {
  Parameter
}

impl_struct!(Parameter);

/// A periodical publication.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Periodical {
    /// The name of this type
    #[def = "Periodical_::Periodical"]
    pub type_: Periodical_,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// The date this Periodical ceased publication.
    pub date_end: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// The date this Periodical was first published.
    pub date_start: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// The International Standard Serial Number(s) (ISSN) that identifies this serial publication.
    pub issns: Option<Vec<String>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Periodical_ {
  Periodical
}

impl_struct!(Periodical);

/// A person (alive, dead, undead, or fictional).
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Person {
    /// The name of this type
    #[def = "Person_::Person"]
    pub type_: Person_,

    /// Postal address for the person.
    pub address: Option<Box<PersonAddress>>,

    /// Organizations that the person is affiliated with.
    pub affiliations: Option<Vec<Organization>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// Email addresses for the person.
    pub emails: Option<Vec<String>>,

    /// Family name. In the U.S., the last name of a person.
    pub family_names: Option<Vec<String>>,

    /// A person or organization that supports (sponsors) something through some kind of financial contribution.
    pub funders: Option<Vec<PersonFunders>>,

    /// Given name. In the U.S., the first name of a person.
    pub given_names: Option<Vec<String>>,

    /// An honorific prefix preceding a person's name such as Dr/Mrs/Mr.
    pub honorific_prefix: Option<Box<String>>,

    /// An honorific suffix after a person's name such as MD/PhD/MSCSW.
    pub honorific_suffix: Option<Box<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// The job title of the person (for example, Financial Manager).
    pub job_title: Option<Box<String>>,

    /// An organization (or program membership) to which this person belongs.
    pub member_of: Option<Vec<Organization>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Telephone numbers for the person.
    pub telephone_numbers: Option<Vec<String>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Person_ {
  Person
}

impl_struct!(Person);

/// A physical mailing address.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct PostalAddress {
    /// The name of this type
    #[def = "PostalAddress_::PostalAddress"]
    pub type_: PostalAddress_,

    /// The country.
    pub address_country: Option<Box<String>>,

    /// The locality in which the street address is, and which is in the region.
    pub address_locality: Option<Box<String>>,

    /// The region in which the locality is, and which is in the country.
    pub address_region: Option<Box<String>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// Languages (human not programming) in which it is possible to communicate with the organization/department etc.
    pub available_languages: Option<Vec<String>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// Email address for correspondence.
    pub emails: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// The post office box number.
    pub post_office_box_number: Option<Box<String>>,

    /// The postal code.
    pub postal_code: Option<Box<String>>,

    /// The street address.
    pub street_address: Option<Box<String>>,

    /// Telephone numbers for the contact point.
    pub telephone_numbers: Option<Vec<String>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum PostalAddress_ {
  PostalAddress
}

impl_struct!(PostalAddress);

/// Any offered product or service. For example, a pair of shoes; a haircut; or an episode of a TV show streamed online.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Product {
    /// The name of this type
    #[def = "Product_::Product"]
    pub type_: Product_,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// Brands that the product is labelled with.
    pub brands: Option<Vec<Brand>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// The logo of the product.
    pub logo: Option<Box<ProductLogo>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Product identification code.
    pub product_id: Option<Box<String>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Product_ {
  Product
}

impl_struct!(Product);

/// A property-value pair.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct PropertyValue {
    /// The name of this type
    #[def = "PropertyValue_::PropertyValue"]
    pub type_: PropertyValue_,

    /// The value of the property.
    #[def = "PropertyValueValue::String(String::new())"]
    pub value: PropertyValueValue,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// A commonly used identifier for the characteristic represented by the property.
    pub property_id: Option<Box<String>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum PropertyValue_ {
  PropertyValue
}

impl_struct!(PropertyValue);

/// A part of a successively published publication such as a periodical or publication volume, often numbered.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct PublicationIssue {
    /// The name of this type
    #[def = "PublicationIssue_::PublicationIssue"]
    pub type_: PublicationIssue_,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Identifies the issue of publication; for example, "iii" or "2".
    pub issue_number: Option<Box<PublicationIssueIssueNumber>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// The page on which the issue ends; for example "138" or "xvi".
    pub page_end: Option<Box<PublicationIssuePageEnd>>,

    /// The page on which the issue starts; for example "135" or "xiii".
    pub page_start: Option<Box<PublicationIssuePageStart>>,

    /// Any description of pages that is not separated into pageStart and pageEnd; for example, "1-6, 9, 55".
    pub pagination: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum PublicationIssue_ {
  PublicationIssue
}

impl_struct!(PublicationIssue);

/// A part of a successively published publication such as a periodical or multi-volume work.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct PublicationVolume {
    /// The name of this type
    #[def = "PublicationVolume_::PublicationVolume"]
    pub type_: PublicationVolume_,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// The page on which the volume ends; for example "138" or "xvi".
    pub page_end: Option<Box<PublicationVolumePageEnd>>,

    /// The page on which the volume starts; for example "135" or "xiii".
    pub page_start: Option<Box<PublicationVolumePageStart>>,

    /// Any description of pages that is not separated into pageStart and pageEnd; for example, "1-6, 9, 55".
    pub pagination: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,

    /// Identifies the volume of publication or multi-part work; for example, "iii" or "2".
    pub volume_number: Option<Box<PublicationVolumeVolumeNumber>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum PublicationVolume_ {
  PublicationVolume
}

impl_struct!(PublicationVolume);

/// Inline, quoted content.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Quote {
    /// The name of this type
    #[def = "Quote_::Quote"]
    pub type_: Quote_,

    /// The content that is marked.
    pub content: Vec<InlineContent>,

    /// The source of the quote.
    pub cite: Option<Box<QuoteCite>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Quote_ {
  Quote
}

impl_struct!(Quote);

/// A section quoted from somewhere else.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct QuoteBlock {
    /// The name of this type
    #[def = "QuoteBlock_::QuoteBlock"]
    pub type_: QuoteBlock_,

    /// The content of the quote.
    pub content: Vec<BlockContent>,

    /// The source of the quote.
    pub cite: Option<Box<QuoteBlockCite>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum QuoteBlock_ {
  QuoteBlock
}

impl_struct!(QuoteBlock);

/// A review of an item, e.g of an Article, or SoftwareSourceCode.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Review {
    /// The name of this type
    #[def = "Review_::Review"]
    pub type_: Review_,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// The item that is being reviewed.
    pub item_reviewed: Option<Box<Thing>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The part or facet of the item that is being reviewed.
    pub review_aspect: Option<Box<String>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Review_ {
  Review
}

impl_struct!(Review);

/// A software application.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct SoftwareApplication {
    /// The name of this type
    #[def = "SoftwareApplication_::SoftwareApplication"]
    pub type_: SoftwareApplication_,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// Requirements for application, including shared libraries that are not included in the application distribution.
    pub software_requirements: Option<Vec<SoftwareApplication>>,

    /// Version of the software.
    pub software_version: Option<Box<String>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum SoftwareApplication_ {
  SoftwareApplication
}

impl_struct!(SoftwareApplication);

/// A computational environment.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct SoftwareEnvironment {
    /// The name of this type
    #[def = "SoftwareEnvironment_::SoftwareEnvironment"]
    pub type_: SoftwareEnvironment_,

    /// The name of the item.
    pub name: String,

    /// The packages that this environment adds to the base environments listed under `extends` (if any).,
    pub adds: Option<Vec<SoftwareSourceCode>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// Other environments that this environment extends by adding or removing packages.,
    pub extends: Option<Vec<SoftwareEnvironment>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// The packages that this environment removes from the base environments listed under `extends` (if any).,
    pub removes: Option<Vec<SoftwareSourceCode>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum SoftwareEnvironment_ {
  SoftwareEnvironment
}

impl_struct!(SoftwareEnvironment);

/// Definition of a compute session, including its software and compute resource requirements and status.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct SoftwareSession {
    /// The name of this type
    #[def = "SoftwareSession_::SoftwareSession"]
    pub type_: SoftwareSession_,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The maximum number of concurrent clients the session is limited to.
    pub clients_limit: Option<Number>,

    /// The maximum number of concurrent clients requested for the session.
    pub clients_request: Option<Number>,

    /// The amount of CPU the session is limited to.
    pub cpu_limit: Option<Number>,

    /// The amount of CPU requested for the session.
    pub cpu_request: Option<Number>,

    /// The date-time that the session ended.
    pub date_end: Option<Box<Date>>,

    /// The date-time that the session began.
    pub date_start: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// The maximum duration (seconds) the session is limited to.
    pub duration_limit: Option<Number>,

    /// The maximum duration (seconds) requested for the session.
    pub duration_request: Option<Number>,

    /// The software environment to execute this session in.
    pub environment: Option<Box<SoftwareEnvironment>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// The amount of memory that the session is limited to.
    pub memory_limit: Option<Number>,

    /// The amount of memory requested for the session.
    pub memory_request: Option<Number>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// The amount of network data transfer (GiB) that the session is limited to.
    pub network_transfer_limit: Option<Number>,

    /// The amount of network data transfer (GiB) requested for the session.
    pub network_transfer_request: Option<Number>,

    /// The status of the session (starting, stopped, etc).
    pub status: Option<SoftwareSessionStatus>,

    /// The inactivity timeout (seconds) the session is limited to.
    pub timeout_limit: Option<Number>,

    /// The inactivity timeout (seconds) requested for the session.
    pub timeout_request: Option<Number>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// Volumes to mount in the session.
    pub volume_mounts: Option<Vec<VolumeMount>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum SoftwareSession_ {
  SoftwareSession
}

impl_struct!(SoftwareSession);

/// Computer programming source code. Example: Full (compile ready) solutions, code snippet samples, scripts, templates.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct SoftwareSourceCode {
    /// The name of this type
    #[def = "SoftwareSourceCode_::SoftwareSourceCode"]
    pub type_: SoftwareSourceCode_,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// Link to the repository where the un-compiled, human readable code and related code is located.
    pub code_repository: Option<Box<String>>,

    /// What type of code sample: full (compile ready) solution, code snippet, inline code, scripts, template.
    pub code_sample_type: Option<Box<String>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// The computer programming language.
    pub programming_language: Option<Box<String>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// Runtime platform or script interpreter dependencies (Example - Java v1, Python2.3, .Net Framework 3.0).
    pub runtime_platform: Option<Vec<String>>,

    /// Dependency requirements for the software.
    pub software_requirements: Option<Vec<SoftwareSourceCodeSoftwareRequirements>>,

    /// Target operating system or product to which the code applies.
    pub target_products: Option<Vec<SoftwareApplication>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum SoftwareSourceCode_ {
  SoftwareSourceCode
}

impl_struct!(SoftwareSourceCode);

/// A schema specifying constraints on a string node.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct StringValidator {
    /// The name of this type
    #[def = "StringValidator_::StringValidator"]
    pub type_: StringValidator_,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// The maximum length for a string node.
    pub max_length: Option<Integer>,

    /// The minimum length for a string node.
    pub min_length: Option<Integer>,

    /// A regular expression that a string node must match.
    pub pattern: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum StringValidator_ {
  StringValidator
}

impl_struct!(StringValidator);

/// Strongly emphasised content.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Strong {
    /// The name of this type
    #[def = "Strong_::Strong"]
    pub type_: Strong_,

    /// The content that is marked.
    pub content: Vec<InlineContent>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Strong_ {
  Strong
}

impl_struct!(Strong);

/// Subscripted content.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Subscript {
    /// The name of this type
    #[def = "Subscript_::Subscript"]
    pub type_: Subscript_,

    /// The content that is marked.
    pub content: Vec<InlineContent>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Subscript_ {
  Subscript
}

impl_struct!(Subscript);

/// Superscripted content.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Superscript {
    /// The name of this type
    #[def = "Superscript_::Superscript"]
    pub type_: Superscript_,

    /// The content that is marked.
    pub content: Vec<InlineContent>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Superscript_ {
  Superscript
}

impl_struct!(Superscript);

/// A table.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct Table {
    /// The name of this type
    #[def = "Table_::Table"]
    pub type_: Table_,

    /// Rows of cells in the table.
    pub rows: Vec<TableRow>,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// A caption for the table.
    pub caption: Option<Box<TableCaption>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// A short label for the table.
    pub label: Option<Box<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Table_ {
  Table
}

impl_struct!(Table);
/// A table.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct TableSimple {
    /// The name of this type
    #[def = "TableSimple_::Table"]
    pub type_: TableSimple_,

    /// Rows of cells in the table.
    pub rows: Vec<TableRow>,

    /// A caption for the table.
    pub caption: Option<Box<TableCaption>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// A short label for the table.
    pub label: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum TableSimple_ {
  Table
}

impl_struct!(TableSimple);

/// A cell within a `Table`.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct TableCell {
    /// The name of this type
    #[def = "TableCell_::TableCell"]
    pub type_: TableCell_,

    /// Indicates whether the cell is a header or data.
    pub cell_type: Option<TableCellCellType>,

    /// How many columns the cell extends.
    pub colspan: Option<u32>,

    /// Contents of the table cell.
    pub content: Option<TableCellContent>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// The name of the cell.
    pub name: Option<Box<String>>,

    /// How many columns the cell extends.
    pub rowspan: Option<u32>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum TableCell_ {
  TableCell
}

impl_struct!(TableCell);

/// A row within a Table.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct TableRow {
    /// The name of this type
    #[def = "TableRow_::TableRow"]
    pub type_: TableRow_,

    /// An array of cells in the row.
    pub cells: Vec<TableCell>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// If present, indicates that all cells in this row should be treated as header cells.
    pub row_type: Option<TableRowRowType>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum TableRow_ {
  TableRow
}

impl_struct!(TableRow);

/// A thematic break, such as a scene change in a story, a transition to another topic, or a new document.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct ThematicBreak {
    /// The name of this type
    #[def = "ThematicBreak_::ThematicBreak"]
    pub type_: ThematicBreak_,

    /// The identifier for this item.
    pub id: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum ThematicBreak_ {
  ThematicBreak
}

impl_struct!(ThematicBreak);

/// A validator specifying constraints on an array of heterogeneous items.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct TupleValidator {
    /// The name of this type
    #[def = "TupleValidator_::TupleValidator"]
    pub type_: TupleValidator_,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// An array of validators specifying the constraints on each successive item in the array.
    pub items: Option<Vec<ValidatorTypes>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum TupleValidator_ {
  TupleValidator
}

impl_struct!(TupleValidator);

/// A video file.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct VideoObject {
    /// The name of this type
    #[def = "VideoObject_::VideoObject"]
    pub type_: VideoObject_,

    /// URL for the actual bytes of the media object, for example the image file or video file.
    pub content_url: String,

    /// The subject matter of the content.
    pub about: Option<Vec<ThingTypes>>,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// The authors of this creative work.
    pub authors: Option<Vec<CreativeWorkAuthors>>,

    /// Bitrate in megabits per second (Mbit/s, Mb/s, Mbps).
    pub bitrate: Option<Number>,

    /// The caption for this video recording.
    pub caption: Option<Box<String>>,

    /// Comments about this creative work.
    pub comments: Option<Vec<Comment>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// File size in megabits (Mbit, Mb).
    pub content_size: Option<Number>,

    /// Date/time of acceptance.
    pub date_accepted: Option<Box<Date>>,

    /// Date/time of creation.
    pub date_created: Option<Box<Date>>,

    /// Date/time of most recent modification.
    pub date_modified: Option<Box<Date>>,

    /// Date of first publication.
    pub date_published: Option<Box<Date>>,

    /// Date/time that work was received.
    pub date_received: Option<Box<Date>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// People who edited the `CreativeWork`.
    pub editors: Option<Vec<Person>>,

    /// URL that can be used to embed the media on a web page via a specific media player.
    pub embed_url: Option<Box<String>>,

    /// Grants that funded the `CreativeWork`; reverse of `fundedItems`.
    pub funded_by: Option<Vec<CreativeWorkFundedBy>>,

    /// People or organizations that funded the `CreativeWork`.
    pub funders: Option<Vec<CreativeWorkFunders>>,

    /// Genre of the creative work, broadcast channel or group.
    pub genre: Option<Vec<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// An item or other CreativeWork that this CreativeWork is a part of.
    #[serde(skip)]
    pub is_part_of: Option<Box<CreativeWorkTypes>>,

    /// Keywords or tags used to describe this content. Multiple entries in a keywords list are typically delimited by commas.
    pub keywords: Option<Vec<String>>,

    /// License documents that applies to this content, typically indicated by URL.
    pub licenses: Option<Vec<CreativeWorkLicenses>>,

    /// The people or organizations who maintain this CreativeWork.
    pub maintainers: Option<Vec<CreativeWorkMaintainers>>,

    /// IANA media type (MIME type).
    pub media_type: Option<Box<String>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// A publisher of the CreativeWork.
    pub publisher: Option<Box<CreativeWorkPublisher>>,

    /// References to other creative works, such as another publication, web page, scholarly article, etc.
    pub references: Option<Vec<CreativeWorkReferences>>,

    /// The textual content of this creative work.
    pub text: Option<Box<String>>,

    /// Thumbnail image of this video recording.
    pub thumbnail: Option<Box<ImageObject>>,

    /// The title of the creative work.
    pub title: Option<Box<CreativeWorkTitle>>,

    /// The transcript of this video recording.
    pub transcript: Option<Box<String>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,

    /// The version of the creative work.
    pub version: Option<Box<CreativeWorkVersion>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum VideoObject_ {
  VideoObject
}

impl_struct!(VideoObject);
/// A video file.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct VideoObjectSimple {
    /// The name of this type
    #[def = "VideoObjectSimple_::VideoObject"]
    pub type_: VideoObjectSimple_,

    /// URL for the actual bytes of the media object, for example the image file or video file.
    pub content_url: String,

    /// Bitrate in megabits per second (Mbit/s, Mb/s, Mbps).
    pub bitrate: Option<Number>,

    /// The caption for this video recording.
    pub caption: Option<Box<String>>,

    /// The structured content of this creative work c.f. property `text`.
    pub content: Option<Box<CreativeWorkContent>>,

    /// File size in megabits (Mbit, Mb).
    pub content_size: Option<Number>,

    /// URL that can be used to embed the media on a web page via a specific media player.
    pub embed_url: Option<Box<String>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// IANA media type (MIME type).
    pub media_type: Option<Box<String>>,

    /// Elements of the collection which can be a variety of different elements, such as Articles, Datatables, Tables and more.
    pub parts: Option<Vec<CreativeWorkTypes>>,

    /// Thumbnail image of this video recording.
    pub thumbnail: Option<Box<ImageObject>>,

    /// The transcript of this video recording.
    pub transcript: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum VideoObjectSimple_ {
  VideoObject
}

impl_struct!(VideoObjectSimple);

/// Describes a volume mount from a host to container.
#[skip_serializing_none]
#[derive(Clone, Debug, Defaults, Serialize, Deserialize)]
#[serde(default, rename_all = "camelCase")]
pub struct VolumeMount {
    /// The name of this type
    #[def = "VolumeMount_::VolumeMount"]
    pub type_: VolumeMount_,

    /// The mount location inside the container.
    pub mount_destination: String,

    /// Alternate names (aliases) for the item.
    pub alternate_names: Option<Vec<String>>,

    /// A description of the item.
    pub description: Option<Box<ThingDescription>>,

    /// The identifier for this item.
    pub id: Option<Box<String>>,

    /// Any kind of identifier for any kind of Thing.
    pub identifiers: Option<Vec<ThingIdentifiers>>,

    /// Images of the item.
    pub images: Option<Vec<ThingImages>>,

    /// A list of options to use when applying the mount.
    pub mount_options: Option<Vec<String>>,

    /// The mount source directory on the host.
    pub mount_source: Option<Box<String>>,

    /// The type of mount.
    pub mount_type: Option<Box<String>>,

    /// The name of the item.
    pub name: Option<Box<String>>,

    /// The URL of the item.
    pub url: Option<Box<String>>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum VolumeMount_ {
  VolumeMount
}

impl_struct!(VolumeMount);

/*********************************************************************
 * Enums for struct properties which use JSON Schema 'enum' or 'anyOf'
 ********************************************************************/

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum CiteCitationMode {
    Parenthetical,
    Narrative,
    NarrativeAuthor,
    NarrativeYear,
    normal,
    suppressAuthor,
}

/// Types permitted for the `pageEnd` property of a `Cite` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CitePageEnd {
    Integer(Integer),
    String(String),
}

/// Types permitted for the `pageStart` property of a `Cite` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CitePageStart {
    Integer(Integer),
    String(String),
}

/// Types permitted for the `assigns` property of a `CodeChunk` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CodeChunkAssigns {
    Variable(Variable),
    String(String),
}

/// Types permitted for the `caption` property of a `CodeChunk` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CodeChunkCaption {
    VecBlockContent(Vec<BlockContent>),
    String(String),
}

/// Types permitted for the `declares` property of a `CodeChunk` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CodeChunkDeclares {
    Variable(Variable),
    Function(Function),
    String(String),
}

/// Types permitted for the `imports` property of a `CodeChunk` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CodeChunkImports {
    SoftwareSourceCode(SoftwareSourceCode),
    SoftwareApplication(SoftwareApplication),
    String(String),
}

/// Types permitted for the `uses` property of a `CodeChunk` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CodeChunkUses {
    Variable(Variable),
    String(String),
}

/// Types permitted for the `description` property of a `Thing` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ThingDescription {
    VecBlockContent(Vec<BlockContent>),
    VecInlineContent(Vec<InlineContent>),
    String(String),
}

/// Types permitted for the `identifiers` property of a `Thing` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ThingIdentifiers {
    PropertyValue(PropertyValue),
    String(String),
}

/// Types permitted for the `images` property of a `Thing` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ThingImages {
    ImageObject(ImageObject),
    String(String),
}

/// Types permitted for the `logo` property of a `Brand` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum BrandLogo {
    ImageObject(ImageObject),
    String(String),
}

/// Types permitted for the `authors` property of a `CreativeWork` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreativeWorkAuthors {
    Person(Person),
    Organization(Organization),
}

/// Types permitted for the `content` property of a `CreativeWork` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreativeWorkContent {
    VecNode(Vec<Node>),
    String(String),
}

/// Types permitted for the `fundedBy` property of a `CreativeWork` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreativeWorkFundedBy {
    Grant(Grant),
    MonetaryGrant(MonetaryGrant),
}

/// Types permitted for the `funders` property of a `CreativeWork` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreativeWorkFunders {
    Person(Person),
    Organization(Organization),
}

/// Types permitted for the `licenses` property of a `CreativeWork` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreativeWorkLicenses {
    CreativeWorkTypes(CreativeWorkTypes),
    String(String),
}

/// Types permitted for the `maintainers` property of a `CreativeWork` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreativeWorkMaintainers {
    Person(Person),
    Organization(Organization),
}

/// Types permitted for the `publisher` property of a `CreativeWork` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreativeWorkPublisher {
    Person(Person),
    Organization(Organization),
}

/// Types permitted for the `references` property of a `CreativeWork` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreativeWorkReferences {
    CreativeWorkTypes(CreativeWorkTypes),
    String(String),
}

/// Types permitted for the `title` property of a `CreativeWork` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreativeWorkTitle {
    VecInlineContent(Vec<InlineContent>),
    String(String),
}

/// Types permitted for the `version` property of a `CreativeWork` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreativeWorkVersion {
    String(String),
    Number(Number),
}

/// Types permitted for the `pageEnd` property of a `Article` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ArticlePageEnd {
    Integer(Integer),
    String(String),
}

/// Types permitted for the `pageStart` property of a `Article` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ArticlePageStart {
    Integer(Integer),
    String(String),
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum ClaimClaimType {
    Statement,
    Theorem,
    Lemma,
    Proof,
    Postulate,
    Hypothesis,
    Proposition,
    Corollary,
}

/// Types permitted for the `caption` property of a `Figure` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum FigureCaption {
    VecBlockContent(Vec<BlockContent>),
    String(String),
}

/// Types permitted for the `sponsors` property of a `Grant` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GrantSponsors {
    Person(Person),
    Organization(Organization),
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum ListOrder {
    Ascending,
    Descending,
    Unordered,
}

/// Types permitted for the `content` property of a `ListItem` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListItemContent {
    VecBlockContent(Vec<BlockContent>),
    VecInlineContent(Vec<InlineContent>),
}

/// Types permitted for the `funders` property of a `MonetaryGrant` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum MonetaryGrantFunders {
    Person(Person),
    Organization(Organization),
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum NoteNoteType {
    Footnote,
    Endnote,
    Sidenote,
}

/// Types permitted for the `address` property of a `Organization` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum OrganizationAddress {
    PostalAddress(PostalAddress),
    String(String),
}

/// Types permitted for the `funders` property of a `Organization` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum OrganizationFunders {
    Organization(Organization),
    Person(Person),
}

/// Types permitted for the `logo` property of a `Organization` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum OrganizationLogo {
    ImageObject(ImageObject),
    String(String),
}

/// Types permitted for the `members` property of a `Organization` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum OrganizationMembers {
    Organization(Organization),
    Person(Person),
}

/// Types permitted for the `address` property of a `Person` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PersonAddress {
    PostalAddress(PostalAddress),
    String(String),
}

/// Types permitted for the `funders` property of a `Person` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PersonFunders {
    Organization(Organization),
    Person(Person),
}

/// Types permitted for the `logo` property of a `Product` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ProductLogo {
    ImageObject(ImageObject),
    String(String),
}

/// Types permitted for the `value` property of a `PropertyValue` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PropertyValueValue {
    Boolean(Boolean),
    Integer(Integer),
    Number(Number),
    String(String),
}

/// Types permitted for the `issueNumber` property of a `PublicationIssue` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PublicationIssueIssueNumber {
    Integer(Integer),
    String(String),
}

/// Types permitted for the `pageEnd` property of a `PublicationIssue` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PublicationIssuePageEnd {
    Integer(Integer),
    String(String),
}

/// Types permitted for the `pageStart` property of a `PublicationIssue` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PublicationIssuePageStart {
    Integer(Integer),
    String(String),
}

/// Types permitted for the `pageEnd` property of a `PublicationVolume` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PublicationVolumePageEnd {
    Integer(Integer),
    String(String),
}

/// Types permitted for the `pageStart` property of a `PublicationVolume` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PublicationVolumePageStart {
    Integer(Integer),
    String(String),
}

/// Types permitted for the `volumeNumber` property of a `PublicationVolume` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PublicationVolumeVolumeNumber {
    Integer(Integer),
    String(String),
}

/// Types permitted for the `cite` property of a `Quote` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum QuoteCite {
    Cite(Cite),
    String(String),
}

/// Types permitted for the `cite` property of a `QuoteBlock` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum QuoteBlockCite {
    Cite(Cite),
    String(String),
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum SoftwareSessionStatus {
    Unknown,
    Starting,
    Started,
    Stopping,
    Stopped,
    Failed,
}

/// Types permitted for the `softwareRequirements` property of a `SoftwareSourceCode` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum SoftwareSourceCodeSoftwareRequirements {
    SoftwareSourceCode(SoftwareSourceCode),
    SoftwareApplication(SoftwareApplication),
    String(String),
}

/// Types permitted for the `caption` property of a `Table` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TableCaption {
    VecBlockContent(Vec<BlockContent>),
    String(String),
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum TableCellCellType {
    Data,
    Header,
}

/// Types permitted for the `content` property of a `TableCell` node.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TableCellContent {
    VecBlockContent(Vec<BlockContent>),
    VecInlineContent(Vec<InlineContent>),
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum TableRowRowType {
    Header,
    Footer,
}


/*********************************************************************
 * Enums for "enum" schemas
 ********************************************************************/

/// The type or nature of a citation, both factually and rhetorically.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CitationIntentEnumeration {
    /// The citing entity agrees with statements, ideas or conclusions presented in the cited entity
    AgreesWith,
    /// The citing entity cites the cited entity as one that provides an authoritative description or definition of the subject under discussion
    CitesAsAuthority,
    /// The citing entity cites the cited entity as source of data
    CitesAsDataSource,
    /// The citing entity cites the cited entity as source of factual evidence for statements it contains
    CitesAsEvidence,
    /// The citing entity cites the cited entity as being the container of metadata describing the citing entity
    CitesAsMetadataDocument,
    /// The citing entity cites the cited entity as providing or containing a possible solution to the issues being discussed
    CitesAsPotentialSolution,
    /// The citing entity cites the cited entity as an item of recommended reading
    CitesAsRecommendedReading,
    /// The citing entity cites the cited entity as one that is related
    CitesAsRelated,
    /// The citing entity cites the cited entity as being the entity from which the citing entity is derived, or about which the citing entity contains metadata
    CitesAsSourceDocument,
    /// The citing entity cites the cited entity as a source of information on the subject under discussion
    CitesForInformation,
    /// The citing entity is used to create or compile the cited entity
    Compiles,
    /// The citing entity confirms facts, ideas or statements presented in the cited entity
    Confirms,
    /// The citing entity contains a statement of fact or a logical assertion (or a collection of such facts and/or assertions) originally present in the cited entity
    ContainsAssertionFrom,
    /// The citing entity corrects statements, ideas or conclusions presented in the cited entity
    Corrects,
    /// The citing entity acknowledges contributions made by the cited entity
    Credits,
    /// The citing entity critiques statements, ideas or conclusions presented in the cited entity
    Critiques,
    /// The citing entity express derision for the cited entity, or for ideas or conclusions contained within it
    Derides,
    /// The citing entity describes the cited entity
    Describes,
    /// The citing entity disagrees with statements, ideas or conclusions presented in the cited entity
    DisagreesWith,
    /// The citing entity discusses statements, ideas or conclusions presented in the cited entity
    Discusses,
    /// The citing entity disputes statements, ideas or conclusions presented in the cited entity
    Disputes,
    /// The citing entity documents information about the cited entity
    Documents,
    /// The citing entity extends facts, ideas or understandings presented in the cited entity
    Extends,
    /// The cited entity provides background information for the citing entity
    GivesBackgroundTo,
    /// The cited entity provides intellectual or factual support for the citing entity
    GivesSupportTo,
    /// The cited entity evokes a reply from the citing entity
    HasReplyFrom,
    /// The citing entity includes one or more excerpts from the cited entity
    IncludesExcerptFrom,
    /// The citing entity includes one or more quotations from the cited entity
    IncludesQuotationFrom,
    /// The cited entity contains statements, ideas or conclusions with which the citing entity agrees
    IsAgreedWithBy,
    /// The cited entity is cited as providing an authoritative description or definition of the subject under discussion in the citing entity
    IsCitedAsAuthorityBy,
    /// The cited entity is cited as a data source by the citing entity
    IsCitedAsDataSourceBy,
    /// The cited entity is cited for providing factual evidence to the citing entity
    IsCitedAsEvidenceBy,
    /// The cited entity is cited as being the container of metadata relating to the citing entity
    IsCitedAsMetadataDocumentBy,
    /// The cited entity is cited as providing or containing a possible solution to the issues being discussed in the citing entity
    IsCitedAsPontentialSolutionBy,
    /// The cited entity is cited by the citing entity as an item of recommended reading
    IsCitedAsRecommendedReadingBy,
    /// The cited entity is cited as being related to the citing entity
    IsCitedAsRelatedBy,
    /// The cited entity is cited as being the entity from which the citing entity is derived, or about which the citing entity contains metadata
    IsCitedAsSourceDocumentBy,
    /// The cited entity (the subject of the RDF triple) is cited by the citing entity (the object of the triple)
    IsCitedBy,
    /// The cited entity is cited as a source of information on the subject under discussion in the citing entity
    IsCitedForInformationBy,
    /// The cited entity is the result of a compile or creation event using the citing entity
    IsCompiledBy,
    /// The cited entity presents facts, ideas or statements that are confirmed by the citing entity
    IsConfirmedBy,
    /// The cited entity presents statements, ideas or conclusions that are corrected by the citing entity
    IsCorrectedBy,
    /// The cited entity makes contributions that are acknowledged by the citing entity
    IsCreditedBy,
    /// The cited entity presents statements, ideas or conclusions that are critiqued by the citing entity
    IsCritiquedBy,
    /// The cited entity contains ideas or conclusions for which the citing entity express derision
    IsDeridedBy,
    /// The cited entity is described by the citing entity
    IsDescribedBy,
    /// The cited entity presents statements, ideas or conclusions that are disagreed with by the citing entity
    IsDisagreedWithBy,
    /// The cited entity presents statements, ideas or conclusions that are discussed by the citing entity
    IsDiscussedBy,
    /// The cited entity presents statements, ideas or conclusions that are disputed by the citing entity
    IsDisputedBy,
    /// Information about the cited entity is documented by the citing entity
    IsDocumentedBy,
    /// The cited entity presents facts, ideas or understandings that are extended by the citing entity
    IsExtendedBy,
    /// The cited entity is the target for an HTTP Uniform Resource Locator (URL) link within the citing entity
    IsLinkedToBy,
    /// The characteristic style or content of the cited entity is imitated by the citing entity for comic effect, usually without explicit citation
    IsParodiedBy,
    /// The cited entity is plagiarized by the author of the citing entity, who includes within the citing entity textual or other elements from the cited entity without formal acknowledgement of their source
    IsPlagiarizedBy,
    /// The cited entity presents statements, ideas or conclusions that are qualified or have conditions placed upon them by the citing entity
    IsQualifiedBy,
    /// The cited entity presents statements, ideas or conclusions that are refuted by the citing entity
    IsRefutedBy,
    /// The cited entity is formally retracted by the citing entity
    IsRetractedBy,
    /// The cited entity presents statements, ideas or conclusions that are reviewed by the citing entity
    IsReviewedBy,
    /// The cited entity or aspects of its contents are ridiculed by the citing entity
    IsRidiculedBy,
    /// The cited entity is cited because the citing article contains speculations on its content or ideas
    IsSpeculatedOnBy,
    /// The cited entity receives intellectual or factual support from the citing entity
    IsSupportedBy,
    /// The cited entity presents statements, ideas, hypotheses or understanding that are updated by the cited entity
    IsUpdatedBy,
    /// A property that permits you to express appreciation of or interest in something that is the object of the RDF triple, or to express that it is worth thinking about even if you do not agree with its content, enabling social media 'likes' statements to be encoded in RDF
    Likes,
    /// The citing entity provides a link, in the form of an HTTP Uniform Resource Locator (URL), to the cited entity
    LinksTo,
    /// The citing entity obtains background information from the cited entity
    ObtainsBackgroundFrom,
    /// The citing entity obtains intellectual or factual support from the cited entity
    ObtainsSupportFrom,
    /// The citing entity imitates the characteristic style or content of the cited entity for comic effect, usually without explicit citation
    Parodies,
    /// A property indicating that the author of the citing entity plagiarizes the cited entity, by including textual or other elements from the cited entity without formal acknowledgement of their source
    Plagiarizes,
    /// The cited entity contains and is the original source of a statement of fact or a logical assertion (or a collection of such facts and/or assertions) that is to be found in the citing entity
    ProvidesAssertionFor,
    /// The cited entity presents conclusions that are used in work described in the citing entity
    ProvidesConclusionsFor,
    /// The cited entity presents data that are used in work described in the citing entity
    ProvidesDataFor,
    /// The cited entity contains information, usually of a textual nature, that is excerpted by (used as an excerpt within) the citing entity
    ProvidesExcerptFor,
    /// The cited entity details a method that is used in work described by the citing entity
    ProvidesMethodFor,
    /// The cited entity contains information, usually of a textual nature, that is quoted by (used as a quotation within) the citing entity
    ProvidesQuotationFor,
    /// The citing entity qualifies or places conditions or restrictions upon statements, ideas or conclusions presented in the cited entity
    Qualifies,
    /// The citing entity refutes statements, ideas or conclusions presented in the cited entity
    Refutes,
    /// The citing entity replies to statements, ideas or criticisms presented in the cited entity
    RepliesTo,
    /// The citing entity constitutes a formal retraction of the cited entity
    Retracts,
    /// The citing entity reviews statements, ideas or conclusions presented in the cited entity
    Reviews,
    /// The citing entity ridicules the cited entity or aspects of its contents
    Ridicules,
    /// Each entity has at least one author that shares a common institutional affiliation with an author of the other entity
    SharesAuthorInstitutionWith,
    /// Each entity has at least one author in common with the other entity
    SharesAuthorWith,
    /// The two entities result from activities that have been funded by the same funding agency
    SharesFundingAgencyWith,
    /// The citing and cited bibliographic resources are published in the same journal
    SharesJournalWith,
    /// The citing and cited bibliographic resources are published in same publication venue
    SharesPublicationVenueWith,
    /// The citing entity speculates on something within or related to the cited entity, without firm evidence
    SpeculatesOn,
    /// The citing entity provides intellectual or factual support for statements, ideas or conclusions presented in the cited entity
    Supports,
    /// The citing entity updates statements, ideas, hypotheses or understanding presented in the cited entity
    Updates,
    /// The citing entity describes work that uses conclusions presented in the cited entity
    UsesConclusionsFrom,
    /// The citing entity describes work that uses data presented in the cited entity
    UsesDataFrom,
    /// The citing entity describes work that uses a method detailed in the cited entity
    UsesMethodIn,
}
impl_enum!(CitationIntentEnumeration);

/*********************************************************************
 * Enums for "union" schemas
 ********************************************************************/
  
/// Union type for valid block content.
#[enum_dispatch(NodeTrait)]
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum BlockContent {
    Claim(ClaimSimple),
    CodeBlock(CodeBlock),
    CodeChunk(CodeChunk),
    Collection(CollectionSimple),
    Figure(FigureSimple),
    Heading(Heading),
    List(List),
    MathBlock(MathBlock),
    Paragraph(Paragraph),
    QuoteBlock(QuoteBlock),
    Table(TableSimple),
    ThematicBreak(ThematicBreak),
}

/// All type schemas that are derived from CodeBlock
#[enum_dispatch(NodeTrait)]
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CodeBlockTypes {
    CodeBlock(CodeBlock),
    CodeChunk(CodeChunk),
}

/// All type schemas that are derived from CodeFragment
#[enum_dispatch(NodeTrait)]
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CodeFragmentTypes {
    CodeFragment(CodeFragment),
    CodeExpression(CodeExpression),
}

/// All type schemas that are derived from Code
#[enum_dispatch(NodeTrait)]
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CodeTypes {
    Code(Code),
    CodeBlock(CodeBlock),
    CodeChunk(CodeChunk),
    CodeExpression(CodeExpression),
    CodeFragment(CodeFragment),
}

/// All type schemas that are derived from ContactPoint
#[enum_dispatch(NodeTrait)]
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ContactPointTypes {
    ContactPoint(ContactPoint),
    PostalAddress(PostalAddress),
}

/// All type schemas that are derived from CreativeWork
#[enum_dispatch(NodeTrait)]
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreativeWorkTypes {
    CreativeWork(CreativeWork),
    Article(Article),
    AudioObject(AudioObject),
    Claim(Claim),
    Collection(Collection),
    Comment(Comment),
    Datatable(Datatable),
    Figure(Figure),
    ImageObject(ImageObject),
    MediaObject(MediaObject),
    Periodical(Periodical),
    PublicationIssue(PublicationIssue),
    PublicationVolume(PublicationVolume),
    Review(Review),
    SoftwareApplication(SoftwareApplication),
    SoftwareSourceCode(SoftwareSourceCode),
    Table(Table),
    VideoObject(VideoObject),
}

/// All type schemas that are derived from Entity
#[enum_dispatch(NodeTrait)]
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum EntityTypes {
    Entity(Entity),
    ArrayValidator(ArrayValidator),
    Article(Article),
    AudioObject(AudioObject),
    BooleanValidator(BooleanValidator),
    Brand(Brand),
    CitationIntentEnumeration(CitationIntentEnumeration),
    Cite(Cite),
    CiteGroup(CiteGroup),
    Claim(Claim),
    Code(Code),
    CodeBlock(CodeBlock),
    CodeChunk(CodeChunk),
    CodeError(CodeError),
    CodeExpression(CodeExpression),
    CodeFragment(CodeFragment),
    Collection(Collection),
    Comment(Comment),
    ConstantValidator(ConstantValidator),
    ContactPoint(ContactPoint),
    CreativeWork(CreativeWork),
    Datatable(Datatable),
    DatatableColumn(DatatableColumn),
    Date(Date),
    DefinedTerm(DefinedTerm),
    Delete(Delete),
    Emphasis(Emphasis),
    EnumValidator(EnumValidator),
    Enumeration(Enumeration),
    Figure(Figure),
    Function(Function),
    Grant(Grant),
    Heading(Heading),
    ImageObject(ImageObject),
    Include(Include),
    IntegerValidator(IntegerValidator),
    Link(Link),
    List(List),
    ListItem(ListItem),
    Mark(Mark),
    Math(Math),
    MathBlock(MathBlock),
    MathFragment(MathFragment),
    MediaObject(MediaObject),
    MonetaryGrant(MonetaryGrant),
    NontextualAnnotation(NontextualAnnotation),
    Note(Note),
    NumberValidator(NumberValidator),
    Organization(Organization),
    Paragraph(Paragraph),
    Parameter(Parameter),
    Periodical(Periodical),
    Person(Person),
    PostalAddress(PostalAddress),
    Product(Product),
    PropertyValue(PropertyValue),
    PublicationIssue(PublicationIssue),
    PublicationVolume(PublicationVolume),
    Quote(Quote),
    QuoteBlock(QuoteBlock),
    Review(Review),
    SoftwareApplication(SoftwareApplication),
    SoftwareEnvironment(SoftwareEnvironment),
    SoftwareSession(SoftwareSession),
    SoftwareSourceCode(SoftwareSourceCode),
    StringValidator(StringValidator),
    Strong(Strong),
    Subscript(Subscript),
    Superscript(Superscript),
    Table(Table),
    TableCell(TableCell),
    TableRow(TableRow),
    ThematicBreak(ThematicBreak),
    Thing(Thing),
    TupleValidator(TupleValidator),
    Validator(Validator),
    Variable(Variable),
    VideoObject(VideoObject),
    VolumeMount(VolumeMount),
}

/// All type schemas that are derived from Enumeration
#[enum_dispatch(NodeTrait)]
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum EnumerationTypes {
    Enumeration(Enumeration),
    CitationIntentEnumeration(CitationIntentEnumeration),
}

/// All type schemas that are derived from Grant
#[enum_dispatch(NodeTrait)]
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GrantTypes {
    Grant(Grant),
    MonetaryGrant(MonetaryGrant),
}

/// Union type for valid inline content.
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum InlineContent {
    AudioObject(AudioObjectSimple),
    Cite(Cite),
    CiteGroup(CiteGroup),
    CodeExpression(CodeExpression),
    CodeFragment(CodeFragment),
    Delete(Delete),
    Emphasis(Emphasis),
    ImageObject(ImageObjectSimple),
    Link(Link),
    MathFragment(MathFragment),
    NontextualAnnotation(NontextualAnnotation),
    Note(Note),
    Quote(Quote),
    Strong(Strong),
    Subscript(Subscript),
    Superscript(Superscript),
    VideoObject(VideoObjectSimple),
    Null,
    Boolean(Boolean),
    Integer(Integer),
    Number(Number),
    String(String),
}

/// All type schemas that are derived from Mark
#[enum_dispatch(NodeTrait)]
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum MarkTypes {
    Mark(Mark),
    Delete(Delete),
    Emphasis(Emphasis),
    NontextualAnnotation(NontextualAnnotation),
    Quote(Quote),
    Strong(Strong),
    Subscript(Subscript),
    Superscript(Superscript),
}

/// All type schemas that are derived from Math
#[enum_dispatch(NodeTrait)]
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum MathTypes {
    Math(Math),
    MathBlock(MathBlock),
    MathFragment(MathFragment),
}

/// All type schemas that are derived from MediaObject
#[enum_dispatch(NodeTrait)]
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum MediaObjectTypes {
    MediaObject(MediaObject),
    AudioObject(AudioObject),
    ImageObject(ImageObject),
    VideoObject(VideoObject),
}

/// Union type for all schema nodes, including primitives and entities
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum Node {
    Entity(Entity),
    ArrayValidator(ArrayValidator),
    Article(Article),
    AudioObject(AudioObject),
    BooleanValidator(BooleanValidator),
    Brand(Brand),
    CitationIntentEnumeration(CitationIntentEnumeration),
    Cite(Cite),
    CiteGroup(CiteGroup),
    Claim(Claim),
    Code(Code),
    CodeBlock(CodeBlock),
    CodeChunk(CodeChunk),
    CodeError(CodeError),
    CodeExpression(CodeExpression),
    CodeFragment(CodeFragment),
    Collection(Collection),
    Comment(Comment),
    ConstantValidator(ConstantValidator),
    ContactPoint(ContactPoint),
    CreativeWork(CreativeWork),
    Datatable(Datatable),
    DatatableColumn(DatatableColumn),
    Date(Date),
    DefinedTerm(DefinedTerm),
    Delete(Delete),
    Emphasis(Emphasis),
    EnumValidator(EnumValidator),
    Enumeration(Enumeration),
    Figure(Figure),
    Function(Function),
    Grant(Grant),
    Heading(Heading),
    ImageObject(ImageObject),
    Include(Include),
    IntegerValidator(IntegerValidator),
    Link(Link),
    List(List),
    ListItem(ListItem),
    Mark(Mark),
    Math(Math),
    MathBlock(MathBlock),
    MathFragment(MathFragment),
    MediaObject(MediaObject),
    MonetaryGrant(MonetaryGrant),
    NontextualAnnotation(NontextualAnnotation),
    Note(Note),
    NumberValidator(NumberValidator),
    Organization(Organization),
    Paragraph(Paragraph),
    Parameter(Parameter),
    Periodical(Periodical),
    Person(Person),
    PostalAddress(PostalAddress),
    Product(Product),
    PropertyValue(PropertyValue),
    PublicationIssue(PublicationIssue),
    PublicationVolume(PublicationVolume),
    Quote(Quote),
    QuoteBlock(QuoteBlock),
    Review(Review),
    SoftwareApplication(SoftwareApplication),
    SoftwareEnvironment(SoftwareEnvironment),
    SoftwareSession(SoftwareSession),
    SoftwareSourceCode(SoftwareSourceCode),
    StringValidator(StringValidator),
    Strong(Strong),
    Subscript(Subscript),
    Superscript(Superscript),
    Table(Table),
    TableCell(TableCell),
    TableRow(TableRow),
    ThematicBreak(ThematicBreak),
    Thing(Thing),
    TupleValidator(TupleValidator),
    Validator(Validator),
    Variable(Variable),
    VideoObject(VideoObject),
    VolumeMount(VolumeMount),
    Null,
    Boolean(Boolean),
    Integer(Integer),
    Number(Number),
    String(String),
    Object(Object),
    Array(Vec<Node>),
}

/// All type schemas that are derived from Thing
#[enum_dispatch(NodeTrait)]
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ThingTypes {
    Thing(Thing),
    Article(Article),
    AudioObject(AudioObject),
    Brand(Brand),
    CitationIntentEnumeration(CitationIntentEnumeration),
    Claim(Claim),
    Collection(Collection),
    Comment(Comment),
    ContactPoint(ContactPoint),
    CreativeWork(CreativeWork),
    Datatable(Datatable),
    DatatableColumn(DatatableColumn),
    DefinedTerm(DefinedTerm),
    Enumeration(Enumeration),
    Figure(Figure),
    Grant(Grant),
    ImageObject(ImageObject),
    ListItem(ListItem),
    MediaObject(MediaObject),
    MonetaryGrant(MonetaryGrant),
    Organization(Organization),
    Periodical(Periodical),
    Person(Person),
    PostalAddress(PostalAddress),
    Product(Product),
    PropertyValue(PropertyValue),
    PublicationIssue(PublicationIssue),
    PublicationVolume(PublicationVolume),
    Review(Review),
    SoftwareApplication(SoftwareApplication),
    SoftwareEnvironment(SoftwareEnvironment),
    SoftwareSession(SoftwareSession),
    SoftwareSourceCode(SoftwareSourceCode),
    Table(Table),
    VideoObject(VideoObject),
    VolumeMount(VolumeMount),
}

/// All type schemas that are derived from Validator
#[enum_dispatch(NodeTrait)]
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ValidatorTypes {
    Validator(Validator),
    ArrayValidator(ArrayValidator),
    BooleanValidator(BooleanValidator),
    ConstantValidator(ConstantValidator),
    EnumValidator(EnumValidator),
    IntegerValidator(IntegerValidator),
    NumberValidator(NumberValidator),
    StringValidator(StringValidator),
    TupleValidator(TupleValidator),
}

/// All type schemas that are derived from Variable
#[enum_dispatch(NodeTrait)]
#[derive(Clone, Debug, Serialize, Deserialize)]
#[serde(untagged)]
pub enum VariableTypes {
    Variable(Variable),
    Parameter(Parameter),
}
