
pub const SCHEMAS: &[(&str, &str)] = &[
    ("Array", r#"{"title":"Array","type":"array"}"#),
    ("ArrayValidator", r#"{"title":"ArrayValidator","type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{},"properties":{"id":{"type":"string"},"itemsValidator":{"allOf":[{"$ref":"ValidatorTypes.schema.json"}]},"contains":{"allOf":[{"$ref":"ValidatorTypes.schema.json"}]},"minItems":{"type":"integer","minimum":0},"maxItems":{"type":"integer","minimum":0},"uniqueItems":{"type":"boolean"}}}"#),
    ("Article", r#"{"title":"Article","examples":[{"type":"Article","title":"Recherches sur les substances radioactives","authors":[{"type":"Person","honorificPrefix":"Dr","givenNames":["Marie","Skłodowska"],"familyNames":["Curie"],"honorificSuffix":"PhD"}],"content":["Le présent travail a pour but d'exposer les recherches que je poursuis depuis"]}],"type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"type":"array","items":{"$ref":"BlockContent.schema.json"},"isOverride":true},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"pageStart":{"anyOf":[{"type":"integer"},{"type":"string"}]},"pageEnd":{"anyOf":[{"type":"integer"},{"type":"string"}]},"pagination":{"type":"string"}}}"#),
    ("AudioObject", r#"{"title":"AudioObject","examples":[{"type":"AudioObject","caption":"Example Audio File","contentSize":54321,"contentUrl":"http://www.example.com/file.mp3","encodingFormat":"audio/mpeg3","transcript":"This is the transcript for the audio file..."}],"type":"object","additionalProperties":false,"required":["type","contentUrl"],"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title","encodingFormat":"mediaType"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"bitrate":{"type":"number"},"contentSize":{"type":"number"},"contentUrl":{"type":"string"},"embedUrl":{"type":"string"},"mediaType":{"aliases":["encodingFormat"],"type":"string","pattern":"^[a-z]+(\\/[a-z\\+\\-]+)$"},"caption":{"type":"string"},"transcript":{"type":"string"}}}"#),
    ("BlockContent", r#"{"title":"BlockContent","anyOf":[{"$ref":"Claim.schema.json"},{"$ref":"CodeBlock.schema.json"},{"$ref":"CodeChunk.schema.json"},{"$ref":"Collection.schema.json"},{"$ref":"Figure.schema.json"},{"$ref":"Heading.schema.json"},{"$ref":"Include.schema.json"},{"$ref":"List.schema.json"},{"$ref":"MathBlock.schema.json"},{"$ref":"Paragraph.schema.json"},{"$ref":"QuoteBlock.schema.json"},{"$ref":"Table.schema.json"},{"$ref":"ThematicBreak.schema.json"}]}"#),
    ("Boolean", r#"{"title":"Boolean","type":"boolean"}"#),
    ("BooleanValidator", r#"{"title":"BooleanValidator","type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{},"properties":{"id":{"type":"string"}}}"#),
    ("Brand", r#"{"title":"Brand","required":["type","name"],"examples":[{"type":"Brand","name":"XYZ","logo":{"type":"ImageObject","url":"https://example.com/xyz.png","caption":"Logo of Brand YXZ"},"reviews":["Rather average product","Not sure if would use again"]}],"type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","review":"reviews"},"additionalProperties":false,"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string","isOverride":true},"url":{"type":"string","format":"uri"},"logo":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"reviews":{"type":"array","items":{"type":"string"},"aliases":["review"]}}}"#),
    ("CitationIntentEnumeration", r#"{"title":"CitationIntentEnumeration","anyOf":[{"const":"AgreesWith","@id":"cito:agreesWith","description":"The citing entity agrees with statements, ideas or conclusions presented in the cited entity"},{"const":"CitesAsAuthority","@id":"cito:citesAsAuthority","description":"The citing entity cites the cited entity as one that provides an authoritative description or definition of the subject under discussion"},{"const":"CitesAsDataSource","@id":"cito:citesAsDataSource","description":"The citing entity cites the cited entity as source of data"},{"const":"CitesAsEvidence","@id":"cito:citesAsEvidence","description":"The citing entity cites the cited entity as source of factual evidence for statements it contains"},{"const":"CitesAsMetadataDocument","@id":"cito:citesAsMetadataDocument","description":"The citing entity cites the cited entity as being the container of metadata describing the citing entity"},{"const":"CitesAsPotentialSolution","@id":"cito:citesAsPotentialSolution","description":"The citing entity cites the cited entity as providing or containing a possible solution to the issues being discussed"},{"const":"CitesAsRecommendedReading","@id":"cito:citesAsRecommendedReading","description":"The citing entity cites the cited entity as an item of recommended reading"},{"const":"CitesAsRelated","@id":"cito:citesAsRelated","description":"The citing entity cites the cited entity as one that is related"},{"const":"CitesAsSourceDocument","@id":"cito:citesAsSourceDocument","description":"The citing entity cites the cited entity as being the entity from which the citing entity is derived, or about which the citing entity contains metadata"},{"const":"CitesForInformation","@id":"cito:citesForInformation","description":"The citing entity cites the cited entity as a source of information on the subject under discussion"},{"const":"Compiles","@id":"cito:compiles","description":"The citing entity is used to create or compile the cited entity"},{"const":"Confirms","@id":"cito:confirms","description":"The citing entity confirms facts, ideas or statements presented in the cited entity"},{"const":"ContainsAssertionFrom","@id":"cito:containsAssertionFrom","description":"The citing entity contains a statement of fact or a logical assertion (or a collection of such facts and/or assertions) originally present in the cited entity"},{"const":"Corrects","@id":"cito:corrects","description":"The citing entity corrects statements, ideas or conclusions presented in the cited entity"},{"const":"Credits","@id":"cito:credits","description":"The citing entity acknowledges contributions made by the cited entity"},{"const":"Critiques","@id":"cito:critiques","description":"The citing entity critiques statements, ideas or conclusions presented in the cited entity"},{"const":"Derides","@id":"cito:derides","description":"The citing entity express derision for the cited entity, or for ideas or conclusions contained within it"},{"const":"Describes","@id":"cito:describes","description":"The citing entity describes the cited entity"},{"const":"DisagreesWith","@id":"cito:disagreesWith","description":"The citing entity disagrees with statements, ideas or conclusions presented in the cited entity"},{"const":"Discusses","@id":"cito:discusses","description":"The citing entity discusses statements, ideas or conclusions presented in the cited entity"},{"const":"Disputes","@id":"cito:disputes","description":"The citing entity disputes statements, ideas or conclusions presented in the cited entity"},{"const":"Documents","@id":"cito:documents","description":"The citing entity documents information about the cited entity"},{"const":"Extends","@id":"cito:extends","description":"The citing entity extends facts, ideas or understandings presented in the cited entity"},{"const":"GivesBackgroundTo","@id":"cito:givesBackgroundTo","description":"The cited entity provides background information for the citing entity"},{"const":"GivesSupportTo","@id":"cito:givesSupportTo","description":"The cited entity provides intellectual or factual support for the citing entity"},{"const":"HasReplyFrom","@id":"cito:hasReplyFrom","description":"The cited entity evokes a reply from the citing entity"},{"const":"IncludesExcerptFrom","@id":"cito:includesExcerptFrom","description":"The citing entity includes one or more excerpts from the cited entity"},{"const":"IncludesQuotationFrom","@id":"cito:includesQuotationFrom","description":"The citing entity includes one or more quotations from the cited entity"},{"const":"IsAgreedWithBy","@id":"cito:isAgreedWithBy","description":"The cited entity contains statements, ideas or conclusions with which the citing entity agrees"},{"const":"IsCitedAsAuthorityBy","@id":"cito:isCitedAsAuthorityBy","description":"The cited entity is cited as providing an authoritative description or definition of the subject under discussion in the citing entity"},{"const":"IsCitedAsDataSourceBy","@id":"cito:isCitedAsDataSourceBy","description":"The cited entity is cited as a data source by the citing entity"},{"const":"IsCitedAsEvidenceBy","@id":"cito:isCitedAsEvidenceBy","description":"The cited entity is cited for providing factual evidence to the citing entity"},{"const":"IsCitedAsMetadataDocumentBy","@id":"cito:isCitedAsMetadataDocumentBy","description":"The cited entity is cited as being the container of metadata relating to the citing entity"},{"const":"IsCitedAsPontentialSolutionBy","@id":"cito:isCitedAsPontentialSolutionBy","description":"The cited entity is cited as providing or containing a possible solution to the issues being discussed in the citing entity"},{"const":"IsCitedAsRecommendedReadingBy","@id":"cito:isCitedAsRecommendedReadingBy","description":"The cited entity is cited by the citing entity as an item of recommended reading"},{"const":"IsCitedAsRelatedBy","@id":"cito:isCitedAsRelatedBy","description":"The cited entity is cited as being related to the citing entity"},{"const":"IsCitedAsSourceDocumentBy","@id":"cito:isCitedAsSourceDocumentBy","description":"The cited entity is cited as being the entity from which the citing entity is derived, or about which the citing entity contains metadata"},{"const":"IsCitedBy","@id":"cito:isCitedBy","description":"The cited entity (the subject of the RDF triple) is cited by the citing entity (the object of the triple)"},{"const":"IsCitedForInformationBy","@id":"cito:isCitedForInformationBy","description":"The cited entity is cited as a source of information on the subject under discussion in the citing entity"},{"const":"IsCompiledBy","@id":"cito:isCompiledBy","description":"The cited entity is the result of a compile or creation event using the citing entity"},{"const":"IsConfirmedBy","@id":"cito:isConfirmedBy","description":"The cited entity presents facts, ideas or statements that are confirmed by the citing entity"},{"const":"IsCorrectedBy","@id":"cito:isCorrectedBy","description":"The cited entity presents statements, ideas or conclusions that are corrected by the citing entity"},{"const":"IsCreditedBy","@id":"cito:isCreditedBy","description":"The cited entity makes contributions that are acknowledged by the citing entity"},{"const":"IsCritiquedBy","@id":"cito:isCritiquedBy","description":"The cited entity presents statements, ideas or conclusions that are critiqued by the citing entity"},{"const":"IsDeridedBy","@id":"cito:isDeridedBy","description":"The cited entity contains ideas or conclusions for which the citing entity express derision"},{"const":"IsDescribedBy","@id":"cito:isDescribedBy","description":"The cited entity is described by the citing entity"},{"const":"IsDisagreedWithBy","@id":"cito:isDisagreedWithBy","description":"The cited entity presents statements, ideas or conclusions that are disagreed with by the citing entity"},{"const":"IsDiscussedBy","@id":"cito:isDiscussedBy","description":"The cited entity presents statements, ideas or conclusions that are discussed by the citing entity"},{"const":"IsDisputedBy","@id":"cito:isDisputedBy","description":"The cited entity presents statements, ideas or conclusions that are disputed by the citing entity"},{"const":"IsDocumentedBy","@id":"cito:isDocumentedBy","description":"Information about the cited entity is documented by the citing entity"},{"const":"IsExtendedBy","@id":"cito:isExtendedBy","description":"The cited entity presents facts, ideas or understandings that are extended by the citing entity"},{"const":"IsLinkedToBy","@id":"cito:isLinkedToBy","description":"The cited entity is the target for an HTTP Uniform Resource Locator (URL) link within the citing entity"},{"const":"IsParodiedBy","@id":"cito:isParodiedBy","description":"The characteristic style or content of the cited entity is imitated by the citing entity for comic effect, usually without explicit citation"},{"const":"IsPlagiarizedBy","@id":"cito:isPlagiarizedBy","description":"The cited entity is plagiarized by the author of the citing entity, who includes within the citing entity textual or other elements from the cited entity without formal acknowledgement of their source"},{"const":"IsQualifiedBy","@id":"cito:isQualifiedBy","description":"The cited entity presents statements, ideas or conclusions that are qualified or have conditions placed upon them by the citing entity"},{"const":"IsRefutedBy","@id":"cito:isRefutedBy","description":"The cited entity presents statements, ideas or conclusions that are refuted by the citing entity"},{"const":"IsRetractedBy","@id":"cito:isRetractedBy","description":"The cited entity is formally retracted by the citing entity"},{"const":"IsReviewedBy","@id":"cito:isReviewedBy","description":"The cited entity presents statements, ideas or conclusions that are reviewed by the citing entity"},{"const":"IsRidiculedBy","@id":"cito:isRidiculedBy","description":"The cited entity or aspects of its contents are ridiculed by the citing entity"},{"const":"IsSpeculatedOnBy","@id":"cito:isSpeculatedOnBy","description":"The cited entity is cited because the citing article contains speculations on its content or ideas"},{"const":"IsSupportedBy","@id":"cito:isSupportedBy","description":"The cited entity receives intellectual or factual support from the citing entity"},{"const":"IsUpdatedBy","@id":"cito:isUpdatedBy","description":"The cited entity presents statements, ideas, hypotheses or understanding that are updated by the cited entity"},{"const":"Likes","@id":"cito:likes","description":"A property that permits you to express appreciation of or interest in something that is the object of the RDF triple, or to express that it is worth thinking about even if you do not agree with its content, enabling social media 'likes' statements to be encoded in RDF"},{"const":"LinksTo","@id":"cito:linksTo","description":"The citing entity provides a link, in the form of an HTTP Uniform Resource Locator (URL), to the cited entity"},{"const":"ObtainsBackgroundFrom","@id":"cito:obtainsBackgroundFrom","description":"The citing entity obtains background information from the cited entity"},{"const":"ObtainsSupportFrom","@id":"cito:obtainsSupportFrom","description":"The citing entity obtains intellectual or factual support from the cited entity"},{"const":"Parodies","@id":"cito:parodies","description":"The citing entity imitates the characteristic style or content of the cited entity for comic effect, usually without explicit citation"},{"const":"Plagiarizes","@id":"cito:plagiarizes","description":"A property indicating that the author of the citing entity plagiarizes the cited entity, by including textual or other elements from the cited entity without formal acknowledgement of their source"},{"const":"ProvidesAssertionFor","@id":"cito:providesAssertionFor","description":"The cited entity contains and is the original source of a statement of fact or a logical assertion (or a collection of such facts and/or assertions) that is to be found in the citing entity"},{"const":"ProvidesConclusionsFor","@id":"cito:providesConclusionsFor","description":"The cited entity presents conclusions that are used in work described in the citing entity"},{"const":"ProvidesDataFor","@id":"cito:providesDataFor","description":"The cited entity presents data that are used in work described in the citing entity"},{"const":"ProvidesExcerptFor","@id":"cito:providesExcerptFor","description":"The cited entity contains information, usually of a textual nature, that is excerpted by (used as an excerpt within) the citing entity"},{"const":"ProvidesMethodFor","@id":"cito:providesMethodFor","description":"The cited entity details a method that is used in work described by the citing entity"},{"const":"ProvidesQuotationFor","@id":"cito:providesQuotationFor","description":"The cited entity contains information, usually of a textual nature, that is quoted by (used as a quotation within) the citing entity"},{"const":"Qualifies","@id":"cito:qualifies","description":"The citing entity qualifies or places conditions or restrictions upon statements, ideas or conclusions presented in the cited entity"},{"const":"Refutes","@id":"cito:refutes","description":"The citing entity refutes statements, ideas or conclusions presented in the cited entity"},{"const":"RepliesTo","@id":"cito:repliesTo","description":"The citing entity replies to statements, ideas or criticisms presented in the cited entity"},{"const":"Retracts","@id":"cito:retracts","description":"The citing entity constitutes a formal retraction of the cited entity"},{"const":"Reviews","@id":"cito:reviews","description":"The citing entity reviews statements, ideas or conclusions presented in the cited entity"},{"const":"Ridicules","@id":"cito:ridicules","description":"The citing entity ridicules the cited entity or aspects of its contents"},{"const":"SharesAuthorInstitutionWith","@id":"cito:sharesAuthorInstitutionWith","description":"Each entity has at least one author that shares a common institutional affiliation with an author of the other entity"},{"const":"SharesAuthorWith","@id":"cito:sharesAuthorWith","description":"Each entity has at least one author in common with the other entity"},{"const":"SharesFundingAgencyWith","@id":"cito:sharesFundingAgencyWith","description":"The two entities result from activities that have been funded by the same funding agency"},{"const":"SharesJournalWith","@id":"cito:sharesJournalWith","description":"The citing and cited bibliographic resources are published in the same journal"},{"const":"SharesPublicationVenueWith","@id":"cito:sharesPublicationVenueWith","description":"The citing and cited bibliographic resources are published in same publication venue"},{"const":"SpeculatesOn","@id":"cito:speculatesOn","description":"The citing entity speculates on something within or related to the cited entity, without firm evidence"},{"const":"Supports","@id":"cito:supports","description":"The citing entity provides intellectual or factual support for statements, ideas or conclusions presented in the cited entity"},{"const":"Updates","@id":"cito:updates","description":"The citing entity updates statements, ideas, hypotheses or understanding presented in the cited entity"},{"const":"UsesConclusionsFrom","@id":"cito:usesConclusionsFrom","description":"The citing entity describes work that uses conclusions presented in the cited entity"},{"const":"UsesDataFrom","@id":"cito:usesDataFrom","description":"The citing entity describes work that uses data presented in the cited entity"},{"const":"UsesMethodIn","@id":"cito:usesMethodIn","description":"The citing entity describes work that uses a method detailed in the cited entity"}],"required":["type"],"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"}}}"#),
    ("Cite", r#"{"title":"Cite","required":["type","target"],"examples":[{"type":"Article","title":"An example of using the Cite node type","authors":[{"type":"Person","givenNames":["Joe"],"familyNames":["Bloggs"]}],"content":[{"type":"Paragraph","content":["A citation of ",{"type":"Cite","target":"some-one-else-1991"},"."]}],"references":[{"type":"Article","id":"some-one-else-1991","title":"Another article by someone else","authors":[{"type":"Person","givenNames":["Some","One"],"familyNames":["Else"]}],"datePublished":"1991"}]}],"type":"object","additionalProperties":false,"propertyAliases":{},"properties":{"id":{"type":"string"},"citationMode":{"type":"string","enum":["Parenthetical","Narrative","NarrativeAuthor","NarrativeYear","normal","suppressAuthor"],"default":"parenthetical"},"citationIntent":{"type":"array","items":{"$ref":"CitationIntentEnumeration.schema.json"}},"content":{"type":"array","items":{"$ref":"InlineContent.schema.json"}},"pageStart":{"anyOf":[{"type":"integer"},{"type":"string"}]},"pageEnd":{"anyOf":[{"type":"integer"},{"type":"string"}]},"pagination":{"type":"string"},"citationPrefix":{"type":"string"},"citationSuffix":{"type":"string"},"target":{"type":"string"}}}"#),
    ("CiteGroup", r#"{"title":"CiteGroup","required":["type","items"],"examples":[{"type":"Article","title":"An example of using the CiteGroup node type","authors":[{"type":"Person","givenNames":["Joe"],"familyNames":["Bloggs"]}],"content":[{"type":"Paragraph","content":["Citing two articles ",{"type":"CiteGroup","items":[{"type":"Cite","target":"some-one-else-1991"},{"type":"Cite","target":"updated-works-2009"}]},"."]}],"references":[{"type":"Article","id":"some-one-else-1991","title":"Another article by someone else","authors":[{"type":"Person","givenNames":["Some","One"],"familyNames":["Else"]}],"datePublished":"1991"},{"type":"Article","id":"update-works-2009","title":"A Better Updated Work","authors":[{"type":"Person","givenNames":["Some","Better"],"familyNames":["Person"]}],"datePublished":"2009"}]}],"type":"object","propertyAliases":{"item":"items"},"additionalProperties":false,"properties":{"id":{"type":"string"},"items":{"type":"array","items":{"$ref":"Cite.schema.json"},"aliases":["item"]}}}"#),
    ("Claim", r#"{"title":"Claim","required":["type","content"],"type":"object","additionalProperties":false,"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"type":"array","items":{"$ref":"BlockContent.schema.json"},"isOverride":true},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"claimType":{"type":"string","enum":["Statement","Theorem","Lemma","Proof","Postulate","Hypothesis","Proposition","Corollary"]},"label":{"type":"string"}}}"#),
    ("Code", r#"{"title":"Code","required":["type","text"],"type":"object","propertyAliases":{"encodingFormat":"mediaType"},"additionalProperties":false,"properties":{"id":{"type":"string"},"text":{"type":"string"},"programmingLanguage":{"type":"string"},"mediaType":{"aliases":["encodingFormat"],"type":"string"}}}"#),
    ("CodeBlock", r#"{"title":"CodeBlock","type":"object","additionalProperties":false,"required":["type","text"],"propertyAliases":{"encodingFormat":"mediaType"},"properties":{"id":{"type":"string"},"text":{"type":"string"},"programmingLanguage":{"type":"string"},"mediaType":{"aliases":["encodingFormat"],"type":"string"}}}"#),
    ("CodeChunk", r#"{"title":"CodeChunk","examples":[{"type":"CodeChunk","programmingLanguage":"python","text":"print('Hello world!')"}],"type":"object","propertyAliases":{"encodingFormat":"mediaType","error":"errors","output":"outputs"},"additionalProperties":false,"required":["type","text","programmingLanguage"],"properties":{"id":{"type":"string"},"text":{"type":"string"},"programmingLanguage":{"type":"string","isOverride":true},"mediaType":{"aliases":["encodingFormat"],"type":"string"},"compileDigest":{"type":"string"},"executeDigest":{"type":"string"},"errors":{"type":"array","items":{"$ref":"CodeError.schema.json"},"aliases":["error"]},"duration":{"type":"number","minimum":0},"label":{"type":"string"},"caption":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"string"}]},"outputs":{"type":"array","items":{"$ref":"Node.schema.json"},"aliases":["output"]}}}"#),
    ("CodeError", r#"{"title":"CodeError","required":["type","errorMessage"],"type":"object","propertyAliases":{"message":"errorMessage","trace":"stackTrace"},"additionalProperties":false,"properties":{"id":{"type":"string"},"errorType":{"type":"string"},"errorMessage":{"aliases":["message"],"type":"string"},"stackTrace":{"aliases":["trace"],"type":"string"}}}"#),
    ("CodeExecutable", r#"{"title":"CodeExecutable","required":["type","text","programmingLanguage"],"type":"object","propertyAliases":{"encodingFormat":"mediaType","error":"errors"},"additionalProperties":false,"properties":{"id":{"type":"string"},"text":{"type":"string"},"programmingLanguage":{"type":"string","isOverride":true},"mediaType":{"aliases":["encodingFormat"],"type":"string"},"compileDigest":{"type":"string"},"executeDigest":{"type":"string"},"errors":{"type":"array","items":{"$ref":"CodeError.schema.json"},"aliases":["error"]},"duration":{"type":"number","minimum":0}}}"#),
    ("CodeExecutableTypes", r#"{"title":"CodeExecutableTypes","anyOf":[{"$ref":"CodeExecutable.schema.json"},{"$ref":"CodeChunk.schema.json"},{"$ref":"CodeExpression.schema.json"}]}"#),
    ("CodeExpression", r#"{"title":"CodeExpression","type":"object","additionalProperties":false,"required":["type","text","programmingLanguage"],"propertyAliases":{"encodingFormat":"mediaType","error":"errors"},"properties":{"id":{"type":"string"},"text":{"type":"string"},"programmingLanguage":{"type":"string","isOverride":true},"mediaType":{"aliases":["encodingFormat"],"type":"string"},"compileDigest":{"type":"string"},"executeDigest":{"type":"string"},"errors":{"type":"array","items":{"$ref":"CodeError.schema.json"},"aliases":["error"]},"duration":{"type":"number","minimum":0},"output":{"allOf":[{"$ref":"Node.schema.json"}]}}}"#),
    ("CodeFragment", r#"{"title":"CodeFragment","type":"object","additionalProperties":false,"required":["type","text"],"propertyAliases":{"encodingFormat":"mediaType"},"properties":{"id":{"type":"string"},"text":{"type":"string"},"programmingLanguage":{"type":"string"},"mediaType":{"aliases":["encodingFormat"],"type":"string"}}}"#),
    ("CodeTypes", r#"{"title":"CodeTypes","anyOf":[{"$ref":"Code.schema.json"},{"$ref":"CodeBlock.schema.json"},{"$ref":"CodeChunk.schema.json"},{"$ref":"CodeExecutable.schema.json"},{"$ref":"CodeExpression.schema.json"},{"$ref":"CodeFragment.schema.json"}]}"#),
    ("Collection", r#"{"title":"Collection","required":["type","parts"],"type":"object","additionalProperties":false,"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"},"isOverride":true},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]}}}"#),
    ("Comment", r#"{"title":"Comment","type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"parentItem":{"$ref":"Comment.schema.json"},"commentAspect":{"type":"string"}}}"#),
    ("ConstantValidator", r#"{"title":"ConstantValidator","type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{},"properties":{"id":{"type":"string"},"value":{"allOf":[{"$ref":"Node.schema.json"}]}}}"#),
    ("ContactPoint", r#"{"title":"ContactPoint","examples":[{"type":"ContactPoint","availableLanguages":["English","Māori"],"emails":["welcome@example.org"],"telephone":"00641234567"}],"type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","availableLanguage":"availableLanguages","email":"emails","telephone":"telephoneNumbers","telephoneNumber":"telephoneNumbers"},"additionalProperties":false,"required":["type"],"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"availableLanguages":{"type":"array","items":{"type":"string"},"aliases":["availableLanguage"]},"emails":{"type":"array","items":{"type":"string","format":"email"},"aliases":["email"]},"telephoneNumbers":{"aliases":["telephone","telephoneNumber"],"type":"array","items":{"type":"string"}}}}"#),
    ("ContactPointTypes", r#"{"title":"ContactPointTypes","anyOf":[{"$ref":"ContactPoint.schema.json"},{"$ref":"PostalAddress.schema.json"}]}"#),
    ("CreativeWork", r#"{"title":"CreativeWork","type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title"},"additionalProperties":false,"required":["type"],"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]}}}"#),
    ("CreativeWorkTypes", r#"{"title":"CreativeWorkTypes","anyOf":[{"$ref":"CreativeWork.schema.json"},{"$ref":"Article.schema.json"},{"$ref":"AudioObject.schema.json"},{"$ref":"Claim.schema.json"},{"$ref":"Collection.schema.json"},{"$ref":"Comment.schema.json"},{"$ref":"Datatable.schema.json"},{"$ref":"Figure.schema.json"},{"$ref":"ImageObject.schema.json"},{"$ref":"MediaObject.schema.json"},{"$ref":"Periodical.schema.json"},{"$ref":"PublicationIssue.schema.json"},{"$ref":"PublicationVolume.schema.json"},{"$ref":"Review.schema.json"},{"$ref":"SoftwareApplication.schema.json"},{"$ref":"SoftwareSourceCode.schema.json"},{"$ref":"Table.schema.json"},{"$ref":"VideoObject.schema.json"}]}"#),
    ("Datatable", r#"{"title":"Datatable","required":["type","columns"],"type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title","column":"columns"},"additionalProperties":false,"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"columns":{"type":"array","items":{"$ref":"DatatableColumn.schema.json"},"aliases":["column"]}}}"#),
    ("DatatableColumn", r#"{"title":"DatatableColumn","required":["type","name","values"],"type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","value":"values"},"additionalProperties":false,"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string","isOverride":true},"url":{"type":"string","format":"uri"},"validator":{"allOf":[{"$ref":"ArrayValidator.schema.json"}]},"values":{"type":"array","items":{"$ref":"Node.schema.json"},"aliases":["value"]}}}"#),
    ("Date", r#"{"title":"Date","parser":"date","required":["type","value"],"type":"object","additionalProperties":false,"propertyAliases":{},"properties":{"id":{"type":"string"},"value":{"anyOf":[{"type":"string","format":"date-time"},{"type":"string","format":"date"},{"type":"string","pattern":"\\d{4}"}]}}}"#),
    ("DefinedTerm", r#"{"title":"DefinedTerm","required":["type","name"],"type":"object","additionalProperties":false,"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string","isOverride":true},"url":{"type":"string","format":"uri"},"termCode":{"type":"string"}}}"#),
    ("Delete", r#"{"title":"Delete","examples":[{"type":"Paragraph","content":["The following is ",{"type":"Delete","content":["marked for deletion"]},"."]}],"type":"object","additionalProperties":false,"required":["type","content"],"propertyAliases":{},"properties":{"id":{"type":"string"},"content":{"type":"array","items":{"$ref":"InlineContent.schema.json"}}}}"#),
    ("Emphasis", r#"{"title":"Emphasis","examples":[{"type":"Paragraph","content":["The following content has extra ",{"type":"Emphasis","content":["emphasis"]}]}],"type":"object","additionalProperties":false,"required":["type","content"],"propertyAliases":{},"properties":{"id":{"type":"string"},"content":{"type":"array","items":{"$ref":"InlineContent.schema.json"}}}}"#),
    ("Entity", r#"{"title":"Entity","required":["type"],"type":"object","additionalProperties":false,"properties":{"id":{"type":"string"}}}"#),
    ("EntityTypes", r#"{"title":"EntityTypes","anyOf":[{"$ref":"Entity.schema.json"},{"$ref":"ArrayValidator.schema.json"},{"$ref":"Article.schema.json"},{"$ref":"AudioObject.schema.json"},{"$ref":"BooleanValidator.schema.json"},{"$ref":"Brand.schema.json"},{"$ref":"CitationIntentEnumeration.schema.json"},{"$ref":"Cite.schema.json"},{"$ref":"CiteGroup.schema.json"},{"$ref":"Claim.schema.json"},{"$ref":"Code.schema.json"},{"$ref":"CodeBlock.schema.json"},{"$ref":"CodeChunk.schema.json"},{"$ref":"CodeError.schema.json"},{"$ref":"CodeExecutable.schema.json"},{"$ref":"CodeExpression.schema.json"},{"$ref":"CodeFragment.schema.json"},{"$ref":"Collection.schema.json"},{"$ref":"Comment.schema.json"},{"$ref":"ConstantValidator.schema.json"},{"$ref":"ContactPoint.schema.json"},{"$ref":"CreativeWork.schema.json"},{"$ref":"Datatable.schema.json"},{"$ref":"DatatableColumn.schema.json"},{"$ref":"Date.schema.json"},{"$ref":"DefinedTerm.schema.json"},{"$ref":"Delete.schema.json"},{"$ref":"Emphasis.schema.json"},{"$ref":"EnumValidator.schema.json"},{"$ref":"Enumeration.schema.json"},{"$ref":"Figure.schema.json"},{"$ref":"Function.schema.json"},{"$ref":"Grant.schema.json"},{"$ref":"Heading.schema.json"},{"$ref":"ImageObject.schema.json"},{"$ref":"Include.schema.json"},{"$ref":"IntegerValidator.schema.json"},{"$ref":"Link.schema.json"},{"$ref":"List.schema.json"},{"$ref":"ListItem.schema.json"},{"$ref":"Mark.schema.json"},{"$ref":"Math.schema.json"},{"$ref":"MathBlock.schema.json"},{"$ref":"MathFragment.schema.json"},{"$ref":"MediaObject.schema.json"},{"$ref":"MonetaryGrant.schema.json"},{"$ref":"NontextualAnnotation.schema.json"},{"$ref":"Note.schema.json"},{"$ref":"NumberValidator.schema.json"},{"$ref":"Organization.schema.json"},{"$ref":"Paragraph.schema.json"},{"$ref":"Parameter.schema.json"},{"$ref":"Periodical.schema.json"},{"$ref":"Person.schema.json"},{"$ref":"PostalAddress.schema.json"},{"$ref":"Product.schema.json"},{"$ref":"PropertyValue.schema.json"},{"$ref":"PublicationIssue.schema.json"},{"$ref":"PublicationVolume.schema.json"},{"$ref":"Quote.schema.json"},{"$ref":"QuoteBlock.schema.json"},{"$ref":"Review.schema.json"},{"$ref":"SoftwareApplication.schema.json"},{"$ref":"SoftwareEnvironment.schema.json"},{"$ref":"SoftwareSession.schema.json"},{"$ref":"SoftwareSourceCode.schema.json"},{"$ref":"StringValidator.schema.json"},{"$ref":"Strong.schema.json"},{"$ref":"Subscript.schema.json"},{"$ref":"Superscript.schema.json"},{"$ref":"Table.schema.json"},{"$ref":"TableCell.schema.json"},{"$ref":"TableRow.schema.json"},{"$ref":"ThematicBreak.schema.json"},{"$ref":"Thing.schema.json"},{"$ref":"TupleValidator.schema.json"},{"$ref":"Validator.schema.json"},{"$ref":"Variable.schema.json"},{"$ref":"VideoObject.schema.json"},{"$ref":"VolumeMount.schema.json"}]}"#),
    ("EnumValidator", r#"{"title":"EnumValidator","type":"object","propertyAliases":{"value":"values"},"additionalProperties":false,"required":["type"],"properties":{"id":{"type":"string"},"values":{"type":"array","items":{"$ref":"Node.schema.json"},"aliases":["value"]}}}"#),
    ("Enumeration", r#"{"title":"Enumeration","required":["type"],"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"}}}"#),
    ("EnumerationTypes", r#"{"title":"EnumerationTypes","anyOf":[{"$ref":"Enumeration.schema.json"},{"$ref":"CitationIntentEnumeration.schema.json"}]}"#),
    ("Figure", r#"{"title":"Figure","type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"caption":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"string"}]},"label":{"type":"string"}}}"#),
    ("Function", r#"{"title":"Function","type":"object","propertyAliases":{"parameter":"parameters"},"additionalProperties":false,"required":["type"],"properties":{"id":{"type":"string"},"name":{"type":"string","pattern":"[a-z_][A-z0-9_]*"},"parameters":{"type":"array","items":{"$ref":"Parameter.schema.json"},"aliases":["parameter"]},"returns":{"allOf":[{"$ref":"ValidatorTypes.schema.json"}]}}}"#),
    ("Grant", r#"{"title":"Grant","type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","fundedItem":"fundedItems","sponsor":"sponsors"},"additionalProperties":false,"required":["type"],"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"fundedItems":{"type":"array","items":{"$ref":"Thing.schema.json"},"aliases":["fundedItem"]},"sponsors":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["sponsor"]}}}"#),
    ("GrantTypes", r#"{"title":"GrantTypes","anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}"#),
    ("Heading", r#"{"title":"Heading","required":["type","content"],"examples":[{"type":"Heading","depth":2,"content":["Secondary Heading"]}],"type":"object","additionalProperties":false,"propertyAliases":{},"properties":{"id":{"type":"string"},"depth":{"type":"integer","default":1,"minimum":1,"maximum":6},"content":{"type":"array","items":{"$ref":"InlineContent.schema.json"}}}}"#),
    ("ImageObject", r#"{"title":"ImageObject","examples":[{"type":"ImageObject","caption":"Kiwi","contentSize":"10.4","contentUrl":"http://www.example.com/kiwi.png","encodingFormat":"image/png","thumbnail":{"type":"ImageObject","contentUrl":"http://www.example.com/kiwi_mini.png"}}],"type":"object","additionalProperties":false,"required":["type","contentUrl"],"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title","encodingFormat":"mediaType"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"bitrate":{"type":"number"},"contentSize":{"type":"number"},"contentUrl":{"type":"string"},"embedUrl":{"type":"string"},"mediaType":{"aliases":["encodingFormat"],"type":"string","pattern":"^[a-z]+(\\/[a-z\\+\\-]+)$"},"caption":{"type":"string"},"thumbnail":{"allOf":[{"$ref":"ImageObject.schema.json"}]}}}"#),
    ("Include", r#"{"title":"Include","required":["type","source"],"type":"object","propertyAliases":{"encodingFormat":"mediaType"},"additionalProperties":false,"properties":{"id":{"type":"string"},"source":{"type":"string"},"mediaType":{"aliases":["encodingFormat"],"type":"string"},"buildDigest":{"type":"string"},"content":{"type":"array","items":{"$ref":"BlockContent.schema.json"}}}}"#),
    ("InlineContent", r#"{"title":"InlineContent","anyOf":[{"$ref":"AudioObject.schema.json"},{"$ref":"Cite.schema.json"},{"$ref":"CiteGroup.schema.json"},{"$ref":"CodeExpression.schema.json"},{"$ref":"CodeFragment.schema.json"},{"$ref":"Delete.schema.json"},{"$ref":"Emphasis.schema.json"},{"$ref":"ImageObject.schema.json"},{"$ref":"Link.schema.json"},{"$ref":"MathFragment.schema.json"},{"$ref":"NontextualAnnotation.schema.json"},{"$ref":"Note.schema.json"},{"$ref":"Parameter.schema.json"},{"$ref":"Quote.schema.json"},{"$ref":"Strong.schema.json"},{"$ref":"Subscript.schema.json"},{"$ref":"Superscript.schema.json"},{"$ref":"VideoObject.schema.json"},{"$ref":"Null.schema.json"},{"$ref":"Boolean.schema.json"},{"$ref":"Integer.schema.json"},{"$ref":"Number.schema.json"},{"$ref":"String.schema.json"}]}"#),
    ("Integer", r#"{"title":"Integer","type":"integer"}"#),
    ("IntegerValidator", r#"{"title":"IntegerValidator","type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{},"properties":{"id":{"type":"string"}}}"#),
    ("Link", r#"{"title":"Link","required":["type","content","target"],"examples":[{"type":"Link","content":["Stencila’s website"],"target":"https://stenci.la"}],"type":"object","propertyAliases":{"export":"exportFrom","import":"importTo"},"additionalProperties":false,"properties":{"id":{"type":"string"},"content":{"type":"array","items":{"$ref":"InlineContent.schema.json"}},"exportFrom":{"aliases":["export"],"type":"string"},"importTo":{"aliases":["import"],"type":"string"},"target":{"type":"string","format":"uri-reference"},"title":{"type":"string"},"relation":{"type":"string"}}}"#),
    ("List", r#"{"title":"List","required":["type","items"],"examples":[{"type":"List","items":[{"type":"ListItem","content":["Item One"]},{"type":"ListItem","content":["Item Two"]},{"type":"ListItem","content":["Item Three"]}]},{"type":"List","items":[{"type":"ListItem","content":"Item One"},{"type":"ListItem","content":["This is a nested item",{"type":"List","order":"ordered","items":[{"type":"ListItem","content":["Nested Item One"]},{"type":"ListItem","content":["Nested Item Two"]},{"type":"ListItem","content":["Nested Item Three"]}]}]},{"type":"ListItem","content":["Item Three"]}]},{"type":"List","items":[{"type":"ListItem","checked":false,"content":["Todo item"]},{"type":"ListItem","checked":true,"content":["Completed todo item"]}]}],"type":"object","propertyAliases":{"item":"items"},"additionalProperties":false,"properties":{"id":{"type":"string"},"items":{"type":"array","items":{"$ref":"ListItem.schema.json"},"aliases":["item"]},"order":{"enum":["Ascending","Descending","Unordered"],"default":"unordered"}}}"#),
    ("ListItem", r#"{"title":"ListItem","examples":[{"type":"ListItem","content":["List Item Content"]},{"type":"ListItem","content":["List Item Content",{"type":"List","order":"ordered","items":["Nested Item One"]}]},{"type":"ListItem","isChecked":true,"content":["Completed todo item"]}],"type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"content":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"}}]},"isChecked":{"type":"boolean","default":false},"item":{"allOf":[{"$ref":"Node.schema.json"}]},"position":{"type":"integer"}}}"#),
    ("Mark", r#"{"title":"Mark","required":["type","content"],"type":"object","additionalProperties":false,"propertyAliases":{},"properties":{"id":{"type":"string"},"content":{"type":"array","items":{"$ref":"InlineContent.schema.json"}}}}"#),
    ("MarkTypes", r#"{"title":"MarkTypes","anyOf":[{"$ref":"Mark.schema.json"},{"$ref":"Delete.schema.json"},{"$ref":"Emphasis.schema.json"},{"$ref":"NontextualAnnotation.schema.json"},{"$ref":"Quote.schema.json"},{"$ref":"Strong.schema.json"},{"$ref":"Subscript.schema.json"},{"$ref":"Superscript.schema.json"}]}"#),
    ("Math", r#"{"title":"Math","required":["type","text"],"type":"object","propertyAliases":{"error":"errors"},"additionalProperties":false,"properties":{"id":{"type":"string"},"errors":{"type":"array","items":{"type":"string"},"aliases":["error"]},"mathLanguage":{"type":"string","default":"tex"},"text":{"type":"string"}}}"#),
    ("MathBlock", r#"{"title":"MathBlock","type":"object","additionalProperties":false,"required":["type","text"],"propertyAliases":{"error":"errors"},"properties":{"id":{"type":"string"},"errors":{"type":"array","items":{"type":"string"},"aliases":["error"]},"mathLanguage":{"type":"string","default":"tex"},"text":{"type":"string"},"label":{"type":"string"}}}"#),
    ("MathFragment", r#"{"title":"MathFragment","type":"object","additionalProperties":false,"required":["type","text"],"propertyAliases":{"error":"errors"},"properties":{"id":{"type":"string"},"errors":{"type":"array","items":{"type":"string"},"aliases":["error"]},"mathLanguage":{"type":"string","default":"tex"},"text":{"type":"string"}}}"#),
    ("MathTypes", r#"{"title":"MathTypes","anyOf":[{"$ref":"Math.schema.json"},{"$ref":"MathBlock.schema.json"},{"$ref":"MathFragment.schema.json"}]}"#),
    ("MediaObject", r#"{"title":"MediaObject","required":["type","contentUrl"],"examples":[{"type":"MediaObject","bitrate":"44","contentSize":"2","contentUrl":"http://www.example.com/file.mp3","encodingFormat":"audio/mpeg3","embedUrl":"http://www.example.com/full_size/file.mp3"}],"type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title","encodingFormat":"mediaType"},"additionalProperties":false,"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"bitrate":{"type":"number"},"contentSize":{"type":"number"},"contentUrl":{"type":"string"},"embedUrl":{"type":"string"},"mediaType":{"aliases":["encodingFormat"],"type":"string","pattern":"^[a-z]+(\\/[a-z\\+\\-]+)$"}}}"#),
    ("MediaObjectTypes", r#"{"title":"MediaObjectTypes","anyOf":[{"$ref":"MediaObject.schema.json"},{"$ref":"AudioObject.schema.json"},{"$ref":"ImageObject.schema.json"},{"$ref":"VideoObject.schema.json"}]}"#),
    ("MonetaryGrant", r#"{"title":"MonetaryGrant","type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","fundedItem":"fundedItems","sponsor":"sponsors","funder":"funders"},"additionalProperties":false,"required":["type"],"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"fundedItems":{"type":"array","items":{"$ref":"Thing.schema.json"},"aliases":["fundedItem"]},"sponsors":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["sponsor"]},"amounts":{"type":"number"},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]}}}"#),
    ("Node", r#"{"title":"Node","anyOf":[{"$ref":"Entity.schema.json"},{"$ref":"ArrayValidator.schema.json"},{"$ref":"Article.schema.json"},{"$ref":"AudioObject.schema.json"},{"$ref":"BooleanValidator.schema.json"},{"$ref":"Brand.schema.json"},{"$ref":"CitationIntentEnumeration.schema.json"},{"$ref":"Cite.schema.json"},{"$ref":"CiteGroup.schema.json"},{"$ref":"Claim.schema.json"},{"$ref":"Code.schema.json"},{"$ref":"CodeBlock.schema.json"},{"$ref":"CodeChunk.schema.json"},{"$ref":"CodeError.schema.json"},{"$ref":"CodeExecutable.schema.json"},{"$ref":"CodeExpression.schema.json"},{"$ref":"CodeFragment.schema.json"},{"$ref":"Collection.schema.json"},{"$ref":"Comment.schema.json"},{"$ref":"ConstantValidator.schema.json"},{"$ref":"ContactPoint.schema.json"},{"$ref":"CreativeWork.schema.json"},{"$ref":"Datatable.schema.json"},{"$ref":"DatatableColumn.schema.json"},{"$ref":"Date.schema.json"},{"$ref":"DefinedTerm.schema.json"},{"$ref":"Delete.schema.json"},{"$ref":"Emphasis.schema.json"},{"$ref":"EnumValidator.schema.json"},{"$ref":"Enumeration.schema.json"},{"$ref":"Figure.schema.json"},{"$ref":"Function.schema.json"},{"$ref":"Grant.schema.json"},{"$ref":"Heading.schema.json"},{"$ref":"ImageObject.schema.json"},{"$ref":"Include.schema.json"},{"$ref":"IntegerValidator.schema.json"},{"$ref":"Link.schema.json"},{"$ref":"List.schema.json"},{"$ref":"ListItem.schema.json"},{"$ref":"Mark.schema.json"},{"$ref":"Math.schema.json"},{"$ref":"MathBlock.schema.json"},{"$ref":"MathFragment.schema.json"},{"$ref":"MediaObject.schema.json"},{"$ref":"MonetaryGrant.schema.json"},{"$ref":"NontextualAnnotation.schema.json"},{"$ref":"Note.schema.json"},{"$ref":"NumberValidator.schema.json"},{"$ref":"Organization.schema.json"},{"$ref":"Paragraph.schema.json"},{"$ref":"Parameter.schema.json"},{"$ref":"Periodical.schema.json"},{"$ref":"Person.schema.json"},{"$ref":"PostalAddress.schema.json"},{"$ref":"Product.schema.json"},{"$ref":"PropertyValue.schema.json"},{"$ref":"PublicationIssue.schema.json"},{"$ref":"PublicationVolume.schema.json"},{"$ref":"Quote.schema.json"},{"$ref":"QuoteBlock.schema.json"},{"$ref":"Review.schema.json"},{"$ref":"SoftwareApplication.schema.json"},{"$ref":"SoftwareEnvironment.schema.json"},{"$ref":"SoftwareSession.schema.json"},{"$ref":"SoftwareSourceCode.schema.json"},{"$ref":"StringValidator.schema.json"},{"$ref":"Strong.schema.json"},{"$ref":"Subscript.schema.json"},{"$ref":"Superscript.schema.json"},{"$ref":"Table.schema.json"},{"$ref":"TableCell.schema.json"},{"$ref":"TableRow.schema.json"},{"$ref":"ThematicBreak.schema.json"},{"$ref":"Thing.schema.json"},{"$ref":"TupleValidator.schema.json"},{"$ref":"Validator.schema.json"},{"$ref":"Variable.schema.json"},{"$ref":"VideoObject.schema.json"},{"$ref":"VolumeMount.schema.json"},{"$ref":"Null.schema.json"},{"$ref":"Boolean.schema.json"},{"$ref":"Integer.schema.json"},{"$ref":"Number.schema.json"},{"$ref":"String.schema.json"},{"$ref":"Object.schema.json"},{"$ref":"Array.schema.json"}]}"#),
    ("NontextualAnnotation", r#"{"title":"NontextualAnnotation","type":"object","additionalProperties":false,"required":["type","content"],"propertyAliases":{},"properties":{"id":{"type":"string"},"content":{"type":"array","items":{"$ref":"InlineContent.schema.json"}}}}"#),
    ("Note", r#"{"title":"Note","required":["type","content"],"type":"object","additionalProperties":false,"propertyAliases":{},"properties":{"id":{"type":"string"},"noteType":{"type":"string","enum":["Footnote","Endnote","Sidenote"]},"content":{"type":"array","items":{"$ref":"BlockContent.schema.json"}}}}"#),
    ("Null", r#"{"title":"Null","type":"null"}"#),
    ("Number", r#"{"title":"Number","type":"number"}"#),
    ("NumberValidator", r#"{"title":"NumberValidator","type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{},"properties":{"id":{"type":"string"},"minimum":{"type":"number"},"exclusiveMinimum":{"type":"number"},"maximum":{"type":"number"},"exclusiveMaximum":{"type":"number"},"multipleOf":{"type":"number","exclusiveMinimum":0}}}"#),
    ("Object", r#"{"title":"Object","type":"object"}"#),
    ("Organization", r#"{"title":"Organization","examples":[{"type":"Organization","address":"Sciences Building, Dunedin, New Zealand","legalName":"Department of Natural Sciences","parentOrganization":{"type":"Organization","legalName":"The University of Otago"}},{"type":"Organization","address":"362 Leith Street, Dunedin 9054, New Zealand","brands":[{"type":"Brand","logo":"http://www.otago.ac.nz/logo"}],"contactPoints":[{"type":"ContactPoint","availableLanguages":["English","Māori"],"emails":["office@otago.ac.nz"],"telephone":"00641234567"}],"departments":[{"type":"Organization","legalName":"Commerce"},{"type":"Organization","legalName":"Health_Sciences"},{"type":"Organization","legalName":"Humanities"}],"funders":[{"type":"Organization","legalName":"MBIE"},{"type":"Organization","legalName":"CancerSociety"}],"legalName":"The University of Otago"}],"type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","brand":"brands","contactPoint":"contactPoints","department":"departments","funder":"funders","member":"members"},"additionalProperties":false,"required":["type"],"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"address":{"anyOf":[{"$ref":"PostalAddress.schema.json"},{"type":"string"}]},"brands":{"type":"array","items":{"$ref":"Brand.schema.json"},"aliases":["brand"]},"contactPoints":{"type":"array","items":{"$ref":"ContactPoint.schema.json"},"aliases":["contactPoint"]},"departments":{"type":"array","items":{"$ref":"Organization.schema.json"},"aliases":["department"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Organization.schema.json"},{"$ref":"Person.schema.json"}]},"aliases":["funder"]},"legalName":{"type":"string","pattern":"[a-zA-Z]"},"logo":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"members":{"type":"array","items":{"anyOf":[{"$ref":"Organization.schema.json"},{"$ref":"Person.schema.json"}]},"aliases":["member"]},"parentOrganization":{"allOf":[{"$ref":"Organization.schema.json"}]}}}"#),
    ("Paragraph", r#"{"title":"Paragraph","required":["type","content"],"examples":[{"type":"Paragraph","content":["Some text content representing ideas expressed as words."]},{"type":"Paragraph","content":["Some text with some",{"type":"Emphasis","content":["emphasized words"]}," and ",{"type":"Strong","content":["some strongly emphasized words"]}]}],"type":"object","additionalProperties":false,"propertyAliases":{},"properties":{"id":{"type":"string"},"content":{"type":"array","items":{"$ref":"InlineContent.schema.json"}}}}"#),
    ("Parameter", r#"{"title":"Parameter","required":["type","name"],"type":"object","additionalProperties":false,"propertyAliases":{},"properties":{"id":{"type":"string"},"name":{"type":"string","pattern":"[a-z_][A-z0-9_]*"},"value":{"allOf":[{"$ref":"Node.schema.json"}]},"default":{"allOf":[{"$ref":"Node.schema.json"}]},"validator":{"allOf":[{"$ref":"ValidatorTypes.schema.json"}]},"executeDigest":{"type":"string"},"isRequired":{"type":"boolean"},"isVariadic":{"type":"boolean"},"isExtensible":{"type":"boolean"}}}"#),
    ("Periodical", r#"{"title":"Periodical","examples":[{"type":"Periodical","title":"Nature","issns":["0028-0836","1476-4687"],"dateStart":"1869-11-04T00:00:00.000Z","url":"https://www.nature.com/"}],"type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title","issn":"issns"},"additionalProperties":false,"required":["type"],"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"dateStart":{"$ref":"Date.schema.json"},"dateEnd":{"$ref":"Date.schema.json"},"issns":{"type":"array","items":{"type":"string"},"aliases":["issn"]}}}"#),
    ("Person", r#"{"title":"Person","parser":"person","examples":[{"type":"Person","honorificPrefix":"Dr","givenNames":["Marie","Skłodowska"],"familyNames":["Curie"],"honorificSuffix":"PhD"}],"type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","affiliation":"affiliations","email":"emails","familyName":"familyNames","surname":"familyNames","surnames":"familyNames","lastName":"familyNames","lastNames":"familyNames","funder":"funders","firstName":"givenNames","firstNames":"givenNames","givenName":"givenNames","prefix":"honorificPrefix","suffix":"honorificSuffix","telephone":"telephoneNumbers","telephoneNumber":"telephoneNumbers"},"additionalProperties":false,"required":["type"],"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"address":{"anyOf":[{"$ref":"PostalAddress.schema.json"},{"type":"string"}]},"affiliations":{"type":"array","items":{"$ref":"Organization.schema.json"},"aliases":["affiliation"]},"emails":{"type":"array","items":{"type":"string","format":"email"},"aliases":["email"]},"familyNames":{"aliases":["familyName","surname","surnames","lastName","lastNames"],"allOf":[{"parser":"ssi"},{"type":"array","items":{"type":"string"}}]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Organization.schema.json"},{"$ref":"Person.schema.json"}]},"aliases":["funder"]},"givenNames":{"aliases":["firstName","firstNames","givenName"],"allOf":[{"parser":"ssi"},{"type":"array","items":{"type":"string"}}]},"honorificPrefix":{"aliases":["prefix"],"type":"string"},"honorificSuffix":{"aliases":["suffix"],"type":"string"},"jobTitle":{"type":"string"},"memberOf":{"type":"array","items":{"$ref":"Organization.schema.json"}},"telephoneNumbers":{"aliases":["telephone","telephoneNumber"],"type":"array","items":{"type":"string"}}}}"#),
    ("PostalAddress", r#"{"title":"PostalAddress","type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","availableLanguage":"availableLanguages","email":"emails","telephone":"telephoneNumbers","telephoneNumber":"telephoneNumbers"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"availableLanguages":{"type":"array","items":{"type":"string"},"aliases":["availableLanguage"]},"emails":{"type":"array","items":{"type":"string","format":"email"},"aliases":["email"]},"telephoneNumbers":{"aliases":["telephone","telephoneNumber"],"type":"array","items":{"type":"string"}},"streetAddress":{"type":"string"},"postOfficeBoxNumber":{"type":"string"},"addressLocality":{"type":"string"},"addressRegion":{"type":"string"},"postalCode":{"type":"string"},"addressCountry":{"type":"string"}}}"#),
    ("Product", r#"{"title":"Product","examples":[{"type":"Product","brand":{"type":"Brand","name":"Astro"},"name":"Astrolabe","logo":{"type":"ImageObject","contentUrl":"http://www.product-astrolabe.com/logo.png","caption":"Astrolabe Logo"},"productID":"AA55"}],"type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","brand":"brands"},"additionalProperties":false,"required":["type"],"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"brands":{"type":"array","items":{"$ref":"Brand.schema.json"},"aliases":["brand"]},"logo":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"productID":{"type":"string"}}}"#),
    ("PropertyValue", r#"{"title":"PropertyValue","required":["type","value"],"type":"object","additionalProperties":false,"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"propertyID":{"type":"string"},"value":{"anyOf":[{"type":"boolean"},{"type":"integer"},{"type":"number"},{"type":"string"}]}}}"#),
    ("PublicationIssue", r#"{"title":"PublicationIssue","examples":[{"type":"PublicationIssue","url":"https://www.nature.com/nature/volumes/571/issues/7766","issueNumber":571,"datePublished":"2019-07-25T00:00:00.000Z","isPartOf":{"type":"PublicationVolume","volumeNumber":571,"isPartOf":{"type":"Periodical","title":"Nature"}}}],"type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"issueNumber":{"anyOf":[{"type":"integer"},{"type":"string"}]},"pageStart":{"anyOf":[{"type":"integer"},{"type":"string"}]},"pageEnd":{"anyOf":[{"type":"integer"},{"type":"string"}]},"pagination":{"type":"string"}}}"#),
    ("PublicationVolume", r#"{"title":"PublicationVolume","examples":[{"type":"PublicationVolume","volumeNumber":571,"isPartOf":{"type":"Periodical","title":"Nature"}}],"type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"pageStart":{"anyOf":[{"type":"integer"},{"type":"string"}]},"pageEnd":{"anyOf":[{"type":"integer"},{"type":"string"}]},"pagination":{"type":"string"},"volumeNumber":{"anyOf":[{"type":"integer"},{"type":"string"}]}}}"#),
    ("Quote", r#"{"title":"Quote","type":"object","additionalProperties":false,"required":["type","content"],"propertyAliases":{},"properties":{"id":{"type":"string"},"content":{"type":"array","items":{"$ref":"InlineContent.schema.json"}},"cite":{"anyOf":[{"$ref":"Cite.schema.json"},{"type":"string","format":"uri"}]}}}"#),
    ("QuoteBlock", r#"{"title":"QuoteBlock","required":["type","content"],"type":"object","additionalProperties":false,"propertyAliases":{},"properties":{"id":{"type":"string"},"cite":{"anyOf":[{"$ref":"Cite.schema.json"},{"type":"string","format":"uri"}]},"content":{"type":"array","items":{"$ref":"BlockContent.schema.json"}}}}"#),
    ("Review", r#"{"title":"Review","type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"itemReviewed":{"$ref":"Thing.schema.json"},"reviewAspect":{"type":"string"}}}"#),
    ("SoftwareApplication", r#"{"title":"SoftwareApplication","type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title","softwareRequirement":"softwareRequirements"},"additionalProperties":false,"required":["type"],"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"softwareRequirements":{"type":"array","items":{"$ref":"SoftwareApplication.schema.json"},"aliases":["softwareRequirement"]},"softwareVersion":{"type":"string"}}}"#),
    ("SoftwareEnvironment", r#"{"title":"SoftwareEnvironment","required":["type","name"],"type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","extend":"extends","add":"adds","remove":"removes"},"additionalProperties":false,"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string","isOverride":true},"url":{"type":"string","format":"uri"},"extends":{"type":"array","items":{"$ref":"SoftwareEnvironment.schema.json"},"aliases":["extend"]},"adds":{"type":"array","items":{"$ref":"SoftwareSourceCode.schema.json"},"aliases":["add"]},"removes":{"type":"array","items":{"$ref":"SoftwareSourceCode.schema.json"},"aliases":["remove"]}}}"#),
    ("SoftwareSession", r#"{"title":"SoftwareSession","type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","volumeMount":"volumeMounts"},"additionalProperties":false,"required":["type"],"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"environment":{"allOf":[{"$ref":"SoftwareEnvironment.schema.json"}]},"dateStart":{"allOf":[{"$ref":"Date.schema.json"}]},"dateEnd":{"allOf":[{"$ref":"Date.schema.json"}]},"status":{"enum":["Unknown","Starting","Started","Stopping","Stopped","Failed"]},"clientsRequest":{"type":"number","minimum":0},"clientsLimit":{"type":"number","minimum":0},"durationRequest":{"type":"number","minimum":0},"durationLimit":{"type":"number","minimum":0},"timeoutRequest":{"type":"number","minimum":0},"timeoutLimit":{"type":"number","minimum":0},"cpuRequest":{"type":"number","minimum":0},"cpuLimit":{"type":"number","minimum":0},"memoryRequest":{"type":"number","minimum":0},"memoryLimit":{"type":"number","minimum":0},"networkTransferRequest":{"type":"number","minimum":0},"networkTransferLimit":{"type":"number","minimum":0},"volumeMounts":{"type":"array","items":{"$ref":"VolumeMount.schema.json"},"aliases":["volumeMount"]}}}"#),
    ("SoftwareSourceCode", r#"{"title":"SoftwareSourceCode","type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title","softwareRequirement":"softwareRequirements","targetProduct":"targetProducts"},"additionalProperties":false,"required":["type"],"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"codeRepository":{"type":"string","format":"uri"},"codeSampleType":{"type":"string"},"programmingLanguage":{"type":"string"},"runtimePlatform":{"type":"array","items":{"type":"string"}},"softwareRequirements":{"type":"array","items":{"anyOf":[{"$ref":"SoftwareSourceCode.schema.json"},{"$ref":"SoftwareApplication.schema.json"},{"type":"string"}]},"aliases":["softwareRequirement"]},"targetProducts":{"type":"array","items":{"$ref":"SoftwareApplication.schema.json"},"aliases":["targetProduct"]}}}"#),
    ("String", r#"{"title":"String","type":"string"}"#),
    ("StringValidator", r#"{"title":"StringValidator","type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{},"properties":{"id":{"type":"string"},"minLength":{"type":"integer","minimum":0},"maxLength":{"type":"integer","minimum":0},"pattern":{"type":"string"}}}"#),
    ("Strong", r#"{"title":"Strong","type":"object","additionalProperties":false,"required":["type","content"],"propertyAliases":{},"properties":{"id":{"type":"string"},"content":{"type":"array","items":{"$ref":"InlineContent.schema.json"}}}}"#),
    ("Subscript", r#"{"title":"Subscript","type":"object","additionalProperties":false,"required":["type","content"],"propertyAliases":{},"properties":{"id":{"type":"string"},"content":{"type":"array","items":{"$ref":"InlineContent.schema.json"}}}}"#),
    ("Superscript", r#"{"title":"Superscript","type":"object","additionalProperties":false,"required":["type","content"],"propertyAliases":{},"properties":{"id":{"type":"string"},"content":{"type":"array","items":{"$ref":"InlineContent.schema.json"}}}}"#),
    ("Table", r#"{"title":"Table","required":["type","rows"],"type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title","row":"rows"},"additionalProperties":false,"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"caption":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"string"}]},"label":{"type":"string"},"rows":{"type":"array","items":{"$ref":"TableRow.schema.json"},"aliases":["row"]}}}"#),
    ("TableCell", r#"{"title":"TableCell","type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{},"properties":{"id":{"type":"string"},"name":{"type":"string"},"colspan":{"type":"integer","minimum":0,"maximum":1000,"default":1},"cellType":{"type":"string","enum":["Data","Header"],"default":"data"},"rowspan":{"type":"integer","minimum":0,"maximum":65534,"default":1},"content":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"}}]}}}"#),
    ("TableRow", r#"{"title":"TableRow","required":["type","cells"],"type":"object","propertyAliases":{"cell":"cells"},"additionalProperties":false,"properties":{"id":{"type":"string"},"cells":{"type":"array","items":{"$ref":"TableCell.schema.json"},"aliases":["cell"]},"rowType":{"type":"string","enum":["Header","Footer"]}}}"#),
    ("ThematicBreak", r#"{"title":"ThematicBreak","examples":[{"type":"ThematicBreak"}],"type":"object","additionalProperties":false,"required":["type"],"propertyAliases":{},"properties":{"id":{"type":"string"}}}"#),
    ("Thing", r#"{"title":"Thing","type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images"},"additionalProperties":false,"required":["type"],"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"}}}"#),
    ("ThingTypes", r#"{"title":"ThingTypes","anyOf":[{"$ref":"Thing.schema.json"},{"$ref":"Article.schema.json"},{"$ref":"AudioObject.schema.json"},{"$ref":"Brand.schema.json"},{"$ref":"CitationIntentEnumeration.schema.json"},{"$ref":"Claim.schema.json"},{"$ref":"Collection.schema.json"},{"$ref":"Comment.schema.json"},{"$ref":"ContactPoint.schema.json"},{"$ref":"CreativeWork.schema.json"},{"$ref":"Datatable.schema.json"},{"$ref":"DatatableColumn.schema.json"},{"$ref":"DefinedTerm.schema.json"},{"$ref":"Enumeration.schema.json"},{"$ref":"Figure.schema.json"},{"$ref":"Grant.schema.json"},{"$ref":"ImageObject.schema.json"},{"$ref":"ListItem.schema.json"},{"$ref":"MediaObject.schema.json"},{"$ref":"MonetaryGrant.schema.json"},{"$ref":"Organization.schema.json"},{"$ref":"Periodical.schema.json"},{"$ref":"Person.schema.json"},{"$ref":"PostalAddress.schema.json"},{"$ref":"Product.schema.json"},{"$ref":"PropertyValue.schema.json"},{"$ref":"PublicationIssue.schema.json"},{"$ref":"PublicationVolume.schema.json"},{"$ref":"Review.schema.json"},{"$ref":"SoftwareApplication.schema.json"},{"$ref":"SoftwareEnvironment.schema.json"},{"$ref":"SoftwareSession.schema.json"},{"$ref":"SoftwareSourceCode.schema.json"},{"$ref":"Table.schema.json"},{"$ref":"VideoObject.schema.json"},{"$ref":"VolumeMount.schema.json"}]}"#),
    ("TupleValidator", r#"{"title":"TupleValidator","type":"object","propertyAliases":{"item":"items"},"additionalProperties":false,"required":["type"],"properties":{"id":{"type":"string"},"items":{"type":"array","items":{"$ref":"ValidatorTypes.schema.json"},"aliases":["item"]}}}"#),
    ("Validator", r#"{"title":"Validator","required":["type"],"propertyAliases":{},"properties":{"id":{"type":"string"}}}"#),
    ("ValidatorTypes", r#"{"title":"ValidatorTypes","anyOf":[{"$ref":"Validator.schema.json"},{"$ref":"ArrayValidator.schema.json"},{"$ref":"BooleanValidator.schema.json"},{"$ref":"ConstantValidator.schema.json"},{"$ref":"EnumValidator.schema.json"},{"$ref":"IntegerValidator.schema.json"},{"$ref":"NumberValidator.schema.json"},{"$ref":"StringValidator.schema.json"},{"$ref":"TupleValidator.schema.json"}]}"#),
    ("Variable", r#"{"title":"Variable","required":["type","name"],"type":"object","additionalProperties":false,"propertyAliases":{},"properties":{"id":{"type":"string"},"name":{"type":"string","pattern":"[a-z_][A-z0-9_]*"},"isReadonly":{"type":"boolean","default":false},"validator":{"allOf":[{"$ref":"ValidatorTypes.schema.json"}]},"value":{"allOf":[{"$ref":"Node.schema.json"}]}}}"#),
    ("VideoObject", r#"{"title":"VideoObject","examples":[{"type":"VideoObject","caption":"Example Video File","contentSize":"45","contentUrl":"http://www.example.com/file.mp4","encodingFormat":"video/mpeg","transcript":"This is the transcript for the video file..."}],"type":"object","additionalProperties":false,"required":["type","contentUrl"],"propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","author":"authors","comment":"comments","date":"datePublished","editor":"editors","funder":"funders","keyword":"keywords","license":"licenses","maintainer":"maintainers","hasParts":"parts","part":"parts","citations":"references","reference":"references","headline":"title","encodingFormat":"mediaType"},"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"about":{"type":"array","items":{"$ref":"ThingTypes.schema.json"}},"authors":{"allOf":[{"parser":"scsi"},{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]}}],"aliases":["author"]},"comments":{"type":"array","items":{"$ref":"Comment.schema.json"},"aliases":["comment"]},"content":{"anyOf":[{"type":"array","items":{"$ref":"Node.schema.json"}},{"type":"string"}]},"dateCreated":{"allOf":[{"$ref":"Date.schema.json"}]},"dateReceived":{"allOf":[{"$ref":"Date.schema.json"}]},"dateAccepted":{"allOf":[{"$ref":"Date.schema.json"}]},"dateModified":{"allOf":[{"$ref":"Date.schema.json"}]},"datePublished":{"aliases":["date"],"allOf":[{"$ref":"Date.schema.json"}]},"editors":{"type":"array","items":{"$ref":"Person.schema.json"},"aliases":["editor"]},"funders":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["funder"]},"fundedBy":{"type":"array","items":{"anyOf":[{"$ref":"Grant.schema.json"},{"$ref":"MonetaryGrant.schema.json"}]}},"genre":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}]},"keywords":{"allOf":[{"parser":"csi"},{"type":"array","items":{"type":"string"}}],"aliases":["keyword"]},"isPartOf":{"$ref":"CreativeWorkTypes.schema.json"},"licenses":{"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string","format":"uri"}]},"aliases":["license"]},"maintainers":{"type":"array","items":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"aliases":["maintainer"]},"parts":{"aliases":["hasParts","part"],"type":"array","items":{"$ref":"CreativeWorkTypes.schema.json"}},"publisher":{"anyOf":[{"$ref":"Person.schema.json"},{"$ref":"Organization.schema.json"}]},"references":{"aliases":["citations","reference"],"type":"array","items":{"anyOf":[{"$ref":"CreativeWorkTypes.schema.json"},{"type":"string"}]}},"text":{"type":"string"},"title":{"aliases":["headline"],"anyOf":[{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"version":{"anyOf":[{"type":"string"},{"type":"number"}]},"bitrate":{"type":"number"},"contentSize":{"type":"number"},"contentUrl":{"type":"string"},"embedUrl":{"type":"string"},"mediaType":{"aliases":["encodingFormat"],"type":"string","pattern":"^[a-z]+(\\/[a-z\\+\\-]+)$"},"caption":{"type":"string"},"thumbnail":{"allOf":[{"$ref":"ImageObject.schema.json"}]},"transcript":{"type":"string"}}}"#),
    ("VolumeMount", r#"{"title":"VolumeMount","required":["type","mountDestination"],"type":"object","propertyAliases":{"alternateName":"alternateNames","identifier":"identifiers","image":"images","mountOption":"mountOptions"},"additionalProperties":false,"properties":{"id":{"type":"string"},"alternateNames":{"type":"array","items":{"type":"string"},"aliases":["alternateName"]},"description":{"anyOf":[{"type":"array","items":{"$ref":"BlockContent.schema.json"}},{"type":"array","items":{"$ref":"InlineContent.schema.json"},"minItems":2},{"type":"string"}]},"identifiers":{"type":"array","items":{"anyOf":[{"$ref":"PropertyValue.schema.json"},{"type":"string"}]},"aliases":["identifier"]},"images":{"type":"array","items":{"anyOf":[{"$ref":"ImageObject.schema.json"},{"type":"string","format":"uri"}]},"aliases":["image"]},"name":{"type":"string"},"url":{"type":"string","format":"uri"},"mountSource":{"type":"string"},"mountDestination":{"type":"string"},"mountOptions":{"type":"array","items":{"type":"string"},"aliases":["mountOption"]},"mountType":{"type":"string"}}}"#),
];
