
pub fn object(key: &str, val: &str) -> Vec<u8> {
    
    let kb: Vec<u8> = key.to_string().into_bytes();

    let kl: u8 = kb.len() as u8;

    let vb: Vec<u8> = val.to_string().into_bytes();

    let vl: u8 = vb.len() as u8;

    [vec![kl, vl], kb, vb].concat()

}

pub fn group(mut objects: Vec<(String, String)>) -> Vec<u8> {

    objects.sort_by_key(|x| x.0.to_string());

    objects.reverse();

    objects.dedup_by_key(|x| x.0.to_string());

    objects.sort_by_key(|x| x.0.to_string());

    let g_encoded: Vec<Vec<u8>> = objects.iter()
        .map(|x| object(&x.0, &x.1))
        .collect();

    return g_encoded[..].concat();

}
