
use std::str;

pub fn object(bytes: &Vec<u8>) -> (String, String) {

    let kl: usize = u8::from_le_bytes([bytes[0]; 1]) as usize;

    let vi: usize = 2 + kl;

    let ks = str::from_utf8(&bytes[2..vi]).unwrap().to_string(); 

    let vs = str::from_utf8(&bytes[vi..bytes.len()]).unwrap().to_string();
    
    (ks, vs)

}

pub fn group(b: &Vec<u8>) -> Vec<(String, String)> {

    let mut o: Vec<(String, String)> = Vec::new();

    let mut i = 0;

    while i < b.len() {

        let kl: usize = u8::from_le_bytes([b[i]; 1]) as usize;

        let vl: usize = u8::from_le_bytes([b[i+8]; 1]) as usize;

        let vi: usize = 2 + kl;

        let ks = str::from_utf8(&b[2..vi]).unwrap().to_string();

        let vs = str::from_utf8(&b[vi..vi + vl]).unwrap().to_string();
        
        o.push((ks, vs));

        i += kl + vl

    }

    o

}
