# Rust Stellar Notation

The Rust Implementation of Stellar Notation, an data encoding and serialization library.

## Usage

```

stellar-notation = "0.9.8"

```

```

use stellar_notation::{
    byte_decode,
    byte_encode,
    value_decode,
    value_encode
}

```

## Object

An Object is a Key-Value Tuple. Keys and Values are UTF-8 Strings.

### Object Encoding

```

let key: String = String::from("key_1");

let value: String = String::from("value_1");

let object: Vec<u8> = byte_encode::object(key, value);

```

### Object Encoding Structure

| Value | Size(bytes) |
|---|---|
| Key Length | 1 |
| Value Length | 8 |
| Key Data | max 255 |
| Value Data |  max ~18.45 |

| Key len | Value len | Key Data | Value Data |
|---|---|---|---|
| 1 byte | 8 bytes | max 255 bytes | max ~18.45 exabytes |

Value data is also limited by the system file size limit.

### Object Decoding

Reconverts bytes into a Two String Tuple.

```

let key_value: (String, String) = byte_decode::object(serialized);

```

## Groups

### Group Encoding

Converts a group of Two String Tuples into bytes.

```

let objects: Vec<(String, String)> = vec![
    object1, object2, object3
]

let group: Vec<u8> = byte_encode::group(objects);

```

### Group Encoding Structure

| Group |
| --- |
| Obj1, Obj2 ... Obj(n) |

### Group Decoding

Reconverts bytes into a group of two string tuples.

```

let key_value_group: Vec<(String, String)> = byte_decode::group(group);

```
