
use crate::StellarValue;

pub fn as_str(value: StellarValue) -> Result<String, String> {

    match value {
        StellarValue::Str(res) => Ok(res),
        _ => Err("value is not a string.".to_string())
    }

}

pub fn as_uint8(value: StellarValue) -> Result<u8, String> {

    match value {
        StellarValue::UInt8(res) => Ok(res),
        _ => Err("value is not uint8.".to_string())
    }

}

pub fn as_uint16(value: StellarValue) -> Result<u16, String> {

    match value {
        StellarValue::UInt16(res) => Ok(res),
        _ => Err("value is not uint16.".to_string())
    }

}

pub fn as_uint32(value: StellarValue) -> Result<u32, String> {

    match value {
        StellarValue::UInt32(res) => Ok(res),
        _ => Err("value is not uint32.".to_string())
    }

}

pub fn as_uint64(value: StellarValue) -> Result<u64, String> {

    match value {
        StellarValue::UInt64(res) => Ok(res),
        _ => Err("value is not uint64.".to_string())
    }

}

pub fn as_uint128(value: StellarValue) -> Result<u128, String> {

    match value {
        StellarValue::UInt128(res) => Ok(res),
        _ => Err("value is not uint128.".to_string())
    }

}

pub fn as_bytes(value: StellarValue) -> Result<Vec<u8>, String> {

    match value {
        StellarValue::Bytes(res) => Ok(res),
        _ => Err("value is not bytes.".to_string())
    }

}
