
use crate::{StellarValue, StellarObject};

pub fn as_str(list: Vec<StellarObject>, key: &str) -> Result<String, String> {

    let value = list_query(list, key)?;

    match value {
        StellarValue::Str(res) => Ok(res),
        _ => Err("value is not a string.".to_string())
    }

}

pub fn as_uint8(list: Vec<StellarObject>, key: &str) -> Result<u8, String> {

    let value = list_query(list, key)?;

    match value {
        StellarValue::UInt8(res) => Ok(res),
        _ => Err("value is not uint8.".to_string())
    }

}

pub fn as_uint16(list: Vec<StellarObject>, key: &str) -> Result<u16, String> {

    let value = list_query(list, key)?;

    match value {
        StellarValue::UInt16(res) => Ok(res),
        _ => Err("value is not uint16.".to_string())
    }

}

pub fn as_uint32(list: Vec<StellarObject>, key: &str) -> Result<u32, String> {

    let value = list_query(list, key)?;

    match value {
        StellarValue::UInt32(res) => Ok(res),
        _ => Err("value is not uint32.".to_string())
    }

}

pub fn as_uint64(list: Vec<StellarObject>, key: &str) -> Result<u64, String> {

    let value = list_query(list, key)?;

    match value {
        StellarValue::UInt64(res) => Ok(res),
        _ => Err("value is not uint64.".to_string())
    }

}

pub fn as_uint128(list: Vec<StellarObject>, key: &str) -> Result<u128, String> {

    let value = list_query(list, key)?;

    match value {
        StellarValue::UInt128(res) => Ok(res),
        _ => Err("value is not uint128.".to_string())
    }

}

pub fn as_bytes(list: Vec<StellarObject>, key: &str) -> Result<Vec<u8>, String> {

    let value = list_query(list, key)?;

    match value {
        StellarValue::Bytes(res) => Ok(res),
        _ => Err("value is not bytes.".to_string())
    }

}

fn list_query(list: Vec<StellarObject>, key: &str) -> Result<StellarValue, String> {

    let query = list.iter().find(|x| x.0 == key);

    match query {
        Some(res) => return Ok(res.1.clone()),
        None => Err("value not in list.".to_string())
    }

}
