
pub mod byte_decode;
pub mod byte_encode;
pub mod list_get;
pub mod string;
pub mod value_get;

#[derive(Debug, Clone)]
pub enum StellarValue {
    Str(String),
    UInt8(u8),
    UInt16(u16),
    UInt32(u32),
    UInt64(u64),
    UInt128(u128),
    Bytes(Vec<u8>)
}

#[derive(Debug, Clone)]
pub struct StellarObject(pub String, pub StellarValue);
