
use crate::{StellarValue, StellarObject};

pub fn object(object: &StellarObject) -> Vec<u8> {

    let key: String = object.0.to_string();
    
    let key_bytes: Vec<u8> = key.into_bytes();

    let key_length: u8 = key_bytes.len() as u8;

    let key_length_bytes: Vec<u8> = key_length.to_le_bytes().to_vec();

    let value: StellarValue = object.1.clone();

    match value {

        StellarValue::Str(res) => {
            return [1_u8.to_le_bytes().to_vec(), key_length_bytes, key_bytes, res.into_bytes()].concat()
        },

        StellarValue::UInt8(res) => {
            return [2_u8.to_le_bytes().to_vec(), key_length_bytes, key_bytes, res.to_le_bytes().to_vec()].concat()
        },

        StellarValue::UInt16(res) => {
            return [3_u8.to_le_bytes().to_vec(), key_length_bytes, key_bytes, res.to_le_bytes().to_vec()].concat()
        },

        StellarValue::UInt32(res) => {
            return [4_u8.to_le_bytes().to_vec(), key_length_bytes, key_bytes, res.to_le_bytes().to_vec()].concat()
        },

        StellarValue::UInt64(res) => {
            return [5_u8.to_le_bytes().to_vec(), key_length_bytes, key_bytes, res.to_le_bytes().to_vec()].concat()
        },

        StellarValue::UInt128(res) => {
            return [6_u8.to_le_bytes().to_vec(), key_length_bytes, key_bytes, res.to_le_bytes().to_vec()].concat()
        },

        StellarValue::Bytes(res) => {
            return [15_u8.to_le_bytes().to_vec(), key_length_bytes, key_bytes, res].concat()
        }

    };

}

pub fn list(mut list: Vec<StellarObject>) -> Vec<u8> {

    list.sort_by_key(|x| x.0.to_string());

    list.reverse();

    list.dedup_by_key(|x| x.0.to_string());

    list.sort_by_key(|x| x.0.to_string());

    let serialized_objects: Vec<Vec<u8>> = list.iter()
        .map(|x| object(x))
        .collect();

    let serialized_objects_concatenated = serialized_objects.concat();

    let object_lengths: Vec<u64> = serialized_objects.iter()
        .map(|x| x.len() as u64)
        .collect();

    let mut current_object_location: u64 = object_lengths.len() as u64 * 8;

    let mut index_vec: Vec<Vec<u8>> = Vec::new();

    for object_length in object_lengths {

        index_vec.push(current_object_location.to_le_bytes().to_vec());
        current_object_location += object_length;

    }

    let result = [index_vec.concat(), serialized_objects_concatenated].concat();

    return result;

}
