
use std::fmt::Write;

pub fn u8(val: &u8) -> String {
    encode_hex(&val.to_le_bytes().to_vec())
}

pub fn u16(val: &u16) -> String {
    encode_hex(&val.to_le_bytes().to_vec())
}

pub fn u32(val: &u32) -> String {
    encode_hex(&val.to_le_bytes().to_vec())
}

pub fn u64(val: &u64) -> String {
    encode_hex(&val.to_le_bytes().to_vec())
}

pub fn u128(val: &u128) -> String {
    encode_hex(&val.to_le_bytes().to_vec())
}

pub fn bytes(val: &Vec<u8>) -> String {
    encode_hex(val)
}

pub fn list(val: &Vec<String>) -> String {
    
    let mut bytes: Vec<u8> = Vec::new();

    for i in val {

        let item_bytes: Vec<u8> = i.to_string().into_bytes();

        let item_length: u64 = item_bytes.len() as u64;

        if item_length < 256 {

            let item_length_size = 1_u8.to_le_bytes().to_vec();
            let u8_item_length: u8 = item_length as u8;

            item_length_size.iter().for_each(|x| bytes.push(*x));
            u8_item_length.to_le_bytes().to_vec().iter().for_each(|x| bytes.push(*x));
            
        } else if item_length < 65536 {
    
            let item_length_size = 2_u8.to_le_bytes().to_vec();
            let u16_item_length: u16 = item_length as u16;

            item_length_size.iter().for_each(|x| bytes.push(*x));
            u16_item_length.to_le_bytes().to_vec().iter().for_each(|x| bytes.push(*x));

    
        } else if item_length < 4294967296 {
    
            let item_length_size: Vec<u8> = 4_u8.to_le_bytes().to_vec();
            let u32_item_length: u32 = item_length as u32;
            
            item_length_size.iter().for_each(|x| bytes.push(*x));
            u32_item_length.to_le_bytes().to_vec().iter().for_each(|x| bytes.push(*x));
    
        } else {
    
            let item_length_size: Vec<u8> = 8_u8.to_le_bytes().to_vec();
            let u64_item_length: u64 = item_length as u64;
            
            item_length_size.iter().for_each(|x| bytes.push(*x));
            u64_item_length.to_le_bytes().to_vec().iter().for_each(|x| bytes.push(*x));
    
        }

    }

    encode_hex(&bytes)
}

fn encode_hex(bytes: &Vec<u8>) -> String {
    let mut res = String::with_capacity((bytes.len() * 2) + 2);
    res.push_str("0X");
    for &b in bytes {
        write!(&mut res, "{:02X}", b).unwrap();
    }
    res
}
