# Rust Stellar Notation

Rust library for encoding and decoding objects in Stellar Notation format.

## Usage

```

stellar-notation = "0.9.17"

```

```

use stellar_notation::{ encode, decode };

```

## Encoding

### Support
| Type | Support |
|---|---|
| u8 | ✅ |
| u16 | ✅ |
| u32 | ✅ |
| u64 | ✅ |
| u128 | ✅ |
| u256 | 🚧 |
| i8 | 🚧 |
| i16 | 🚧 |
| i32 | 🚧 |
| i64 | 🚧 |
| i128 | 🚧 |
| i256 | 🚧 |
| f32 | 🚧 |
| f64 | 🚧 |
| bool | 🚧 |
| list | ✅ |
| bytes | ✅ |


### Unsigned Integers

```

let encoded_u8: String = encode::u8(1);

let integer: u8 = decode::as_u8(encoded_u8);

```

### Bytes

```

let encoded_bytes: String = encode::bytes(vec![1,2,3]);

let bytes: Vec<u8> = decode::as_bytes(encoded_bytes);

```

### List

```

let encoded_list: String = encode::list(vec![encoded_u8_1, encoded_u8_2, encoded_u8_3]);

let list: Vec<String> = decode::as_list(encoded_list);

```

2021-09-14
