
use std::fmt::Write;

pub fn u8(val: &u8) -> String {
    encode_hex(&val.to_le_bytes().to_vec())
}

pub fn u16(val: &u16) -> String {
    encode_hex(&val.to_le_bytes().to_vec())
}

pub fn u32(val: &u32) -> String {
    encode_hex(&val.to_le_bytes().to_vec())
}

pub fn u64(val: &u64) -> String {
    encode_hex(&val.to_le_bytes().to_vec())
}

pub fn u128(val: &u128) -> String {
    encode_hex(&val.to_le_bytes().to_vec())
}

pub fn bytes(val: &Vec<u8>) -> String {
    encode_hex(val)
}

pub fn list(val: &Vec<String>) -> String {
    let mut res: String = String::from("0X");
    val.iter().for_each(|x| res.push_str(x));
    res
}

fn encode_hex(bytes: &Vec<u8>) -> String {
    let mut res = String::with_capacity((bytes.len() * 2) + 2);
    res.push_str("0X");
    for &b in bytes {
        write!(&mut res, "{:02X}", b).unwrap();
    }
    res
}
