
use std::error::Error;
use std::str;
use std::convert::TryInto;
use std::num::ParseIntError;

pub fn as_u8(val: &str) -> Result<u8, Box<dyn Error>> {
    let res = u8::from_le_bytes(decode_hex(val)?[..].try_into().unwrap());
    Ok(res)
}

pub fn as_u16(val: &str) -> Result<u16, Box<dyn Error>> {
    let res = u16::from_le_bytes(decode_hex(val)?[..].try_into().unwrap());
    Ok(res)
}

pub fn as_u32(val: &str) -> Result<u32, Box<dyn Error>> {
    let res = u32::from_le_bytes(decode_hex(val)?[..].try_into().unwrap());
    Ok(res)
}

pub fn as_u64(val: &str) -> Result<u64, Box<dyn Error>> {
    let res = u64::from_le_bytes(decode_hex(val)?[..].try_into().unwrap());
    Ok(res)
}

pub fn as_u128(val: &str) -> Result<u128, Box<dyn Error>> {
    let res = u128::from_le_bytes(decode_hex(val)?[..].try_into().unwrap());
    Ok(res)
}

pub fn as_bytes(val: &str) -> Result<Vec<u8>, Box<dyn Error>> {
    let res = decode_hex(val)?;
    Ok(res)
}

pub fn as_list(val: &str) -> Result<Vec<String>, Box<dyn Error>> {
    let (_first, last) = val.split_at(2);
    let strings: Vec<&str> = last.split("0X").collect();
    let res = strings.iter().map(|x| x.to_string()).collect();
    Ok(res)
}

fn decode_hex(s: &str) -> Result<Vec<u8>, ParseIntError> {
    (2..s.len())
        .step_by(2)
        .map(|i| u8::from_str_radix(&s[i..i + 2], 16))
        .collect()
}
