
use std::error::Error;
use std::fmt;

#[derive(Debug)]
struct CustomError(String);

impl fmt::Display for CustomError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Stellar Notation Error: {}", self.0)
    }
}

impl Error for CustomError {}

pub mod decoding;
pub mod encoding;
