
use std::error::Error;
use std::str;

use crate::CustomError;

pub fn run(bytes: &Vec<u8>) -> Result<(String, String), Box<dyn Error>> {

    let key_length: usize = u8::from_le_bytes([bytes[0]; 1]) as usize;

    let key_string: String = str::from_utf8(&bytes[1..key_length]).unwrap().to_string();

    let vls: usize = u8::from_le_bytes([bytes[1 + key_length]; 1]) as usize;

    match vls {
        
        1 => {
            let vs = str::from_utf8(&bytes[3 + key_length..bytes.len()])?.to_string();
            Ok((key_string, vs))
        },

        2 => {
            let vs = str::from_utf8(&bytes[4 + key_length..bytes.len()])?.to_string();
            Ok((key_string, vs))
        },

        4 => {
            let vs = str::from_utf8(&bytes[6 + key_length..bytes.len()])?.to_string();
            Ok((key_string, vs))
        },

        8 => {
            let vs = str::from_utf8(&bytes[10 + key_length..bytes.len()])?.to_string();
            Ok((key_string, vs))
        },

        _ => {
            Err(Box::new(CustomError("value length size unknown".into())))
        }

    }

}