
use std::error::Error;
use std::str;

use crate::CustomError;

pub fn run(bytes: &Vec<u8>) -> Result<Vec<(String, String)>, Box<dyn Error>> {

    let mut objects: Vec<(String, String)> = Vec::new();

    let mut i = 0;

    while i < bytes.len() {

        let key_length: usize = u8::from_le_bytes([bytes[i]; 1]) as usize;
        i += 1;

        let key_string: String = str::from_utf8(&bytes[i..i + key_length]).unwrap().to_string();
        i += key_length;

        let value_length_size: usize = u8::from_le_bytes([bytes[i]; 1]) as usize;
        i += 1;

        match value_length_size {

            1 => {

                let value_length: usize = u8::from_le_bytes([bytes[i]; 1]) as usize;
                i += 1;

                let value_string: String = str::from_utf8(&bytes[i..i + value_length])?.to_string();
                i += value_length;

                objects.push((key_string, value_string))

            },

            2 => {

                let value_length: usize = u16::from_le_bytes([bytes[i], bytes[i + 1]]) as usize;
                i += 2;

                let value_string: String = str::from_utf8(&bytes[i..i + value_length])?.to_string();
                i += value_length;

                objects.push((key_string, value_string))

            },

            4 => {

                let value_length: usize = u32::from_le_bytes([bytes[i], bytes[i + 1], bytes[i + 2], bytes[i + 3]]) as usize;
                i += 4;

                let value_string: String = str::from_utf8(&bytes[i..i + value_length])?.to_string();
                i += value_length;

                objects.push((key_string, value_string))

            },

            8 => {

                let value_length: usize = u64::from_le_bytes([bytes[i], bytes[i + 1], bytes[i + 2], bytes[i + 3], bytes[i + 4], bytes[i + 5], bytes[i + 6], bytes[i + 7]]) as usize;
                i += 8;

                let value_string: String = str::from_utf8(&bytes[i..i + value_length])?.to_string();
                i += value_length;

                objects.push((key_string, value_string))

            },

            _ => {
                Err(Box::new(CustomError("value length size unknown".into())))?
            }

        }

    }

    Ok(objects)

}
