
use std::error::Error;
use std::str;
use std::convert::TryInto;
use std::num::ParseIntError;

mod group;
mod object;

pub fn object(bytes: &Vec<u8>) -> Result<(String, String), Box<dyn Error>> {
    object::run(bytes)
}

pub fn group(bytes: &Vec<u8>) -> Result<Vec<(String, String)>, Box<dyn Error>> {
    group::run(bytes)
}

pub fn as_u128(val: &str) -> Result<u128, Box<dyn Error>> {
    let res = u128::from_le_bytes(decode_hex(val)?[..].try_into().unwrap());
    Ok(res)
}

pub fn as_bytes(val: &str) -> Result<Vec<u8>, Box<dyn Error>> {
    let res = decode_hex(val)?;
    Ok(res)
}

fn decode_hex(s: &str) -> Result<Vec<u8>, ParseIntError> {
    (2..s.len())
        .step_by(2)
        .map(|i| u8::from_str_radix(&s[i..i + 2], 16))
        .collect()
}
