# Rust Stellar Notation

The Rust Implementation of Stellar Notation, a data encoding library.

## Usage

```

stellar-notation = "0.9.13"

```

```

use stellar_notation::{ encoding, decoding };

```

## Values

Encoding and Decoding Values between Hex for u128 and bytes.

### u128

```

let encoded_u128: String = encoding::u128(1);

let u128_number: u128 = decoding::as_128(encoded_u128);

```

### bytes

```

let encoded_bytes: String = encoding::bytes(vec![1,2,3]);

let bytes: Vec<u8> = decoding::as_bytes(encoded_bytes);

```

## Objects

An Object is a Key-Value tuple of UTF-8 Strings.

### Object Encoding

```

let key: String = String::from("key_1");
let value: String = String::from("value_1");

let object_buffer: Vec<u8> = encoding::object(key, value);

```

### Object Encoding Structure

| Value | Key Length | Key Bytes | Value Length Size | Value Length | Value Data |
|---|---|---|---|---|---|
| Size(bytes) | 1 | max. 255 | 1 | 1,2,4,8 | max. ~18.45exa |

Value data is also limited by the system file size limit.

### Object Decoding

Decodes bytes into a Key Value String tuple.

```

let object: (String, String) = decoding::object(object_buffer);

```

## Groups

### Group Encoding

Converts a group of objects into bytes.

```

let group: Vec<(String, String)> = vec![
    object1, object2, object3
]

let group_buffer: Vec<u8> = byte_encode::group(group);

```

### Group Encoding Structure

| Group |
| --- |
| Obj1, Obj2 ... Obj(n) |

### Group Decoding

Reconverts bytes into a group of objects.

```

let group: Vec<(String, String)> = decoding::group(group_buffer);

```

2021-09-10
