
pub fn object(key: &str, val: &str) -> Vec<u8> {
    
    let kb: Vec<u8> = key.to_string().into_bytes();

    let kl: u8 = kb.len() as u8;

    let vb: Vec<u8> = val.to_string().into_bytes();

    let vs: u64 = vb.len() as u64;

    if vs < 255 {

        let vls: Vec<u8> = 1_u8.to_le_bytes().to_vec();

        let vl: u8 = vs as u8;

        [vec![kl], kb, vls, vl.to_le_bytes().to_vec(), vb].concat()
        
    } else if vs < 65535 {

        let vls: Vec<u8> = 2_u8.to_le_bytes().to_vec();

        let vl: u16 = vs as u16;

        [vec![kl], kb, vls, vl.to_le_bytes().to_vec(), vb].concat()

    } else if vs < 4294967295 {

        let vls: Vec<u8> = 4_u8.to_le_bytes().to_vec();

        let vl: u32 = vs as u32;

        [vec![kl], kb, vls, vl.to_le_bytes().to_vec(), vb].concat()

    } else {

        let vls: Vec<u8> = 8_u8.to_le_bytes().to_vec();

        let vl: u64 = vs as u64;

        [vec![kl], kb, vls, vl.to_le_bytes().to_vec(), vb].concat()

    }

}

pub fn group(mut objs: Vec<(String, String)>) -> Vec<u8> {

    objs.sort_by_key(|x| x.0.to_string());

    objs.reverse();

    objs.dedup_by_key(|x| x.0.to_string());

    objs.sort_by_key(|x| x.0.to_string());

    let res: Vec<Vec<u8>> = objs.iter()
        .map(|x| object(&x.0, &x.1))
        .collect();

    res.concat()

}
