
use std::fmt::Write;

pub fn u128(val: &u128) -> String {
    encode_hex(&val.to_le_bytes().to_vec())
}

pub fn bytes(val: &Vec<u8>) -> String {
    encode_hex(val)
}

fn encode_hex(bytes: &Vec<u8>) -> String {
    let mut s = String::with_capacity((bytes.len() * 2) + 2);
    s.push_str("0X");
    for &b in bytes {
        write!(&mut s, "{:02X}", b).unwrap();
    }
    s
}