# Rust Stellar Notation

The Rust Implementation of Stellar Notation, a data encoding library.

## Usage

```

stellar-notation = "0.9.9"

```

```

use stellar_notation::{
    byte_decode,
    byte_encode,
    value_decode,
    value_encode
}

```

## Values

Encoding and Decoding Values into Hex String is supported for u128 and bytes.

### u128

```

let u128_str: String = value_encode::u128(1);

let u128_num: u128 = value_decode::as_128(u128_str);

```

### bytes

```

let bytes: Vec<u8> = vec![1,2,3]

let byte_str: String = value_encode::bytes(bytes);

let decoded_byte_str: Vec<u8> = value_decode::as_bytes(byte_str);

```

## Object

An Object is a Key-Value Tuple. Keys and Values are UTF-8 Strings.

### Object Encoding

```

let key: String = String::from("key_1");

let value: String = String::from("value_1");

let object: Vec<u8> = byte_encode::object(key, value);

```

### Object Encoding Structure

| Value | Size(bytes) |
|---|---|
| Key Length | 1 |
| Value Length | 8 |
| Key Data | max 255 |
| Value Data |  max ~18.45 exa |

Value data is also limited by the system file size limit.

### Object Decoding

Reconverts bytes into a Two String Tuple.

```

let key_value: (String, String) = byte_decode::object(serialized);

```

## Groups

### Group Encoding

Converts a group of Two String Tuples into bytes.

```

let objects: Vec<(String, String)> = vec![
    object1, object2, object3
]

let group: Vec<u8> = byte_encode::group(objects);

```

### Group Encoding Structure

| Group |
| --- |
| Obj1, Obj2 ... Obj(n) |

### Group Decoding

Reconverts bytes into a group of two string tuples.

```

let key_value_group: Vec<(String, String)> = byte_decode::group(group);

```

# END
