
use std::str;
use std::convert::TryFrom;

pub fn serialize_str(obj: (String, String)) -> Vec<u8> {

    let value_type: Vec<u8> = 1_u8.to_le_bytes().to_vec();

    let key: String = obj.0;
    
    let key_bytes: Vec<u8> = key.into_bytes();

    let value: String = obj.1;
            
    let value_bytes: Vec<u8> = value.into_bytes();

    let key_bytes_length = u8::try_from(key_bytes.len());

    match key_bytes_length {
        
        Ok(len) => {

            let result: Vec<u8> = [
                value_type,
                len.to_le_bytes().to_vec(),
                key_bytes,
                value_bytes
            ].concat();

            return result

        },

        Err(_) => return vec![]

    }

}

pub fn deserialize_str(vec: Vec<u8>) -> (String, String) {

    let key_length = usize::from_le(vec[1].into());
    
    let key_slice = &vec[2..key_length + 2];
    
    let value_slice = &vec[key_length + 2..vec.len()];
    
    let key = str::from_utf8(key_slice).unwrap().to_string();
    
    let value = str::from_utf8(value_slice).unwrap().to_string();
    
    return (key, value)

}

pub fn encode(list: &Vec<Vec<u8>>) -> Vec<u8> {

    let obj_sizes: Vec<usize> = list.into_iter().map(|x| x.len()).collect();

    let mut current_index = obj_sizes.len() * 8;

    let mut result: Vec<u8> = Vec::new();

    for x in &obj_sizes[0..obj_sizes.len()] {

        let index = current_index.to_le_bytes().to_vec();
        result = [result, index].concat();
        current_index += x;

    }

    for obj in list {
        result = [result, obj.to_vec()].concat();
    }

    return result;

}

