
pub fn serialize(vec: Vec<(String, String)>) -> String {
    
    let mut string = String::new();
    
    string.push_str("{");

    let mut count = 1;

    for i in vec.iter() {

        string.push_str(&i.0);
        string.push_str(&String::from(":"));
        string.push_str(&i.1);
        string.push_str(&String::from(","));

        if count < vec.len() {
            string.push_str(",");
        }

        count += 1;

    }

    string.push_str("}");

    return string

}

pub fn deserialize(string: String) -> Vec<(String, String)> {

    let mut main_str = &string[1..string.len() - 1];

    let mut vec = Vec::new();

    while main_str.len() > 0 {

        let key_split: Vec<&str> = main_str.split(":").collect();

        let key = String::from(key_split[0]);

        let value_split: Vec<&str> = key_split[0].split(",").collect();

        let value = String::from(value_split[0]);

        let key_value = (key, value);

        vec.push(key_value);

        main_str = value_split[1];

    }

    return vec

}
