
use std::error::Error;

pub fn serialize(vec: Vec<(String, String)>) -> Result<String, Box<dyn Error>> {
    
    let mut s = String::new();
    
    s.push_str("{");

    for i in vec.iter() {

        s.push_str(&i.0);
        s.push_str(&String::from(":"));
        s.push_str(&i.1);
        s.push_str(&String::from(","));

    }

    s.push_str("}");

    Ok(s)

}

pub fn deserialize(s: String) -> Result<Vec<(String, String)>, Box<dyn Error>> {

    let mut main_str = &s[1..s.len() - 1];

    let mut v = Vec::new();

    while main_str.len() > 0 {

        let key_split: Vec<&str> = main_str.split(":").collect();

        let key = String::from(key_split[0]);

        let value_split: Vec<&str> = key_split[0].split(",").collect();

        let value = String::from(value_split[0]);

        let key_value = (key, value);

        v.push(key_value);

        main_str = value_split[1];

    }

    Ok(v)

}
