/* automatically generated by rust-bindgen 0.58.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const QUERY_PORT_NOT_INITIALIZED: u32 = 65535;
pub const QUERY_PORT_ERROR: u32 = 65534;
pub const _VCRT_COMPILER_PREPROCESSOR: u32 = 1;
pub const _SAL_VERSION: u32 = 20;
pub const __SAL_H_VERSION: u32 = 180000000;
pub const _USE_DECLSPECS_FOR_SAL: u32 = 0;
pub const _USE_ATTRIBUTES_FOR_SAL: u32 = 0;
pub const _CRT_PACKING: u32 = 8;
pub const _HAS_EXCEPTIONS: u32 = 1;
pub const NULL: u32 = 0;
pub const _HAS_CXX17: u32 = 0;
pub const _HAS_CXX20: u32 = 0;
pub const _HAS_NODISCARD: u32 = 1;
pub const _ARGMAX: u32 = 100;
pub const _CRT_INT_MAX: u32 = 2147483647;
pub const _CRT_FUNCTIONS_REQUIRED: u32 = 1;
pub const _CRT_HAS_CXX17: u32 = 0;
pub const _ARM_WINAPI_PARTITION_DESKTOP_SDK_AVAILABLE: u32 = 1;
pub const _CRT_BUILD_DESKTOP_APP: u32 = 1;
pub const _CRT_INTERNAL_NONSTDC_NAMES: u32 = 1;
pub const __STDC_SECURE_LIB__: u32 = 200411;
pub const __GOT_SECURE_LIB__: u32 = 200411;
pub const __STDC_WANT_SECURE_LIB__: u32 = 1;
pub const _SECURECRT_FILL_BUFFER_PATTERN: u32 = 254;
pub const _CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES: u32 = 0;
pub const _CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES_COUNT: u32 = 0;
pub const _CRT_SECURE_CPP_OVERLOAD_SECURE_NAMES: u32 = 1;
pub const _CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES_MEMORY: u32 = 0;
pub const _CRT_SECURE_CPP_OVERLOAD_SECURE_NAMES_MEMORY: u32 = 0;
pub const EPERM: u32 = 1;
pub const ENOENT: u32 = 2;
pub const ESRCH: u32 = 3;
pub const EINTR: u32 = 4;
pub const EIO: u32 = 5;
pub const ENXIO: u32 = 6;
pub const E2BIG: u32 = 7;
pub const ENOEXEC: u32 = 8;
pub const EBADF: u32 = 9;
pub const ECHILD: u32 = 10;
pub const EAGAIN: u32 = 11;
pub const ENOMEM: u32 = 12;
pub const EACCES: u32 = 13;
pub const EFAULT: u32 = 14;
pub const EBUSY: u32 = 16;
pub const EEXIST: u32 = 17;
pub const EXDEV: u32 = 18;
pub const ENODEV: u32 = 19;
pub const ENOTDIR: u32 = 20;
pub const EISDIR: u32 = 21;
pub const ENFILE: u32 = 23;
pub const EMFILE: u32 = 24;
pub const ENOTTY: u32 = 25;
pub const EFBIG: u32 = 27;
pub const ENOSPC: u32 = 28;
pub const ESPIPE: u32 = 29;
pub const EROFS: u32 = 30;
pub const EMLINK: u32 = 31;
pub const EPIPE: u32 = 32;
pub const EDOM: u32 = 33;
pub const EDEADLK: u32 = 36;
pub const ENAMETOOLONG: u32 = 38;
pub const ENOLCK: u32 = 39;
pub const ENOSYS: u32 = 40;
pub const ENOTEMPTY: u32 = 41;
pub const EINVAL: u32 = 22;
pub const ERANGE: u32 = 34;
pub const EILSEQ: u32 = 42;
pub const STRUNCATE: u32 = 80;
pub const EDEADLOCK: u32 = 36;
pub const EADDRINUSE: u32 = 100;
pub const EADDRNOTAVAIL: u32 = 101;
pub const EAFNOSUPPORT: u32 = 102;
pub const EALREADY: u32 = 103;
pub const EBADMSG: u32 = 104;
pub const ECANCELED: u32 = 105;
pub const ECONNABORTED: u32 = 106;
pub const ECONNREFUSED: u32 = 107;
pub const ECONNRESET: u32 = 108;
pub const EDESTADDRREQ: u32 = 109;
pub const EHOSTUNREACH: u32 = 110;
pub const EIDRM: u32 = 111;
pub const EINPROGRESS: u32 = 112;
pub const EISCONN: u32 = 113;
pub const ELOOP: u32 = 114;
pub const EMSGSIZE: u32 = 115;
pub const ENETDOWN: u32 = 116;
pub const ENETRESET: u32 = 117;
pub const ENETUNREACH: u32 = 118;
pub const ENOBUFS: u32 = 119;
pub const ENODATA: u32 = 120;
pub const ENOLINK: u32 = 121;
pub const ENOMSG: u32 = 122;
pub const ENOPROTOOPT: u32 = 123;
pub const ENOSR: u32 = 124;
pub const ENOSTR: u32 = 125;
pub const ENOTCONN: u32 = 126;
pub const ENOTRECOVERABLE: u32 = 127;
pub const ENOTSOCK: u32 = 128;
pub const ENOTSUP: u32 = 129;
pub const EOPNOTSUPP: u32 = 130;
pub const EOTHER: u32 = 131;
pub const EOVERFLOW: u32 = 132;
pub const EOWNERDEAD: u32 = 133;
pub const EPROTO: u32 = 134;
pub const EPROTONOSUPPORT: u32 = 135;
pub const EPROTOTYPE: u32 = 136;
pub const ETIME: u32 = 137;
pub const ETIMEDOUT: u32 = 138;
pub const ETXTBSY: u32 = 139;
pub const EWOULDBLOCK: u32 = 140;
pub const _NLSCMPERROR: u32 = 2147483647;
pub const STEAMCLIENT_INTERFACE_VERSION: &'static [u8; 15usize] = b"SteamClient020\0";
pub const STEAMUSER_INTERFACE_VERSION: &'static [u8; 13usize] = b"SteamUser021\0";
pub const STEAMFRIENDS_INTERFACE_VERSION: &'static [u8; 16usize] = b"SteamFriends017\0";
pub const STEAMUTILS_INTERFACE_VERSION: &'static [u8; 14usize] = b"SteamUtils010\0";
pub const _CRT_INTERNAL_STDIO_SYMBOL_PREFIX: &'static [u8; 1usize] = b"\0";
pub const _CRT_INTERNAL_PRINTF_LEGACY_VSPRINTF_NULL_TERMINATION: u32 = 1;
pub const _CRT_INTERNAL_PRINTF_STANDARD_SNPRINTF_BEHAVIOR: u32 = 2;
pub const _CRT_INTERNAL_PRINTF_LEGACY_WIDE_SPECIFIERS: u32 = 4;
pub const _CRT_INTERNAL_PRINTF_LEGACY_MSVCRT_COMPATIBILITY: u32 = 8;
pub const _CRT_INTERNAL_PRINTF_LEGACY_THREE_DIGIT_EXPONENTS: u32 = 16;
pub const _CRT_INTERNAL_SCANF_SECURECRT: u32 = 1;
pub const _CRT_INTERNAL_SCANF_LEGACY_WIDE_SPECIFIERS: u32 = 2;
pub const _CRT_INTERNAL_SCANF_LEGACY_MSVCRT_COMPATIBILITY: u32 = 4;
pub const BUFSIZ: u32 = 512;
pub const _NSTREAM_: u32 = 512;
pub const _IOB_ENTRIES: u32 = 3;
pub const EOF: i32 = -1;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 64;
pub const _IONBF: u32 = 4;
pub const L_tmpnam: u32 = 260;
pub const L_tmpnam_s: u32 = 260;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const SEEK_SET: u32 = 0;
pub const FILENAME_MAX: u32 = 260;
pub const FOPEN_MAX: u32 = 20;
pub const _SYS_OPEN: u32 = 20;
pub const TMP_MAX: u32 = 2147483647;
pub const TMP_MAX_S: u32 = 2147483647;
pub const _TMP_MAX_S: u32 = 2147483647;
pub const SYS_OPEN: u32 = 20;
pub const k_nMaxLobbyKeyLength: u32 = 255;
pub const STEAMMATCHMAKING_INTERFACE_VERSION: &'static [u8; 20usize] = b"SteamMatchMaking009\0";
pub const STEAMMATCHMAKINGSERVERS_INTERFACE_VERSION: &'static [u8; 27usize] =
    b"SteamMatchMakingServers002\0";
pub const STEAMGAMESEARCH_INTERFACE_VERSION: &'static [u8; 24usize] = b"SteamMatchGameSearch001\0";
pub const STEAMPARTIES_INTERFACE_VERSION: &'static [u8; 16usize] = b"SteamParties002\0";
pub const STEAMREMOTESTORAGE_INTERFACE_VERSION: &'static [u8; 40usize] =
    b"STEAMREMOTESTORAGE_INTERFACE_VERSION014\0";
pub const STEAMUSERSTATS_INTERFACE_VERSION: &'static [u8; 36usize] =
    b"STEAMUSERSTATS_INTERFACE_VERSION012\0";
pub const STEAMAPPS_INTERFACE_VERSION: &'static [u8; 31usize] = b"STEAMAPPS_INTERFACE_VERSION008\0";
pub const STEAMNETWORKING_INTERFACE_VERSION: &'static [u8; 19usize] = b"SteamNetworking006\0";
pub const INVALID_SCREENSHOT_HANDLE: u32 = 0;
pub const STEAMSCREENSHOTS_INTERFACE_VERSION: &'static [u8; 38usize] =
    b"STEAMSCREENSHOTS_INTERFACE_VERSION003\0";
pub const STEAMMUSIC_INTERFACE_VERSION: &'static [u8; 32usize] =
    b"STEAMMUSIC_INTERFACE_VERSION001\0";
pub const k_SteamMusicNameMaxLength: u32 = 255;
pub const k_SteamMusicPNGMaxLength: u32 = 65535;
pub const STEAMMUSICREMOTE_INTERFACE_VERSION: &'static [u8; 38usize] =
    b"STEAMMUSICREMOTE_INTERFACE_VERSION001\0";
pub const INVALID_HTTPREQUEST_HANDLE: u32 = 0;
pub const INVALID_HTTPCOOKIE_HANDLE: u32 = 0;
pub const STEAMHTTP_INTERFACE_VERSION: &'static [u8; 31usize] = b"STEAMHTTP_INTERFACE_VERSION003\0";
pub const STEAM_INPUT_MAX_COUNT: u32 = 16;
pub const STEAM_INPUT_MAX_ANALOG_ACTIONS: u32 = 16;
pub const STEAM_INPUT_MAX_DIGITAL_ACTIONS: u32 = 128;
pub const STEAM_INPUT_MAX_ORIGINS: u32 = 8;
pub const STEAM_INPUT_MAX_ACTIVE_LAYERS: u32 = 16;
pub const STEAM_INPUT_MIN_ANALOG_ACTION_DATA: f64 = -1.0;
pub const STEAM_INPUT_MAX_ANALOG_ACTION_DATA: f64 = 1.0;
pub const STEAMINPUT_INTERFACE_VERSION: &'static [u8; 14usize] = b"SteamInput002\0";
pub const STEAM_CONTROLLER_MAX_COUNT: u32 = 16;
pub const STEAM_CONTROLLER_MAX_ANALOG_ACTIONS: u32 = 16;
pub const STEAM_CONTROLLER_MAX_DIGITAL_ACTIONS: u32 = 128;
pub const STEAM_CONTROLLER_MAX_ORIGINS: u32 = 8;
pub const STEAM_CONTROLLER_MAX_ACTIVE_LAYERS: u32 = 16;
pub const STEAM_CONTROLLER_MIN_ANALOG_ACTION_DATA: f64 = -1.0;
pub const STEAM_CONTROLLER_MAX_ANALOG_ACTION_DATA: f64 = 1.0;
pub const STEAMCONTROLLER_INTERFACE_VERSION: &'static [u8; 19usize] = b"SteamController008\0";
pub const STEAMUGC_INTERFACE_VERSION: &'static [u8; 30usize] = b"STEAMUGC_INTERFACE_VERSION015\0";
pub const STEAMAPPLIST_INTERFACE_VERSION: &'static [u8; 34usize] =
    b"STEAMAPPLIST_INTERFACE_VERSION001\0";
pub const STEAMHTMLSURFACE_INTERFACE_VERSION: &'static [u8; 39usize] =
    b"STEAMHTMLSURFACE_INTERFACE_VERSION_005\0";
pub const STEAMINVENTORY_INTERFACE_VERSION: &'static [u8; 30usize] =
    b"STEAMINVENTORY_INTERFACE_V003\0";
pub const STEAMVIDEO_INTERFACE_VERSION: &'static [u8; 26usize] = b"STEAMVIDEO_INTERFACE_V002\0";
pub const STEAMPARENTALSETTINGS_INTERFACE_VERSION: &'static [u8; 43usize] =
    b"STEAMPARENTALSETTINGS_INTERFACE_VERSION001\0";
pub const STEAMREMOTEPLAY_INTERFACE_VERSION: &'static [u8; 37usize] =
    b"STEAMREMOTEPLAY_INTERFACE_VERSION001\0";
pub const WCHAR_MIN: u32 = 0;
pub const WCHAR_MAX: u32 = 65535;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 65535;
pub const STEAMNETWORKINGMESSAGES_INTERFACE_VERSION: &'static [u8; 27usize] =
    b"SteamNetworkingMessages002\0";
pub const STEAMNETWORKINGSOCKETS_INTERFACE_VERSION: &'static [u8; 26usize] =
    b"SteamNetworkingSockets009\0";
pub const STEAMNETWORKINGUTILS_INTERFACE_VERSION: &'static [u8; 24usize] =
    b"SteamNetworkingUtils003\0";
pub const STEAMGAMESERVER_INTERFACE_VERSION: &'static [u8; 19usize] = b"SteamGameServer013\0";
pub const STEAMGAMESERVERSTATS_INTERFACE_VERSION: &'static [u8; 24usize] =
    b"SteamGameServerStats001\0";
pub type uint8 = ::std::os::raw::c_uchar;
pub type int8 = ::std::os::raw::c_schar;
pub type int16 = ::std::os::raw::c_short;
pub type uint16 = ::std::os::raw::c_ushort;
pub type int32 = ::std::os::raw::c_int;
pub type uint32 = ::std::os::raw::c_uint;
pub type int64 = ::std::os::raw::c_longlong;
pub type uint64 = ::std::os::raw::c_ulonglong;
pub type lint64 = int64;
pub type ulint64 = uint64;
pub type intp = ::std::os::raw::c_longlong;
pub type uintp = ::std::os::raw::c_ulonglong;
pub const k_cubSaltSize: ::std::os::raw::c_int = 8;
pub type Salt_t = [uint8; 8usize];
pub type GID_t = uint64;
pub const k_GIDNil: GID_t = 18446744073709551615;
pub type JobID_t = uint64;
pub type TxnID_t = GID_t;
extern "C" {
    pub static k_TxnIDNil: GID_t;
}
pub const k_TxnIDUnknown: GID_t = 0;
pub const k_JobIDNil: JobID_t = 18446744073709551615;
pub type PackageId_t = uint32;
pub const k_uPackageIdInvalid: PackageId_t = 4294967295;
pub type BundleId_t = uint32;
pub const k_uBundleIdInvalid: BundleId_t = 0;
pub type AppId_t = uint32;
pub const k_uAppIdInvalid: AppId_t = 0;
pub type AssetClassId_t = uint64;
pub const k_ulAssetClassIdInvalid: AssetClassId_t = 0;
pub type PhysicalItemId_t = uint32;
pub const k_uPhysicalItemIdInvalid: PhysicalItemId_t = 0;
pub type DepotId_t = uint32;
pub const k_uDepotIdInvalid: DepotId_t = 0;
pub type RTime32 = uint32;
pub type CellID_t = uint32;
pub const k_uCellIDInvalid: CellID_t = 4294967295;
pub type SteamAPICall_t = uint64;
pub const k_uAPICallInvalid: SteamAPICall_t = 0;
pub type AccountID_t = uint32;
pub type PartnerId_t = uint32;
pub const k_uPartnerIdInvalid: PartnerId_t = 0;
pub type ManifestId_t = uint64;
pub const k_uManifestIdInvalid: ManifestId_t = 0;
pub type SiteId_t = uint64;
pub const k_ulSiteIdInvalid: SiteId_t = 0;
pub type PartyBeaconID_t = uint64;
pub const k_ulPartyBeaconIdInvalid: PartyBeaconID_t = 0;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamIPType {
    k_ESteamIPTypeIPv4 = 0,
    k_ESteamIPTypeIPv6 = 1,
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct SteamIPAddress_t {
    pub __bindgen_anon_1: SteamIPAddress_t__bindgen_ty_1,
    pub m_eType: ESteamIPType,
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union SteamIPAddress_t__bindgen_ty_1 {
    pub m_unIPv4: uint32,
    pub m_rgubIPv6: [uint8; 16usize],
    pub m_ipv6Qword: [uint64; 2usize],
}
#[test]
fn bindgen_test_layout_SteamIPAddress_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<SteamIPAddress_t__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(SteamIPAddress_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamIPAddress_t__bindgen_ty_1>(),
        1usize,
        concat!("Alignment of ", stringify!(SteamIPAddress_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamIPAddress_t__bindgen_ty_1>())).m_unIPv4 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamIPAddress_t__bindgen_ty_1),
            "::",
            stringify!(m_unIPv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamIPAddress_t__bindgen_ty_1>())).m_rgubIPv6 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamIPAddress_t__bindgen_ty_1),
            "::",
            stringify!(m_rgubIPv6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamIPAddress_t__bindgen_ty_1>())).m_ipv6Qword as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamIPAddress_t__bindgen_ty_1),
            "::",
            stringify!(m_ipv6Qword)
        )
    );
}
#[test]
fn bindgen_test_layout_SteamIPAddress_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamIPAddress_t>(),
        20usize,
        concat!("Size of: ", stringify!(SteamIPAddress_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamIPAddress_t>(),
        1usize,
        concat!("Alignment of ", stringify!(SteamIPAddress_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamIPAddress_t>())).m_eType as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamIPAddress_t),
            "::",
            stringify!(m_eType)
        )
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EUniverse {
    k_EUniverseInvalid = 0,
    k_EUniversePublic = 1,
    k_EUniverseBeta = 2,
    k_EUniverseInternal = 3,
    k_EUniverseDev = 4,
    k_EUniverseMax = 5,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EResult {
    k_EResultNone = 0,
    k_EResultOK = 1,
    k_EResultFail = 2,
    k_EResultNoConnection = 3,
    k_EResultInvalidPassword = 5,
    k_EResultLoggedInElsewhere = 6,
    k_EResultInvalidProtocolVer = 7,
    k_EResultInvalidParam = 8,
    k_EResultFileNotFound = 9,
    k_EResultBusy = 10,
    k_EResultInvalidState = 11,
    k_EResultInvalidName = 12,
    k_EResultInvalidEmail = 13,
    k_EResultDuplicateName = 14,
    k_EResultAccessDenied = 15,
    k_EResultTimeout = 16,
    k_EResultBanned = 17,
    k_EResultAccountNotFound = 18,
    k_EResultInvalidSteamID = 19,
    k_EResultServiceUnavailable = 20,
    k_EResultNotLoggedOn = 21,
    k_EResultPending = 22,
    k_EResultEncryptionFailure = 23,
    k_EResultInsufficientPrivilege = 24,
    k_EResultLimitExceeded = 25,
    k_EResultRevoked = 26,
    k_EResultExpired = 27,
    k_EResultAlreadyRedeemed = 28,
    k_EResultDuplicateRequest = 29,
    k_EResultAlreadyOwned = 30,
    k_EResultIPNotFound = 31,
    k_EResultPersistFailed = 32,
    k_EResultLockingFailed = 33,
    k_EResultLogonSessionReplaced = 34,
    k_EResultConnectFailed = 35,
    k_EResultHandshakeFailed = 36,
    k_EResultIOFailure = 37,
    k_EResultRemoteDisconnect = 38,
    k_EResultShoppingCartNotFound = 39,
    k_EResultBlocked = 40,
    k_EResultIgnored = 41,
    k_EResultNoMatch = 42,
    k_EResultAccountDisabled = 43,
    k_EResultServiceReadOnly = 44,
    k_EResultAccountNotFeatured = 45,
    k_EResultAdministratorOK = 46,
    k_EResultContentVersion = 47,
    k_EResultTryAnotherCM = 48,
    k_EResultPasswordRequiredToKickSession = 49,
    k_EResultAlreadyLoggedInElsewhere = 50,
    k_EResultSuspended = 51,
    k_EResultCancelled = 52,
    k_EResultDataCorruption = 53,
    k_EResultDiskFull = 54,
    k_EResultRemoteCallFailed = 55,
    k_EResultPasswordUnset = 56,
    k_EResultExternalAccountUnlinked = 57,
    k_EResultPSNTicketInvalid = 58,
    k_EResultExternalAccountAlreadyLinked = 59,
    k_EResultRemoteFileConflict = 60,
    k_EResultIllegalPassword = 61,
    k_EResultSameAsPreviousValue = 62,
    k_EResultAccountLogonDenied = 63,
    k_EResultCannotUseOldPassword = 64,
    k_EResultInvalidLoginAuthCode = 65,
    k_EResultAccountLogonDeniedNoMail = 66,
    k_EResultHardwareNotCapableOfIPT = 67,
    k_EResultIPTInitError = 68,
    k_EResultParentalControlRestricted = 69,
    k_EResultFacebookQueryError = 70,
    k_EResultExpiredLoginAuthCode = 71,
    k_EResultIPLoginRestrictionFailed = 72,
    k_EResultAccountLockedDown = 73,
    k_EResultAccountLogonDeniedVerifiedEmailRequired = 74,
    k_EResultNoMatchingURL = 75,
    k_EResultBadResponse = 76,
    k_EResultRequirePasswordReEntry = 77,
    k_EResultValueOutOfRange = 78,
    k_EResultUnexpectedError = 79,
    k_EResultDisabled = 80,
    k_EResultInvalidCEGSubmission = 81,
    k_EResultRestrictedDevice = 82,
    k_EResultRegionLocked = 83,
    k_EResultRateLimitExceeded = 84,
    k_EResultAccountLoginDeniedNeedTwoFactor = 85,
    k_EResultItemDeleted = 86,
    k_EResultAccountLoginDeniedThrottle = 87,
    k_EResultTwoFactorCodeMismatch = 88,
    k_EResultTwoFactorActivationCodeMismatch = 89,
    k_EResultAccountAssociatedToMultiplePartners = 90,
    k_EResultNotModified = 91,
    k_EResultNoMobileDevice = 92,
    k_EResultTimeNotSynced = 93,
    k_EResultSmsCodeFailed = 94,
    k_EResultAccountLimitExceeded = 95,
    k_EResultAccountActivityLimitExceeded = 96,
    k_EResultPhoneActivityLimitExceeded = 97,
    k_EResultRefundToWallet = 98,
    k_EResultEmailSendFailure = 99,
    k_EResultNotSettled = 100,
    k_EResultNeedCaptcha = 101,
    k_EResultGSLTDenied = 102,
    k_EResultGSOwnerDenied = 103,
    k_EResultInvalidItemType = 104,
    k_EResultIPBanned = 105,
    k_EResultGSLTExpired = 106,
    k_EResultInsufficientFunds = 107,
    k_EResultTooManyPending = 108,
    k_EResultNoSiteLicensesFound = 109,
    k_EResultWGNetworkSendExceeded = 110,
    k_EResultAccountNotFriends = 111,
    k_EResultLimitedUserAccount = 112,
    k_EResultCantRemoveItem = 113,
    k_EResultAccountDeleted = 114,
    k_EResultExistingUserCancelledLicense = 115,
    k_EResultCommunityCooldown = 116,
    k_EResultNoLauncherSpecified = 117,
    k_EResultMustAgreeToSSA = 118,
    k_EResultLauncherMigrated = 119,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EVoiceResult {
    k_EVoiceResultOK = 0,
    k_EVoiceResultNotInitialized = 1,
    k_EVoiceResultNotRecording = 2,
    k_EVoiceResultNoData = 3,
    k_EVoiceResultBufferTooSmall = 4,
    k_EVoiceResultDataCorrupted = 5,
    k_EVoiceResultRestricted = 6,
    k_EVoiceResultUnsupportedCodec = 7,
    k_EVoiceResultReceiverOutOfDate = 8,
    k_EVoiceResultReceiverDidNotAnswer = 9,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EDenyReason {
    k_EDenyInvalid = 0,
    k_EDenyInvalidVersion = 1,
    k_EDenyGeneric = 2,
    k_EDenyNotLoggedOn = 3,
    k_EDenyNoLicense = 4,
    k_EDenyCheater = 5,
    k_EDenyLoggedInElseWhere = 6,
    k_EDenyUnknownText = 7,
    k_EDenyIncompatibleAnticheat = 8,
    k_EDenyMemoryCorruption = 9,
    k_EDenyIncompatibleSoftware = 10,
    k_EDenySteamConnectionLost = 11,
    k_EDenySteamConnectionError = 12,
    k_EDenySteamResponseTimedOut = 13,
    k_EDenySteamValidationStalled = 14,
    k_EDenySteamOwnerLeftGuestUser = 15,
}
pub type HAuthTicket = uint32;
pub const k_HAuthTicketInvalid: HAuthTicket = 0;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EBeginAuthSessionResult {
    k_EBeginAuthSessionResultOK = 0,
    k_EBeginAuthSessionResultInvalidTicket = 1,
    k_EBeginAuthSessionResultDuplicateRequest = 2,
    k_EBeginAuthSessionResultInvalidVersion = 3,
    k_EBeginAuthSessionResultGameMismatch = 4,
    k_EBeginAuthSessionResultExpiredTicket = 5,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EAuthSessionResponse {
    k_EAuthSessionResponseOK = 0,
    k_EAuthSessionResponseUserNotConnectedToSteam = 1,
    k_EAuthSessionResponseNoLicenseOrExpired = 2,
    k_EAuthSessionResponseVACBanned = 3,
    k_EAuthSessionResponseLoggedInElseWhere = 4,
    k_EAuthSessionResponseVACCheckTimedOut = 5,
    k_EAuthSessionResponseAuthTicketCanceled = 6,
    k_EAuthSessionResponseAuthTicketInvalidAlreadyUsed = 7,
    k_EAuthSessionResponseAuthTicketInvalid = 8,
    k_EAuthSessionResponsePublisherIssuedBan = 9,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EUserHasLicenseForAppResult {
    k_EUserHasLicenseResultHasLicense = 0,
    k_EUserHasLicenseResultDoesNotHaveLicense = 1,
    k_EUserHasLicenseResultNoAuth = 2,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EAccountType {
    k_EAccountTypeInvalid = 0,
    k_EAccountTypeIndividual = 1,
    k_EAccountTypeMultiseat = 2,
    k_EAccountTypeGameServer = 3,
    k_EAccountTypeAnonGameServer = 4,
    k_EAccountTypePending = 5,
    k_EAccountTypeContentServer = 6,
    k_EAccountTypeClan = 7,
    k_EAccountTypeChat = 8,
    k_EAccountTypeConsoleUser = 9,
    k_EAccountTypeAnonUser = 10,
    k_EAccountTypeMax = 11,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EAppReleaseState {
    k_EAppReleaseState_Unknown = 0,
    k_EAppReleaseState_Unavailable = 1,
    k_EAppReleaseState_Prerelease = 2,
    k_EAppReleaseState_PreloadOnly = 3,
    k_EAppReleaseState_Released = 4,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EAppOwnershipFlags {
    k_EAppOwnershipFlags_None = 0,
    k_EAppOwnershipFlags_OwnsLicense = 1,
    k_EAppOwnershipFlags_FreeLicense = 2,
    k_EAppOwnershipFlags_RegionRestricted = 4,
    k_EAppOwnershipFlags_LowViolence = 8,
    k_EAppOwnershipFlags_InvalidPlatform = 16,
    k_EAppOwnershipFlags_SharedLicense = 32,
    k_EAppOwnershipFlags_FreeWeekend = 64,
    k_EAppOwnershipFlags_RetailLicense = 128,
    k_EAppOwnershipFlags_LicenseLocked = 256,
    k_EAppOwnershipFlags_LicensePending = 512,
    k_EAppOwnershipFlags_LicenseExpired = 1024,
    k_EAppOwnershipFlags_LicensePermanent = 2048,
    k_EAppOwnershipFlags_LicenseRecurring = 4096,
    k_EAppOwnershipFlags_LicenseCanceled = 8192,
    k_EAppOwnershipFlags_AutoGrant = 16384,
    k_EAppOwnershipFlags_PendingGift = 32768,
    k_EAppOwnershipFlags_RentalNotActivated = 65536,
    k_EAppOwnershipFlags_Rental = 131072,
    k_EAppOwnershipFlags_SiteLicense = 262144,
    k_EAppOwnershipFlags_LegacyFreeSub = 524288,
    k_EAppOwnershipFlags_InvalidOSType = 1048576,
    k_EAppOwnershipFlags_TimedTrial = 2097152,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EAppType {
    k_EAppType_Invalid = 0,
    k_EAppType_Game = 1,
    k_EAppType_Application = 2,
    k_EAppType_Tool = 4,
    k_EAppType_Demo = 8,
    k_EAppType_Media_DEPRECATED = 16,
    k_EAppType_DLC = 32,
    k_EAppType_Guide = 64,
    k_EAppType_Driver = 128,
    k_EAppType_Config = 256,
    k_EAppType_Hardware = 512,
    k_EAppType_Franchise = 1024,
    k_EAppType_Video = 2048,
    k_EAppType_Plugin = 4096,
    k_EAppType_MusicAlbum = 8192,
    k_EAppType_Series = 16384,
    k_EAppType_Comic_UNUSED = 32768,
    k_EAppType_Beta = 65536,
    k_EAppType_Shortcut = 1073741824,
    k_EAppType_DepotOnly_DEPRECATED = -2147483648,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamUserStatType {
    k_ESteamUserStatTypeINVALID = 0,
    k_ESteamUserStatTypeINT = 1,
    k_ESteamUserStatTypeFLOAT = 2,
    k_ESteamUserStatTypeAVGRATE = 3,
    k_ESteamUserStatTypeACHIEVEMENTS = 4,
    k_ESteamUserStatTypeGROUPACHIEVEMENTS = 5,
    k_ESteamUserStatTypeMAX = 6,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EChatEntryType {
    k_EChatEntryTypeInvalid = 0,
    k_EChatEntryTypeChatMsg = 1,
    k_EChatEntryTypeTyping = 2,
    k_EChatEntryTypeInviteGame = 3,
    k_EChatEntryTypeEmote = 4,
    k_EChatEntryTypeLeftConversation = 6,
    k_EChatEntryTypeEntered = 7,
    k_EChatEntryTypeWasKicked = 8,
    k_EChatEntryTypeWasBanned = 9,
    k_EChatEntryTypeDisconnected = 10,
    k_EChatEntryTypeHistoricalChat = 11,
    k_EChatEntryTypeLinkBlocked = 14,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EChatRoomEnterResponse {
    k_EChatRoomEnterResponseSuccess = 1,
    k_EChatRoomEnterResponseDoesntExist = 2,
    k_EChatRoomEnterResponseNotAllowed = 3,
    k_EChatRoomEnterResponseFull = 4,
    k_EChatRoomEnterResponseError = 5,
    k_EChatRoomEnterResponseBanned = 6,
    k_EChatRoomEnterResponseLimited = 7,
    k_EChatRoomEnterResponseClanDisabled = 8,
    k_EChatRoomEnterResponseCommunityBan = 9,
    k_EChatRoomEnterResponseMemberBlockedYou = 10,
    k_EChatRoomEnterResponseYouBlockedMember = 11,
    k_EChatRoomEnterResponseRatelimitExceeded = 15,
}
pub type PFNLegacyKeyRegistration = ::std::option::Option<
    unsafe extern "C" fn(
        pchCDKey: *const ::std::os::raw::c_char,
        pchInstallPath: *const ::std::os::raw::c_char,
    ),
>;
pub type PFNLegacyKeyInstalled = ::std::option::Option<unsafe extern "C" fn() -> bool>;
pub const k_unSteamAccountIDMask: ::std::os::raw::c_uint = 4294967295;
pub const k_unSteamAccountInstanceMask: ::std::os::raw::c_uint = 1048575;
pub const k_unSteamUserDefaultInstance: ::std::os::raw::c_uint = 1;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EChatSteamIDInstanceFlags {
    k_EChatAccountInstanceMask = 4095,
    k_EChatInstanceFlagClan = 524288,
    k_EChatInstanceFlagLobby = 262144,
    k_EChatInstanceFlagMMSLobby = 131072,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EMarketingMessageFlags {
    k_EMarketingMessageFlagsNone = 0,
    k_EMarketingMessageFlagsHighPriority = 1,
    k_EMarketingMessageFlagsPlatformWindows = 2,
    k_EMarketingMessageFlagsPlatformMac = 4,
    k_EMarketingMessageFlagsPlatformLinux = 8,
    k_EMarketingMessageFlagsPlatformRestrictions = 14,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ENotificationPosition {
    k_EPositionTopLeft = 0,
    k_EPositionTopRight = 1,
    k_EPositionBottomLeft = 2,
    k_EPositionBottomRight = 3,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EBroadcastUploadResult {
    k_EBroadcastUploadResultNone = 0,
    k_EBroadcastUploadResultOK = 1,
    k_EBroadcastUploadResultInitFailed = 2,
    k_EBroadcastUploadResultFrameFailed = 3,
    k_EBroadcastUploadResultTimeout = 4,
    k_EBroadcastUploadResultBandwidthExceeded = 5,
    k_EBroadcastUploadResultLowFPS = 6,
    k_EBroadcastUploadResultMissingKeyFrames = 7,
    k_EBroadcastUploadResultNoConnection = 8,
    k_EBroadcastUploadResultRelayFailed = 9,
    k_EBroadcastUploadResultSettingsChanged = 10,
    k_EBroadcastUploadResultMissingAudio = 11,
    k_EBroadcastUploadResultTooFarBehind = 12,
    k_EBroadcastUploadResultTranscodeBehind = 13,
    k_EBroadcastUploadResultNotAllowedToPlay = 14,
    k_EBroadcastUploadResultBusy = 15,
    k_EBroadcastUploadResultBanned = 16,
    k_EBroadcastUploadResultAlreadyActive = 17,
    k_EBroadcastUploadResultForcedOff = 18,
    k_EBroadcastUploadResultAudioBehind = 19,
    k_EBroadcastUploadResultShutdown = 20,
    k_EBroadcastUploadResultDisconnect = 21,
    k_EBroadcastUploadResultVideoInitFailed = 22,
    k_EBroadcastUploadResultAudioInitFailed = 23,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ELaunchOptionType {
    k_ELaunchOptionType_None = 0,
    k_ELaunchOptionType_Default = 1,
    k_ELaunchOptionType_SafeMode = 2,
    k_ELaunchOptionType_Multiplayer = 3,
    k_ELaunchOptionType_Config = 4,
    k_ELaunchOptionType_OpenVR = 5,
    k_ELaunchOptionType_Server = 6,
    k_ELaunchOptionType_Editor = 7,
    k_ELaunchOptionType_Manual = 8,
    k_ELaunchOptionType_Benchmark = 9,
    k_ELaunchOptionType_Option1 = 10,
    k_ELaunchOptionType_Option2 = 11,
    k_ELaunchOptionType_Option3 = 12,
    k_ELaunchOptionType_OculusVR = 13,
    k_ELaunchOptionType_OpenVROverlay = 14,
    k_ELaunchOptionType_OSVR = 15,
    k_ELaunchOptionType_Dialog = 1000,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EVRHMDType {
    k_eEVRHMDType_None = -1,
    k_eEVRHMDType_Unknown = 0,
    k_eEVRHMDType_HTC_Dev = 1,
    k_eEVRHMDType_HTC_VivePre = 2,
    k_eEVRHMDType_HTC_Vive = 3,
    k_eEVRHMDType_HTC_VivePro = 4,
    k_eEVRHMDType_HTC_ViveCosmos = 5,
    k_eEVRHMDType_HTC_Unknown = 20,
    k_eEVRHMDType_Oculus_DK1 = 21,
    k_eEVRHMDType_Oculus_DK2 = 22,
    k_eEVRHMDType_Oculus_Rift = 23,
    k_eEVRHMDType_Oculus_RiftS = 24,
    k_eEVRHMDType_Oculus_Quest = 25,
    k_eEVRHMDType_Oculus_Unknown = 40,
    k_eEVRHMDType_Acer_Unknown = 50,
    k_eEVRHMDType_Acer_WindowsMR = 51,
    k_eEVRHMDType_Dell_Unknown = 60,
    k_eEVRHMDType_Dell_Visor = 61,
    k_eEVRHMDType_Lenovo_Unknown = 70,
    k_eEVRHMDType_Lenovo_Explorer = 71,
    k_eEVRHMDType_HP_Unknown = 80,
    k_eEVRHMDType_HP_WindowsMR = 81,
    k_eEVRHMDType_HP_Reverb = 82,
    k_eEVRHMDType_HP_ReverbG2 = 1463,
    k_eEVRHMDType_Samsung_Unknown = 90,
    k_eEVRHMDType_Samsung_Odyssey = 91,
    k_eEVRHMDType_Unannounced_Unknown = 100,
    k_eEVRHMDType_Unannounced_WindowsMR = 101,
    k_eEVRHMDType_vridge = 110,
    k_eEVRHMDType_Huawei_Unknown = 120,
    k_eEVRHMDType_Huawei_VR2 = 121,
    k_eEVRHMDType_Huawei_EndOfRange = 129,
    k_eEVRHmdType_Valve_Unknown = 130,
    k_eEVRHmdType_Valve_Index = 131,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EMarketNotAllowedReasonFlags {
    k_EMarketNotAllowedReason_None = 0,
    k_EMarketNotAllowedReason_TemporaryFailure = 1,
    k_EMarketNotAllowedReason_AccountDisabled = 2,
    k_EMarketNotAllowedReason_AccountLockedDown = 4,
    k_EMarketNotAllowedReason_AccountLimited = 8,
    k_EMarketNotAllowedReason_TradeBanned = 16,
    k_EMarketNotAllowedReason_AccountNotTrusted = 32,
    k_EMarketNotAllowedReason_SteamGuardNotEnabled = 64,
    k_EMarketNotAllowedReason_SteamGuardOnlyRecentlyEnabled = 128,
    k_EMarketNotAllowedReason_RecentPasswordReset = 256,
    k_EMarketNotAllowedReason_NewPaymentMethod = 512,
    k_EMarketNotAllowedReason_InvalidCookie = 1024,
    k_EMarketNotAllowedReason_UsingNewDevice = 2048,
    k_EMarketNotAllowedReason_RecentSelfRefund = 4096,
    k_EMarketNotAllowedReason_NewPaymentMethodCannotBeVerified = 8192,
    k_EMarketNotAllowedReason_NoRecentPurchases = 16384,
    k_EMarketNotAllowedReason_AcceptedWalletGift = 32768,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EDurationControlProgress {
    k_EDurationControlProgress_Full = 0,
    k_EDurationControlProgress_Half = 1,
    k_EDurationControlProgress_None = 2,
    k_EDurationControl_ExitSoon_3h = 3,
    k_EDurationControl_ExitSoon_5h = 4,
    k_EDurationControl_ExitSoon_Night = 5,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EDurationControlNotification {
    k_EDurationControlNotification_None = 0,
    k_EDurationControlNotification_1Hour = 1,
    k_EDurationControlNotification_3Hours = 2,
    k_EDurationControlNotification_HalfProgress = 3,
    k_EDurationControlNotification_NoProgress = 4,
    k_EDurationControlNotification_ExitSoon_3h = 5,
    k_EDurationControlNotification_ExitSoon_5h = 6,
    k_EDurationControlNotification_ExitSoon_Night = 7,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EDurationControlOnlineState {
    k_EDurationControlOnlineState_Invalid = 0,
    k_EDurationControlOnlineState_Offline = 1,
    k_EDurationControlOnlineState_Online = 2,
    k_EDurationControlOnlineState_OnlineHighPri = 3,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct CSteamID {
    pub m_steamid: CSteamID_SteamID_t,
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union CSteamID_SteamID_t {
    pub m_comp: CSteamID_SteamID_t_SteamIDComponent_t,
    pub m_unAll64Bits: uint64,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct CSteamID_SteamID_t_SteamIDComponent_t {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_CSteamID_SteamID_t_SteamIDComponent_t() {
    assert_eq!(
        ::std::mem::size_of::<CSteamID_SteamID_t_SteamIDComponent_t>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(CSteamID_SteamID_t_SteamIDComponent_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<CSteamID_SteamID_t_SteamIDComponent_t>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(CSteamID_SteamID_t_SteamIDComponent_t)
        )
    );
}
impl CSteamID_SteamID_t_SteamIDComponent_t {
    #[inline]
    pub fn m_unAccountID(&self) -> uint32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 32u8) as u32) }
    }
    #[inline]
    pub fn set_m_unAccountID(&mut self, val: uint32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 32u8, val as u64)
        }
    }
    #[inline]
    pub fn m_unAccountInstance(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 20u8) as u32) }
    }
    #[inline]
    pub fn set_m_unAccountInstance(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 20u8, val as u64)
        }
    }
    #[inline]
    pub fn m_EAccountType(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(52usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_m_EAccountType(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(52usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn m_EUniverse(&self) -> EUniverse {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(56usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_m_EUniverse(&mut self, val: EUniverse) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(56usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        m_unAccountID: uint32,
        m_unAccountInstance: ::std::os::raw::c_uint,
        m_EAccountType: ::std::os::raw::c_uint,
        m_EUniverse: EUniverse,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 32u8, {
            let m_unAccountID: u32 = unsafe { ::std::mem::transmute(m_unAccountID) };
            m_unAccountID as u64
        });
        __bindgen_bitfield_unit.set(32usize, 20u8, {
            let m_unAccountInstance: u32 = unsafe { ::std::mem::transmute(m_unAccountInstance) };
            m_unAccountInstance as u64
        });
        __bindgen_bitfield_unit.set(52usize, 4u8, {
            let m_EAccountType: u32 = unsafe { ::std::mem::transmute(m_EAccountType) };
            m_EAccountType as u64
        });
        __bindgen_bitfield_unit.set(56usize, 8u8, {
            let m_EUniverse: u32 = unsafe { ::std::mem::transmute(m_EUniverse) };
            m_EUniverse as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_CSteamID_SteamID_t() {
    assert_eq!(
        ::std::mem::size_of::<CSteamID_SteamID_t>(),
        8usize,
        concat!("Size of: ", stringify!(CSteamID_SteamID_t))
    );
    assert_eq!(
        ::std::mem::align_of::<CSteamID_SteamID_t>(),
        1usize,
        concat!("Alignment of ", stringify!(CSteamID_SteamID_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CSteamID_SteamID_t>())).m_comp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamID_SteamID_t),
            "::",
            stringify!(m_comp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamID_SteamID_t>())).m_unAll64Bits as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamID_SteamID_t),
            "::",
            stringify!(m_unAll64Bits)
        )
    );
}
#[test]
fn bindgen_test_layout_CSteamID() {
    assert_eq!(
        ::std::mem::size_of::<CSteamID>(),
        8usize,
        concat!("Size of: ", stringify!(CSteamID))
    );
    assert_eq!(
        ::std::mem::align_of::<CSteamID>(),
        1usize,
        concat!("Alignment of ", stringify!(CSteamID))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CSteamID>())).m_steamid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamID),
            "::",
            stringify!(m_steamid)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}?IsValid@CSteamID@@QEBA_NXZ"]
    pub fn CSteamID_IsValid(this: *const CSteamID) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?Render@CSteamID@@QEBAPEBDXZ"]
    pub fn CSteamID_Render(this: *const CSteamID) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}?Render@CSteamID@@SAPEBD_K@Z"]
    pub fn CSteamID_Render1(ulSteamID: uint64) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}?SetFromString@CSteamID@@QEAAXPEBDW4EUniverse@@@Z"]
    pub fn CSteamID_SetFromString(
        this: *mut CSteamID,
        pchSteamID: *const ::std::os::raw::c_char,
        eDefaultUniverse: EUniverse,
    );
}
extern "C" {
    #[link_name = "\u{1}?SetFromStringStrict@CSteamID@@QEAA_NPEBDW4EUniverse@@@Z"]
    pub fn CSteamID_SetFromStringStrict(
        this: *mut CSteamID,
        pchSteamID: *const ::std::os::raw::c_char,
        eDefaultUniverse: EUniverse,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?SetFromSteam2String@CSteamID@@QEAA_NPEBDW4EUniverse@@@Z"]
    pub fn CSteamID_SetFromSteam2String(
        this: *mut CSteamID,
        pchSteam2ID: *const ::std::os::raw::c_char,
        eUniverse: EUniverse,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?BValidExternalSteamID@CSteamID@@QEBA_NXZ"]
    pub fn CSteamID_BValidExternalSteamID(this: *const CSteamID) -> bool;
}
extern "C" {
    #[link_name = "\u{1}??0CSteamID@@QEAA@PEBDW4EUniverse@@@Z"]
    pub fn CSteamID_CSteamID(
        this: *mut CSteamID,
        pchSteamID: *const ::std::os::raw::c_char,
        eDefaultUniverse: EUniverse,
    );
}
impl CSteamID {
    #[inline]
    pub unsafe fn IsValid(&self) -> bool {
        CSteamID_IsValid(self)
    }
    #[inline]
    pub unsafe fn Render(&self) -> *const ::std::os::raw::c_char {
        CSteamID_Render(self)
    }
    #[inline]
    pub unsafe fn Render1(ulSteamID: uint64) -> *const ::std::os::raw::c_char {
        CSteamID_Render1(ulSteamID)
    }
    #[inline]
    pub unsafe fn SetFromString(
        &mut self,
        pchSteamID: *const ::std::os::raw::c_char,
        eDefaultUniverse: EUniverse,
    ) {
        CSteamID_SetFromString(self, pchSteamID, eDefaultUniverse)
    }
    #[inline]
    pub unsafe fn SetFromStringStrict(
        &mut self,
        pchSteamID: *const ::std::os::raw::c_char,
        eDefaultUniverse: EUniverse,
    ) -> bool {
        CSteamID_SetFromStringStrict(self, pchSteamID, eDefaultUniverse)
    }
    #[inline]
    pub unsafe fn SetFromSteam2String(
        &mut self,
        pchSteam2ID: *const ::std::os::raw::c_char,
        eUniverse: EUniverse,
    ) -> bool {
        CSteamID_SetFromSteam2String(self, pchSteam2ID, eUniverse)
    }
    #[inline]
    pub unsafe fn BValidExternalSteamID(&self) -> bool {
        CSteamID_BValidExternalSteamID(self)
    }
    #[inline]
    pub unsafe fn new(
        pchSteamID: *const ::std::os::raw::c_char,
        eDefaultUniverse: EUniverse,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        CSteamID_CSteamID(__bindgen_tmp.as_mut_ptr(), pchSteamID, eDefaultUniverse);
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct CGameID {
    pub __bindgen_anon_1: CGameID__bindgen_ty_1,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum CGameID_EGameIDType {
    k_EGameIDTypeApp = 0,
    k_EGameIDTypeGameMod = 1,
    k_EGameIDTypeShortcut = 2,
    k_EGameIDTypeP2P = 3,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct CGameID_GameID_t {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[test]
fn bindgen_test_layout_CGameID_GameID_t() {
    assert_eq!(
        ::std::mem::size_of::<CGameID_GameID_t>(),
        8usize,
        concat!("Size of: ", stringify!(CGameID_GameID_t))
    );
    assert_eq!(
        ::std::mem::align_of::<CGameID_GameID_t>(),
        1usize,
        concat!("Alignment of ", stringify!(CGameID_GameID_t))
    );
}
impl CGameID_GameID_t {
    #[inline]
    pub fn m_nAppID(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_m_nAppID(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn m_nType(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_m_nType(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn m_nModID(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 32u8) as u32) }
    }
    #[inline]
    pub fn set_m_nModID(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 32u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        m_nAppID: ::std::os::raw::c_uint,
        m_nType: ::std::os::raw::c_uint,
        m_nModID: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let m_nAppID: u32 = unsafe { ::std::mem::transmute(m_nAppID) };
            m_nAppID as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let m_nType: u32 = unsafe { ::std::mem::transmute(m_nType) };
            m_nType as u64
        });
        __bindgen_bitfield_unit.set(32usize, 32u8, {
            let m_nModID: u32 = unsafe { ::std::mem::transmute(m_nModID) };
            m_nModID as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union CGameID__bindgen_ty_1 {
    pub m_ulGameID: uint64,
    pub m_gameID: CGameID_GameID_t,
}
#[test]
fn bindgen_test_layout_CGameID__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<CGameID__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(CGameID__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<CGameID__bindgen_ty_1>(),
        1usize,
        concat!("Alignment of ", stringify!(CGameID__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CGameID__bindgen_ty_1>())).m_ulGameID as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CGameID__bindgen_ty_1),
            "::",
            stringify!(m_ulGameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CGameID__bindgen_ty_1>())).m_gameID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CGameID__bindgen_ty_1),
            "::",
            stringify!(m_gameID)
        )
    );
}
#[test]
fn bindgen_test_layout_CGameID() {
    assert_eq!(
        ::std::mem::size_of::<CGameID>(),
        8usize,
        concat!("Size of: ", stringify!(CGameID))
    );
    assert_eq!(
        ::std::mem::align_of::<CGameID>(),
        1usize,
        concat!("Alignment of ", stringify!(CGameID))
    );
}
extern "C" {
    #[link_name = "\u{1}?Render@CGameID@@QEBAPEBDXZ"]
    pub fn CGameID_Render(this: *const CGameID) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}?Render@CGameID@@SAPEBD_K@Z"]
    pub fn CGameID_Render1(ulGameID: uint64) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}??0CGameID@@QEAA@PEBD@Z"]
    pub fn CGameID_CGameID(this: *mut CGameID, pchGameID: *const ::std::os::raw::c_char);
}
impl CGameID {
    #[inline]
    pub unsafe fn Render(&self) -> *const ::std::os::raw::c_char {
        CGameID_Render(self)
    }
    #[inline]
    pub unsafe fn Render1(ulGameID: uint64) -> *const ::std::os::raw::c_char {
        CGameID_Render1(ulGameID)
    }
    #[inline]
    pub unsafe fn new(pchGameID: *const ::std::os::raw::c_char) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        CGameID_CGameID(__bindgen_tmp.as_mut_ptr(), pchGameID);
        __bindgen_tmp.assume_init()
    }
}
pub const k_cchGameExtraInfoMax: ::std::os::raw::c_int = 64;
pub type PFNPreMinidumpCallback =
    ::std::option::Option<unsafe extern "C" fn(context: *mut ::std::os::raw::c_void)>;
pub type BREAKPAD_HANDLE = *mut ::std::os::raw::c_void;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EGameSearchErrorCode_t {
    k_EGameSearchErrorCode_OK = 1,
    k_EGameSearchErrorCode_Failed_Search_Already_In_Progress = 2,
    k_EGameSearchErrorCode_Failed_No_Search_In_Progress = 3,
    k_EGameSearchErrorCode_Failed_Not_Lobby_Leader = 4,
    k_EGameSearchErrorCode_Failed_No_Host_Available = 5,
    k_EGameSearchErrorCode_Failed_Search_Params_Invalid = 6,
    k_EGameSearchErrorCode_Failed_Offline = 7,
    k_EGameSearchErrorCode_Failed_NotAuthorized = 8,
    k_EGameSearchErrorCode_Failed_Unknown_Error = 9,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EPlayerResult_t {
    k_EPlayerResultFailedToConnect = 1,
    k_EPlayerResultAbandoned = 2,
    k_EPlayerResultKicked = 3,
    k_EPlayerResultIncomplete = 4,
    k_EPlayerResultCompleted = 5,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamIPv6ConnectivityProtocol {
    k_ESteamIPv6ConnectivityProtocol_Invalid = 0,
    k_ESteamIPv6ConnectivityProtocol_HTTP = 1,
    k_ESteamIPv6ConnectivityProtocol_UDP = 2,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamIPv6ConnectivityState {
    k_ESteamIPv6ConnectivityState_Unknown = 0,
    k_ESteamIPv6ConnectivityState_Good = 1,
    k_ESteamIPv6ConnectivityState_Bad = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ValvePackingSentinel_t {
    pub m_u32: uint32,
    pub m_u64: uint64,
    pub m_u16: uint16,
    pub m_d: f64,
}
#[test]
fn bindgen_test_layout_ValvePackingSentinel_t() {
    assert_eq!(
        ::std::mem::size_of::<ValvePackingSentinel_t>(),
        32usize,
        concat!("Size of: ", stringify!(ValvePackingSentinel_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ValvePackingSentinel_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ValvePackingSentinel_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ValvePackingSentinel_t>())).m_u32 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ValvePackingSentinel_t),
            "::",
            stringify!(m_u32)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ValvePackingSentinel_t>())).m_u64 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ValvePackingSentinel_t),
            "::",
            stringify!(m_u64)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ValvePackingSentinel_t>())).m_u16 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ValvePackingSentinel_t),
            "::",
            stringify!(m_u16)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ValvePackingSentinel_t>())).m_d as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ValvePackingSentinel_t),
            "::",
            stringify!(m_d)
        )
    );
}
pub type compile_time_assert_type = [::std::os::raw::c_char; 1usize];
pub type HSteamPipe = int32;
pub type HSteamUser = int32;
pub type SteamAPIWarningMessageHook_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: ::std::os::raw::c_int, arg2: *const ::std::os::raw::c_char),
>;
pub type SteamAPI_CheckCallbackRegistered_t =
    ::std::option::Option<unsafe extern "C" fn(iCallbackNum: ::std::os::raw::c_int) -> uint32>;
extern "C" {
    pub fn SteamAPI_RunCallbacks();
}
extern "C" {
    pub fn SteamGameServer_RunCallbacks();
}
#[repr(C)]
pub struct CCallbackBase__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CCallbackBase {
    pub vtable_: *const CCallbackBase__bindgen_vtable,
    pub m_nCallbackFlags: uint8,
    pub m_iCallback: ::std::os::raw::c_int,
}
pub const CCallbackBase_k_ECallbackFlagsRegistered: CCallbackBase__bindgen_ty_1 =
    CCallbackBase__bindgen_ty_1::k_ECallbackFlagsRegistered;
pub const CCallbackBase_k_ECallbackFlagsGameServer: CCallbackBase__bindgen_ty_1 =
    CCallbackBase__bindgen_ty_1::k_ECallbackFlagsGameServer;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum CCallbackBase__bindgen_ty_1 {
    k_ECallbackFlagsRegistered = 1,
    k_ECallbackFlagsGameServer = 2,
}
#[test]
fn bindgen_test_layout_CCallbackBase() {
    assert_eq!(
        ::std::mem::size_of::<CCallbackBase>(),
        16usize,
        concat!("Size of: ", stringify!(CCallbackBase))
    );
    assert_eq!(
        ::std::mem::align_of::<CCallbackBase>(),
        8usize,
        concat!("Alignment of ", stringify!(CCallbackBase))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CCallbackBase>())).m_nCallbackFlags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(CCallbackBase),
            "::",
            stringify!(m_nCallbackFlags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CCallbackBase>())).m_iCallback as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(CCallbackBase),
            "::",
            stringify!(m_iCallback)
        )
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct CCallResult<T, P> {
    pub _base: CCallbackBase,
    pub m_hAPICall: SteamAPICall_t,
    pub m_pObj: *mut T,
    pub m_Func: CCallResult_func_t<P>,
    pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
    pub _phantom_1: ::std::marker::PhantomData<::std::cell::UnsafeCell<P>>,
}
pub type CCallResult_func_t<P> =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut P, arg2: bool)>;
pub type CCallback_func_t<P> = ::std::option::Option<unsafe extern "C" fn(arg1: *mut P)>;
pub type va_list = *mut ::std::os::raw::c_char;
extern "C" {
    pub fn __va_start(arg1: *mut va_list, ...);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __vcrt_va_list_is_reference {
    pub _address: u8,
}
pub const __vcrt_va_list_is_reference___the_value: __vcrt_va_list_is_reference__bindgen_ty_1 =
    __vcrt_va_list_is_reference__bindgen_ty_1::__the_value;
#[repr(u8)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum __vcrt_va_list_is_reference__bindgen_ty_1 {
    __the_value = 0,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __vcrt_assert_va_start_is_not_reference {
    pub _address: u8,
}
pub type size_t = ::std::os::raw::c_ulonglong;
pub type __vcrt_bool = bool;
extern "C" {
    pub fn __security_init_cookie();
}
extern "C" {
    pub fn __security_check_cookie(_StackCookie: usize);
}
extern "C" {
    pub fn __report_gsfailure(_StackCookie: usize);
}
extern "C" {
    pub static mut __security_cookie: usize;
}
pub type __crt_bool = bool;
extern "C" {
    pub fn _invalid_parameter_noinfo();
}
extern "C" {
    pub fn _invalid_parameter_noinfo_noreturn();
}
extern "C" {
    pub fn _invoke_watson(
        _Expression: *const u16,
        _FunctionName: *const u16,
        _FileName: *const u16,
        _LineNo: ::std::os::raw::c_uint,
        _Reserved: usize,
    );
}
pub type errno_t = ::std::os::raw::c_int;
pub type wint_t = ::std::os::raw::c_ushort;
pub type wctype_t = ::std::os::raw::c_ushort;
pub type __time32_t = ::std::os::raw::c_long;
pub type __time64_t = ::std::os::raw::c_longlong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __crt_locale_data_public {
    pub _locale_pctype: *const ::std::os::raw::c_ushort,
    pub _locale_mb_cur_max: ::std::os::raw::c_int,
    pub _locale_lc_codepage: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___crt_locale_data_public() {
    assert_eq!(
        ::std::mem::size_of::<__crt_locale_data_public>(),
        16usize,
        concat!("Size of: ", stringify!(__crt_locale_data_public))
    );
    assert_eq!(
        ::std::mem::align_of::<__crt_locale_data_public>(),
        8usize,
        concat!("Alignment of ", stringify!(__crt_locale_data_public))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__crt_locale_data_public>()))._locale_pctype as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__crt_locale_data_public),
            "::",
            stringify!(_locale_pctype)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__crt_locale_data_public>()))._locale_mb_cur_max as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__crt_locale_data_public),
            "::",
            stringify!(_locale_mb_cur_max)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__crt_locale_data_public>()))._locale_lc_codepage as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__crt_locale_data_public),
            "::",
            stringify!(_locale_lc_codepage)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __crt_locale_pointers {
    pub locinfo: *mut __crt_locale_data,
    pub mbcinfo: *mut __crt_multibyte_data,
}
#[test]
fn bindgen_test_layout___crt_locale_pointers() {
    assert_eq!(
        ::std::mem::size_of::<__crt_locale_pointers>(),
        16usize,
        concat!("Size of: ", stringify!(__crt_locale_pointers))
    );
    assert_eq!(
        ::std::mem::align_of::<__crt_locale_pointers>(),
        8usize,
        concat!("Alignment of ", stringify!(__crt_locale_pointers))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__crt_locale_pointers>())).locinfo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__crt_locale_pointers),
            "::",
            stringify!(locinfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__crt_locale_pointers>())).mbcinfo as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__crt_locale_pointers),
            "::",
            stringify!(mbcinfo)
        )
    );
}
pub type _locale_t = *mut __crt_locale_pointers;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _Mbstatet {
    pub _Wchar: ::std::os::raw::c_ulong,
    pub _Byte: ::std::os::raw::c_ushort,
    pub _State: ::std::os::raw::c_ushort,
}
#[test]
fn bindgen_test_layout__Mbstatet() {
    assert_eq!(
        ::std::mem::size_of::<_Mbstatet>(),
        8usize,
        concat!("Size of: ", stringify!(_Mbstatet))
    );
    assert_eq!(
        ::std::mem::align_of::<_Mbstatet>(),
        4usize,
        concat!("Alignment of ", stringify!(_Mbstatet))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_Mbstatet>()))._Wchar as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_Mbstatet),
            "::",
            stringify!(_Wchar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_Mbstatet>()))._Byte as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_Mbstatet),
            "::",
            stringify!(_Byte)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_Mbstatet>()))._State as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(_Mbstatet),
            "::",
            stringify!(_State)
        )
    );
}
pub type mbstate_t = _Mbstatet;
pub type time_t = __time64_t;
pub type rsize_t = size_t;
extern "C" {
    pub fn _errno() -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn _set_errno(_Value: ::std::os::raw::c_int) -> errno_t;
}
extern "C" {
    pub fn _get_errno(_Value: *mut ::std::os::raw::c_int) -> errno_t;
}
extern "C" {
    pub fn __doserrno() -> *mut ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn _set_doserrno(_Value: ::std::os::raw::c_ulong) -> errno_t;
}
extern "C" {
    pub fn _get_doserrno(_Value: *mut ::std::os::raw::c_ulong) -> errno_t;
}
extern "C" {
    pub fn memchr(
        _Buf: *const ::std::os::raw::c_void,
        _Val: ::std::os::raw::c_int,
        _MaxCount: size_t,
    ) -> *const ::std::os::raw::c_void;
}
extern "C" {
    pub fn memcmp(
        _Buf1: *const ::std::os::raw::c_void,
        _Buf2: *const ::std::os::raw::c_void,
        _Size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memcpy(
        _Dst: *mut ::std::os::raw::c_void,
        _Src: *const ::std::os::raw::c_void,
        _Size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memmove(
        _Dst: *mut ::std::os::raw::c_void,
        _Src: *const ::std::os::raw::c_void,
        _Size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memset(
        _Dst: *mut ::std::os::raw::c_void,
        _Val: ::std::os::raw::c_int,
        _Size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strchr(
        _Str: *const ::std::os::raw::c_char,
        _Val: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn strrchr(
        _Str: *const ::std::os::raw::c_char,
        _Ch: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn strstr(
        _Str: *const ::std::os::raw::c_char,
        _SubStr: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn wcschr(_Str: *const u16, _Ch: u16) -> *const u16;
}
extern "C" {
    pub fn wcsrchr(_Str: *const u16, _Ch: u16) -> *const u16;
}
extern "C" {
    pub fn wcsstr(_Str: *const u16, _SubStr: *const u16) -> *const u16;
}
extern "C" {
    pub fn _memicmp(
        _Buf1: *const ::std::os::raw::c_void,
        _Buf2: *const ::std::os::raw::c_void,
        _Size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _memicmp_l(
        _Buf1: *const ::std::os::raw::c_void,
        _Buf2: *const ::std::os::raw::c_void,
        _Size: size_t,
        _Locale: _locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn memccpy(
        _Dst: *mut ::std::os::raw::c_void,
        _Src: *const ::std::os::raw::c_void,
        _Val: ::std::os::raw::c_int,
        _Size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn memicmp(
        _Buf1: *const ::std::os::raw::c_void,
        _Buf2: *const ::std::os::raw::c_void,
        _Size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcscat_s(_Destination: *mut u16, _SizeInWords: rsize_t, _Source: *const u16) -> errno_t;
}
extern "C" {
    pub fn wcscpy_s(_Destination: *mut u16, _SizeInWords: rsize_t, _Source: *const u16) -> errno_t;
}
extern "C" {
    pub fn wcsncat_s(
        _Destination: *mut u16,
        _SizeInWords: rsize_t,
        _Source: *const u16,
        _MaxCount: rsize_t,
    ) -> errno_t;
}
extern "C" {
    pub fn wcsncpy_s(
        _Destination: *mut u16,
        _SizeInWords: rsize_t,
        _Source: *const u16,
        _MaxCount: rsize_t,
    ) -> errno_t;
}
extern "C" {
    pub fn wcstok_s(_String: *mut u16, _Delimiter: *const u16, _Context: *mut *mut u16)
        -> *mut u16;
}
extern "C" {
    pub fn _wcsdup(_String: *const u16) -> *mut u16;
}
extern "C" {
    pub fn wcscat(_Destination: *mut u16, _Source: *const u16) -> *mut u16;
}
extern "C" {
    pub fn wcscmp(_String1: *const u16, _String2: *const u16) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcscpy(_Destination: *mut u16, _Source: *const u16) -> *mut u16;
}
extern "C" {
    pub fn wcscspn(_String: *const u16, _Control: *const u16) -> size_t;
}
extern "C" {
    pub fn wcslen(_String: *const u16) -> size_t;
}
extern "C" {
    pub fn wcsnlen(_Source: *const u16, _MaxCount: size_t) -> size_t;
}
extern "C" {
    pub fn wcsncat(_Destination: *mut u16, _Source: *const u16, _Count: size_t) -> *mut u16;
}
extern "C" {
    pub fn wcsncmp(
        _String1: *const u16,
        _String2: *const u16,
        _MaxCount: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcsncpy(_Destination: *mut u16, _Source: *const u16, _Count: size_t) -> *mut u16;
}
extern "C" {
    pub fn wcspbrk(_String: *const u16, _Control: *const u16) -> *const u16;
}
extern "C" {
    pub fn wcsspn(_String: *const u16, _Control: *const u16) -> size_t;
}
extern "C" {
    pub fn wcstok(_String: *mut u16, _Delimiter: *const u16, _Context: *mut *mut u16) -> *mut u16;
}
extern "C" {
    pub fn _wcserror(_ErrorNumber: ::std::os::raw::c_int) -> *mut u16;
}
extern "C" {
    pub fn _wcserror_s(
        _Buffer: *mut u16,
        _SizeInWords: size_t,
        _ErrorNumber: ::std::os::raw::c_int,
    ) -> errno_t;
}
extern "C" {
    pub fn __wcserror(_String: *const u16) -> *mut u16;
}
extern "C" {
    pub fn __wcserror_s(
        _Buffer: *mut u16,
        _SizeInWords: size_t,
        _ErrorMessage: *const u16,
    ) -> errno_t;
}
extern "C" {
    pub fn _wcsicmp(_String1: *const u16, _String2: *const u16) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wcsicmp_l(
        _String1: *const u16,
        _String2: *const u16,
        _Locale: _locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wcsnicmp(
        _String1: *const u16,
        _String2: *const u16,
        _MaxCount: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wcsnicmp_l(
        _String1: *const u16,
        _String2: *const u16,
        _MaxCount: size_t,
        _Locale: _locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wcsnset_s(
        _Destination: *mut u16,
        _SizeInWords: size_t,
        _Value: u16,
        _MaxCount: size_t,
    ) -> errno_t;
}
extern "C" {
    pub fn _wcsnset(_String: *mut u16, _Value: u16, _MaxCount: size_t) -> *mut u16;
}
extern "C" {
    pub fn _wcsrev(_String: *mut u16) -> *mut u16;
}
extern "C" {
    pub fn _wcsset_s(_Destination: *mut u16, _SizeInWords: size_t, _Value: u16) -> errno_t;
}
extern "C" {
    pub fn _wcsset(_String: *mut u16, _Value: u16) -> *mut u16;
}
extern "C" {
    pub fn _wcslwr_s(_String: *mut u16, _SizeInWords: size_t) -> errno_t;
}
extern "C" {
    pub fn _wcslwr(_String: *mut u16) -> *mut u16;
}
extern "C" {
    pub fn _wcslwr_s_l(_String: *mut u16, _SizeInWords: size_t, _Locale: _locale_t) -> errno_t;
}
extern "C" {
    pub fn _wcslwr_l(_String: *mut u16, _Locale: _locale_t) -> *mut u16;
}
extern "C" {
    pub fn _wcsupr_s(_String: *mut u16, _Size: size_t) -> errno_t;
}
extern "C" {
    pub fn _wcsupr(_String: *mut u16) -> *mut u16;
}
extern "C" {
    pub fn _wcsupr_s_l(_String: *mut u16, _Size: size_t, _Locale: _locale_t) -> errno_t;
}
extern "C" {
    pub fn _wcsupr_l(_String: *mut u16, _Locale: _locale_t) -> *mut u16;
}
extern "C" {
    pub fn wcsxfrm(_Destination: *mut u16, _Source: *const u16, _MaxCount: size_t) -> size_t;
}
extern "C" {
    pub fn _wcsxfrm_l(
        _Destination: *mut u16,
        _Source: *const u16,
        _MaxCount: size_t,
        _Locale: _locale_t,
    ) -> size_t;
}
extern "C" {
    pub fn wcscoll(_String1: *const u16, _String2: *const u16) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wcscoll_l(
        _String1: *const u16,
        _String2: *const u16,
        _Locale: _locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wcsicoll(_String1: *const u16, _String2: *const u16) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wcsicoll_l(
        _String1: *const u16,
        _String2: *const u16,
        _Locale: _locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wcsncoll(
        _String1: *const u16,
        _String2: *const u16,
        _MaxCount: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wcsncoll_l(
        _String1: *const u16,
        _String2: *const u16,
        _MaxCount: size_t,
        _Locale: _locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wcsnicoll(
        _String1: *const u16,
        _String2: *const u16,
        _MaxCount: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wcsnicoll_l(
        _String1: *const u16,
        _String2: *const u16,
        _MaxCount: size_t,
        _Locale: _locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcsdup(_String: *const u16) -> *mut u16;
}
extern "C" {
    pub fn wcsicmp(_String1: *const u16, _String2: *const u16) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcsnicmp(
        _String1: *const u16,
        _String2: *const u16,
        _MaxCount: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcsnset(_String: *mut u16, _Value: u16, _MaxCount: size_t) -> *mut u16;
}
extern "C" {
    pub fn wcsrev(_String: *mut u16) -> *mut u16;
}
extern "C" {
    pub fn wcsset(_String: *mut u16, _Value: u16) -> *mut u16;
}
extern "C" {
    pub fn wcslwr(_String: *mut u16) -> *mut u16;
}
extern "C" {
    pub fn wcsupr(_String: *mut u16) -> *mut u16;
}
extern "C" {
    pub fn wcsicoll(_String1: *const u16, _String2: *const u16) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcpy_s(
        _Destination: *mut ::std::os::raw::c_char,
        _SizeInBytes: rsize_t,
        _Source: *const ::std::os::raw::c_char,
    ) -> errno_t;
}
extern "C" {
    pub fn strcat_s(
        _Destination: *mut ::std::os::raw::c_char,
        _SizeInBytes: rsize_t,
        _Source: *const ::std::os::raw::c_char,
    ) -> errno_t;
}
extern "C" {
    pub fn strerror_s(
        _Buffer: *mut ::std::os::raw::c_char,
        _SizeInBytes: size_t,
        _ErrorNumber: ::std::os::raw::c_int,
    ) -> errno_t;
}
extern "C" {
    pub fn strncat_s(
        _Destination: *mut ::std::os::raw::c_char,
        _SizeInBytes: rsize_t,
        _Source: *const ::std::os::raw::c_char,
        _MaxCount: rsize_t,
    ) -> errno_t;
}
extern "C" {
    pub fn strncpy_s(
        _Destination: *mut ::std::os::raw::c_char,
        _SizeInBytes: rsize_t,
        _Source: *const ::std::os::raw::c_char,
        _MaxCount: rsize_t,
    ) -> errno_t;
}
extern "C" {
    pub fn strtok_s(
        _String: *mut ::std::os::raw::c_char,
        _Delimiter: *const ::std::os::raw::c_char,
        _Context: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn _memccpy(
        _Dst: *mut ::std::os::raw::c_void,
        _Src: *const ::std::os::raw::c_void,
        _Val: ::std::os::raw::c_int,
        _MaxCount: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strcat(
        _Destination: *mut ::std::os::raw::c_char,
        _Source: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcmp(
        _Str1: *const ::std::os::raw::c_char,
        _Str2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _strcmpi(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcoll(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _strcoll_l(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strcpy(
        _Destination: *mut ::std::os::raw::c_char,
        _Source: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcspn(
        _Str: *const ::std::os::raw::c_char,
        _Control: *const ::std::os::raw::c_char,
    ) -> size_t;
}
extern "C" {
    pub fn _strdup(_Source: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn _strerror(_ErrorMessage: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn _strerror_s(
        _Buffer: *mut ::std::os::raw::c_char,
        _SizeInBytes: size_t,
        _ErrorMessage: *const ::std::os::raw::c_char,
    ) -> errno_t;
}
extern "C" {
    pub fn strerror(_ErrorMessage: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn _stricmp(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _stricoll(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _stricoll_l(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _stricmp_l(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strlen(_Str: *const ::std::os::raw::c_char) -> size_t;
}
extern "C" {
    pub fn _strlwr_s(_String: *mut ::std::os::raw::c_char, _Size: size_t) -> errno_t;
}
extern "C" {
    pub fn _strlwr(_String: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn _strlwr_s_l(
        _String: *mut ::std::os::raw::c_char,
        _Size: size_t,
        _Locale: _locale_t,
    ) -> errno_t;
}
extern "C" {
    pub fn _strlwr_l(
        _String: *mut ::std::os::raw::c_char,
        _Locale: _locale_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncat(
        _Destination: *mut ::std::os::raw::c_char,
        _Source: *const ::std::os::raw::c_char,
        _Count: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strncmp(
        _Str1: *const ::std::os::raw::c_char,
        _Str2: *const ::std::os::raw::c_char,
        _MaxCount: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _strnicmp(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
        _MaxCount: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _strnicmp_l(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Locale: _locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _strnicoll(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
        _MaxCount: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _strnicoll_l(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Locale: _locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _strncoll(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
        _MaxCount: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _strncoll_l(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Locale: _locale_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __strncnt(_String: *const ::std::os::raw::c_char, _Count: size_t) -> size_t;
}
extern "C" {
    pub fn strncpy(
        _Destination: *mut ::std::os::raw::c_char,
        _Source: *const ::std::os::raw::c_char,
        _Count: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strnlen(_String: *const ::std::os::raw::c_char, _MaxCount: size_t) -> size_t;
}
extern "C" {
    pub fn _strnset_s(
        _String: *mut ::std::os::raw::c_char,
        _SizeInBytes: size_t,
        _Value: ::std::os::raw::c_int,
        _MaxCount: size_t,
    ) -> errno_t;
}
extern "C" {
    pub fn _strnset(
        _Destination: *mut ::std::os::raw::c_char,
        _Value: ::std::os::raw::c_int,
        _Count: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strpbrk(
        _Str: *const ::std::os::raw::c_char,
        _Control: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn _strrev(_Str: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn _strset_s(
        _Destination: *mut ::std::os::raw::c_char,
        _DestinationSize: size_t,
        _Value: ::std::os::raw::c_int,
    ) -> errno_t;
}
extern "C" {
    pub fn _strset(
        _Destination: *mut ::std::os::raw::c_char,
        _Value: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strspn(
        _Str: *const ::std::os::raw::c_char,
        _Control: *const ::std::os::raw::c_char,
    ) -> size_t;
}
extern "C" {
    pub fn strtok(
        _String: *mut ::std::os::raw::c_char,
        _Delimiter: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn _strupr_s(_String: *mut ::std::os::raw::c_char, _Size: size_t) -> errno_t;
}
extern "C" {
    pub fn _strupr(_String: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn _strupr_s_l(
        _String: *mut ::std::os::raw::c_char,
        _Size: size_t,
        _Locale: _locale_t,
    ) -> errno_t;
}
extern "C" {
    pub fn _strupr_l(
        _String: *mut ::std::os::raw::c_char,
        _Locale: _locale_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strxfrm(
        _Destination: *mut ::std::os::raw::c_char,
        _Source: *const ::std::os::raw::c_char,
        _MaxCount: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn _strxfrm_l(
        _Destination: *mut ::std::os::raw::c_char,
        _Source: *const ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Locale: _locale_t,
    ) -> size_t;
}
extern "C" {
    pub fn strdup(_String: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strcmpi(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn stricmp(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strlwr(_String: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strnicmp(
        _String1: *const ::std::os::raw::c_char,
        _String2: *const ::std::os::raw::c_char,
        _MaxCount: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn strnset(
        _String: *mut ::std::os::raw::c_char,
        _Value: ::std::os::raw::c_int,
        _MaxCount: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strrev(_String: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strset(
        _String: *mut ::std::os::raw::c_char,
        _Value: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn strupr(_String: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_GetHSteamPipe() -> HSteamPipe;
}
extern "C" {
    pub fn SteamAPI_GetHSteamUser() -> HSteamUser;
}
extern "C" {
    pub fn SteamGameServer_GetHSteamPipe() -> HSteamPipe;
}
extern "C" {
    pub fn SteamGameServer_GetHSteamUser() -> HSteamUser;
}
extern "C" {
    pub fn SteamInternal_ContextInit(
        pContextInitData: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn SteamInternal_CreateInterface(
        ver: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn SteamInternal_FindOrCreateUserInterface(
        hSteamUser: HSteamUser,
        pszVersion: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn SteamInternal_FindOrCreateGameServerInterface(
        hSteamUser: HSteamUser,
        pszVersion: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn SteamAPI_RegisterCallback(
        pCallback: *mut CCallbackBase,
        iCallback: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_UnregisterCallback(pCallback: *mut CCallbackBase);
}
extern "C" {
    pub fn SteamAPI_RegisterCallResult(pCallback: *mut CCallbackBase, hAPICall: SteamAPICall_t);
}
extern "C" {
    pub fn SteamAPI_UnregisterCallResult(pCallback: *mut CCallbackBase, hAPICall: SteamAPICall_t);
}
#[doc = " Internal structure used in manual callback dispatch"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CallbackMsg_t {
    pub m_hSteamUser: HSteamUser,
    pub m_iCallback: ::std::os::raw::c_int,
    pub m_pubParam: *mut uint8,
    pub m_cubParam: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_CallbackMsg_t() {
    assert_eq!(
        ::std::mem::size_of::<CallbackMsg_t>(),
        24usize,
        concat!("Size of: ", stringify!(CallbackMsg_t))
    );
    assert_eq!(
        ::std::mem::align_of::<CallbackMsg_t>(),
        8usize,
        concat!("Alignment of ", stringify!(CallbackMsg_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CallbackMsg_t>())).m_hSteamUser as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CallbackMsg_t),
            "::",
            stringify!(m_hSteamUser)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CallbackMsg_t>())).m_iCallback as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(CallbackMsg_t),
            "::",
            stringify!(m_iCallback)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CallbackMsg_t>())).m_pubParam as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(CallbackMsg_t),
            "::",
            stringify!(m_pubParam)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CallbackMsg_t>())).m_cubParam as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(CallbackMsg_t),
            "::",
            stringify!(m_cubParam)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamContentServer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamPS3OverlayRender {
    _unused: [u8; 0],
}
pub const k_iSteamUserCallbacks: _bindgen_ty_1 = _bindgen_ty_1::k_iSteamUserCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_1 {
    k_iSteamUserCallbacks = 100,
}
pub const k_iSteamGameServerCallbacks: _bindgen_ty_2 = _bindgen_ty_2::k_iSteamGameServerCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_2 {
    k_iSteamGameServerCallbacks = 200,
}
pub const k_iSteamFriendsCallbacks: _bindgen_ty_3 = _bindgen_ty_3::k_iSteamFriendsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_3 {
    k_iSteamFriendsCallbacks = 300,
}
pub const k_iSteamBillingCallbacks: _bindgen_ty_4 = _bindgen_ty_4::k_iSteamBillingCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_4 {
    k_iSteamBillingCallbacks = 400,
}
pub const k_iSteamMatchmakingCallbacks: _bindgen_ty_5 = _bindgen_ty_5::k_iSteamMatchmakingCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_5 {
    k_iSteamMatchmakingCallbacks = 500,
}
pub const k_iSteamContentServerCallbacks: _bindgen_ty_6 =
    _bindgen_ty_6::k_iSteamContentServerCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_6 {
    k_iSteamContentServerCallbacks = 600,
}
pub const k_iSteamUtilsCallbacks: _bindgen_ty_7 = _bindgen_ty_7::k_iSteamUtilsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_7 {
    k_iSteamUtilsCallbacks = 700,
}
pub const k_iClientFriendsCallbacks: _bindgen_ty_8 = _bindgen_ty_8::k_iClientFriendsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_8 {
    k_iClientFriendsCallbacks = 800,
}
pub const k_iClientUserCallbacks: _bindgen_ty_9 = _bindgen_ty_9::k_iClientUserCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_9 {
    k_iClientUserCallbacks = 900,
}
pub const k_iSteamAppsCallbacks: _bindgen_ty_10 = _bindgen_ty_10::k_iSteamAppsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_10 {
    k_iSteamAppsCallbacks = 1000,
}
pub const k_iSteamUserStatsCallbacks: _bindgen_ty_11 = _bindgen_ty_11::k_iSteamUserStatsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_11 {
    k_iSteamUserStatsCallbacks = 1100,
}
pub const k_iSteamNetworkingCallbacks: _bindgen_ty_12 = _bindgen_ty_12::k_iSteamNetworkingCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_12 {
    k_iSteamNetworkingCallbacks = 1200,
}
pub const k_iSteamNetworkingSocketsCallbacks: _bindgen_ty_13 =
    _bindgen_ty_13::k_iSteamNetworkingSocketsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_13 {
    k_iSteamNetworkingSocketsCallbacks = 1220,
}
pub const k_iSteamNetworkingMessagesCallbacks: _bindgen_ty_14 =
    _bindgen_ty_14::k_iSteamNetworkingMessagesCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_14 {
    k_iSteamNetworkingMessagesCallbacks = 1250,
}
pub const k_iSteamNetworkingUtilsCallbacks: _bindgen_ty_15 =
    _bindgen_ty_15::k_iSteamNetworkingUtilsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_15 {
    k_iSteamNetworkingUtilsCallbacks = 1280,
}
pub const k_iClientRemoteStorageCallbacks: _bindgen_ty_16 =
    _bindgen_ty_16::k_iClientRemoteStorageCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_16 {
    k_iClientRemoteStorageCallbacks = 1300,
}
pub const k_iClientDepotBuilderCallbacks: _bindgen_ty_17 =
    _bindgen_ty_17::k_iClientDepotBuilderCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_17 {
    k_iClientDepotBuilderCallbacks = 1400,
}
pub const k_iSteamGameServerItemsCallbacks: _bindgen_ty_18 =
    _bindgen_ty_18::k_iSteamGameServerItemsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_18 {
    k_iSteamGameServerItemsCallbacks = 1500,
}
pub const k_iClientUtilsCallbacks: _bindgen_ty_19 = _bindgen_ty_19::k_iClientUtilsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_19 {
    k_iClientUtilsCallbacks = 1600,
}
pub const k_iSteamGameCoordinatorCallbacks: _bindgen_ty_20 =
    _bindgen_ty_20::k_iSteamGameCoordinatorCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_20 {
    k_iSteamGameCoordinatorCallbacks = 1700,
}
pub const k_iSteamGameServerStatsCallbacks: _bindgen_ty_21 =
    _bindgen_ty_21::k_iSteamGameServerStatsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_21 {
    k_iSteamGameServerStatsCallbacks = 1800,
}
pub const k_iSteam2AsyncCallbacks: _bindgen_ty_22 = _bindgen_ty_22::k_iSteam2AsyncCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_22 {
    k_iSteam2AsyncCallbacks = 1900,
}
pub const k_iSteamGameStatsCallbacks: _bindgen_ty_23 = _bindgen_ty_23::k_iSteamGameStatsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_23 {
    k_iSteamGameStatsCallbacks = 2000,
}
pub const k_iClientHTTPCallbacks: _bindgen_ty_24 = _bindgen_ty_24::k_iClientHTTPCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_24 {
    k_iClientHTTPCallbacks = 2100,
}
pub const k_iClientScreenshotsCallbacks: _bindgen_ty_25 =
    _bindgen_ty_25::k_iClientScreenshotsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_25 {
    k_iClientScreenshotsCallbacks = 2200,
}
pub const k_iSteamScreenshotsCallbacks: _bindgen_ty_26 =
    _bindgen_ty_26::k_iSteamScreenshotsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_26 {
    k_iSteamScreenshotsCallbacks = 2300,
}
pub const k_iClientAudioCallbacks: _bindgen_ty_27 = _bindgen_ty_27::k_iClientAudioCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_27 {
    k_iClientAudioCallbacks = 2400,
}
pub const k_iClientUnifiedMessagesCallbacks: _bindgen_ty_28 =
    _bindgen_ty_28::k_iClientUnifiedMessagesCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_28 {
    k_iClientUnifiedMessagesCallbacks = 2500,
}
pub const k_iSteamStreamLauncherCallbacks: _bindgen_ty_29 =
    _bindgen_ty_29::k_iSteamStreamLauncherCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_29 {
    k_iSteamStreamLauncherCallbacks = 2600,
}
pub const k_iClientControllerCallbacks: _bindgen_ty_30 =
    _bindgen_ty_30::k_iClientControllerCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_30 {
    k_iClientControllerCallbacks = 2700,
}
pub const k_iSteamControllerCallbacks: _bindgen_ty_31 = _bindgen_ty_31::k_iSteamControllerCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_31 {
    k_iSteamControllerCallbacks = 2800,
}
pub const k_iClientParentalSettingsCallbacks: _bindgen_ty_32 =
    _bindgen_ty_32::k_iClientParentalSettingsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_32 {
    k_iClientParentalSettingsCallbacks = 2900,
}
pub const k_iClientDeviceAuthCallbacks: _bindgen_ty_33 =
    _bindgen_ty_33::k_iClientDeviceAuthCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_33 {
    k_iClientDeviceAuthCallbacks = 3000,
}
pub const k_iClientNetworkDeviceManagerCallbacks: _bindgen_ty_34 =
    _bindgen_ty_34::k_iClientNetworkDeviceManagerCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_34 {
    k_iClientNetworkDeviceManagerCallbacks = 3100,
}
pub const k_iClientMusicCallbacks: _bindgen_ty_35 = _bindgen_ty_35::k_iClientMusicCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_35 {
    k_iClientMusicCallbacks = 3200,
}
pub const k_iClientRemoteClientManagerCallbacks: _bindgen_ty_36 =
    _bindgen_ty_36::k_iClientRemoteClientManagerCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_36 {
    k_iClientRemoteClientManagerCallbacks = 3300,
}
pub const k_iClientUGCCallbacks: _bindgen_ty_37 = _bindgen_ty_37::k_iClientUGCCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_37 {
    k_iClientUGCCallbacks = 3400,
}
pub const k_iSteamStreamClientCallbacks: _bindgen_ty_38 =
    _bindgen_ty_38::k_iSteamStreamClientCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_38 {
    k_iSteamStreamClientCallbacks = 3500,
}
pub const k_IClientProductBuilderCallbacks: _bindgen_ty_39 =
    _bindgen_ty_39::k_IClientProductBuilderCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_39 {
    k_IClientProductBuilderCallbacks = 3600,
}
pub const k_iClientShortcutsCallbacks: _bindgen_ty_40 = _bindgen_ty_40::k_iClientShortcutsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_40 {
    k_iClientShortcutsCallbacks = 3700,
}
pub const k_iClientRemoteControlManagerCallbacks: _bindgen_ty_41 =
    _bindgen_ty_41::k_iClientRemoteControlManagerCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_41 {
    k_iClientRemoteControlManagerCallbacks = 3800,
}
pub const k_iSteamAppListCallbacks: _bindgen_ty_42 = _bindgen_ty_42::k_iSteamAppListCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_42 {
    k_iSteamAppListCallbacks = 3900,
}
pub const k_iSteamMusicCallbacks: _bindgen_ty_43 = _bindgen_ty_43::k_iSteamMusicCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_43 {
    k_iSteamMusicCallbacks = 4000,
}
pub const k_iSteamMusicRemoteCallbacks: _bindgen_ty_44 =
    _bindgen_ty_44::k_iSteamMusicRemoteCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_44 {
    k_iSteamMusicRemoteCallbacks = 4100,
}
pub const k_iClientVRCallbacks: _bindgen_ty_45 = _bindgen_ty_45::k_iClientVRCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_45 {
    k_iClientVRCallbacks = 4200,
}
pub const k_iClientGameNotificationCallbacks: _bindgen_ty_46 =
    _bindgen_ty_46::k_iClientGameNotificationCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_46 {
    k_iClientGameNotificationCallbacks = 4300,
}
pub const k_iSteamGameNotificationCallbacks: _bindgen_ty_47 =
    _bindgen_ty_47::k_iSteamGameNotificationCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_47 {
    k_iSteamGameNotificationCallbacks = 4400,
}
pub const k_iSteamHTMLSurfaceCallbacks: _bindgen_ty_48 =
    _bindgen_ty_48::k_iSteamHTMLSurfaceCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_48 {
    k_iSteamHTMLSurfaceCallbacks = 4500,
}
pub const k_iClientVideoCallbacks: _bindgen_ty_49 = _bindgen_ty_49::k_iClientVideoCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_49 {
    k_iClientVideoCallbacks = 4600,
}
pub const k_iClientInventoryCallbacks: _bindgen_ty_50 = _bindgen_ty_50::k_iClientInventoryCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_50 {
    k_iClientInventoryCallbacks = 4700,
}
pub const k_iClientBluetoothManagerCallbacks: _bindgen_ty_51 =
    _bindgen_ty_51::k_iClientBluetoothManagerCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_51 {
    k_iClientBluetoothManagerCallbacks = 4800,
}
pub const k_iClientSharedConnectionCallbacks: _bindgen_ty_52 =
    _bindgen_ty_52::k_iClientSharedConnectionCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_52 {
    k_iClientSharedConnectionCallbacks = 4900,
}
pub const k_ISteamParentalSettingsCallbacks: _bindgen_ty_53 =
    _bindgen_ty_53::k_ISteamParentalSettingsCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_53 {
    k_ISteamParentalSettingsCallbacks = 5000,
}
pub const k_iClientShaderCallbacks: _bindgen_ty_54 = _bindgen_ty_54::k_iClientShaderCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_54 {
    k_iClientShaderCallbacks = 5100,
}
pub const k_iSteamGameSearchCallbacks: _bindgen_ty_55 = _bindgen_ty_55::k_iSteamGameSearchCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_55 {
    k_iSteamGameSearchCallbacks = 5200,
}
pub const k_iSteamPartiesCallbacks: _bindgen_ty_56 = _bindgen_ty_56::k_iSteamPartiesCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_56 {
    k_iSteamPartiesCallbacks = 5300,
}
pub const k_iClientPartiesCallbacks: _bindgen_ty_57 = _bindgen_ty_57::k_iClientPartiesCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_57 {
    k_iClientPartiesCallbacks = 5400,
}
pub const k_iSteamSTARCallbacks: _bindgen_ty_58 = _bindgen_ty_58::k_iSteamSTARCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_58 {
    k_iSteamSTARCallbacks = 5500,
}
pub const k_iClientSTARCallbacks: _bindgen_ty_59 = _bindgen_ty_59::k_iClientSTARCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_59 {
    k_iClientSTARCallbacks = 5600,
}
pub const k_iSteamRemotePlayCallbacks: _bindgen_ty_60 = _bindgen_ty_60::k_iSteamRemotePlayCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_60 {
    k_iSteamRemotePlayCallbacks = 5700,
}
pub const k_iClientCompatCallbacks: _bindgen_ty_61 = _bindgen_ty_61::k_iClientCompatCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_61 {
    k_iClientCompatCallbacks = 5800,
}
pub const k_iSteamChatCallbacks: _bindgen_ty_62 = _bindgen_ty_62::k_iSteamChatCallbacks;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_62 {
    k_iSteamChatCallbacks = 5900,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CSteamAPIContext {
    pub m_pSteamClient: *mut ISteamClient,
    pub m_pSteamUser: *mut ISteamUser,
    pub m_pSteamFriends: *mut ISteamFriends,
    pub m_pSteamUtils: *mut ISteamUtils,
    pub m_pSteamMatchmaking: *mut ISteamMatchmaking,
    pub m_pSteamGameSearch: *mut ISteamGameSearch,
    pub m_pSteamUserStats: *mut ISteamUserStats,
    pub m_pSteamApps: *mut ISteamApps,
    pub m_pSteamMatchmakingServers: *mut ISteamMatchmakingServers,
    pub m_pSteamNetworking: *mut ISteamNetworking,
    pub m_pSteamRemoteStorage: *mut ISteamRemoteStorage,
    pub m_pSteamScreenshots: *mut ISteamScreenshots,
    pub m_pSteamHTTP: *mut ISteamHTTP,
    pub m_pController: *mut ISteamController,
    pub m_pSteamUGC: *mut ISteamUGC,
    pub m_pSteamAppList: *mut ISteamAppList,
    pub m_pSteamMusic: *mut ISteamMusic,
    pub m_pSteamMusicRemote: *mut ISteamMusicRemote,
    pub m_pSteamHTMLSurface: *mut ISteamHTMLSurface,
    pub m_pSteamInventory: *mut ISteamInventory,
    pub m_pSteamVideo: *mut ISteamVideo,
    pub m_pSteamParentalSettings: *mut ISteamParentalSettings,
    pub m_pSteamInput: *mut ISteamInput,
}
#[test]
fn bindgen_test_layout_CSteamAPIContext() {
    assert_eq!(
        ::std::mem::size_of::<CSteamAPIContext>(),
        184usize,
        concat!("Size of: ", stringify!(CSteamAPIContext))
    );
    assert_eq!(
        ::std::mem::align_of::<CSteamAPIContext>(),
        8usize,
        concat!("Alignment of ", stringify!(CSteamAPIContext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamClient as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamClient)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamUser as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamUser)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamFriends as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamFriends)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamUtils as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamUtils)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamMatchmaking as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamMatchmaking)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamGameSearch as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamGameSearch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamUserStats as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamUserStats)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamApps as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamApps)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamMatchmakingServers as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamMatchmakingServers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamNetworking as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamNetworking)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamRemoteStorage as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamRemoteStorage)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamScreenshots as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamScreenshots)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamHTTP as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamHTTP)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CSteamAPIContext>())).m_pController as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pController)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamUGC as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamUGC)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamAppList as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamAppList)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamMusic as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamMusic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamMusicRemote as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamMusicRemote)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamHTMLSurface as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamHTMLSurface)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamInventory as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamInventory)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamVideo as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamVideo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamParentalSettings as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamParentalSettings)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CSteamAPIContext>())).m_pSteamInput as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamAPIContext),
            "::",
            stringify!(m_pSteamInput)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CSteamGameServerAPIContext {
    pub m_pSteamClient: *mut ISteamClient,
    pub m_pSteamGameServer: *mut ISteamGameServer,
    pub m_pSteamGameServerUtils: *mut ISteamUtils,
    pub m_pSteamGameServerNetworking: *mut ISteamNetworking,
    pub m_pSteamGameServerStats: *mut ISteamGameServerStats,
    pub m_pSteamHTTP: *mut ISteamHTTP,
    pub m_pSteamInventory: *mut ISteamInventory,
    pub m_pSteamUGC: *mut ISteamUGC,
    pub m_pSteamApps: *mut ISteamApps,
}
#[test]
fn bindgen_test_layout_CSteamGameServerAPIContext() {
    assert_eq!(
        ::std::mem::size_of::<CSteamGameServerAPIContext>(),
        72usize,
        concat!("Size of: ", stringify!(CSteamGameServerAPIContext))
    );
    assert_eq!(
        ::std::mem::align_of::<CSteamGameServerAPIContext>(),
        8usize,
        concat!("Alignment of ", stringify!(CSteamGameServerAPIContext))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamGameServerAPIContext>())).m_pSteamClient as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamGameServerAPIContext),
            "::",
            stringify!(m_pSteamClient)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamGameServerAPIContext>())).m_pSteamGameServer as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamGameServerAPIContext),
            "::",
            stringify!(m_pSteamGameServer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamGameServerAPIContext>())).m_pSteamGameServerUtils
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamGameServerAPIContext),
            "::",
            stringify!(m_pSteamGameServerUtils)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamGameServerAPIContext>())).m_pSteamGameServerNetworking
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamGameServerAPIContext),
            "::",
            stringify!(m_pSteamGameServerNetworking)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamGameServerAPIContext>())).m_pSteamGameServerStats
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamGameServerAPIContext),
            "::",
            stringify!(m_pSteamGameServerStats)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamGameServerAPIContext>())).m_pSteamHTTP as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamGameServerAPIContext),
            "::",
            stringify!(m_pSteamHTTP)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamGameServerAPIContext>())).m_pSteamInventory as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamGameServerAPIContext),
            "::",
            stringify!(m_pSteamInventory)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamGameServerAPIContext>())).m_pSteamUGC as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamGameServerAPIContext),
            "::",
            stringify!(m_pSteamUGC)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CSteamGameServerAPIContext>())).m_pSteamApps as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(CSteamGameServerAPIContext),
            "::",
            stringify!(m_pSteamApps)
        )
    );
}
#[repr(C)]
pub struct ISteamClient__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamClient {
    pub vtable_: *const ISteamClient__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamClient() {
    assert_eq!(
        ::std::mem::size_of::<ISteamClient>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamClient))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamClient>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamClient))
    );
}
#[repr(C)]
pub struct ISteamUser__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamUser {
    pub vtable_: *const ISteamUser__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamUser() {
    assert_eq!(
        ::std::mem::size_of::<ISteamUser>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamUser))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamUser>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamUser))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamServersConnected_t {
    pub _address: u8,
}
pub const SteamServersConnected_t_k_iCallback: SteamServersConnected_t__bindgen_ty_1 =
    SteamServersConnected_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamServersConnected_t__bindgen_ty_1 {
    k_iCallback = 101,
}
#[test]
fn bindgen_test_layout_SteamServersConnected_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamServersConnected_t>(),
        1usize,
        concat!("Size of: ", stringify!(SteamServersConnected_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamServersConnected_t>(),
        1usize,
        concat!("Alignment of ", stringify!(SteamServersConnected_t))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamServerConnectFailure_t {
    pub m_eResult: EResult,
    pub m_bStillRetrying: bool,
}
pub const SteamServerConnectFailure_t_k_iCallback: SteamServerConnectFailure_t__bindgen_ty_1 =
    SteamServerConnectFailure_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamServerConnectFailure_t__bindgen_ty_1 {
    k_iCallback = 102,
}
#[test]
fn bindgen_test_layout_SteamServerConnectFailure_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamServerConnectFailure_t>(),
        8usize,
        concat!("Size of: ", stringify!(SteamServerConnectFailure_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamServerConnectFailure_t>(),
        4usize,
        concat!("Alignment of ", stringify!(SteamServerConnectFailure_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamServerConnectFailure_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamServerConnectFailure_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamServerConnectFailure_t>())).m_bStillRetrying as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamServerConnectFailure_t),
            "::",
            stringify!(m_bStillRetrying)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamServersDisconnected_t {
    pub m_eResult: EResult,
}
pub const SteamServersDisconnected_t_k_iCallback: SteamServersDisconnected_t__bindgen_ty_1 =
    SteamServersDisconnected_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamServersDisconnected_t__bindgen_ty_1 {
    k_iCallback = 103,
}
#[test]
fn bindgen_test_layout_SteamServersDisconnected_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamServersDisconnected_t>(),
        4usize,
        concat!("Size of: ", stringify!(SteamServersDisconnected_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamServersDisconnected_t>(),
        4usize,
        concat!("Alignment of ", stringify!(SteamServersDisconnected_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamServersDisconnected_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamServersDisconnected_t),
            "::",
            stringify!(m_eResult)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ClientGameServerDeny_t {
    pub m_uAppID: uint32,
    pub m_unGameServerIP: uint32,
    pub m_usGameServerPort: uint16,
    pub m_bSecure: uint16,
    pub m_uReason: uint32,
}
pub const ClientGameServerDeny_t_k_iCallback: ClientGameServerDeny_t__bindgen_ty_1 =
    ClientGameServerDeny_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ClientGameServerDeny_t__bindgen_ty_1 {
    k_iCallback = 113,
}
#[test]
fn bindgen_test_layout_ClientGameServerDeny_t() {
    assert_eq!(
        ::std::mem::size_of::<ClientGameServerDeny_t>(),
        16usize,
        concat!("Size of: ", stringify!(ClientGameServerDeny_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ClientGameServerDeny_t>(),
        4usize,
        concat!("Alignment of ", stringify!(ClientGameServerDeny_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ClientGameServerDeny_t>())).m_uAppID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ClientGameServerDeny_t),
            "::",
            stringify!(m_uAppID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ClientGameServerDeny_t>())).m_unGameServerIP as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ClientGameServerDeny_t),
            "::",
            stringify!(m_unGameServerIP)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ClientGameServerDeny_t>())).m_usGameServerPort as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ClientGameServerDeny_t),
            "::",
            stringify!(m_usGameServerPort)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ClientGameServerDeny_t>())).m_bSecure as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(ClientGameServerDeny_t),
            "::",
            stringify!(m_bSecure)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ClientGameServerDeny_t>())).m_uReason as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ClientGameServerDeny_t),
            "::",
            stringify!(m_uReason)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IPCFailure_t {
    pub m_eFailureType: uint8,
}
pub const IPCFailure_t_k_iCallback: IPCFailure_t__bindgen_ty_1 =
    IPCFailure_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum IPCFailure_t__bindgen_ty_1 {
    k_iCallback = 117,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum IPCFailure_t_EFailureType {
    k_EFailureFlushedCallbackQueue = 0,
    k_EFailurePipeFail = 1,
}
#[test]
fn bindgen_test_layout_IPCFailure_t() {
    assert_eq!(
        ::std::mem::size_of::<IPCFailure_t>(),
        1usize,
        concat!("Size of: ", stringify!(IPCFailure_t))
    );
    assert_eq!(
        ::std::mem::align_of::<IPCFailure_t>(),
        1usize,
        concat!("Alignment of ", stringify!(IPCFailure_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<IPCFailure_t>())).m_eFailureType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(IPCFailure_t),
            "::",
            stringify!(m_eFailureType)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LicensesUpdated_t {
    pub _address: u8,
}
pub const LicensesUpdated_t_k_iCallback: LicensesUpdated_t__bindgen_ty_1 =
    LicensesUpdated_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum LicensesUpdated_t__bindgen_ty_1 {
    k_iCallback = 125,
}
#[test]
fn bindgen_test_layout_LicensesUpdated_t() {
    assert_eq!(
        ::std::mem::size_of::<LicensesUpdated_t>(),
        1usize,
        concat!("Size of: ", stringify!(LicensesUpdated_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LicensesUpdated_t>(),
        1usize,
        concat!("Alignment of ", stringify!(LicensesUpdated_t))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ValidateAuthTicketResponse_t {
    pub m_SteamID: CSteamID,
    pub m_eAuthSessionResponse: EAuthSessionResponse,
    pub m_OwnerSteamID: CSteamID,
}
pub const ValidateAuthTicketResponse_t_k_iCallback: ValidateAuthTicketResponse_t__bindgen_ty_1 =
    ValidateAuthTicketResponse_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ValidateAuthTicketResponse_t__bindgen_ty_1 {
    k_iCallback = 143,
}
#[test]
fn bindgen_test_layout_ValidateAuthTicketResponse_t() {
    assert_eq!(
        ::std::mem::size_of::<ValidateAuthTicketResponse_t>(),
        20usize,
        concat!("Size of: ", stringify!(ValidateAuthTicketResponse_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ValidateAuthTicketResponse_t>(),
        4usize,
        concat!("Alignment of ", stringify!(ValidateAuthTicketResponse_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ValidateAuthTicketResponse_t>())).m_SteamID as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ValidateAuthTicketResponse_t),
            "::",
            stringify!(m_SteamID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ValidateAuthTicketResponse_t>())).m_eAuthSessionResponse
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ValidateAuthTicketResponse_t),
            "::",
            stringify!(m_eAuthSessionResponse)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ValidateAuthTicketResponse_t>())).m_OwnerSteamID as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ValidateAuthTicketResponse_t),
            "::",
            stringify!(m_OwnerSteamID)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MicroTxnAuthorizationResponse_t {
    pub m_unAppID: uint32,
    pub m_ulOrderID: uint64,
    pub m_bAuthorized: uint8,
}
pub const MicroTxnAuthorizationResponse_t_k_iCallback:
    MicroTxnAuthorizationResponse_t__bindgen_ty_1 =
    MicroTxnAuthorizationResponse_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MicroTxnAuthorizationResponse_t__bindgen_ty_1 {
    k_iCallback = 152,
}
#[test]
fn bindgen_test_layout_MicroTxnAuthorizationResponse_t() {
    assert_eq!(
        ::std::mem::size_of::<MicroTxnAuthorizationResponse_t>(),
        24usize,
        concat!("Size of: ", stringify!(MicroTxnAuthorizationResponse_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MicroTxnAuthorizationResponse_t>(),
        8usize,
        concat!("Alignment of ", stringify!(MicroTxnAuthorizationResponse_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MicroTxnAuthorizationResponse_t>())).m_unAppID as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MicroTxnAuthorizationResponse_t),
            "::",
            stringify!(m_unAppID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MicroTxnAuthorizationResponse_t>())).m_ulOrderID as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(MicroTxnAuthorizationResponse_t),
            "::",
            stringify!(m_ulOrderID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MicroTxnAuthorizationResponse_t>())).m_bAuthorized as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(MicroTxnAuthorizationResponse_t),
            "::",
            stringify!(m_bAuthorized)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EncryptedAppTicketResponse_t {
    pub m_eResult: EResult,
}
pub const EncryptedAppTicketResponse_t_k_iCallback: EncryptedAppTicketResponse_t__bindgen_ty_1 =
    EncryptedAppTicketResponse_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EncryptedAppTicketResponse_t__bindgen_ty_1 {
    k_iCallback = 154,
}
#[test]
fn bindgen_test_layout_EncryptedAppTicketResponse_t() {
    assert_eq!(
        ::std::mem::size_of::<EncryptedAppTicketResponse_t>(),
        4usize,
        concat!("Size of: ", stringify!(EncryptedAppTicketResponse_t))
    );
    assert_eq!(
        ::std::mem::align_of::<EncryptedAppTicketResponse_t>(),
        4usize,
        concat!("Alignment of ", stringify!(EncryptedAppTicketResponse_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<EncryptedAppTicketResponse_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(EncryptedAppTicketResponse_t),
            "::",
            stringify!(m_eResult)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GetAuthSessionTicketResponse_t {
    pub m_hAuthTicket: HAuthTicket,
    pub m_eResult: EResult,
}
pub const GetAuthSessionTicketResponse_t_k_iCallback: GetAuthSessionTicketResponse_t__bindgen_ty_1 =
    GetAuthSessionTicketResponse_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GetAuthSessionTicketResponse_t__bindgen_ty_1 {
    k_iCallback = 163,
}
#[test]
fn bindgen_test_layout_GetAuthSessionTicketResponse_t() {
    assert_eq!(
        ::std::mem::size_of::<GetAuthSessionTicketResponse_t>(),
        8usize,
        concat!("Size of: ", stringify!(GetAuthSessionTicketResponse_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GetAuthSessionTicketResponse_t>(),
        4usize,
        concat!("Alignment of ", stringify!(GetAuthSessionTicketResponse_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GetAuthSessionTicketResponse_t>())).m_hAuthTicket as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GetAuthSessionTicketResponse_t),
            "::",
            stringify!(m_hAuthTicket)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GetAuthSessionTicketResponse_t>())).m_eResult as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GetAuthSessionTicketResponse_t),
            "::",
            stringify!(m_eResult)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GameWebCallback_t {
    pub m_szURL: [::std::os::raw::c_char; 256usize],
}
pub const GameWebCallback_t_k_iCallback: GameWebCallback_t__bindgen_ty_1 =
    GameWebCallback_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GameWebCallback_t__bindgen_ty_1 {
    k_iCallback = 164,
}
#[test]
fn bindgen_test_layout_GameWebCallback_t() {
    assert_eq!(
        ::std::mem::size_of::<GameWebCallback_t>(),
        256usize,
        concat!("Size of: ", stringify!(GameWebCallback_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GameWebCallback_t>(),
        1usize,
        concat!("Alignment of ", stringify!(GameWebCallback_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GameWebCallback_t>())).m_szURL as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameWebCallback_t),
            "::",
            stringify!(m_szURL)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct StoreAuthURLResponse_t {
    pub m_szURL: [::std::os::raw::c_char; 512usize],
}
pub const StoreAuthURLResponse_t_k_iCallback: StoreAuthURLResponse_t__bindgen_ty_1 =
    StoreAuthURLResponse_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum StoreAuthURLResponse_t__bindgen_ty_1 {
    k_iCallback = 165,
}
#[test]
fn bindgen_test_layout_StoreAuthURLResponse_t() {
    assert_eq!(
        ::std::mem::size_of::<StoreAuthURLResponse_t>(),
        512usize,
        concat!("Size of: ", stringify!(StoreAuthURLResponse_t))
    );
    assert_eq!(
        ::std::mem::align_of::<StoreAuthURLResponse_t>(),
        1usize,
        concat!("Alignment of ", stringify!(StoreAuthURLResponse_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<StoreAuthURLResponse_t>())).m_szURL as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StoreAuthURLResponse_t),
            "::",
            stringify!(m_szURL)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MarketEligibilityResponse_t {
    pub m_bAllowed: bool,
    pub m_eNotAllowedReason: EMarketNotAllowedReasonFlags,
    pub m_rtAllowedAtTime: RTime32,
    pub m_cdaySteamGuardRequiredDays: ::std::os::raw::c_int,
    pub m_cdayNewDeviceCooldown: ::std::os::raw::c_int,
}
pub const MarketEligibilityResponse_t_k_iCallback: MarketEligibilityResponse_t__bindgen_ty_1 =
    MarketEligibilityResponse_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MarketEligibilityResponse_t__bindgen_ty_1 {
    k_iCallback = 166,
}
#[test]
fn bindgen_test_layout_MarketEligibilityResponse_t() {
    assert_eq!(
        ::std::mem::size_of::<MarketEligibilityResponse_t>(),
        20usize,
        concat!("Size of: ", stringify!(MarketEligibilityResponse_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MarketEligibilityResponse_t>(),
        4usize,
        concat!("Alignment of ", stringify!(MarketEligibilityResponse_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MarketEligibilityResponse_t>())).m_bAllowed as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MarketEligibilityResponse_t),
            "::",
            stringify!(m_bAllowed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MarketEligibilityResponse_t>())).m_eNotAllowedReason as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(MarketEligibilityResponse_t),
            "::",
            stringify!(m_eNotAllowedReason)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MarketEligibilityResponse_t>())).m_rtAllowedAtTime as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(MarketEligibilityResponse_t),
            "::",
            stringify!(m_rtAllowedAtTime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MarketEligibilityResponse_t>())).m_cdaySteamGuardRequiredDays
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(MarketEligibilityResponse_t),
            "::",
            stringify!(m_cdaySteamGuardRequiredDays)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MarketEligibilityResponse_t>())).m_cdayNewDeviceCooldown
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(MarketEligibilityResponse_t),
            "::",
            stringify!(m_cdayNewDeviceCooldown)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DurationControl_t {
    pub m_eResult: EResult,
    pub m_appid: AppId_t,
    pub m_bApplicable: bool,
    pub m_csecsLast5h: int32,
    pub m_progress: EDurationControlProgress,
    pub m_notification: EDurationControlNotification,
    pub m_csecsToday: int32,
    pub m_csecsRemaining: int32,
}
pub const DurationControl_t_k_iCallback: DurationControl_t__bindgen_ty_1 =
    DurationControl_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum DurationControl_t__bindgen_ty_1 {
    k_iCallback = 167,
}
#[test]
fn bindgen_test_layout_DurationControl_t() {
    assert_eq!(
        ::std::mem::size_of::<DurationControl_t>(),
        32usize,
        concat!("Size of: ", stringify!(DurationControl_t))
    );
    assert_eq!(
        ::std::mem::align_of::<DurationControl_t>(),
        4usize,
        concat!("Alignment of ", stringify!(DurationControl_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DurationControl_t>())).m_eResult as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(DurationControl_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DurationControl_t>())).m_appid as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(DurationControl_t),
            "::",
            stringify!(m_appid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DurationControl_t>())).m_bApplicable as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(DurationControl_t),
            "::",
            stringify!(m_bApplicable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DurationControl_t>())).m_csecsLast5h as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(DurationControl_t),
            "::",
            stringify!(m_csecsLast5h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DurationControl_t>())).m_progress as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(DurationControl_t),
            "::",
            stringify!(m_progress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<DurationControl_t>())).m_notification as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(DurationControl_t),
            "::",
            stringify!(m_notification)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DurationControl_t>())).m_csecsToday as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(DurationControl_t),
            "::",
            stringify!(m_csecsToday)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<DurationControl_t>())).m_csecsRemaining as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(DurationControl_t),
            "::",
            stringify!(m_csecsRemaining)
        )
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EFriendRelationship {
    k_EFriendRelationshipNone = 0,
    k_EFriendRelationshipBlocked = 1,
    k_EFriendRelationshipRequestRecipient = 2,
    k_EFriendRelationshipFriend = 3,
    k_EFriendRelationshipRequestInitiator = 4,
    k_EFriendRelationshipIgnored = 5,
    k_EFriendRelationshipIgnoredFriend = 6,
    k_EFriendRelationshipSuggested_DEPRECATED = 7,
    k_EFriendRelationshipMax = 8,
}
pub const k_cchMaxFriendsGroupName: ::std::os::raw::c_int = 64;
pub const k_cFriendsGroupLimit: ::std::os::raw::c_int = 100;
pub type FriendsGroupID_t = int16;
pub const k_FriendsGroupID_Invalid: FriendsGroupID_t = -1;
pub const k_cEnumerateFollowersMax: ::std::os::raw::c_int = 50;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EPersonaState {
    k_EPersonaStateOffline = 0,
    k_EPersonaStateOnline = 1,
    k_EPersonaStateBusy = 2,
    k_EPersonaStateAway = 3,
    k_EPersonaStateSnooze = 4,
    k_EPersonaStateLookingToTrade = 5,
    k_EPersonaStateLookingToPlay = 6,
    k_EPersonaStateInvisible = 7,
    k_EPersonaStateMax = 8,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EFriendFlags {
    k_EFriendFlagNone = 0,
    k_EFriendFlagBlocked = 1,
    k_EFriendFlagFriendshipRequested = 2,
    k_EFriendFlagImmediate = 4,
    k_EFriendFlagClanMember = 8,
    k_EFriendFlagOnGameServer = 16,
    k_EFriendFlagRequestingFriendship = 128,
    k_EFriendFlagRequestingInfo = 256,
    k_EFriendFlagIgnored = 512,
    k_EFriendFlagIgnoredFriend = 1024,
    k_EFriendFlagChatMember = 4096,
    k_EFriendFlagAll = 65535,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct FriendGameInfo_t {
    pub m_gameID: CGameID,
    pub m_unGameIP: uint32,
    pub m_usGamePort: uint16,
    pub m_usQueryPort: uint16,
    pub m_steamIDLobby: CSteamID,
}
#[test]
fn bindgen_test_layout_FriendGameInfo_t() {
    assert_eq!(
        ::std::mem::size_of::<FriendGameInfo_t>(),
        24usize,
        concat!("Size of: ", stringify!(FriendGameInfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<FriendGameInfo_t>(),
        4usize,
        concat!("Alignment of ", stringify!(FriendGameInfo_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FriendGameInfo_t>())).m_gameID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendGameInfo_t),
            "::",
            stringify!(m_gameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FriendGameInfo_t>())).m_unGameIP as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendGameInfo_t),
            "::",
            stringify!(m_unGameIP)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FriendGameInfo_t>())).m_usGamePort as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendGameInfo_t),
            "::",
            stringify!(m_usGamePort)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FriendGameInfo_t>())).m_usQueryPort as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendGameInfo_t),
            "::",
            stringify!(m_usQueryPort)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FriendGameInfo_t>())).m_steamIDLobby as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendGameInfo_t),
            "::",
            stringify!(m_steamIDLobby)
        )
    );
}
pub const k_cchPersonaNameMax: _bindgen_ty_63 = _bindgen_ty_63::k_cchPersonaNameMax;
pub const k_cwchPersonaNameMax: _bindgen_ty_63 = _bindgen_ty_63::k_cwchPersonaNameMax;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_63 {
    k_cchPersonaNameMax = 128,
    k_cwchPersonaNameMax = 32,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EUserRestriction {
    k_nUserRestrictionNone = 0,
    k_nUserRestrictionUnknown = 1,
    k_nUserRestrictionAnyChat = 2,
    k_nUserRestrictionVoiceChat = 4,
    k_nUserRestrictionGroupChat = 8,
    k_nUserRestrictionRating = 16,
    k_nUserRestrictionGameInvites = 32,
    k_nUserRestrictionTrading = 64,
}
pub const k_cubChatMetadataMax: uint32 = 8192;
pub const k_cchMaxRichPresenceKeys: _bindgen_ty_64 = _bindgen_ty_64::k_cchMaxRichPresenceKeys;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_64 {
    k_cchMaxRichPresenceKeys = 30,
}
pub const k_cchMaxRichPresenceKeyLength: _bindgen_ty_65 =
    _bindgen_ty_65::k_cchMaxRichPresenceKeyLength;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_65 {
    k_cchMaxRichPresenceKeyLength = 64,
}
pub const k_cchMaxRichPresenceValueLength: _bindgen_ty_66 =
    _bindgen_ty_66::k_cchMaxRichPresenceValueLength;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_66 {
    k_cchMaxRichPresenceValueLength = 256,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EOverlayToStoreFlag {
    k_EOverlayToStoreFlag_None = 0,
    k_EOverlayToStoreFlag_AddToCart = 1,
    k_EOverlayToStoreFlag_AddToCartAndShow = 2,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EActivateGameOverlayToWebPageMode {
    k_EActivateGameOverlayToWebPageMode_Default = 0,
    k_EActivateGameOverlayToWebPageMode_Modal = 1,
}
#[repr(C)]
pub struct ISteamFriends__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamFriends {
    pub vtable_: *const ISteamFriends__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamFriends() {
    assert_eq!(
        ::std::mem::size_of::<ISteamFriends>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamFriends))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamFriends>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamFriends))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PersonaStateChange_t {
    pub m_ulSteamID: uint64,
    pub m_nChangeFlags: ::std::os::raw::c_int,
}
pub const PersonaStateChange_t_k_iCallback: PersonaStateChange_t__bindgen_ty_1 =
    PersonaStateChange_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum PersonaStateChange_t__bindgen_ty_1 {
    k_iCallback = 304,
}
#[test]
fn bindgen_test_layout_PersonaStateChange_t() {
    assert_eq!(
        ::std::mem::size_of::<PersonaStateChange_t>(),
        16usize,
        concat!("Size of: ", stringify!(PersonaStateChange_t))
    );
    assert_eq!(
        ::std::mem::align_of::<PersonaStateChange_t>(),
        8usize,
        concat!("Alignment of ", stringify!(PersonaStateChange_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<PersonaStateChange_t>())).m_ulSteamID as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PersonaStateChange_t),
            "::",
            stringify!(m_ulSteamID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<PersonaStateChange_t>())).m_nChangeFlags as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(PersonaStateChange_t),
            "::",
            stringify!(m_nChangeFlags)
        )
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EPersonaChange {
    k_EPersonaChangeName = 1,
    k_EPersonaChangeStatus = 2,
    k_EPersonaChangeComeOnline = 4,
    k_EPersonaChangeGoneOffline = 8,
    k_EPersonaChangeGamePlayed = 16,
    k_EPersonaChangeGameServer = 32,
    k_EPersonaChangeAvatar = 64,
    k_EPersonaChangeJoinedSource = 128,
    k_EPersonaChangeLeftSource = 256,
    k_EPersonaChangeRelationshipChanged = 512,
    k_EPersonaChangeNameFirstSet = 1024,
    k_EPersonaChangeBroadcast = 2048,
    k_EPersonaChangeNickname = 4096,
    k_EPersonaChangeSteamLevel = 8192,
    k_EPersonaChangeRichPresence = 16384,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GameOverlayActivated_t {
    pub m_bActive: uint8,
}
pub const GameOverlayActivated_t_k_iCallback: GameOverlayActivated_t__bindgen_ty_1 =
    GameOverlayActivated_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GameOverlayActivated_t__bindgen_ty_1 {
    k_iCallback = 331,
}
#[test]
fn bindgen_test_layout_GameOverlayActivated_t() {
    assert_eq!(
        ::std::mem::size_of::<GameOverlayActivated_t>(),
        1usize,
        concat!("Size of: ", stringify!(GameOverlayActivated_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GameOverlayActivated_t>(),
        1usize,
        concat!("Alignment of ", stringify!(GameOverlayActivated_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameOverlayActivated_t>())).m_bActive as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameOverlayActivated_t),
            "::",
            stringify!(m_bActive)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GameServerChangeRequested_t {
    pub m_rgchServer: [::std::os::raw::c_char; 64usize],
    pub m_rgchPassword: [::std::os::raw::c_char; 64usize],
}
pub const GameServerChangeRequested_t_k_iCallback: GameServerChangeRequested_t__bindgen_ty_1 =
    GameServerChangeRequested_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GameServerChangeRequested_t__bindgen_ty_1 {
    k_iCallback = 332,
}
#[test]
fn bindgen_test_layout_GameServerChangeRequested_t() {
    assert_eq!(
        ::std::mem::size_of::<GameServerChangeRequested_t>(),
        128usize,
        concat!("Size of: ", stringify!(GameServerChangeRequested_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GameServerChangeRequested_t>(),
        1usize,
        concat!("Alignment of ", stringify!(GameServerChangeRequested_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameServerChangeRequested_t>())).m_rgchServer as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameServerChangeRequested_t),
            "::",
            stringify!(m_rgchServer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameServerChangeRequested_t>())).m_rgchPassword as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(GameServerChangeRequested_t),
            "::",
            stringify!(m_rgchPassword)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GameLobbyJoinRequested_t {
    pub m_steamIDLobby: CSteamID,
    pub m_steamIDFriend: CSteamID,
}
pub const GameLobbyJoinRequested_t_k_iCallback: GameLobbyJoinRequested_t__bindgen_ty_1 =
    GameLobbyJoinRequested_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GameLobbyJoinRequested_t__bindgen_ty_1 {
    k_iCallback = 333,
}
#[test]
fn bindgen_test_layout_GameLobbyJoinRequested_t() {
    assert_eq!(
        ::std::mem::size_of::<GameLobbyJoinRequested_t>(),
        16usize,
        concat!("Size of: ", stringify!(GameLobbyJoinRequested_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GameLobbyJoinRequested_t>(),
        1usize,
        concat!("Alignment of ", stringify!(GameLobbyJoinRequested_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameLobbyJoinRequested_t>())).m_steamIDLobby as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameLobbyJoinRequested_t),
            "::",
            stringify!(m_steamIDLobby)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameLobbyJoinRequested_t>())).m_steamIDFriend as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GameLobbyJoinRequested_t),
            "::",
            stringify!(m_steamIDFriend)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AvatarImageLoaded_t {
    pub m_steamID: CSteamID,
    pub m_iImage: ::std::os::raw::c_int,
    pub m_iWide: ::std::os::raw::c_int,
    pub m_iTall: ::std::os::raw::c_int,
}
pub const AvatarImageLoaded_t_k_iCallback: AvatarImageLoaded_t__bindgen_ty_1 =
    AvatarImageLoaded_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AvatarImageLoaded_t__bindgen_ty_1 {
    k_iCallback = 334,
}
#[test]
fn bindgen_test_layout_AvatarImageLoaded_t() {
    assert_eq!(
        ::std::mem::size_of::<AvatarImageLoaded_t>(),
        20usize,
        concat!("Size of: ", stringify!(AvatarImageLoaded_t))
    );
    assert_eq!(
        ::std::mem::align_of::<AvatarImageLoaded_t>(),
        4usize,
        concat!("Alignment of ", stringify!(AvatarImageLoaded_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AvatarImageLoaded_t>())).m_steamID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AvatarImageLoaded_t),
            "::",
            stringify!(m_steamID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AvatarImageLoaded_t>())).m_iImage as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AvatarImageLoaded_t),
            "::",
            stringify!(m_iImage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AvatarImageLoaded_t>())).m_iWide as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(AvatarImageLoaded_t),
            "::",
            stringify!(m_iWide)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<AvatarImageLoaded_t>())).m_iTall as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AvatarImageLoaded_t),
            "::",
            stringify!(m_iTall)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ClanOfficerListResponse_t {
    pub m_steamIDClan: CSteamID,
    pub m_cOfficers: ::std::os::raw::c_int,
    pub m_bSuccess: uint8,
}
pub const ClanOfficerListResponse_t_k_iCallback: ClanOfficerListResponse_t__bindgen_ty_1 =
    ClanOfficerListResponse_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ClanOfficerListResponse_t__bindgen_ty_1 {
    k_iCallback = 335,
}
#[test]
fn bindgen_test_layout_ClanOfficerListResponse_t() {
    assert_eq!(
        ::std::mem::size_of::<ClanOfficerListResponse_t>(),
        16usize,
        concat!("Size of: ", stringify!(ClanOfficerListResponse_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ClanOfficerListResponse_t>(),
        4usize,
        concat!("Alignment of ", stringify!(ClanOfficerListResponse_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ClanOfficerListResponse_t>())).m_steamIDClan as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ClanOfficerListResponse_t),
            "::",
            stringify!(m_steamIDClan)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ClanOfficerListResponse_t>())).m_cOfficers as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ClanOfficerListResponse_t),
            "::",
            stringify!(m_cOfficers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ClanOfficerListResponse_t>())).m_bSuccess as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ClanOfficerListResponse_t),
            "::",
            stringify!(m_bSuccess)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct FriendRichPresenceUpdate_t {
    pub m_steamIDFriend: CSteamID,
    pub m_nAppID: AppId_t,
}
pub const FriendRichPresenceUpdate_t_k_iCallback: FriendRichPresenceUpdate_t__bindgen_ty_1 =
    FriendRichPresenceUpdate_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum FriendRichPresenceUpdate_t__bindgen_ty_1 {
    k_iCallback = 336,
}
#[test]
fn bindgen_test_layout_FriendRichPresenceUpdate_t() {
    assert_eq!(
        ::std::mem::size_of::<FriendRichPresenceUpdate_t>(),
        12usize,
        concat!("Size of: ", stringify!(FriendRichPresenceUpdate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<FriendRichPresenceUpdate_t>(),
        4usize,
        concat!("Alignment of ", stringify!(FriendRichPresenceUpdate_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<FriendRichPresenceUpdate_t>())).m_steamIDFriend as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendRichPresenceUpdate_t),
            "::",
            stringify!(m_steamIDFriend)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<FriendRichPresenceUpdate_t>())).m_nAppID as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendRichPresenceUpdate_t),
            "::",
            stringify!(m_nAppID)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GameRichPresenceJoinRequested_t {
    pub m_steamIDFriend: CSteamID,
    pub m_rgchConnect: [::std::os::raw::c_char; 256usize],
}
pub const GameRichPresenceJoinRequested_t_k_iCallback:
    GameRichPresenceJoinRequested_t__bindgen_ty_1 =
    GameRichPresenceJoinRequested_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GameRichPresenceJoinRequested_t__bindgen_ty_1 {
    k_iCallback = 337,
}
#[test]
fn bindgen_test_layout_GameRichPresenceJoinRequested_t() {
    assert_eq!(
        ::std::mem::size_of::<GameRichPresenceJoinRequested_t>(),
        264usize,
        concat!("Size of: ", stringify!(GameRichPresenceJoinRequested_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GameRichPresenceJoinRequested_t>(),
        1usize,
        concat!("Alignment of ", stringify!(GameRichPresenceJoinRequested_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameRichPresenceJoinRequested_t>())).m_steamIDFriend as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameRichPresenceJoinRequested_t),
            "::",
            stringify!(m_steamIDFriend)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameRichPresenceJoinRequested_t>())).m_rgchConnect as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GameRichPresenceJoinRequested_t),
            "::",
            stringify!(m_rgchConnect)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GameConnectedClanChatMsg_t {
    pub m_steamIDClanChat: CSteamID,
    pub m_steamIDUser: CSteamID,
    pub m_iMessageID: ::std::os::raw::c_int,
}
pub const GameConnectedClanChatMsg_t_k_iCallback: GameConnectedClanChatMsg_t__bindgen_ty_1 =
    GameConnectedClanChatMsg_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GameConnectedClanChatMsg_t__bindgen_ty_1 {
    k_iCallback = 338,
}
#[test]
fn bindgen_test_layout_GameConnectedClanChatMsg_t() {
    assert_eq!(
        ::std::mem::size_of::<GameConnectedClanChatMsg_t>(),
        20usize,
        concat!("Size of: ", stringify!(GameConnectedClanChatMsg_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GameConnectedClanChatMsg_t>(),
        4usize,
        concat!("Alignment of ", stringify!(GameConnectedClanChatMsg_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameConnectedClanChatMsg_t>())).m_steamIDClanChat as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameConnectedClanChatMsg_t),
            "::",
            stringify!(m_steamIDClanChat)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameConnectedClanChatMsg_t>())).m_steamIDUser as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GameConnectedClanChatMsg_t),
            "::",
            stringify!(m_steamIDUser)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameConnectedClanChatMsg_t>())).m_iMessageID as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(GameConnectedClanChatMsg_t),
            "::",
            stringify!(m_iMessageID)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GameConnectedChatJoin_t {
    pub m_steamIDClanChat: CSteamID,
    pub m_steamIDUser: CSteamID,
}
pub const GameConnectedChatJoin_t_k_iCallback: GameConnectedChatJoin_t__bindgen_ty_1 =
    GameConnectedChatJoin_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GameConnectedChatJoin_t__bindgen_ty_1 {
    k_iCallback = 339,
}
#[test]
fn bindgen_test_layout_GameConnectedChatJoin_t() {
    assert_eq!(
        ::std::mem::size_of::<GameConnectedChatJoin_t>(),
        16usize,
        concat!("Size of: ", stringify!(GameConnectedChatJoin_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GameConnectedChatJoin_t>(),
        1usize,
        concat!("Alignment of ", stringify!(GameConnectedChatJoin_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameConnectedChatJoin_t>())).m_steamIDClanChat as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameConnectedChatJoin_t),
            "::",
            stringify!(m_steamIDClanChat)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameConnectedChatJoin_t>())).m_steamIDUser as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GameConnectedChatJoin_t),
            "::",
            stringify!(m_steamIDUser)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GameConnectedChatLeave_t {
    pub m_steamIDClanChat: CSteamID,
    pub m_steamIDUser: CSteamID,
    pub m_bKicked: bool,
    pub m_bDropped: bool,
}
pub const GameConnectedChatLeave_t_k_iCallback: GameConnectedChatLeave_t__bindgen_ty_1 =
    GameConnectedChatLeave_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GameConnectedChatLeave_t__bindgen_ty_1 {
    k_iCallback = 340,
}
#[test]
fn bindgen_test_layout_GameConnectedChatLeave_t() {
    assert_eq!(
        ::std::mem::size_of::<GameConnectedChatLeave_t>(),
        18usize,
        concat!("Size of: ", stringify!(GameConnectedChatLeave_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GameConnectedChatLeave_t>(),
        1usize,
        concat!("Alignment of ", stringify!(GameConnectedChatLeave_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameConnectedChatLeave_t>())).m_steamIDClanChat as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameConnectedChatLeave_t),
            "::",
            stringify!(m_steamIDClanChat)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameConnectedChatLeave_t>())).m_steamIDUser as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GameConnectedChatLeave_t),
            "::",
            stringify!(m_steamIDUser)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameConnectedChatLeave_t>())).m_bKicked as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(GameConnectedChatLeave_t),
            "::",
            stringify!(m_bKicked)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameConnectedChatLeave_t>())).m_bDropped as *const _ as usize
        },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(GameConnectedChatLeave_t),
            "::",
            stringify!(m_bDropped)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DownloadClanActivityCountsResult_t {
    pub m_bSuccess: bool,
}
pub const DownloadClanActivityCountsResult_t_k_iCallback:
    DownloadClanActivityCountsResult_t__bindgen_ty_1 =
    DownloadClanActivityCountsResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum DownloadClanActivityCountsResult_t__bindgen_ty_1 {
    k_iCallback = 341,
}
#[test]
fn bindgen_test_layout_DownloadClanActivityCountsResult_t() {
    assert_eq!(
        ::std::mem::size_of::<DownloadClanActivityCountsResult_t>(),
        1usize,
        concat!("Size of: ", stringify!(DownloadClanActivityCountsResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<DownloadClanActivityCountsResult_t>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(DownloadClanActivityCountsResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<DownloadClanActivityCountsResult_t>())).m_bSuccess as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(DownloadClanActivityCountsResult_t),
            "::",
            stringify!(m_bSuccess)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct JoinClanChatRoomCompletionResult_t {
    pub m_steamIDClanChat: CSteamID,
    pub m_eChatRoomEnterResponse: EChatRoomEnterResponse,
}
pub const JoinClanChatRoomCompletionResult_t_k_iCallback:
    JoinClanChatRoomCompletionResult_t__bindgen_ty_1 =
    JoinClanChatRoomCompletionResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum JoinClanChatRoomCompletionResult_t__bindgen_ty_1 {
    k_iCallback = 342,
}
#[test]
fn bindgen_test_layout_JoinClanChatRoomCompletionResult_t() {
    assert_eq!(
        ::std::mem::size_of::<JoinClanChatRoomCompletionResult_t>(),
        12usize,
        concat!("Size of: ", stringify!(JoinClanChatRoomCompletionResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<JoinClanChatRoomCompletionResult_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(JoinClanChatRoomCompletionResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<JoinClanChatRoomCompletionResult_t>())).m_steamIDClanChat
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(JoinClanChatRoomCompletionResult_t),
            "::",
            stringify!(m_steamIDClanChat)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<JoinClanChatRoomCompletionResult_t>())).m_eChatRoomEnterResponse
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(JoinClanChatRoomCompletionResult_t),
            "::",
            stringify!(m_eChatRoomEnterResponse)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GameConnectedFriendChatMsg_t {
    pub m_steamIDUser: CSteamID,
    pub m_iMessageID: ::std::os::raw::c_int,
}
pub const GameConnectedFriendChatMsg_t_k_iCallback: GameConnectedFriendChatMsg_t__bindgen_ty_1 =
    GameConnectedFriendChatMsg_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GameConnectedFriendChatMsg_t__bindgen_ty_1 {
    k_iCallback = 343,
}
#[test]
fn bindgen_test_layout_GameConnectedFriendChatMsg_t() {
    assert_eq!(
        ::std::mem::size_of::<GameConnectedFriendChatMsg_t>(),
        12usize,
        concat!("Size of: ", stringify!(GameConnectedFriendChatMsg_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GameConnectedFriendChatMsg_t>(),
        4usize,
        concat!("Alignment of ", stringify!(GameConnectedFriendChatMsg_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameConnectedFriendChatMsg_t>())).m_steamIDUser as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GameConnectedFriendChatMsg_t),
            "::",
            stringify!(m_steamIDUser)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GameConnectedFriendChatMsg_t>())).m_iMessageID as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GameConnectedFriendChatMsg_t),
            "::",
            stringify!(m_iMessageID)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct FriendsGetFollowerCount_t {
    pub m_eResult: EResult,
    pub m_steamID: CSteamID,
    pub m_nCount: ::std::os::raw::c_int,
}
pub const FriendsGetFollowerCount_t_k_iCallback: FriendsGetFollowerCount_t__bindgen_ty_1 =
    FriendsGetFollowerCount_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum FriendsGetFollowerCount_t__bindgen_ty_1 {
    k_iCallback = 344,
}
#[test]
fn bindgen_test_layout_FriendsGetFollowerCount_t() {
    assert_eq!(
        ::std::mem::size_of::<FriendsGetFollowerCount_t>(),
        16usize,
        concat!("Size of: ", stringify!(FriendsGetFollowerCount_t))
    );
    assert_eq!(
        ::std::mem::align_of::<FriendsGetFollowerCount_t>(),
        4usize,
        concat!("Alignment of ", stringify!(FriendsGetFollowerCount_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<FriendsGetFollowerCount_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendsGetFollowerCount_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<FriendsGetFollowerCount_t>())).m_steamID as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendsGetFollowerCount_t),
            "::",
            stringify!(m_steamID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<FriendsGetFollowerCount_t>())).m_nCount as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendsGetFollowerCount_t),
            "::",
            stringify!(m_nCount)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct FriendsIsFollowing_t {
    pub m_eResult: EResult,
    pub m_steamID: CSteamID,
    pub m_bIsFollowing: bool,
}
pub const FriendsIsFollowing_t_k_iCallback: FriendsIsFollowing_t__bindgen_ty_1 =
    FriendsIsFollowing_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum FriendsIsFollowing_t__bindgen_ty_1 {
    k_iCallback = 345,
}
#[test]
fn bindgen_test_layout_FriendsIsFollowing_t() {
    assert_eq!(
        ::std::mem::size_of::<FriendsIsFollowing_t>(),
        16usize,
        concat!("Size of: ", stringify!(FriendsIsFollowing_t))
    );
    assert_eq!(
        ::std::mem::align_of::<FriendsIsFollowing_t>(),
        4usize,
        concat!("Alignment of ", stringify!(FriendsIsFollowing_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FriendsIsFollowing_t>())).m_eResult as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendsIsFollowing_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FriendsIsFollowing_t>())).m_steamID as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendsIsFollowing_t),
            "::",
            stringify!(m_steamID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<FriendsIsFollowing_t>())).m_bIsFollowing as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendsIsFollowing_t),
            "::",
            stringify!(m_bIsFollowing)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct FriendsEnumerateFollowingList_t {
    pub m_eResult: EResult,
    pub m_rgSteamID: [CSteamID; 50usize],
    pub m_nResultsReturned: int32,
    pub m_nTotalResultCount: int32,
}
pub const FriendsEnumerateFollowingList_t_k_iCallback:
    FriendsEnumerateFollowingList_t__bindgen_ty_1 =
    FriendsEnumerateFollowingList_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum FriendsEnumerateFollowingList_t__bindgen_ty_1 {
    k_iCallback = 346,
}
#[test]
fn bindgen_test_layout_FriendsEnumerateFollowingList_t() {
    assert_eq!(
        ::std::mem::size_of::<FriendsEnumerateFollowingList_t>(),
        412usize,
        concat!("Size of: ", stringify!(FriendsEnumerateFollowingList_t))
    );
    assert_eq!(
        ::std::mem::align_of::<FriendsEnumerateFollowingList_t>(),
        4usize,
        concat!("Alignment of ", stringify!(FriendsEnumerateFollowingList_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<FriendsEnumerateFollowingList_t>())).m_eResult as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendsEnumerateFollowingList_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<FriendsEnumerateFollowingList_t>())).m_rgSteamID as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendsEnumerateFollowingList_t),
            "::",
            stringify!(m_rgSteamID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<FriendsEnumerateFollowingList_t>())).m_nResultsReturned
                as *const _ as usize
        },
        404usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendsEnumerateFollowingList_t),
            "::",
            stringify!(m_nResultsReturned)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<FriendsEnumerateFollowingList_t>())).m_nTotalResultCount
                as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(FriendsEnumerateFollowingList_t),
            "::",
            stringify!(m_nTotalResultCount)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetPersonaNameResponse_t {
    pub m_bSuccess: bool,
    pub m_bLocalSuccess: bool,
    pub m_result: EResult,
}
pub const SetPersonaNameResponse_t_k_iCallback: SetPersonaNameResponse_t__bindgen_ty_1 =
    SetPersonaNameResponse_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SetPersonaNameResponse_t__bindgen_ty_1 {
    k_iCallback = 347,
}
#[test]
fn bindgen_test_layout_SetPersonaNameResponse_t() {
    assert_eq!(
        ::std::mem::size_of::<SetPersonaNameResponse_t>(),
        8usize,
        concat!("Size of: ", stringify!(SetPersonaNameResponse_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SetPersonaNameResponse_t>(),
        4usize,
        concat!("Alignment of ", stringify!(SetPersonaNameResponse_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SetPersonaNameResponse_t>())).m_bSuccess as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SetPersonaNameResponse_t),
            "::",
            stringify!(m_bSuccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SetPersonaNameResponse_t>())).m_bLocalSuccess as *const _
                as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(SetPersonaNameResponse_t),
            "::",
            stringify!(m_bLocalSuccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SetPersonaNameResponse_t>())).m_result as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(SetPersonaNameResponse_t),
            "::",
            stringify!(m_result)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UnreadChatMessagesChanged_t {
    pub _address: u8,
}
pub const UnreadChatMessagesChanged_t_k_iCallback: UnreadChatMessagesChanged_t__bindgen_ty_1 =
    UnreadChatMessagesChanged_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum UnreadChatMessagesChanged_t__bindgen_ty_1 {
    k_iCallback = 348,
}
#[test]
fn bindgen_test_layout_UnreadChatMessagesChanged_t() {
    assert_eq!(
        ::std::mem::size_of::<UnreadChatMessagesChanged_t>(),
        1usize,
        concat!("Size of: ", stringify!(UnreadChatMessagesChanged_t))
    );
    assert_eq!(
        ::std::mem::align_of::<UnreadChatMessagesChanged_t>(),
        1usize,
        concat!("Alignment of ", stringify!(UnreadChatMessagesChanged_t))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct OverlayBrowserProtocolNavigation_t {
    pub rgchURI: [::std::os::raw::c_char; 1024usize],
}
pub const OverlayBrowserProtocolNavigation_t_k_iCallback:
    OverlayBrowserProtocolNavigation_t__bindgen_ty_1 =
    OverlayBrowserProtocolNavigation_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum OverlayBrowserProtocolNavigation_t__bindgen_ty_1 {
    k_iCallback = 349,
}
#[test]
fn bindgen_test_layout_OverlayBrowserProtocolNavigation_t() {
    assert_eq!(
        ::std::mem::size_of::<OverlayBrowserProtocolNavigation_t>(),
        1024usize,
        concat!("Size of: ", stringify!(OverlayBrowserProtocolNavigation_t))
    );
    assert_eq!(
        ::std::mem::align_of::<OverlayBrowserProtocolNavigation_t>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(OverlayBrowserProtocolNavigation_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<OverlayBrowserProtocolNavigation_t>())).rgchURI as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(OverlayBrowserProtocolNavigation_t),
            "::",
            stringify!(rgchURI)
        )
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamAPICallFailure {
    k_ESteamAPICallFailureNone = -1,
    k_ESteamAPICallFailureSteamGone = 0,
    k_ESteamAPICallFailureNetworkFailure = 1,
    k_ESteamAPICallFailureInvalidHandle = 2,
    k_ESteamAPICallFailureMismatchedCallback = 3,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EGamepadTextInputMode {
    k_EGamepadTextInputModeNormal = 0,
    k_EGamepadTextInputModePassword = 1,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EGamepadTextInputLineMode {
    k_EGamepadTextInputLineModeSingleLine = 0,
    k_EGamepadTextInputLineModeMultipleLines = 1,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ETextFilteringContext {
    k_ETextFilteringContextUnknown = 0,
    k_ETextFilteringContextGameContent = 1,
    k_ETextFilteringContextChat = 2,
    k_ETextFilteringContextName = 3,
}
#[repr(C)]
pub struct ISteamUtils__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamUtils {
    pub vtable_: *const ISteamUtils__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamUtils() {
    assert_eq!(
        ::std::mem::size_of::<ISteamUtils>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamUtils))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamUtils>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamUtils))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct IPCountry_t {
    pub _address: u8,
}
pub const IPCountry_t_k_iCallback: IPCountry_t__bindgen_ty_1 =
    IPCountry_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum IPCountry_t__bindgen_ty_1 {
    k_iCallback = 701,
}
#[test]
fn bindgen_test_layout_IPCountry_t() {
    assert_eq!(
        ::std::mem::size_of::<IPCountry_t>(),
        1usize,
        concat!("Size of: ", stringify!(IPCountry_t))
    );
    assert_eq!(
        ::std::mem::align_of::<IPCountry_t>(),
        1usize,
        concat!("Alignment of ", stringify!(IPCountry_t))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LowBatteryPower_t {
    pub m_nMinutesBatteryLeft: uint8,
}
pub const LowBatteryPower_t_k_iCallback: LowBatteryPower_t__bindgen_ty_1 =
    LowBatteryPower_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum LowBatteryPower_t__bindgen_ty_1 {
    k_iCallback = 702,
}
#[test]
fn bindgen_test_layout_LowBatteryPower_t() {
    assert_eq!(
        ::std::mem::size_of::<LowBatteryPower_t>(),
        1usize,
        concat!("Size of: ", stringify!(LowBatteryPower_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LowBatteryPower_t>(),
        1usize,
        concat!("Alignment of ", stringify!(LowBatteryPower_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LowBatteryPower_t>())).m_nMinutesBatteryLeft as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LowBatteryPower_t),
            "::",
            stringify!(m_nMinutesBatteryLeft)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamAPICallCompleted_t {
    pub m_hAsyncCall: SteamAPICall_t,
    pub m_iCallback: ::std::os::raw::c_int,
    pub m_cubParam: uint32,
}
pub const SteamAPICallCompleted_t_k_iCallback: SteamAPICallCompleted_t__bindgen_ty_1 =
    SteamAPICallCompleted_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamAPICallCompleted_t__bindgen_ty_1 {
    k_iCallback = 703,
}
#[test]
fn bindgen_test_layout_SteamAPICallCompleted_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamAPICallCompleted_t>(),
        16usize,
        concat!("Size of: ", stringify!(SteamAPICallCompleted_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamAPICallCompleted_t>(),
        8usize,
        concat!("Alignment of ", stringify!(SteamAPICallCompleted_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamAPICallCompleted_t>())).m_hAsyncCall as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamAPICallCompleted_t),
            "::",
            stringify!(m_hAsyncCall)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamAPICallCompleted_t>())).m_iCallback as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamAPICallCompleted_t),
            "::",
            stringify!(m_iCallback)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamAPICallCompleted_t>())).m_cubParam as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamAPICallCompleted_t),
            "::",
            stringify!(m_cubParam)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamShutdown_t {
    pub _address: u8,
}
pub const SteamShutdown_t_k_iCallback: SteamShutdown_t__bindgen_ty_1 =
    SteamShutdown_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamShutdown_t__bindgen_ty_1 {
    k_iCallback = 704,
}
#[test]
fn bindgen_test_layout_SteamShutdown_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamShutdown_t>(),
        1usize,
        concat!("Size of: ", stringify!(SteamShutdown_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamShutdown_t>(),
        1usize,
        concat!("Alignment of ", stringify!(SteamShutdown_t))
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ECheckFileSignature {
    k_ECheckFileSignatureInvalidSignature = 0,
    k_ECheckFileSignatureValidSignature = 1,
    k_ECheckFileSignatureFileNotFound = 2,
    k_ECheckFileSignatureNoSignaturesFoundForThisApp = 3,
    k_ECheckFileSignatureNoSignaturesFoundForThisFile = 4,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CheckFileSignature_t {
    pub m_eCheckFileSignature: ECheckFileSignature,
}
pub const CheckFileSignature_t_k_iCallback: CheckFileSignature_t__bindgen_ty_1 =
    CheckFileSignature_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum CheckFileSignature_t__bindgen_ty_1 {
    k_iCallback = 705,
}
#[test]
fn bindgen_test_layout_CheckFileSignature_t() {
    assert_eq!(
        ::std::mem::size_of::<CheckFileSignature_t>(),
        4usize,
        concat!("Size of: ", stringify!(CheckFileSignature_t))
    );
    assert_eq!(
        ::std::mem::align_of::<CheckFileSignature_t>(),
        4usize,
        concat!("Alignment of ", stringify!(CheckFileSignature_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CheckFileSignature_t>())).m_eCheckFileSignature as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CheckFileSignature_t),
            "::",
            stringify!(m_eCheckFileSignature)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GamepadTextInputDismissed_t {
    pub m_bSubmitted: bool,
    pub m_unSubmittedText: uint32,
}
pub const GamepadTextInputDismissed_t_k_iCallback: GamepadTextInputDismissed_t__bindgen_ty_1 =
    GamepadTextInputDismissed_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GamepadTextInputDismissed_t__bindgen_ty_1 {
    k_iCallback = 714,
}
#[test]
fn bindgen_test_layout_GamepadTextInputDismissed_t() {
    assert_eq!(
        ::std::mem::size_of::<GamepadTextInputDismissed_t>(),
        8usize,
        concat!("Size of: ", stringify!(GamepadTextInputDismissed_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GamepadTextInputDismissed_t>(),
        4usize,
        concat!("Alignment of ", stringify!(GamepadTextInputDismissed_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GamepadTextInputDismissed_t>())).m_bSubmitted as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GamepadTextInputDismissed_t),
            "::",
            stringify!(m_bSubmitted)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GamepadTextInputDismissed_t>())).m_unSubmittedText as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GamepadTextInputDismissed_t),
            "::",
            stringify!(m_unSubmittedText)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _iobuf {
    pub _Placeholder: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout__iobuf() {
    assert_eq!(
        ::std::mem::size_of::<_iobuf>(),
        8usize,
        concat!("Size of: ", stringify!(_iobuf))
    );
    assert_eq!(
        ::std::mem::align_of::<_iobuf>(),
        8usize,
        concat!("Alignment of ", stringify!(_iobuf))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iobuf>()))._Placeholder as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_iobuf),
            "::",
            stringify!(_Placeholder)
        )
    );
}
pub type FILE = _iobuf;
extern "C" {
    pub fn __acrt_iob_func(_Ix: ::std::os::raw::c_uint) -> *mut FILE;
}
extern "C" {
    pub fn fgetwc(_Stream: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn _fgetwchar() -> wint_t;
}
extern "C" {
    pub fn fputwc(_Character: u16, _Stream: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn _fputwchar(_Character: u16) -> wint_t;
}
extern "C" {
    pub fn getwc(_Stream: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn getwchar() -> wint_t;
}
extern "C" {
    pub fn fgetws(
        _Buffer: *mut u16,
        _BufferCount: ::std::os::raw::c_int,
        _Stream: *mut FILE,
    ) -> *mut u16;
}
extern "C" {
    pub fn fputws(_Buffer: *const u16, _Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _getws_s(_Buffer: *mut u16, _BufferCount: size_t) -> *mut u16;
}
extern "C" {
    pub fn putwc(_Character: u16, _Stream: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn putwchar(_Character: u16) -> wint_t;
}
extern "C" {
    pub fn _putws(_Buffer: *const u16) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ungetwc(_Character: wint_t, _Stream: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn _wfdopen(_FileHandle: ::std::os::raw::c_int, _Mode: *const u16) -> *mut FILE;
}
extern "C" {
    pub fn _wfopen(_FileName: *const u16, _Mode: *const u16) -> *mut FILE;
}
extern "C" {
    pub fn _wfopen_s(_Stream: *mut *mut FILE, _FileName: *const u16, _Mode: *const u16) -> errno_t;
}
extern "C" {
    pub fn _wfreopen(_FileName: *const u16, _Mode: *const u16, _OldStream: *mut FILE) -> *mut FILE;
}
extern "C" {
    pub fn _wfreopen_s(
        _Stream: *mut *mut FILE,
        _FileName: *const u16,
        _Mode: *const u16,
        _OldStream: *mut FILE,
    ) -> errno_t;
}
extern "C" {
    pub fn _wfsopen(
        _FileName: *const u16,
        _Mode: *const u16,
        _ShFlag: ::std::os::raw::c_int,
    ) -> *mut FILE;
}
extern "C" {
    pub fn _wperror(_ErrorMessage: *const u16);
}
extern "C" {
    pub fn _wpopen(_Command: *const u16, _Mode: *const u16) -> *mut FILE;
}
extern "C" {
    pub fn _wremove(_FileName: *const u16) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wtempnam(_Directory: *const u16, _FilePrefix: *const u16) -> *mut u16;
}
extern "C" {
    pub fn _wtmpnam_s(_Buffer: *mut u16, _BufferCount: size_t) -> errno_t;
}
extern "C" {
    pub fn _wtmpnam(_Buffer: *mut u16) -> *mut u16;
}
extern "C" {
    pub fn _fgetwc_nolock(_Stream: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn _fputwc_nolock(_Character: u16, _Stream: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn _getwc_nolock(_Stream: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn _putwc_nolock(_Character: u16, _Stream: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn _ungetwc_nolock(_Character: wint_t, _Stream: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn __stdio_common_vfwprintf(
        _Options: ::std::os::raw::c_ulonglong,
        _Stream: *mut FILE,
        _Format: *const u16,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vfwprintf_s(
        _Options: ::std::os::raw::c_ulonglong,
        _Stream: *mut FILE,
        _Format: *const u16,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vfwprintf_p(
        _Options: ::std::os::raw::c_ulonglong,
        _Stream: *mut FILE,
        _Format: *const u16,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vfwscanf(
        _Options: ::std::os::raw::c_ulonglong,
        _Stream: *mut FILE,
        _Format: *const u16,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vswprintf(
        _Options: ::std::os::raw::c_ulonglong,
        _Buffer: *mut u16,
        _BufferCount: size_t,
        _Format: *const u16,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vswprintf_s(
        _Options: ::std::os::raw::c_ulonglong,
        _Buffer: *mut u16,
        _BufferCount: size_t,
        _Format: *const u16,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vsnwprintf_s(
        _Options: ::std::os::raw::c_ulonglong,
        _Buffer: *mut u16,
        _BufferCount: size_t,
        _MaxCount: size_t,
        _Format: *const u16,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vswprintf_p(
        _Options: ::std::os::raw::c_ulonglong,
        _Buffer: *mut u16,
        _BufferCount: size_t,
        _Format: *const u16,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vswscanf(
        _Options: ::std::os::raw::c_ulonglong,
        _Buffer: *const u16,
        _BufferCount: size_t,
        _Format: *const u16,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
pub type fpos_t = ::std::os::raw::c_longlong;
extern "C" {
    pub fn _get_stream_buffer_pointers(
        _Stream: *mut FILE,
        _Base: *mut *mut *mut ::std::os::raw::c_char,
        _Pointer: *mut *mut *mut ::std::os::raw::c_char,
        _Count: *mut *mut ::std::os::raw::c_int,
    ) -> errno_t;
}
extern "C" {
    pub fn clearerr_s(_Stream: *mut FILE) -> errno_t;
}
extern "C" {
    pub fn fopen_s(
        _Stream: *mut *mut FILE,
        _FileName: *const ::std::os::raw::c_char,
        _Mode: *const ::std::os::raw::c_char,
    ) -> errno_t;
}
extern "C" {
    pub fn fread_s(
        _Buffer: *mut ::std::os::raw::c_void,
        _BufferSize: size_t,
        _ElementSize: size_t,
        _ElementCount: size_t,
        _Stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn freopen_s(
        _Stream: *mut *mut FILE,
        _FileName: *const ::std::os::raw::c_char,
        _Mode: *const ::std::os::raw::c_char,
        _OldStream: *mut FILE,
    ) -> errno_t;
}
extern "C" {
    pub fn gets_s(
        _Buffer: *mut ::std::os::raw::c_char,
        _Size: rsize_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tmpfile_s(_Stream: *mut *mut FILE) -> errno_t;
}
extern "C" {
    pub fn tmpnam_s(_Buffer: *mut ::std::os::raw::c_char, _Size: rsize_t) -> errno_t;
}
extern "C" {
    pub fn clearerr(_Stream: *mut FILE);
}
extern "C" {
    pub fn fclose(_Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fcloseall() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fdopen(
        _FileHandle: ::std::os::raw::c_int,
        _Mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn feof(_Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(_Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(_Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc(_Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fgetchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetpos(_Stream: *mut FILE, _Position: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        _Buffer: *mut ::std::os::raw::c_char,
        _MaxCount: ::std::os::raw::c_int,
        _Stream: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn _fileno(_Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _flushall() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fopen(
        _FileName: *const ::std::os::raw::c_char,
        _Mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fputc(_Character: ::std::os::raw::c_int, _Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fputchar(_Character: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputs(
        _Buffer: *const ::std::os::raw::c_char,
        _Stream: *mut FILE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        _Buffer: *mut ::std::os::raw::c_void,
        _ElementSize: size_t,
        _ElementCount: size_t,
        _Stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn freopen(
        _FileName: *const ::std::os::raw::c_char,
        _Mode: *const ::std::os::raw::c_char,
        _Stream: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn _fsopen(
        _FileName: *const ::std::os::raw::c_char,
        _Mode: *const ::std::os::raw::c_char,
        _ShFlag: ::std::os::raw::c_int,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fsetpos(_Stream: *mut FILE, _Position: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fseek(
        _Stream: *mut FILE,
        _Offset: ::std::os::raw::c_long,
        _Origin: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fseeki64(
        _Stream: *mut FILE,
        _Offset: ::std::os::raw::c_longlong,
        _Origin: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(_Stream: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn _ftelli64(_Stream: *mut FILE) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn fwrite(
        _Buffer: *const ::std::os::raw::c_void,
        _ElementSize: size_t,
        _ElementCount: size_t,
        _Stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn getc(_Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _getmaxstdio() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _getw(_Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perror(_ErrorMessage: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn _pclose(_Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _popen(
        _Command: *const ::std::os::raw::c_char,
        _Mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn putc(_Character: ::std::os::raw::c_int, _Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(_Character: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(_Buffer: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _putw(_Word: ::std::os::raw::c_int, _Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn remove(_FileName: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        _OldFileName: *const ::std::os::raw::c_char,
        _NewFileName: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _unlink(_FileName: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unlink(_FileName: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rewind(_Stream: *mut FILE);
}
extern "C" {
    pub fn _rmtmp() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuf(_Stream: *mut FILE, _Buffer: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn _setmaxstdio(_Maximum: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setvbuf(
        _Stream: *mut FILE,
        _Buffer: *mut ::std::os::raw::c_char,
        _Mode: ::std::os::raw::c_int,
        _Size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _tempnam(
        _DirectoryName: *const ::std::os::raw::c_char,
        _FilePrefix: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn tmpnam(_Buffer: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ungetc(_Character: ::std::os::raw::c_int, _Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _lock_file(_Stream: *mut FILE);
}
extern "C" {
    pub fn _unlock_file(_Stream: *mut FILE);
}
extern "C" {
    pub fn _fclose_nolock(_Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fflush_nolock(_Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fgetc_nolock(_Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fputc_nolock(
        _Character: ::std::os::raw::c_int,
        _Stream: *mut FILE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fread_nolock(
        _Buffer: *mut ::std::os::raw::c_void,
        _ElementSize: size_t,
        _ElementCount: size_t,
        _Stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn _fread_nolock_s(
        _Buffer: *mut ::std::os::raw::c_void,
        _BufferSize: size_t,
        _ElementSize: size_t,
        _ElementCount: size_t,
        _Stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn _fseek_nolock(
        _Stream: *mut FILE,
        _Offset: ::std::os::raw::c_long,
        _Origin: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fseeki64_nolock(
        _Stream: *mut FILE,
        _Offset: ::std::os::raw::c_longlong,
        _Origin: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _ftell_nolock(_Stream: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn _ftelli64_nolock(_Stream: *mut FILE) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn _fwrite_nolock(
        _Buffer: *const ::std::os::raw::c_void,
        _ElementSize: size_t,
        _ElementCount: size_t,
        _Stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn _getc_nolock(_Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _putc_nolock(
        _Character: ::std::os::raw::c_int,
        _Stream: *mut FILE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _ungetc_nolock(
        _Character: ::std::os::raw::c_int,
        _Stream: *mut FILE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __p__commode() -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vfprintf(
        _Options: ::std::os::raw::c_ulonglong,
        _Stream: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vfprintf_s(
        _Options: ::std::os::raw::c_ulonglong,
        _Stream: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vfprintf_p(
        _Options: ::std::os::raw::c_ulonglong,
        _Stream: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _set_printf_count_output(_Value: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _get_printf_count_output() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vfscanf(
        _Options: ::std::os::raw::c_ulonglong,
        _Stream: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _Arglist: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vsprintf(
        _Options: ::std::os::raw::c_ulonglong,
        _Buffer: *mut ::std::os::raw::c_char,
        _BufferCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vsprintf_s(
        _Options: ::std::os::raw::c_ulonglong,
        _Buffer: *mut ::std::os::raw::c_char,
        _BufferCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vsnprintf_s(
        _Options: ::std::os::raw::c_ulonglong,
        _Buffer: *mut ::std::os::raw::c_char,
        _BufferCount: size_t,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vsprintf_p(
        _Options: ::std::os::raw::c_ulonglong,
        _Buffer: *mut ::std::os::raw::c_char,
        _BufferCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __stdio_common_vsscanf(
        _Options: ::std::os::raw::c_ulonglong,
        _Buffer: *const ::std::os::raw::c_char,
        _BufferCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tempnam(
        _Directory: *const ::std::os::raw::c_char,
        _FilePrefix: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fcloseall() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fdopen(
        _FileHandle: ::std::os::raw::c_int,
        _Format: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fgetchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fileno(_Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flushall() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputchar(_Ch: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(_Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(_Ch: ::std::os::raw::c_int, _Stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rmtmp() -> ::std::os::raw::c_int;
}
pub const k_cbMaxGameServerGameDir: ::std::os::raw::c_int = 32;
pub const k_cbMaxGameServerMapName: ::std::os::raw::c_int = 32;
pub const k_cbMaxGameServerGameDescription: ::std::os::raw::c_int = 64;
pub const k_cbMaxGameServerName: ::std::os::raw::c_int = 64;
pub const k_cbMaxGameServerTags: ::std::os::raw::c_int = 128;
pub const k_cbMaxGameServerGameData: ::std::os::raw::c_int = 2048;
#[doc = " Store key/value pair used in matchmaking queries."]
#[doc = ""]
#[doc = " Actually, the name Key/Value is a bit misleading.  The \"key\" is better"]
#[doc = " understood as \"filter operation code\" and the \"value\" is the operand to this"]
#[doc = " filter operation.  The meaning of the operand depends upon the filter."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct MatchMakingKeyValuePair_t {
    pub m_szKey: [::std::os::raw::c_char; 256usize],
    pub m_szValue: [::std::os::raw::c_char; 256usize],
}
#[test]
fn bindgen_test_layout_MatchMakingKeyValuePair_t() {
    assert_eq!(
        ::std::mem::size_of::<MatchMakingKeyValuePair_t>(),
        512usize,
        concat!("Size of: ", stringify!(MatchMakingKeyValuePair_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MatchMakingKeyValuePair_t>(),
        1usize,
        concat!("Alignment of ", stringify!(MatchMakingKeyValuePair_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MatchMakingKeyValuePair_t>())).m_szKey as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MatchMakingKeyValuePair_t),
            "::",
            stringify!(m_szKey)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MatchMakingKeyValuePair_t>())).m_szValue as *const _ as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(MatchMakingKeyValuePair_t),
            "::",
            stringify!(m_szValue)
        )
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EMatchMakingServerResponse {
    eServerResponded = 0,
    eServerFailedToRespond = 1,
    eNoServersListedOnMasterServer = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct servernetadr_t {
    pub m_usConnectionPort: uint16,
    pub m_usQueryPort: uint16,
    pub m_unIP: uint32,
}
#[test]
fn bindgen_test_layout_servernetadr_t() {
    assert_eq!(
        ::std::mem::size_of::<servernetadr_t>(),
        8usize,
        concat!("Size of: ", stringify!(servernetadr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<servernetadr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(servernetadr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<servernetadr_t>())).m_usConnectionPort as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(servernetadr_t),
            "::",
            stringify!(m_usConnectionPort)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<servernetadr_t>())).m_usQueryPort as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(servernetadr_t),
            "::",
            stringify!(m_usQueryPort)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<servernetadr_t>())).m_unIP as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(servernetadr_t),
            "::",
            stringify!(m_unIP)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}?Init@servernetadr_t@@QEAAXIGG@Z"]
    pub fn servernetadr_t_Init(
        this: *mut servernetadr_t,
        ip: ::std::os::raw::c_uint,
        usQueryPort: uint16,
        usConnectionPort: uint16,
    );
}
extern "C" {
    #[link_name = "\u{1}?GetQueryPort@servernetadr_t@@QEBAGXZ"]
    pub fn servernetadr_t_GetQueryPort(this: *const servernetadr_t) -> uint16;
}
extern "C" {
    #[link_name = "\u{1}?SetQueryPort@servernetadr_t@@QEAAXG@Z"]
    pub fn servernetadr_t_SetQueryPort(this: *mut servernetadr_t, usPort: uint16);
}
extern "C" {
    #[link_name = "\u{1}?GetConnectionPort@servernetadr_t@@QEBAGXZ"]
    pub fn servernetadr_t_GetConnectionPort(this: *const servernetadr_t) -> uint16;
}
extern "C" {
    #[link_name = "\u{1}?SetConnectionPort@servernetadr_t@@QEAAXG@Z"]
    pub fn servernetadr_t_SetConnectionPort(this: *mut servernetadr_t, usPort: uint16);
}
extern "C" {
    #[link_name = "\u{1}?GetIP@servernetadr_t@@QEBAIXZ"]
    pub fn servernetadr_t_GetIP(this: *const servernetadr_t) -> uint32;
}
extern "C" {
    #[link_name = "\u{1}?SetIP@servernetadr_t@@QEAAXI@Z"]
    pub fn servernetadr_t_SetIP(this: *mut servernetadr_t, unIP: uint32);
}
extern "C" {
    #[link_name = "\u{1}?GetConnectionAddressString@servernetadr_t@@QEBAPEBDXZ"]
    pub fn servernetadr_t_GetConnectionAddressString(
        this: *const servernetadr_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}?GetQueryAddressString@servernetadr_t@@QEBAPEBDXZ"]
    pub fn servernetadr_t_GetQueryAddressString(
        this: *const servernetadr_t,
    ) -> *const ::std::os::raw::c_char;
}
impl servernetadr_t {
    #[inline]
    pub unsafe fn Init(
        &mut self,
        ip: ::std::os::raw::c_uint,
        usQueryPort: uint16,
        usConnectionPort: uint16,
    ) {
        servernetadr_t_Init(self, ip, usQueryPort, usConnectionPort)
    }
    #[inline]
    pub unsafe fn GetQueryPort(&self) -> uint16 {
        servernetadr_t_GetQueryPort(self)
    }
    #[inline]
    pub unsafe fn SetQueryPort(&mut self, usPort: uint16) {
        servernetadr_t_SetQueryPort(self, usPort)
    }
    #[inline]
    pub unsafe fn GetConnectionPort(&self) -> uint16 {
        servernetadr_t_GetConnectionPort(self)
    }
    #[inline]
    pub unsafe fn SetConnectionPort(&mut self, usPort: uint16) {
        servernetadr_t_SetConnectionPort(self, usPort)
    }
    #[inline]
    pub unsafe fn GetIP(&self) -> uint32 {
        servernetadr_t_GetIP(self)
    }
    #[inline]
    pub unsafe fn SetIP(&mut self, unIP: uint32) {
        servernetadr_t_SetIP(self, unIP)
    }
    #[inline]
    pub unsafe fn GetConnectionAddressString(&self) -> *const ::std::os::raw::c_char {
        servernetadr_t_GetConnectionAddressString(self)
    }
    #[inline]
    pub unsafe fn GetQueryAddressString(&self) -> *const ::std::os::raw::c_char {
        servernetadr_t_GetQueryAddressString(self)
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct gameserveritem_t {
    #[doc = "< IP/Query Port/Connection Port for this server"]
    pub m_NetAdr: servernetadr_t,
    #[doc = "< current ping time in milliseconds"]
    pub m_nPing: ::std::os::raw::c_int,
    #[doc = "< server has responded successfully in the past"]
    pub m_bHadSuccessfulResponse: bool,
    #[doc = "< server is marked as not responding and should no longer be refreshed"]
    pub m_bDoNotRefresh: bool,
    #[doc = "< current game directory"]
    pub m_szGameDir: [::std::os::raw::c_char; 32usize],
    #[doc = "< current map"]
    pub m_szMap: [::std::os::raw::c_char; 32usize],
    #[doc = "< game description"]
    pub m_szGameDescription: [::std::os::raw::c_char; 64usize],
    #[doc = "< Steam App ID of this server"]
    pub m_nAppID: uint32,
    #[doc = "< total number of players currently on the server.  INCLUDES BOTS!!"]
    pub m_nPlayers: ::std::os::raw::c_int,
    #[doc = "< Maximum players that can join this server"]
    pub m_nMaxPlayers: ::std::os::raw::c_int,
    #[doc = "< Number of bots (i.e simulated players) on this server"]
    pub m_nBotPlayers: ::std::os::raw::c_int,
    #[doc = "< true if this server needs a password to join"]
    pub m_bPassword: bool,
    #[doc = "< Is this server protected by VAC"]
    pub m_bSecure: bool,
    #[doc = "< time (in unix time) when this server was last played on (for favorite/history servers)"]
    pub m_ulTimeLastPlayed: uint32,
    #[doc = "< server version as reported to Steam"]
    pub m_nServerVersion: ::std::os::raw::c_int,
    #[doc = " Game server name"]
    pub m_szServerName: [::std::os::raw::c_char; 64usize],
    #[doc = " the tags this server exposes"]
    pub m_szGameTags: [::std::os::raw::c_char; 128usize],
    #[doc = " steamID of the game server - invalid if it's doesn't have one (old server, or not connected to Steam)"]
    pub m_steamID: CSteamID,
}
#[test]
fn bindgen_test_layout_gameserveritem_t() {
    assert_eq!(
        ::std::mem::size_of::<gameserveritem_t>(),
        372usize,
        concat!("Size of: ", stringify!(gameserveritem_t))
    );
    assert_eq!(
        ::std::mem::align_of::<gameserveritem_t>(),
        4usize,
        concat!("Alignment of ", stringify!(gameserveritem_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gameserveritem_t>())).m_NetAdr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_NetAdr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gameserveritem_t>())).m_nPing as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_nPing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gameserveritem_t>())).m_bHadSuccessfulResponse as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_bHadSuccessfulResponse)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gameserveritem_t>())).m_bDoNotRefresh as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_bDoNotRefresh)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gameserveritem_t>())).m_szGameDir as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_szGameDir)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gameserveritem_t>())).m_szMap as *const _ as usize },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_szMap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gameserveritem_t>())).m_szGameDescription as *const _ as usize
        },
        78usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_szGameDescription)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gameserveritem_t>())).m_nAppID as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_nAppID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gameserveritem_t>())).m_nPlayers as *const _ as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_nPlayers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gameserveritem_t>())).m_nMaxPlayers as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_nMaxPlayers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gameserveritem_t>())).m_nBotPlayers as *const _ as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_nBotPlayers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gameserveritem_t>())).m_bPassword as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_bPassword)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gameserveritem_t>())).m_bSecure as *const _ as usize },
        161usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_bSecure)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gameserveritem_t>())).m_ulTimeLastPlayed as *const _ as usize
        },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_ulTimeLastPlayed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<gameserveritem_t>())).m_nServerVersion as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_nServerVersion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gameserveritem_t>())).m_szServerName as *const _ as usize },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_szServerName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gameserveritem_t>())).m_szGameTags as *const _ as usize },
        236usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_szGameTags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<gameserveritem_t>())).m_steamID as *const _ as usize },
        364usize,
        concat!(
            "Offset of field: ",
            stringify!(gameserveritem_t),
            "::",
            stringify!(m_steamID)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}?GetName@gameserveritem_t@@QEBAPEBDXZ"]
    pub fn gameserveritem_t_GetName(this: *const gameserveritem_t)
        -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}?SetName@gameserveritem_t@@QEAAXPEBD@Z"]
    pub fn gameserveritem_t_SetName(
        this: *mut gameserveritem_t,
        pName: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    #[link_name = "\u{1}??0gameserveritem_t@@QEAA@XZ"]
    pub fn gameserveritem_t_gameserveritem_t(this: *mut gameserveritem_t);
}
impl gameserveritem_t {
    #[inline]
    pub unsafe fn GetName(&self) -> *const ::std::os::raw::c_char {
        gameserveritem_t_GetName(self)
    }
    #[inline]
    pub unsafe fn SetName(&mut self, pName: *const ::std::os::raw::c_char) {
        gameserveritem_t_SetName(self, pName)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        gameserveritem_t_gameserveritem_t(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ELobbyType {
    k_ELobbyTypePrivate = 0,
    k_ELobbyTypeFriendsOnly = 1,
    k_ELobbyTypePublic = 2,
    k_ELobbyTypeInvisible = 3,
    k_ELobbyTypePrivateUnique = 4,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ELobbyComparison {
    k_ELobbyComparisonEqualToOrLessThan = -2,
    k_ELobbyComparisonLessThan = -1,
    k_ELobbyComparisonEqual = 0,
    k_ELobbyComparisonGreaterThan = 1,
    k_ELobbyComparisonEqualToOrGreaterThan = 2,
    k_ELobbyComparisonNotEqual = 3,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ELobbyDistanceFilter {
    k_ELobbyDistanceFilterClose = 0,
    k_ELobbyDistanceFilterDefault = 1,
    k_ELobbyDistanceFilterFar = 2,
    k_ELobbyDistanceFilterWorldwide = 3,
}
#[repr(C)]
pub struct ISteamMatchmaking__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamMatchmaking {
    pub vtable_: *const ISteamMatchmaking__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamMatchmaking() {
    assert_eq!(
        ::std::mem::size_of::<ISteamMatchmaking>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamMatchmaking))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamMatchmaking>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamMatchmaking))
    );
}
pub type HServerListRequest = *mut ::std::os::raw::c_void;
#[repr(C)]
pub struct ISteamMatchmakingServerListResponse__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamMatchmakingServerListResponse {
    pub vtable_: *const ISteamMatchmakingServerListResponse__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamMatchmakingServerListResponse() {
    assert_eq!(
        ::std::mem::size_of::<ISteamMatchmakingServerListResponse>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamMatchmakingServerListResponse))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamMatchmakingServerListResponse>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(ISteamMatchmakingServerListResponse)
        )
    );
}
#[repr(C)]
pub struct ISteamMatchmakingPingResponse__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamMatchmakingPingResponse {
    pub vtable_: *const ISteamMatchmakingPingResponse__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamMatchmakingPingResponse() {
    assert_eq!(
        ::std::mem::size_of::<ISteamMatchmakingPingResponse>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamMatchmakingPingResponse))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamMatchmakingPingResponse>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamMatchmakingPingResponse))
    );
}
#[repr(C)]
pub struct ISteamMatchmakingPlayersResponse__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamMatchmakingPlayersResponse {
    pub vtable_: *const ISteamMatchmakingPlayersResponse__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamMatchmakingPlayersResponse() {
    assert_eq!(
        ::std::mem::size_of::<ISteamMatchmakingPlayersResponse>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamMatchmakingPlayersResponse))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamMatchmakingPlayersResponse>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(ISteamMatchmakingPlayersResponse)
        )
    );
}
#[repr(C)]
pub struct ISteamMatchmakingRulesResponse__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamMatchmakingRulesResponse {
    pub vtable_: *const ISteamMatchmakingRulesResponse__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamMatchmakingRulesResponse() {
    assert_eq!(
        ::std::mem::size_of::<ISteamMatchmakingRulesResponse>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamMatchmakingRulesResponse))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamMatchmakingRulesResponse>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamMatchmakingRulesResponse))
    );
}
pub type HServerQuery = ::std::os::raw::c_int;
pub const HSERVERQUERY_INVALID: ::std::os::raw::c_int = -1;
#[repr(C)]
pub struct ISteamMatchmakingServers__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamMatchmakingServers {
    pub vtable_: *const ISteamMatchmakingServers__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamMatchmakingServers() {
    assert_eq!(
        ::std::mem::size_of::<ISteamMatchmakingServers>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamMatchmakingServers))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamMatchmakingServers>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamMatchmakingServers))
    );
}
pub const k_unFavoriteFlagNone: uint32 = 0;
pub const k_unFavoriteFlagFavorite: uint32 = 1;
pub const k_unFavoriteFlagHistory: uint32 = 2;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EChatMemberStateChange {
    k_EChatMemberStateChangeEntered = 1,
    k_EChatMemberStateChangeLeft = 2,
    k_EChatMemberStateChangeDisconnected = 4,
    k_EChatMemberStateChangeKicked = 8,
    k_EChatMemberStateChangeBanned = 16,
}
#[repr(C)]
pub struct ISteamGameSearch__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamGameSearch {
    pub vtable_: *const ISteamGameSearch__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamGameSearch() {
    assert_eq!(
        ::std::mem::size_of::<ISteamGameSearch>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamGameSearch))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamGameSearch>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamGameSearch))
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamPartyBeaconLocationType {
    k_ESteamPartyBeaconLocationType_Invalid = 0,
    k_ESteamPartyBeaconLocationType_ChatGroup = 1,
    k_ESteamPartyBeaconLocationType_Max = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamPartyBeaconLocation_t {
    pub m_eType: ESteamPartyBeaconLocationType,
    pub m_ulLocationID: uint64,
}
#[test]
fn bindgen_test_layout_SteamPartyBeaconLocation_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamPartyBeaconLocation_t>(),
        16usize,
        concat!("Size of: ", stringify!(SteamPartyBeaconLocation_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamPartyBeaconLocation_t>(),
        8usize,
        concat!("Alignment of ", stringify!(SteamPartyBeaconLocation_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamPartyBeaconLocation_t>())).m_eType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamPartyBeaconLocation_t),
            "::",
            stringify!(m_eType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamPartyBeaconLocation_t>())).m_ulLocationID as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamPartyBeaconLocation_t),
            "::",
            stringify!(m_ulLocationID)
        )
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamPartyBeaconLocationData {
    k_ESteamPartyBeaconLocationDataInvalid = 0,
    k_ESteamPartyBeaconLocationDataName = 1,
    k_ESteamPartyBeaconLocationDataIconURLSmall = 2,
    k_ESteamPartyBeaconLocationDataIconURLMedium = 3,
    k_ESteamPartyBeaconLocationDataIconURLLarge = 4,
}
#[repr(C)]
pub struct ISteamParties__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamParties {
    pub vtable_: *const ISteamParties__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamParties() {
    assert_eq!(
        ::std::mem::size_of::<ISteamParties>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamParties))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamParties>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamParties))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FavoritesListChanged_t {
    pub m_nIP: uint32,
    pub m_nQueryPort: uint32,
    pub m_nConnPort: uint32,
    pub m_nAppID: uint32,
    pub m_nFlags: uint32,
    pub m_bAdd: bool,
    pub m_unAccountId: AccountID_t,
}
pub const FavoritesListChanged_t_k_iCallback: FavoritesListChanged_t__bindgen_ty_1 =
    FavoritesListChanged_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum FavoritesListChanged_t__bindgen_ty_1 {
    k_iCallback = 502,
}
#[test]
fn bindgen_test_layout_FavoritesListChanged_t() {
    assert_eq!(
        ::std::mem::size_of::<FavoritesListChanged_t>(),
        28usize,
        concat!("Size of: ", stringify!(FavoritesListChanged_t))
    );
    assert_eq!(
        ::std::mem::align_of::<FavoritesListChanged_t>(),
        4usize,
        concat!("Alignment of ", stringify!(FavoritesListChanged_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FavoritesListChanged_t>())).m_nIP as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FavoritesListChanged_t),
            "::",
            stringify!(m_nIP)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<FavoritesListChanged_t>())).m_nQueryPort as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(FavoritesListChanged_t),
            "::",
            stringify!(m_nQueryPort)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<FavoritesListChanged_t>())).m_nConnPort as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FavoritesListChanged_t),
            "::",
            stringify!(m_nConnPort)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FavoritesListChanged_t>())).m_nAppID as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(FavoritesListChanged_t),
            "::",
            stringify!(m_nAppID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FavoritesListChanged_t>())).m_nFlags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(FavoritesListChanged_t),
            "::",
            stringify!(m_nFlags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FavoritesListChanged_t>())).m_bAdd as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(FavoritesListChanged_t),
            "::",
            stringify!(m_bAdd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<FavoritesListChanged_t>())).m_unAccountId as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(FavoritesListChanged_t),
            "::",
            stringify!(m_unAccountId)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LobbyInvite_t {
    pub m_ulSteamIDUser: uint64,
    pub m_ulSteamIDLobby: uint64,
    pub m_ulGameID: uint64,
}
pub const LobbyInvite_t_k_iCallback: LobbyInvite_t__bindgen_ty_1 =
    LobbyInvite_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum LobbyInvite_t__bindgen_ty_1 {
    k_iCallback = 503,
}
#[test]
fn bindgen_test_layout_LobbyInvite_t() {
    assert_eq!(
        ::std::mem::size_of::<LobbyInvite_t>(),
        24usize,
        concat!("Size of: ", stringify!(LobbyInvite_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LobbyInvite_t>(),
        8usize,
        concat!("Alignment of ", stringify!(LobbyInvite_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyInvite_t>())).m_ulSteamIDUser as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyInvite_t),
            "::",
            stringify!(m_ulSteamIDUser)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyInvite_t>())).m_ulSteamIDLobby as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyInvite_t),
            "::",
            stringify!(m_ulSteamIDLobby)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyInvite_t>())).m_ulGameID as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyInvite_t),
            "::",
            stringify!(m_ulGameID)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LobbyEnter_t {
    pub m_ulSteamIDLobby: uint64,
    pub m_rgfChatPermissions: uint32,
    pub m_bLocked: bool,
    pub m_EChatRoomEnterResponse: uint32,
}
pub const LobbyEnter_t_k_iCallback: LobbyEnter_t__bindgen_ty_1 =
    LobbyEnter_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum LobbyEnter_t__bindgen_ty_1 {
    k_iCallback = 504,
}
#[test]
fn bindgen_test_layout_LobbyEnter_t() {
    assert_eq!(
        ::std::mem::size_of::<LobbyEnter_t>(),
        24usize,
        concat!("Size of: ", stringify!(LobbyEnter_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LobbyEnter_t>(),
        8usize,
        concat!("Alignment of ", stringify!(LobbyEnter_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyEnter_t>())).m_ulSteamIDLobby as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyEnter_t),
            "::",
            stringify!(m_ulSteamIDLobby)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LobbyEnter_t>())).m_rgfChatPermissions as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyEnter_t),
            "::",
            stringify!(m_rgfChatPermissions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyEnter_t>())).m_bLocked as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyEnter_t),
            "::",
            stringify!(m_bLocked)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LobbyEnter_t>())).m_EChatRoomEnterResponse as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyEnter_t),
            "::",
            stringify!(m_EChatRoomEnterResponse)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LobbyDataUpdate_t {
    pub m_ulSteamIDLobby: uint64,
    pub m_ulSteamIDMember: uint64,
    pub m_bSuccess: uint8,
}
pub const LobbyDataUpdate_t_k_iCallback: LobbyDataUpdate_t__bindgen_ty_1 =
    LobbyDataUpdate_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum LobbyDataUpdate_t__bindgen_ty_1 {
    k_iCallback = 505,
}
#[test]
fn bindgen_test_layout_LobbyDataUpdate_t() {
    assert_eq!(
        ::std::mem::size_of::<LobbyDataUpdate_t>(),
        24usize,
        concat!("Size of: ", stringify!(LobbyDataUpdate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LobbyDataUpdate_t>(),
        8usize,
        concat!("Alignment of ", stringify!(LobbyDataUpdate_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LobbyDataUpdate_t>())).m_ulSteamIDLobby as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyDataUpdate_t),
            "::",
            stringify!(m_ulSteamIDLobby)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LobbyDataUpdate_t>())).m_ulSteamIDMember as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyDataUpdate_t),
            "::",
            stringify!(m_ulSteamIDMember)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyDataUpdate_t>())).m_bSuccess as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyDataUpdate_t),
            "::",
            stringify!(m_bSuccess)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LobbyChatUpdate_t {
    pub m_ulSteamIDLobby: uint64,
    pub m_ulSteamIDUserChanged: uint64,
    pub m_ulSteamIDMakingChange: uint64,
    pub m_rgfChatMemberStateChange: uint32,
}
pub const LobbyChatUpdate_t_k_iCallback: LobbyChatUpdate_t__bindgen_ty_1 =
    LobbyChatUpdate_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum LobbyChatUpdate_t__bindgen_ty_1 {
    k_iCallback = 506,
}
#[test]
fn bindgen_test_layout_LobbyChatUpdate_t() {
    assert_eq!(
        ::std::mem::size_of::<LobbyChatUpdate_t>(),
        32usize,
        concat!("Size of: ", stringify!(LobbyChatUpdate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LobbyChatUpdate_t>(),
        8usize,
        concat!("Alignment of ", stringify!(LobbyChatUpdate_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LobbyChatUpdate_t>())).m_ulSteamIDLobby as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyChatUpdate_t),
            "::",
            stringify!(m_ulSteamIDLobby)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LobbyChatUpdate_t>())).m_ulSteamIDUserChanged as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyChatUpdate_t),
            "::",
            stringify!(m_ulSteamIDUserChanged)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LobbyChatUpdate_t>())).m_ulSteamIDMakingChange as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyChatUpdate_t),
            "::",
            stringify!(m_ulSteamIDMakingChange)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LobbyChatUpdate_t>())).m_rgfChatMemberStateChange as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyChatUpdate_t),
            "::",
            stringify!(m_rgfChatMemberStateChange)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LobbyChatMsg_t {
    pub m_ulSteamIDLobby: uint64,
    pub m_ulSteamIDUser: uint64,
    pub m_eChatEntryType: uint8,
    pub m_iChatID: uint32,
}
pub const LobbyChatMsg_t_k_iCallback: LobbyChatMsg_t__bindgen_ty_1 =
    LobbyChatMsg_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum LobbyChatMsg_t__bindgen_ty_1 {
    k_iCallback = 507,
}
#[test]
fn bindgen_test_layout_LobbyChatMsg_t() {
    assert_eq!(
        ::std::mem::size_of::<LobbyChatMsg_t>(),
        24usize,
        concat!("Size of: ", stringify!(LobbyChatMsg_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LobbyChatMsg_t>(),
        8usize,
        concat!("Alignment of ", stringify!(LobbyChatMsg_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyChatMsg_t>())).m_ulSteamIDLobby as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyChatMsg_t),
            "::",
            stringify!(m_ulSteamIDLobby)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyChatMsg_t>())).m_ulSteamIDUser as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyChatMsg_t),
            "::",
            stringify!(m_ulSteamIDUser)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyChatMsg_t>())).m_eChatEntryType as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyChatMsg_t),
            "::",
            stringify!(m_eChatEntryType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyChatMsg_t>())).m_iChatID as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyChatMsg_t),
            "::",
            stringify!(m_iChatID)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LobbyGameCreated_t {
    pub m_ulSteamIDLobby: uint64,
    pub m_ulSteamIDGameServer: uint64,
    pub m_unIP: uint32,
    pub m_usPort: uint16,
}
pub const LobbyGameCreated_t_k_iCallback: LobbyGameCreated_t__bindgen_ty_1 =
    LobbyGameCreated_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum LobbyGameCreated_t__bindgen_ty_1 {
    k_iCallback = 509,
}
#[test]
fn bindgen_test_layout_LobbyGameCreated_t() {
    assert_eq!(
        ::std::mem::size_of::<LobbyGameCreated_t>(),
        24usize,
        concat!("Size of: ", stringify!(LobbyGameCreated_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LobbyGameCreated_t>(),
        8usize,
        concat!("Alignment of ", stringify!(LobbyGameCreated_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LobbyGameCreated_t>())).m_ulSteamIDLobby as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyGameCreated_t),
            "::",
            stringify!(m_ulSteamIDLobby)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LobbyGameCreated_t>())).m_ulSteamIDGameServer as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyGameCreated_t),
            "::",
            stringify!(m_ulSteamIDGameServer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyGameCreated_t>())).m_unIP as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyGameCreated_t),
            "::",
            stringify!(m_unIP)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyGameCreated_t>())).m_usPort as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyGameCreated_t),
            "::",
            stringify!(m_usPort)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LobbyMatchList_t {
    pub m_nLobbiesMatching: uint32,
}
pub const LobbyMatchList_t_k_iCallback: LobbyMatchList_t__bindgen_ty_1 =
    LobbyMatchList_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum LobbyMatchList_t__bindgen_ty_1 {
    k_iCallback = 510,
}
#[test]
fn bindgen_test_layout_LobbyMatchList_t() {
    assert_eq!(
        ::std::mem::size_of::<LobbyMatchList_t>(),
        4usize,
        concat!("Size of: ", stringify!(LobbyMatchList_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LobbyMatchList_t>(),
        4usize,
        concat!("Alignment of ", stringify!(LobbyMatchList_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LobbyMatchList_t>())).m_nLobbiesMatching as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyMatchList_t),
            "::",
            stringify!(m_nLobbiesMatching)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LobbyKicked_t {
    pub m_ulSteamIDLobby: uint64,
    pub m_ulSteamIDAdmin: uint64,
    pub m_bKickedDueToDisconnect: uint8,
}
pub const LobbyKicked_t_k_iCallback: LobbyKicked_t__bindgen_ty_1 =
    LobbyKicked_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum LobbyKicked_t__bindgen_ty_1 {
    k_iCallback = 512,
}
#[test]
fn bindgen_test_layout_LobbyKicked_t() {
    assert_eq!(
        ::std::mem::size_of::<LobbyKicked_t>(),
        24usize,
        concat!("Size of: ", stringify!(LobbyKicked_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LobbyKicked_t>(),
        8usize,
        concat!("Alignment of ", stringify!(LobbyKicked_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyKicked_t>())).m_ulSteamIDLobby as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyKicked_t),
            "::",
            stringify!(m_ulSteamIDLobby)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyKicked_t>())).m_ulSteamIDAdmin as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyKicked_t),
            "::",
            stringify!(m_ulSteamIDAdmin)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LobbyKicked_t>())).m_bKickedDueToDisconnect as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyKicked_t),
            "::",
            stringify!(m_bKickedDueToDisconnect)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LobbyCreated_t {
    pub m_eResult: EResult,
    pub m_ulSteamIDLobby: uint64,
}
pub const LobbyCreated_t_k_iCallback: LobbyCreated_t__bindgen_ty_1 =
    LobbyCreated_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum LobbyCreated_t__bindgen_ty_1 {
    k_iCallback = 513,
}
#[test]
fn bindgen_test_layout_LobbyCreated_t() {
    assert_eq!(
        ::std::mem::size_of::<LobbyCreated_t>(),
        16usize,
        concat!("Size of: ", stringify!(LobbyCreated_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LobbyCreated_t>(),
        8usize,
        concat!("Alignment of ", stringify!(LobbyCreated_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyCreated_t>())).m_eResult as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyCreated_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LobbyCreated_t>())).m_ulSteamIDLobby as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LobbyCreated_t),
            "::",
            stringify!(m_ulSteamIDLobby)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct PSNGameBootInviteResult_t {
    pub m_bGameBootInviteExists: bool,
    pub m_steamIDLobby: CSteamID,
}
pub const PSNGameBootInviteResult_t_k_iCallback: PSNGameBootInviteResult_t__bindgen_ty_1 =
    PSNGameBootInviteResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum PSNGameBootInviteResult_t__bindgen_ty_1 {
    k_iCallback = 515,
}
#[test]
fn bindgen_test_layout_PSNGameBootInviteResult_t() {
    assert_eq!(
        ::std::mem::size_of::<PSNGameBootInviteResult_t>(),
        9usize,
        concat!("Size of: ", stringify!(PSNGameBootInviteResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<PSNGameBootInviteResult_t>(),
        1usize,
        concat!("Alignment of ", stringify!(PSNGameBootInviteResult_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<PSNGameBootInviteResult_t>())).m_bGameBootInviteExists
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PSNGameBootInviteResult_t),
            "::",
            stringify!(m_bGameBootInviteExists)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<PSNGameBootInviteResult_t>())).m_steamIDLobby as *const _
                as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(PSNGameBootInviteResult_t),
            "::",
            stringify!(m_steamIDLobby)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FavoritesListAccountsUpdated_t {
    pub m_eResult: EResult,
}
pub const FavoritesListAccountsUpdated_t_k_iCallback: FavoritesListAccountsUpdated_t__bindgen_ty_1 =
    FavoritesListAccountsUpdated_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum FavoritesListAccountsUpdated_t__bindgen_ty_1 {
    k_iCallback = 516,
}
#[test]
fn bindgen_test_layout_FavoritesListAccountsUpdated_t() {
    assert_eq!(
        ::std::mem::size_of::<FavoritesListAccountsUpdated_t>(),
        4usize,
        concat!("Size of: ", stringify!(FavoritesListAccountsUpdated_t))
    );
    assert_eq!(
        ::std::mem::align_of::<FavoritesListAccountsUpdated_t>(),
        4usize,
        concat!("Alignment of ", stringify!(FavoritesListAccountsUpdated_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<FavoritesListAccountsUpdated_t>())).m_eResult as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FavoritesListAccountsUpdated_t),
            "::",
            stringify!(m_eResult)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SearchForGameProgressCallback_t {
    pub m_ullSearchID: uint64,
    pub m_eResult: EResult,
    pub m_lobbyID: CSteamID,
    pub m_steamIDEndedSearch: CSteamID,
    pub m_nSecondsRemainingEstimate: int32,
    pub m_cPlayersSearching: int32,
}
pub const SearchForGameProgressCallback_t_k_iCallback:
    SearchForGameProgressCallback_t__bindgen_ty_1 =
    SearchForGameProgressCallback_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SearchForGameProgressCallback_t__bindgen_ty_1 {
    k_iCallback = 5201,
}
#[test]
fn bindgen_test_layout_SearchForGameProgressCallback_t() {
    assert_eq!(
        ::std::mem::size_of::<SearchForGameProgressCallback_t>(),
        40usize,
        concat!("Size of: ", stringify!(SearchForGameProgressCallback_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SearchForGameProgressCallback_t>(),
        8usize,
        concat!("Alignment of ", stringify!(SearchForGameProgressCallback_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SearchForGameProgressCallback_t>())).m_ullSearchID as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SearchForGameProgressCallback_t),
            "::",
            stringify!(m_ullSearchID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SearchForGameProgressCallback_t>())).m_eResult as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SearchForGameProgressCallback_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SearchForGameProgressCallback_t>())).m_lobbyID as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(SearchForGameProgressCallback_t),
            "::",
            stringify!(m_lobbyID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SearchForGameProgressCallback_t>())).m_steamIDEndedSearch
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(SearchForGameProgressCallback_t),
            "::",
            stringify!(m_steamIDEndedSearch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SearchForGameProgressCallback_t>())).m_nSecondsRemainingEstimate
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(SearchForGameProgressCallback_t),
            "::",
            stringify!(m_nSecondsRemainingEstimate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SearchForGameProgressCallback_t>())).m_cPlayersSearching
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(SearchForGameProgressCallback_t),
            "::",
            stringify!(m_cPlayersSearching)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SearchForGameResultCallback_t {
    pub m_ullSearchID: uint64,
    pub m_eResult: EResult,
    pub m_nCountPlayersInGame: int32,
    pub m_nCountAcceptedGame: int32,
    pub m_steamIDHost: CSteamID,
    pub m_bFinalCallback: bool,
}
pub const SearchForGameResultCallback_t_k_iCallback: SearchForGameResultCallback_t__bindgen_ty_1 =
    SearchForGameResultCallback_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SearchForGameResultCallback_t__bindgen_ty_1 {
    k_iCallback = 5202,
}
#[test]
fn bindgen_test_layout_SearchForGameResultCallback_t() {
    assert_eq!(
        ::std::mem::size_of::<SearchForGameResultCallback_t>(),
        32usize,
        concat!("Size of: ", stringify!(SearchForGameResultCallback_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SearchForGameResultCallback_t>(),
        8usize,
        concat!("Alignment of ", stringify!(SearchForGameResultCallback_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SearchForGameResultCallback_t>())).m_ullSearchID as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SearchForGameResultCallback_t),
            "::",
            stringify!(m_ullSearchID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SearchForGameResultCallback_t>())).m_eResult as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SearchForGameResultCallback_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SearchForGameResultCallback_t>())).m_nCountPlayersInGame
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(SearchForGameResultCallback_t),
            "::",
            stringify!(m_nCountPlayersInGame)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SearchForGameResultCallback_t>())).m_nCountAcceptedGame
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SearchForGameResultCallback_t),
            "::",
            stringify!(m_nCountAcceptedGame)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SearchForGameResultCallback_t>())).m_steamIDHost as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(SearchForGameResultCallback_t),
            "::",
            stringify!(m_steamIDHost)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SearchForGameResultCallback_t>())).m_bFinalCallback as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(SearchForGameResultCallback_t),
            "::",
            stringify!(m_bFinalCallback)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RequestPlayersForGameProgressCallback_t {
    pub m_eResult: EResult,
    pub m_ullSearchID: uint64,
}
pub const RequestPlayersForGameProgressCallback_t_k_iCallback:
    RequestPlayersForGameProgressCallback_t__bindgen_ty_1 =
    RequestPlayersForGameProgressCallback_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RequestPlayersForGameProgressCallback_t__bindgen_ty_1 {
    k_iCallback = 5211,
}
#[test]
fn bindgen_test_layout_RequestPlayersForGameProgressCallback_t() {
    assert_eq!(
        ::std::mem::size_of::<RequestPlayersForGameProgressCallback_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(RequestPlayersForGameProgressCallback_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RequestPlayersForGameProgressCallback_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RequestPlayersForGameProgressCallback_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RequestPlayersForGameProgressCallback_t>())).m_eResult
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RequestPlayersForGameProgressCallback_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RequestPlayersForGameProgressCallback_t>())).m_ullSearchID
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RequestPlayersForGameProgressCallback_t),
            "::",
            stringify!(m_ullSearchID)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RequestPlayersForGameResultCallback_t {
    pub m_eResult: EResult,
    pub m_ullSearchID: uint64,
    pub m_SteamIDPlayerFound: CSteamID,
    pub m_SteamIDLobby: CSteamID,
    pub m_ePlayerAcceptState: RequestPlayersForGameResultCallback_t_PlayerAcceptState_t,
    pub m_nPlayerIndex: int32,
    pub m_nTotalPlayersFound: int32,
    pub m_nTotalPlayersAcceptedGame: int32,
    pub m_nSuggestedTeamIndex: int32,
    pub m_ullUniqueGameID: uint64,
}
pub const RequestPlayersForGameResultCallback_t_k_iCallback:
    RequestPlayersForGameResultCallback_t__bindgen_ty_1 =
    RequestPlayersForGameResultCallback_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RequestPlayersForGameResultCallback_t__bindgen_ty_1 {
    k_iCallback = 5212,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RequestPlayersForGameResultCallback_t_PlayerAcceptState_t {
    k_EStateUnknown = 0,
    k_EStatePlayerAccepted = 1,
    k_EStatePlayerDeclined = 2,
}
#[test]
fn bindgen_test_layout_RequestPlayersForGameResultCallback_t() {
    assert_eq!(
        ::std::mem::size_of::<RequestPlayersForGameResultCallback_t>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(RequestPlayersForGameResultCallback_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RequestPlayersForGameResultCallback_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RequestPlayersForGameResultCallback_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RequestPlayersForGameResultCallback_t>())).m_eResult as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RequestPlayersForGameResultCallback_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RequestPlayersForGameResultCallback_t>())).m_ullSearchID
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RequestPlayersForGameResultCallback_t),
            "::",
            stringify!(m_ullSearchID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RequestPlayersForGameResultCallback_t>())).m_SteamIDPlayerFound
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RequestPlayersForGameResultCallback_t),
            "::",
            stringify!(m_SteamIDPlayerFound)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RequestPlayersForGameResultCallback_t>())).m_SteamIDLobby
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(RequestPlayersForGameResultCallback_t),
            "::",
            stringify!(m_SteamIDLobby)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RequestPlayersForGameResultCallback_t>())).m_ePlayerAcceptState
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(RequestPlayersForGameResultCallback_t),
            "::",
            stringify!(m_ePlayerAcceptState)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RequestPlayersForGameResultCallback_t>())).m_nPlayerIndex
                as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(RequestPlayersForGameResultCallback_t),
            "::",
            stringify!(m_nPlayerIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RequestPlayersForGameResultCallback_t>())).m_nTotalPlayersFound
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(RequestPlayersForGameResultCallback_t),
            "::",
            stringify!(m_nTotalPlayersFound)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RequestPlayersForGameResultCallback_t>()))
                .m_nTotalPlayersAcceptedGame as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(RequestPlayersForGameResultCallback_t),
            "::",
            stringify!(m_nTotalPlayersAcceptedGame)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RequestPlayersForGameResultCallback_t>())).m_nSuggestedTeamIndex
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(RequestPlayersForGameResultCallback_t),
            "::",
            stringify!(m_nSuggestedTeamIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RequestPlayersForGameResultCallback_t>())).m_ullUniqueGameID
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(RequestPlayersForGameResultCallback_t),
            "::",
            stringify!(m_ullUniqueGameID)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RequestPlayersForGameFinalResultCallback_t {
    pub m_eResult: EResult,
    pub m_ullSearchID: uint64,
    pub m_ullUniqueGameID: uint64,
}
pub const RequestPlayersForGameFinalResultCallback_t_k_iCallback:
    RequestPlayersForGameFinalResultCallback_t__bindgen_ty_1 =
    RequestPlayersForGameFinalResultCallback_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RequestPlayersForGameFinalResultCallback_t__bindgen_ty_1 {
    k_iCallback = 5213,
}
#[test]
fn bindgen_test_layout_RequestPlayersForGameFinalResultCallback_t() {
    assert_eq!(
        ::std::mem::size_of::<RequestPlayersForGameFinalResultCallback_t>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(RequestPlayersForGameFinalResultCallback_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RequestPlayersForGameFinalResultCallback_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RequestPlayersForGameFinalResultCallback_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RequestPlayersForGameFinalResultCallback_t>())).m_eResult
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RequestPlayersForGameFinalResultCallback_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RequestPlayersForGameFinalResultCallback_t>())).m_ullSearchID
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RequestPlayersForGameFinalResultCallback_t),
            "::",
            stringify!(m_ullSearchID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RequestPlayersForGameFinalResultCallback_t>())).m_ullUniqueGameID
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RequestPlayersForGameFinalResultCallback_t),
            "::",
            stringify!(m_ullUniqueGameID)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SubmitPlayerResultResultCallback_t {
    pub m_eResult: EResult,
    pub ullUniqueGameID: uint64,
    pub steamIDPlayer: CSteamID,
}
pub const SubmitPlayerResultResultCallback_t_k_iCallback:
    SubmitPlayerResultResultCallback_t__bindgen_ty_1 =
    SubmitPlayerResultResultCallback_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SubmitPlayerResultResultCallback_t__bindgen_ty_1 {
    k_iCallback = 5214,
}
#[test]
fn bindgen_test_layout_SubmitPlayerResultResultCallback_t() {
    assert_eq!(
        ::std::mem::size_of::<SubmitPlayerResultResultCallback_t>(),
        24usize,
        concat!("Size of: ", stringify!(SubmitPlayerResultResultCallback_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SubmitPlayerResultResultCallback_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(SubmitPlayerResultResultCallback_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SubmitPlayerResultResultCallback_t>())).m_eResult as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SubmitPlayerResultResultCallback_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SubmitPlayerResultResultCallback_t>())).ullUniqueGameID
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SubmitPlayerResultResultCallback_t),
            "::",
            stringify!(ullUniqueGameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SubmitPlayerResultResultCallback_t>())).steamIDPlayer as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SubmitPlayerResultResultCallback_t),
            "::",
            stringify!(steamIDPlayer)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct EndGameResultCallback_t {
    pub m_eResult: EResult,
    pub ullUniqueGameID: uint64,
}
pub const EndGameResultCallback_t_k_iCallback: EndGameResultCallback_t__bindgen_ty_1 =
    EndGameResultCallback_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EndGameResultCallback_t__bindgen_ty_1 {
    k_iCallback = 5215,
}
#[test]
fn bindgen_test_layout_EndGameResultCallback_t() {
    assert_eq!(
        ::std::mem::size_of::<EndGameResultCallback_t>(),
        16usize,
        concat!("Size of: ", stringify!(EndGameResultCallback_t))
    );
    assert_eq!(
        ::std::mem::align_of::<EndGameResultCallback_t>(),
        8usize,
        concat!("Alignment of ", stringify!(EndGameResultCallback_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<EndGameResultCallback_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(EndGameResultCallback_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<EndGameResultCallback_t>())).ullUniqueGameID as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(EndGameResultCallback_t),
            "::",
            stringify!(ullUniqueGameID)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct JoinPartyCallback_t {
    pub m_eResult: EResult,
    pub m_ulBeaconID: PartyBeaconID_t,
    pub m_SteamIDBeaconOwner: CSteamID,
    pub m_rgchConnectString: [::std::os::raw::c_char; 256usize],
}
pub const JoinPartyCallback_t_k_iCallback: JoinPartyCallback_t__bindgen_ty_1 =
    JoinPartyCallback_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum JoinPartyCallback_t__bindgen_ty_1 {
    k_iCallback = 5301,
}
#[test]
fn bindgen_test_layout_JoinPartyCallback_t() {
    assert_eq!(
        ::std::mem::size_of::<JoinPartyCallback_t>(),
        280usize,
        concat!("Size of: ", stringify!(JoinPartyCallback_t))
    );
    assert_eq!(
        ::std::mem::align_of::<JoinPartyCallback_t>(),
        8usize,
        concat!("Alignment of ", stringify!(JoinPartyCallback_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<JoinPartyCallback_t>())).m_eResult as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(JoinPartyCallback_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<JoinPartyCallback_t>())).m_ulBeaconID as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(JoinPartyCallback_t),
            "::",
            stringify!(m_ulBeaconID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<JoinPartyCallback_t>())).m_SteamIDBeaconOwner as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(JoinPartyCallback_t),
            "::",
            stringify!(m_SteamIDBeaconOwner)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<JoinPartyCallback_t>())).m_rgchConnectString as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(JoinPartyCallback_t),
            "::",
            stringify!(m_rgchConnectString)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateBeaconCallback_t {
    pub m_eResult: EResult,
    pub m_ulBeaconID: PartyBeaconID_t,
}
pub const CreateBeaconCallback_t_k_iCallback: CreateBeaconCallback_t__bindgen_ty_1 =
    CreateBeaconCallback_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum CreateBeaconCallback_t__bindgen_ty_1 {
    k_iCallback = 5302,
}
#[test]
fn bindgen_test_layout_CreateBeaconCallback_t() {
    assert_eq!(
        ::std::mem::size_of::<CreateBeaconCallback_t>(),
        16usize,
        concat!("Size of: ", stringify!(CreateBeaconCallback_t))
    );
    assert_eq!(
        ::std::mem::align_of::<CreateBeaconCallback_t>(),
        8usize,
        concat!("Alignment of ", stringify!(CreateBeaconCallback_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CreateBeaconCallback_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CreateBeaconCallback_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CreateBeaconCallback_t>())).m_ulBeaconID as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(CreateBeaconCallback_t),
            "::",
            stringify!(m_ulBeaconID)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ReservationNotificationCallback_t {
    pub m_ulBeaconID: PartyBeaconID_t,
    pub m_steamIDJoiner: CSteamID,
}
pub const ReservationNotificationCallback_t_k_iCallback:
    ReservationNotificationCallback_t__bindgen_ty_1 =
    ReservationNotificationCallback_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ReservationNotificationCallback_t__bindgen_ty_1 {
    k_iCallback = 5303,
}
#[test]
fn bindgen_test_layout_ReservationNotificationCallback_t() {
    assert_eq!(
        ::std::mem::size_of::<ReservationNotificationCallback_t>(),
        16usize,
        concat!("Size of: ", stringify!(ReservationNotificationCallback_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ReservationNotificationCallback_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(ReservationNotificationCallback_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ReservationNotificationCallback_t>())).m_ulBeaconID as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ReservationNotificationCallback_t),
            "::",
            stringify!(m_ulBeaconID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ReservationNotificationCallback_t>())).m_steamIDJoiner
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ReservationNotificationCallback_t),
            "::",
            stringify!(m_steamIDJoiner)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ChangeNumOpenSlotsCallback_t {
    pub m_eResult: EResult,
}
pub const ChangeNumOpenSlotsCallback_t_k_iCallback: ChangeNumOpenSlotsCallback_t__bindgen_ty_1 =
    ChangeNumOpenSlotsCallback_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ChangeNumOpenSlotsCallback_t__bindgen_ty_1 {
    k_iCallback = 5304,
}
#[test]
fn bindgen_test_layout_ChangeNumOpenSlotsCallback_t() {
    assert_eq!(
        ::std::mem::size_of::<ChangeNumOpenSlotsCallback_t>(),
        4usize,
        concat!("Size of: ", stringify!(ChangeNumOpenSlotsCallback_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ChangeNumOpenSlotsCallback_t>(),
        4usize,
        concat!("Alignment of ", stringify!(ChangeNumOpenSlotsCallback_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ChangeNumOpenSlotsCallback_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ChangeNumOpenSlotsCallback_t),
            "::",
            stringify!(m_eResult)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AvailableBeaconLocationsUpdated_t {
    pub _address: u8,
}
pub const AvailableBeaconLocationsUpdated_t_k_iCallback:
    AvailableBeaconLocationsUpdated_t__bindgen_ty_1 =
    AvailableBeaconLocationsUpdated_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AvailableBeaconLocationsUpdated_t__bindgen_ty_1 {
    k_iCallback = 5305,
}
#[test]
fn bindgen_test_layout_AvailableBeaconLocationsUpdated_t() {
    assert_eq!(
        ::std::mem::size_of::<AvailableBeaconLocationsUpdated_t>(),
        1usize,
        concat!("Size of: ", stringify!(AvailableBeaconLocationsUpdated_t))
    );
    assert_eq!(
        ::std::mem::align_of::<AvailableBeaconLocationsUpdated_t>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(AvailableBeaconLocationsUpdated_t)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ActiveBeaconsUpdated_t {
    pub _address: u8,
}
pub const ActiveBeaconsUpdated_t_k_iCallback: ActiveBeaconsUpdated_t__bindgen_ty_1 =
    ActiveBeaconsUpdated_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ActiveBeaconsUpdated_t__bindgen_ty_1 {
    k_iCallback = 5306,
}
#[test]
fn bindgen_test_layout_ActiveBeaconsUpdated_t() {
    assert_eq!(
        ::std::mem::size_of::<ActiveBeaconsUpdated_t>(),
        1usize,
        concat!("Size of: ", stringify!(ActiveBeaconsUpdated_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ActiveBeaconsUpdated_t>(),
        1usize,
        concat!("Alignment of ", stringify!(ActiveBeaconsUpdated_t))
    );
}
pub const k_unMaxCloudFileChunkSize: uint32 = 104857600;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamParamStringArray_t {
    pub m_ppStrings: *mut *const ::std::os::raw::c_char,
    pub m_nNumStrings: int32,
}
#[test]
fn bindgen_test_layout_SteamParamStringArray_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamParamStringArray_t>(),
        16usize,
        concat!("Size of: ", stringify!(SteamParamStringArray_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamParamStringArray_t>(),
        8usize,
        concat!("Alignment of ", stringify!(SteamParamStringArray_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamParamStringArray_t>())).m_ppStrings as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamParamStringArray_t),
            "::",
            stringify!(m_ppStrings)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamParamStringArray_t>())).m_nNumStrings as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamParamStringArray_t),
            "::",
            stringify!(m_nNumStrings)
        )
    );
}
pub type UGCHandle_t = uint64;
pub type PublishedFileUpdateHandle_t = uint64;
pub type PublishedFileId_t = uint64;
pub const k_PublishedFileIdInvalid: PublishedFileId_t = 0;
pub const k_UGCHandleInvalid: UGCHandle_t = 18446744073709551615;
pub const k_PublishedFileUpdateHandleInvalid: PublishedFileUpdateHandle_t = 18446744073709551615;
pub type UGCFileWriteStreamHandle_t = uint64;
pub const k_UGCFileStreamHandleInvalid: UGCFileWriteStreamHandle_t = 18446744073709551615;
pub const k_cchPublishedDocumentTitleMax: uint32 = 129;
pub const k_cchPublishedDocumentDescriptionMax: uint32 = 8000;
pub const k_cchPublishedDocumentChangeDescriptionMax: uint32 = 8000;
pub const k_unEnumeratePublishedFilesMaxResults: uint32 = 50;
pub const k_cchTagListMax: uint32 = 1025;
pub const k_cchFilenameMax: uint32 = 260;
pub const k_cchPublishedFileURLMax: uint32 = 256;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ERemoteStoragePlatform {
    k_ERemoteStoragePlatformNone = 0,
    k_ERemoteStoragePlatformWindows = 1,
    k_ERemoteStoragePlatformOSX = 2,
    k_ERemoteStoragePlatformPS3 = 4,
    k_ERemoteStoragePlatformLinux = 8,
    k_ERemoteStoragePlatformSwitch = 16,
    k_ERemoteStoragePlatformAndroid = 32,
    k_ERemoteStoragePlatformIOS = 64,
    k_ERemoteStoragePlatformAll = -1,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ERemoteStoragePublishedFileVisibility {
    k_ERemoteStoragePublishedFileVisibilityPublic = 0,
    k_ERemoteStoragePublishedFileVisibilityFriendsOnly = 1,
    k_ERemoteStoragePublishedFileVisibilityPrivate = 2,
    k_ERemoteStoragePublishedFileVisibilityUnlisted = 3,
}
impl EWorkshopFileType {
    pub const k_EWorkshopFileTypeCommunity: EWorkshopFileType =
        EWorkshopFileType::k_EWorkshopFileTypeFirst;
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EWorkshopFileType {
    k_EWorkshopFileTypeFirst = 0,
    k_EWorkshopFileTypeMicrotransaction = 1,
    k_EWorkshopFileTypeCollection = 2,
    k_EWorkshopFileTypeArt = 3,
    k_EWorkshopFileTypeVideo = 4,
    k_EWorkshopFileTypeScreenshot = 5,
    k_EWorkshopFileTypeGame = 6,
    k_EWorkshopFileTypeSoftware = 7,
    k_EWorkshopFileTypeConcept = 8,
    k_EWorkshopFileTypeWebGuide = 9,
    k_EWorkshopFileTypeIntegratedGuide = 10,
    k_EWorkshopFileTypeMerch = 11,
    k_EWorkshopFileTypeControllerBinding = 12,
    k_EWorkshopFileTypeSteamworksAccessInvite = 13,
    k_EWorkshopFileTypeSteamVideo = 14,
    k_EWorkshopFileTypeGameManagedItem = 15,
    k_EWorkshopFileTypeMax = 16,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EWorkshopVote {
    k_EWorkshopVoteUnvoted = 0,
    k_EWorkshopVoteFor = 1,
    k_EWorkshopVoteAgainst = 2,
    k_EWorkshopVoteLater = 3,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EWorkshopFileAction {
    k_EWorkshopFileActionPlayed = 0,
    k_EWorkshopFileActionCompleted = 1,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EWorkshopEnumerationType {
    k_EWorkshopEnumerationTypeRankedByVote = 0,
    k_EWorkshopEnumerationTypeRecent = 1,
    k_EWorkshopEnumerationTypeTrending = 2,
    k_EWorkshopEnumerationTypeFavoritesOfFriends = 3,
    k_EWorkshopEnumerationTypeVotedByFriends = 4,
    k_EWorkshopEnumerationTypeContentByFriends = 5,
    k_EWorkshopEnumerationTypeRecentFromFollowedUsers = 6,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EWorkshopVideoProvider {
    k_EWorkshopVideoProviderNone = 0,
    k_EWorkshopVideoProviderYoutube = 1,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EUGCReadAction {
    k_EUGCRead_ContinueReadingUntilFinished = 0,
    k_EUGCRead_ContinueReading = 1,
    k_EUGCRead_Close = 2,
}
#[repr(C)]
pub struct ISteamRemoteStorage__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamRemoteStorage {
    pub vtable_: *const ISteamRemoteStorage__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamRemoteStorage() {
    assert_eq!(
        ::std::mem::size_of::<ISteamRemoteStorage>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamRemoteStorage))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamRemoteStorage>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamRemoteStorage))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStorageAppSyncedClient_t {
    pub m_nAppID: AppId_t,
    pub m_eResult: EResult,
    pub m_unNumDownloads: ::std::os::raw::c_int,
}
pub const RemoteStorageAppSyncedClient_t_k_iCallback: RemoteStorageAppSyncedClient_t__bindgen_ty_1 =
    RemoteStorageAppSyncedClient_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageAppSyncedClient_t__bindgen_ty_1 {
    k_iCallback = 1301,
}
#[test]
fn bindgen_test_layout_RemoteStorageAppSyncedClient_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageAppSyncedClient_t>(),
        12usize,
        concat!("Size of: ", stringify!(RemoteStorageAppSyncedClient_t))
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageAppSyncedClient_t>(),
        4usize,
        concat!("Alignment of ", stringify!(RemoteStorageAppSyncedClient_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageAppSyncedClient_t>())).m_nAppID as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageAppSyncedClient_t),
            "::",
            stringify!(m_nAppID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageAppSyncedClient_t>())).m_eResult as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageAppSyncedClient_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageAppSyncedClient_t>())).m_unNumDownloads as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageAppSyncedClient_t),
            "::",
            stringify!(m_unNumDownloads)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStorageAppSyncedServer_t {
    pub m_nAppID: AppId_t,
    pub m_eResult: EResult,
    pub m_unNumUploads: ::std::os::raw::c_int,
}
pub const RemoteStorageAppSyncedServer_t_k_iCallback: RemoteStorageAppSyncedServer_t__bindgen_ty_1 =
    RemoteStorageAppSyncedServer_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageAppSyncedServer_t__bindgen_ty_1 {
    k_iCallback = 1302,
}
#[test]
fn bindgen_test_layout_RemoteStorageAppSyncedServer_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageAppSyncedServer_t>(),
        12usize,
        concat!("Size of: ", stringify!(RemoteStorageAppSyncedServer_t))
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageAppSyncedServer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(RemoteStorageAppSyncedServer_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageAppSyncedServer_t>())).m_nAppID as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageAppSyncedServer_t),
            "::",
            stringify!(m_nAppID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageAppSyncedServer_t>())).m_eResult as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageAppSyncedServer_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageAppSyncedServer_t>())).m_unNumUploads as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageAppSyncedServer_t),
            "::",
            stringify!(m_unNumUploads)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RemoteStorageAppSyncProgress_t {
    pub m_rgchCurrentFile: [::std::os::raw::c_char; 260usize],
    pub m_nAppID: AppId_t,
    pub m_uBytesTransferredThisChunk: uint32,
    pub m_dAppPercentComplete: f64,
    pub m_bUploading: bool,
}
pub const RemoteStorageAppSyncProgress_t_k_iCallback: RemoteStorageAppSyncProgress_t__bindgen_ty_1 =
    RemoteStorageAppSyncProgress_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageAppSyncProgress_t__bindgen_ty_1 {
    k_iCallback = 1303,
}
#[test]
fn bindgen_test_layout_RemoteStorageAppSyncProgress_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageAppSyncProgress_t>(),
        288usize,
        concat!("Size of: ", stringify!(RemoteStorageAppSyncProgress_t))
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageAppSyncProgress_t>(),
        8usize,
        concat!("Alignment of ", stringify!(RemoteStorageAppSyncProgress_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageAppSyncProgress_t>())).m_rgchCurrentFile as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageAppSyncProgress_t),
            "::",
            stringify!(m_rgchCurrentFile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageAppSyncProgress_t>())).m_nAppID as *const _ as usize
        },
        260usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageAppSyncProgress_t),
            "::",
            stringify!(m_nAppID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageAppSyncProgress_t>())).m_uBytesTransferredThisChunk
                as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageAppSyncProgress_t),
            "::",
            stringify!(m_uBytesTransferredThisChunk)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageAppSyncProgress_t>())).m_dAppPercentComplete
                as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageAppSyncProgress_t),
            "::",
            stringify!(m_dAppPercentComplete)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageAppSyncProgress_t>())).m_bUploading as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageAppSyncProgress_t),
            "::",
            stringify!(m_bUploading)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStorageAppSyncStatusCheck_t {
    pub m_nAppID: AppId_t,
    pub m_eResult: EResult,
}
pub const RemoteStorageAppSyncStatusCheck_t_k_iCallback:
    RemoteStorageAppSyncStatusCheck_t__bindgen_ty_1 =
    RemoteStorageAppSyncStatusCheck_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageAppSyncStatusCheck_t__bindgen_ty_1 {
    k_iCallback = 1305,
}
#[test]
fn bindgen_test_layout_RemoteStorageAppSyncStatusCheck_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageAppSyncStatusCheck_t>(),
        8usize,
        concat!("Size of: ", stringify!(RemoteStorageAppSyncStatusCheck_t))
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageAppSyncStatusCheck_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageAppSyncStatusCheck_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageAppSyncStatusCheck_t>())).m_nAppID as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageAppSyncStatusCheck_t),
            "::",
            stringify!(m_nAppID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageAppSyncStatusCheck_t>())).m_eResult as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageAppSyncStatusCheck_t),
            "::",
            stringify!(m_eResult)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RemoteStorageFileShareResult_t {
    pub m_eResult: EResult,
    pub m_hFile: UGCHandle_t,
    pub m_rgchFilename: [::std::os::raw::c_char; 260usize],
}
pub const RemoteStorageFileShareResult_t_k_iCallback: RemoteStorageFileShareResult_t__bindgen_ty_1 =
    RemoteStorageFileShareResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageFileShareResult_t__bindgen_ty_1 {
    k_iCallback = 1307,
}
#[test]
fn bindgen_test_layout_RemoteStorageFileShareResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageFileShareResult_t>(),
        280usize,
        concat!("Size of: ", stringify!(RemoteStorageFileShareResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageFileShareResult_t>(),
        8usize,
        concat!("Alignment of ", stringify!(RemoteStorageFileShareResult_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageFileShareResult_t>())).m_eResult as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageFileShareResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageFileShareResult_t>())).m_hFile as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageFileShareResult_t),
            "::",
            stringify!(m_hFile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageFileShareResult_t>())).m_rgchFilename as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageFileShareResult_t),
            "::",
            stringify!(m_rgchFilename)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStoragePublishFileResult_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_bUserNeedsToAcceptWorkshopLegalAgreement: bool,
}
pub const RemoteStoragePublishFileResult_t_k_iCallback:
    RemoteStoragePublishFileResult_t__bindgen_ty_1 =
    RemoteStoragePublishFileResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStoragePublishFileResult_t__bindgen_ty_1 {
    k_iCallback = 1309,
}
#[test]
fn bindgen_test_layout_RemoteStoragePublishFileResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStoragePublishFileResult_t>(),
        24usize,
        concat!("Size of: ", stringify!(RemoteStoragePublishFileResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStoragePublishFileResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStoragePublishFileResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStoragePublishFileResult_t>())).m_eResult as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStoragePublishFileResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStoragePublishFileResult_t>())).m_nPublishedFileId
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStoragePublishFileResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStoragePublishFileResult_t>()))
                .m_bUserNeedsToAcceptWorkshopLegalAgreement as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStoragePublishFileResult_t),
            "::",
            stringify!(m_bUserNeedsToAcceptWorkshopLegalAgreement)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStorageDeletePublishedFileResult_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
}
pub const RemoteStorageDeletePublishedFileResult_t_k_iCallback:
    RemoteStorageDeletePublishedFileResult_t__bindgen_ty_1 =
    RemoteStorageDeletePublishedFileResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageDeletePublishedFileResult_t__bindgen_ty_1 {
    k_iCallback = 1311,
}
#[test]
fn bindgen_test_layout_RemoteStorageDeletePublishedFileResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageDeletePublishedFileResult_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStorageDeletePublishedFileResult_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageDeletePublishedFileResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageDeletePublishedFileResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageDeletePublishedFileResult_t>())).m_eResult
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageDeletePublishedFileResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageDeletePublishedFileResult_t>())).m_nPublishedFileId
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageDeletePublishedFileResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RemoteStorageEnumerateUserPublishedFilesResult_t {
    pub m_eResult: EResult,
    pub m_nResultsReturned: int32,
    pub m_nTotalResultCount: int32,
    pub m_rgPublishedFileId: [PublishedFileId_t; 50usize],
}
pub const RemoteStorageEnumerateUserPublishedFilesResult_t_k_iCallback:
    RemoteStorageEnumerateUserPublishedFilesResult_t__bindgen_ty_1 =
    RemoteStorageEnumerateUserPublishedFilesResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageEnumerateUserPublishedFilesResult_t__bindgen_ty_1 {
    k_iCallback = 1312,
}
#[test]
fn bindgen_test_layout_RemoteStorageEnumerateUserPublishedFilesResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageEnumerateUserPublishedFilesResult_t>(),
        416usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStorageEnumerateUserPublishedFilesResult_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageEnumerateUserPublishedFilesResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageEnumerateUserPublishedFilesResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateUserPublishedFilesResult_t>())).m_eResult
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateUserPublishedFilesResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateUserPublishedFilesResult_t>()))
                .m_nResultsReturned as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateUserPublishedFilesResult_t),
            "::",
            stringify!(m_nResultsReturned)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateUserPublishedFilesResult_t>()))
                .m_nTotalResultCount as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateUserPublishedFilesResult_t),
            "::",
            stringify!(m_nTotalResultCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateUserPublishedFilesResult_t>()))
                .m_rgPublishedFileId as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateUserPublishedFilesResult_t),
            "::",
            stringify!(m_rgPublishedFileId)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStorageSubscribePublishedFileResult_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
}
pub const RemoteStorageSubscribePublishedFileResult_t_k_iCallback:
    RemoteStorageSubscribePublishedFileResult_t__bindgen_ty_1 =
    RemoteStorageSubscribePublishedFileResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageSubscribePublishedFileResult_t__bindgen_ty_1 {
    k_iCallback = 1313,
}
#[test]
fn bindgen_test_layout_RemoteStorageSubscribePublishedFileResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageSubscribePublishedFileResult_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStorageSubscribePublishedFileResult_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageSubscribePublishedFileResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageSubscribePublishedFileResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageSubscribePublishedFileResult_t>())).m_eResult
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageSubscribePublishedFileResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageSubscribePublishedFileResult_t>()))
                .m_nPublishedFileId as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageSubscribePublishedFileResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RemoteStorageEnumerateUserSubscribedFilesResult_t {
    pub m_eResult: EResult,
    pub m_nResultsReturned: int32,
    pub m_nTotalResultCount: int32,
    pub m_rgPublishedFileId: [PublishedFileId_t; 50usize],
    pub m_rgRTimeSubscribed: [uint32; 50usize],
}
pub const RemoteStorageEnumerateUserSubscribedFilesResult_t_k_iCallback:
    RemoteStorageEnumerateUserSubscribedFilesResult_t__bindgen_ty_1 =
    RemoteStorageEnumerateUserSubscribedFilesResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageEnumerateUserSubscribedFilesResult_t__bindgen_ty_1 {
    k_iCallback = 1314,
}
#[test]
fn bindgen_test_layout_RemoteStorageEnumerateUserSubscribedFilesResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageEnumerateUserSubscribedFilesResult_t>(),
        616usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStorageEnumerateUserSubscribedFilesResult_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageEnumerateUserSubscribedFilesResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageEnumerateUserSubscribedFilesResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateUserSubscribedFilesResult_t>())).m_eResult
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateUserSubscribedFilesResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateUserSubscribedFilesResult_t>()))
                .m_nResultsReturned as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateUserSubscribedFilesResult_t),
            "::",
            stringify!(m_nResultsReturned)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateUserSubscribedFilesResult_t>()))
                .m_nTotalResultCount as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateUserSubscribedFilesResult_t),
            "::",
            stringify!(m_nTotalResultCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateUserSubscribedFilesResult_t>()))
                .m_rgPublishedFileId as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateUserSubscribedFilesResult_t),
            "::",
            stringify!(m_rgPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateUserSubscribedFilesResult_t>()))
                .m_rgRTimeSubscribed as *const _ as usize
        },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateUserSubscribedFilesResult_t),
            "::",
            stringify!(m_rgRTimeSubscribed)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStorageUnsubscribePublishedFileResult_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
}
pub const RemoteStorageUnsubscribePublishedFileResult_t_k_iCallback:
    RemoteStorageUnsubscribePublishedFileResult_t__bindgen_ty_1 =
    RemoteStorageUnsubscribePublishedFileResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageUnsubscribePublishedFileResult_t__bindgen_ty_1 {
    k_iCallback = 1315,
}
#[test]
fn bindgen_test_layout_RemoteStorageUnsubscribePublishedFileResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageUnsubscribePublishedFileResult_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStorageUnsubscribePublishedFileResult_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageUnsubscribePublishedFileResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageUnsubscribePublishedFileResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageUnsubscribePublishedFileResult_t>())).m_eResult
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageUnsubscribePublishedFileResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageUnsubscribePublishedFileResult_t>()))
                .m_nPublishedFileId as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageUnsubscribePublishedFileResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStorageUpdatePublishedFileResult_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_bUserNeedsToAcceptWorkshopLegalAgreement: bool,
}
pub const RemoteStorageUpdatePublishedFileResult_t_k_iCallback:
    RemoteStorageUpdatePublishedFileResult_t__bindgen_ty_1 =
    RemoteStorageUpdatePublishedFileResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageUpdatePublishedFileResult_t__bindgen_ty_1 {
    k_iCallback = 1316,
}
#[test]
fn bindgen_test_layout_RemoteStorageUpdatePublishedFileResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageUpdatePublishedFileResult_t>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStorageUpdatePublishedFileResult_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageUpdatePublishedFileResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageUpdatePublishedFileResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageUpdatePublishedFileResult_t>())).m_eResult
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageUpdatePublishedFileResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageUpdatePublishedFileResult_t>())).m_nPublishedFileId
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageUpdatePublishedFileResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageUpdatePublishedFileResult_t>()))
                .m_bUserNeedsToAcceptWorkshopLegalAgreement as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageUpdatePublishedFileResult_t),
            "::",
            stringify!(m_bUserNeedsToAcceptWorkshopLegalAgreement)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RemoteStorageDownloadUGCResult_t {
    pub m_eResult: EResult,
    pub m_hFile: UGCHandle_t,
    pub m_nAppID: AppId_t,
    pub m_nSizeInBytes: int32,
    pub m_pchFileName: [::std::os::raw::c_char; 260usize],
    pub m_ulSteamIDOwner: uint64,
}
pub const RemoteStorageDownloadUGCResult_t_k_iCallback:
    RemoteStorageDownloadUGCResult_t__bindgen_ty_1 =
    RemoteStorageDownloadUGCResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageDownloadUGCResult_t__bindgen_ty_1 {
    k_iCallback = 1317,
}
#[test]
fn bindgen_test_layout_RemoteStorageDownloadUGCResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageDownloadUGCResult_t>(),
        296usize,
        concat!("Size of: ", stringify!(RemoteStorageDownloadUGCResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageDownloadUGCResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageDownloadUGCResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageDownloadUGCResult_t>())).m_eResult as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageDownloadUGCResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageDownloadUGCResult_t>())).m_hFile as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageDownloadUGCResult_t),
            "::",
            stringify!(m_hFile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageDownloadUGCResult_t>())).m_nAppID as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageDownloadUGCResult_t),
            "::",
            stringify!(m_nAppID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageDownloadUGCResult_t>())).m_nSizeInBytes as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageDownloadUGCResult_t),
            "::",
            stringify!(m_nSizeInBytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageDownloadUGCResult_t>())).m_pchFileName as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageDownloadUGCResult_t),
            "::",
            stringify!(m_pchFileName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageDownloadUGCResult_t>())).m_ulSteamIDOwner
                as *const _ as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageDownloadUGCResult_t),
            "::",
            stringify!(m_ulSteamIDOwner)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RemoteStorageGetPublishedFileDetailsResult_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_nCreatorAppID: AppId_t,
    pub m_nConsumerAppID: AppId_t,
    pub m_rgchTitle: [::std::os::raw::c_char; 129usize],
    pub m_rgchDescription: [::std::os::raw::c_char; 8000usize],
    pub m_hFile: UGCHandle_t,
    pub m_hPreviewFile: UGCHandle_t,
    pub m_ulSteamIDOwner: uint64,
    pub m_rtimeCreated: uint32,
    pub m_rtimeUpdated: uint32,
    pub m_eVisibility: ERemoteStoragePublishedFileVisibility,
    pub m_bBanned: bool,
    pub m_rgchTags: [::std::os::raw::c_char; 1025usize],
    pub m_bTagsTruncated: bool,
    pub m_pchFileName: [::std::os::raw::c_char; 260usize],
    pub m_nFileSize: int32,
    pub m_nPreviewFileSize: int32,
    pub m_rgchURL: [::std::os::raw::c_char; 256usize],
    pub m_eFileType: EWorkshopFileType,
    pub m_bAcceptedForUse: bool,
}
pub const RemoteStorageGetPublishedFileDetailsResult_t_k_iCallback:
    RemoteStorageGetPublishedFileDetailsResult_t__bindgen_ty_1 =
    RemoteStorageGetPublishedFileDetailsResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageGetPublishedFileDetailsResult_t__bindgen_ty_1 {
    k_iCallback = 1318,
}
#[test]
fn bindgen_test_layout_RemoteStorageGetPublishedFileDetailsResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageGetPublishedFileDetailsResult_t>(),
        9760usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageGetPublishedFileDetailsResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>())).m_eResult
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>()))
                .m_nPublishedFileId as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>())).m_nCreatorAppID
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_nCreatorAppID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>()))
                .m_nConsumerAppID as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_nConsumerAppID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>())).m_rgchTitle
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_rgchTitle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>()))
                .m_rgchDescription as *const _ as usize
        },
        153usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_rgchDescription)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>())).m_hFile
                as *const _ as usize
        },
        8160usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_hFile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>())).m_hPreviewFile
                as *const _ as usize
        },
        8168usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_hPreviewFile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>()))
                .m_ulSteamIDOwner as *const _ as usize
        },
        8176usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_ulSteamIDOwner)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>())).m_rtimeCreated
                as *const _ as usize
        },
        8184usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_rtimeCreated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>())).m_rtimeUpdated
                as *const _ as usize
        },
        8188usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_rtimeUpdated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>())).m_eVisibility
                as *const _ as usize
        },
        8192usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_eVisibility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>())).m_bBanned
                as *const _ as usize
        },
        8196usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_bBanned)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>())).m_rgchTags
                as *const _ as usize
        },
        8197usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_rgchTags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>()))
                .m_bTagsTruncated as *const _ as usize
        },
        9222usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_bTagsTruncated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>())).m_pchFileName
                as *const _ as usize
        },
        9223usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_pchFileName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>())).m_nFileSize
                as *const _ as usize
        },
        9484usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_nFileSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>()))
                .m_nPreviewFileSize as *const _ as usize
        },
        9488usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_nPreviewFileSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>())).m_rgchURL
                as *const _ as usize
        },
        9492usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_rgchURL)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>())).m_eFileType
                as *const _ as usize
        },
        9748usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_eFileType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedFileDetailsResult_t>()))
                .m_bAcceptedForUse as *const _ as usize
        },
        9752usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedFileDetailsResult_t),
            "::",
            stringify!(m_bAcceptedForUse)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RemoteStorageEnumerateWorkshopFilesResult_t {
    pub m_eResult: EResult,
    pub m_nResultsReturned: int32,
    pub m_nTotalResultCount: int32,
    pub m_rgPublishedFileId: [PublishedFileId_t; 50usize],
    pub m_rgScore: [f32; 50usize],
    pub m_nAppId: AppId_t,
    pub m_unStartIndex: uint32,
}
pub const RemoteStorageEnumerateWorkshopFilesResult_t_k_iCallback:
    RemoteStorageEnumerateWorkshopFilesResult_t__bindgen_ty_1 =
    RemoteStorageEnumerateWorkshopFilesResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageEnumerateWorkshopFilesResult_t__bindgen_ty_1 {
    k_iCallback = 1319,
}
#[test]
fn bindgen_test_layout_RemoteStorageEnumerateWorkshopFilesResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageEnumerateWorkshopFilesResult_t>(),
        624usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStorageEnumerateWorkshopFilesResult_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageEnumerateWorkshopFilesResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageEnumerateWorkshopFilesResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateWorkshopFilesResult_t>())).m_eResult
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateWorkshopFilesResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateWorkshopFilesResult_t>()))
                .m_nResultsReturned as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateWorkshopFilesResult_t),
            "::",
            stringify!(m_nResultsReturned)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateWorkshopFilesResult_t>()))
                .m_nTotalResultCount as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateWorkshopFilesResult_t),
            "::",
            stringify!(m_nTotalResultCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateWorkshopFilesResult_t>()))
                .m_rgPublishedFileId as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateWorkshopFilesResult_t),
            "::",
            stringify!(m_rgPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateWorkshopFilesResult_t>())).m_rgScore
                as *const _ as usize
        },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateWorkshopFilesResult_t),
            "::",
            stringify!(m_rgScore)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateWorkshopFilesResult_t>())).m_nAppId
                as *const _ as usize
        },
        616usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateWorkshopFilesResult_t),
            "::",
            stringify!(m_nAppId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateWorkshopFilesResult_t>())).m_unStartIndex
                as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateWorkshopFilesResult_t),
            "::",
            stringify!(m_unStartIndex)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStorageGetPublishedItemVoteDetailsResult_t {
    pub m_eResult: EResult,
    pub m_unPublishedFileId: PublishedFileId_t,
    pub m_nVotesFor: int32,
    pub m_nVotesAgainst: int32,
    pub m_nReports: int32,
    pub m_fScore: f32,
}
pub const RemoteStorageGetPublishedItemVoteDetailsResult_t_k_iCallback:
    RemoteStorageGetPublishedItemVoteDetailsResult_t__bindgen_ty_1 =
    RemoteStorageGetPublishedItemVoteDetailsResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageGetPublishedItemVoteDetailsResult_t__bindgen_ty_1 {
    k_iCallback = 1320,
}
#[test]
fn bindgen_test_layout_RemoteStorageGetPublishedItemVoteDetailsResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageGetPublishedItemVoteDetailsResult_t>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStorageGetPublishedItemVoteDetailsResult_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageGetPublishedItemVoteDetailsResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageGetPublishedItemVoteDetailsResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedItemVoteDetailsResult_t>())).m_eResult
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedItemVoteDetailsResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedItemVoteDetailsResult_t>()))
                .m_unPublishedFileId as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedItemVoteDetailsResult_t),
            "::",
            stringify!(m_unPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedItemVoteDetailsResult_t>())).m_nVotesFor
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedItemVoteDetailsResult_t),
            "::",
            stringify!(m_nVotesFor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedItemVoteDetailsResult_t>()))
                .m_nVotesAgainst as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedItemVoteDetailsResult_t),
            "::",
            stringify!(m_nVotesAgainst)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedItemVoteDetailsResult_t>())).m_nReports
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedItemVoteDetailsResult_t),
            "::",
            stringify!(m_nReports)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageGetPublishedItemVoteDetailsResult_t>())).m_fScore
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageGetPublishedItemVoteDetailsResult_t),
            "::",
            stringify!(m_fScore)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStoragePublishedFileSubscribed_t {
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_nAppID: AppId_t,
}
pub const RemoteStoragePublishedFileSubscribed_t_k_iCallback:
    RemoteStoragePublishedFileSubscribed_t__bindgen_ty_1 =
    RemoteStoragePublishedFileSubscribed_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStoragePublishedFileSubscribed_t__bindgen_ty_1 {
    k_iCallback = 1321,
}
#[test]
fn bindgen_test_layout_RemoteStoragePublishedFileSubscribed_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStoragePublishedFileSubscribed_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStoragePublishedFileSubscribed_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStoragePublishedFileSubscribed_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStoragePublishedFileSubscribed_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStoragePublishedFileSubscribed_t>())).m_nPublishedFileId
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStoragePublishedFileSubscribed_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStoragePublishedFileSubscribed_t>())).m_nAppID as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStoragePublishedFileSubscribed_t),
            "::",
            stringify!(m_nAppID)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStoragePublishedFileUnsubscribed_t {
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_nAppID: AppId_t,
}
pub const RemoteStoragePublishedFileUnsubscribed_t_k_iCallback:
    RemoteStoragePublishedFileUnsubscribed_t__bindgen_ty_1 =
    RemoteStoragePublishedFileUnsubscribed_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStoragePublishedFileUnsubscribed_t__bindgen_ty_1 {
    k_iCallback = 1322,
}
#[test]
fn bindgen_test_layout_RemoteStoragePublishedFileUnsubscribed_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStoragePublishedFileUnsubscribed_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStoragePublishedFileUnsubscribed_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStoragePublishedFileUnsubscribed_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStoragePublishedFileUnsubscribed_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStoragePublishedFileUnsubscribed_t>())).m_nPublishedFileId
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStoragePublishedFileUnsubscribed_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStoragePublishedFileUnsubscribed_t>())).m_nAppID
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStoragePublishedFileUnsubscribed_t),
            "::",
            stringify!(m_nAppID)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStoragePublishedFileDeleted_t {
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_nAppID: AppId_t,
}
pub const RemoteStoragePublishedFileDeleted_t_k_iCallback:
    RemoteStoragePublishedFileDeleted_t__bindgen_ty_1 =
    RemoteStoragePublishedFileDeleted_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStoragePublishedFileDeleted_t__bindgen_ty_1 {
    k_iCallback = 1323,
}
#[test]
fn bindgen_test_layout_RemoteStoragePublishedFileDeleted_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStoragePublishedFileDeleted_t>(),
        16usize,
        concat!("Size of: ", stringify!(RemoteStoragePublishedFileDeleted_t))
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStoragePublishedFileDeleted_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStoragePublishedFileDeleted_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStoragePublishedFileDeleted_t>())).m_nPublishedFileId
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStoragePublishedFileDeleted_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStoragePublishedFileDeleted_t>())).m_nAppID as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStoragePublishedFileDeleted_t),
            "::",
            stringify!(m_nAppID)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStorageUpdateUserPublishedItemVoteResult_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
}
pub const RemoteStorageUpdateUserPublishedItemVoteResult_t_k_iCallback:
    RemoteStorageUpdateUserPublishedItemVoteResult_t__bindgen_ty_1 =
    RemoteStorageUpdateUserPublishedItemVoteResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageUpdateUserPublishedItemVoteResult_t__bindgen_ty_1 {
    k_iCallback = 1324,
}
#[test]
fn bindgen_test_layout_RemoteStorageUpdateUserPublishedItemVoteResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageUpdateUserPublishedItemVoteResult_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStorageUpdateUserPublishedItemVoteResult_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageUpdateUserPublishedItemVoteResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageUpdateUserPublishedItemVoteResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageUpdateUserPublishedItemVoteResult_t>())).m_eResult
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageUpdateUserPublishedItemVoteResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageUpdateUserPublishedItemVoteResult_t>()))
                .m_nPublishedFileId as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageUpdateUserPublishedItemVoteResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStorageUserVoteDetails_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_eVote: EWorkshopVote,
}
pub const RemoteStorageUserVoteDetails_t_k_iCallback: RemoteStorageUserVoteDetails_t__bindgen_ty_1 =
    RemoteStorageUserVoteDetails_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageUserVoteDetails_t__bindgen_ty_1 {
    k_iCallback = 1325,
}
#[test]
fn bindgen_test_layout_RemoteStorageUserVoteDetails_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageUserVoteDetails_t>(),
        24usize,
        concat!("Size of: ", stringify!(RemoteStorageUserVoteDetails_t))
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageUserVoteDetails_t>(),
        8usize,
        concat!("Alignment of ", stringify!(RemoteStorageUserVoteDetails_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageUserVoteDetails_t>())).m_eResult as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageUserVoteDetails_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageUserVoteDetails_t>())).m_nPublishedFileId
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageUserVoteDetails_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageUserVoteDetails_t>())).m_eVote as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageUserVoteDetails_t),
            "::",
            stringify!(m_eVote)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RemoteStorageEnumerateUserSharedWorkshopFilesResult_t {
    pub m_eResult: EResult,
    pub m_nResultsReturned: int32,
    pub m_nTotalResultCount: int32,
    pub m_rgPublishedFileId: [PublishedFileId_t; 50usize],
}
pub const RemoteStorageEnumerateUserSharedWorkshopFilesResult_t_k_iCallback:
    RemoteStorageEnumerateUserSharedWorkshopFilesResult_t__bindgen_ty_1 =
    RemoteStorageEnumerateUserSharedWorkshopFilesResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageEnumerateUserSharedWorkshopFilesResult_t__bindgen_ty_1 {
    k_iCallback = 1326,
}
#[test]
fn bindgen_test_layout_RemoteStorageEnumerateUserSharedWorkshopFilesResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageEnumerateUserSharedWorkshopFilesResult_t>(),
        416usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStorageEnumerateUserSharedWorkshopFilesResult_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageEnumerateUserSharedWorkshopFilesResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageEnumerateUserSharedWorkshopFilesResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateUserSharedWorkshopFilesResult_t>()))
                .m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateUserSharedWorkshopFilesResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateUserSharedWorkshopFilesResult_t>()))
                .m_nResultsReturned as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateUserSharedWorkshopFilesResult_t),
            "::",
            stringify!(m_nResultsReturned)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateUserSharedWorkshopFilesResult_t>()))
                .m_nTotalResultCount as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateUserSharedWorkshopFilesResult_t),
            "::",
            stringify!(m_nTotalResultCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumerateUserSharedWorkshopFilesResult_t>()))
                .m_rgPublishedFileId as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumerateUserSharedWorkshopFilesResult_t),
            "::",
            stringify!(m_rgPublishedFileId)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStorageSetUserPublishedFileActionResult_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_eAction: EWorkshopFileAction,
}
pub const RemoteStorageSetUserPublishedFileActionResult_t_k_iCallback:
    RemoteStorageSetUserPublishedFileActionResult_t__bindgen_ty_1 =
    RemoteStorageSetUserPublishedFileActionResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageSetUserPublishedFileActionResult_t__bindgen_ty_1 {
    k_iCallback = 1327,
}
#[test]
fn bindgen_test_layout_RemoteStorageSetUserPublishedFileActionResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageSetUserPublishedFileActionResult_t>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStorageSetUserPublishedFileActionResult_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageSetUserPublishedFileActionResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageSetUserPublishedFileActionResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageSetUserPublishedFileActionResult_t>())).m_eResult
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageSetUserPublishedFileActionResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageSetUserPublishedFileActionResult_t>()))
                .m_nPublishedFileId as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageSetUserPublishedFileActionResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageSetUserPublishedFileActionResult_t>())).m_eAction
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageSetUserPublishedFileActionResult_t),
            "::",
            stringify!(m_eAction)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct RemoteStorageEnumeratePublishedFilesByUserActionResult_t {
    pub m_eResult: EResult,
    pub m_eAction: EWorkshopFileAction,
    pub m_nResultsReturned: int32,
    pub m_nTotalResultCount: int32,
    pub m_rgPublishedFileId: [PublishedFileId_t; 50usize],
    pub m_rgRTimeUpdated: [uint32; 50usize],
}
pub const RemoteStorageEnumeratePublishedFilesByUserActionResult_t_k_iCallback:
    RemoteStorageEnumeratePublishedFilesByUserActionResult_t__bindgen_ty_1 =
    RemoteStorageEnumeratePublishedFilesByUserActionResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageEnumeratePublishedFilesByUserActionResult_t__bindgen_ty_1 {
    k_iCallback = 1328,
}
#[test]
fn bindgen_test_layout_RemoteStorageEnumeratePublishedFilesByUserActionResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageEnumeratePublishedFilesByUserActionResult_t>(),
        616usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStorageEnumeratePublishedFilesByUserActionResult_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageEnumeratePublishedFilesByUserActionResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageEnumeratePublishedFilesByUserActionResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumeratePublishedFilesByUserActionResult_t>()))
                .m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumeratePublishedFilesByUserActionResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumeratePublishedFilesByUserActionResult_t>()))
                .m_eAction as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumeratePublishedFilesByUserActionResult_t),
            "::",
            stringify!(m_eAction)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumeratePublishedFilesByUserActionResult_t>()))
                .m_nResultsReturned as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumeratePublishedFilesByUserActionResult_t),
            "::",
            stringify!(m_nResultsReturned)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumeratePublishedFilesByUserActionResult_t>()))
                .m_nTotalResultCount as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumeratePublishedFilesByUserActionResult_t),
            "::",
            stringify!(m_nTotalResultCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumeratePublishedFilesByUserActionResult_t>()))
                .m_rgPublishedFileId as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumeratePublishedFilesByUserActionResult_t),
            "::",
            stringify!(m_rgPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageEnumeratePublishedFilesByUserActionResult_t>()))
                .m_rgRTimeUpdated as *const _ as usize
        },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageEnumeratePublishedFilesByUserActionResult_t),
            "::",
            stringify!(m_rgRTimeUpdated)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStoragePublishFileProgress_t {
    pub m_dPercentFile: f64,
    pub m_bPreview: bool,
}
pub const RemoteStoragePublishFileProgress_t_k_iCallback:
    RemoteStoragePublishFileProgress_t__bindgen_ty_1 =
    RemoteStoragePublishFileProgress_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStoragePublishFileProgress_t__bindgen_ty_1 {
    k_iCallback = 1329,
}
#[test]
fn bindgen_test_layout_RemoteStoragePublishFileProgress_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStoragePublishFileProgress_t>(),
        16usize,
        concat!("Size of: ", stringify!(RemoteStoragePublishFileProgress_t))
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStoragePublishFileProgress_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStoragePublishFileProgress_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStoragePublishFileProgress_t>())).m_dPercentFile
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStoragePublishFileProgress_t),
            "::",
            stringify!(m_dPercentFile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStoragePublishFileProgress_t>())).m_bPreview as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStoragePublishFileProgress_t),
            "::",
            stringify!(m_bPreview)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStoragePublishedFileUpdated_t {
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_nAppID: AppId_t,
    pub m_ulUnused: uint64,
}
pub const RemoteStoragePublishedFileUpdated_t_k_iCallback:
    RemoteStoragePublishedFileUpdated_t__bindgen_ty_1 =
    RemoteStoragePublishedFileUpdated_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStoragePublishedFileUpdated_t__bindgen_ty_1 {
    k_iCallback = 1330,
}
#[test]
fn bindgen_test_layout_RemoteStoragePublishedFileUpdated_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStoragePublishedFileUpdated_t>(),
        24usize,
        concat!("Size of: ", stringify!(RemoteStoragePublishedFileUpdated_t))
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStoragePublishedFileUpdated_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStoragePublishedFileUpdated_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStoragePublishedFileUpdated_t>())).m_nPublishedFileId
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStoragePublishedFileUpdated_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStoragePublishedFileUpdated_t>())).m_nAppID as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStoragePublishedFileUpdated_t),
            "::",
            stringify!(m_nAppID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStoragePublishedFileUpdated_t>())).m_ulUnused as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStoragePublishedFileUpdated_t),
            "::",
            stringify!(m_ulUnused)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStorageFileWriteAsyncComplete_t {
    pub m_eResult: EResult,
}
pub const RemoteStorageFileWriteAsyncComplete_t_k_iCallback:
    RemoteStorageFileWriteAsyncComplete_t__bindgen_ty_1 =
    RemoteStorageFileWriteAsyncComplete_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageFileWriteAsyncComplete_t__bindgen_ty_1 {
    k_iCallback = 1331,
}
#[test]
fn bindgen_test_layout_RemoteStorageFileWriteAsyncComplete_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageFileWriteAsyncComplete_t>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStorageFileWriteAsyncComplete_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageFileWriteAsyncComplete_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageFileWriteAsyncComplete_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageFileWriteAsyncComplete_t>())).m_eResult as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageFileWriteAsyncComplete_t),
            "::",
            stringify!(m_eResult)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoteStorageFileReadAsyncComplete_t {
    pub m_hFileReadAsync: SteamAPICall_t,
    pub m_eResult: EResult,
    pub m_nOffset: uint32,
    pub m_cubRead: uint32,
}
pub const RemoteStorageFileReadAsyncComplete_t_k_iCallback:
    RemoteStorageFileReadAsyncComplete_t__bindgen_ty_1 =
    RemoteStorageFileReadAsyncComplete_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoteStorageFileReadAsyncComplete_t__bindgen_ty_1 {
    k_iCallback = 1332,
}
#[test]
fn bindgen_test_layout_RemoteStorageFileReadAsyncComplete_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoteStorageFileReadAsyncComplete_t>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(RemoteStorageFileReadAsyncComplete_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<RemoteStorageFileReadAsyncComplete_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(RemoteStorageFileReadAsyncComplete_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageFileReadAsyncComplete_t>())).m_hFileReadAsync
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageFileReadAsyncComplete_t),
            "::",
            stringify!(m_hFileReadAsync)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageFileReadAsyncComplete_t>())).m_eResult as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageFileReadAsyncComplete_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageFileReadAsyncComplete_t>())).m_nOffset as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageFileReadAsyncComplete_t),
            "::",
            stringify!(m_nOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoteStorageFileReadAsyncComplete_t>())).m_cubRead as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoteStorageFileReadAsyncComplete_t),
            "::",
            stringify!(m_cubRead)
        )
    );
}
pub const k_cchStatNameMax: _bindgen_ty_67 = _bindgen_ty_67::k_cchStatNameMax;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_67 {
    k_cchStatNameMax = 128,
}
pub const k_cchLeaderboardNameMax: _bindgen_ty_68 = _bindgen_ty_68::k_cchLeaderboardNameMax;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_68 {
    k_cchLeaderboardNameMax = 128,
}
pub const k_cLeaderboardDetailsMax: _bindgen_ty_69 = _bindgen_ty_69::k_cLeaderboardDetailsMax;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _bindgen_ty_69 {
    k_cLeaderboardDetailsMax = 64,
}
pub type SteamLeaderboard_t = uint64;
pub type SteamLeaderboardEntries_t = uint64;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ELeaderboardDataRequest {
    k_ELeaderboardDataRequestGlobal = 0,
    k_ELeaderboardDataRequestGlobalAroundUser = 1,
    k_ELeaderboardDataRequestFriends = 2,
    k_ELeaderboardDataRequestUsers = 3,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ELeaderboardSortMethod {
    k_ELeaderboardSortMethodNone = 0,
    k_ELeaderboardSortMethodAscending = 1,
    k_ELeaderboardSortMethodDescending = 2,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ELeaderboardDisplayType {
    k_ELeaderboardDisplayTypeNone = 0,
    k_ELeaderboardDisplayTypeNumeric = 1,
    k_ELeaderboardDisplayTypeTimeSeconds = 2,
    k_ELeaderboardDisplayTypeTimeMilliSeconds = 3,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ELeaderboardUploadScoreMethod {
    k_ELeaderboardUploadScoreMethodNone = 0,
    k_ELeaderboardUploadScoreMethodKeepBest = 1,
    k_ELeaderboardUploadScoreMethodForceUpdate = 2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct LeaderboardEntry_t {
    pub m_steamIDUser: CSteamID,
    pub m_nGlobalRank: int32,
    pub m_nScore: int32,
    pub m_cDetails: int32,
    pub m_hUGC: UGCHandle_t,
}
#[test]
fn bindgen_test_layout_LeaderboardEntry_t() {
    assert_eq!(
        ::std::mem::size_of::<LeaderboardEntry_t>(),
        32usize,
        concat!("Size of: ", stringify!(LeaderboardEntry_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LeaderboardEntry_t>(),
        8usize,
        concat!("Alignment of ", stringify!(LeaderboardEntry_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LeaderboardEntry_t>())).m_steamIDUser as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardEntry_t),
            "::",
            stringify!(m_steamIDUser)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LeaderboardEntry_t>())).m_nGlobalRank as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardEntry_t),
            "::",
            stringify!(m_nGlobalRank)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LeaderboardEntry_t>())).m_nScore as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardEntry_t),
            "::",
            stringify!(m_nScore)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LeaderboardEntry_t>())).m_cDetails as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardEntry_t),
            "::",
            stringify!(m_cDetails)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LeaderboardEntry_t>())).m_hUGC as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardEntry_t),
            "::",
            stringify!(m_hUGC)
        )
    );
}
#[repr(C)]
pub struct ISteamUserStats__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamUserStats {
    pub vtable_: *const ISteamUserStats__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamUserStats() {
    assert_eq!(
        ::std::mem::size_of::<ISteamUserStats>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamUserStats))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamUserStats>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamUserStats))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct UserStatsReceived_t {
    pub m_nGameID: uint64,
    pub m_eResult: EResult,
    pub m_steamIDUser: CSteamID,
}
pub const UserStatsReceived_t_k_iCallback: UserStatsReceived_t__bindgen_ty_1 =
    UserStatsReceived_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum UserStatsReceived_t__bindgen_ty_1 {
    k_iCallback = 1101,
}
#[test]
fn bindgen_test_layout_UserStatsReceived_t() {
    assert_eq!(
        ::std::mem::size_of::<UserStatsReceived_t>(),
        24usize,
        concat!("Size of: ", stringify!(UserStatsReceived_t))
    );
    assert_eq!(
        ::std::mem::align_of::<UserStatsReceived_t>(),
        8usize,
        concat!("Alignment of ", stringify!(UserStatsReceived_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<UserStatsReceived_t>())).m_nGameID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(UserStatsReceived_t),
            "::",
            stringify!(m_nGameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<UserStatsReceived_t>())).m_eResult as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(UserStatsReceived_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<UserStatsReceived_t>())).m_steamIDUser as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(UserStatsReceived_t),
            "::",
            stringify!(m_steamIDUser)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UserStatsStored_t {
    pub m_nGameID: uint64,
    pub m_eResult: EResult,
}
pub const UserStatsStored_t_k_iCallback: UserStatsStored_t__bindgen_ty_1 =
    UserStatsStored_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum UserStatsStored_t__bindgen_ty_1 {
    k_iCallback = 1102,
}
#[test]
fn bindgen_test_layout_UserStatsStored_t() {
    assert_eq!(
        ::std::mem::size_of::<UserStatsStored_t>(),
        16usize,
        concat!("Size of: ", stringify!(UserStatsStored_t))
    );
    assert_eq!(
        ::std::mem::align_of::<UserStatsStored_t>(),
        8usize,
        concat!("Alignment of ", stringify!(UserStatsStored_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<UserStatsStored_t>())).m_nGameID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(UserStatsStored_t),
            "::",
            stringify!(m_nGameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<UserStatsStored_t>())).m_eResult as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(UserStatsStored_t),
            "::",
            stringify!(m_eResult)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct UserAchievementStored_t {
    pub m_nGameID: uint64,
    pub m_bGroupAchievement: bool,
    pub m_rgchAchievementName: [::std::os::raw::c_char; 128usize],
    pub m_nCurProgress: uint32,
    pub m_nMaxProgress: uint32,
}
pub const UserAchievementStored_t_k_iCallback: UserAchievementStored_t__bindgen_ty_1 =
    UserAchievementStored_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum UserAchievementStored_t__bindgen_ty_1 {
    k_iCallback = 1103,
}
#[test]
fn bindgen_test_layout_UserAchievementStored_t() {
    assert_eq!(
        ::std::mem::size_of::<UserAchievementStored_t>(),
        152usize,
        concat!("Size of: ", stringify!(UserAchievementStored_t))
    );
    assert_eq!(
        ::std::mem::align_of::<UserAchievementStored_t>(),
        8usize,
        concat!("Alignment of ", stringify!(UserAchievementStored_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<UserAchievementStored_t>())).m_nGameID as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(UserAchievementStored_t),
            "::",
            stringify!(m_nGameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<UserAchievementStored_t>())).m_bGroupAchievement as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(UserAchievementStored_t),
            "::",
            stringify!(m_bGroupAchievement)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<UserAchievementStored_t>())).m_rgchAchievementName as *const _
                as usize
        },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(UserAchievementStored_t),
            "::",
            stringify!(m_rgchAchievementName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<UserAchievementStored_t>())).m_nCurProgress as *const _ as usize
        },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(UserAchievementStored_t),
            "::",
            stringify!(m_nCurProgress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<UserAchievementStored_t>())).m_nMaxProgress as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(UserAchievementStored_t),
            "::",
            stringify!(m_nMaxProgress)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LeaderboardFindResult_t {
    pub m_hSteamLeaderboard: SteamLeaderboard_t,
    pub m_bLeaderboardFound: uint8,
}
pub const LeaderboardFindResult_t_k_iCallback: LeaderboardFindResult_t__bindgen_ty_1 =
    LeaderboardFindResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum LeaderboardFindResult_t__bindgen_ty_1 {
    k_iCallback = 1104,
}
#[test]
fn bindgen_test_layout_LeaderboardFindResult_t() {
    assert_eq!(
        ::std::mem::size_of::<LeaderboardFindResult_t>(),
        16usize,
        concat!("Size of: ", stringify!(LeaderboardFindResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LeaderboardFindResult_t>(),
        8usize,
        concat!("Alignment of ", stringify!(LeaderboardFindResult_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LeaderboardFindResult_t>())).m_hSteamLeaderboard as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardFindResult_t),
            "::",
            stringify!(m_hSteamLeaderboard)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LeaderboardFindResult_t>())).m_bLeaderboardFound as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardFindResult_t),
            "::",
            stringify!(m_bLeaderboardFound)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LeaderboardScoresDownloaded_t {
    pub m_hSteamLeaderboard: SteamLeaderboard_t,
    pub m_hSteamLeaderboardEntries: SteamLeaderboardEntries_t,
    pub m_cEntryCount: ::std::os::raw::c_int,
}
pub const LeaderboardScoresDownloaded_t_k_iCallback: LeaderboardScoresDownloaded_t__bindgen_ty_1 =
    LeaderboardScoresDownloaded_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum LeaderboardScoresDownloaded_t__bindgen_ty_1 {
    k_iCallback = 1105,
}
#[test]
fn bindgen_test_layout_LeaderboardScoresDownloaded_t() {
    assert_eq!(
        ::std::mem::size_of::<LeaderboardScoresDownloaded_t>(),
        24usize,
        concat!("Size of: ", stringify!(LeaderboardScoresDownloaded_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LeaderboardScoresDownloaded_t>(),
        8usize,
        concat!("Alignment of ", stringify!(LeaderboardScoresDownloaded_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LeaderboardScoresDownloaded_t>())).m_hSteamLeaderboard
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardScoresDownloaded_t),
            "::",
            stringify!(m_hSteamLeaderboard)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LeaderboardScoresDownloaded_t>())).m_hSteamLeaderboardEntries
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardScoresDownloaded_t),
            "::",
            stringify!(m_hSteamLeaderboardEntries)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LeaderboardScoresDownloaded_t>())).m_cEntryCount as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardScoresDownloaded_t),
            "::",
            stringify!(m_cEntryCount)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LeaderboardScoreUploaded_t {
    pub m_bSuccess: uint8,
    pub m_hSteamLeaderboard: SteamLeaderboard_t,
    pub m_nScore: int32,
    pub m_bScoreChanged: uint8,
    pub m_nGlobalRankNew: ::std::os::raw::c_int,
    pub m_nGlobalRankPrevious: ::std::os::raw::c_int,
}
pub const LeaderboardScoreUploaded_t_k_iCallback: LeaderboardScoreUploaded_t__bindgen_ty_1 =
    LeaderboardScoreUploaded_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum LeaderboardScoreUploaded_t__bindgen_ty_1 {
    k_iCallback = 1106,
}
#[test]
fn bindgen_test_layout_LeaderboardScoreUploaded_t() {
    assert_eq!(
        ::std::mem::size_of::<LeaderboardScoreUploaded_t>(),
        32usize,
        concat!("Size of: ", stringify!(LeaderboardScoreUploaded_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LeaderboardScoreUploaded_t>(),
        8usize,
        concat!("Alignment of ", stringify!(LeaderboardScoreUploaded_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LeaderboardScoreUploaded_t>())).m_bSuccess as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardScoreUploaded_t),
            "::",
            stringify!(m_bSuccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LeaderboardScoreUploaded_t>())).m_hSteamLeaderboard as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardScoreUploaded_t),
            "::",
            stringify!(m_hSteamLeaderboard)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LeaderboardScoreUploaded_t>())).m_nScore as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardScoreUploaded_t),
            "::",
            stringify!(m_nScore)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LeaderboardScoreUploaded_t>())).m_bScoreChanged as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardScoreUploaded_t),
            "::",
            stringify!(m_bScoreChanged)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LeaderboardScoreUploaded_t>())).m_nGlobalRankNew as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardScoreUploaded_t),
            "::",
            stringify!(m_nGlobalRankNew)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LeaderboardScoreUploaded_t>())).m_nGlobalRankPrevious as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardScoreUploaded_t),
            "::",
            stringify!(m_nGlobalRankPrevious)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NumberOfCurrentPlayers_t {
    pub m_bSuccess: uint8,
    pub m_cPlayers: int32,
}
pub const NumberOfCurrentPlayers_t_k_iCallback: NumberOfCurrentPlayers_t__bindgen_ty_1 =
    NumberOfCurrentPlayers_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum NumberOfCurrentPlayers_t__bindgen_ty_1 {
    k_iCallback = 1107,
}
#[test]
fn bindgen_test_layout_NumberOfCurrentPlayers_t() {
    assert_eq!(
        ::std::mem::size_of::<NumberOfCurrentPlayers_t>(),
        8usize,
        concat!("Size of: ", stringify!(NumberOfCurrentPlayers_t))
    );
    assert_eq!(
        ::std::mem::align_of::<NumberOfCurrentPlayers_t>(),
        4usize,
        concat!("Alignment of ", stringify!(NumberOfCurrentPlayers_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NumberOfCurrentPlayers_t>())).m_bSuccess as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(NumberOfCurrentPlayers_t),
            "::",
            stringify!(m_bSuccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<NumberOfCurrentPlayers_t>())).m_cPlayers as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(NumberOfCurrentPlayers_t),
            "::",
            stringify!(m_cPlayers)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct UserStatsUnloaded_t {
    pub m_steamIDUser: CSteamID,
}
pub const UserStatsUnloaded_t_k_iCallback: UserStatsUnloaded_t__bindgen_ty_1 =
    UserStatsUnloaded_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum UserStatsUnloaded_t__bindgen_ty_1 {
    k_iCallback = 1108,
}
#[test]
fn bindgen_test_layout_UserStatsUnloaded_t() {
    assert_eq!(
        ::std::mem::size_of::<UserStatsUnloaded_t>(),
        8usize,
        concat!("Size of: ", stringify!(UserStatsUnloaded_t))
    );
    assert_eq!(
        ::std::mem::align_of::<UserStatsUnloaded_t>(),
        1usize,
        concat!("Alignment of ", stringify!(UserStatsUnloaded_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<UserStatsUnloaded_t>())).m_steamIDUser as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(UserStatsUnloaded_t),
            "::",
            stringify!(m_steamIDUser)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct UserAchievementIconFetched_t {
    pub m_nGameID: CGameID,
    pub m_rgchAchievementName: [::std::os::raw::c_char; 128usize],
    pub m_bAchieved: bool,
    pub m_nIconHandle: ::std::os::raw::c_int,
}
pub const UserAchievementIconFetched_t_k_iCallback: UserAchievementIconFetched_t__bindgen_ty_1 =
    UserAchievementIconFetched_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum UserAchievementIconFetched_t__bindgen_ty_1 {
    k_iCallback = 1109,
}
#[test]
fn bindgen_test_layout_UserAchievementIconFetched_t() {
    assert_eq!(
        ::std::mem::size_of::<UserAchievementIconFetched_t>(),
        144usize,
        concat!("Size of: ", stringify!(UserAchievementIconFetched_t))
    );
    assert_eq!(
        ::std::mem::align_of::<UserAchievementIconFetched_t>(),
        4usize,
        concat!("Alignment of ", stringify!(UserAchievementIconFetched_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<UserAchievementIconFetched_t>())).m_nGameID as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(UserAchievementIconFetched_t),
            "::",
            stringify!(m_nGameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<UserAchievementIconFetched_t>())).m_rgchAchievementName
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(UserAchievementIconFetched_t),
            "::",
            stringify!(m_rgchAchievementName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<UserAchievementIconFetched_t>())).m_bAchieved as *const _
                as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(UserAchievementIconFetched_t),
            "::",
            stringify!(m_bAchieved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<UserAchievementIconFetched_t>())).m_nIconHandle as *const _
                as usize
        },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(UserAchievementIconFetched_t),
            "::",
            stringify!(m_nIconHandle)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GlobalAchievementPercentagesReady_t {
    pub m_nGameID: uint64,
    pub m_eResult: EResult,
}
pub const GlobalAchievementPercentagesReady_t_k_iCallback:
    GlobalAchievementPercentagesReady_t__bindgen_ty_1 =
    GlobalAchievementPercentagesReady_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GlobalAchievementPercentagesReady_t__bindgen_ty_1 {
    k_iCallback = 1110,
}
#[test]
fn bindgen_test_layout_GlobalAchievementPercentagesReady_t() {
    assert_eq!(
        ::std::mem::size_of::<GlobalAchievementPercentagesReady_t>(),
        16usize,
        concat!("Size of: ", stringify!(GlobalAchievementPercentagesReady_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GlobalAchievementPercentagesReady_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(GlobalAchievementPercentagesReady_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GlobalAchievementPercentagesReady_t>())).m_nGameID as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GlobalAchievementPercentagesReady_t),
            "::",
            stringify!(m_nGameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GlobalAchievementPercentagesReady_t>())).m_eResult as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GlobalAchievementPercentagesReady_t),
            "::",
            stringify!(m_eResult)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LeaderboardUGCSet_t {
    pub m_eResult: EResult,
    pub m_hSteamLeaderboard: SteamLeaderboard_t,
}
pub const LeaderboardUGCSet_t_k_iCallback: LeaderboardUGCSet_t__bindgen_ty_1 =
    LeaderboardUGCSet_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum LeaderboardUGCSet_t__bindgen_ty_1 {
    k_iCallback = 1111,
}
#[test]
fn bindgen_test_layout_LeaderboardUGCSet_t() {
    assert_eq!(
        ::std::mem::size_of::<LeaderboardUGCSet_t>(),
        16usize,
        concat!("Size of: ", stringify!(LeaderboardUGCSet_t))
    );
    assert_eq!(
        ::std::mem::align_of::<LeaderboardUGCSet_t>(),
        8usize,
        concat!("Alignment of ", stringify!(LeaderboardUGCSet_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<LeaderboardUGCSet_t>())).m_eResult as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardUGCSet_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<LeaderboardUGCSet_t>())).m_hSteamLeaderboard as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LeaderboardUGCSet_t),
            "::",
            stringify!(m_hSteamLeaderboard)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PS3TrophiesInstalled_t {
    pub m_nGameID: uint64,
    pub m_eResult: EResult,
    pub m_ulRequiredDiskSpace: uint64,
}
pub const PS3TrophiesInstalled_t_k_iCallback: PS3TrophiesInstalled_t__bindgen_ty_1 =
    PS3TrophiesInstalled_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum PS3TrophiesInstalled_t__bindgen_ty_1 {
    k_iCallback = 1112,
}
#[test]
fn bindgen_test_layout_PS3TrophiesInstalled_t() {
    assert_eq!(
        ::std::mem::size_of::<PS3TrophiesInstalled_t>(),
        24usize,
        concat!("Size of: ", stringify!(PS3TrophiesInstalled_t))
    );
    assert_eq!(
        ::std::mem::align_of::<PS3TrophiesInstalled_t>(),
        8usize,
        concat!("Alignment of ", stringify!(PS3TrophiesInstalled_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<PS3TrophiesInstalled_t>())).m_nGameID as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PS3TrophiesInstalled_t),
            "::",
            stringify!(m_nGameID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<PS3TrophiesInstalled_t>())).m_eResult as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(PS3TrophiesInstalled_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<PS3TrophiesInstalled_t>())).m_ulRequiredDiskSpace as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(PS3TrophiesInstalled_t),
            "::",
            stringify!(m_ulRequiredDiskSpace)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GlobalStatsReceived_t {
    pub m_nGameID: uint64,
    pub m_eResult: EResult,
}
pub const GlobalStatsReceived_t_k_iCallback: GlobalStatsReceived_t__bindgen_ty_1 =
    GlobalStatsReceived_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GlobalStatsReceived_t__bindgen_ty_1 {
    k_iCallback = 1112,
}
#[test]
fn bindgen_test_layout_GlobalStatsReceived_t() {
    assert_eq!(
        ::std::mem::size_of::<GlobalStatsReceived_t>(),
        16usize,
        concat!("Size of: ", stringify!(GlobalStatsReceived_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GlobalStatsReceived_t>(),
        8usize,
        concat!("Alignment of ", stringify!(GlobalStatsReceived_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GlobalStatsReceived_t>())).m_nGameID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GlobalStatsReceived_t),
            "::",
            stringify!(m_nGameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GlobalStatsReceived_t>())).m_eResult as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GlobalStatsReceived_t),
            "::",
            stringify!(m_eResult)
        )
    );
}
pub const k_cubAppProofOfPurchaseKeyMax: ::std::os::raw::c_int = 240;
#[repr(C)]
pub struct ISteamApps__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamApps {
    pub vtable_: *const ISteamApps__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamApps() {
    assert_eq!(
        ::std::mem::size_of::<ISteamApps>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamApps))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamApps>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamApps))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DlcInstalled_t {
    pub m_nAppID: AppId_t,
}
pub const DlcInstalled_t_k_iCallback: DlcInstalled_t__bindgen_ty_1 =
    DlcInstalled_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum DlcInstalled_t__bindgen_ty_1 {
    k_iCallback = 1005,
}
#[test]
fn bindgen_test_layout_DlcInstalled_t() {
    assert_eq!(
        ::std::mem::size_of::<DlcInstalled_t>(),
        4usize,
        concat!("Size of: ", stringify!(DlcInstalled_t))
    );
    assert_eq!(
        ::std::mem::align_of::<DlcInstalled_t>(),
        4usize,
        concat!("Alignment of ", stringify!(DlcInstalled_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DlcInstalled_t>())).m_nAppID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(DlcInstalled_t),
            "::",
            stringify!(m_nAppID)
        )
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ERegisterActivationCodeResult {
    k_ERegisterActivationCodeResultOK = 0,
    k_ERegisterActivationCodeResultFail = 1,
    k_ERegisterActivationCodeResultAlreadyRegistered = 2,
    k_ERegisterActivationCodeResultTimeout = 3,
    k_ERegisterActivationCodeAlreadyOwned = 4,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RegisterActivationCodeResponse_t {
    pub m_eResult: ERegisterActivationCodeResult,
    pub m_unPackageRegistered: uint32,
}
pub const RegisterActivationCodeResponse_t_k_iCallback:
    RegisterActivationCodeResponse_t__bindgen_ty_1 =
    RegisterActivationCodeResponse_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RegisterActivationCodeResponse_t__bindgen_ty_1 {
    k_iCallback = 1008,
}
#[test]
fn bindgen_test_layout_RegisterActivationCodeResponse_t() {
    assert_eq!(
        ::std::mem::size_of::<RegisterActivationCodeResponse_t>(),
        8usize,
        concat!("Size of: ", stringify!(RegisterActivationCodeResponse_t))
    );
    assert_eq!(
        ::std::mem::align_of::<RegisterActivationCodeResponse_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(RegisterActivationCodeResponse_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RegisterActivationCodeResponse_t>())).m_eResult as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RegisterActivationCodeResponse_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RegisterActivationCodeResponse_t>())).m_unPackageRegistered
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(RegisterActivationCodeResponse_t),
            "::",
            stringify!(m_unPackageRegistered)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NewUrlLaunchParameters_t {
    pub _address: u8,
}
pub const NewUrlLaunchParameters_t_k_iCallback: NewUrlLaunchParameters_t__bindgen_ty_1 =
    NewUrlLaunchParameters_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum NewUrlLaunchParameters_t__bindgen_ty_1 {
    k_iCallback = 1014,
}
#[test]
fn bindgen_test_layout_NewUrlLaunchParameters_t() {
    assert_eq!(
        ::std::mem::size_of::<NewUrlLaunchParameters_t>(),
        1usize,
        concat!("Size of: ", stringify!(NewUrlLaunchParameters_t))
    );
    assert_eq!(
        ::std::mem::align_of::<NewUrlLaunchParameters_t>(),
        1usize,
        concat!("Alignment of ", stringify!(NewUrlLaunchParameters_t))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AppProofOfPurchaseKeyResponse_t {
    pub m_eResult: EResult,
    pub m_nAppID: uint32,
    pub m_cchKeyLength: uint32,
    pub m_rgchKey: [::std::os::raw::c_char; 240usize],
}
pub const AppProofOfPurchaseKeyResponse_t_k_iCallback:
    AppProofOfPurchaseKeyResponse_t__bindgen_ty_1 =
    AppProofOfPurchaseKeyResponse_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AppProofOfPurchaseKeyResponse_t__bindgen_ty_1 {
    k_iCallback = 1021,
}
#[test]
fn bindgen_test_layout_AppProofOfPurchaseKeyResponse_t() {
    assert_eq!(
        ::std::mem::size_of::<AppProofOfPurchaseKeyResponse_t>(),
        252usize,
        concat!("Size of: ", stringify!(AppProofOfPurchaseKeyResponse_t))
    );
    assert_eq!(
        ::std::mem::align_of::<AppProofOfPurchaseKeyResponse_t>(),
        4usize,
        concat!("Alignment of ", stringify!(AppProofOfPurchaseKeyResponse_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AppProofOfPurchaseKeyResponse_t>())).m_eResult as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AppProofOfPurchaseKeyResponse_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AppProofOfPurchaseKeyResponse_t>())).m_nAppID as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(AppProofOfPurchaseKeyResponse_t),
            "::",
            stringify!(m_nAppID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AppProofOfPurchaseKeyResponse_t>())).m_cchKeyLength as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AppProofOfPurchaseKeyResponse_t),
            "::",
            stringify!(m_cchKeyLength)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AppProofOfPurchaseKeyResponse_t>())).m_rgchKey as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(AppProofOfPurchaseKeyResponse_t),
            "::",
            stringify!(m_rgchKey)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FileDetailsResult_t {
    pub m_eResult: EResult,
    pub m_ulFileSize: uint64,
    pub m_FileSHA: [uint8; 20usize],
    pub m_unFlags: uint32,
}
pub const FileDetailsResult_t_k_iCallback: FileDetailsResult_t__bindgen_ty_1 =
    FileDetailsResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum FileDetailsResult_t__bindgen_ty_1 {
    k_iCallback = 1023,
}
#[test]
fn bindgen_test_layout_FileDetailsResult_t() {
    assert_eq!(
        ::std::mem::size_of::<FileDetailsResult_t>(),
        40usize,
        concat!("Size of: ", stringify!(FileDetailsResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<FileDetailsResult_t>(),
        8usize,
        concat!("Alignment of ", stringify!(FileDetailsResult_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FileDetailsResult_t>())).m_eResult as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FileDetailsResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<FileDetailsResult_t>())).m_ulFileSize as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FileDetailsResult_t),
            "::",
            stringify!(m_ulFileSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FileDetailsResult_t>())).m_FileSHA as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(FileDetailsResult_t),
            "::",
            stringify!(m_FileSHA)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FileDetailsResult_t>())).m_unFlags as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(FileDetailsResult_t),
            "::",
            stringify!(m_unFlags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TimedTrialStatus_t {
    pub m_unAppID: AppId_t,
    pub m_bIsOffline: bool,
    pub m_unSecondsAllowed: uint32,
    pub m_unSecondsPlayed: uint32,
}
pub const TimedTrialStatus_t_k_iCallback: TimedTrialStatus_t__bindgen_ty_1 =
    TimedTrialStatus_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum TimedTrialStatus_t__bindgen_ty_1 {
    k_iCallback = 1030,
}
#[test]
fn bindgen_test_layout_TimedTrialStatus_t() {
    assert_eq!(
        ::std::mem::size_of::<TimedTrialStatus_t>(),
        16usize,
        concat!("Size of: ", stringify!(TimedTrialStatus_t))
    );
    assert_eq!(
        ::std::mem::align_of::<TimedTrialStatus_t>(),
        4usize,
        concat!("Alignment of ", stringify!(TimedTrialStatus_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TimedTrialStatus_t>())).m_unAppID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TimedTrialStatus_t),
            "::",
            stringify!(m_unAppID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TimedTrialStatus_t>())).m_bIsOffline as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TimedTrialStatus_t),
            "::",
            stringify!(m_bIsOffline)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TimedTrialStatus_t>())).m_unSecondsAllowed as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(TimedTrialStatus_t),
            "::",
            stringify!(m_unSecondsAllowed)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TimedTrialStatus_t>())).m_unSecondsPlayed as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(TimedTrialStatus_t),
            "::",
            stringify!(m_unSecondsPlayed)
        )
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EP2PSessionError {
    k_EP2PSessionErrorNone = 0,
    k_EP2PSessionErrorNoRightsToApp = 2,
    k_EP2PSessionErrorTimeout = 4,
    k_EP2PSessionErrorNotRunningApp_DELETED = 1,
    k_EP2PSessionErrorDestinationNotLoggedIn_DELETED = 3,
    k_EP2PSessionErrorMax = 5,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EP2PSend {
    k_EP2PSendUnreliable = 0,
    k_EP2PSendUnreliableNoDelay = 1,
    k_EP2PSendReliable = 2,
    k_EP2PSendReliableWithBuffering = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct P2PSessionState_t {
    pub m_bConnectionActive: uint8,
    pub m_bConnecting: uint8,
    pub m_eP2PSessionError: uint8,
    pub m_bUsingRelay: uint8,
    pub m_nBytesQueuedForSend: int32,
    pub m_nPacketsQueuedForSend: int32,
    pub m_nRemoteIP: uint32,
    pub m_nRemotePort: uint16,
}
#[test]
fn bindgen_test_layout_P2PSessionState_t() {
    assert_eq!(
        ::std::mem::size_of::<P2PSessionState_t>(),
        20usize,
        concat!("Size of: ", stringify!(P2PSessionState_t))
    );
    assert_eq!(
        ::std::mem::align_of::<P2PSessionState_t>(),
        4usize,
        concat!("Alignment of ", stringify!(P2PSessionState_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<P2PSessionState_t>())).m_bConnectionActive as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(P2PSessionState_t),
            "::",
            stringify!(m_bConnectionActive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<P2PSessionState_t>())).m_bConnecting as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(P2PSessionState_t),
            "::",
            stringify!(m_bConnecting)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<P2PSessionState_t>())).m_eP2PSessionError as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(P2PSessionState_t),
            "::",
            stringify!(m_eP2PSessionError)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<P2PSessionState_t>())).m_bUsingRelay as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(P2PSessionState_t),
            "::",
            stringify!(m_bUsingRelay)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<P2PSessionState_t>())).m_nBytesQueuedForSend as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(P2PSessionState_t),
            "::",
            stringify!(m_nBytesQueuedForSend)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<P2PSessionState_t>())).m_nPacketsQueuedForSend as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(P2PSessionState_t),
            "::",
            stringify!(m_nPacketsQueuedForSend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<P2PSessionState_t>())).m_nRemoteIP as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(P2PSessionState_t),
            "::",
            stringify!(m_nRemoteIP)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<P2PSessionState_t>())).m_nRemotePort as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(P2PSessionState_t),
            "::",
            stringify!(m_nRemotePort)
        )
    );
}
pub type SNetSocket_t = uint32;
pub type SNetListenSocket_t = uint32;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESNetSocketState {
    k_ESNetSocketStateInvalid = 0,
    k_ESNetSocketStateConnected = 1,
    k_ESNetSocketStateInitiated = 10,
    k_ESNetSocketStateLocalCandidatesFound = 11,
    k_ESNetSocketStateReceivedRemoteCandidates = 12,
    k_ESNetSocketStateChallengeHandshake = 15,
    k_ESNetSocketStateDisconnecting = 21,
    k_ESNetSocketStateLocalDisconnect = 22,
    k_ESNetSocketStateTimeoutDuringConnect = 23,
    k_ESNetSocketStateRemoteEndDisconnected = 24,
    k_ESNetSocketStateConnectionBroken = 25,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESNetSocketConnectionType {
    k_ESNetSocketConnectionTypeNotConnected = 0,
    k_ESNetSocketConnectionTypeUDP = 1,
    k_ESNetSocketConnectionTypeUDPRelay = 2,
}
#[repr(C)]
pub struct ISteamNetworking__bindgen_vtable(::std::os::raw::c_void);
#[doc = "      the Steamworks SDK.  Please see ISteamNetworkingSockets and"]
#[doc = "      ISteamNetworkingMessages"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamNetworking {
    pub vtable_: *const ISteamNetworking__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamNetworking() {
    assert_eq!(
        ::std::mem::size_of::<ISteamNetworking>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamNetworking))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamNetworking>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamNetworking))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct P2PSessionRequest_t {
    pub m_steamIDRemote: CSteamID,
}
pub const P2PSessionRequest_t_k_iCallback: P2PSessionRequest_t__bindgen_ty_1 =
    P2PSessionRequest_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum P2PSessionRequest_t__bindgen_ty_1 {
    k_iCallback = 1202,
}
#[test]
fn bindgen_test_layout_P2PSessionRequest_t() {
    assert_eq!(
        ::std::mem::size_of::<P2PSessionRequest_t>(),
        8usize,
        concat!("Size of: ", stringify!(P2PSessionRequest_t))
    );
    assert_eq!(
        ::std::mem::align_of::<P2PSessionRequest_t>(),
        1usize,
        concat!("Alignment of ", stringify!(P2PSessionRequest_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<P2PSessionRequest_t>())).m_steamIDRemote as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(P2PSessionRequest_t),
            "::",
            stringify!(m_steamIDRemote)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct P2PSessionConnectFail_t {
    pub m_steamIDRemote: CSteamID,
    pub m_eP2PSessionError: uint8,
}
pub const P2PSessionConnectFail_t_k_iCallback: P2PSessionConnectFail_t__bindgen_ty_1 =
    P2PSessionConnectFail_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum P2PSessionConnectFail_t__bindgen_ty_1 {
    k_iCallback = 1203,
}
#[test]
fn bindgen_test_layout_P2PSessionConnectFail_t() {
    assert_eq!(
        ::std::mem::size_of::<P2PSessionConnectFail_t>(),
        9usize,
        concat!("Size of: ", stringify!(P2PSessionConnectFail_t))
    );
    assert_eq!(
        ::std::mem::align_of::<P2PSessionConnectFail_t>(),
        1usize,
        concat!("Alignment of ", stringify!(P2PSessionConnectFail_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<P2PSessionConnectFail_t>())).m_steamIDRemote as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(P2PSessionConnectFail_t),
            "::",
            stringify!(m_steamIDRemote)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<P2PSessionConnectFail_t>())).m_eP2PSessionError as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(P2PSessionConnectFail_t),
            "::",
            stringify!(m_eP2PSessionError)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SocketStatusCallback_t {
    pub m_hSocket: SNetSocket_t,
    pub m_hListenSocket: SNetListenSocket_t,
    pub m_steamIDRemote: CSteamID,
    pub m_eSNetSocketState: ::std::os::raw::c_int,
}
pub const SocketStatusCallback_t_k_iCallback: SocketStatusCallback_t__bindgen_ty_1 =
    SocketStatusCallback_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SocketStatusCallback_t__bindgen_ty_1 {
    k_iCallback = 1201,
}
#[test]
fn bindgen_test_layout_SocketStatusCallback_t() {
    assert_eq!(
        ::std::mem::size_of::<SocketStatusCallback_t>(),
        20usize,
        concat!("Size of: ", stringify!(SocketStatusCallback_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SocketStatusCallback_t>(),
        4usize,
        concat!("Alignment of ", stringify!(SocketStatusCallback_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SocketStatusCallback_t>())).m_hSocket as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SocketStatusCallback_t),
            "::",
            stringify!(m_hSocket)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SocketStatusCallback_t>())).m_hListenSocket as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(SocketStatusCallback_t),
            "::",
            stringify!(m_hListenSocket)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SocketStatusCallback_t>())).m_steamIDRemote as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SocketStatusCallback_t),
            "::",
            stringify!(m_steamIDRemote)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SocketStatusCallback_t>())).m_eSNetSocketState as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SocketStatusCallback_t),
            "::",
            stringify!(m_eSNetSocketState)
        )
    );
}
pub const k_nScreenshotMaxTaggedUsers: uint32 = 32;
pub const k_nScreenshotMaxTaggedPublishedFiles: uint32 = 32;
pub const k_cubUFSTagTypeMax: ::std::os::raw::c_int = 255;
pub const k_cubUFSTagValueMax: ::std::os::raw::c_int = 255;
pub const k_ScreenshotThumbWidth: ::std::os::raw::c_int = 200;
pub type ScreenshotHandle = uint32;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EVRScreenshotType {
    k_EVRScreenshotType_None = 0,
    k_EVRScreenshotType_Mono = 1,
    k_EVRScreenshotType_Stereo = 2,
    k_EVRScreenshotType_MonoCubemap = 3,
    k_EVRScreenshotType_MonoPanorama = 4,
    k_EVRScreenshotType_StereoPanorama = 5,
}
#[repr(C)]
pub struct ISteamScreenshots__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamScreenshots {
    pub vtable_: *const ISteamScreenshots__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamScreenshots() {
    assert_eq!(
        ::std::mem::size_of::<ISteamScreenshots>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamScreenshots))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamScreenshots>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamScreenshots))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScreenshotReady_t {
    pub m_hLocal: ScreenshotHandle,
    pub m_eResult: EResult,
}
pub const ScreenshotReady_t_k_iCallback: ScreenshotReady_t__bindgen_ty_1 =
    ScreenshotReady_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ScreenshotReady_t__bindgen_ty_1 {
    k_iCallback = 2301,
}
#[test]
fn bindgen_test_layout_ScreenshotReady_t() {
    assert_eq!(
        ::std::mem::size_of::<ScreenshotReady_t>(),
        8usize,
        concat!("Size of: ", stringify!(ScreenshotReady_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ScreenshotReady_t>(),
        4usize,
        concat!("Alignment of ", stringify!(ScreenshotReady_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ScreenshotReady_t>())).m_hLocal as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ScreenshotReady_t),
            "::",
            stringify!(m_hLocal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ScreenshotReady_t>())).m_eResult as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ScreenshotReady_t),
            "::",
            stringify!(m_eResult)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ScreenshotRequested_t {
    pub _address: u8,
}
pub const ScreenshotRequested_t_k_iCallback: ScreenshotRequested_t__bindgen_ty_1 =
    ScreenshotRequested_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ScreenshotRequested_t__bindgen_ty_1 {
    k_iCallback = 2302,
}
#[test]
fn bindgen_test_layout_ScreenshotRequested_t() {
    assert_eq!(
        ::std::mem::size_of::<ScreenshotRequested_t>(),
        1usize,
        concat!("Size of: ", stringify!(ScreenshotRequested_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ScreenshotRequested_t>(),
        1usize,
        concat!("Alignment of ", stringify!(ScreenshotRequested_t))
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AudioPlayback_Status {
    AudioPlayback_Undefined = 0,
    AudioPlayback_Playing = 1,
    AudioPlayback_Paused = 2,
    AudioPlayback_Idle = 3,
}
#[repr(C)]
pub struct ISteamMusic__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamMusic {
    pub vtable_: *const ISteamMusic__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamMusic() {
    assert_eq!(
        ::std::mem::size_of::<ISteamMusic>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamMusic))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamMusic>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamMusic))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct PlaybackStatusHasChanged_t {
    pub _address: u8,
}
pub const PlaybackStatusHasChanged_t_k_iCallback: PlaybackStatusHasChanged_t__bindgen_ty_1 =
    PlaybackStatusHasChanged_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum PlaybackStatusHasChanged_t__bindgen_ty_1 {
    k_iCallback = 4001,
}
#[test]
fn bindgen_test_layout_PlaybackStatusHasChanged_t() {
    assert_eq!(
        ::std::mem::size_of::<PlaybackStatusHasChanged_t>(),
        1usize,
        concat!("Size of: ", stringify!(PlaybackStatusHasChanged_t))
    );
    assert_eq!(
        ::std::mem::align_of::<PlaybackStatusHasChanged_t>(),
        1usize,
        concat!("Alignment of ", stringify!(PlaybackStatusHasChanged_t))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VolumeHasChanged_t {
    pub m_flNewVolume: f32,
}
pub const VolumeHasChanged_t_k_iCallback: VolumeHasChanged_t__bindgen_ty_1 =
    VolumeHasChanged_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum VolumeHasChanged_t__bindgen_ty_1 {
    k_iCallback = 4002,
}
#[test]
fn bindgen_test_layout_VolumeHasChanged_t() {
    assert_eq!(
        ::std::mem::size_of::<VolumeHasChanged_t>(),
        4usize,
        concat!("Size of: ", stringify!(VolumeHasChanged_t))
    );
    assert_eq!(
        ::std::mem::align_of::<VolumeHasChanged_t>(),
        4usize,
        concat!("Alignment of ", stringify!(VolumeHasChanged_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VolumeHasChanged_t>())).m_flNewVolume as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VolumeHasChanged_t),
            "::",
            stringify!(m_flNewVolume)
        )
    );
}
#[repr(C)]
pub struct ISteamMusicRemote__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamMusicRemote {
    pub vtable_: *const ISteamMusicRemote__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamMusicRemote() {
    assert_eq!(
        ::std::mem::size_of::<ISteamMusicRemote>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamMusicRemote))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamMusicRemote>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamMusicRemote))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MusicPlayerRemoteWillActivate_t {
    pub _address: u8,
}
pub const MusicPlayerRemoteWillActivate_t_k_iCallback:
    MusicPlayerRemoteWillActivate_t__bindgen_ty_1 =
    MusicPlayerRemoteWillActivate_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MusicPlayerRemoteWillActivate_t__bindgen_ty_1 {
    k_iCallback = 4101,
}
#[test]
fn bindgen_test_layout_MusicPlayerRemoteWillActivate_t() {
    assert_eq!(
        ::std::mem::size_of::<MusicPlayerRemoteWillActivate_t>(),
        1usize,
        concat!("Size of: ", stringify!(MusicPlayerRemoteWillActivate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MusicPlayerRemoteWillActivate_t>(),
        1usize,
        concat!("Alignment of ", stringify!(MusicPlayerRemoteWillActivate_t))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MusicPlayerRemoteWillDeactivate_t {
    pub _address: u8,
}
pub const MusicPlayerRemoteWillDeactivate_t_k_iCallback:
    MusicPlayerRemoteWillDeactivate_t__bindgen_ty_1 =
    MusicPlayerRemoteWillDeactivate_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MusicPlayerRemoteWillDeactivate_t__bindgen_ty_1 {
    k_iCallback = 4102,
}
#[test]
fn bindgen_test_layout_MusicPlayerRemoteWillDeactivate_t() {
    assert_eq!(
        ::std::mem::size_of::<MusicPlayerRemoteWillDeactivate_t>(),
        1usize,
        concat!("Size of: ", stringify!(MusicPlayerRemoteWillDeactivate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MusicPlayerRemoteWillDeactivate_t>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(MusicPlayerRemoteWillDeactivate_t)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MusicPlayerRemoteToFront_t {
    pub _address: u8,
}
pub const MusicPlayerRemoteToFront_t_k_iCallback: MusicPlayerRemoteToFront_t__bindgen_ty_1 =
    MusicPlayerRemoteToFront_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MusicPlayerRemoteToFront_t__bindgen_ty_1 {
    k_iCallback = 4103,
}
#[test]
fn bindgen_test_layout_MusicPlayerRemoteToFront_t() {
    assert_eq!(
        ::std::mem::size_of::<MusicPlayerRemoteToFront_t>(),
        1usize,
        concat!("Size of: ", stringify!(MusicPlayerRemoteToFront_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MusicPlayerRemoteToFront_t>(),
        1usize,
        concat!("Alignment of ", stringify!(MusicPlayerRemoteToFront_t))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MusicPlayerWillQuit_t {
    pub _address: u8,
}
pub const MusicPlayerWillQuit_t_k_iCallback: MusicPlayerWillQuit_t__bindgen_ty_1 =
    MusicPlayerWillQuit_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MusicPlayerWillQuit_t__bindgen_ty_1 {
    k_iCallback = 4104,
}
#[test]
fn bindgen_test_layout_MusicPlayerWillQuit_t() {
    assert_eq!(
        ::std::mem::size_of::<MusicPlayerWillQuit_t>(),
        1usize,
        concat!("Size of: ", stringify!(MusicPlayerWillQuit_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MusicPlayerWillQuit_t>(),
        1usize,
        concat!("Alignment of ", stringify!(MusicPlayerWillQuit_t))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MusicPlayerWantsPlay_t {
    pub _address: u8,
}
pub const MusicPlayerWantsPlay_t_k_iCallback: MusicPlayerWantsPlay_t__bindgen_ty_1 =
    MusicPlayerWantsPlay_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MusicPlayerWantsPlay_t__bindgen_ty_1 {
    k_iCallback = 4105,
}
#[test]
fn bindgen_test_layout_MusicPlayerWantsPlay_t() {
    assert_eq!(
        ::std::mem::size_of::<MusicPlayerWantsPlay_t>(),
        1usize,
        concat!("Size of: ", stringify!(MusicPlayerWantsPlay_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MusicPlayerWantsPlay_t>(),
        1usize,
        concat!("Alignment of ", stringify!(MusicPlayerWantsPlay_t))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MusicPlayerWantsPause_t {
    pub _address: u8,
}
pub const MusicPlayerWantsPause_t_k_iCallback: MusicPlayerWantsPause_t__bindgen_ty_1 =
    MusicPlayerWantsPause_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MusicPlayerWantsPause_t__bindgen_ty_1 {
    k_iCallback = 4106,
}
#[test]
fn bindgen_test_layout_MusicPlayerWantsPause_t() {
    assert_eq!(
        ::std::mem::size_of::<MusicPlayerWantsPause_t>(),
        1usize,
        concat!("Size of: ", stringify!(MusicPlayerWantsPause_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MusicPlayerWantsPause_t>(),
        1usize,
        concat!("Alignment of ", stringify!(MusicPlayerWantsPause_t))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MusicPlayerWantsPlayPrevious_t {
    pub _address: u8,
}
pub const MusicPlayerWantsPlayPrevious_t_k_iCallback: MusicPlayerWantsPlayPrevious_t__bindgen_ty_1 =
    MusicPlayerWantsPlayPrevious_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MusicPlayerWantsPlayPrevious_t__bindgen_ty_1 {
    k_iCallback = 4107,
}
#[test]
fn bindgen_test_layout_MusicPlayerWantsPlayPrevious_t() {
    assert_eq!(
        ::std::mem::size_of::<MusicPlayerWantsPlayPrevious_t>(),
        1usize,
        concat!("Size of: ", stringify!(MusicPlayerWantsPlayPrevious_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MusicPlayerWantsPlayPrevious_t>(),
        1usize,
        concat!("Alignment of ", stringify!(MusicPlayerWantsPlayPrevious_t))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MusicPlayerWantsPlayNext_t {
    pub _address: u8,
}
pub const MusicPlayerWantsPlayNext_t_k_iCallback: MusicPlayerWantsPlayNext_t__bindgen_ty_1 =
    MusicPlayerWantsPlayNext_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MusicPlayerWantsPlayNext_t__bindgen_ty_1 {
    k_iCallback = 4108,
}
#[test]
fn bindgen_test_layout_MusicPlayerWantsPlayNext_t() {
    assert_eq!(
        ::std::mem::size_of::<MusicPlayerWantsPlayNext_t>(),
        1usize,
        concat!("Size of: ", stringify!(MusicPlayerWantsPlayNext_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MusicPlayerWantsPlayNext_t>(),
        1usize,
        concat!("Alignment of ", stringify!(MusicPlayerWantsPlayNext_t))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MusicPlayerWantsShuffled_t {
    pub m_bShuffled: bool,
}
pub const MusicPlayerWantsShuffled_t_k_iCallback: MusicPlayerWantsShuffled_t__bindgen_ty_1 =
    MusicPlayerWantsShuffled_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MusicPlayerWantsShuffled_t__bindgen_ty_1 {
    k_iCallback = 4109,
}
#[test]
fn bindgen_test_layout_MusicPlayerWantsShuffled_t() {
    assert_eq!(
        ::std::mem::size_of::<MusicPlayerWantsShuffled_t>(),
        1usize,
        concat!("Size of: ", stringify!(MusicPlayerWantsShuffled_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MusicPlayerWantsShuffled_t>(),
        1usize,
        concat!("Alignment of ", stringify!(MusicPlayerWantsShuffled_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MusicPlayerWantsShuffled_t>())).m_bShuffled as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MusicPlayerWantsShuffled_t),
            "::",
            stringify!(m_bShuffled)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MusicPlayerWantsLooped_t {
    pub m_bLooped: bool,
}
pub const MusicPlayerWantsLooped_t_k_iCallback: MusicPlayerWantsLooped_t__bindgen_ty_1 =
    MusicPlayerWantsLooped_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MusicPlayerWantsLooped_t__bindgen_ty_1 {
    k_iCallback = 4110,
}
#[test]
fn bindgen_test_layout_MusicPlayerWantsLooped_t() {
    assert_eq!(
        ::std::mem::size_of::<MusicPlayerWantsLooped_t>(),
        1usize,
        concat!("Size of: ", stringify!(MusicPlayerWantsLooped_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MusicPlayerWantsLooped_t>(),
        1usize,
        concat!("Alignment of ", stringify!(MusicPlayerWantsLooped_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MusicPlayerWantsLooped_t>())).m_bLooped as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MusicPlayerWantsLooped_t),
            "::",
            stringify!(m_bLooped)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MusicPlayerWantsVolume_t {
    pub m_flNewVolume: f32,
}
pub const MusicPlayerWantsVolume_t_k_iCallback: MusicPlayerWantsVolume_t__bindgen_ty_1 =
    MusicPlayerWantsVolume_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MusicPlayerWantsVolume_t__bindgen_ty_1 {
    k_iCallback = 4011,
}
#[test]
fn bindgen_test_layout_MusicPlayerWantsVolume_t() {
    assert_eq!(
        ::std::mem::size_of::<MusicPlayerWantsVolume_t>(),
        4usize,
        concat!("Size of: ", stringify!(MusicPlayerWantsVolume_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MusicPlayerWantsVolume_t>(),
        4usize,
        concat!("Alignment of ", stringify!(MusicPlayerWantsVolume_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MusicPlayerWantsVolume_t>())).m_flNewVolume as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MusicPlayerWantsVolume_t),
            "::",
            stringify!(m_flNewVolume)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MusicPlayerSelectsQueueEntry_t {
    pub nID: ::std::os::raw::c_int,
}
pub const MusicPlayerSelectsQueueEntry_t_k_iCallback: MusicPlayerSelectsQueueEntry_t__bindgen_ty_1 =
    MusicPlayerSelectsQueueEntry_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MusicPlayerSelectsQueueEntry_t__bindgen_ty_1 {
    k_iCallback = 4012,
}
#[test]
fn bindgen_test_layout_MusicPlayerSelectsQueueEntry_t() {
    assert_eq!(
        ::std::mem::size_of::<MusicPlayerSelectsQueueEntry_t>(),
        4usize,
        concat!("Size of: ", stringify!(MusicPlayerSelectsQueueEntry_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MusicPlayerSelectsQueueEntry_t>(),
        4usize,
        concat!("Alignment of ", stringify!(MusicPlayerSelectsQueueEntry_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MusicPlayerSelectsQueueEntry_t>())).nID as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MusicPlayerSelectsQueueEntry_t),
            "::",
            stringify!(nID)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MusicPlayerSelectsPlaylistEntry_t {
    pub nID: ::std::os::raw::c_int,
}
pub const MusicPlayerSelectsPlaylistEntry_t_k_iCallback:
    MusicPlayerSelectsPlaylistEntry_t__bindgen_ty_1 =
    MusicPlayerSelectsPlaylistEntry_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MusicPlayerSelectsPlaylistEntry_t__bindgen_ty_1 {
    k_iCallback = 4013,
}
#[test]
fn bindgen_test_layout_MusicPlayerSelectsPlaylistEntry_t() {
    assert_eq!(
        ::std::mem::size_of::<MusicPlayerSelectsPlaylistEntry_t>(),
        4usize,
        concat!("Size of: ", stringify!(MusicPlayerSelectsPlaylistEntry_t))
    );
    assert_eq!(
        ::std::mem::align_of::<MusicPlayerSelectsPlaylistEntry_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(MusicPlayerSelectsPlaylistEntry_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MusicPlayerSelectsPlaylistEntry_t>())).nID as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MusicPlayerSelectsPlaylistEntry_t),
            "::",
            stringify!(nID)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MusicPlayerWantsPlayingRepeatStatus_t {
    pub m_nPlayingRepeatStatus: ::std::os::raw::c_int,
}
pub const MusicPlayerWantsPlayingRepeatStatus_t_k_iCallback:
    MusicPlayerWantsPlayingRepeatStatus_t__bindgen_ty_1 =
    MusicPlayerWantsPlayingRepeatStatus_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MusicPlayerWantsPlayingRepeatStatus_t__bindgen_ty_1 {
    k_iCallback = 4114,
}
#[test]
fn bindgen_test_layout_MusicPlayerWantsPlayingRepeatStatus_t() {
    assert_eq!(
        ::std::mem::size_of::<MusicPlayerWantsPlayingRepeatStatus_t>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(MusicPlayerWantsPlayingRepeatStatus_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<MusicPlayerWantsPlayingRepeatStatus_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(MusicPlayerWantsPlayingRepeatStatus_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<MusicPlayerWantsPlayingRepeatStatus_t>())).m_nPlayingRepeatStatus
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MusicPlayerWantsPlayingRepeatStatus_t),
            "::",
            stringify!(m_nPlayingRepeatStatus)
        )
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EHTTPMethod {
    k_EHTTPMethodInvalid = 0,
    k_EHTTPMethodGET = 1,
    k_EHTTPMethodHEAD = 2,
    k_EHTTPMethodPOST = 3,
    k_EHTTPMethodPUT = 4,
    k_EHTTPMethodDELETE = 5,
    k_EHTTPMethodOPTIONS = 6,
    k_EHTTPMethodPATCH = 7,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EHTTPStatusCode {
    k_EHTTPStatusCodeInvalid = 0,
    k_EHTTPStatusCode100Continue = 100,
    k_EHTTPStatusCode101SwitchingProtocols = 101,
    k_EHTTPStatusCode200OK = 200,
    k_EHTTPStatusCode201Created = 201,
    k_EHTTPStatusCode202Accepted = 202,
    k_EHTTPStatusCode203NonAuthoritative = 203,
    k_EHTTPStatusCode204NoContent = 204,
    k_EHTTPStatusCode205ResetContent = 205,
    k_EHTTPStatusCode206PartialContent = 206,
    k_EHTTPStatusCode300MultipleChoices = 300,
    k_EHTTPStatusCode301MovedPermanently = 301,
    k_EHTTPStatusCode302Found = 302,
    k_EHTTPStatusCode303SeeOther = 303,
    k_EHTTPStatusCode304NotModified = 304,
    k_EHTTPStatusCode305UseProxy = 305,
    k_EHTTPStatusCode307TemporaryRedirect = 307,
    k_EHTTPStatusCode400BadRequest = 400,
    k_EHTTPStatusCode401Unauthorized = 401,
    k_EHTTPStatusCode402PaymentRequired = 402,
    k_EHTTPStatusCode403Forbidden = 403,
    k_EHTTPStatusCode404NotFound = 404,
    k_EHTTPStatusCode405MethodNotAllowed = 405,
    k_EHTTPStatusCode406NotAcceptable = 406,
    k_EHTTPStatusCode407ProxyAuthRequired = 407,
    k_EHTTPStatusCode408RequestTimeout = 408,
    k_EHTTPStatusCode409Conflict = 409,
    k_EHTTPStatusCode410Gone = 410,
    k_EHTTPStatusCode411LengthRequired = 411,
    k_EHTTPStatusCode412PreconditionFailed = 412,
    k_EHTTPStatusCode413RequestEntityTooLarge = 413,
    k_EHTTPStatusCode414RequestURITooLong = 414,
    k_EHTTPStatusCode415UnsupportedMediaType = 415,
    k_EHTTPStatusCode416RequestedRangeNotSatisfiable = 416,
    k_EHTTPStatusCode417ExpectationFailed = 417,
    k_EHTTPStatusCode4xxUnknown = 418,
    k_EHTTPStatusCode429TooManyRequests = 429,
    k_EHTTPStatusCode444ConnectionClosed = 444,
    k_EHTTPStatusCode500InternalServerError = 500,
    k_EHTTPStatusCode501NotImplemented = 501,
    k_EHTTPStatusCode502BadGateway = 502,
    k_EHTTPStatusCode503ServiceUnavailable = 503,
    k_EHTTPStatusCode504GatewayTimeout = 504,
    k_EHTTPStatusCode505HTTPVersionNotSupported = 505,
    k_EHTTPStatusCode5xxUnknown = 599,
}
pub type HTTPRequestHandle = uint32;
pub type HTTPCookieContainerHandle = uint32;
#[repr(C)]
pub struct ISteamHTTP__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamHTTP {
    pub vtable_: *const ISteamHTTP__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamHTTP() {
    assert_eq!(
        ::std::mem::size_of::<ISteamHTTP>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamHTTP))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamHTTP>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamHTTP))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTTPRequestCompleted_t {
    pub m_hRequest: HTTPRequestHandle,
    pub m_ulContextValue: uint64,
    pub m_bRequestSuccessful: bool,
    pub m_eStatusCode: EHTTPStatusCode,
    pub m_unBodySize: uint32,
}
pub const HTTPRequestCompleted_t_k_iCallback: HTTPRequestCompleted_t__bindgen_ty_1 =
    HTTPRequestCompleted_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTTPRequestCompleted_t__bindgen_ty_1 {
    k_iCallback = 2101,
}
#[test]
fn bindgen_test_layout_HTTPRequestCompleted_t() {
    assert_eq!(
        ::std::mem::size_of::<HTTPRequestCompleted_t>(),
        32usize,
        concat!("Size of: ", stringify!(HTTPRequestCompleted_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTTPRequestCompleted_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTTPRequestCompleted_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTTPRequestCompleted_t>())).m_hRequest as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTTPRequestCompleted_t),
            "::",
            stringify!(m_hRequest)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTTPRequestCompleted_t>())).m_ulContextValue as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTTPRequestCompleted_t),
            "::",
            stringify!(m_ulContextValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTTPRequestCompleted_t>())).m_bRequestSuccessful as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(HTTPRequestCompleted_t),
            "::",
            stringify!(m_bRequestSuccessful)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTTPRequestCompleted_t>())).m_eStatusCode as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(HTTPRequestCompleted_t),
            "::",
            stringify!(m_eStatusCode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTTPRequestCompleted_t>())).m_unBodySize as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(HTTPRequestCompleted_t),
            "::",
            stringify!(m_unBodySize)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTTPRequestHeadersReceived_t {
    pub m_hRequest: HTTPRequestHandle,
    pub m_ulContextValue: uint64,
}
pub const HTTPRequestHeadersReceived_t_k_iCallback: HTTPRequestHeadersReceived_t__bindgen_ty_1 =
    HTTPRequestHeadersReceived_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTTPRequestHeadersReceived_t__bindgen_ty_1 {
    k_iCallback = 2102,
}
#[test]
fn bindgen_test_layout_HTTPRequestHeadersReceived_t() {
    assert_eq!(
        ::std::mem::size_of::<HTTPRequestHeadersReceived_t>(),
        16usize,
        concat!("Size of: ", stringify!(HTTPRequestHeadersReceived_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTTPRequestHeadersReceived_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTTPRequestHeadersReceived_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTTPRequestHeadersReceived_t>())).m_hRequest as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTTPRequestHeadersReceived_t),
            "::",
            stringify!(m_hRequest)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTTPRequestHeadersReceived_t>())).m_ulContextValue as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTTPRequestHeadersReceived_t),
            "::",
            stringify!(m_ulContextValue)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTTPRequestDataReceived_t {
    pub m_hRequest: HTTPRequestHandle,
    pub m_ulContextValue: uint64,
    pub m_cOffset: uint32,
    pub m_cBytesReceived: uint32,
}
pub const HTTPRequestDataReceived_t_k_iCallback: HTTPRequestDataReceived_t__bindgen_ty_1 =
    HTTPRequestDataReceived_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTTPRequestDataReceived_t__bindgen_ty_1 {
    k_iCallback = 2103,
}
#[test]
fn bindgen_test_layout_HTTPRequestDataReceived_t() {
    assert_eq!(
        ::std::mem::size_of::<HTTPRequestDataReceived_t>(),
        24usize,
        concat!("Size of: ", stringify!(HTTPRequestDataReceived_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTTPRequestDataReceived_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTTPRequestDataReceived_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTTPRequestDataReceived_t>())).m_hRequest as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTTPRequestDataReceived_t),
            "::",
            stringify!(m_hRequest)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTTPRequestDataReceived_t>())).m_ulContextValue as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTTPRequestDataReceived_t),
            "::",
            stringify!(m_ulContextValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTTPRequestDataReceived_t>())).m_cOffset as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(HTTPRequestDataReceived_t),
            "::",
            stringify!(m_cOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTTPRequestDataReceived_t>())).m_cBytesReceived as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(HTTPRequestDataReceived_t),
            "::",
            stringify!(m_cBytesReceived)
        )
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EInputSourceMode {
    k_EInputSourceMode_None = 0,
    k_EInputSourceMode_Dpad = 1,
    k_EInputSourceMode_Buttons = 2,
    k_EInputSourceMode_FourButtons = 3,
    k_EInputSourceMode_AbsoluteMouse = 4,
    k_EInputSourceMode_RelativeMouse = 5,
    k_EInputSourceMode_JoystickMove = 6,
    k_EInputSourceMode_JoystickMouse = 7,
    k_EInputSourceMode_JoystickCamera = 8,
    k_EInputSourceMode_ScrollWheel = 9,
    k_EInputSourceMode_Trigger = 10,
    k_EInputSourceMode_TouchMenu = 11,
    k_EInputSourceMode_MouseJoystick = 12,
    k_EInputSourceMode_MouseRegion = 13,
    k_EInputSourceMode_RadialMenu = 14,
    k_EInputSourceMode_SingleButton = 15,
    k_EInputSourceMode_Switches = 16,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EInputActionOrigin {
    k_EInputActionOrigin_None = 0,
    k_EInputActionOrigin_SteamController_A = 1,
    k_EInputActionOrigin_SteamController_B = 2,
    k_EInputActionOrigin_SteamController_X = 3,
    k_EInputActionOrigin_SteamController_Y = 4,
    k_EInputActionOrigin_SteamController_LeftBumper = 5,
    k_EInputActionOrigin_SteamController_RightBumper = 6,
    k_EInputActionOrigin_SteamController_LeftGrip = 7,
    k_EInputActionOrigin_SteamController_RightGrip = 8,
    k_EInputActionOrigin_SteamController_Start = 9,
    k_EInputActionOrigin_SteamController_Back = 10,
    k_EInputActionOrigin_SteamController_LeftPad_Touch = 11,
    k_EInputActionOrigin_SteamController_LeftPad_Swipe = 12,
    k_EInputActionOrigin_SteamController_LeftPad_Click = 13,
    k_EInputActionOrigin_SteamController_LeftPad_DPadNorth = 14,
    k_EInputActionOrigin_SteamController_LeftPad_DPadSouth = 15,
    k_EInputActionOrigin_SteamController_LeftPad_DPadWest = 16,
    k_EInputActionOrigin_SteamController_LeftPad_DPadEast = 17,
    k_EInputActionOrigin_SteamController_RightPad_Touch = 18,
    k_EInputActionOrigin_SteamController_RightPad_Swipe = 19,
    k_EInputActionOrigin_SteamController_RightPad_Click = 20,
    k_EInputActionOrigin_SteamController_RightPad_DPadNorth = 21,
    k_EInputActionOrigin_SteamController_RightPad_DPadSouth = 22,
    k_EInputActionOrigin_SteamController_RightPad_DPadWest = 23,
    k_EInputActionOrigin_SteamController_RightPad_DPadEast = 24,
    k_EInputActionOrigin_SteamController_LeftTrigger_Pull = 25,
    k_EInputActionOrigin_SteamController_LeftTrigger_Click = 26,
    k_EInputActionOrigin_SteamController_RightTrigger_Pull = 27,
    k_EInputActionOrigin_SteamController_RightTrigger_Click = 28,
    k_EInputActionOrigin_SteamController_LeftStick_Move = 29,
    k_EInputActionOrigin_SteamController_LeftStick_Click = 30,
    k_EInputActionOrigin_SteamController_LeftStick_DPadNorth = 31,
    k_EInputActionOrigin_SteamController_LeftStick_DPadSouth = 32,
    k_EInputActionOrigin_SteamController_LeftStick_DPadWest = 33,
    k_EInputActionOrigin_SteamController_LeftStick_DPadEast = 34,
    k_EInputActionOrigin_SteamController_Gyro_Move = 35,
    k_EInputActionOrigin_SteamController_Gyro_Pitch = 36,
    k_EInputActionOrigin_SteamController_Gyro_Yaw = 37,
    k_EInputActionOrigin_SteamController_Gyro_Roll = 38,
    k_EInputActionOrigin_SteamController_Reserved0 = 39,
    k_EInputActionOrigin_SteamController_Reserved1 = 40,
    k_EInputActionOrigin_SteamController_Reserved2 = 41,
    k_EInputActionOrigin_SteamController_Reserved3 = 42,
    k_EInputActionOrigin_SteamController_Reserved4 = 43,
    k_EInputActionOrigin_SteamController_Reserved5 = 44,
    k_EInputActionOrigin_SteamController_Reserved6 = 45,
    k_EInputActionOrigin_SteamController_Reserved7 = 46,
    k_EInputActionOrigin_SteamController_Reserved8 = 47,
    k_EInputActionOrigin_SteamController_Reserved9 = 48,
    k_EInputActionOrigin_SteamController_Reserved10 = 49,
    k_EInputActionOrigin_PS4_X = 50,
    k_EInputActionOrigin_PS4_Circle = 51,
    k_EInputActionOrigin_PS4_Triangle = 52,
    k_EInputActionOrigin_PS4_Square = 53,
    k_EInputActionOrigin_PS4_LeftBumper = 54,
    k_EInputActionOrigin_PS4_RightBumper = 55,
    k_EInputActionOrigin_PS4_Options = 56,
    k_EInputActionOrigin_PS4_Share = 57,
    k_EInputActionOrigin_PS4_LeftPad_Touch = 58,
    k_EInputActionOrigin_PS4_LeftPad_Swipe = 59,
    k_EInputActionOrigin_PS4_LeftPad_Click = 60,
    k_EInputActionOrigin_PS4_LeftPad_DPadNorth = 61,
    k_EInputActionOrigin_PS4_LeftPad_DPadSouth = 62,
    k_EInputActionOrigin_PS4_LeftPad_DPadWest = 63,
    k_EInputActionOrigin_PS4_LeftPad_DPadEast = 64,
    k_EInputActionOrigin_PS4_RightPad_Touch = 65,
    k_EInputActionOrigin_PS4_RightPad_Swipe = 66,
    k_EInputActionOrigin_PS4_RightPad_Click = 67,
    k_EInputActionOrigin_PS4_RightPad_DPadNorth = 68,
    k_EInputActionOrigin_PS4_RightPad_DPadSouth = 69,
    k_EInputActionOrigin_PS4_RightPad_DPadWest = 70,
    k_EInputActionOrigin_PS4_RightPad_DPadEast = 71,
    k_EInputActionOrigin_PS4_CenterPad_Touch = 72,
    k_EInputActionOrigin_PS4_CenterPad_Swipe = 73,
    k_EInputActionOrigin_PS4_CenterPad_Click = 74,
    k_EInputActionOrigin_PS4_CenterPad_DPadNorth = 75,
    k_EInputActionOrigin_PS4_CenterPad_DPadSouth = 76,
    k_EInputActionOrigin_PS4_CenterPad_DPadWest = 77,
    k_EInputActionOrigin_PS4_CenterPad_DPadEast = 78,
    k_EInputActionOrigin_PS4_LeftTrigger_Pull = 79,
    k_EInputActionOrigin_PS4_LeftTrigger_Click = 80,
    k_EInputActionOrigin_PS4_RightTrigger_Pull = 81,
    k_EInputActionOrigin_PS4_RightTrigger_Click = 82,
    k_EInputActionOrigin_PS4_LeftStick_Move = 83,
    k_EInputActionOrigin_PS4_LeftStick_Click = 84,
    k_EInputActionOrigin_PS4_LeftStick_DPadNorth = 85,
    k_EInputActionOrigin_PS4_LeftStick_DPadSouth = 86,
    k_EInputActionOrigin_PS4_LeftStick_DPadWest = 87,
    k_EInputActionOrigin_PS4_LeftStick_DPadEast = 88,
    k_EInputActionOrigin_PS4_RightStick_Move = 89,
    k_EInputActionOrigin_PS4_RightStick_Click = 90,
    k_EInputActionOrigin_PS4_RightStick_DPadNorth = 91,
    k_EInputActionOrigin_PS4_RightStick_DPadSouth = 92,
    k_EInputActionOrigin_PS4_RightStick_DPadWest = 93,
    k_EInputActionOrigin_PS4_RightStick_DPadEast = 94,
    k_EInputActionOrigin_PS4_DPad_North = 95,
    k_EInputActionOrigin_PS4_DPad_South = 96,
    k_EInputActionOrigin_PS4_DPad_West = 97,
    k_EInputActionOrigin_PS4_DPad_East = 98,
    k_EInputActionOrigin_PS4_Gyro_Move = 99,
    k_EInputActionOrigin_PS4_Gyro_Pitch = 100,
    k_EInputActionOrigin_PS4_Gyro_Yaw = 101,
    k_EInputActionOrigin_PS4_Gyro_Roll = 102,
    k_EInputActionOrigin_PS4_DPad_Move = 103,
    k_EInputActionOrigin_PS4_Reserved1 = 104,
    k_EInputActionOrigin_PS4_Reserved2 = 105,
    k_EInputActionOrigin_PS4_Reserved3 = 106,
    k_EInputActionOrigin_PS4_Reserved4 = 107,
    k_EInputActionOrigin_PS4_Reserved5 = 108,
    k_EInputActionOrigin_PS4_Reserved6 = 109,
    k_EInputActionOrigin_PS4_Reserved7 = 110,
    k_EInputActionOrigin_PS4_Reserved8 = 111,
    k_EInputActionOrigin_PS4_Reserved9 = 112,
    k_EInputActionOrigin_PS4_Reserved10 = 113,
    k_EInputActionOrigin_XBoxOne_A = 114,
    k_EInputActionOrigin_XBoxOne_B = 115,
    k_EInputActionOrigin_XBoxOne_X = 116,
    k_EInputActionOrigin_XBoxOne_Y = 117,
    k_EInputActionOrigin_XBoxOne_LeftBumper = 118,
    k_EInputActionOrigin_XBoxOne_RightBumper = 119,
    k_EInputActionOrigin_XBoxOne_Menu = 120,
    k_EInputActionOrigin_XBoxOne_View = 121,
    k_EInputActionOrigin_XBoxOne_LeftTrigger_Pull = 122,
    k_EInputActionOrigin_XBoxOne_LeftTrigger_Click = 123,
    k_EInputActionOrigin_XBoxOne_RightTrigger_Pull = 124,
    k_EInputActionOrigin_XBoxOne_RightTrigger_Click = 125,
    k_EInputActionOrigin_XBoxOne_LeftStick_Move = 126,
    k_EInputActionOrigin_XBoxOne_LeftStick_Click = 127,
    k_EInputActionOrigin_XBoxOne_LeftStick_DPadNorth = 128,
    k_EInputActionOrigin_XBoxOne_LeftStick_DPadSouth = 129,
    k_EInputActionOrigin_XBoxOne_LeftStick_DPadWest = 130,
    k_EInputActionOrigin_XBoxOne_LeftStick_DPadEast = 131,
    k_EInputActionOrigin_XBoxOne_RightStick_Move = 132,
    k_EInputActionOrigin_XBoxOne_RightStick_Click = 133,
    k_EInputActionOrigin_XBoxOne_RightStick_DPadNorth = 134,
    k_EInputActionOrigin_XBoxOne_RightStick_DPadSouth = 135,
    k_EInputActionOrigin_XBoxOne_RightStick_DPadWest = 136,
    k_EInputActionOrigin_XBoxOne_RightStick_DPadEast = 137,
    k_EInputActionOrigin_XBoxOne_DPad_North = 138,
    k_EInputActionOrigin_XBoxOne_DPad_South = 139,
    k_EInputActionOrigin_XBoxOne_DPad_West = 140,
    k_EInputActionOrigin_XBoxOne_DPad_East = 141,
    k_EInputActionOrigin_XBoxOne_DPad_Move = 142,
    k_EInputActionOrigin_XBoxOne_Reserved1 = 143,
    k_EInputActionOrigin_XBoxOne_Reserved2 = 144,
    k_EInputActionOrigin_XBoxOne_Reserved3 = 145,
    k_EInputActionOrigin_XBoxOne_Reserved4 = 146,
    k_EInputActionOrigin_XBoxOne_Reserved5 = 147,
    k_EInputActionOrigin_XBoxOne_Reserved6 = 148,
    k_EInputActionOrigin_XBoxOne_Reserved7 = 149,
    k_EInputActionOrigin_XBoxOne_Reserved8 = 150,
    k_EInputActionOrigin_XBoxOne_Reserved9 = 151,
    k_EInputActionOrigin_XBoxOne_Reserved10 = 152,
    k_EInputActionOrigin_XBox360_A = 153,
    k_EInputActionOrigin_XBox360_B = 154,
    k_EInputActionOrigin_XBox360_X = 155,
    k_EInputActionOrigin_XBox360_Y = 156,
    k_EInputActionOrigin_XBox360_LeftBumper = 157,
    k_EInputActionOrigin_XBox360_RightBumper = 158,
    k_EInputActionOrigin_XBox360_Start = 159,
    k_EInputActionOrigin_XBox360_Back = 160,
    k_EInputActionOrigin_XBox360_LeftTrigger_Pull = 161,
    k_EInputActionOrigin_XBox360_LeftTrigger_Click = 162,
    k_EInputActionOrigin_XBox360_RightTrigger_Pull = 163,
    k_EInputActionOrigin_XBox360_RightTrigger_Click = 164,
    k_EInputActionOrigin_XBox360_LeftStick_Move = 165,
    k_EInputActionOrigin_XBox360_LeftStick_Click = 166,
    k_EInputActionOrigin_XBox360_LeftStick_DPadNorth = 167,
    k_EInputActionOrigin_XBox360_LeftStick_DPadSouth = 168,
    k_EInputActionOrigin_XBox360_LeftStick_DPadWest = 169,
    k_EInputActionOrigin_XBox360_LeftStick_DPadEast = 170,
    k_EInputActionOrigin_XBox360_RightStick_Move = 171,
    k_EInputActionOrigin_XBox360_RightStick_Click = 172,
    k_EInputActionOrigin_XBox360_RightStick_DPadNorth = 173,
    k_EInputActionOrigin_XBox360_RightStick_DPadSouth = 174,
    k_EInputActionOrigin_XBox360_RightStick_DPadWest = 175,
    k_EInputActionOrigin_XBox360_RightStick_DPadEast = 176,
    k_EInputActionOrigin_XBox360_DPad_North = 177,
    k_EInputActionOrigin_XBox360_DPad_South = 178,
    k_EInputActionOrigin_XBox360_DPad_West = 179,
    k_EInputActionOrigin_XBox360_DPad_East = 180,
    k_EInputActionOrigin_XBox360_DPad_Move = 181,
    k_EInputActionOrigin_XBox360_Reserved1 = 182,
    k_EInputActionOrigin_XBox360_Reserved2 = 183,
    k_EInputActionOrigin_XBox360_Reserved3 = 184,
    k_EInputActionOrigin_XBox360_Reserved4 = 185,
    k_EInputActionOrigin_XBox360_Reserved5 = 186,
    k_EInputActionOrigin_XBox360_Reserved6 = 187,
    k_EInputActionOrigin_XBox360_Reserved7 = 188,
    k_EInputActionOrigin_XBox360_Reserved8 = 189,
    k_EInputActionOrigin_XBox360_Reserved9 = 190,
    k_EInputActionOrigin_XBox360_Reserved10 = 191,
    k_EInputActionOrigin_Switch_A = 192,
    k_EInputActionOrigin_Switch_B = 193,
    k_EInputActionOrigin_Switch_X = 194,
    k_EInputActionOrigin_Switch_Y = 195,
    k_EInputActionOrigin_Switch_LeftBumper = 196,
    k_EInputActionOrigin_Switch_RightBumper = 197,
    k_EInputActionOrigin_Switch_Plus = 198,
    k_EInputActionOrigin_Switch_Minus = 199,
    k_EInputActionOrigin_Switch_Capture = 200,
    k_EInputActionOrigin_Switch_LeftTrigger_Pull = 201,
    k_EInputActionOrigin_Switch_LeftTrigger_Click = 202,
    k_EInputActionOrigin_Switch_RightTrigger_Pull = 203,
    k_EInputActionOrigin_Switch_RightTrigger_Click = 204,
    k_EInputActionOrigin_Switch_LeftStick_Move = 205,
    k_EInputActionOrigin_Switch_LeftStick_Click = 206,
    k_EInputActionOrigin_Switch_LeftStick_DPadNorth = 207,
    k_EInputActionOrigin_Switch_LeftStick_DPadSouth = 208,
    k_EInputActionOrigin_Switch_LeftStick_DPadWest = 209,
    k_EInputActionOrigin_Switch_LeftStick_DPadEast = 210,
    k_EInputActionOrigin_Switch_RightStick_Move = 211,
    k_EInputActionOrigin_Switch_RightStick_Click = 212,
    k_EInputActionOrigin_Switch_RightStick_DPadNorth = 213,
    k_EInputActionOrigin_Switch_RightStick_DPadSouth = 214,
    k_EInputActionOrigin_Switch_RightStick_DPadWest = 215,
    k_EInputActionOrigin_Switch_RightStick_DPadEast = 216,
    k_EInputActionOrigin_Switch_DPad_North = 217,
    k_EInputActionOrigin_Switch_DPad_South = 218,
    k_EInputActionOrigin_Switch_DPad_West = 219,
    k_EInputActionOrigin_Switch_DPad_East = 220,
    k_EInputActionOrigin_Switch_ProGyro_Move = 221,
    k_EInputActionOrigin_Switch_ProGyro_Pitch = 222,
    k_EInputActionOrigin_Switch_ProGyro_Yaw = 223,
    k_EInputActionOrigin_Switch_ProGyro_Roll = 224,
    k_EInputActionOrigin_Switch_DPad_Move = 225,
    k_EInputActionOrigin_Switch_Reserved1 = 226,
    k_EInputActionOrigin_Switch_Reserved2 = 227,
    k_EInputActionOrigin_Switch_Reserved3 = 228,
    k_EInputActionOrigin_Switch_Reserved4 = 229,
    k_EInputActionOrigin_Switch_Reserved5 = 230,
    k_EInputActionOrigin_Switch_Reserved6 = 231,
    k_EInputActionOrigin_Switch_Reserved7 = 232,
    k_EInputActionOrigin_Switch_Reserved8 = 233,
    k_EInputActionOrigin_Switch_Reserved9 = 234,
    k_EInputActionOrigin_Switch_Reserved10 = 235,
    k_EInputActionOrigin_Switch_RightGyro_Move = 236,
    k_EInputActionOrigin_Switch_RightGyro_Pitch = 237,
    k_EInputActionOrigin_Switch_RightGyro_Yaw = 238,
    k_EInputActionOrigin_Switch_RightGyro_Roll = 239,
    k_EInputActionOrigin_Switch_LeftGyro_Move = 240,
    k_EInputActionOrigin_Switch_LeftGyro_Pitch = 241,
    k_EInputActionOrigin_Switch_LeftGyro_Yaw = 242,
    k_EInputActionOrigin_Switch_LeftGyro_Roll = 243,
    k_EInputActionOrigin_Switch_LeftGrip_Lower = 244,
    k_EInputActionOrigin_Switch_LeftGrip_Upper = 245,
    k_EInputActionOrigin_Switch_RightGrip_Lower = 246,
    k_EInputActionOrigin_Switch_RightGrip_Upper = 247,
    k_EInputActionOrigin_Switch_Reserved11 = 248,
    k_EInputActionOrigin_Switch_Reserved12 = 249,
    k_EInputActionOrigin_Switch_Reserved13 = 250,
    k_EInputActionOrigin_Switch_Reserved14 = 251,
    k_EInputActionOrigin_Switch_Reserved15 = 252,
    k_EInputActionOrigin_Switch_Reserved16 = 253,
    k_EInputActionOrigin_Switch_Reserved17 = 254,
    k_EInputActionOrigin_Switch_Reserved18 = 255,
    k_EInputActionOrigin_Switch_Reserved19 = 256,
    k_EInputActionOrigin_Switch_Reserved20 = 257,
    k_EInputActionOrigin_PS5_X = 258,
    k_EInputActionOrigin_PS5_Circle = 259,
    k_EInputActionOrigin_PS5_Triangle = 260,
    k_EInputActionOrigin_PS5_Square = 261,
    k_EInputActionOrigin_PS5_LeftBumper = 262,
    k_EInputActionOrigin_PS5_RightBumper = 263,
    k_EInputActionOrigin_PS5_Option = 264,
    k_EInputActionOrigin_PS5_Create = 265,
    k_EInputActionOrigin_PS5_Mute = 266,
    k_EInputActionOrigin_PS5_LeftPad_Touch = 267,
    k_EInputActionOrigin_PS5_LeftPad_Swipe = 268,
    k_EInputActionOrigin_PS5_LeftPad_Click = 269,
    k_EInputActionOrigin_PS5_LeftPad_DPadNorth = 270,
    k_EInputActionOrigin_PS5_LeftPad_DPadSouth = 271,
    k_EInputActionOrigin_PS5_LeftPad_DPadWest = 272,
    k_EInputActionOrigin_PS5_LeftPad_DPadEast = 273,
    k_EInputActionOrigin_PS5_RightPad_Touch = 274,
    k_EInputActionOrigin_PS5_RightPad_Swipe = 275,
    k_EInputActionOrigin_PS5_RightPad_Click = 276,
    k_EInputActionOrigin_PS5_RightPad_DPadNorth = 277,
    k_EInputActionOrigin_PS5_RightPad_DPadSouth = 278,
    k_EInputActionOrigin_PS5_RightPad_DPadWest = 279,
    k_EInputActionOrigin_PS5_RightPad_DPadEast = 280,
    k_EInputActionOrigin_PS5_CenterPad_Touch = 281,
    k_EInputActionOrigin_PS5_CenterPad_Swipe = 282,
    k_EInputActionOrigin_PS5_CenterPad_Click = 283,
    k_EInputActionOrigin_PS5_CenterPad_DPadNorth = 284,
    k_EInputActionOrigin_PS5_CenterPad_DPadSouth = 285,
    k_EInputActionOrigin_PS5_CenterPad_DPadWest = 286,
    k_EInputActionOrigin_PS5_CenterPad_DPadEast = 287,
    k_EInputActionOrigin_PS5_LeftTrigger_Pull = 288,
    k_EInputActionOrigin_PS5_LeftTrigger_Click = 289,
    k_EInputActionOrigin_PS5_RightTrigger_Pull = 290,
    k_EInputActionOrigin_PS5_RightTrigger_Click = 291,
    k_EInputActionOrigin_PS5_LeftStick_Move = 292,
    k_EInputActionOrigin_PS5_LeftStick_Click = 293,
    k_EInputActionOrigin_PS5_LeftStick_DPadNorth = 294,
    k_EInputActionOrigin_PS5_LeftStick_DPadSouth = 295,
    k_EInputActionOrigin_PS5_LeftStick_DPadWest = 296,
    k_EInputActionOrigin_PS5_LeftStick_DPadEast = 297,
    k_EInputActionOrigin_PS5_RightStick_Move = 298,
    k_EInputActionOrigin_PS5_RightStick_Click = 299,
    k_EInputActionOrigin_PS5_RightStick_DPadNorth = 300,
    k_EInputActionOrigin_PS5_RightStick_DPadSouth = 301,
    k_EInputActionOrigin_PS5_RightStick_DPadWest = 302,
    k_EInputActionOrigin_PS5_RightStick_DPadEast = 303,
    k_EInputActionOrigin_PS5_DPad_North = 304,
    k_EInputActionOrigin_PS5_DPad_South = 305,
    k_EInputActionOrigin_PS5_DPad_West = 306,
    k_EInputActionOrigin_PS5_DPad_East = 307,
    k_EInputActionOrigin_PS5_Gyro_Move = 308,
    k_EInputActionOrigin_PS5_Gyro_Pitch = 309,
    k_EInputActionOrigin_PS5_Gyro_Yaw = 310,
    k_EInputActionOrigin_PS5_Gyro_Roll = 311,
    k_EInputActionOrigin_PS5_DPad_Move = 312,
    k_EInputActionOrigin_PS5_Reserved1 = 313,
    k_EInputActionOrigin_PS5_Reserved2 = 314,
    k_EInputActionOrigin_PS5_Reserved3 = 315,
    k_EInputActionOrigin_PS5_Reserved4 = 316,
    k_EInputActionOrigin_PS5_Reserved5 = 317,
    k_EInputActionOrigin_PS5_Reserved6 = 318,
    k_EInputActionOrigin_PS5_Reserved7 = 319,
    k_EInputActionOrigin_PS5_Reserved8 = 320,
    k_EInputActionOrigin_PS5_Reserved9 = 321,
    k_EInputActionOrigin_PS5_Reserved10 = 322,
    k_EInputActionOrigin_PS5_Reserved11 = 323,
    k_EInputActionOrigin_PS5_Reserved12 = 324,
    k_EInputActionOrigin_PS5_Reserved13 = 325,
    k_EInputActionOrigin_PS5_Reserved14 = 326,
    k_EInputActionOrigin_PS5_Reserved15 = 327,
    k_EInputActionOrigin_PS5_Reserved16 = 328,
    k_EInputActionOrigin_PS5_Reserved17 = 329,
    k_EInputActionOrigin_PS5_Reserved18 = 330,
    k_EInputActionOrigin_PS5_Reserved19 = 331,
    k_EInputActionOrigin_PS5_Reserved20 = 332,
    k_EInputActionOrigin_Count = 333,
    k_EInputActionOrigin_MaximumPossibleValue = 32767,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EXboxOrigin {
    k_EXboxOrigin_A = 0,
    k_EXboxOrigin_B = 1,
    k_EXboxOrigin_X = 2,
    k_EXboxOrigin_Y = 3,
    k_EXboxOrigin_LeftBumper = 4,
    k_EXboxOrigin_RightBumper = 5,
    k_EXboxOrigin_Menu = 6,
    k_EXboxOrigin_View = 7,
    k_EXboxOrigin_LeftTrigger_Pull = 8,
    k_EXboxOrigin_LeftTrigger_Click = 9,
    k_EXboxOrigin_RightTrigger_Pull = 10,
    k_EXboxOrigin_RightTrigger_Click = 11,
    k_EXboxOrigin_LeftStick_Move = 12,
    k_EXboxOrigin_LeftStick_Click = 13,
    k_EXboxOrigin_LeftStick_DPadNorth = 14,
    k_EXboxOrigin_LeftStick_DPadSouth = 15,
    k_EXboxOrigin_LeftStick_DPadWest = 16,
    k_EXboxOrigin_LeftStick_DPadEast = 17,
    k_EXboxOrigin_RightStick_Move = 18,
    k_EXboxOrigin_RightStick_Click = 19,
    k_EXboxOrigin_RightStick_DPadNorth = 20,
    k_EXboxOrigin_RightStick_DPadSouth = 21,
    k_EXboxOrigin_RightStick_DPadWest = 22,
    k_EXboxOrigin_RightStick_DPadEast = 23,
    k_EXboxOrigin_DPad_North = 24,
    k_EXboxOrigin_DPad_South = 25,
    k_EXboxOrigin_DPad_West = 26,
    k_EXboxOrigin_DPad_East = 27,
    k_EXboxOrigin_Count = 28,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamControllerPad {
    k_ESteamControllerPad_Left = 0,
    k_ESteamControllerPad_Right = 1,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamInputType {
    k_ESteamInputType_Unknown = 0,
    k_ESteamInputType_SteamController = 1,
    k_ESteamInputType_XBox360Controller = 2,
    k_ESteamInputType_XBoxOneController = 3,
    k_ESteamInputType_GenericGamepad = 4,
    k_ESteamInputType_PS4Controller = 5,
    k_ESteamInputType_AppleMFiController = 6,
    k_ESteamInputType_AndroidController = 7,
    k_ESteamInputType_SwitchJoyConPair = 8,
    k_ESteamInputType_SwitchJoyConSingle = 9,
    k_ESteamInputType_SwitchProController = 10,
    k_ESteamInputType_MobileTouch = 11,
    k_ESteamInputType_PS3Controller = 12,
    k_ESteamInputType_PS5Controller = 13,
    k_ESteamInputType_Count = 14,
    k_ESteamInputType_MaximumPossibleValue = 255,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamInputLEDFlag {
    k_ESteamInputLEDFlag_SetColor = 0,
    k_ESteamInputLEDFlag_RestoreUserDefault = 1,
}
pub type InputHandle_t = uint64;
pub type InputActionSetHandle_t = uint64;
pub type InputDigitalActionHandle_t = uint64;
pub type InputAnalogActionHandle_t = uint64;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct InputAnalogActionData_t {
    pub eMode: EInputSourceMode,
    pub x: f32,
    pub y: f32,
    pub bActive: bool,
}
#[test]
fn bindgen_test_layout_InputAnalogActionData_t() {
    assert_eq!(
        ::std::mem::size_of::<InputAnalogActionData_t>(),
        13usize,
        concat!("Size of: ", stringify!(InputAnalogActionData_t))
    );
    assert_eq!(
        ::std::mem::align_of::<InputAnalogActionData_t>(),
        1usize,
        concat!("Alignment of ", stringify!(InputAnalogActionData_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<InputAnalogActionData_t>())).eMode as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(InputAnalogActionData_t),
            "::",
            stringify!(eMode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<InputAnalogActionData_t>())).x as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(InputAnalogActionData_t),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<InputAnalogActionData_t>())).y as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(InputAnalogActionData_t),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<InputAnalogActionData_t>())).bActive as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(InputAnalogActionData_t),
            "::",
            stringify!(bActive)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct InputDigitalActionData_t {
    pub bState: bool,
    pub bActive: bool,
}
#[test]
fn bindgen_test_layout_InputDigitalActionData_t() {
    assert_eq!(
        ::std::mem::size_of::<InputDigitalActionData_t>(),
        2usize,
        concat!("Size of: ", stringify!(InputDigitalActionData_t))
    );
    assert_eq!(
        ::std::mem::align_of::<InputDigitalActionData_t>(),
        1usize,
        concat!("Alignment of ", stringify!(InputDigitalActionData_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<InputDigitalActionData_t>())).bState as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(InputDigitalActionData_t),
            "::",
            stringify!(bState)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<InputDigitalActionData_t>())).bActive as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(InputDigitalActionData_t),
            "::",
            stringify!(bActive)
        )
    );
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct InputMotionData_t {
    pub rotQuatX: f32,
    pub rotQuatY: f32,
    pub rotQuatZ: f32,
    pub rotQuatW: f32,
    pub posAccelX: f32,
    pub posAccelY: f32,
    pub posAccelZ: f32,
    pub rotVelX: f32,
    pub rotVelY: f32,
    pub rotVelZ: f32,
}
#[test]
fn bindgen_test_layout_InputMotionData_t() {
    assert_eq!(
        ::std::mem::size_of::<InputMotionData_t>(),
        40usize,
        concat!("Size of: ", stringify!(InputMotionData_t))
    );
    assert_eq!(
        ::std::mem::align_of::<InputMotionData_t>(),
        1usize,
        concat!("Alignment of ", stringify!(InputMotionData_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<InputMotionData_t>())).rotQuatX as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(InputMotionData_t),
            "::",
            stringify!(rotQuatX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<InputMotionData_t>())).rotQuatY as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(InputMotionData_t),
            "::",
            stringify!(rotQuatY)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<InputMotionData_t>())).rotQuatZ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(InputMotionData_t),
            "::",
            stringify!(rotQuatZ)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<InputMotionData_t>())).rotQuatW as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(InputMotionData_t),
            "::",
            stringify!(rotQuatW)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<InputMotionData_t>())).posAccelX as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(InputMotionData_t),
            "::",
            stringify!(posAccelX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<InputMotionData_t>())).posAccelY as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(InputMotionData_t),
            "::",
            stringify!(posAccelY)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<InputMotionData_t>())).posAccelZ as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(InputMotionData_t),
            "::",
            stringify!(posAccelZ)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<InputMotionData_t>())).rotVelX as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(InputMotionData_t),
            "::",
            stringify!(rotVelX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<InputMotionData_t>())).rotVelY as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(InputMotionData_t),
            "::",
            stringify!(rotVelY)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<InputMotionData_t>())).rotVelZ as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(InputMotionData_t),
            "::",
            stringify!(rotVelZ)
        )
    );
}
#[repr(C)]
pub struct ISteamInput__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamInput {
    pub vtable_: *const ISteamInput__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamInput() {
    assert_eq!(
        ::std::mem::size_of::<ISteamInput>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamInput))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamInput>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamInput))
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EControllerActionOrigin {
    k_EControllerActionOrigin_None = 0,
    k_EControllerActionOrigin_A = 1,
    k_EControllerActionOrigin_B = 2,
    k_EControllerActionOrigin_X = 3,
    k_EControllerActionOrigin_Y = 4,
    k_EControllerActionOrigin_LeftBumper = 5,
    k_EControllerActionOrigin_RightBumper = 6,
    k_EControllerActionOrigin_LeftGrip = 7,
    k_EControllerActionOrigin_RightGrip = 8,
    k_EControllerActionOrigin_Start = 9,
    k_EControllerActionOrigin_Back = 10,
    k_EControllerActionOrigin_LeftPad_Touch = 11,
    k_EControllerActionOrigin_LeftPad_Swipe = 12,
    k_EControllerActionOrigin_LeftPad_Click = 13,
    k_EControllerActionOrigin_LeftPad_DPadNorth = 14,
    k_EControllerActionOrigin_LeftPad_DPadSouth = 15,
    k_EControllerActionOrigin_LeftPad_DPadWest = 16,
    k_EControllerActionOrigin_LeftPad_DPadEast = 17,
    k_EControllerActionOrigin_RightPad_Touch = 18,
    k_EControllerActionOrigin_RightPad_Swipe = 19,
    k_EControllerActionOrigin_RightPad_Click = 20,
    k_EControllerActionOrigin_RightPad_DPadNorth = 21,
    k_EControllerActionOrigin_RightPad_DPadSouth = 22,
    k_EControllerActionOrigin_RightPad_DPadWest = 23,
    k_EControllerActionOrigin_RightPad_DPadEast = 24,
    k_EControllerActionOrigin_LeftTrigger_Pull = 25,
    k_EControllerActionOrigin_LeftTrigger_Click = 26,
    k_EControllerActionOrigin_RightTrigger_Pull = 27,
    k_EControllerActionOrigin_RightTrigger_Click = 28,
    k_EControllerActionOrigin_LeftStick_Move = 29,
    k_EControllerActionOrigin_LeftStick_Click = 30,
    k_EControllerActionOrigin_LeftStick_DPadNorth = 31,
    k_EControllerActionOrigin_LeftStick_DPadSouth = 32,
    k_EControllerActionOrigin_LeftStick_DPadWest = 33,
    k_EControllerActionOrigin_LeftStick_DPadEast = 34,
    k_EControllerActionOrigin_Gyro_Move = 35,
    k_EControllerActionOrigin_Gyro_Pitch = 36,
    k_EControllerActionOrigin_Gyro_Yaw = 37,
    k_EControllerActionOrigin_Gyro_Roll = 38,
    k_EControllerActionOrigin_PS4_X = 39,
    k_EControllerActionOrigin_PS4_Circle = 40,
    k_EControllerActionOrigin_PS4_Triangle = 41,
    k_EControllerActionOrigin_PS4_Square = 42,
    k_EControllerActionOrigin_PS4_LeftBumper = 43,
    k_EControllerActionOrigin_PS4_RightBumper = 44,
    k_EControllerActionOrigin_PS4_Options = 45,
    k_EControllerActionOrigin_PS4_Share = 46,
    k_EControllerActionOrigin_PS4_LeftPad_Touch = 47,
    k_EControllerActionOrigin_PS4_LeftPad_Swipe = 48,
    k_EControllerActionOrigin_PS4_LeftPad_Click = 49,
    k_EControllerActionOrigin_PS4_LeftPad_DPadNorth = 50,
    k_EControllerActionOrigin_PS4_LeftPad_DPadSouth = 51,
    k_EControllerActionOrigin_PS4_LeftPad_DPadWest = 52,
    k_EControllerActionOrigin_PS4_LeftPad_DPadEast = 53,
    k_EControllerActionOrigin_PS4_RightPad_Touch = 54,
    k_EControllerActionOrigin_PS4_RightPad_Swipe = 55,
    k_EControllerActionOrigin_PS4_RightPad_Click = 56,
    k_EControllerActionOrigin_PS4_RightPad_DPadNorth = 57,
    k_EControllerActionOrigin_PS4_RightPad_DPadSouth = 58,
    k_EControllerActionOrigin_PS4_RightPad_DPadWest = 59,
    k_EControllerActionOrigin_PS4_RightPad_DPadEast = 60,
    k_EControllerActionOrigin_PS4_CenterPad_Touch = 61,
    k_EControllerActionOrigin_PS4_CenterPad_Swipe = 62,
    k_EControllerActionOrigin_PS4_CenterPad_Click = 63,
    k_EControllerActionOrigin_PS4_CenterPad_DPadNorth = 64,
    k_EControllerActionOrigin_PS4_CenterPad_DPadSouth = 65,
    k_EControllerActionOrigin_PS4_CenterPad_DPadWest = 66,
    k_EControllerActionOrigin_PS4_CenterPad_DPadEast = 67,
    k_EControllerActionOrigin_PS4_LeftTrigger_Pull = 68,
    k_EControllerActionOrigin_PS4_LeftTrigger_Click = 69,
    k_EControllerActionOrigin_PS4_RightTrigger_Pull = 70,
    k_EControllerActionOrigin_PS4_RightTrigger_Click = 71,
    k_EControllerActionOrigin_PS4_LeftStick_Move = 72,
    k_EControllerActionOrigin_PS4_LeftStick_Click = 73,
    k_EControllerActionOrigin_PS4_LeftStick_DPadNorth = 74,
    k_EControllerActionOrigin_PS4_LeftStick_DPadSouth = 75,
    k_EControllerActionOrigin_PS4_LeftStick_DPadWest = 76,
    k_EControllerActionOrigin_PS4_LeftStick_DPadEast = 77,
    k_EControllerActionOrigin_PS4_RightStick_Move = 78,
    k_EControllerActionOrigin_PS4_RightStick_Click = 79,
    k_EControllerActionOrigin_PS4_RightStick_DPadNorth = 80,
    k_EControllerActionOrigin_PS4_RightStick_DPadSouth = 81,
    k_EControllerActionOrigin_PS4_RightStick_DPadWest = 82,
    k_EControllerActionOrigin_PS4_RightStick_DPadEast = 83,
    k_EControllerActionOrigin_PS4_DPad_North = 84,
    k_EControllerActionOrigin_PS4_DPad_South = 85,
    k_EControllerActionOrigin_PS4_DPad_West = 86,
    k_EControllerActionOrigin_PS4_DPad_East = 87,
    k_EControllerActionOrigin_PS4_Gyro_Move = 88,
    k_EControllerActionOrigin_PS4_Gyro_Pitch = 89,
    k_EControllerActionOrigin_PS4_Gyro_Yaw = 90,
    k_EControllerActionOrigin_PS4_Gyro_Roll = 91,
    k_EControllerActionOrigin_XBoxOne_A = 92,
    k_EControllerActionOrigin_XBoxOne_B = 93,
    k_EControllerActionOrigin_XBoxOne_X = 94,
    k_EControllerActionOrigin_XBoxOne_Y = 95,
    k_EControllerActionOrigin_XBoxOne_LeftBumper = 96,
    k_EControllerActionOrigin_XBoxOne_RightBumper = 97,
    k_EControllerActionOrigin_XBoxOne_Menu = 98,
    k_EControllerActionOrigin_XBoxOne_View = 99,
    k_EControllerActionOrigin_XBoxOne_LeftTrigger_Pull = 100,
    k_EControllerActionOrigin_XBoxOne_LeftTrigger_Click = 101,
    k_EControllerActionOrigin_XBoxOne_RightTrigger_Pull = 102,
    k_EControllerActionOrigin_XBoxOne_RightTrigger_Click = 103,
    k_EControllerActionOrigin_XBoxOne_LeftStick_Move = 104,
    k_EControllerActionOrigin_XBoxOne_LeftStick_Click = 105,
    k_EControllerActionOrigin_XBoxOne_LeftStick_DPadNorth = 106,
    k_EControllerActionOrigin_XBoxOne_LeftStick_DPadSouth = 107,
    k_EControllerActionOrigin_XBoxOne_LeftStick_DPadWest = 108,
    k_EControllerActionOrigin_XBoxOne_LeftStick_DPadEast = 109,
    k_EControllerActionOrigin_XBoxOne_RightStick_Move = 110,
    k_EControllerActionOrigin_XBoxOne_RightStick_Click = 111,
    k_EControllerActionOrigin_XBoxOne_RightStick_DPadNorth = 112,
    k_EControllerActionOrigin_XBoxOne_RightStick_DPadSouth = 113,
    k_EControllerActionOrigin_XBoxOne_RightStick_DPadWest = 114,
    k_EControllerActionOrigin_XBoxOne_RightStick_DPadEast = 115,
    k_EControllerActionOrigin_XBoxOne_DPad_North = 116,
    k_EControllerActionOrigin_XBoxOne_DPad_South = 117,
    k_EControllerActionOrigin_XBoxOne_DPad_West = 118,
    k_EControllerActionOrigin_XBoxOne_DPad_East = 119,
    k_EControllerActionOrigin_XBox360_A = 120,
    k_EControllerActionOrigin_XBox360_B = 121,
    k_EControllerActionOrigin_XBox360_X = 122,
    k_EControllerActionOrigin_XBox360_Y = 123,
    k_EControllerActionOrigin_XBox360_LeftBumper = 124,
    k_EControllerActionOrigin_XBox360_RightBumper = 125,
    k_EControllerActionOrigin_XBox360_Start = 126,
    k_EControllerActionOrigin_XBox360_Back = 127,
    k_EControllerActionOrigin_XBox360_LeftTrigger_Pull = 128,
    k_EControllerActionOrigin_XBox360_LeftTrigger_Click = 129,
    k_EControllerActionOrigin_XBox360_RightTrigger_Pull = 130,
    k_EControllerActionOrigin_XBox360_RightTrigger_Click = 131,
    k_EControllerActionOrigin_XBox360_LeftStick_Move = 132,
    k_EControllerActionOrigin_XBox360_LeftStick_Click = 133,
    k_EControllerActionOrigin_XBox360_LeftStick_DPadNorth = 134,
    k_EControllerActionOrigin_XBox360_LeftStick_DPadSouth = 135,
    k_EControllerActionOrigin_XBox360_LeftStick_DPadWest = 136,
    k_EControllerActionOrigin_XBox360_LeftStick_DPadEast = 137,
    k_EControllerActionOrigin_XBox360_RightStick_Move = 138,
    k_EControllerActionOrigin_XBox360_RightStick_Click = 139,
    k_EControllerActionOrigin_XBox360_RightStick_DPadNorth = 140,
    k_EControllerActionOrigin_XBox360_RightStick_DPadSouth = 141,
    k_EControllerActionOrigin_XBox360_RightStick_DPadWest = 142,
    k_EControllerActionOrigin_XBox360_RightStick_DPadEast = 143,
    k_EControllerActionOrigin_XBox360_DPad_North = 144,
    k_EControllerActionOrigin_XBox360_DPad_South = 145,
    k_EControllerActionOrigin_XBox360_DPad_West = 146,
    k_EControllerActionOrigin_XBox360_DPad_East = 147,
    k_EControllerActionOrigin_SteamV2_A = 148,
    k_EControllerActionOrigin_SteamV2_B = 149,
    k_EControllerActionOrigin_SteamV2_X = 150,
    k_EControllerActionOrigin_SteamV2_Y = 151,
    k_EControllerActionOrigin_SteamV2_LeftBumper = 152,
    k_EControllerActionOrigin_SteamV2_RightBumper = 153,
    k_EControllerActionOrigin_SteamV2_LeftGrip_Lower = 154,
    k_EControllerActionOrigin_SteamV2_LeftGrip_Upper = 155,
    k_EControllerActionOrigin_SteamV2_RightGrip_Lower = 156,
    k_EControllerActionOrigin_SteamV2_RightGrip_Upper = 157,
    k_EControllerActionOrigin_SteamV2_LeftBumper_Pressure = 158,
    k_EControllerActionOrigin_SteamV2_RightBumper_Pressure = 159,
    k_EControllerActionOrigin_SteamV2_LeftGrip_Pressure = 160,
    k_EControllerActionOrigin_SteamV2_RightGrip_Pressure = 161,
    k_EControllerActionOrigin_SteamV2_LeftGrip_Upper_Pressure = 162,
    k_EControllerActionOrigin_SteamV2_RightGrip_Upper_Pressure = 163,
    k_EControllerActionOrigin_SteamV2_Start = 164,
    k_EControllerActionOrigin_SteamV2_Back = 165,
    k_EControllerActionOrigin_SteamV2_LeftPad_Touch = 166,
    k_EControllerActionOrigin_SteamV2_LeftPad_Swipe = 167,
    k_EControllerActionOrigin_SteamV2_LeftPad_Click = 168,
    k_EControllerActionOrigin_SteamV2_LeftPad_Pressure = 169,
    k_EControllerActionOrigin_SteamV2_LeftPad_DPadNorth = 170,
    k_EControllerActionOrigin_SteamV2_LeftPad_DPadSouth = 171,
    k_EControllerActionOrigin_SteamV2_LeftPad_DPadWest = 172,
    k_EControllerActionOrigin_SteamV2_LeftPad_DPadEast = 173,
    k_EControllerActionOrigin_SteamV2_RightPad_Touch = 174,
    k_EControllerActionOrigin_SteamV2_RightPad_Swipe = 175,
    k_EControllerActionOrigin_SteamV2_RightPad_Click = 176,
    k_EControllerActionOrigin_SteamV2_RightPad_Pressure = 177,
    k_EControllerActionOrigin_SteamV2_RightPad_DPadNorth = 178,
    k_EControllerActionOrigin_SteamV2_RightPad_DPadSouth = 179,
    k_EControllerActionOrigin_SteamV2_RightPad_DPadWest = 180,
    k_EControllerActionOrigin_SteamV2_RightPad_DPadEast = 181,
    k_EControllerActionOrigin_SteamV2_LeftTrigger_Pull = 182,
    k_EControllerActionOrigin_SteamV2_LeftTrigger_Click = 183,
    k_EControllerActionOrigin_SteamV2_RightTrigger_Pull = 184,
    k_EControllerActionOrigin_SteamV2_RightTrigger_Click = 185,
    k_EControllerActionOrigin_SteamV2_LeftStick_Move = 186,
    k_EControllerActionOrigin_SteamV2_LeftStick_Click = 187,
    k_EControllerActionOrigin_SteamV2_LeftStick_DPadNorth = 188,
    k_EControllerActionOrigin_SteamV2_LeftStick_DPadSouth = 189,
    k_EControllerActionOrigin_SteamV2_LeftStick_DPadWest = 190,
    k_EControllerActionOrigin_SteamV2_LeftStick_DPadEast = 191,
    k_EControllerActionOrigin_SteamV2_Gyro_Move = 192,
    k_EControllerActionOrigin_SteamV2_Gyro_Pitch = 193,
    k_EControllerActionOrigin_SteamV2_Gyro_Yaw = 194,
    k_EControllerActionOrigin_SteamV2_Gyro_Roll = 195,
    k_EControllerActionOrigin_Switch_A = 196,
    k_EControllerActionOrigin_Switch_B = 197,
    k_EControllerActionOrigin_Switch_X = 198,
    k_EControllerActionOrigin_Switch_Y = 199,
    k_EControllerActionOrigin_Switch_LeftBumper = 200,
    k_EControllerActionOrigin_Switch_RightBumper = 201,
    k_EControllerActionOrigin_Switch_Plus = 202,
    k_EControllerActionOrigin_Switch_Minus = 203,
    k_EControllerActionOrigin_Switch_Capture = 204,
    k_EControllerActionOrigin_Switch_LeftTrigger_Pull = 205,
    k_EControllerActionOrigin_Switch_LeftTrigger_Click = 206,
    k_EControllerActionOrigin_Switch_RightTrigger_Pull = 207,
    k_EControllerActionOrigin_Switch_RightTrigger_Click = 208,
    k_EControllerActionOrigin_Switch_LeftStick_Move = 209,
    k_EControllerActionOrigin_Switch_LeftStick_Click = 210,
    k_EControllerActionOrigin_Switch_LeftStick_DPadNorth = 211,
    k_EControllerActionOrigin_Switch_LeftStick_DPadSouth = 212,
    k_EControllerActionOrigin_Switch_LeftStick_DPadWest = 213,
    k_EControllerActionOrigin_Switch_LeftStick_DPadEast = 214,
    k_EControllerActionOrigin_Switch_RightStick_Move = 215,
    k_EControllerActionOrigin_Switch_RightStick_Click = 216,
    k_EControllerActionOrigin_Switch_RightStick_DPadNorth = 217,
    k_EControllerActionOrigin_Switch_RightStick_DPadSouth = 218,
    k_EControllerActionOrigin_Switch_RightStick_DPadWest = 219,
    k_EControllerActionOrigin_Switch_RightStick_DPadEast = 220,
    k_EControllerActionOrigin_Switch_DPad_North = 221,
    k_EControllerActionOrigin_Switch_DPad_South = 222,
    k_EControllerActionOrigin_Switch_DPad_West = 223,
    k_EControllerActionOrigin_Switch_DPad_East = 224,
    k_EControllerActionOrigin_Switch_ProGyro_Move = 225,
    k_EControllerActionOrigin_Switch_ProGyro_Pitch = 226,
    k_EControllerActionOrigin_Switch_ProGyro_Yaw = 227,
    k_EControllerActionOrigin_Switch_ProGyro_Roll = 228,
    k_EControllerActionOrigin_Switch_RightGyro_Move = 229,
    k_EControllerActionOrigin_Switch_RightGyro_Pitch = 230,
    k_EControllerActionOrigin_Switch_RightGyro_Yaw = 231,
    k_EControllerActionOrigin_Switch_RightGyro_Roll = 232,
    k_EControllerActionOrigin_Switch_LeftGyro_Move = 233,
    k_EControllerActionOrigin_Switch_LeftGyro_Pitch = 234,
    k_EControllerActionOrigin_Switch_LeftGyro_Yaw = 235,
    k_EControllerActionOrigin_Switch_LeftGyro_Roll = 236,
    k_EControllerActionOrigin_Switch_LeftGrip_Lower = 237,
    k_EControllerActionOrigin_Switch_LeftGrip_Upper = 238,
    k_EControllerActionOrigin_Switch_RightGrip_Lower = 239,
    k_EControllerActionOrigin_Switch_RightGrip_Upper = 240,
    k_EControllerActionOrigin_PS4_DPad_Move = 241,
    k_EControllerActionOrigin_XBoxOne_DPad_Move = 242,
    k_EControllerActionOrigin_XBox360_DPad_Move = 243,
    k_EControllerActionOrigin_Switch_DPad_Move = 244,
    k_EControllerActionOrigin_PS5_X = 245,
    k_EControllerActionOrigin_PS5_Circle = 246,
    k_EControllerActionOrigin_PS5_Triangle = 247,
    k_EControllerActionOrigin_PS5_Square = 248,
    k_EControllerActionOrigin_PS5_LeftBumper = 249,
    k_EControllerActionOrigin_PS5_RightBumper = 250,
    k_EControllerActionOrigin_PS5_Option = 251,
    k_EControllerActionOrigin_PS5_Create = 252,
    k_EControllerActionOrigin_PS5_Mute = 253,
    k_EControllerActionOrigin_PS5_LeftPad_Touch = 254,
    k_EControllerActionOrigin_PS5_LeftPad_Swipe = 255,
    k_EControllerActionOrigin_PS5_LeftPad_Click = 256,
    k_EControllerActionOrigin_PS5_LeftPad_DPadNorth = 257,
    k_EControllerActionOrigin_PS5_LeftPad_DPadSouth = 258,
    k_EControllerActionOrigin_PS5_LeftPad_DPadWest = 259,
    k_EControllerActionOrigin_PS5_LeftPad_DPadEast = 260,
    k_EControllerActionOrigin_PS5_RightPad_Touch = 261,
    k_EControllerActionOrigin_PS5_RightPad_Swipe = 262,
    k_EControllerActionOrigin_PS5_RightPad_Click = 263,
    k_EControllerActionOrigin_PS5_RightPad_DPadNorth = 264,
    k_EControllerActionOrigin_PS5_RightPad_DPadSouth = 265,
    k_EControllerActionOrigin_PS5_RightPad_DPadWest = 266,
    k_EControllerActionOrigin_PS5_RightPad_DPadEast = 267,
    k_EControllerActionOrigin_PS5_CenterPad_Touch = 268,
    k_EControllerActionOrigin_PS5_CenterPad_Swipe = 269,
    k_EControllerActionOrigin_PS5_CenterPad_Click = 270,
    k_EControllerActionOrigin_PS5_CenterPad_DPadNorth = 271,
    k_EControllerActionOrigin_PS5_CenterPad_DPadSouth = 272,
    k_EControllerActionOrigin_PS5_CenterPad_DPadWest = 273,
    k_EControllerActionOrigin_PS5_CenterPad_DPadEast = 274,
    k_EControllerActionOrigin_PS5_LeftTrigger_Pull = 275,
    k_EControllerActionOrigin_PS5_LeftTrigger_Click = 276,
    k_EControllerActionOrigin_PS5_RightTrigger_Pull = 277,
    k_EControllerActionOrigin_PS5_RightTrigger_Click = 278,
    k_EControllerActionOrigin_PS5_LeftStick_Move = 279,
    k_EControllerActionOrigin_PS5_LeftStick_Click = 280,
    k_EControllerActionOrigin_PS5_LeftStick_DPadNorth = 281,
    k_EControllerActionOrigin_PS5_LeftStick_DPadSouth = 282,
    k_EControllerActionOrigin_PS5_LeftStick_DPadWest = 283,
    k_EControllerActionOrigin_PS5_LeftStick_DPadEast = 284,
    k_EControllerActionOrigin_PS5_RightStick_Move = 285,
    k_EControllerActionOrigin_PS5_RightStick_Click = 286,
    k_EControllerActionOrigin_PS5_RightStick_DPadNorth = 287,
    k_EControllerActionOrigin_PS5_RightStick_DPadSouth = 288,
    k_EControllerActionOrigin_PS5_RightStick_DPadWest = 289,
    k_EControllerActionOrigin_PS5_RightStick_DPadEast = 290,
    k_EControllerActionOrigin_PS5_DPad_Move = 291,
    k_EControllerActionOrigin_PS5_DPad_North = 292,
    k_EControllerActionOrigin_PS5_DPad_South = 293,
    k_EControllerActionOrigin_PS5_DPad_West = 294,
    k_EControllerActionOrigin_PS5_DPad_East = 295,
    k_EControllerActionOrigin_PS5_Gyro_Move = 296,
    k_EControllerActionOrigin_PS5_Gyro_Pitch = 297,
    k_EControllerActionOrigin_PS5_Gyro_Yaw = 298,
    k_EControllerActionOrigin_PS5_Gyro_Roll = 299,
    k_EControllerActionOrigin_Count = 300,
    k_EControllerActionOrigin_MaximumPossibleValue = 32767,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamControllerLEDFlag {
    k_ESteamControllerLEDFlag_SetColor = 0,
    k_ESteamControllerLEDFlag_RestoreUserDefault = 1,
}
pub type ControllerHandle_t = uint64;
pub type ControllerActionSetHandle_t = uint64;
pub type ControllerDigitalActionHandle_t = uint64;
pub type ControllerAnalogActionHandle_t = uint64;
#[repr(C)]
pub struct ISteamController__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamController {
    pub vtable_: *const ISteamController__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamController() {
    assert_eq!(
        ::std::mem::size_of::<ISteamController>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamController))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamController>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamController))
    );
}
pub type UGCQueryHandle_t = uint64;
pub type UGCUpdateHandle_t = uint64;
pub const k_UGCQueryHandleInvalid: UGCQueryHandle_t = 18446744073709551615;
pub const k_UGCUpdateHandleInvalid: UGCUpdateHandle_t = 18446744073709551615;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EUGCMatchingUGCType {
    k_EUGCMatchingUGCType_Items = 0,
    k_EUGCMatchingUGCType_Items_Mtx = 1,
    k_EUGCMatchingUGCType_Items_ReadyToUse = 2,
    k_EUGCMatchingUGCType_Collections = 3,
    k_EUGCMatchingUGCType_Artwork = 4,
    k_EUGCMatchingUGCType_Videos = 5,
    k_EUGCMatchingUGCType_Screenshots = 6,
    k_EUGCMatchingUGCType_AllGuides = 7,
    k_EUGCMatchingUGCType_WebGuides = 8,
    k_EUGCMatchingUGCType_IntegratedGuides = 9,
    k_EUGCMatchingUGCType_UsableInGame = 10,
    k_EUGCMatchingUGCType_ControllerBindings = 11,
    k_EUGCMatchingUGCType_GameManagedItems = 12,
    k_EUGCMatchingUGCType_All = -1,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EUserUGCList {
    k_EUserUGCList_Published = 0,
    k_EUserUGCList_VotedOn = 1,
    k_EUserUGCList_VotedUp = 2,
    k_EUserUGCList_VotedDown = 3,
    k_EUserUGCList_WillVoteLater = 4,
    k_EUserUGCList_Favorited = 5,
    k_EUserUGCList_Subscribed = 6,
    k_EUserUGCList_UsedOrPlayed = 7,
    k_EUserUGCList_Followed = 8,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EUserUGCListSortOrder {
    k_EUserUGCListSortOrder_CreationOrderDesc = 0,
    k_EUserUGCListSortOrder_CreationOrderAsc = 1,
    k_EUserUGCListSortOrder_TitleAsc = 2,
    k_EUserUGCListSortOrder_LastUpdatedDesc = 3,
    k_EUserUGCListSortOrder_SubscriptionDateDesc = 4,
    k_EUserUGCListSortOrder_VoteScoreDesc = 5,
    k_EUserUGCListSortOrder_ForModeration = 6,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EUGCQuery {
    k_EUGCQuery_RankedByVote = 0,
    k_EUGCQuery_RankedByPublicationDate = 1,
    k_EUGCQuery_AcceptedForGameRankedByAcceptanceDate = 2,
    k_EUGCQuery_RankedByTrend = 3,
    k_EUGCQuery_FavoritedByFriendsRankedByPublicationDate = 4,
    k_EUGCQuery_CreatedByFriendsRankedByPublicationDate = 5,
    k_EUGCQuery_RankedByNumTimesReported = 6,
    k_EUGCQuery_CreatedByFollowedUsersRankedByPublicationDate = 7,
    k_EUGCQuery_NotYetRated = 8,
    k_EUGCQuery_RankedByTotalVotesAsc = 9,
    k_EUGCQuery_RankedByVotesUp = 10,
    k_EUGCQuery_RankedByTextSearch = 11,
    k_EUGCQuery_RankedByTotalUniqueSubscriptions = 12,
    k_EUGCQuery_RankedByPlaytimeTrend = 13,
    k_EUGCQuery_RankedByTotalPlaytime = 14,
    k_EUGCQuery_RankedByAveragePlaytimeTrend = 15,
    k_EUGCQuery_RankedByLifetimeAveragePlaytime = 16,
    k_EUGCQuery_RankedByPlaytimeSessionsTrend = 17,
    k_EUGCQuery_RankedByLifetimePlaytimeSessions = 18,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EItemUpdateStatus {
    k_EItemUpdateStatusInvalid = 0,
    k_EItemUpdateStatusPreparingConfig = 1,
    k_EItemUpdateStatusPreparingContent = 2,
    k_EItemUpdateStatusUploadingContent = 3,
    k_EItemUpdateStatusUploadingPreviewFile = 4,
    k_EItemUpdateStatusCommittingChanges = 5,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EItemState {
    k_EItemStateNone = 0,
    k_EItemStateSubscribed = 1,
    k_EItemStateLegacyItem = 2,
    k_EItemStateInstalled = 4,
    k_EItemStateNeedsUpdate = 8,
    k_EItemStateDownloading = 16,
    k_EItemStateDownloadPending = 32,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EItemStatistic {
    k_EItemStatistic_NumSubscriptions = 0,
    k_EItemStatistic_NumFavorites = 1,
    k_EItemStatistic_NumFollowers = 2,
    k_EItemStatistic_NumUniqueSubscriptions = 3,
    k_EItemStatistic_NumUniqueFavorites = 4,
    k_EItemStatistic_NumUniqueFollowers = 5,
    k_EItemStatistic_NumUniqueWebsiteViews = 6,
    k_EItemStatistic_ReportScore = 7,
    k_EItemStatistic_NumSecondsPlayed = 8,
    k_EItemStatistic_NumPlaytimeSessions = 9,
    k_EItemStatistic_NumComments = 10,
    k_EItemStatistic_NumSecondsPlayedDuringTimePeriod = 11,
    k_EItemStatistic_NumPlaytimeSessionsDuringTimePeriod = 12,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EItemPreviewType {
    k_EItemPreviewType_Image = 0,
    k_EItemPreviewType_YouTubeVideo = 1,
    k_EItemPreviewType_Sketchfab = 2,
    k_EItemPreviewType_EnvironmentMap_HorizontalCross = 3,
    k_EItemPreviewType_EnvironmentMap_LatLong = 4,
    k_EItemPreviewType_ReservedMax = 255,
}
pub const kNumUGCResultsPerPage: uint32 = 50;
pub const k_cchDeveloperMetadataMax: uint32 = 5000;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SteamUGCDetails_t {
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_eResult: EResult,
    pub m_eFileType: EWorkshopFileType,
    pub m_nCreatorAppID: AppId_t,
    pub m_nConsumerAppID: AppId_t,
    pub m_rgchTitle: [::std::os::raw::c_char; 129usize],
    pub m_rgchDescription: [::std::os::raw::c_char; 8000usize],
    pub m_ulSteamIDOwner: uint64,
    pub m_rtimeCreated: uint32,
    pub m_rtimeUpdated: uint32,
    pub m_rtimeAddedToUserList: uint32,
    pub m_eVisibility: ERemoteStoragePublishedFileVisibility,
    pub m_bBanned: bool,
    pub m_bAcceptedForUse: bool,
    pub m_bTagsTruncated: bool,
    pub m_rgchTags: [::std::os::raw::c_char; 1025usize],
    pub m_hFile: UGCHandle_t,
    pub m_hPreviewFile: UGCHandle_t,
    pub m_pchFileName: [::std::os::raw::c_char; 260usize],
    pub m_nFileSize: int32,
    pub m_nPreviewFileSize: int32,
    pub m_rgchURL: [::std::os::raw::c_char; 256usize],
    pub m_unVotesUp: uint32,
    pub m_unVotesDown: uint32,
    pub m_flScore: f32,
    pub m_unNumChildren: uint32,
}
#[test]
fn bindgen_test_layout_SteamUGCDetails_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamUGCDetails_t>(),
        9776usize,
        concat!("Size of: ", stringify!(SteamUGCDetails_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamUGCDetails_t>(),
        8usize,
        concat!("Alignment of ", stringify!(SteamUGCDetails_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_nPublishedFileId as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_eResult as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_eFileType as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_eFileType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_nCreatorAppID as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_nCreatorAppID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_nConsumerAppID as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_nConsumerAppID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_rgchTitle as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_rgchTitle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_rgchDescription as *const _ as usize
        },
        153usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_rgchDescription)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_ulSteamIDOwner as *const _ as usize
        },
        8160usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_ulSteamIDOwner)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_rtimeCreated as *const _ as usize
        },
        8168usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_rtimeCreated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_rtimeUpdated as *const _ as usize
        },
        8172usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_rtimeUpdated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_rtimeAddedToUserList as *const _
                as usize
        },
        8176usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_rtimeAddedToUserList)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_eVisibility as *const _ as usize },
        8180usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_eVisibility)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_bBanned as *const _ as usize },
        8184usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_bBanned)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_bAcceptedForUse as *const _ as usize
        },
        8185usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_bAcceptedForUse)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_bTagsTruncated as *const _ as usize
        },
        8186usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_bTagsTruncated)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_rgchTags as *const _ as usize },
        8187usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_rgchTags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_hFile as *const _ as usize },
        9216usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_hFile)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_hPreviewFile as *const _ as usize
        },
        9224usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_hPreviewFile)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_pchFileName as *const _ as usize },
        9232usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_pchFileName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_nFileSize as *const _ as usize },
        9492usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_nFileSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_nPreviewFileSize as *const _ as usize
        },
        9496usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_nPreviewFileSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_rgchURL as *const _ as usize },
        9500usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_rgchURL)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_unVotesUp as *const _ as usize },
        9756usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_unVotesUp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_unVotesDown as *const _ as usize },
        9760usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_unVotesDown)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_flScore as *const _ as usize },
        9764usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_flScore)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCDetails_t>())).m_unNumChildren as *const _ as usize
        },
        9768usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCDetails_t),
            "::",
            stringify!(m_unNumChildren)
        )
    );
}
#[repr(C)]
pub struct ISteamUGC__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamUGC {
    pub vtable_: *const ISteamUGC__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamUGC() {
    assert_eq!(
        ::std::mem::size_of::<ISteamUGC>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamUGC))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamUGC>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamUGC))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SteamUGCQueryCompleted_t {
    pub m_handle: UGCQueryHandle_t,
    pub m_eResult: EResult,
    pub m_unNumResultsReturned: uint32,
    pub m_unTotalMatchingResults: uint32,
    pub m_bCachedData: bool,
    pub m_rgchNextCursor: [::std::os::raw::c_char; 256usize],
}
pub const SteamUGCQueryCompleted_t_k_iCallback: SteamUGCQueryCompleted_t__bindgen_ty_1 =
    SteamUGCQueryCompleted_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamUGCQueryCompleted_t__bindgen_ty_1 {
    k_iCallback = 3401,
}
#[test]
fn bindgen_test_layout_SteamUGCQueryCompleted_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamUGCQueryCompleted_t>(),
        280usize,
        concat!("Size of: ", stringify!(SteamUGCQueryCompleted_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamUGCQueryCompleted_t>(),
        8usize,
        concat!("Alignment of ", stringify!(SteamUGCQueryCompleted_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCQueryCompleted_t>())).m_handle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCQueryCompleted_t),
            "::",
            stringify!(m_handle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCQueryCompleted_t>())).m_eResult as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCQueryCompleted_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCQueryCompleted_t>())).m_unNumResultsReturned as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCQueryCompleted_t),
            "::",
            stringify!(m_unNumResultsReturned)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCQueryCompleted_t>())).m_unTotalMatchingResults
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCQueryCompleted_t),
            "::",
            stringify!(m_unTotalMatchingResults)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCQueryCompleted_t>())).m_bCachedData as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCQueryCompleted_t),
            "::",
            stringify!(m_bCachedData)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCQueryCompleted_t>())).m_rgchNextCursor as *const _
                as usize
        },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCQueryCompleted_t),
            "::",
            stringify!(m_rgchNextCursor)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SteamUGCRequestUGCDetailsResult_t {
    pub m_details: SteamUGCDetails_t,
    pub m_bCachedData: bool,
}
pub const SteamUGCRequestUGCDetailsResult_t_k_iCallback:
    SteamUGCRequestUGCDetailsResult_t__bindgen_ty_1 =
    SteamUGCRequestUGCDetailsResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamUGCRequestUGCDetailsResult_t__bindgen_ty_1 {
    k_iCallback = 3402,
}
#[test]
fn bindgen_test_layout_SteamUGCRequestUGCDetailsResult_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamUGCRequestUGCDetailsResult_t>(),
        9784usize,
        concat!("Size of: ", stringify!(SteamUGCRequestUGCDetailsResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamUGCRequestUGCDetailsResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(SteamUGCRequestUGCDetailsResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCRequestUGCDetailsResult_t>())).m_details as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCRequestUGCDetailsResult_t),
            "::",
            stringify!(m_details)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamUGCRequestUGCDetailsResult_t>())).m_bCachedData as *const _
                as usize
        },
        9776usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamUGCRequestUGCDetailsResult_t),
            "::",
            stringify!(m_bCachedData)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CreateItemResult_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_bUserNeedsToAcceptWorkshopLegalAgreement: bool,
}
pub const CreateItemResult_t_k_iCallback: CreateItemResult_t__bindgen_ty_1 =
    CreateItemResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum CreateItemResult_t__bindgen_ty_1 {
    k_iCallback = 3403,
}
#[test]
fn bindgen_test_layout_CreateItemResult_t() {
    assert_eq!(
        ::std::mem::size_of::<CreateItemResult_t>(),
        24usize,
        concat!("Size of: ", stringify!(CreateItemResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<CreateItemResult_t>(),
        8usize,
        concat!("Alignment of ", stringify!(CreateItemResult_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<CreateItemResult_t>())).m_eResult as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(CreateItemResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CreateItemResult_t>())).m_nPublishedFileId as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(CreateItemResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<CreateItemResult_t>()))
                .m_bUserNeedsToAcceptWorkshopLegalAgreement as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(CreateItemResult_t),
            "::",
            stringify!(m_bUserNeedsToAcceptWorkshopLegalAgreement)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SubmitItemUpdateResult_t {
    pub m_eResult: EResult,
    pub m_bUserNeedsToAcceptWorkshopLegalAgreement: bool,
    pub m_nPublishedFileId: PublishedFileId_t,
}
pub const SubmitItemUpdateResult_t_k_iCallback: SubmitItemUpdateResult_t__bindgen_ty_1 =
    SubmitItemUpdateResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SubmitItemUpdateResult_t__bindgen_ty_1 {
    k_iCallback = 3404,
}
#[test]
fn bindgen_test_layout_SubmitItemUpdateResult_t() {
    assert_eq!(
        ::std::mem::size_of::<SubmitItemUpdateResult_t>(),
        16usize,
        concat!("Size of: ", stringify!(SubmitItemUpdateResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SubmitItemUpdateResult_t>(),
        8usize,
        concat!("Alignment of ", stringify!(SubmitItemUpdateResult_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SubmitItemUpdateResult_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SubmitItemUpdateResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SubmitItemUpdateResult_t>()))
                .m_bUserNeedsToAcceptWorkshopLegalAgreement as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(SubmitItemUpdateResult_t),
            "::",
            stringify!(m_bUserNeedsToAcceptWorkshopLegalAgreement)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SubmitItemUpdateResult_t>())).m_nPublishedFileId as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SubmitItemUpdateResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ItemInstalled_t {
    pub m_unAppID: AppId_t,
    pub m_nPublishedFileId: PublishedFileId_t,
}
pub const ItemInstalled_t_k_iCallback: ItemInstalled_t__bindgen_ty_1 =
    ItemInstalled_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ItemInstalled_t__bindgen_ty_1 {
    k_iCallback = 3405,
}
#[test]
fn bindgen_test_layout_ItemInstalled_t() {
    assert_eq!(
        ::std::mem::size_of::<ItemInstalled_t>(),
        16usize,
        concat!("Size of: ", stringify!(ItemInstalled_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ItemInstalled_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ItemInstalled_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ItemInstalled_t>())).m_unAppID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ItemInstalled_t),
            "::",
            stringify!(m_unAppID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ItemInstalled_t>())).m_nPublishedFileId as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ItemInstalled_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DownloadItemResult_t {
    pub m_unAppID: AppId_t,
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_eResult: EResult,
}
pub const DownloadItemResult_t_k_iCallback: DownloadItemResult_t__bindgen_ty_1 =
    DownloadItemResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum DownloadItemResult_t__bindgen_ty_1 {
    k_iCallback = 3406,
}
#[test]
fn bindgen_test_layout_DownloadItemResult_t() {
    assert_eq!(
        ::std::mem::size_of::<DownloadItemResult_t>(),
        24usize,
        concat!("Size of: ", stringify!(DownloadItemResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<DownloadItemResult_t>(),
        8usize,
        concat!("Alignment of ", stringify!(DownloadItemResult_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DownloadItemResult_t>())).m_unAppID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(DownloadItemResult_t),
            "::",
            stringify!(m_unAppID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<DownloadItemResult_t>())).m_nPublishedFileId as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(DownloadItemResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DownloadItemResult_t>())).m_eResult as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(DownloadItemResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct UserFavoriteItemsListChanged_t {
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_eResult: EResult,
    pub m_bWasAddRequest: bool,
}
pub const UserFavoriteItemsListChanged_t_k_iCallback: UserFavoriteItemsListChanged_t__bindgen_ty_1 =
    UserFavoriteItemsListChanged_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum UserFavoriteItemsListChanged_t__bindgen_ty_1 {
    k_iCallback = 3407,
}
#[test]
fn bindgen_test_layout_UserFavoriteItemsListChanged_t() {
    assert_eq!(
        ::std::mem::size_of::<UserFavoriteItemsListChanged_t>(),
        16usize,
        concat!("Size of: ", stringify!(UserFavoriteItemsListChanged_t))
    );
    assert_eq!(
        ::std::mem::align_of::<UserFavoriteItemsListChanged_t>(),
        8usize,
        concat!("Alignment of ", stringify!(UserFavoriteItemsListChanged_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<UserFavoriteItemsListChanged_t>())).m_nPublishedFileId
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(UserFavoriteItemsListChanged_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<UserFavoriteItemsListChanged_t>())).m_eResult as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(UserFavoriteItemsListChanged_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<UserFavoriteItemsListChanged_t>())).m_bWasAddRequest as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(UserFavoriteItemsListChanged_t),
            "::",
            stringify!(m_bWasAddRequest)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SetUserItemVoteResult_t {
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_eResult: EResult,
    pub m_bVoteUp: bool,
}
pub const SetUserItemVoteResult_t_k_iCallback: SetUserItemVoteResult_t__bindgen_ty_1 =
    SetUserItemVoteResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SetUserItemVoteResult_t__bindgen_ty_1 {
    k_iCallback = 3408,
}
#[test]
fn bindgen_test_layout_SetUserItemVoteResult_t() {
    assert_eq!(
        ::std::mem::size_of::<SetUserItemVoteResult_t>(),
        16usize,
        concat!("Size of: ", stringify!(SetUserItemVoteResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SetUserItemVoteResult_t>(),
        8usize,
        concat!("Alignment of ", stringify!(SetUserItemVoteResult_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SetUserItemVoteResult_t>())).m_nPublishedFileId as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SetUserItemVoteResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SetUserItemVoteResult_t>())).m_eResult as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SetUserItemVoteResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SetUserItemVoteResult_t>())).m_bVoteUp as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(SetUserItemVoteResult_t),
            "::",
            stringify!(m_bVoteUp)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GetUserItemVoteResult_t {
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_eResult: EResult,
    pub m_bVotedUp: bool,
    pub m_bVotedDown: bool,
    pub m_bVoteSkipped: bool,
}
pub const GetUserItemVoteResult_t_k_iCallback: GetUserItemVoteResult_t__bindgen_ty_1 =
    GetUserItemVoteResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GetUserItemVoteResult_t__bindgen_ty_1 {
    k_iCallback = 3409,
}
#[test]
fn bindgen_test_layout_GetUserItemVoteResult_t() {
    assert_eq!(
        ::std::mem::size_of::<GetUserItemVoteResult_t>(),
        16usize,
        concat!("Size of: ", stringify!(GetUserItemVoteResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GetUserItemVoteResult_t>(),
        8usize,
        concat!("Alignment of ", stringify!(GetUserItemVoteResult_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GetUserItemVoteResult_t>())).m_nPublishedFileId as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GetUserItemVoteResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GetUserItemVoteResult_t>())).m_eResult as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GetUserItemVoteResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GetUserItemVoteResult_t>())).m_bVotedUp as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(GetUserItemVoteResult_t),
            "::",
            stringify!(m_bVotedUp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GetUserItemVoteResult_t>())).m_bVotedDown as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(GetUserItemVoteResult_t),
            "::",
            stringify!(m_bVotedDown)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GetUserItemVoteResult_t>())).m_bVoteSkipped as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(GetUserItemVoteResult_t),
            "::",
            stringify!(m_bVoteSkipped)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StartPlaytimeTrackingResult_t {
    pub m_eResult: EResult,
}
pub const StartPlaytimeTrackingResult_t_k_iCallback: StartPlaytimeTrackingResult_t__bindgen_ty_1 =
    StartPlaytimeTrackingResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum StartPlaytimeTrackingResult_t__bindgen_ty_1 {
    k_iCallback = 3410,
}
#[test]
fn bindgen_test_layout_StartPlaytimeTrackingResult_t() {
    assert_eq!(
        ::std::mem::size_of::<StartPlaytimeTrackingResult_t>(),
        4usize,
        concat!("Size of: ", stringify!(StartPlaytimeTrackingResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<StartPlaytimeTrackingResult_t>(),
        4usize,
        concat!("Alignment of ", stringify!(StartPlaytimeTrackingResult_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StartPlaytimeTrackingResult_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StartPlaytimeTrackingResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StopPlaytimeTrackingResult_t {
    pub m_eResult: EResult,
}
pub const StopPlaytimeTrackingResult_t_k_iCallback: StopPlaytimeTrackingResult_t__bindgen_ty_1 =
    StopPlaytimeTrackingResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum StopPlaytimeTrackingResult_t__bindgen_ty_1 {
    k_iCallback = 3411,
}
#[test]
fn bindgen_test_layout_StopPlaytimeTrackingResult_t() {
    assert_eq!(
        ::std::mem::size_of::<StopPlaytimeTrackingResult_t>(),
        4usize,
        concat!("Size of: ", stringify!(StopPlaytimeTrackingResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<StopPlaytimeTrackingResult_t>(),
        4usize,
        concat!("Alignment of ", stringify!(StopPlaytimeTrackingResult_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StopPlaytimeTrackingResult_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StopPlaytimeTrackingResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AddUGCDependencyResult_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_nChildPublishedFileId: PublishedFileId_t,
}
pub const AddUGCDependencyResult_t_k_iCallback: AddUGCDependencyResult_t__bindgen_ty_1 =
    AddUGCDependencyResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AddUGCDependencyResult_t__bindgen_ty_1 {
    k_iCallback = 3412,
}
#[test]
fn bindgen_test_layout_AddUGCDependencyResult_t() {
    assert_eq!(
        ::std::mem::size_of::<AddUGCDependencyResult_t>(),
        24usize,
        concat!("Size of: ", stringify!(AddUGCDependencyResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<AddUGCDependencyResult_t>(),
        8usize,
        concat!("Alignment of ", stringify!(AddUGCDependencyResult_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AddUGCDependencyResult_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AddUGCDependencyResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AddUGCDependencyResult_t>())).m_nPublishedFileId as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AddUGCDependencyResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AddUGCDependencyResult_t>())).m_nChildPublishedFileId as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AddUGCDependencyResult_t),
            "::",
            stringify!(m_nChildPublishedFileId)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoveUGCDependencyResult_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_nChildPublishedFileId: PublishedFileId_t,
}
pub const RemoveUGCDependencyResult_t_k_iCallback: RemoveUGCDependencyResult_t__bindgen_ty_1 =
    RemoveUGCDependencyResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoveUGCDependencyResult_t__bindgen_ty_1 {
    k_iCallback = 3413,
}
#[test]
fn bindgen_test_layout_RemoveUGCDependencyResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoveUGCDependencyResult_t>(),
        24usize,
        concat!("Size of: ", stringify!(RemoveUGCDependencyResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<RemoveUGCDependencyResult_t>(),
        8usize,
        concat!("Alignment of ", stringify!(RemoveUGCDependencyResult_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoveUGCDependencyResult_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoveUGCDependencyResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoveUGCDependencyResult_t>())).m_nPublishedFileId as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoveUGCDependencyResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoveUGCDependencyResult_t>())).m_nChildPublishedFileId
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoveUGCDependencyResult_t),
            "::",
            stringify!(m_nChildPublishedFileId)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AddAppDependencyResult_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_nAppID: AppId_t,
}
pub const AddAppDependencyResult_t_k_iCallback: AddAppDependencyResult_t__bindgen_ty_1 =
    AddAppDependencyResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AddAppDependencyResult_t__bindgen_ty_1 {
    k_iCallback = 3414,
}
#[test]
fn bindgen_test_layout_AddAppDependencyResult_t() {
    assert_eq!(
        ::std::mem::size_of::<AddAppDependencyResult_t>(),
        24usize,
        concat!("Size of: ", stringify!(AddAppDependencyResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<AddAppDependencyResult_t>(),
        8usize,
        concat!("Alignment of ", stringify!(AddAppDependencyResult_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AddAppDependencyResult_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AddAppDependencyResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AddAppDependencyResult_t>())).m_nPublishedFileId as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(AddAppDependencyResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AddAppDependencyResult_t>())).m_nAppID as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(AddAppDependencyResult_t),
            "::",
            stringify!(m_nAppID)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RemoveAppDependencyResult_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_nAppID: AppId_t,
}
pub const RemoveAppDependencyResult_t_k_iCallback: RemoveAppDependencyResult_t__bindgen_ty_1 =
    RemoveAppDependencyResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum RemoveAppDependencyResult_t__bindgen_ty_1 {
    k_iCallback = 3415,
}
#[test]
fn bindgen_test_layout_RemoveAppDependencyResult_t() {
    assert_eq!(
        ::std::mem::size_of::<RemoveAppDependencyResult_t>(),
        24usize,
        concat!("Size of: ", stringify!(RemoveAppDependencyResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<RemoveAppDependencyResult_t>(),
        8usize,
        concat!("Alignment of ", stringify!(RemoveAppDependencyResult_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoveAppDependencyResult_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoveAppDependencyResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoveAppDependencyResult_t>())).m_nPublishedFileId as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoveAppDependencyResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<RemoveAppDependencyResult_t>())).m_nAppID as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(RemoveAppDependencyResult_t),
            "::",
            stringify!(m_nAppID)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GetAppDependenciesResult_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
    pub m_rgAppIDs: [AppId_t; 32usize],
    pub m_nNumAppDependencies: uint32,
    pub m_nTotalNumAppDependencies: uint32,
}
pub const GetAppDependenciesResult_t_k_iCallback: GetAppDependenciesResult_t__bindgen_ty_1 =
    GetAppDependenciesResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GetAppDependenciesResult_t__bindgen_ty_1 {
    k_iCallback = 3416,
}
#[test]
fn bindgen_test_layout_GetAppDependenciesResult_t() {
    assert_eq!(
        ::std::mem::size_of::<GetAppDependenciesResult_t>(),
        152usize,
        concat!("Size of: ", stringify!(GetAppDependenciesResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GetAppDependenciesResult_t>(),
        8usize,
        concat!("Alignment of ", stringify!(GetAppDependenciesResult_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GetAppDependenciesResult_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GetAppDependenciesResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GetAppDependenciesResult_t>())).m_nPublishedFileId as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GetAppDependenciesResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GetAppDependenciesResult_t>())).m_rgAppIDs as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(GetAppDependenciesResult_t),
            "::",
            stringify!(m_rgAppIDs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GetAppDependenciesResult_t>())).m_nNumAppDependencies as *const _
                as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(GetAppDependenciesResult_t),
            "::",
            stringify!(m_nNumAppDependencies)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GetAppDependenciesResult_t>())).m_nTotalNumAppDependencies
                as *const _ as usize
        },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(GetAppDependenciesResult_t),
            "::",
            stringify!(m_nTotalNumAppDependencies)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DeleteItemResult_t {
    pub m_eResult: EResult,
    pub m_nPublishedFileId: PublishedFileId_t,
}
pub const DeleteItemResult_t_k_iCallback: DeleteItemResult_t__bindgen_ty_1 =
    DeleteItemResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum DeleteItemResult_t__bindgen_ty_1 {
    k_iCallback = 3417,
}
#[test]
fn bindgen_test_layout_DeleteItemResult_t() {
    assert_eq!(
        ::std::mem::size_of::<DeleteItemResult_t>(),
        16usize,
        concat!("Size of: ", stringify!(DeleteItemResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<DeleteItemResult_t>(),
        8usize,
        concat!("Alignment of ", stringify!(DeleteItemResult_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<DeleteItemResult_t>())).m_eResult as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(DeleteItemResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<DeleteItemResult_t>())).m_nPublishedFileId as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(DeleteItemResult_t),
            "::",
            stringify!(m_nPublishedFileId)
        )
    );
}
#[repr(C)]
pub struct ISteamAppList__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamAppList {
    pub vtable_: *const ISteamAppList__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamAppList() {
    assert_eq!(
        ::std::mem::size_of::<ISteamAppList>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamAppList))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamAppList>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamAppList))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamAppInstalled_t {
    pub m_nAppID: AppId_t,
}
pub const SteamAppInstalled_t_k_iCallback: SteamAppInstalled_t__bindgen_ty_1 =
    SteamAppInstalled_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamAppInstalled_t__bindgen_ty_1 {
    k_iCallback = 3901,
}
#[test]
fn bindgen_test_layout_SteamAppInstalled_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamAppInstalled_t>(),
        4usize,
        concat!("Size of: ", stringify!(SteamAppInstalled_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamAppInstalled_t>(),
        4usize,
        concat!("Alignment of ", stringify!(SteamAppInstalled_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamAppInstalled_t>())).m_nAppID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamAppInstalled_t),
            "::",
            stringify!(m_nAppID)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamAppUninstalled_t {
    pub m_nAppID: AppId_t,
}
pub const SteamAppUninstalled_t_k_iCallback: SteamAppUninstalled_t__bindgen_ty_1 =
    SteamAppUninstalled_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamAppUninstalled_t__bindgen_ty_1 {
    k_iCallback = 3902,
}
#[test]
fn bindgen_test_layout_SteamAppUninstalled_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamAppUninstalled_t>(),
        4usize,
        concat!("Size of: ", stringify!(SteamAppUninstalled_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamAppUninstalled_t>(),
        4usize,
        concat!("Alignment of ", stringify!(SteamAppUninstalled_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamAppUninstalled_t>())).m_nAppID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamAppUninstalled_t),
            "::",
            stringify!(m_nAppID)
        )
    );
}
pub type HHTMLBrowser = uint32;
pub const INVALID_HTMLBROWSER: uint32 = 0;
#[repr(C)]
pub struct ISteamHTMLSurface__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug)]
pub struct ISteamHTMLSurface {
    pub vtable_: *const ISteamHTMLSurface__bindgen_vtable,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ISteamHTMLSurface_EHTMLMouseButton {
    eHTMLMouseButton_Left = 0,
    eHTMLMouseButton_Right = 1,
    eHTMLMouseButton_Middle = 2,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ISteamHTMLSurface_EMouseCursor {
    dc_user = 0,
    dc_none = 1,
    dc_arrow = 2,
    dc_ibeam = 3,
    dc_hourglass = 4,
    dc_waitarrow = 5,
    dc_crosshair = 6,
    dc_up = 7,
    dc_sizenw = 8,
    dc_sizese = 9,
    dc_sizene = 10,
    dc_sizesw = 11,
    dc_sizew = 12,
    dc_sizee = 13,
    dc_sizen = 14,
    dc_sizes = 15,
    dc_sizewe = 16,
    dc_sizens = 17,
    dc_sizeall = 18,
    dc_no = 19,
    dc_hand = 20,
    dc_blank = 21,
    dc_middle_pan = 22,
    dc_north_pan = 23,
    dc_north_east_pan = 24,
    dc_east_pan = 25,
    dc_south_east_pan = 26,
    dc_south_pan = 27,
    dc_south_west_pan = 28,
    dc_west_pan = 29,
    dc_north_west_pan = 30,
    dc_alias = 31,
    dc_cell = 32,
    dc_colresize = 33,
    dc_copycur = 34,
    dc_verticaltext = 35,
    dc_rowresize = 36,
    dc_zoomin = 37,
    dc_zoomout = 38,
    dc_help = 39,
    dc_custom = 40,
    dc_last = 41,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ISteamHTMLSurface_EHTMLKeyModifiers {
    k_eHTMLKeyModifier_None = 0,
    k_eHTMLKeyModifier_AltDown = 1,
    k_eHTMLKeyModifier_CtrlDown = 2,
    k_eHTMLKeyModifier_ShiftDown = 4,
}
#[test]
fn bindgen_test_layout_ISteamHTMLSurface() {
    assert_eq!(
        ::std::mem::size_of::<ISteamHTMLSurface>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamHTMLSurface))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamHTMLSurface>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamHTMLSurface))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_BrowserReady_t {
    pub unBrowserHandle: HHTMLBrowser,
}
pub const HTML_BrowserReady_t_k_iCallback: HTML_BrowserReady_t__bindgen_ty_1 =
    HTML_BrowserReady_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_BrowserReady_t__bindgen_ty_1 {
    k_iCallback = 4501,
}
#[test]
fn bindgen_test_layout_HTML_BrowserReady_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_BrowserReady_t>(),
        4usize,
        concat!("Size of: ", stringify!(HTML_BrowserReady_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_BrowserReady_t>(),
        4usize,
        concat!("Alignment of ", stringify!(HTML_BrowserReady_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_BrowserReady_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_BrowserReady_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_NeedsPaint_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub pBGRA: *const ::std::os::raw::c_char,
    pub unWide: uint32,
    pub unTall: uint32,
    pub unUpdateX: uint32,
    pub unUpdateY: uint32,
    pub unUpdateWide: uint32,
    pub unUpdateTall: uint32,
    pub unScrollX: uint32,
    pub unScrollY: uint32,
    pub flPageScale: f32,
    pub unPageSerial: uint32,
}
pub const HTML_NeedsPaint_t_k_iCallback: HTML_NeedsPaint_t__bindgen_ty_1 =
    HTML_NeedsPaint_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_NeedsPaint_t__bindgen_ty_1 {
    k_iCallback = 4502,
}
#[test]
fn bindgen_test_layout_HTML_NeedsPaint_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_NeedsPaint_t>(),
        56usize,
        concat!("Size of: ", stringify!(HTML_NeedsPaint_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_NeedsPaint_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTML_NeedsPaint_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_NeedsPaint_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NeedsPaint_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NeedsPaint_t>())).pBGRA as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NeedsPaint_t),
            "::",
            stringify!(pBGRA)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NeedsPaint_t>())).unWide as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NeedsPaint_t),
            "::",
            stringify!(unWide)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NeedsPaint_t>())).unTall as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NeedsPaint_t),
            "::",
            stringify!(unTall)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NeedsPaint_t>())).unUpdateX as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NeedsPaint_t),
            "::",
            stringify!(unUpdateX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NeedsPaint_t>())).unUpdateY as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NeedsPaint_t),
            "::",
            stringify!(unUpdateY)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NeedsPaint_t>())).unUpdateWide as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NeedsPaint_t),
            "::",
            stringify!(unUpdateWide)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NeedsPaint_t>())).unUpdateTall as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NeedsPaint_t),
            "::",
            stringify!(unUpdateTall)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NeedsPaint_t>())).unScrollX as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NeedsPaint_t),
            "::",
            stringify!(unScrollX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NeedsPaint_t>())).unScrollY as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NeedsPaint_t),
            "::",
            stringify!(unScrollY)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NeedsPaint_t>())).flPageScale as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NeedsPaint_t),
            "::",
            stringify!(flPageScale)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NeedsPaint_t>())).unPageSerial as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NeedsPaint_t),
            "::",
            stringify!(unPageSerial)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_StartRequest_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub pchURL: *const ::std::os::raw::c_char,
    pub pchTarget: *const ::std::os::raw::c_char,
    pub pchPostData: *const ::std::os::raw::c_char,
    pub bIsRedirect: bool,
}
pub const HTML_StartRequest_t_k_iCallback: HTML_StartRequest_t__bindgen_ty_1 =
    HTML_StartRequest_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_StartRequest_t__bindgen_ty_1 {
    k_iCallback = 4503,
}
#[test]
fn bindgen_test_layout_HTML_StartRequest_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_StartRequest_t>(),
        40usize,
        concat!("Size of: ", stringify!(HTML_StartRequest_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_StartRequest_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTML_StartRequest_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_StartRequest_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_StartRequest_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_StartRequest_t>())).pchURL as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_StartRequest_t),
            "::",
            stringify!(pchURL)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_StartRequest_t>())).pchTarget as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_StartRequest_t),
            "::",
            stringify!(pchTarget)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_StartRequest_t>())).pchPostData as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_StartRequest_t),
            "::",
            stringify!(pchPostData)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_StartRequest_t>())).bIsRedirect as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_StartRequest_t),
            "::",
            stringify!(bIsRedirect)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_CloseBrowser_t {
    pub unBrowserHandle: HHTMLBrowser,
}
pub const HTML_CloseBrowser_t_k_iCallback: HTML_CloseBrowser_t__bindgen_ty_1 =
    HTML_CloseBrowser_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_CloseBrowser_t__bindgen_ty_1 {
    k_iCallback = 4504,
}
#[test]
fn bindgen_test_layout_HTML_CloseBrowser_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_CloseBrowser_t>(),
        4usize,
        concat!("Size of: ", stringify!(HTML_CloseBrowser_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_CloseBrowser_t>(),
        4usize,
        concat!("Alignment of ", stringify!(HTML_CloseBrowser_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_CloseBrowser_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_CloseBrowser_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_URLChanged_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub pchURL: *const ::std::os::raw::c_char,
    pub pchPostData: *const ::std::os::raw::c_char,
    pub bIsRedirect: bool,
    pub pchPageTitle: *const ::std::os::raw::c_char,
    pub bNewNavigation: bool,
}
pub const HTML_URLChanged_t_k_iCallback: HTML_URLChanged_t__bindgen_ty_1 =
    HTML_URLChanged_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_URLChanged_t__bindgen_ty_1 {
    k_iCallback = 4505,
}
#[test]
fn bindgen_test_layout_HTML_URLChanged_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_URLChanged_t>(),
        48usize,
        concat!("Size of: ", stringify!(HTML_URLChanged_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_URLChanged_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTML_URLChanged_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_URLChanged_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_URLChanged_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_URLChanged_t>())).pchURL as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_URLChanged_t),
            "::",
            stringify!(pchURL)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_URLChanged_t>())).pchPostData as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_URLChanged_t),
            "::",
            stringify!(pchPostData)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_URLChanged_t>())).bIsRedirect as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_URLChanged_t),
            "::",
            stringify!(bIsRedirect)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_URLChanged_t>())).pchPageTitle as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_URLChanged_t),
            "::",
            stringify!(pchPageTitle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_URLChanged_t>())).bNewNavigation as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_URLChanged_t),
            "::",
            stringify!(bNewNavigation)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_FinishedRequest_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub pchURL: *const ::std::os::raw::c_char,
    pub pchPageTitle: *const ::std::os::raw::c_char,
}
pub const HTML_FinishedRequest_t_k_iCallback: HTML_FinishedRequest_t__bindgen_ty_1 =
    HTML_FinishedRequest_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_FinishedRequest_t__bindgen_ty_1 {
    k_iCallback = 4506,
}
#[test]
fn bindgen_test_layout_HTML_FinishedRequest_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_FinishedRequest_t>(),
        24usize,
        concat!("Size of: ", stringify!(HTML_FinishedRequest_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_FinishedRequest_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTML_FinishedRequest_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_FinishedRequest_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_FinishedRequest_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_FinishedRequest_t>())).pchURL as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_FinishedRequest_t),
            "::",
            stringify!(pchURL)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_FinishedRequest_t>())).pchPageTitle as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_FinishedRequest_t),
            "::",
            stringify!(pchPageTitle)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_OpenLinkInNewTab_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub pchURL: *const ::std::os::raw::c_char,
}
pub const HTML_OpenLinkInNewTab_t_k_iCallback: HTML_OpenLinkInNewTab_t__bindgen_ty_1 =
    HTML_OpenLinkInNewTab_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_OpenLinkInNewTab_t__bindgen_ty_1 {
    k_iCallback = 4507,
}
#[test]
fn bindgen_test_layout_HTML_OpenLinkInNewTab_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_OpenLinkInNewTab_t>(),
        16usize,
        concat!("Size of: ", stringify!(HTML_OpenLinkInNewTab_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_OpenLinkInNewTab_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTML_OpenLinkInNewTab_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_OpenLinkInNewTab_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_OpenLinkInNewTab_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_OpenLinkInNewTab_t>())).pchURL as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_OpenLinkInNewTab_t),
            "::",
            stringify!(pchURL)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_ChangedTitle_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub pchTitle: *const ::std::os::raw::c_char,
}
pub const HTML_ChangedTitle_t_k_iCallback: HTML_ChangedTitle_t__bindgen_ty_1 =
    HTML_ChangedTitle_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_ChangedTitle_t__bindgen_ty_1 {
    k_iCallback = 4508,
}
#[test]
fn bindgen_test_layout_HTML_ChangedTitle_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_ChangedTitle_t>(),
        16usize,
        concat!("Size of: ", stringify!(HTML_ChangedTitle_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_ChangedTitle_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTML_ChangedTitle_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_ChangedTitle_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_ChangedTitle_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_ChangedTitle_t>())).pchTitle as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_ChangedTitle_t),
            "::",
            stringify!(pchTitle)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_SearchResults_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub unResults: uint32,
    pub unCurrentMatch: uint32,
}
pub const HTML_SearchResults_t_k_iCallback: HTML_SearchResults_t__bindgen_ty_1 =
    HTML_SearchResults_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_SearchResults_t__bindgen_ty_1 {
    k_iCallback = 4509,
}
#[test]
fn bindgen_test_layout_HTML_SearchResults_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_SearchResults_t>(),
        12usize,
        concat!("Size of: ", stringify!(HTML_SearchResults_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_SearchResults_t>(),
        4usize,
        concat!("Alignment of ", stringify!(HTML_SearchResults_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_SearchResults_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_SearchResults_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_SearchResults_t>())).unResults as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_SearchResults_t),
            "::",
            stringify!(unResults)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_SearchResults_t>())).unCurrentMatch as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_SearchResults_t),
            "::",
            stringify!(unCurrentMatch)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_CanGoBackAndForward_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub bCanGoBack: bool,
    pub bCanGoForward: bool,
}
pub const HTML_CanGoBackAndForward_t_k_iCallback: HTML_CanGoBackAndForward_t__bindgen_ty_1 =
    HTML_CanGoBackAndForward_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_CanGoBackAndForward_t__bindgen_ty_1 {
    k_iCallback = 4510,
}
#[test]
fn bindgen_test_layout_HTML_CanGoBackAndForward_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_CanGoBackAndForward_t>(),
        8usize,
        concat!("Size of: ", stringify!(HTML_CanGoBackAndForward_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_CanGoBackAndForward_t>(),
        4usize,
        concat!("Alignment of ", stringify!(HTML_CanGoBackAndForward_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_CanGoBackAndForward_t>())).unBrowserHandle as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_CanGoBackAndForward_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_CanGoBackAndForward_t>())).bCanGoBack as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_CanGoBackAndForward_t),
            "::",
            stringify!(bCanGoBack)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_CanGoBackAndForward_t>())).bCanGoForward as *const _
                as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_CanGoBackAndForward_t),
            "::",
            stringify!(bCanGoForward)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_HorizontalScroll_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub unScrollMax: uint32,
    pub unScrollCurrent: uint32,
    pub flPageScale: f32,
    pub bVisible: bool,
    pub unPageSize: uint32,
}
pub const HTML_HorizontalScroll_t_k_iCallback: HTML_HorizontalScroll_t__bindgen_ty_1 =
    HTML_HorizontalScroll_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_HorizontalScroll_t__bindgen_ty_1 {
    k_iCallback = 4511,
}
#[test]
fn bindgen_test_layout_HTML_HorizontalScroll_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_HorizontalScroll_t>(),
        24usize,
        concat!("Size of: ", stringify!(HTML_HorizontalScroll_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_HorizontalScroll_t>(),
        4usize,
        concat!("Alignment of ", stringify!(HTML_HorizontalScroll_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_HorizontalScroll_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_HorizontalScroll_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_HorizontalScroll_t>())).unScrollMax as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_HorizontalScroll_t),
            "::",
            stringify!(unScrollMax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_HorizontalScroll_t>())).unScrollCurrent as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_HorizontalScroll_t),
            "::",
            stringify!(unScrollCurrent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_HorizontalScroll_t>())).flPageScale as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_HorizontalScroll_t),
            "::",
            stringify!(flPageScale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_HorizontalScroll_t>())).bVisible as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_HorizontalScroll_t),
            "::",
            stringify!(bVisible)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_HorizontalScroll_t>())).unPageSize as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_HorizontalScroll_t),
            "::",
            stringify!(unPageSize)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_VerticalScroll_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub unScrollMax: uint32,
    pub unScrollCurrent: uint32,
    pub flPageScale: f32,
    pub bVisible: bool,
    pub unPageSize: uint32,
}
pub const HTML_VerticalScroll_t_k_iCallback: HTML_VerticalScroll_t__bindgen_ty_1 =
    HTML_VerticalScroll_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_VerticalScroll_t__bindgen_ty_1 {
    k_iCallback = 4512,
}
#[test]
fn bindgen_test_layout_HTML_VerticalScroll_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_VerticalScroll_t>(),
        24usize,
        concat!("Size of: ", stringify!(HTML_VerticalScroll_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_VerticalScroll_t>(),
        4usize,
        concat!("Alignment of ", stringify!(HTML_VerticalScroll_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_VerticalScroll_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_VerticalScroll_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_VerticalScroll_t>())).unScrollMax as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_VerticalScroll_t),
            "::",
            stringify!(unScrollMax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_VerticalScroll_t>())).unScrollCurrent as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_VerticalScroll_t),
            "::",
            stringify!(unScrollCurrent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_VerticalScroll_t>())).flPageScale as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_VerticalScroll_t),
            "::",
            stringify!(flPageScale)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_VerticalScroll_t>())).bVisible as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_VerticalScroll_t),
            "::",
            stringify!(bVisible)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_VerticalScroll_t>())).unPageSize as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_VerticalScroll_t),
            "::",
            stringify!(unPageSize)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_LinkAtPosition_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub x: uint32,
    pub y: uint32,
    pub pchURL: *const ::std::os::raw::c_char,
    pub bInput: bool,
    pub bLiveLink: bool,
}
pub const HTML_LinkAtPosition_t_k_iCallback: HTML_LinkAtPosition_t__bindgen_ty_1 =
    HTML_LinkAtPosition_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_LinkAtPosition_t__bindgen_ty_1 {
    k_iCallback = 4513,
}
#[test]
fn bindgen_test_layout_HTML_LinkAtPosition_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_LinkAtPosition_t>(),
        32usize,
        concat!("Size of: ", stringify!(HTML_LinkAtPosition_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_LinkAtPosition_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTML_LinkAtPosition_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_LinkAtPosition_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_LinkAtPosition_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_LinkAtPosition_t>())).x as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_LinkAtPosition_t),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_LinkAtPosition_t>())).y as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_LinkAtPosition_t),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_LinkAtPosition_t>())).pchURL as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_LinkAtPosition_t),
            "::",
            stringify!(pchURL)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_LinkAtPosition_t>())).bInput as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_LinkAtPosition_t),
            "::",
            stringify!(bInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_LinkAtPosition_t>())).bLiveLink as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_LinkAtPosition_t),
            "::",
            stringify!(bLiveLink)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_JSAlert_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub pchMessage: *const ::std::os::raw::c_char,
}
pub const HTML_JSAlert_t_k_iCallback: HTML_JSAlert_t__bindgen_ty_1 =
    HTML_JSAlert_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_JSAlert_t__bindgen_ty_1 {
    k_iCallback = 4514,
}
#[test]
fn bindgen_test_layout_HTML_JSAlert_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_JSAlert_t>(),
        16usize,
        concat!("Size of: ", stringify!(HTML_JSAlert_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_JSAlert_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTML_JSAlert_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_JSAlert_t>())).unBrowserHandle as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_JSAlert_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_JSAlert_t>())).pchMessage as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_JSAlert_t),
            "::",
            stringify!(pchMessage)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_JSConfirm_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub pchMessage: *const ::std::os::raw::c_char,
}
pub const HTML_JSConfirm_t_k_iCallback: HTML_JSConfirm_t__bindgen_ty_1 =
    HTML_JSConfirm_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_JSConfirm_t__bindgen_ty_1 {
    k_iCallback = 4515,
}
#[test]
fn bindgen_test_layout_HTML_JSConfirm_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_JSConfirm_t>(),
        16usize,
        concat!("Size of: ", stringify!(HTML_JSConfirm_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_JSConfirm_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTML_JSConfirm_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_JSConfirm_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_JSConfirm_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_JSConfirm_t>())).pchMessage as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_JSConfirm_t),
            "::",
            stringify!(pchMessage)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_FileOpenDialog_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub pchTitle: *const ::std::os::raw::c_char,
    pub pchInitialFile: *const ::std::os::raw::c_char,
}
pub const HTML_FileOpenDialog_t_k_iCallback: HTML_FileOpenDialog_t__bindgen_ty_1 =
    HTML_FileOpenDialog_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_FileOpenDialog_t__bindgen_ty_1 {
    k_iCallback = 4516,
}
#[test]
fn bindgen_test_layout_HTML_FileOpenDialog_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_FileOpenDialog_t>(),
        24usize,
        concat!("Size of: ", stringify!(HTML_FileOpenDialog_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_FileOpenDialog_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTML_FileOpenDialog_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_FileOpenDialog_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_FileOpenDialog_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_FileOpenDialog_t>())).pchTitle as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_FileOpenDialog_t),
            "::",
            stringify!(pchTitle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_FileOpenDialog_t>())).pchInitialFile as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_FileOpenDialog_t),
            "::",
            stringify!(pchInitialFile)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_NewWindow_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub pchURL: *const ::std::os::raw::c_char,
    pub unX: uint32,
    pub unY: uint32,
    pub unWide: uint32,
    pub unTall: uint32,
    pub unNewWindow_BrowserHandle_IGNORE: HHTMLBrowser,
}
pub const HTML_NewWindow_t_k_iCallback: HTML_NewWindow_t__bindgen_ty_1 =
    HTML_NewWindow_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_NewWindow_t__bindgen_ty_1 {
    k_iCallback = 4521,
}
#[test]
fn bindgen_test_layout_HTML_NewWindow_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_NewWindow_t>(),
        40usize,
        concat!("Size of: ", stringify!(HTML_NewWindow_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_NewWindow_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTML_NewWindow_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_NewWindow_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NewWindow_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NewWindow_t>())).pchURL as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NewWindow_t),
            "::",
            stringify!(pchURL)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NewWindow_t>())).unX as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NewWindow_t),
            "::",
            stringify!(unX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NewWindow_t>())).unY as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NewWindow_t),
            "::",
            stringify!(unY)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NewWindow_t>())).unWide as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NewWindow_t),
            "::",
            stringify!(unWide)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_NewWindow_t>())).unTall as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NewWindow_t),
            "::",
            stringify!(unTall)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_NewWindow_t>())).unNewWindow_BrowserHandle_IGNORE
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_NewWindow_t),
            "::",
            stringify!(unNewWindow_BrowserHandle_IGNORE)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_SetCursor_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub eMouseCursor: uint32,
}
pub const HTML_SetCursor_t_k_iCallback: HTML_SetCursor_t__bindgen_ty_1 =
    HTML_SetCursor_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_SetCursor_t__bindgen_ty_1 {
    k_iCallback = 4522,
}
#[test]
fn bindgen_test_layout_HTML_SetCursor_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_SetCursor_t>(),
        8usize,
        concat!("Size of: ", stringify!(HTML_SetCursor_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_SetCursor_t>(),
        4usize,
        concat!("Alignment of ", stringify!(HTML_SetCursor_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_SetCursor_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_SetCursor_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_SetCursor_t>())).eMouseCursor as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_SetCursor_t),
            "::",
            stringify!(eMouseCursor)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_StatusText_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub pchMsg: *const ::std::os::raw::c_char,
}
pub const HTML_StatusText_t_k_iCallback: HTML_StatusText_t__bindgen_ty_1 =
    HTML_StatusText_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_StatusText_t__bindgen_ty_1 {
    k_iCallback = 4523,
}
#[test]
fn bindgen_test_layout_HTML_StatusText_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_StatusText_t>(),
        16usize,
        concat!("Size of: ", stringify!(HTML_StatusText_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_StatusText_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTML_StatusText_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_StatusText_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_StatusText_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_StatusText_t>())).pchMsg as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_StatusText_t),
            "::",
            stringify!(pchMsg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_ShowToolTip_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub pchMsg: *const ::std::os::raw::c_char,
}
pub const HTML_ShowToolTip_t_k_iCallback: HTML_ShowToolTip_t__bindgen_ty_1 =
    HTML_ShowToolTip_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_ShowToolTip_t__bindgen_ty_1 {
    k_iCallback = 4524,
}
#[test]
fn bindgen_test_layout_HTML_ShowToolTip_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_ShowToolTip_t>(),
        16usize,
        concat!("Size of: ", stringify!(HTML_ShowToolTip_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_ShowToolTip_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTML_ShowToolTip_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_ShowToolTip_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_ShowToolTip_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_ShowToolTip_t>())).pchMsg as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_ShowToolTip_t),
            "::",
            stringify!(pchMsg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_UpdateToolTip_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub pchMsg: *const ::std::os::raw::c_char,
}
pub const HTML_UpdateToolTip_t_k_iCallback: HTML_UpdateToolTip_t__bindgen_ty_1 =
    HTML_UpdateToolTip_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_UpdateToolTip_t__bindgen_ty_1 {
    k_iCallback = 4525,
}
#[test]
fn bindgen_test_layout_HTML_UpdateToolTip_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_UpdateToolTip_t>(),
        16usize,
        concat!("Size of: ", stringify!(HTML_UpdateToolTip_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_UpdateToolTip_t>(),
        8usize,
        concat!("Alignment of ", stringify!(HTML_UpdateToolTip_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_UpdateToolTip_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_UpdateToolTip_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HTML_UpdateToolTip_t>())).pchMsg as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_UpdateToolTip_t),
            "::",
            stringify!(pchMsg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_HideToolTip_t {
    pub unBrowserHandle: HHTMLBrowser,
}
pub const HTML_HideToolTip_t_k_iCallback: HTML_HideToolTip_t__bindgen_ty_1 =
    HTML_HideToolTip_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_HideToolTip_t__bindgen_ty_1 {
    k_iCallback = 4526,
}
#[test]
fn bindgen_test_layout_HTML_HideToolTip_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_HideToolTip_t>(),
        4usize,
        concat!("Size of: ", stringify!(HTML_HideToolTip_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_HideToolTip_t>(),
        4usize,
        concat!("Alignment of ", stringify!(HTML_HideToolTip_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_HideToolTip_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_HideToolTip_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HTML_BrowserRestarted_t {
    pub unBrowserHandle: HHTMLBrowser,
    pub unOldBrowserHandle: HHTMLBrowser,
}
pub const HTML_BrowserRestarted_t_k_iCallback: HTML_BrowserRestarted_t__bindgen_ty_1 =
    HTML_BrowserRestarted_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum HTML_BrowserRestarted_t__bindgen_ty_1 {
    k_iCallback = 4527,
}
#[test]
fn bindgen_test_layout_HTML_BrowserRestarted_t() {
    assert_eq!(
        ::std::mem::size_of::<HTML_BrowserRestarted_t>(),
        8usize,
        concat!("Size of: ", stringify!(HTML_BrowserRestarted_t))
    );
    assert_eq!(
        ::std::mem::align_of::<HTML_BrowserRestarted_t>(),
        4usize,
        concat!("Alignment of ", stringify!(HTML_BrowserRestarted_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_BrowserRestarted_t>())).unBrowserHandle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_BrowserRestarted_t),
            "::",
            stringify!(unBrowserHandle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<HTML_BrowserRestarted_t>())).unOldBrowserHandle as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(HTML_BrowserRestarted_t),
            "::",
            stringify!(unOldBrowserHandle)
        )
    );
}
pub type SteamItemInstanceID_t = uint64;
extern "C" {
    pub static k_SteamItemInstanceIDInvalid: SteamItemInstanceID_t;
}
pub type SteamItemDef_t = int32;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamItemFlags {
    k_ESteamItemNoTrade = 1,
    k_ESteamItemRemoved = 256,
    k_ESteamItemConsumed = 512,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamItemDetails_t {
    pub m_itemId: SteamItemInstanceID_t,
    pub m_iDefinition: SteamItemDef_t,
    pub m_unQuantity: uint16,
    pub m_unFlags: uint16,
}
#[test]
fn bindgen_test_layout_SteamItemDetails_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamItemDetails_t>(),
        16usize,
        concat!("Size of: ", stringify!(SteamItemDetails_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamItemDetails_t>(),
        8usize,
        concat!("Alignment of ", stringify!(SteamItemDetails_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamItemDetails_t>())).m_itemId as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamItemDetails_t),
            "::",
            stringify!(m_itemId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamItemDetails_t>())).m_iDefinition as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamItemDetails_t),
            "::",
            stringify!(m_iDefinition)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamItemDetails_t>())).m_unQuantity as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamItemDetails_t),
            "::",
            stringify!(m_unQuantity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamItemDetails_t>())).m_unFlags as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamItemDetails_t),
            "::",
            stringify!(m_unFlags)
        )
    );
}
pub type SteamInventoryResult_t = int32;
pub const k_SteamInventoryResultInvalid: SteamInventoryResult_t = -1;
pub type SteamInventoryUpdateHandle_t = uint64;
pub const k_SteamInventoryUpdateHandleInvalid: SteamInventoryUpdateHandle_t = 18446744073709551615;
#[repr(C)]
pub struct ISteamInventory__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamInventory {
    pub vtable_: *const ISteamInventory__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamInventory() {
    assert_eq!(
        ::std::mem::size_of::<ISteamInventory>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamInventory))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamInventory>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamInventory))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamInventoryResultReady_t {
    pub m_handle: SteamInventoryResult_t,
    pub m_result: EResult,
}
pub const SteamInventoryResultReady_t_k_iCallback: SteamInventoryResultReady_t__bindgen_ty_1 =
    SteamInventoryResultReady_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamInventoryResultReady_t__bindgen_ty_1 {
    k_iCallback = 4700,
}
#[test]
fn bindgen_test_layout_SteamInventoryResultReady_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamInventoryResultReady_t>(),
        8usize,
        concat!("Size of: ", stringify!(SteamInventoryResultReady_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamInventoryResultReady_t>(),
        4usize,
        concat!("Alignment of ", stringify!(SteamInventoryResultReady_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamInventoryResultReady_t>())).m_handle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamInventoryResultReady_t),
            "::",
            stringify!(m_handle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamInventoryResultReady_t>())).m_result as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamInventoryResultReady_t),
            "::",
            stringify!(m_result)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamInventoryFullUpdate_t {
    pub m_handle: SteamInventoryResult_t,
}
pub const SteamInventoryFullUpdate_t_k_iCallback: SteamInventoryFullUpdate_t__bindgen_ty_1 =
    SteamInventoryFullUpdate_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamInventoryFullUpdate_t__bindgen_ty_1 {
    k_iCallback = 4701,
}
#[test]
fn bindgen_test_layout_SteamInventoryFullUpdate_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamInventoryFullUpdate_t>(),
        4usize,
        concat!("Size of: ", stringify!(SteamInventoryFullUpdate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamInventoryFullUpdate_t>(),
        4usize,
        concat!("Alignment of ", stringify!(SteamInventoryFullUpdate_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamInventoryFullUpdate_t>())).m_handle as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamInventoryFullUpdate_t),
            "::",
            stringify!(m_handle)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamInventoryDefinitionUpdate_t {
    pub _address: u8,
}
pub const SteamInventoryDefinitionUpdate_t_k_iCallback:
    SteamInventoryDefinitionUpdate_t__bindgen_ty_1 =
    SteamInventoryDefinitionUpdate_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamInventoryDefinitionUpdate_t__bindgen_ty_1 {
    k_iCallback = 4702,
}
#[test]
fn bindgen_test_layout_SteamInventoryDefinitionUpdate_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamInventoryDefinitionUpdate_t>(),
        1usize,
        concat!("Size of: ", stringify!(SteamInventoryDefinitionUpdate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamInventoryDefinitionUpdate_t>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(SteamInventoryDefinitionUpdate_t)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SteamInventoryEligiblePromoItemDefIDs_t {
    pub m_result: EResult,
    pub m_steamID: CSteamID,
    pub m_numEligiblePromoItemDefs: ::std::os::raw::c_int,
    pub m_bCachedData: bool,
}
pub const SteamInventoryEligiblePromoItemDefIDs_t_k_iCallback:
    SteamInventoryEligiblePromoItemDefIDs_t__bindgen_ty_1 =
    SteamInventoryEligiblePromoItemDefIDs_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamInventoryEligiblePromoItemDefIDs_t__bindgen_ty_1 {
    k_iCallback = 4703,
}
#[test]
fn bindgen_test_layout_SteamInventoryEligiblePromoItemDefIDs_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamInventoryEligiblePromoItemDefIDs_t>(),
        20usize,
        concat!(
            "Size of: ",
            stringify!(SteamInventoryEligiblePromoItemDefIDs_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<SteamInventoryEligiblePromoItemDefIDs_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(SteamInventoryEligiblePromoItemDefIDs_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamInventoryEligiblePromoItemDefIDs_t>())).m_result as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamInventoryEligiblePromoItemDefIDs_t),
            "::",
            stringify!(m_result)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamInventoryEligiblePromoItemDefIDs_t>())).m_steamID
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamInventoryEligiblePromoItemDefIDs_t),
            "::",
            stringify!(m_steamID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamInventoryEligiblePromoItemDefIDs_t>()))
                .m_numEligiblePromoItemDefs as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamInventoryEligiblePromoItemDefIDs_t),
            "::",
            stringify!(m_numEligiblePromoItemDefs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamInventoryEligiblePromoItemDefIDs_t>())).m_bCachedData
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamInventoryEligiblePromoItemDefIDs_t),
            "::",
            stringify!(m_bCachedData)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamInventoryStartPurchaseResult_t {
    pub m_result: EResult,
    pub m_ulOrderID: uint64,
    pub m_ulTransID: uint64,
}
pub const SteamInventoryStartPurchaseResult_t_k_iCallback:
    SteamInventoryStartPurchaseResult_t__bindgen_ty_1 =
    SteamInventoryStartPurchaseResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamInventoryStartPurchaseResult_t__bindgen_ty_1 {
    k_iCallback = 4704,
}
#[test]
fn bindgen_test_layout_SteamInventoryStartPurchaseResult_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamInventoryStartPurchaseResult_t>(),
        24usize,
        concat!("Size of: ", stringify!(SteamInventoryStartPurchaseResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamInventoryStartPurchaseResult_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(SteamInventoryStartPurchaseResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamInventoryStartPurchaseResult_t>())).m_result as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamInventoryStartPurchaseResult_t),
            "::",
            stringify!(m_result)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamInventoryStartPurchaseResult_t>())).m_ulOrderID as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamInventoryStartPurchaseResult_t),
            "::",
            stringify!(m_ulOrderID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamInventoryStartPurchaseResult_t>())).m_ulTransID as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamInventoryStartPurchaseResult_t),
            "::",
            stringify!(m_ulTransID)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamInventoryRequestPricesResult_t {
    pub m_result: EResult,
    pub m_rgchCurrency: [::std::os::raw::c_char; 4usize],
}
pub const SteamInventoryRequestPricesResult_t_k_iCallback:
    SteamInventoryRequestPricesResult_t__bindgen_ty_1 =
    SteamInventoryRequestPricesResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamInventoryRequestPricesResult_t__bindgen_ty_1 {
    k_iCallback = 4705,
}
#[test]
fn bindgen_test_layout_SteamInventoryRequestPricesResult_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamInventoryRequestPricesResult_t>(),
        8usize,
        concat!("Size of: ", stringify!(SteamInventoryRequestPricesResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamInventoryRequestPricesResult_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(SteamInventoryRequestPricesResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamInventoryRequestPricesResult_t>())).m_result as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamInventoryRequestPricesResult_t),
            "::",
            stringify!(m_result)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamInventoryRequestPricesResult_t>())).m_rgchCurrency
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamInventoryRequestPricesResult_t),
            "::",
            stringify!(m_rgchCurrency)
        )
    );
}
#[repr(C)]
pub struct ISteamVideo__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamVideo {
    pub vtable_: *const ISteamVideo__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamVideo() {
    assert_eq!(
        ::std::mem::size_of::<ISteamVideo>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamVideo))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamVideo>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamVideo))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GetVideoURLResult_t {
    pub m_eResult: EResult,
    pub m_unVideoAppID: AppId_t,
    pub m_rgchURL: [::std::os::raw::c_char; 256usize],
}
pub const GetVideoURLResult_t_k_iCallback: GetVideoURLResult_t__bindgen_ty_1 =
    GetVideoURLResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GetVideoURLResult_t__bindgen_ty_1 {
    k_iCallback = 4611,
}
#[test]
fn bindgen_test_layout_GetVideoURLResult_t() {
    assert_eq!(
        ::std::mem::size_of::<GetVideoURLResult_t>(),
        264usize,
        concat!("Size of: ", stringify!(GetVideoURLResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GetVideoURLResult_t>(),
        4usize,
        concat!("Alignment of ", stringify!(GetVideoURLResult_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GetVideoURLResult_t>())).m_eResult as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GetVideoURLResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GetVideoURLResult_t>())).m_unVideoAppID as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GetVideoURLResult_t),
            "::",
            stringify!(m_unVideoAppID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GetVideoURLResult_t>())).m_rgchURL as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GetVideoURLResult_t),
            "::",
            stringify!(m_rgchURL)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GetOPFSettingsResult_t {
    pub m_eResult: EResult,
    pub m_unVideoAppID: AppId_t,
}
pub const GetOPFSettingsResult_t_k_iCallback: GetOPFSettingsResult_t__bindgen_ty_1 =
    GetOPFSettingsResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GetOPFSettingsResult_t__bindgen_ty_1 {
    k_iCallback = 4624,
}
#[test]
fn bindgen_test_layout_GetOPFSettingsResult_t() {
    assert_eq!(
        ::std::mem::size_of::<GetOPFSettingsResult_t>(),
        8usize,
        concat!("Size of: ", stringify!(GetOPFSettingsResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GetOPFSettingsResult_t>(),
        4usize,
        concat!("Alignment of ", stringify!(GetOPFSettingsResult_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GetOPFSettingsResult_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GetOPFSettingsResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GetOPFSettingsResult_t>())).m_unVideoAppID as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GetOPFSettingsResult_t),
            "::",
            stringify!(m_unVideoAppID)
        )
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EParentalFeature {
    k_EFeatureInvalid = 0,
    k_EFeatureStore = 1,
    k_EFeatureCommunity = 2,
    k_EFeatureProfile = 3,
    k_EFeatureFriends = 4,
    k_EFeatureNews = 5,
    k_EFeatureTrading = 6,
    k_EFeatureSettings = 7,
    k_EFeatureConsole = 8,
    k_EFeatureBrowser = 9,
    k_EFeatureParentalSetup = 10,
    k_EFeatureLibrary = 11,
    k_EFeatureTest = 12,
    k_EFeatureSiteLicense = 13,
    k_EFeatureMax = 14,
}
#[repr(C)]
pub struct ISteamParentalSettings__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamParentalSettings {
    pub vtable_: *const ISteamParentalSettings__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamParentalSettings() {
    assert_eq!(
        ::std::mem::size_of::<ISteamParentalSettings>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamParentalSettings))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamParentalSettings>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamParentalSettings))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamParentalSettingsChanged_t {
    pub _address: u8,
}
pub const SteamParentalSettingsChanged_t_k_iCallback: SteamParentalSettingsChanged_t__bindgen_ty_1 =
    SteamParentalSettingsChanged_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamParentalSettingsChanged_t__bindgen_ty_1 {
    k_iCallback = 5001,
}
#[test]
fn bindgen_test_layout_SteamParentalSettingsChanged_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamParentalSettingsChanged_t>(),
        1usize,
        concat!("Size of: ", stringify!(SteamParentalSettingsChanged_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamParentalSettingsChanged_t>(),
        1usize,
        concat!("Alignment of ", stringify!(SteamParentalSettingsChanged_t))
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamDeviceFormFactor {
    k_ESteamDeviceFormFactorUnknown = 0,
    k_ESteamDeviceFormFactorPhone = 1,
    k_ESteamDeviceFormFactorTablet = 2,
    k_ESteamDeviceFormFactorComputer = 3,
    k_ESteamDeviceFormFactorTV = 4,
}
pub type RemotePlaySessionID_t = uint32;
#[repr(C)]
pub struct ISteamRemotePlay__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamRemotePlay {
    pub vtable_: *const ISteamRemotePlay__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamRemotePlay() {
    assert_eq!(
        ::std::mem::size_of::<ISteamRemotePlay>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamRemotePlay))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamRemotePlay>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamRemotePlay))
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamRemotePlaySessionConnected_t {
    pub m_unSessionID: RemotePlaySessionID_t,
}
pub const SteamRemotePlaySessionConnected_t_k_iCallback:
    SteamRemotePlaySessionConnected_t__bindgen_ty_1 =
    SteamRemotePlaySessionConnected_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamRemotePlaySessionConnected_t__bindgen_ty_1 {
    k_iCallback = 5701,
}
#[test]
fn bindgen_test_layout_SteamRemotePlaySessionConnected_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamRemotePlaySessionConnected_t>(),
        4usize,
        concat!("Size of: ", stringify!(SteamRemotePlaySessionConnected_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamRemotePlaySessionConnected_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(SteamRemotePlaySessionConnected_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamRemotePlaySessionConnected_t>())).m_unSessionID as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamRemotePlaySessionConnected_t),
            "::",
            stringify!(m_unSessionID)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamRemotePlaySessionDisconnected_t {
    pub m_unSessionID: RemotePlaySessionID_t,
}
pub const SteamRemotePlaySessionDisconnected_t_k_iCallback:
    SteamRemotePlaySessionDisconnected_t__bindgen_ty_1 =
    SteamRemotePlaySessionDisconnected_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamRemotePlaySessionDisconnected_t__bindgen_ty_1 {
    k_iCallback = 5702,
}
#[test]
fn bindgen_test_layout_SteamRemotePlaySessionDisconnected_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamRemotePlaySessionDisconnected_t>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(SteamRemotePlaySessionDisconnected_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<SteamRemotePlaySessionDisconnected_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(SteamRemotePlaySessionDisconnected_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamRemotePlaySessionDisconnected_t>())).m_unSessionID
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamRemotePlaySessionDisconnected_t),
            "::",
            stringify!(m_unSessionID)
        )
    );
}
pub type int_least8_t = ::std::os::raw::c_schar;
pub type int_least16_t = ::std::os::raw::c_short;
pub type int_least32_t = ::std::os::raw::c_int;
pub type int_least64_t = ::std::os::raw::c_longlong;
pub type uint_least8_t = ::std::os::raw::c_uchar;
pub type uint_least16_t = ::std::os::raw::c_ushort;
pub type uint_least32_t = ::std::os::raw::c_uint;
pub type uint_least64_t = ::std::os::raw::c_ulonglong;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_int;
pub type int_fast32_t = ::std::os::raw::c_int;
pub type int_fast64_t = ::std::os::raw::c_longlong;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_uint;
pub type uint_fast32_t = ::std::os::raw::c_uint;
pub type uint_fast64_t = ::std::os::raw::c_ulonglong;
pub type intmax_t = ::std::os::raw::c_longlong;
pub type uintmax_t = ::std::os::raw::c_ulonglong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamDatagramRelayAuthTicket {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamDatagramHostedAddress {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamDatagramGameCoordinatorServerLogin {
    _unused: [u8; 0],
}
pub type FnSteamNetConnectionStatusChanged = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut SteamNetConnectionStatusChangedCallback_t),
>;
pub type FnSteamNetAuthenticationStatusChanged =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut SteamNetAuthenticationStatus_t)>;
pub type FnSteamRelayNetworkStatusChanged =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut SteamRelayNetworkStatus_t)>;
pub type FnSteamNetworkingMessagesSessionRequest =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut SteamNetworkingMessagesSessionRequest_t)>;
pub type FnSteamNetworkingMessagesSessionFailed =
    ::std::option::Option<unsafe extern "C" fn(arg1: *mut SteamNetworkingMessagesSessionFailed_t)>;
#[doc = " Handle used to identify a connection to a remote host."]
pub type HSteamNetConnection = uint32;
pub const k_HSteamNetConnection_Invalid: HSteamNetConnection = 0;
#[doc = " Handle used to identify a \"listen socket\".  Unlike traditional"]
#[doc = " Berkeley sockets, a listen socket and a connection are two"]
#[doc = " different abstractions."]
pub type HSteamListenSocket = uint32;
pub const k_HSteamListenSocket_Invalid: HSteamListenSocket = 0;
#[doc = " Handle used to identify a poll group, used to query many"]
#[doc = " connections at once efficiently."]
pub type HSteamNetPollGroup = uint32;
pub const k_HSteamNetPollGroup_Invalid: HSteamNetPollGroup = 0;
pub const k_cchMaxSteamNetworkingErrMsg: ::std::os::raw::c_int = 1024;
#[doc = " Used to return English-language diagnostic error messages to caller."]
#[doc = " (For debugging or spewing to a console, etc.  Not intended for UI.)"]
pub type SteamNetworkingErrMsg = [::std::os::raw::c_char; 1024usize];
#[doc = " Identifier used for a network location point of presence.  (E.g. a Valve data center.)"]
#[doc = " Typically you won't need to directly manipulate these."]
pub type SteamNetworkingPOPID = uint32;
#[doc = " A local timestamp.  You can subtract two timestamps to get the number of elapsed"]
#[doc = " microseconds.  This is guaranteed to increase over time during the lifetime"]
#[doc = " of a process, but not globally across runs.  You don't need to worry about"]
#[doc = " the value wrapping around.  Note that the underlying clock might not actually have"]
#[doc = " microsecond resolution."]
pub type SteamNetworkingMicroseconds = int64;
#[repr(i32)]
#[non_exhaustive]
#[doc = " Describe the status of a particular network resource"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamNetworkingAvailability {
    k_ESteamNetworkingAvailability_CannotTry = -102,
    k_ESteamNetworkingAvailability_Failed = -101,
    k_ESteamNetworkingAvailability_Previously = -100,
    k_ESteamNetworkingAvailability_Retrying = -10,
    k_ESteamNetworkingAvailability_NeverTried = 1,
    k_ESteamNetworkingAvailability_Waiting = 2,
    k_ESteamNetworkingAvailability_Attempting = 3,
    k_ESteamNetworkingAvailability_Current = 100,
    k_ESteamNetworkingAvailability_Unknown = 0,
    k_ESteamNetworkingAvailability__Force32bit = 2147483647,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = " Different methods of describing the identity of a network host"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamNetworkingIdentityType {
    k_ESteamNetworkingIdentityType_Invalid = 0,
    k_ESteamNetworkingIdentityType_SteamID = 16,
    k_ESteamNetworkingIdentityType_IPAddress = 1,
    k_ESteamNetworkingIdentityType_GenericString = 2,
    k_ESteamNetworkingIdentityType_GenericBytes = 3,
    k_ESteamNetworkingIdentityType_UnknownType = 4,
    k_ESteamNetworkingIdentityType__Force32bit = 2147483647,
}
#[doc = " Store an IP and port.  IPv6 is always used; IPv4 is represented using"]
#[doc = " \"IPv4-mapped\" addresses: IPv4 aa.bb.cc.dd => IPv6 ::ffff:aabb:ccdd"]
#[doc = " (RFC 4291 section 2.5.5.2.)"]
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct SteamNetworkingIPAddr {
    pub __bindgen_anon_1: SteamNetworkingIPAddr__bindgen_ty_2,
    pub m_port: uint16,
}
pub const SteamNetworkingIPAddr_k_cchMaxString: SteamNetworkingIPAddr__bindgen_ty_1 =
    SteamNetworkingIPAddr__bindgen_ty_1::k_cchMaxString;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamNetworkingIPAddr__bindgen_ty_1 {
    k_cchMaxString = 48,
}
#[doc = " RFC4038, section 4.2"]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct SteamNetworkingIPAddr_IPv4MappedAddress {
    pub m_8zeros: uint64,
    pub m_0000: uint16,
    pub m_ffff: uint16,
    pub m_ip: [uint8; 4usize],
}
#[test]
fn bindgen_test_layout_SteamNetworkingIPAddr_IPv4MappedAddress() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetworkingIPAddr_IPv4MappedAddress>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(SteamNetworkingIPAddr_IPv4MappedAddress)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetworkingIPAddr_IPv4MappedAddress>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(SteamNetworkingIPAddr_IPv4MappedAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingIPAddr_IPv4MappedAddress>())).m_8zeros as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIPAddr_IPv4MappedAddress),
            "::",
            stringify!(m_8zeros)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingIPAddr_IPv4MappedAddress>())).m_0000 as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIPAddr_IPv4MappedAddress),
            "::",
            stringify!(m_0000)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingIPAddr_IPv4MappedAddress>())).m_ffff as *const _
                as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIPAddr_IPv4MappedAddress),
            "::",
            stringify!(m_ffff)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingIPAddr_IPv4MappedAddress>())).m_ip as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIPAddr_IPv4MappedAddress),
            "::",
            stringify!(m_ip)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union SteamNetworkingIPAddr__bindgen_ty_2 {
    pub m_ipv6: [uint8; 16usize],
    pub m_ipv4: SteamNetworkingIPAddr_IPv4MappedAddress,
}
#[test]
fn bindgen_test_layout_SteamNetworkingIPAddr__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetworkingIPAddr__bindgen_ty_2>(),
        16usize,
        concat!("Size of: ", stringify!(SteamNetworkingIPAddr__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetworkingIPAddr__bindgen_ty_2>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(SteamNetworkingIPAddr__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingIPAddr__bindgen_ty_2>())).m_ipv6 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIPAddr__bindgen_ty_2),
            "::",
            stringify!(m_ipv6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingIPAddr__bindgen_ty_2>())).m_ipv4 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIPAddr__bindgen_ty_2),
            "::",
            stringify!(m_ipv4)
        )
    );
}
#[test]
fn bindgen_test_layout_SteamNetworkingIPAddr() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetworkingIPAddr>(),
        18usize,
        concat!("Size of: ", stringify!(SteamNetworkingIPAddr))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetworkingIPAddr>(),
        1usize,
        concat!("Alignment of ", stringify!(SteamNetworkingIPAddr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamNetworkingIPAddr>())).m_port as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIPAddr),
            "::",
            stringify!(m_port)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}?Clear@SteamNetworkingIPAddr@@QEAAXXZ"]
    pub fn SteamNetworkingIPAddr_Clear(this: *mut SteamNetworkingIPAddr);
}
extern "C" {
    #[link_name = "\u{1}?IsIPv6AllZeros@SteamNetworkingIPAddr@@QEBA_NXZ"]
    pub fn SteamNetworkingIPAddr_IsIPv6AllZeros(this: *const SteamNetworkingIPAddr) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?SetIPv6@SteamNetworkingIPAddr@@QEAAXPEBEG@Z"]
    pub fn SteamNetworkingIPAddr_SetIPv6(
        this: *mut SteamNetworkingIPAddr,
        ipv6: *const uint8,
        nPort: uint16,
    );
}
extern "C" {
    #[link_name = "\u{1}?SetIPv4@SteamNetworkingIPAddr@@QEAAXIG@Z"]
    pub fn SteamNetworkingIPAddr_SetIPv4(
        this: *mut SteamNetworkingIPAddr,
        nIP: uint32,
        nPort: uint16,
    );
}
extern "C" {
    #[link_name = "\u{1}?IsIPv4@SteamNetworkingIPAddr@@QEBA_NXZ"]
    pub fn SteamNetworkingIPAddr_IsIPv4(this: *const SteamNetworkingIPAddr) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?GetIPv4@SteamNetworkingIPAddr@@QEBAIXZ"]
    pub fn SteamNetworkingIPAddr_GetIPv4(this: *const SteamNetworkingIPAddr) -> uint32;
}
extern "C" {
    #[link_name = "\u{1}?SetIPv6LocalHost@SteamNetworkingIPAddr@@QEAAXG@Z"]
    pub fn SteamNetworkingIPAddr_SetIPv6LocalHost(this: *mut SteamNetworkingIPAddr, nPort: uint16);
}
extern "C" {
    #[link_name = "\u{1}?IsLocalHost@SteamNetworkingIPAddr@@QEBA_NXZ"]
    pub fn SteamNetworkingIPAddr_IsLocalHost(this: *const SteamNetworkingIPAddr) -> bool;
}
impl SteamNetworkingIPAddr {
    #[inline]
    pub unsafe fn Clear(&mut self) {
        SteamNetworkingIPAddr_Clear(self)
    }
    #[inline]
    pub unsafe fn IsIPv6AllZeros(&self) -> bool {
        SteamNetworkingIPAddr_IsIPv6AllZeros(self)
    }
    #[inline]
    pub unsafe fn SetIPv6(&mut self, ipv6: *const uint8, nPort: uint16) {
        SteamNetworkingIPAddr_SetIPv6(self, ipv6, nPort)
    }
    #[inline]
    pub unsafe fn SetIPv4(&mut self, nIP: uint32, nPort: uint16) {
        SteamNetworkingIPAddr_SetIPv4(self, nIP, nPort)
    }
    #[inline]
    pub unsafe fn IsIPv4(&self) -> bool {
        SteamNetworkingIPAddr_IsIPv4(self)
    }
    #[inline]
    pub unsafe fn GetIPv4(&self) -> uint32 {
        SteamNetworkingIPAddr_GetIPv4(self)
    }
    #[inline]
    pub unsafe fn SetIPv6LocalHost(&mut self, nPort: uint16) {
        SteamNetworkingIPAddr_SetIPv6LocalHost(self, nPort)
    }
    #[inline]
    pub unsafe fn IsLocalHost(&self) -> bool {
        SteamNetworkingIPAddr_IsLocalHost(self)
    }
}
#[doc = " An abstract way to represent the identity of a network host.  All identities can"]
#[doc = " be represented as simple string.  Furthermore, this string representation is actually"]
#[doc = " used on the wire in several places, even though it is less efficient, in order to"]
#[doc = " facilitate forward compatibility.  (Old client code can handle an identity type that"]
#[doc = " it doesn't understand.)"]
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct SteamNetworkingIdentity {
    #[doc = " Type of identity."]
    pub m_eType: ESteamNetworkingIdentityType,
    pub m_cbSize: ::std::os::raw::c_int,
    pub __bindgen_anon_1: SteamNetworkingIdentity__bindgen_ty_2,
}
pub const SteamNetworkingIdentity_k_cchMaxString: SteamNetworkingIdentity__bindgen_ty_1 =
    SteamNetworkingIdentity__bindgen_ty_1::k_cchMaxString;
pub const SteamNetworkingIdentity_k_cchMaxGenericString: SteamNetworkingIdentity__bindgen_ty_1 =
    SteamNetworkingIdentity__bindgen_ty_1::k_cchMaxGenericString;
pub const SteamNetworkingIdentity_k_cbMaxGenericBytes: SteamNetworkingIdentity__bindgen_ty_1 =
    SteamNetworkingIdentity__bindgen_ty_1::k_cchMaxGenericString;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamNetworkingIdentity__bindgen_ty_1 {
    k_cchMaxString = 128,
    k_cchMaxGenericString = 32,
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union SteamNetworkingIdentity__bindgen_ty_2 {
    pub m_steamID64: uint64,
    pub m_szGenericString: [::std::os::raw::c_char; 32usize],
    pub m_genericBytes: [uint8; 32usize],
    pub m_szUnknownRawString: [::std::os::raw::c_char; 128usize],
    pub m_ip: SteamNetworkingIPAddr,
    pub m_reserved: [uint32; 32usize],
}
#[test]
fn bindgen_test_layout_SteamNetworkingIdentity__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetworkingIdentity__bindgen_ty_2>(),
        128usize,
        concat!(
            "Size of: ",
            stringify!(SteamNetworkingIdentity__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetworkingIdentity__bindgen_ty_2>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(SteamNetworkingIdentity__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingIdentity__bindgen_ty_2>())).m_steamID64
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIdentity__bindgen_ty_2),
            "::",
            stringify!(m_steamID64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingIdentity__bindgen_ty_2>())).m_szGenericString
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIdentity__bindgen_ty_2),
            "::",
            stringify!(m_szGenericString)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingIdentity__bindgen_ty_2>())).m_genericBytes
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIdentity__bindgen_ty_2),
            "::",
            stringify!(m_genericBytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingIdentity__bindgen_ty_2>())).m_szUnknownRawString
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIdentity__bindgen_ty_2),
            "::",
            stringify!(m_szUnknownRawString)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingIdentity__bindgen_ty_2>())).m_ip as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIdentity__bindgen_ty_2),
            "::",
            stringify!(m_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingIdentity__bindgen_ty_2>())).m_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIdentity__bindgen_ty_2),
            "::",
            stringify!(m_reserved)
        )
    );
}
#[test]
fn bindgen_test_layout_SteamNetworkingIdentity() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetworkingIdentity>(),
        136usize,
        concat!("Size of: ", stringify!(SteamNetworkingIdentity))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetworkingIdentity>(),
        1usize,
        concat!("Alignment of ", stringify!(SteamNetworkingIdentity))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamNetworkingIdentity>())).m_eType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIdentity),
            "::",
            stringify!(m_eType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingIdentity>())).m_cbSize as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIdentity),
            "::",
            stringify!(m_cbSize)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}?Clear@SteamNetworkingIdentity@@QEAAXXZ"]
    pub fn SteamNetworkingIdentity_Clear(this: *mut SteamNetworkingIdentity);
}
extern "C" {
    #[link_name = "\u{1}?IsInvalid@SteamNetworkingIdentity@@QEBA_NXZ"]
    pub fn SteamNetworkingIdentity_IsInvalid(this: *const SteamNetworkingIdentity) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?SetSteamID@SteamNetworkingIdentity@@QEAAXVCSteamID@@@Z"]
    pub fn SteamNetworkingIdentity_SetSteamID(
        this: *mut SteamNetworkingIdentity,
        steamID: CSteamID,
    );
}
extern "C" {
    #[link_name = "\u{1}?GetSteamID@SteamNetworkingIdentity@@QEBA?AVCSteamID@@XZ"]
    pub fn SteamNetworkingIdentity_GetSteamID(this: *const SteamNetworkingIdentity) -> CSteamID;
}
extern "C" {
    #[link_name = "\u{1}?SetSteamID64@SteamNetworkingIdentity@@QEAAX_K@Z"]
    pub fn SteamNetworkingIdentity_SetSteamID64(
        this: *mut SteamNetworkingIdentity,
        steamID: uint64,
    );
}
extern "C" {
    #[link_name = "\u{1}?GetSteamID64@SteamNetworkingIdentity@@QEBA_KXZ"]
    pub fn SteamNetworkingIdentity_GetSteamID64(this: *const SteamNetworkingIdentity) -> uint64;
}
extern "C" {
    #[link_name = "\u{1}?SetIPAddr@SteamNetworkingIdentity@@QEAAXAEBUSteamNetworkingIPAddr@@@Z"]
    pub fn SteamNetworkingIdentity_SetIPAddr(
        this: *mut SteamNetworkingIdentity,
        addr: *const SteamNetworkingIPAddr,
    );
}
extern "C" {
    #[link_name = "\u{1}?GetIPAddr@SteamNetworkingIdentity@@QEBAPEBUSteamNetworkingIPAddr@@XZ"]
    pub fn SteamNetworkingIdentity_GetIPAddr(
        this: *const SteamNetworkingIdentity,
    ) -> *const SteamNetworkingIPAddr;
}
extern "C" {
    #[link_name = "\u{1}?SetLocalHost@SteamNetworkingIdentity@@QEAAXXZ"]
    pub fn SteamNetworkingIdentity_SetLocalHost(this: *mut SteamNetworkingIdentity);
}
extern "C" {
    #[link_name = "\u{1}?IsLocalHost@SteamNetworkingIdentity@@QEBA_NXZ"]
    pub fn SteamNetworkingIdentity_IsLocalHost(this: *const SteamNetworkingIdentity) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?SetGenericString@SteamNetworkingIdentity@@QEAA_NPEBD@Z"]
    pub fn SteamNetworkingIdentity_SetGenericString(
        this: *mut SteamNetworkingIdentity,
        pszString: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?GetGenericString@SteamNetworkingIdentity@@QEBAPEBDXZ"]
    pub fn SteamNetworkingIdentity_GetGenericString(
        this: *const SteamNetworkingIdentity,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}?SetGenericBytes@SteamNetworkingIdentity@@QEAA_NPEBX_K@Z"]
    pub fn SteamNetworkingIdentity_SetGenericBytes(
        this: *mut SteamNetworkingIdentity,
        data: *const ::std::os::raw::c_void,
        cbLen: size_t,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?GetGenericBytes@SteamNetworkingIdentity@@QEBAPEBEAEAH@Z"]
    pub fn SteamNetworkingIdentity_GetGenericBytes(
        this: *const SteamNetworkingIdentity,
        cbLen: *mut ::std::os::raw::c_int,
    ) -> *const uint8;
}
extern "C" {
    #[doc = " Print to a human-readable string.  This is suitable for debug messages"]
    #[doc = " or any other time you need to encode the identity as a string.  It has a"]
    #[doc = " URL-like format (type:<type-data>).  Your buffer should be at least"]
    #[doc = " k_cchMaxString bytes big to avoid truncation."]
    #[doc = ""]
    #[doc = " See also SteamNetworkingIPAddrRender"]
    #[link_name = "\u{1}?ToString@SteamNetworkingIdentity@@QEBAXPEAD_K@Z"]
    pub fn SteamNetworkingIdentity_ToString(
        this: *const SteamNetworkingIdentity,
        buf: *mut ::std::os::raw::c_char,
        cbBuf: size_t,
    );
}
extern "C" {
    #[doc = " Parse back a string that was generated using ToString.  If we don't understand the"]
    #[doc = " string, but it looks \"reasonable\" (it matches the pattern type:<type-data> and doesn't"]
    #[doc = " have any funky characters, etc), then we will return true, and the type is set to"]
    #[doc = " k_ESteamNetworkingIdentityType_UnknownType.  false will only be returned if the string"]
    #[doc = " looks invalid."]
    #[link_name = "\u{1}?ParseString@SteamNetworkingIdentity@@QEAA_NPEBD@Z"]
    pub fn SteamNetworkingIdentity_ParseString(
        this: *mut SteamNetworkingIdentity,
        pszStr: *const ::std::os::raw::c_char,
    ) -> bool;
}
impl SteamNetworkingIdentity {
    #[inline]
    pub unsafe fn Clear(&mut self) {
        SteamNetworkingIdentity_Clear(self)
    }
    #[inline]
    pub unsafe fn IsInvalid(&self) -> bool {
        SteamNetworkingIdentity_IsInvalid(self)
    }
    #[inline]
    pub unsafe fn SetSteamID(&mut self, steamID: CSteamID) {
        SteamNetworkingIdentity_SetSteamID(self, steamID)
    }
    #[inline]
    pub unsafe fn GetSteamID(&self) -> CSteamID {
        SteamNetworkingIdentity_GetSteamID(self)
    }
    #[inline]
    pub unsafe fn SetSteamID64(&mut self, steamID: uint64) {
        SteamNetworkingIdentity_SetSteamID64(self, steamID)
    }
    #[inline]
    pub unsafe fn GetSteamID64(&self) -> uint64 {
        SteamNetworkingIdentity_GetSteamID64(self)
    }
    #[inline]
    pub unsafe fn SetIPAddr(&mut self, addr: *const SteamNetworkingIPAddr) {
        SteamNetworkingIdentity_SetIPAddr(self, addr)
    }
    #[inline]
    pub unsafe fn GetIPAddr(&self) -> *const SteamNetworkingIPAddr {
        SteamNetworkingIdentity_GetIPAddr(self)
    }
    #[inline]
    pub unsafe fn SetLocalHost(&mut self) {
        SteamNetworkingIdentity_SetLocalHost(self)
    }
    #[inline]
    pub unsafe fn IsLocalHost(&self) -> bool {
        SteamNetworkingIdentity_IsLocalHost(self)
    }
    #[inline]
    pub unsafe fn SetGenericString(&mut self, pszString: *const ::std::os::raw::c_char) -> bool {
        SteamNetworkingIdentity_SetGenericString(self, pszString)
    }
    #[inline]
    pub unsafe fn GetGenericString(&self) -> *const ::std::os::raw::c_char {
        SteamNetworkingIdentity_GetGenericString(self)
    }
    #[inline]
    pub unsafe fn SetGenericBytes(
        &mut self,
        data: *const ::std::os::raw::c_void,
        cbLen: size_t,
    ) -> bool {
        SteamNetworkingIdentity_SetGenericBytes(self, data, cbLen)
    }
    #[inline]
    pub unsafe fn GetGenericBytes(&self, cbLen: *mut ::std::os::raw::c_int) -> *const uint8 {
        SteamNetworkingIdentity_GetGenericBytes(self, cbLen)
    }
    #[inline]
    pub unsafe fn ToString(&self, buf: *mut ::std::os::raw::c_char, cbBuf: size_t) {
        SteamNetworkingIdentity_ToString(self, buf, cbBuf)
    }
    #[inline]
    pub unsafe fn ParseString(&mut self, pszStr: *const ::std::os::raw::c_char) -> bool {
        SteamNetworkingIdentity_ParseString(self, pszStr)
    }
}
#[repr(i32)]
#[non_exhaustive]
#[doc = " High level connection status"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamNetworkingConnectionState {
    #[doc = " Dummy value used to indicate an error condition in the API."]
    #[doc = " Specified connection doesn't exist or has already been closed."]
    k_ESteamNetworkingConnectionState_None = 0,
    #[doc = " We are trying to establish whether peers can talk to each other,"]
    #[doc = " whether they WANT to talk to each other, perform basic auth,"]
    #[doc = " and exchange crypt keys."]
    #[doc = ""]
    #[doc = " - For connections on the \"client\" side (initiated locally):"]
    #[doc = "   We're in the process of trying to establish a connection."]
    #[doc = "   Depending on the connection type, we might not know who they are."]
    #[doc = "   Note that it is not possible to tell if we are waiting on the"]
    #[doc = "   network to complete handshake packets, or for the application layer"]
    #[doc = "   to accept the connection."]
    #[doc = ""]
    #[doc = " - For connections on the \"server\" side (accepted through listen socket):"]
    #[doc = "   We have completed some basic handshake and the client has presented"]
    #[doc = "   some proof of identity.  The connection is ready to be accepted"]
    #[doc = "   using AcceptConnection()."]
    #[doc = ""]
    #[doc = " In either case, any unreliable packets sent now are almost certain"]
    #[doc = " to be dropped.  Attempts to receive packets are guaranteed to fail."]
    #[doc = " You may send messages if the send mode allows for them to be queued."]
    #[doc = " but if you close the connection before the connection is actually"]
    #[doc = " established, any queued messages will be discarded immediately."]
    #[doc = " (We will not attempt to flush the queue and confirm delivery to the"]
    #[doc = " remote host, which ordinarily happens when a connection is closed.)"]
    k_ESteamNetworkingConnectionState_Connecting = 1,
    #[doc = " Some connection types use a back channel or trusted 3rd party"]
    #[doc = " for earliest communication.  If the server accepts the connection,"]
    #[doc = " then these connections switch into the rendezvous state.  During this"]
    #[doc = " state, we still have not yet established an end-to-end route (through"]
    #[doc = " the relay network), and so if you send any messages unreliable, they"]
    #[doc = " are going to be discarded."]
    k_ESteamNetworkingConnectionState_FindingRoute = 2,
    #[doc = " We've received communications from our peer (and we know"]
    #[doc = " who they are) and are all good.  If you close the connection now,"]
    #[doc = " we will make our best effort to flush out any reliable sent data that"]
    #[doc = " has not been acknowledged by the peer.  (But note that this happens"]
    #[doc = " from within the application process, so unlike a TCP connection, you are"]
    #[doc = " not totally handing it off to the operating system to deal with it.)"]
    k_ESteamNetworkingConnectionState_Connected = 3,
    #[doc = " Connection has been closed by our peer, but not closed locally."]
    #[doc = " The connection still exists from an API perspective.  You must close the"]
    #[doc = " handle to free up resources.  If there are any messages in the inbound queue,"]
    #[doc = " you may retrieve them.  Otherwise, nothing may be done with the connection"]
    #[doc = " except to close it."]
    #[doc = ""]
    #[doc = " This stats is similar to CLOSE_WAIT in the TCP state machine."]
    k_ESteamNetworkingConnectionState_ClosedByPeer = 4,
    #[doc = " A disruption in the connection has been detected locally.  (E.g. timeout,"]
    #[doc = " local internet connection disrupted, etc.)"]
    #[doc = ""]
    #[doc = " The connection still exists from an API perspective.  You must close the"]
    #[doc = " handle to free up resources."]
    #[doc = ""]
    #[doc = " Attempts to send further messages will fail.  Any remaining received messages"]
    #[doc = " in the queue are available."]
    k_ESteamNetworkingConnectionState_ProblemDetectedLocally = 5,
    #[doc = " We've disconnected on our side, and from an API perspective the connection is closed."]
    #[doc = " No more data may be sent or received.  All reliable data has been flushed, or else"]
    #[doc = " we've given up and discarded it.  We do not yet know for sure that the peer knows"]
    #[doc = " the connection has been closed, however, so we're just hanging around so that if we do"]
    #[doc = " get a packet from them, we can send them the appropriate packets so that they can"]
    #[doc = " know why the connection was closed (and not have to rely on a timeout, which makes"]
    #[doc = " it appear as if something is wrong)."]
    k_ESteamNetworkingConnectionState_FinWait = -1,
    #[doc = " We've disconnected on our side, and from an API perspective the connection is closed."]
    #[doc = " No more data may be sent or received.  From a network perspective, however, on the wire,"]
    #[doc = " we have not yet given any indication to the peer that the connection is closed."]
    #[doc = " We are in the process of flushing out the last bit of reliable data.  Once that is done,"]
    #[doc = " we will inform the peer that the connection has been closed, and transition to the"]
    #[doc = " FinWait state."]
    #[doc = ""]
    #[doc = " Note that no indication is given to the remote host that we have closed the connection,"]
    #[doc = " until the data has been flushed.  If the remote host attempts to send us data, we will"]
    #[doc = " do whatever is necessary to keep the connection alive until it can be closed properly."]
    #[doc = " But in fact the data will be discarded, since there is no way for the application to"]
    #[doc = " read it back.  Typically this is not a problem, as application protocols that utilize"]
    #[doc = " the lingering functionality are designed for the remote host to wait for the response"]
    #[doc = " before sending any more data."]
    k_ESteamNetworkingConnectionState_Linger = -2,
    #[doc = " Connection is completely inactive and ready to be destroyed"]
    k_ESteamNetworkingConnectionState_Dead = -3,
    #[doc = " Connection is completely inactive and ready to be destroyed"]
    k_ESteamNetworkingConnectionState__Force32Bit = 2147483647,
}
impl ESteamNetConnectionEnd {
    pub const k_ESteamNetConnectionEnd_App_Generic: ESteamNetConnectionEnd =
        ESteamNetConnectionEnd::k_ESteamNetConnectionEnd_App_Min;
}
impl ESteamNetConnectionEnd {
    pub const k_ESteamNetConnectionEnd_AppException_Generic: ESteamNetConnectionEnd =
        ESteamNetConnectionEnd::k_ESteamNetConnectionEnd_AppException_Min;
}
#[repr(i32)]
#[non_exhaustive]
#[doc = " Enumerate various causes of connection termination.  These are designed to work similar"]
#[doc = " to HTTP error codes: the numeric range gives you a rough classification as to the source"]
#[doc = " of the problem."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamNetConnectionEnd {
    k_ESteamNetConnectionEnd_Invalid = 0,
    k_ESteamNetConnectionEnd_App_Min = 1000,
    k_ESteamNetConnectionEnd_App_Max = 1999,
    k_ESteamNetConnectionEnd_AppException_Min = 2000,
    k_ESteamNetConnectionEnd_AppException_Max = 2999,
    k_ESteamNetConnectionEnd_Local_Min = 3000,
    k_ESteamNetConnectionEnd_Local_OfflineMode = 3001,
    k_ESteamNetConnectionEnd_Local_ManyRelayConnectivity = 3002,
    k_ESteamNetConnectionEnd_Local_HostedServerPrimaryRelay = 3003,
    k_ESteamNetConnectionEnd_Local_NetworkConfig = 3004,
    k_ESteamNetConnectionEnd_Local_Rights = 3005,
    k_ESteamNetConnectionEnd_Local_P2P_ICE_NoPublicAddresses = 3006,
    k_ESteamNetConnectionEnd_Local_Max = 3999,
    k_ESteamNetConnectionEnd_Remote_Min = 4000,
    k_ESteamNetConnectionEnd_Remote_Timeout = 4001,
    k_ESteamNetConnectionEnd_Remote_BadCrypt = 4002,
    k_ESteamNetConnectionEnd_Remote_BadCert = 4003,
    k_ESteamNetConnectionEnd_Remote_NotLoggedIn = 4004,
    k_ESteamNetConnectionEnd_Remote_NotRunningApp = 4005,
    k_ESteamNetConnectionEnd_Remote_BadProtocolVersion = 4006,
    k_ESteamNetConnectionEnd_Remote_P2P_ICE_NoPublicAddresses = 4007,
    k_ESteamNetConnectionEnd_Remote_Max = 4999,
    k_ESteamNetConnectionEnd_Misc_Min = 5000,
    k_ESteamNetConnectionEnd_Misc_Generic = 5001,
    k_ESteamNetConnectionEnd_Misc_InternalError = 5002,
    k_ESteamNetConnectionEnd_Misc_Timeout = 5003,
    k_ESteamNetConnectionEnd_Misc_RelayConnectivity = 5004,
    k_ESteamNetConnectionEnd_Misc_SteamConnectivity = 5005,
    k_ESteamNetConnectionEnd_Misc_NoRelaySessionsToClient = 5006,
    k_ESteamNetConnectionEnd_Misc_P2P_Rendezvous = 5008,
    k_ESteamNetConnectionEnd_Misc_P2P_NAT_Firewall = 5009,
    k_ESteamNetConnectionEnd_Misc_PeerSentNoConnection = 5010,
    k_ESteamNetConnectionEnd_Misc_Max = 5999,
    k_ESteamNetConnectionEnd__Force32Bit = 2147483647,
}
pub const k_cchSteamNetworkingMaxConnectionCloseReason: ::std::os::raw::c_int = 128;
pub const k_cchSteamNetworkingMaxConnectionDescription: ::std::os::raw::c_int = 128;
#[doc = " Describe the state of a connection."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SteamNetConnectionInfo_t {
    #[doc = " Who is on the other end?  Depending on the connection type and phase of the connection, we might not know"]
    pub m_identityRemote: SteamNetworkingIdentity,
    #[doc = " Arbitrary user data set by the local application code"]
    pub m_nUserData: int64,
    #[doc = " Handle to listen socket this was connected on, or k_HSteamListenSocket_Invalid if we initiated the connection"]
    pub m_hListenSocket: HSteamListenSocket,
    #[doc = " Remote address.  Might be all 0's if we don't know it, or if this is N/A."]
    #[doc = " (E.g. Basically everything except direct UDP connection.)"]
    pub m_addrRemote: SteamNetworkingIPAddr,
    pub m__pad1: uint16,
    #[doc = " What data center is the remote host in?  (0 if we don't know.)"]
    pub m_idPOPRemote: SteamNetworkingPOPID,
    #[doc = " What relay are we using to communicate with the remote host?"]
    #[doc = " (0 if not applicable.)"]
    pub m_idPOPRelay: SteamNetworkingPOPID,
    #[doc = " High level state of the connection"]
    pub m_eState: ESteamNetworkingConnectionState,
    #[doc = " Basic cause of the connection termination or problem."]
    #[doc = " See ESteamNetConnectionEnd for the values used"]
    pub m_eEndReason: ::std::os::raw::c_int,
    #[doc = " Human-readable, but non-localized explanation for connection"]
    #[doc = " termination or problem.  This is intended for debugging /"]
    #[doc = " diagnostic purposes only, not to display to users.  It might"]
    #[doc = " have some details specific to the issue."]
    pub m_szEndDebug: [::std::os::raw::c_char; 128usize],
    #[doc = " Debug description.  This includes the internal connection ID,"]
    #[doc = " connection type (and peer information), and any name"]
    #[doc = " given to the connection by the app.  This string is used in various"]
    #[doc = " internal logging messages."]
    #[doc = ""]
    #[doc = " Note that the connection ID *usually* matches the HSteamNetConnection"]
    #[doc = " handle, but in certain cases with symmetric connections it might not."]
    pub m_szConnectionDescription: [::std::os::raw::c_char; 128usize],
    #[doc = " Internal stuff, room to change API easily"]
    pub reserved: [uint32; 64usize],
}
#[test]
fn bindgen_test_layout_SteamNetConnectionInfo_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetConnectionInfo_t>(),
        696usize,
        concat!("Size of: ", stringify!(SteamNetConnectionInfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetConnectionInfo_t>(),
        8usize,
        concat!("Alignment of ", stringify!(SteamNetConnectionInfo_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetConnectionInfo_t>())).m_identityRemote as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetConnectionInfo_t),
            "::",
            stringify!(m_identityRemote)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetConnectionInfo_t>())).m_nUserData as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetConnectionInfo_t),
            "::",
            stringify!(m_nUserData)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetConnectionInfo_t>())).m_hListenSocket as *const _
                as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetConnectionInfo_t),
            "::",
            stringify!(m_hListenSocket)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetConnectionInfo_t>())).m_addrRemote as *const _ as usize
        },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetConnectionInfo_t),
            "::",
            stringify!(m_addrRemote)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetConnectionInfo_t>())).m__pad1 as *const _ as usize
        },
        166usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetConnectionInfo_t),
            "::",
            stringify!(m__pad1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetConnectionInfo_t>())).m_idPOPRemote as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetConnectionInfo_t),
            "::",
            stringify!(m_idPOPRemote)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetConnectionInfo_t>())).m_idPOPRelay as *const _ as usize
        },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetConnectionInfo_t),
            "::",
            stringify!(m_idPOPRelay)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetConnectionInfo_t>())).m_eState as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetConnectionInfo_t),
            "::",
            stringify!(m_eState)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetConnectionInfo_t>())).m_eEndReason as *const _ as usize
        },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetConnectionInfo_t),
            "::",
            stringify!(m_eEndReason)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetConnectionInfo_t>())).m_szEndDebug as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetConnectionInfo_t),
            "::",
            stringify!(m_szEndDebug)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetConnectionInfo_t>())).m_szConnectionDescription
                as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetConnectionInfo_t),
            "::",
            stringify!(m_szConnectionDescription)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetConnectionInfo_t>())).reserved as *const _ as usize
        },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetConnectionInfo_t),
            "::",
            stringify!(reserved)
        )
    );
}
#[doc = " Quick connection state, pared down to something you could call"]
#[doc = " more frequently without it being too big of a perf hit."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamNetworkingQuickConnectionStatus {
    #[doc = " High level state of the connection"]
    pub m_eState: ESteamNetworkingConnectionState,
    #[doc = " Current ping (ms)"]
    pub m_nPing: ::std::os::raw::c_int,
    #[doc = " Connection quality measured locally, 0...1.  (Percentage of packets delivered"]
    #[doc = " end-to-end in order)."]
    pub m_flConnectionQualityLocal: f32,
    #[doc = " Packet delivery success rate as observed from remote host"]
    pub m_flConnectionQualityRemote: f32,
    #[doc = " Current data rates from recent history."]
    pub m_flOutPacketsPerSec: f32,
    pub m_flOutBytesPerSec: f32,
    pub m_flInPacketsPerSec: f32,
    pub m_flInBytesPerSec: f32,
    #[doc = " Estimate rate that we believe that we can send data to our peer."]
    #[doc = " Note that this could be significantly higher than m_flOutBytesPerSec,"]
    #[doc = " meaning the capacity of the channel is higher than you are sending data."]
    #[doc = " (That's OK!)"]
    pub m_nSendRateBytesPerSecond: ::std::os::raw::c_int,
    #[doc = " Number of bytes pending to be sent.  This is data that you have recently"]
    #[doc = " requested to be sent but has not yet actually been put on the wire.  The"]
    #[doc = " reliable number ALSO includes data that was previously placed on the wire,"]
    #[doc = " but has now been scheduled for re-transmission.  Thus, it's possible to"]
    #[doc = " observe m_cbPendingReliable increasing between two checks, even if no"]
    #[doc = " calls were made to send reliable data between the checks.  Data that is"]
    #[doc = " awaiting the Nagle delay will appear in these numbers."]
    pub m_cbPendingUnreliable: ::std::os::raw::c_int,
    pub m_cbPendingReliable: ::std::os::raw::c_int,
    #[doc = " Number of bytes of reliable data that has been placed the wire, but"]
    #[doc = " for which we have not yet received an acknowledgment, and thus we may"]
    #[doc = " have to re-transmit."]
    pub m_cbSentUnackedReliable: ::std::os::raw::c_int,
    #[doc = " If you asked us to send a message right now, how long would that message"]
    #[doc = " sit in the queue before we actually started putting packets on the wire?"]
    #[doc = " (And assuming Nagle does not cause any packets to be delayed.)"]
    #[doc = ""]
    #[doc = " In general, data that is sent by the application is limited by the"]
    #[doc = " bandwidth of the channel.  If you send data faster than this, it must"]
    #[doc = " be queued and put on the wire at a metered rate.  Even sending a small amount"]
    #[doc = " of data (e.g. a few MTU, say ~3k) will require some of the data to be delayed"]
    #[doc = " a bit."]
    #[doc = ""]
    #[doc = " In general, the estimated delay will be approximately equal to"]
    #[doc = ""]
    #[doc = "\t\t( m_cbPendingUnreliable+m_cbPendingReliable ) / m_nSendRateBytesPerSecond"]
    #[doc = ""]
    #[doc = " plus or minus one MTU.  It depends on how much time has elapsed since the last"]
    #[doc = " packet was put on the wire.  For example, the queue might have *just* been emptied,"]
    #[doc = " and the last packet placed on the wire, and we are exactly up against the send"]
    #[doc = " rate limit.  In that case we might need to wait for one packet's worth of time to"]
    #[doc = " elapse before we can send again.  On the other extreme, the queue might have data"]
    #[doc = " in it waiting for Nagle.  (This will always be less than one packet, because as soon"]
    #[doc = " as we have a complete packet we would send it.)  In that case, we might be ready"]
    #[doc = " to send data now, and this value will be 0."]
    pub m_usecQueueTime: SteamNetworkingMicroseconds,
    #[doc = " Internal stuff, room to change API easily"]
    pub reserved: [uint32; 16usize],
}
#[test]
fn bindgen_test_layout_SteamNetworkingQuickConnectionStatus() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetworkingQuickConnectionStatus>(),
        120usize,
        concat!(
            "Size of: ",
            stringify!(SteamNetworkingQuickConnectionStatus)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetworkingQuickConnectionStatus>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(SteamNetworkingQuickConnectionStatus)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingQuickConnectionStatus>())).m_eState as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingQuickConnectionStatus),
            "::",
            stringify!(m_eState)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingQuickConnectionStatus>())).m_nPing as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingQuickConnectionStatus),
            "::",
            stringify!(m_nPing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingQuickConnectionStatus>()))
                .m_flConnectionQualityLocal as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingQuickConnectionStatus),
            "::",
            stringify!(m_flConnectionQualityLocal)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingQuickConnectionStatus>()))
                .m_flConnectionQualityRemote as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingQuickConnectionStatus),
            "::",
            stringify!(m_flConnectionQualityRemote)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingQuickConnectionStatus>())).m_flOutPacketsPerSec
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingQuickConnectionStatus),
            "::",
            stringify!(m_flOutPacketsPerSec)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingQuickConnectionStatus>())).m_flOutBytesPerSec
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingQuickConnectionStatus),
            "::",
            stringify!(m_flOutBytesPerSec)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingQuickConnectionStatus>())).m_flInPacketsPerSec
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingQuickConnectionStatus),
            "::",
            stringify!(m_flInPacketsPerSec)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingQuickConnectionStatus>())).m_flInBytesPerSec
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingQuickConnectionStatus),
            "::",
            stringify!(m_flInBytesPerSec)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingQuickConnectionStatus>()))
                .m_nSendRateBytesPerSecond as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingQuickConnectionStatus),
            "::",
            stringify!(m_nSendRateBytesPerSecond)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingQuickConnectionStatus>())).m_cbPendingUnreliable
                as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingQuickConnectionStatus),
            "::",
            stringify!(m_cbPendingUnreliable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingQuickConnectionStatus>())).m_cbPendingReliable
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingQuickConnectionStatus),
            "::",
            stringify!(m_cbPendingReliable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingQuickConnectionStatus>())).m_cbSentUnackedReliable
                as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingQuickConnectionStatus),
            "::",
            stringify!(m_cbSentUnackedReliable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingQuickConnectionStatus>())).m_usecQueueTime
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingQuickConnectionStatus),
            "::",
            stringify!(m_usecQueueTime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingQuickConnectionStatus>())).reserved as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingQuickConnectionStatus),
            "::",
            stringify!(reserved)
        )
    );
}
pub const k_cbMaxSteamNetworkingSocketsMessageSizeSend: ::std::os::raw::c_int = 524288;
#[doc = " A message that has been received."]
#[repr(C)]
pub struct SteamNetworkingMessage_t {
    #[doc = " Message payload"]
    pub m_pData: *mut ::std::os::raw::c_void,
    #[doc = " Size of the payload."]
    pub m_cbSize: ::std::os::raw::c_int,
    #[doc = " For messages received on connections: what connection did this come from?"]
    #[doc = " For outgoing messages: what connection to send it to?"]
    #[doc = " Not used when using the ISteamNetworkingMessages interface"]
    pub m_conn: HSteamNetConnection,
    #[doc = " For inbound messages: Who sent this to us?"]
    #[doc = " For outbound messages on connections: not used."]
    #[doc = " For outbound messages on the ad-hoc ISteamNetworkingMessages interface: who should we send this to?"]
    pub m_identityPeer: SteamNetworkingIdentity,
    #[doc = " For messages received on connections, this is the user data"]
    #[doc = " associated with the connection."]
    #[doc = ""]
    #[doc = " This is *usually* the same as calling GetConnection() and then"]
    #[doc = " fetching the user data associated with that connection, but for"]
    #[doc = " the following subtle differences:"]
    #[doc = ""]
    #[doc = " - This user data will match the connection's user data at the time"]
    #[doc = "   is captured at the time the message is returned by the API."]
    #[doc = "   If you subsequently change the userdata on the connection,"]
    #[doc = "   this won't be updated."]
    #[doc = " - This is an inline call, so it's *much* faster."]
    #[doc = " - You might have closed the connection, so fetching the user data"]
    #[doc = "   would not be possible."]
    #[doc = ""]
    #[doc = " Not used when sending messages,"]
    pub m_nConnUserData: int64,
    #[doc = " Local timestamp when the message was received"]
    #[doc = " Not used for outbound messages."]
    pub m_usecTimeReceived: SteamNetworkingMicroseconds,
    #[doc = " Message number assigned by the sender."]
    #[doc = " This is not used for outbound messages"]
    pub m_nMessageNumber: int64,
    #[doc = " Function used to free up m_pData.  This mechanism exists so that"]
    #[doc = " apps can create messages with buffers allocated from their own"]
    #[doc = " heap, and pass them into the library.  This function will"]
    #[doc = " usually be something like:"]
    #[doc = ""]
    #[doc = " free( pMsg->m_pData );"]
    pub m_pfnFreeData:
        ::std::option::Option<unsafe extern "C" fn(pMsg: *mut SteamNetworkingMessage_t)>,
    #[doc = " Function to used to decrement the internal reference count and, if"]
    #[doc = " it's zero, release the message.  You should not set this function pointer,"]
    #[doc = " or need to access this directly!  Use the Release() function instead!"]
    pub m_pfnRelease:
        ::std::option::Option<unsafe extern "C" fn(pMsg: *mut SteamNetworkingMessage_t)>,
    #[doc = " When using ISteamNetworkingMessages, the channel number the message was received on"]
    #[doc = " (Not used for messages sent or received on \"connections\")"]
    pub m_nChannel: ::std::os::raw::c_int,
    #[doc = " Bitmask of k_nSteamNetworkingSend_xxx flags."]
    #[doc = " For received messages, only the k_nSteamNetworkingSend_Reliable bit is valid."]
    #[doc = " For outbound messages, all bits are relevant"]
    pub m_nFlags: ::std::os::raw::c_int,
    #[doc = " Arbitrary user data that you can use when sending messages using"]
    #[doc = " ISteamNetworkingUtils::AllocateMessage and ISteamNetworkingSockets::SendMessage."]
    #[doc = " (The callback you set in m_pfnFreeData might use this field.)"]
    #[doc = ""]
    #[doc = " Not used for received messages."]
    pub m_nUserData: int64,
}
#[test]
fn bindgen_test_layout_SteamNetworkingMessage_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetworkingMessage_t>(),
        208usize,
        concat!("Size of: ", stringify!(SteamNetworkingMessage_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetworkingMessage_t>(),
        8usize,
        concat!("Alignment of ", stringify!(SteamNetworkingMessage_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingMessage_t>())).m_pData as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingMessage_t),
            "::",
            stringify!(m_pData)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingMessage_t>())).m_cbSize as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingMessage_t),
            "::",
            stringify!(m_cbSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamNetworkingMessage_t>())).m_conn as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingMessage_t),
            "::",
            stringify!(m_conn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingMessage_t>())).m_identityPeer as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingMessage_t),
            "::",
            stringify!(m_identityPeer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingMessage_t>())).m_nConnUserData as *const _
                as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingMessage_t),
            "::",
            stringify!(m_nConnUserData)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingMessage_t>())).m_usecTimeReceived as *const _
                as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingMessage_t),
            "::",
            stringify!(m_usecTimeReceived)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingMessage_t>())).m_nMessageNumber as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingMessage_t),
            "::",
            stringify!(m_nMessageNumber)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingMessage_t>())).m_pfnFreeData as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingMessage_t),
            "::",
            stringify!(m_pfnFreeData)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingMessage_t>())).m_pfnRelease as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingMessage_t),
            "::",
            stringify!(m_pfnRelease)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingMessage_t>())).m_nChannel as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingMessage_t),
            "::",
            stringify!(m_nChannel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingMessage_t>())).m_nFlags as *const _ as usize
        },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingMessage_t),
            "::",
            stringify!(m_nFlags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingMessage_t>())).m_nUserData as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingMessage_t),
            "::",
            stringify!(m_nUserData)
        )
    );
}
pub const k_nSteamNetworkingSend_Unreliable: ::std::os::raw::c_int = 0;
pub const k_nSteamNetworkingSend_NoNagle: ::std::os::raw::c_int = 1;
pub const k_nSteamNetworkingSend_UnreliableNoNagle: ::std::os::raw::c_int = 1;
pub const k_nSteamNetworkingSend_NoDelay: ::std::os::raw::c_int = 4;
pub const k_nSteamNetworkingSend_UnreliableNoDelay: ::std::os::raw::c_int = 5;
pub const k_nSteamNetworkingSend_Reliable: ::std::os::raw::c_int = 8;
pub const k_nSteamNetworkingSend_ReliableNoNagle: ::std::os::raw::c_int = 9;
pub const k_nSteamNetworkingSend_UseCurrentThread: ::std::os::raw::c_int = 16;
pub const k_nSteamNetworkingSend_AutoRestartBrokenSession: ::std::os::raw::c_int = 32;
#[doc = " Object that describes a \"location\" on the Internet with sufficient"]
#[doc = " detail that we can reasonably estimate an upper bound on the ping between"]
#[doc = " the two hosts, even if a direct route between the hosts is not possible,"]
#[doc = " and the connection must be routed through the Steam Datagram Relay network."]
#[doc = " This does not contain any information that identifies the host.  Indeed,"]
#[doc = " if two hosts are in the same building or otherwise have nearly identical"]
#[doc = " networking characteristics, then it's valid to use the same location"]
#[doc = " object for both of them."]
#[doc = ""]
#[doc = " NOTE: This object should only be used in the same process!  Do not serialize it,"]
#[doc = " send it over the wire, or persist it in a file or database!  If you need"]
#[doc = " to do that, convert it to a string representation using the methods in"]
#[doc = " ISteamNetworkingUtils()."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SteamNetworkPingLocation_t {
    pub m_data: [uint8; 512usize],
}
#[test]
fn bindgen_test_layout_SteamNetworkPingLocation_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetworkPingLocation_t>(),
        512usize,
        concat!("Size of: ", stringify!(SteamNetworkPingLocation_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetworkPingLocation_t>(),
        1usize,
        concat!("Alignment of ", stringify!(SteamNetworkPingLocation_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkPingLocation_t>())).m_data as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkPingLocation_t),
            "::",
            stringify!(m_data)
        )
    );
}
pub const k_cchMaxSteamNetworkingPingLocationString: ::std::os::raw::c_int = 1024;
pub const k_nSteamNetworkingPing_Failed: ::std::os::raw::c_int = -1;
pub const k_nSteamNetworkingPing_Unknown: ::std::os::raw::c_int = -2;
#[repr(i32)]
#[non_exhaustive]
#[doc = " Configuration values can be applied to different types of objects."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamNetworkingConfigScope {
    #[doc = " Get/set global option, or defaults.  Even options that apply to more specific scopes"]
    #[doc = " have global scope, and you may be able to just change the global defaults.  If you"]
    #[doc = " need different settings per connection (for example), then you will need to set those"]
    #[doc = " options at the more specific scope."]
    k_ESteamNetworkingConfig_Global = 1,
    #[doc = " Some options are specific to a particular interface.  Note that all connection"]
    #[doc = " and listen socket settings can also be set at the interface level, and they will"]
    #[doc = " apply to objects created through those interfaces."]
    k_ESteamNetworkingConfig_SocketsInterface = 2,
    #[doc = " Options for a listen socket.  Listen socket options can be set at the interface layer,"]
    #[doc = " if  you have multiple listen sockets and they all use the same options."]
    #[doc = " You can also set connection options on a listen socket, and they set the defaults"]
    #[doc = " for all connections accepted through this listen socket.  (They will be used if you don't"]
    #[doc = " set a connection option.)"]
    k_ESteamNetworkingConfig_ListenSocket = 3,
    #[doc = " Options for a specific connection."]
    k_ESteamNetworkingConfig_Connection = 4,
    #[doc = " Options for a specific connection."]
    k_ESteamNetworkingConfigScope__Force32Bit = 2147483647,
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamNetworkingConfigDataType {
    k_ESteamNetworkingConfig_Int32 = 1,
    k_ESteamNetworkingConfig_Int64 = 2,
    k_ESteamNetworkingConfig_Float = 3,
    k_ESteamNetworkingConfig_String = 4,
    k_ESteamNetworkingConfig_Ptr = 5,
    k_ESteamNetworkingConfigDataType__Force32Bit = 2147483647,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = " Configuration options"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamNetworkingConfigValue {
    k_ESteamNetworkingConfig_Invalid = 0,
    #[doc = " [global float, 0--100] Randomly discard N pct of packets instead of sending/recv"]
    #[doc = " This is a global option only, since it is applied at a low level"]
    #[doc = " where we don't have much context"]
    k_ESteamNetworkingConfig_FakePacketLoss_Send = 2,
    #[doc = " [global float, 0--100] Randomly discard N pct of packets instead of sending/recv"]
    #[doc = " This is a global option only, since it is applied at a low level"]
    #[doc = " where we don't have much context"]
    k_ESteamNetworkingConfig_FakePacketLoss_Recv = 3,
    #[doc = " [global int32].  Delay all outbound/inbound packets by N ms"]
    k_ESteamNetworkingConfig_FakePacketLag_Send = 4,
    #[doc = " [global int32].  Delay all outbound/inbound packets by N ms"]
    k_ESteamNetworkingConfig_FakePacketLag_Recv = 5,
    #[doc = " [global float] 0-100 Percentage of packets we will add additional delay"]
    #[doc = " to (causing them to be reordered)"]
    k_ESteamNetworkingConfig_FakePacketReorder_Send = 6,
    #[doc = " [global float] 0-100 Percentage of packets we will add additional delay"]
    #[doc = " to (causing them to be reordered)"]
    k_ESteamNetworkingConfig_FakePacketReorder_Recv = 7,
    #[doc = " [global int32] Extra delay, in ms, to apply to reordered packets."]
    k_ESteamNetworkingConfig_FakePacketReorder_Time = 8,
    #[doc = " [global float 0--100] Globally duplicate some percentage of packets we send"]
    k_ESteamNetworkingConfig_FakePacketDup_Send = 26,
    #[doc = " [global float 0--100] Globally duplicate some percentage of packets we send"]
    k_ESteamNetworkingConfig_FakePacketDup_Recv = 27,
    #[doc = " [global int32] Amount of delay, in ms, to delay duplicated packets."]
    #[doc = " (We chose a random delay between 0 and this value)"]
    k_ESteamNetworkingConfig_FakePacketDup_TimeMax = 28,
    #[doc = " [connection int32] Timeout value (in ms) to use when first connecting"]
    k_ESteamNetworkingConfig_TimeoutInitial = 24,
    #[doc = " [connection int32] Timeout value (in ms) to use after connection is established"]
    k_ESteamNetworkingConfig_TimeoutConnected = 25,
    #[doc = " [connection int32] Upper limit of buffered pending bytes to be sent,"]
    #[doc = " if this is reached SendMessage will return k_EResultLimitExceeded"]
    #[doc = " Default is 512k (524288 bytes)"]
    k_ESteamNetworkingConfig_SendBufferSize = 9,
    #[doc = " [connection int32] Minimum/maximum send rate clamp, 0 is no limit."]
    #[doc = " This value will control the min/max allowed sending rate that"]
    #[doc = " bandwidth estimation is allowed to reach.  Default is 0 (no-limit)"]
    k_ESteamNetworkingConfig_SendRateMin = 10,
    #[doc = " [connection int32] Minimum/maximum send rate clamp, 0 is no limit."]
    #[doc = " This value will control the min/max allowed sending rate that"]
    #[doc = " bandwidth estimation is allowed to reach.  Default is 0 (no-limit)"]
    k_ESteamNetworkingConfig_SendRateMax = 11,
    #[doc = " [connection int32] Nagle time, in microseconds.  When SendMessage is called, if"]
    #[doc = " the outgoing message is less than the size of the MTU, it will be"]
    #[doc = " queued for a delay equal to the Nagle timer value.  This is to ensure"]
    #[doc = " that if the application sends several small messages rapidly, they are"]
    #[doc = " coalesced into a single packet."]
    #[doc = " See historical RFC 896.  Value is in microseconds."]
    #[doc = " Default is 5000us (5ms)."]
    k_ESteamNetworkingConfig_NagleTime = 12,
    #[doc = " [connection int32] Don't automatically fail IP connections that don't have"]
    #[doc = " strong auth.  On clients, this means we will attempt the connection even if"]
    #[doc = " we don't know our identity or can't get a cert.  On the server, it means that"]
    #[doc = " we won't automatically reject a connection due to a failure to authenticate."]
    #[doc = " (You can examine the incoming connection and decide whether to accept it.)"]
    #[doc = ""]
    #[doc = " This is a dev configuration value, and you should not let users modify it in"]
    #[doc = " production."]
    k_ESteamNetworkingConfig_IP_AllowWithoutAuth = 23,
    #[doc = " [connection int32] Do not send UDP packets with a payload of"]
    #[doc = " larger than N bytes.  If you set this, k_ESteamNetworkingConfig_MTU_DataSize"]
    #[doc = " is automatically adjusted"]
    k_ESteamNetworkingConfig_MTU_PacketSize = 32,
    #[doc = " [connection int32] (read only) Maximum message size you can send that"]
    #[doc = " will not fragment, based on k_ESteamNetworkingConfig_MTU_PacketSize"]
    k_ESteamNetworkingConfig_MTU_DataSize = 33,
    #[doc = " [connection int32] Allow unencrypted (and unauthenticated) communication."]
    #[doc = " 0: Not allowed (the default)"]
    #[doc = " 1: Allowed, but prefer encrypted"]
    #[doc = " 2: Allowed, and preferred"]
    #[doc = " 3: Required.  (Fail the connection if the peer requires encryption.)"]
    #[doc = ""]
    #[doc = " This is a dev configuration value, since its purpose is to disable encryption."]
    #[doc = " You should not let users modify it in production.  (But note that it requires"]
    #[doc = " the peer to also modify their value in order for encryption to be disabled.)"]
    k_ESteamNetworkingConfig_Unencrypted = 34,
    #[doc = " [global int32] 0 or 1.  Some variables are \"dev\" variables.  They are useful"]
    #[doc = " for debugging, but should not be adjusted in production.  When this flag is false (the default),"]
    #[doc = " such variables will not be enumerated by the ISteamnetworkingUtils::GetFirstConfigValue"]
    #[doc = " ISteamNetworkingUtils::GetConfigValueInfo functions.  The idea here is that you"]
    #[doc = " can use those functions to provide a generic mechanism to set any configuration"]
    #[doc = " value from a console or configuration file, looking up the variable by name.  Depending"]
    #[doc = " on your game, modifying other configuration values may also have negative effects, and"]
    #[doc = " you may wish to further lock down which variables are allowed to be modified by the user."]
    #[doc = " (Maybe no variables!)  Or maybe you use a whitelist or blacklist approach."]
    #[doc = ""]
    #[doc = " (This flag is itself a dev variable.)"]
    k_ESteamNetworkingConfig_EnumerateDevVars = 35,
    #[doc = " [connection int32] Set this to 1 on outbound connections and listen sockets,"]
    #[doc = " to enable \"symmetric connect mode\", which is useful in the following"]
    #[doc = " common peer-to-peer use case:"]
    #[doc = ""]
    #[doc = " - The two peers are \"equal\" to each other.  (Neither is clearly the \"client\""]
    #[doc = "   or \"server\".)"]
    #[doc = " - Either peer may initiate the connection, and indeed they may do this"]
    #[doc = "   at the same time"]
    #[doc = " - The peers only desire a single connection to each other, and if both"]
    #[doc = "   peers initiate connections simultaneously, a protocol is needed for them"]
    #[doc = "   to resolve the conflict, so that we end up with a single connection."]
    #[doc = ""]
    #[doc = " This use case is both common, and involves subtle race conditions and tricky"]
    #[doc = " pitfalls, which is why the API has support for dealing with it."]
    #[doc = ""]
    #[doc = " If an incoming connection arrives on a listen socket or via custom signaling,"]
    #[doc = " and the application has not attempted to make a matching outbound connection"]
    #[doc = " in symmetric mode, then the incoming connection can be accepted as usual."]
    #[doc = " A \"matching\" connection means that the relevant endpoint information matches."]
    #[doc = " (At the time this comment is being written, this is only supported for P2P"]
    #[doc = " connections, which means that the peer identities must match, and the virtual"]
    #[doc = " port must match.  At a later time, symmetric mode may be supported for other"]
    #[doc = " connection types.)"]
    #[doc = ""]
    #[doc = " If connections are initiated by both peers simultaneously, race conditions"]
    #[doc = " can arise, but fortunately, most of them are handled internally and do not"]
    #[doc = " require any special awareness from the application.  However, there"]
    #[doc = " is one important case that application code must be aware of:"]
    #[doc = " If application code attempts an outbound connection using a ConnectXxx"]
    #[doc = " function in symmetric mode, and a matching incoming connection is already"]
    #[doc = " waiting on a listen socket, then instead of forming a new connection,"]
    #[doc = " the ConnectXxx call will accept the existing incoming connection, and return"]
    #[doc = " a connection handle to this accepted connection."]
    #[doc = " IMPORTANT: in this case, a SteamNetConnectionStatusChangedCallback_t"]
    #[doc = " has probably *already* been posted to the queue for the incoming connection!"]
    #[doc = " (Once callbacks are posted to the queue, they are not modified.)  It doesn't"]
    #[doc = " matter if the callback has not been consumed by the app.  Thus, application"]
    #[doc = " code that makes use of symmetric connections must be aware that, when processing a"]
    #[doc = " SteamNetConnectionStatusChangedCallback_t for an incoming connection, the"]
    #[doc = " m_hConn may refer to a new connection that the app has has not"]
    #[doc = " seen before (the usual case), but it may also refer to a connection that"]
    #[doc = " has already been accepted implicitly through a call to Connect()!  In this"]
    #[doc = " case, AcceptConnection() will return k_EResultDuplicateRequest."]
    #[doc = ""]
    #[doc = " Only one symmetric connection to a given peer (on a given virtual port)"]
    #[doc = " may exist at any given time.  If client code attempts to create a connection,"]
    #[doc = " and a (live) connection already exists on the local host, then either the"]
    #[doc = " existing connection will be accepted as described above, or the attempt"]
    #[doc = " to create a new connection will fail.  Furthermore, linger mode functionality"]
    #[doc = " is not supported on symmetric connections."]
    #[doc = ""]
    #[doc = " A more complicated race condition can arise if both peers initiate a connection"]
    #[doc = " at roughly the same time.  In this situation, each peer will receive an incoming"]
    #[doc = " connection from the other peer, when the application code has already initiated"]
    #[doc = " an outgoing connection to that peer.  The peers must resolve this conflict and"]
    #[doc = " decide who is going to act as the \"server\" and who will act as the \"client\"."]
    #[doc = " Typically the application does not need to be aware of this case as it is handled"]
    #[doc = " internally.  On both sides, the will observe their outbound connection being"]
    #[doc = " \"accepted\", although one of them one have been converted internally to act"]
    #[doc = " as the \"server\"."]
    #[doc = ""]
    #[doc = " In general, symmetric mode should be all-or-nothing: do not mix symmetric"]
    #[doc = " connections with a non-symmetric connection that it might possible \"match\""]
    #[doc = " with.  If you use symmetric mode on any connections, then both peers should"]
    #[doc = " use it on all connections, and the corresponding listen socket, if any.  The"]
    #[doc = " behaviour when symmetric and ordinary connections are mixed is not defined by"]
    #[doc = " this API, and you should not rely on it.  (This advice only applies when connections"]
    #[doc = " might possibly \"match\".  For example, it's OK to use all symmetric mode"]
    #[doc = " connections on one virtual port, and all ordinary, non-symmetric connections"]
    #[doc = " on a different virtual port, as there is no potential for ambiguity.)"]
    #[doc = ""]
    #[doc = " When using the feature, you should set it in the following situations on"]
    #[doc = " applicable objects:"]
    #[doc = ""]
    #[doc = " - When creating an outbound connection using ConnectXxx function"]
    #[doc = " - When creating a listen socket.  (Note that this will automatically cause"]
    #[doc = "   any accepted connections to inherit the flag.)"]
    #[doc = " - When using custom signaling, before accepting an incoming connection."]
    #[doc = ""]
    #[doc = " Setting the flag on listen socket and accepted connections will enable the"]
    #[doc = " API to automatically deal with duplicate incoming connections, even if the"]
    #[doc = " local host has not made any outbound requests.  (In general, such duplicate"]
    #[doc = " requests from a peer are ignored internally and will not be visible to the"]
    #[doc = " application code.  The previous connection must be closed or resolved first.)"]
    k_ESteamNetworkingConfig_SymmetricConnect = 37,
    #[doc = " [connection int32] For connection types that use \"virtual ports\", this can be used"]
    #[doc = " to assign a local virtual port.  For incoming connections, this will always be the"]
    #[doc = " virtual port of the listen socket (or the port requested by the remote host if custom"]
    #[doc = " signaling is used and the connection is accepted), and cannot be changed.  For"]
    #[doc = " connections initiated locally, the local virtual port will default to the same as the"]
    #[doc = " requested remote virtual port, if you do not specify a different option when creating"]
    #[doc = " the connection.  The local port is only relevant for symmetric connections, when"]
    #[doc = " determining if two connections \"match.\"  In this case, if you need the local and remote"]
    #[doc = " port to differ, you can set this value."]
    #[doc = ""]
    #[doc = " You can also read back this value on listen sockets."]
    #[doc = ""]
    #[doc = " This value should not be read or written in any other context."]
    k_ESteamNetworkingConfig_LocalVirtualPort = 38,
    #[doc = " [connection FnSteamNetConnectionStatusChanged] Callback that will be invoked"]
    #[doc = " when the state of a connection changes."]
    #[doc = ""]
    #[doc = " IMPORTANT: callbacks are dispatched to the handler that is in effect at the time"]
    #[doc = " the event occurs, which might be in another thread.  For example, immediately after"]
    #[doc = " creating a listen socket, you may receive an incoming connection.  And then immediately"]
    #[doc = " after this, the remote host may close the connection.  All of this could happen"]
    #[doc = " before the function to create the listen socket has returned.  For this reason,"]
    #[doc = " callbacks usually must be in effect at the time of object creation.  This means"]
    #[doc = " you should set them when you are creating the listen socket or connection, or have"]
    #[doc = " them in effect so they will be inherited at the time of object creation."]
    #[doc = ""]
    #[doc = " For example:"]
    #[doc = ""]
    #[doc = " exterm void MyStatusChangedFunc( SteamNetConnectionStatusChangedCallback_t *info );"]
    #[doc = " SteamNetworkingConfigValue_t opt; opt.SetPtr( k_ESteamNetworkingConfig_Callback_ConnectionStatusChanged, MyStatusChangedFunc );"]
    #[doc = " SteamNetworkingIPAddr localAddress; localAddress.Clear();"]
    #[doc = " HSteamListenSocket hListenSock = SteamNetworkingSockets()->CreateListenSocketIP( localAddress, 1, &opt );"]
    #[doc = ""]
    #[doc = " When accepting an incoming connection, there is no atomic way to switch the"]
    #[doc = " callback.  However, if the connection is DOA, AcceptConnection() will fail, and"]
    #[doc = " you can fetch the state of the connection at that time."]
    #[doc = ""]
    #[doc = " If all connections and listen sockets can use the same callback, the simplest"]
    #[doc = " method is to set it globally before you create any listen sockets or connections."]
    k_ESteamNetworkingConfig_Callback_ConnectionStatusChanged = 201,
    #[doc = " [global FnSteamNetAuthenticationStatusChanged] Callback that will be invoked"]
    #[doc = " when our auth state changes.  If you use this, install the callback before creating"]
    #[doc = " any connections or listen sockets, and don't change it."]
    #[doc = " See: ISteamNetworkingUtils::SetGlobalCallback_SteamNetAuthenticationStatusChanged"]
    k_ESteamNetworkingConfig_Callback_AuthStatusChanged = 202,
    #[doc = " [global FnSteamRelayNetworkStatusChanged] Callback that will be invoked"]
    #[doc = " when our auth state changes.  If you use this, install the callback before creating"]
    #[doc = " any connections or listen sockets, and don't change it."]
    #[doc = " See: ISteamNetworkingUtils::SetGlobalCallback_SteamRelayNetworkStatusChanged"]
    k_ESteamNetworkingConfig_Callback_RelayNetworkStatusChanged = 203,
    #[doc = " [global FnSteamNetworkingMessagesSessionRequest] Callback that will be invoked"]
    #[doc = " when a peer wants to initiate a SteamNetworkingMessagesSessionRequest."]
    #[doc = " See: ISteamNetworkingUtils::SetGlobalCallback_MessagesSessionRequest"]
    k_ESteamNetworkingConfig_Callback_MessagesSessionRequest = 204,
    #[doc = " [global FnSteamNetworkingMessagesSessionFailed] Callback that will be invoked"]
    #[doc = " when a session you have initiated, or accepted either fails to connect, or loses"]
    #[doc = " connection in some unexpected way."]
    #[doc = " See: ISteamNetworkingUtils::SetGlobalCallback_MessagesSessionFailed"]
    k_ESteamNetworkingConfig_Callback_MessagesSessionFailed = 205,
    #[doc = " [global FnSteamNetworkingSocketsCreateConnectionSignaling] Callback that will"]
    #[doc = " be invoked when we need to create a signaling object for a connection"]
    #[doc = " initiated locally.  See: ISteamNetworkingSockets::ConnectP2P,"]
    #[doc = " ISteamNetworkingMessages."]
    k_ESteamNetworkingConfig_Callback_CreateConnectionSignaling = 206,
    #[doc = " [connection string] Comma-separated list of STUN servers that can be used"]
    #[doc = " for NAT piercing.  If you set this to an empty string, NAT piercing will"]
    #[doc = " not be attempted.  Also if \"public\" candidates are not allowed for"]
    #[doc = " P2P_Transport_ICE_Enable, then this is ignored."]
    k_ESteamNetworkingConfig_P2P_STUN_ServerList = 103,
    #[doc = " [connection int32] What types of ICE candidates to share with the peer."]
    #[doc = " See k_nSteamNetworkingConfig_P2P_Transport_ICE_Enable_xxx values"]
    k_ESteamNetworkingConfig_P2P_Transport_ICE_Enable = 104,
    #[doc = " [connection int32] When selecting P2P transport, add various"]
    #[doc = " penalties to the scores for selected transports.  (Route selection"]
    #[doc = " scores are on a scale of milliseconds.  The score begins with the"]
    #[doc = " route ping time and is then adjusted.)"]
    k_ESteamNetworkingConfig_P2P_Transport_ICE_Penalty = 105,
    #[doc = " [connection int32] When selecting P2P transport, add various"]
    #[doc = " penalties to the scores for selected transports.  (Route selection"]
    #[doc = " scores are on a scale of milliseconds.  The score begins with the"]
    #[doc = " route ping time and is then adjusted.)"]
    k_ESteamNetworkingConfig_P2P_Transport_SDR_Penalty = 106,
    #[doc = " [int32 global] If the first N pings to a port all fail, mark that port as unavailable for"]
    #[doc = " a while, and try a different one.  Some ISPs and routers may drop the first"]
    #[doc = " packet, so setting this to 1 may greatly disrupt communications."]
    k_ESteamNetworkingConfig_SDRClient_ConsecutitivePingTimeoutsFailInitial = 19,
    #[doc = " [int32 global] If N consecutive pings to a port fail, after having received successful"]
    #[doc = " communication, mark that port as unavailable for a while, and try a"]
    #[doc = " different one."]
    k_ESteamNetworkingConfig_SDRClient_ConsecutitivePingTimeoutsFail = 20,
    #[doc = " [int32 global] Minimum number of lifetime pings we need to send, before we think our estimate"]
    #[doc = " is solid.  The first ping to each cluster is very often delayed because of NAT,"]
    #[doc = " routers not having the best route, etc.  Until we've sent a sufficient number"]
    #[doc = " of pings, our estimate is often inaccurate.  Keep pinging until we get this"]
    #[doc = " many pings."]
    k_ESteamNetworkingConfig_SDRClient_MinPingsBeforePingAccurate = 21,
    #[doc = " [int32 global] Set all steam datagram traffic to originate from the same"]
    #[doc = " local port. By default, we open up a new UDP socket (on a different local"]
    #[doc = " port) for each relay.  This is slightly less optimal, but it works around"]
    #[doc = " some routers that don't implement NAT properly.  If you have intermittent"]
    #[doc = " problems talking to relays that might be NAT related, try toggling"]
    #[doc = " this flag"]
    k_ESteamNetworkingConfig_SDRClient_SingleSocket = 22,
    #[doc = " [global string] Code of relay cluster to force use.  If not empty, we will"]
    #[doc = " only use relays in that cluster.  E.g. 'iad'"]
    k_ESteamNetworkingConfig_SDRClient_ForceRelayCluster = 29,
    #[doc = " [connection string] For debugging, generate our own (unsigned) ticket, using"]
    #[doc = " the specified  gameserver address.  Router must be configured to accept unsigned"]
    #[doc = " tickets."]
    k_ESteamNetworkingConfig_SDRClient_DebugTicketAddress = 30,
    #[doc = " [global string] For debugging.  Override list of relays from the config with"]
    #[doc = " this set (maybe just one).  Comma-separated list."]
    k_ESteamNetworkingConfig_SDRClient_ForceProxyAddr = 31,
    #[doc = " [global string] For debugging.  Force ping times to clusters to be the specified"]
    #[doc = " values.  A comma separated list of <cluster>=<ms> values.  E.g. \"sto=32,iad=100\""]
    #[doc = ""]
    #[doc = " This is a dev configuration value, you probably should not let users modify it"]
    #[doc = " in production."]
    k_ESteamNetworkingConfig_SDRClient_FakeClusterPing = 36,
    #[doc = " [global string] For debugging.  Force ping times to clusters to be the specified"]
    #[doc = " values.  A comma separated list of <cluster>=<ms> values.  E.g. \"sto=32,iad=100\""]
    #[doc = ""]
    #[doc = " This is a dev configuration value, you probably should not let users modify it"]
    #[doc = " in production."]
    k_ESteamNetworkingConfig_LogLevel_AckRTT = 13,
    #[doc = " [global string] For debugging.  Force ping times to clusters to be the specified"]
    #[doc = " values.  A comma separated list of <cluster>=<ms> values.  E.g. \"sto=32,iad=100\""]
    #[doc = ""]
    #[doc = " This is a dev configuration value, you probably should not let users modify it"]
    #[doc = " in production."]
    k_ESteamNetworkingConfig_LogLevel_PacketDecode = 14,
    #[doc = " [global string] For debugging.  Force ping times to clusters to be the specified"]
    #[doc = " values.  A comma separated list of <cluster>=<ms> values.  E.g. \"sto=32,iad=100\""]
    #[doc = ""]
    #[doc = " This is a dev configuration value, you probably should not let users modify it"]
    #[doc = " in production."]
    k_ESteamNetworkingConfig_LogLevel_Message = 15,
    #[doc = " [global string] For debugging.  Force ping times to clusters to be the specified"]
    #[doc = " values.  A comma separated list of <cluster>=<ms> values.  E.g. \"sto=32,iad=100\""]
    #[doc = ""]
    #[doc = " This is a dev configuration value, you probably should not let users modify it"]
    #[doc = " in production."]
    k_ESteamNetworkingConfig_LogLevel_PacketGaps = 16,
    #[doc = " [global string] For debugging.  Force ping times to clusters to be the specified"]
    #[doc = " values.  A comma separated list of <cluster>=<ms> values.  E.g. \"sto=32,iad=100\""]
    #[doc = ""]
    #[doc = " This is a dev configuration value, you probably should not let users modify it"]
    #[doc = " in production."]
    k_ESteamNetworkingConfig_LogLevel_P2PRendezvous = 17,
    #[doc = " [global string] For debugging.  Force ping times to clusters to be the specified"]
    #[doc = " values.  A comma separated list of <cluster>=<ms> values.  E.g. \"sto=32,iad=100\""]
    #[doc = ""]
    #[doc = " This is a dev configuration value, you probably should not let users modify it"]
    #[doc = " in production."]
    k_ESteamNetworkingConfig_LogLevel_SDRRelayPings = 18,
    #[doc = " [global string] For debugging.  Force ping times to clusters to be the specified"]
    #[doc = " values.  A comma separated list of <cluster>=<ms> values.  E.g. \"sto=32,iad=100\""]
    #[doc = ""]
    #[doc = " This is a dev configuration value, you probably should not let users modify it"]
    #[doc = " in production."]
    k_ESteamNetworkingConfigValue__Force32Bit = 2147483647,
}
pub const k_nSteamNetworkingConfig_P2P_Transport_ICE_Enable_Default: ::std::os::raw::c_int = -1;
pub const k_nSteamNetworkingConfig_P2P_Transport_ICE_Enable_Disable: ::std::os::raw::c_int = 0;
pub const k_nSteamNetworkingConfig_P2P_Transport_ICE_Enable_Relay: ::std::os::raw::c_int = 1;
pub const k_nSteamNetworkingConfig_P2P_Transport_ICE_Enable_Private: ::std::os::raw::c_int = 2;
pub const k_nSteamNetworkingConfig_P2P_Transport_ICE_Enable_Public: ::std::os::raw::c_int = 4;
pub const k_nSteamNetworkingConfig_P2P_Transport_ICE_Enable_All: ::std::os::raw::c_int = 2147483647;
#[doc = " In a few places we need to set configuration options on listen sockets and connections, and"]
#[doc = " have them take effect *before* the listen socket or connection really starts doing anything."]
#[doc = " Creating the object and then setting the options \"immediately\" after creation doesn't work"]
#[doc = " completely, because network packets could be received between the time the object is created and"]
#[doc = " when the options are applied.  To set options at creation time in a reliable way, they must be"]
#[doc = " passed to the creation function.  This structure is used to pass those options."]
#[doc = ""]
#[doc = " For the meaning of these fields, see ISteamNetworkingUtils::SetConfigValue.  Basically"]
#[doc = " when the object is created, we just iterate over the list of options and call"]
#[doc = " ISteamNetworkingUtils::SetConfigValueStruct, where the scope arguments are supplied by the"]
#[doc = " object being created."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SteamNetworkingConfigValue_t {
    #[doc = " Which option is being set"]
    pub m_eValue: ESteamNetworkingConfigValue,
    #[doc = " Which field below did you fill in?"]
    pub m_eDataType: ESteamNetworkingConfigDataType,
    pub m_val: SteamNetworkingConfigValue_t__bindgen_ty_1,
}
#[doc = " Option value"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union SteamNetworkingConfigValue_t__bindgen_ty_1 {
    pub m_int32: i32,
    pub m_int64: i64,
    pub m_float: f32,
    pub m_string: *const ::std::os::raw::c_char,
    pub m_ptr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_SteamNetworkingConfigValue_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetworkingConfigValue_t__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(SteamNetworkingConfigValue_t__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetworkingConfigValue_t__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(SteamNetworkingConfigValue_t__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingConfigValue_t__bindgen_ty_1>())).m_int32
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingConfigValue_t__bindgen_ty_1),
            "::",
            stringify!(m_int32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingConfigValue_t__bindgen_ty_1>())).m_int64
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingConfigValue_t__bindgen_ty_1),
            "::",
            stringify!(m_int64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingConfigValue_t__bindgen_ty_1>())).m_float
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingConfigValue_t__bindgen_ty_1),
            "::",
            stringify!(m_float)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingConfigValue_t__bindgen_ty_1>())).m_string
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingConfigValue_t__bindgen_ty_1),
            "::",
            stringify!(m_string)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingConfigValue_t__bindgen_ty_1>())).m_ptr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingConfigValue_t__bindgen_ty_1),
            "::",
            stringify!(m_ptr)
        )
    );
}
#[test]
fn bindgen_test_layout_SteamNetworkingConfigValue_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetworkingConfigValue_t>(),
        16usize,
        concat!("Size of: ", stringify!(SteamNetworkingConfigValue_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetworkingConfigValue_t>(),
        8usize,
        concat!("Alignment of ", stringify!(SteamNetworkingConfigValue_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingConfigValue_t>())).m_eValue as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingConfigValue_t),
            "::",
            stringify!(m_eValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingConfigValue_t>())).m_eDataType as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingConfigValue_t),
            "::",
            stringify!(m_eDataType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingConfigValue_t>())).m_val as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingConfigValue_t),
            "::",
            stringify!(m_val)
        )
    );
}
#[repr(i32)]
#[non_exhaustive]
#[doc = " Return value of ISteamNetworkintgUtils::GetConfigValue"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamNetworkingGetConfigValueResult {
    k_ESteamNetworkingGetConfigValue_BadValue = -1,
    k_ESteamNetworkingGetConfigValue_BadScopeObj = -2,
    k_ESteamNetworkingGetConfigValue_BufferTooSmall = -3,
    k_ESteamNetworkingGetConfigValue_OK = 1,
    k_ESteamNetworkingGetConfigValue_OKInherited = 2,
    k_ESteamNetworkingGetConfigValueResult__Force32Bit = 2147483647,
}
#[repr(i32)]
#[non_exhaustive]
#[doc = " Detail level for diagnostic output callback."]
#[doc = " See ISteamNetworkingUtils::SetDebugOutputFunction"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ESteamNetworkingSocketsDebugOutputType {
    k_ESteamNetworkingSocketsDebugOutputType_None = 0,
    k_ESteamNetworkingSocketsDebugOutputType_Bug = 1,
    k_ESteamNetworkingSocketsDebugOutputType_Error = 2,
    k_ESteamNetworkingSocketsDebugOutputType_Important = 3,
    k_ESteamNetworkingSocketsDebugOutputType_Warning = 4,
    k_ESteamNetworkingSocketsDebugOutputType_Msg = 5,
    k_ESteamNetworkingSocketsDebugOutputType_Verbose = 6,
    k_ESteamNetworkingSocketsDebugOutputType_Debug = 7,
    k_ESteamNetworkingSocketsDebugOutputType_Everything = 8,
    k_ESteamNetworkingSocketsDebugOutputType__Force32Bit = 2147483647,
}
#[doc = " Setup callback for debug output, and the desired verbosity you want."]
pub type FSteamNetworkingSocketsDebugOutput = ::std::option::Option<
    unsafe extern "C" fn(
        nType: ESteamNetworkingSocketsDebugOutputType,
        pszMsg: *const ::std::os::raw::c_char,
    ),
>;
pub const k_SteamDatagramPOPID_dev: SteamNetworkingPOPID = 6579574;
#[doc = " Utility class for printing a SteamNetworkingPOPID."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SteamNetworkingPOPIDRender {
    pub buf: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout_SteamNetworkingPOPIDRender() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetworkingPOPIDRender>(),
        8usize,
        concat!("Size of: ", stringify!(SteamNetworkingPOPIDRender))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetworkingPOPIDRender>(),
        1usize,
        concat!("Alignment of ", stringify!(SteamNetworkingPOPIDRender))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamNetworkingPOPIDRender>())).buf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingPOPIDRender),
            "::",
            stringify!(buf)
        )
    );
}
pub type ISteamNetworkingMessage = SteamNetworkingMessage_t;
pub type SteamDatagramErrMsg = SteamNetworkingErrMsg;
#[repr(C)]
pub struct ISteamNetworkingMessages__bindgen_vtable(::std::os::raw::c_void);
#[doc = " The non-connection-oriented interface to send and receive messages"]
#[doc = " (whether they be \"clients\" or \"servers\")."]
#[doc = ""]
#[doc = " ISteamNetworkingSockets is connection-oriented (like TCP), meaning you"]
#[doc = " need to listen and connect, and then you send messages using a connection"]
#[doc = " handle.  ISteamNetworkingMessages is more like UDP, in that you can just send"]
#[doc = " messages to arbitrary peers at any time.  The underlying connections are"]
#[doc = " established implicitly."]
#[doc = ""]
#[doc = " Under the hood ISteamNetworkingMessages works on top of the ISteamNetworkingSockets"]
#[doc = " code, so you get the same routing and messaging efficiency.  The difference is"]
#[doc = " mainly in your responsibility to explicitly establish a connection and"]
#[doc = " the type of feedback you get about the state of the connection.  Both"]
#[doc = " interfaces can do \"P2P\" communications, and both support both unreliable"]
#[doc = " and reliable messages, fragmentation and reassembly."]
#[doc = ""]
#[doc = " The primary purpose of this interface is to be \"like UDP\", so that UDP-based code"]
#[doc = " can be ported easily to take advantage of relayed connections.  If you find"]
#[doc = " yourself needing more low level information or control, or to be able to better"]
#[doc = " handle failure, then you probably need to use ISteamNetworkingSockets directly."]
#[doc = " Also, note that if your main goal is to obtain a connection between two peers"]
#[doc = " without concerning yourself with assigning roles of \"client\" and \"server\","]
#[doc = " you may find the symmetric connection mode of ISteamNetworkingSockets useful."]
#[doc = " (See k_ESteamNetworkingConfig_SymmetricConnect.)"]
#[doc = ""]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamNetworkingMessages {
    pub vtable_: *const ISteamNetworkingMessages__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamNetworkingMessages() {
    assert_eq!(
        ::std::mem::size_of::<ISteamNetworkingMessages>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamNetworkingMessages))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamNetworkingMessages>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamNetworkingMessages))
    );
}
#[doc = " Posted when a remote host is sending us a message, and we do not already have a session with them"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SteamNetworkingMessagesSessionRequest_t {
    pub m_identityRemote: SteamNetworkingIdentity,
}
pub const SteamNetworkingMessagesSessionRequest_t_k_iCallback:
    SteamNetworkingMessagesSessionRequest_t__bindgen_ty_1 =
    SteamNetworkingMessagesSessionRequest_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamNetworkingMessagesSessionRequest_t__bindgen_ty_1 {
    k_iCallback = 1251,
}
#[test]
fn bindgen_test_layout_SteamNetworkingMessagesSessionRequest_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetworkingMessagesSessionRequest_t>(),
        136usize,
        concat!(
            "Size of: ",
            stringify!(SteamNetworkingMessagesSessionRequest_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetworkingMessagesSessionRequest_t>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(SteamNetworkingMessagesSessionRequest_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingMessagesSessionRequest_t>())).m_identityRemote
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingMessagesSessionRequest_t),
            "::",
            stringify!(m_identityRemote)
        )
    );
}
#[doc = " Posted when we fail to establish a connection, or we detect that communications"]
#[doc = " have been disrupted it an unusual way.  There is no notification when a peer proactively"]
#[doc = " closes the session.  (\"Closed by peer\" is not a concept of UDP-style communications, and"]
#[doc = " SteamNetworkingMessages is primarily intended to make porting UDP code easy.)"]
#[doc = ""]
#[doc = " Remember: callbacks are asynchronous.   See notes on SendMessageToUser,"]
#[doc = " and k_nSteamNetworkingSend_AutoRestartBrokenSession in particular."]
#[doc = ""]
#[doc = " Also, if a session times out due to inactivity, no callbacks will be posted.  The only"]
#[doc = " way to detect that this is happening is that querying the session state may return"]
#[doc = " none, connecting, and findingroute again."]
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct SteamNetworkingMessagesSessionFailed_t {
    #[doc = " Detailed info about the session that failed."]
    #[doc = " SteamNetConnectionInfo_t::m_identityRemote indicates who this session"]
    #[doc = " was with."]
    pub m_info: SteamNetConnectionInfo_t,
}
pub const SteamNetworkingMessagesSessionFailed_t_k_iCallback:
    SteamNetworkingMessagesSessionFailed_t__bindgen_ty_1 =
    SteamNetworkingMessagesSessionFailed_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamNetworkingMessagesSessionFailed_t__bindgen_ty_1 {
    k_iCallback = 1252,
}
#[test]
fn bindgen_test_layout_SteamNetworkingMessagesSessionFailed_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetworkingMessagesSessionFailed_t>(),
        696usize,
        concat!(
            "Size of: ",
            stringify!(SteamNetworkingMessagesSessionFailed_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetworkingMessagesSessionFailed_t>(),
        1usize,
        concat!(
            "Alignment of ",
            stringify!(SteamNetworkingMessagesSessionFailed_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingMessagesSessionFailed_t>())).m_info as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingMessagesSessionFailed_t),
            "::",
            stringify!(m_info)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamNetworkingConnectionSignaling {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamNetworkingSignalingRecvContext {
    _unused: [u8; 0],
}
#[repr(C)]
pub struct ISteamNetworkingSockets__bindgen_vtable(::std::os::raw::c_void);
#[doc = " Lower level networking API."]
#[doc = ""]
#[doc = " - Connection-oriented API (like TCP, not UDP).  When sending and receiving"]
#[doc = "   messages, a connection handle is used.  (For a UDP-style interface, see"]
#[doc = "   ISteamNetworkingMessages.)  In this TCP-style interface, the \"server\" will"]
#[doc = "   \"listen\" on a \"listen socket.\"  A \"client\" will \"connect\" to the server,"]
#[doc = "   and the server will \"accept\" the connection."]
#[doc = " - But unlike TCP, it's message-oriented, not stream-oriented."]
#[doc = " - Mix of reliable and unreliable messages"]
#[doc = " - Fragmentation and reassembly"]
#[doc = " - Supports connectivity over plain UDP"]
#[doc = " - Also supports SDR (\"Steam Datagram Relay\") connections, which are"]
#[doc = "   addressed by the identity of the peer.  There is a \"P2P\" use case and"]
#[doc = "   a \"hosted dedicated server\" use case."]
#[doc = ""]
#[doc = " Note that neither of the terms \"connection\" nor \"socket\" necessarily correspond"]
#[doc = " one-to-one with an underlying UDP socket.  An attempt has been made to"]
#[doc = " keep the semantics as similar to the standard socket model when appropriate,"]
#[doc = " but some deviations do exist."]
#[doc = ""]
#[doc = " See also: ISteamNetworkingMessages, the UDP-style interface.  This API might be"]
#[doc = " easier to use, especially when porting existing UDP code."]
#[repr(C)]
#[derive(Debug)]
pub struct ISteamNetworkingSockets {
    pub vtable_: *const ISteamNetworkingSockets__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamNetworkingSockets() {
    assert_eq!(
        ::std::mem::size_of::<ISteamNetworkingSockets>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamNetworkingSockets))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamNetworkingSockets>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamNetworkingSockets))
    );
}
extern "C" {
    #[link_name = "\u{1}??_DISteamNetworkingSockets@@IEAAXXZ"]
    pub fn ISteamNetworkingSockets_ISteamNetworkingSockets_destructor(
        this: *mut ISteamNetworkingSockets,
    );
}
impl ISteamNetworkingSockets {
    #[inline]
    pub unsafe fn destruct(&mut self) {
        ISteamNetworkingSockets_ISteamNetworkingSockets_destructor(self)
    }
}
#[doc = " This callback is posted whenever a connection is created, destroyed, or changes state."]
#[doc = " The m_info field will contain a complete description of the connection at the time the"]
#[doc = " change occurred and the callback was posted.  In particular, m_eState will have the"]
#[doc = " new connection state."]
#[doc = ""]
#[doc = " You will usually need to listen for this callback to know when:"]
#[doc = " - A new connection arrives on a listen socket."]
#[doc = "   m_info.m_hListenSocket will be set, m_eOldState = k_ESteamNetworkingConnectionState_None,"]
#[doc = "   and m_info.m_eState = k_ESteamNetworkingConnectionState_Connecting."]
#[doc = "   See ISteamNetworkigSockets::AcceptConnection."]
#[doc = " - A connection you initiated has been accepted by the remote host."]
#[doc = "   m_eOldState = k_ESteamNetworkingConnectionState_Connecting, and"]
#[doc = "   m_info.m_eState = k_ESteamNetworkingConnectionState_Connected."]
#[doc = "   Some connections might transition to k_ESteamNetworkingConnectionState_FindingRoute first."]
#[doc = " - A connection has been actively rejected or closed by the remote host."]
#[doc = "   m_eOldState = k_ESteamNetworkingConnectionState_Connecting or k_ESteamNetworkingConnectionState_Connected,"]
#[doc = "   and m_info.m_eState = k_ESteamNetworkingConnectionState_ClosedByPeer.  m_info.m_eEndReason"]
#[doc = "   and m_info.m_szEndDebug will have for more details."]
#[doc = "   NOTE: upon receiving this callback, you must still destroy the connection using"]
#[doc = "   ISteamNetworkingSockets::CloseConnection to free up local resources.  (The details"]
#[doc = "   passed to the function are not used in this case, since the connection is already closed.)"]
#[doc = " - A problem was detected with the connection, and it has been closed by the local host."]
#[doc = "   The most common failure is timeout, but other configuration or authentication failures"]
#[doc = "   can cause this.  m_eOldState = k_ESteamNetworkingConnectionState_Connecting or"]
#[doc = "   k_ESteamNetworkingConnectionState_Connected, and m_info.m_eState = k_ESteamNetworkingConnectionState_ProblemDetectedLocally."]
#[doc = "   m_info.m_eEndReason and m_info.m_szEndDebug will have for more details."]
#[doc = "   NOTE: upon receiving this callback, you must still destroy the connection using"]
#[doc = "   ISteamNetworkingSockets::CloseConnection to free up local resources.  (The details"]
#[doc = "   passed to the function are not used in this case, since the connection is already closed.)"]
#[doc = ""]
#[doc = " Remember that callbacks are posted to a queue, and networking connections can"]
#[doc = " change at any time.  It is possible that the connection has already changed"]
#[doc = " state by the time you process this callback."]
#[doc = ""]
#[doc = " Also note that callbacks will be posted when connections are created and destroyed by your own API calls."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SteamNetConnectionStatusChangedCallback_t {
    #[doc = " Connection handle"]
    pub m_hConn: HSteamNetConnection,
    #[doc = " Full connection info"]
    pub m_info: SteamNetConnectionInfo_t,
    #[doc = " Previous state.  (Current state is in m_info.m_eState)"]
    pub m_eOldState: ESteamNetworkingConnectionState,
}
pub const SteamNetConnectionStatusChangedCallback_t_k_iCallback:
    SteamNetConnectionStatusChangedCallback_t__bindgen_ty_1 =
    SteamNetConnectionStatusChangedCallback_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamNetConnectionStatusChangedCallback_t__bindgen_ty_1 {
    k_iCallback = 1221,
}
#[test]
fn bindgen_test_layout_SteamNetConnectionStatusChangedCallback_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetConnectionStatusChangedCallback_t>(),
        712usize,
        concat!(
            "Size of: ",
            stringify!(SteamNetConnectionStatusChangedCallback_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetConnectionStatusChangedCallback_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(SteamNetConnectionStatusChangedCallback_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetConnectionStatusChangedCallback_t>())).m_hConn
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetConnectionStatusChangedCallback_t),
            "::",
            stringify!(m_hConn)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetConnectionStatusChangedCallback_t>())).m_info as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetConnectionStatusChangedCallback_t),
            "::",
            stringify!(m_info)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetConnectionStatusChangedCallback_t>())).m_eOldState
                as *const _ as usize
        },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetConnectionStatusChangedCallback_t),
            "::",
            stringify!(m_eOldState)
        )
    );
}
#[doc = " A struct used to describe our readiness to participate in authenticated,"]
#[doc = " encrypted communication.  In order to do this we need:"]
#[doc = ""]
#[doc = " - The list of trusted CA certificates that might be relevant for this"]
#[doc = "   app."]
#[doc = " - A valid certificate issued by a CA."]
#[doc = ""]
#[doc = " This callback is posted whenever the state of our readiness changes."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SteamNetAuthenticationStatus_t {
    #[doc = " Status"]
    pub m_eAvail: ESteamNetworkingAvailability,
    #[doc = " Non-localized English language status.  For diagnostic/debugging"]
    #[doc = " purposes only."]
    pub m_debugMsg: [::std::os::raw::c_char; 256usize],
}
pub const SteamNetAuthenticationStatus_t_k_iCallback: SteamNetAuthenticationStatus_t__bindgen_ty_1 =
    SteamNetAuthenticationStatus_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamNetAuthenticationStatus_t__bindgen_ty_1 {
    k_iCallback = 1222,
}
#[test]
fn bindgen_test_layout_SteamNetAuthenticationStatus_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetAuthenticationStatus_t>(),
        260usize,
        concat!("Size of: ", stringify!(SteamNetAuthenticationStatus_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetAuthenticationStatus_t>(),
        4usize,
        concat!("Alignment of ", stringify!(SteamNetAuthenticationStatus_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetAuthenticationStatus_t>())).m_eAvail as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetAuthenticationStatus_t),
            "::",
            stringify!(m_eAvail)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetAuthenticationStatus_t>())).m_debugMsg as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetAuthenticationStatus_t),
            "::",
            stringify!(m_debugMsg)
        )
    );
}
#[repr(C)]
pub struct ISteamNetworkingUtils__bindgen_vtable(::std::os::raw::c_void);
#[doc = " Misc networking utilities for checking the local networking environment"]
#[doc = " and estimating pings."]
#[repr(C)]
#[derive(Debug)]
pub struct ISteamNetworkingUtils {
    pub vtable_: *const ISteamNetworkingUtils__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamNetworkingUtils() {
    assert_eq!(
        ::std::mem::size_of::<ISteamNetworkingUtils>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamNetworkingUtils))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamNetworkingUtils>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamNetworkingUtils))
    );
}
extern "C" {
    #[link_name = "\u{1}?SetGlobalConfigValueInt32@ISteamNetworkingUtils@@QEAA_NW4ESteamNetworkingConfigValue@@H@Z"]
    pub fn ISteamNetworkingUtils_SetGlobalConfigValueInt32(
        this: *mut ISteamNetworkingUtils,
        eValue: ESteamNetworkingConfigValue,
        val: int32,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?SetGlobalConfigValueFloat@ISteamNetworkingUtils@@QEAA_NW4ESteamNetworkingConfigValue@@M@Z"]
    pub fn ISteamNetworkingUtils_SetGlobalConfigValueFloat(
        this: *mut ISteamNetworkingUtils,
        eValue: ESteamNetworkingConfigValue,
        val: f32,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?SetGlobalConfigValueString@ISteamNetworkingUtils@@QEAA_NW4ESteamNetworkingConfigValue@@PEBD@Z"]
    pub fn ISteamNetworkingUtils_SetGlobalConfigValueString(
        this: *mut ISteamNetworkingUtils,
        eValue: ESteamNetworkingConfigValue,
        val: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?SetGlobalConfigValuePtr@ISteamNetworkingUtils@@QEAA_NW4ESteamNetworkingConfigValue@@PEAX@Z"]
    pub fn ISteamNetworkingUtils_SetGlobalConfigValuePtr(
        this: *mut ISteamNetworkingUtils,
        eValue: ESteamNetworkingConfigValue,
        val: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?SetConnectionConfigValueInt32@ISteamNetworkingUtils@@QEAA_NIW4ESteamNetworkingConfigValue@@H@Z"]
    pub fn ISteamNetworkingUtils_SetConnectionConfigValueInt32(
        this: *mut ISteamNetworkingUtils,
        hConn: HSteamNetConnection,
        eValue: ESteamNetworkingConfigValue,
        val: int32,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?SetConnectionConfigValueFloat@ISteamNetworkingUtils@@QEAA_NIW4ESteamNetworkingConfigValue@@M@Z"]
    pub fn ISteamNetworkingUtils_SetConnectionConfigValueFloat(
        this: *mut ISteamNetworkingUtils,
        hConn: HSteamNetConnection,
        eValue: ESteamNetworkingConfigValue,
        val: f32,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?SetConnectionConfigValueString@ISteamNetworkingUtils@@QEAA_NIW4ESteamNetworkingConfigValue@@PEBD@Z"]
    pub fn ISteamNetworkingUtils_SetConnectionConfigValueString(
        this: *mut ISteamNetworkingUtils,
        hConn: HSteamNetConnection,
        eValue: ESteamNetworkingConfigValue,
        val: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?SetGlobalCallback_SteamNetConnectionStatusChanged@ISteamNetworkingUtils@@QEAA_NP6AXPEAUSteamNetConnectionStatusChangedCallback_t@@@Z@Z"]
    pub fn ISteamNetworkingUtils_SetGlobalCallback_SteamNetConnectionStatusChanged(
        this: *mut ISteamNetworkingUtils,
        fnCallback: FnSteamNetConnectionStatusChanged,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?SetGlobalCallback_SteamNetAuthenticationStatusChanged@ISteamNetworkingUtils@@QEAA_NP6AXPEAUSteamNetAuthenticationStatus_t@@@Z@Z"]
    pub fn ISteamNetworkingUtils_SetGlobalCallback_SteamNetAuthenticationStatusChanged(
        this: *mut ISteamNetworkingUtils,
        fnCallback: FnSteamNetAuthenticationStatusChanged,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?SetGlobalCallback_SteamRelayNetworkStatusChanged@ISteamNetworkingUtils@@QEAA_NP6AXPEAUSteamRelayNetworkStatus_t@@@Z@Z"]
    pub fn ISteamNetworkingUtils_SetGlobalCallback_SteamRelayNetworkStatusChanged(
        this: *mut ISteamNetworkingUtils,
        fnCallback: FnSteamRelayNetworkStatusChanged,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?SetGlobalCallback_MessagesSessionRequest@ISteamNetworkingUtils@@QEAA_NP6AXPEAUSteamNetworkingMessagesSessionRequest_t@@@Z@Z"]
    pub fn ISteamNetworkingUtils_SetGlobalCallback_MessagesSessionRequest(
        this: *mut ISteamNetworkingUtils,
        fnCallback: FnSteamNetworkingMessagesSessionRequest,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}?SetGlobalCallback_MessagesSessionFailed@ISteamNetworkingUtils@@QEAA_NP6AXPEAUSteamNetworkingMessagesSessionFailed_t@@@Z@Z"]
    pub fn ISteamNetworkingUtils_SetGlobalCallback_MessagesSessionFailed(
        this: *mut ISteamNetworkingUtils,
        fnCallback: FnSteamNetworkingMessagesSessionFailed,
    ) -> bool;
}
extern "C" {
    #[doc = " Set a configuration value, using a struct to pass the value."]
    #[doc = " (This is just a convenience shortcut; see below for the implementation and"]
    #[doc = " a little insight into how SteamNetworkingConfigValue_t is used when"]
    #[doc = " setting config options during listen socket and connection creation.)"]
    #[link_name = "\u{1}?SetConfigValueStruct@ISteamNetworkingUtils@@QEAA_NAEBUSteamNetworkingConfigValue_t@@W4ESteamNetworkingConfigScope@@_J@Z"]
    pub fn ISteamNetworkingUtils_SetConfigValueStruct(
        this: *mut ISteamNetworkingUtils,
        opt: *const SteamNetworkingConfigValue_t,
        eScopeType: ESteamNetworkingConfigScope,
        scopeObj: isize,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}??_DISteamNetworkingUtils@@IEAAXXZ"]
    pub fn ISteamNetworkingUtils_ISteamNetworkingUtils_destructor(this: *mut ISteamNetworkingUtils);
}
impl ISteamNetworkingUtils {
    #[inline]
    pub unsafe fn SetGlobalConfigValueInt32(
        &mut self,
        eValue: ESteamNetworkingConfigValue,
        val: int32,
    ) -> bool {
        ISteamNetworkingUtils_SetGlobalConfigValueInt32(self, eValue, val)
    }
    #[inline]
    pub unsafe fn SetGlobalConfigValueFloat(
        &mut self,
        eValue: ESteamNetworkingConfigValue,
        val: f32,
    ) -> bool {
        ISteamNetworkingUtils_SetGlobalConfigValueFloat(self, eValue, val)
    }
    #[inline]
    pub unsafe fn SetGlobalConfigValueString(
        &mut self,
        eValue: ESteamNetworkingConfigValue,
        val: *const ::std::os::raw::c_char,
    ) -> bool {
        ISteamNetworkingUtils_SetGlobalConfigValueString(self, eValue, val)
    }
    #[inline]
    pub unsafe fn SetGlobalConfigValuePtr(
        &mut self,
        eValue: ESteamNetworkingConfigValue,
        val: *mut ::std::os::raw::c_void,
    ) -> bool {
        ISteamNetworkingUtils_SetGlobalConfigValuePtr(self, eValue, val)
    }
    #[inline]
    pub unsafe fn SetConnectionConfigValueInt32(
        &mut self,
        hConn: HSteamNetConnection,
        eValue: ESteamNetworkingConfigValue,
        val: int32,
    ) -> bool {
        ISteamNetworkingUtils_SetConnectionConfigValueInt32(self, hConn, eValue, val)
    }
    #[inline]
    pub unsafe fn SetConnectionConfigValueFloat(
        &mut self,
        hConn: HSteamNetConnection,
        eValue: ESteamNetworkingConfigValue,
        val: f32,
    ) -> bool {
        ISteamNetworkingUtils_SetConnectionConfigValueFloat(self, hConn, eValue, val)
    }
    #[inline]
    pub unsafe fn SetConnectionConfigValueString(
        &mut self,
        hConn: HSteamNetConnection,
        eValue: ESteamNetworkingConfigValue,
        val: *const ::std::os::raw::c_char,
    ) -> bool {
        ISteamNetworkingUtils_SetConnectionConfigValueString(self, hConn, eValue, val)
    }
    #[inline]
    pub unsafe fn SetGlobalCallback_SteamNetConnectionStatusChanged(
        &mut self,
        fnCallback: FnSteamNetConnectionStatusChanged,
    ) -> bool {
        ISteamNetworkingUtils_SetGlobalCallback_SteamNetConnectionStatusChanged(self, fnCallback)
    }
    #[inline]
    pub unsafe fn SetGlobalCallback_SteamNetAuthenticationStatusChanged(
        &mut self,
        fnCallback: FnSteamNetAuthenticationStatusChanged,
    ) -> bool {
        ISteamNetworkingUtils_SetGlobalCallback_SteamNetAuthenticationStatusChanged(
            self, fnCallback,
        )
    }
    #[inline]
    pub unsafe fn SetGlobalCallback_SteamRelayNetworkStatusChanged(
        &mut self,
        fnCallback: FnSteamRelayNetworkStatusChanged,
    ) -> bool {
        ISteamNetworkingUtils_SetGlobalCallback_SteamRelayNetworkStatusChanged(self, fnCallback)
    }
    #[inline]
    pub unsafe fn SetGlobalCallback_MessagesSessionRequest(
        &mut self,
        fnCallback: FnSteamNetworkingMessagesSessionRequest,
    ) -> bool {
        ISteamNetworkingUtils_SetGlobalCallback_MessagesSessionRequest(self, fnCallback)
    }
    #[inline]
    pub unsafe fn SetGlobalCallback_MessagesSessionFailed(
        &mut self,
        fnCallback: FnSteamNetworkingMessagesSessionFailed,
    ) -> bool {
        ISteamNetworkingUtils_SetGlobalCallback_MessagesSessionFailed(self, fnCallback)
    }
    #[inline]
    pub unsafe fn SetConfigValueStruct(
        &mut self,
        opt: *const SteamNetworkingConfigValue_t,
        eScopeType: ESteamNetworkingConfigScope,
        scopeObj: isize,
    ) -> bool {
        ISteamNetworkingUtils_SetConfigValueStruct(self, opt, eScopeType, scopeObj)
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        ISteamNetworkingUtils_ISteamNetworkingUtils_destructor(self)
    }
}
#[doc = " A struct used to describe our readiness to use the relay network."]
#[doc = " To do this we first need to fetch the network configuration,"]
#[doc = " which describes what POPs are available."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SteamRelayNetworkStatus_t {
    #[doc = " Summary status.  When this is \"current\", initialization has"]
    #[doc = " completed.  Anything else means you are not ready yet, or"]
    #[doc = " there is a significant problem."]
    pub m_eAvail: ESteamNetworkingAvailability,
    #[doc = " Nonzero if latency measurement is in progress (or pending,"]
    #[doc = " awaiting a prerequisite)."]
    pub m_bPingMeasurementInProgress: ::std::os::raw::c_int,
    #[doc = " Status obtaining the network config.  This is a prerequisite"]
    #[doc = " for relay network access."]
    #[doc = ""]
    #[doc = " Failure to obtain the network config almost always indicates"]
    #[doc = " a problem with the local internet connection."]
    pub m_eAvailNetworkConfig: ESteamNetworkingAvailability,
    #[doc = " Current ability to communicate with ANY relay.  Note that"]
    #[doc = " the complete failure to communicate with any relays almost"]
    #[doc = " always indicates a problem with the local Internet connection."]
    #[doc = " (However, just because you can reach a single relay doesn't"]
    #[doc = " mean that the local connection is in perfect health.)"]
    pub m_eAvailAnyRelay: ESteamNetworkingAvailability,
    #[doc = " Non-localized English language status.  For diagnostic/debugging"]
    #[doc = " purposes only."]
    pub m_debugMsg: [::std::os::raw::c_char; 256usize],
}
pub const SteamRelayNetworkStatus_t_k_iCallback: SteamRelayNetworkStatus_t__bindgen_ty_1 =
    SteamRelayNetworkStatus_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum SteamRelayNetworkStatus_t__bindgen_ty_1 {
    k_iCallback = 1281,
}
#[test]
fn bindgen_test_layout_SteamRelayNetworkStatus_t() {
    assert_eq!(
        ::std::mem::size_of::<SteamRelayNetworkStatus_t>(),
        272usize,
        concat!("Size of: ", stringify!(SteamRelayNetworkStatus_t))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamRelayNetworkStatus_t>(),
        4usize,
        concat!("Alignment of ", stringify!(SteamRelayNetworkStatus_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamRelayNetworkStatus_t>())).m_eAvail as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamRelayNetworkStatus_t),
            "::",
            stringify!(m_eAvail)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamRelayNetworkStatus_t>())).m_bPingMeasurementInProgress
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamRelayNetworkStatus_t),
            "::",
            stringify!(m_bPingMeasurementInProgress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamRelayNetworkStatus_t>())).m_eAvailNetworkConfig as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamRelayNetworkStatus_t),
            "::",
            stringify!(m_eAvailNetworkConfig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamRelayNetworkStatus_t>())).m_eAvailAnyRelay as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamRelayNetworkStatus_t),
            "::",
            stringify!(m_eAvailAnyRelay)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamRelayNetworkStatus_t>())).m_debugMsg as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamRelayNetworkStatus_t),
            "::",
            stringify!(m_debugMsg)
        )
    );
}
#[doc = " Utility class for printing a SteamNetworkingIdentity."]
#[doc = " E.g. printf( \"Identity is '%s'\\n\", SteamNetworkingIdentityRender( identity ).c_str() );"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SteamNetworkingIdentityRender {
    pub buf: [::std::os::raw::c_char; 128usize],
}
#[test]
fn bindgen_test_layout_SteamNetworkingIdentityRender() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetworkingIdentityRender>(),
        128usize,
        concat!("Size of: ", stringify!(SteamNetworkingIdentityRender))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetworkingIdentityRender>(),
        1usize,
        concat!("Alignment of ", stringify!(SteamNetworkingIdentityRender))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<SteamNetworkingIdentityRender>())).buf as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIdentityRender),
            "::",
            stringify!(buf)
        )
    );
}
#[doc = " Utility class for printing a SteamNetworkingIPAddrRender."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct SteamNetworkingIPAddrRender {
    pub buf: [::std::os::raw::c_char; 48usize],
}
#[test]
fn bindgen_test_layout_SteamNetworkingIPAddrRender() {
    assert_eq!(
        ::std::mem::size_of::<SteamNetworkingIPAddrRender>(),
        48usize,
        concat!("Size of: ", stringify!(SteamNetworkingIPAddrRender))
    );
    assert_eq!(
        ::std::mem::align_of::<SteamNetworkingIPAddrRender>(),
        1usize,
        concat!("Alignment of ", stringify!(SteamNetworkingIPAddrRender))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<SteamNetworkingIPAddrRender>())).buf as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(SteamNetworkingIPAddrRender),
            "::",
            stringify!(buf)
        )
    );
}
extern "C" {
    pub fn SteamAPI_Init() -> bool;
}
extern "C" {
    pub fn SteamAPI_Shutdown();
}
extern "C" {
    pub fn SteamAPI_RestartAppIfNecessary(unOwnAppID: uint32) -> bool;
}
extern "C" {
    pub fn SteamAPI_ReleaseCurrentThreadMemory();
}
extern "C" {
    pub fn SteamAPI_WriteMiniDump(
        uStructuredExceptionCode: uint32,
        pvExceptionInfo: *mut ::std::os::raw::c_void,
        uBuildID: uint32,
    );
}
extern "C" {
    pub fn SteamAPI_SetMiniDumpComment(pchMsg: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn SteamAPI_IsSteamRunning() -> bool;
}
extern "C" {
    pub fn SteamAPI_GetSteamInstallPath() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_SetTryCatchCallbacks(bTryCatchCallbacks: bool);
}
extern "C" {
    #[doc = " Inform the API that you wish to use manual event dispatch.  This must be called after SteamAPI_Init, but before"]
    #[doc = " you use any of the other manual dispatch functions below."]
    pub fn SteamAPI_ManualDispatch_Init();
}
extern "C" {
    #[doc = " Perform certain periodic actions that need to be performed."]
    pub fn SteamAPI_ManualDispatch_RunFrame(hSteamPipe: HSteamPipe);
}
extern "C" {
    #[doc = " Fetch the next pending callback on the given pipe, if any.  If a callback is available, true is returned"]
    #[doc = " and the structure is populated.  In this case, you MUST call SteamAPI_ManualDispatch_FreeLastCallback"]
    #[doc = " (after dispatching the callback) before calling SteamAPI_ManualDispatch_GetNextCallback again."]
    pub fn SteamAPI_ManualDispatch_GetNextCallback(
        hSteamPipe: HSteamPipe,
        pCallbackMsg: *mut CallbackMsg_t,
    ) -> bool;
}
extern "C" {
    #[doc = " You must call this after dispatching the callback, if SteamAPI_ManualDispatch_GetNextCallback returns true."]
    pub fn SteamAPI_ManualDispatch_FreeLastCallback(hSteamPipe: HSteamPipe);
}
extern "C" {
    #[doc = " Return the call result for the specified call on the specified pipe.  You really should"]
    #[doc = " only call this in a handler for SteamAPICallCompleted_t callback."]
    pub fn SteamAPI_ManualDispatch_GetAPICallResult(
        hSteamPipe: HSteamPipe,
        hSteamAPICall: SteamAPICall_t,
        pCallback: *mut ::std::os::raw::c_void,
        cubCallback: ::std::os::raw::c_int,
        iCallbackExpected: ::std::os::raw::c_int,
        pbFailed: *mut bool,
    ) -> bool;
}
#[repr(C)]
pub struct ISteamGameServer__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamGameServer {
    pub vtable_: *const ISteamGameServer__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamGameServer() {
    assert_eq!(
        ::std::mem::size_of::<ISteamGameServer>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamGameServer))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamGameServer>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamGameServer))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GSClientApprove_t {
    pub m_SteamID: CSteamID,
    pub m_OwnerSteamID: CSteamID,
}
pub const GSClientApprove_t_k_iCallback: GSClientApprove_t__bindgen_ty_1 =
    GSClientApprove_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GSClientApprove_t__bindgen_ty_1 {
    k_iCallback = 201,
}
#[test]
fn bindgen_test_layout_GSClientApprove_t() {
    assert_eq!(
        ::std::mem::size_of::<GSClientApprove_t>(),
        16usize,
        concat!("Size of: ", stringify!(GSClientApprove_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GSClientApprove_t>(),
        1usize,
        concat!("Alignment of ", stringify!(GSClientApprove_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSClientApprove_t>())).m_SteamID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GSClientApprove_t),
            "::",
            stringify!(m_SteamID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GSClientApprove_t>())).m_OwnerSteamID as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GSClientApprove_t),
            "::",
            stringify!(m_OwnerSteamID)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GSClientDeny_t {
    pub m_SteamID: CSteamID,
    pub m_eDenyReason: EDenyReason,
    pub m_rgchOptionalText: [::std::os::raw::c_char; 128usize],
}
pub const GSClientDeny_t_k_iCallback: GSClientDeny_t__bindgen_ty_1 =
    GSClientDeny_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GSClientDeny_t__bindgen_ty_1 {
    k_iCallback = 202,
}
#[test]
fn bindgen_test_layout_GSClientDeny_t() {
    assert_eq!(
        ::std::mem::size_of::<GSClientDeny_t>(),
        140usize,
        concat!("Size of: ", stringify!(GSClientDeny_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GSClientDeny_t>(),
        4usize,
        concat!("Alignment of ", stringify!(GSClientDeny_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSClientDeny_t>())).m_SteamID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GSClientDeny_t),
            "::",
            stringify!(m_SteamID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSClientDeny_t>())).m_eDenyReason as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GSClientDeny_t),
            "::",
            stringify!(m_eDenyReason)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GSClientDeny_t>())).m_rgchOptionalText as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(GSClientDeny_t),
            "::",
            stringify!(m_rgchOptionalText)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GSClientKick_t {
    pub m_SteamID: CSteamID,
    pub m_eDenyReason: EDenyReason,
}
pub const GSClientKick_t_k_iCallback: GSClientKick_t__bindgen_ty_1 =
    GSClientKick_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GSClientKick_t__bindgen_ty_1 {
    k_iCallback = 203,
}
#[test]
fn bindgen_test_layout_GSClientKick_t() {
    assert_eq!(
        ::std::mem::size_of::<GSClientKick_t>(),
        12usize,
        concat!("Size of: ", stringify!(GSClientKick_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GSClientKick_t>(),
        4usize,
        concat!("Alignment of ", stringify!(GSClientKick_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSClientKick_t>())).m_SteamID as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GSClientKick_t),
            "::",
            stringify!(m_SteamID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSClientKick_t>())).m_eDenyReason as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GSClientKick_t),
            "::",
            stringify!(m_eDenyReason)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GSClientAchievementStatus_t {
    pub m_SteamID: uint64,
    pub m_pchAchievement: [::std::os::raw::c_char; 128usize],
    pub m_bUnlocked: bool,
}
pub const GSClientAchievementStatus_t_k_iCallback: GSClientAchievementStatus_t__bindgen_ty_1 =
    GSClientAchievementStatus_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GSClientAchievementStatus_t__bindgen_ty_1 {
    k_iCallback = 206,
}
#[test]
fn bindgen_test_layout_GSClientAchievementStatus_t() {
    assert_eq!(
        ::std::mem::size_of::<GSClientAchievementStatus_t>(),
        144usize,
        concat!("Size of: ", stringify!(GSClientAchievementStatus_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GSClientAchievementStatus_t>(),
        8usize,
        concat!("Alignment of ", stringify!(GSClientAchievementStatus_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GSClientAchievementStatus_t>())).m_SteamID as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GSClientAchievementStatus_t),
            "::",
            stringify!(m_SteamID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GSClientAchievementStatus_t>())).m_pchAchievement as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GSClientAchievementStatus_t),
            "::",
            stringify!(m_pchAchievement)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GSClientAchievementStatus_t>())).m_bUnlocked as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(GSClientAchievementStatus_t),
            "::",
            stringify!(m_bUnlocked)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GSPolicyResponse_t {
    pub m_bSecure: uint8,
}
pub const GSPolicyResponse_t_k_iCallback: GSPolicyResponse_t__bindgen_ty_1 =
    GSPolicyResponse_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GSPolicyResponse_t__bindgen_ty_1 {
    k_iCallback = 115,
}
#[test]
fn bindgen_test_layout_GSPolicyResponse_t() {
    assert_eq!(
        ::std::mem::size_of::<GSPolicyResponse_t>(),
        1usize,
        concat!("Size of: ", stringify!(GSPolicyResponse_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GSPolicyResponse_t>(),
        1usize,
        concat!("Alignment of ", stringify!(GSPolicyResponse_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSPolicyResponse_t>())).m_bSecure as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GSPolicyResponse_t),
            "::",
            stringify!(m_bSecure)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GSGameplayStats_t {
    pub m_eResult: EResult,
    pub m_nRank: int32,
    pub m_unTotalConnects: uint32,
    pub m_unTotalMinutesPlayed: uint32,
}
pub const GSGameplayStats_t_k_iCallback: GSGameplayStats_t__bindgen_ty_1 =
    GSGameplayStats_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GSGameplayStats_t__bindgen_ty_1 {
    k_iCallback = 207,
}
#[test]
fn bindgen_test_layout_GSGameplayStats_t() {
    assert_eq!(
        ::std::mem::size_of::<GSGameplayStats_t>(),
        16usize,
        concat!("Size of: ", stringify!(GSGameplayStats_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GSGameplayStats_t>(),
        4usize,
        concat!("Alignment of ", stringify!(GSGameplayStats_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSGameplayStats_t>())).m_eResult as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GSGameplayStats_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSGameplayStats_t>())).m_nRank as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GSGameplayStats_t),
            "::",
            stringify!(m_nRank)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GSGameplayStats_t>())).m_unTotalConnects as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GSGameplayStats_t),
            "::",
            stringify!(m_unTotalConnects)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GSGameplayStats_t>())).m_unTotalMinutesPlayed as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(GSGameplayStats_t),
            "::",
            stringify!(m_unTotalMinutesPlayed)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GSClientGroupStatus_t {
    pub m_SteamIDUser: CSteamID,
    pub m_SteamIDGroup: CSteamID,
    pub m_bMember: bool,
    pub m_bOfficer: bool,
}
pub const GSClientGroupStatus_t_k_iCallback: GSClientGroupStatus_t__bindgen_ty_1 =
    GSClientGroupStatus_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GSClientGroupStatus_t__bindgen_ty_1 {
    k_iCallback = 208,
}
#[test]
fn bindgen_test_layout_GSClientGroupStatus_t() {
    assert_eq!(
        ::std::mem::size_of::<GSClientGroupStatus_t>(),
        18usize,
        concat!("Size of: ", stringify!(GSClientGroupStatus_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GSClientGroupStatus_t>(),
        1usize,
        concat!("Alignment of ", stringify!(GSClientGroupStatus_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GSClientGroupStatus_t>())).m_SteamIDUser as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GSClientGroupStatus_t),
            "::",
            stringify!(m_SteamIDUser)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GSClientGroupStatus_t>())).m_SteamIDGroup as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GSClientGroupStatus_t),
            "::",
            stringify!(m_SteamIDGroup)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSClientGroupStatus_t>())).m_bMember as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(GSClientGroupStatus_t),
            "::",
            stringify!(m_bMember)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GSClientGroupStatus_t>())).m_bOfficer as *const _ as usize
        },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(GSClientGroupStatus_t),
            "::",
            stringify!(m_bOfficer)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GSReputation_t {
    pub m_eResult: EResult,
    pub m_unReputationScore: uint32,
    pub m_bBanned: bool,
    pub m_unBannedIP: uint32,
    pub m_usBannedPort: uint16,
    pub m_ulBannedGameID: uint64,
    pub m_unBanExpires: uint32,
}
pub const GSReputation_t_k_iCallback: GSReputation_t__bindgen_ty_1 =
    GSReputation_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GSReputation_t__bindgen_ty_1 {
    k_iCallback = 209,
}
#[test]
fn bindgen_test_layout_GSReputation_t() {
    assert_eq!(
        ::std::mem::size_of::<GSReputation_t>(),
        40usize,
        concat!("Size of: ", stringify!(GSReputation_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GSReputation_t>(),
        8usize,
        concat!("Alignment of ", stringify!(GSReputation_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSReputation_t>())).m_eResult as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GSReputation_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<GSReputation_t>())).m_unReputationScore as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GSReputation_t),
            "::",
            stringify!(m_unReputationScore)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSReputation_t>())).m_bBanned as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GSReputation_t),
            "::",
            stringify!(m_bBanned)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSReputation_t>())).m_unBannedIP as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(GSReputation_t),
            "::",
            stringify!(m_unBannedIP)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSReputation_t>())).m_usBannedPort as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(GSReputation_t),
            "::",
            stringify!(m_usBannedPort)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSReputation_t>())).m_ulBannedGameID as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(GSReputation_t),
            "::",
            stringify!(m_ulBannedGameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSReputation_t>())).m_unBanExpires as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(GSReputation_t),
            "::",
            stringify!(m_unBanExpires)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AssociateWithClanResult_t {
    pub m_eResult: EResult,
}
pub const AssociateWithClanResult_t_k_iCallback: AssociateWithClanResult_t__bindgen_ty_1 =
    AssociateWithClanResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AssociateWithClanResult_t__bindgen_ty_1 {
    k_iCallback = 210,
}
#[test]
fn bindgen_test_layout_AssociateWithClanResult_t() {
    assert_eq!(
        ::std::mem::size_of::<AssociateWithClanResult_t>(),
        4usize,
        concat!("Size of: ", stringify!(AssociateWithClanResult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<AssociateWithClanResult_t>(),
        4usize,
        concat!("Alignment of ", stringify!(AssociateWithClanResult_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<AssociateWithClanResult_t>())).m_eResult as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(AssociateWithClanResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ComputeNewPlayerCompatibilityResult_t {
    pub m_eResult: EResult,
    pub m_cPlayersThatDontLikeCandidate: ::std::os::raw::c_int,
    pub m_cPlayersThatCandidateDoesntLike: ::std::os::raw::c_int,
    pub m_cClanPlayersThatDontLikeCandidate: ::std::os::raw::c_int,
    pub m_SteamIDCandidate: CSteamID,
}
pub const ComputeNewPlayerCompatibilityResult_t_k_iCallback:
    ComputeNewPlayerCompatibilityResult_t__bindgen_ty_1 =
    ComputeNewPlayerCompatibilityResult_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ComputeNewPlayerCompatibilityResult_t__bindgen_ty_1 {
    k_iCallback = 211,
}
#[test]
fn bindgen_test_layout_ComputeNewPlayerCompatibilityResult_t() {
    assert_eq!(
        ::std::mem::size_of::<ComputeNewPlayerCompatibilityResult_t>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(ComputeNewPlayerCompatibilityResult_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<ComputeNewPlayerCompatibilityResult_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(ComputeNewPlayerCompatibilityResult_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ComputeNewPlayerCompatibilityResult_t>())).m_eResult as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ComputeNewPlayerCompatibilityResult_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ComputeNewPlayerCompatibilityResult_t>()))
                .m_cPlayersThatDontLikeCandidate as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ComputeNewPlayerCompatibilityResult_t),
            "::",
            stringify!(m_cPlayersThatDontLikeCandidate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ComputeNewPlayerCompatibilityResult_t>()))
                .m_cPlayersThatCandidateDoesntLike as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ComputeNewPlayerCompatibilityResult_t),
            "::",
            stringify!(m_cPlayersThatCandidateDoesntLike)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ComputeNewPlayerCompatibilityResult_t>()))
                .m_cClanPlayersThatDontLikeCandidate as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ComputeNewPlayerCompatibilityResult_t),
            "::",
            stringify!(m_cClanPlayersThatDontLikeCandidate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ComputeNewPlayerCompatibilityResult_t>())).m_SteamIDCandidate
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ComputeNewPlayerCompatibilityResult_t),
            "::",
            stringify!(m_SteamIDCandidate)
        )
    );
}
#[repr(C)]
pub struct ISteamGameServerStats__bindgen_vtable(::std::os::raw::c_void);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ISteamGameServerStats {
    pub vtable_: *const ISteamGameServerStats__bindgen_vtable,
}
#[test]
fn bindgen_test_layout_ISteamGameServerStats() {
    assert_eq!(
        ::std::mem::size_of::<ISteamGameServerStats>(),
        8usize,
        concat!("Size of: ", stringify!(ISteamGameServerStats))
    );
    assert_eq!(
        ::std::mem::align_of::<ISteamGameServerStats>(),
        8usize,
        concat!("Alignment of ", stringify!(ISteamGameServerStats))
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GSStatsReceived_t {
    pub m_eResult: EResult,
    pub m_steamIDUser: CSteamID,
}
pub const GSStatsReceived_t_k_iCallback: GSStatsReceived_t__bindgen_ty_1 =
    GSStatsReceived_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GSStatsReceived_t__bindgen_ty_1 {
    k_iCallback = 1800,
}
#[test]
fn bindgen_test_layout_GSStatsReceived_t() {
    assert_eq!(
        ::std::mem::size_of::<GSStatsReceived_t>(),
        12usize,
        concat!("Size of: ", stringify!(GSStatsReceived_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GSStatsReceived_t>(),
        4usize,
        concat!("Alignment of ", stringify!(GSStatsReceived_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSStatsReceived_t>())).m_eResult as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GSStatsReceived_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSStatsReceived_t>())).m_steamIDUser as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GSStatsReceived_t),
            "::",
            stringify!(m_steamIDUser)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GSStatsStored_t {
    pub m_eResult: EResult,
    pub m_steamIDUser: CSteamID,
}
pub const GSStatsStored_t_k_iCallback: GSStatsStored_t__bindgen_ty_1 =
    GSStatsStored_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GSStatsStored_t__bindgen_ty_1 {
    k_iCallback = 1801,
}
#[test]
fn bindgen_test_layout_GSStatsStored_t() {
    assert_eq!(
        ::std::mem::size_of::<GSStatsStored_t>(),
        12usize,
        concat!("Size of: ", stringify!(GSStatsStored_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GSStatsStored_t>(),
        4usize,
        concat!("Alignment of ", stringify!(GSStatsStored_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSStatsStored_t>())).m_eResult as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GSStatsStored_t),
            "::",
            stringify!(m_eResult)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSStatsStored_t>())).m_steamIDUser as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(GSStatsStored_t),
            "::",
            stringify!(m_steamIDUser)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GSStatsUnloaded_t {
    pub m_steamIDUser: CSteamID,
}
pub const GSStatsUnloaded_t_k_iCallback: GSStatsUnloaded_t__bindgen_ty_1 =
    GSStatsUnloaded_t__bindgen_ty_1::k_iCallback;
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum GSStatsUnloaded_t__bindgen_ty_1 {
    k_iCallback = 1108,
}
#[test]
fn bindgen_test_layout_GSStatsUnloaded_t() {
    assert_eq!(
        ::std::mem::size_of::<GSStatsUnloaded_t>(),
        8usize,
        concat!("Size of: ", stringify!(GSStatsUnloaded_t))
    );
    assert_eq!(
        ::std::mem::align_of::<GSStatsUnloaded_t>(),
        1usize,
        concat!("Alignment of ", stringify!(GSStatsUnloaded_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GSStatsUnloaded_t>())).m_steamIDUser as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GSStatsUnloaded_t),
            "::",
            stringify!(m_steamIDUser)
        )
    );
}
pub type uint64_steamid = uint64;
pub type uint64_gameid = uint64;
extern "C" {
    pub fn SteamAPI_ISteamClient_CreateSteamPipe(self_: *mut ISteamClient) -> HSteamPipe;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_BReleaseSteamPipe(
        self_: *mut ISteamClient,
        hSteamPipe: HSteamPipe,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_ConnectToGlobalUser(
        self_: *mut ISteamClient,
        hSteamPipe: HSteamPipe,
    ) -> HSteamUser;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_CreateLocalUser(
        self_: *mut ISteamClient,
        phSteamPipe: *mut HSteamPipe,
        eAccountType: EAccountType,
    ) -> HSteamUser;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_ReleaseUser(
        self_: *mut ISteamClient,
        hSteamPipe: HSteamPipe,
        hUser: HSteamUser,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamUser(
        self_: *mut ISteamClient,
        hSteamUser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamUser;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamGameServer(
        self_: *mut ISteamClient,
        hSteamUser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamGameServer;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_SetLocalIPBinding(
        self_: *mut ISteamClient,
        unIP: *const SteamIPAddress_t,
        usPort: uint16,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamFriends(
        self_: *mut ISteamClient,
        hSteamUser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamFriends;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamUtils(
        self_: *mut ISteamClient,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamUtils;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamMatchmaking(
        self_: *mut ISteamClient,
        hSteamUser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamMatchmaking;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamMatchmakingServers(
        self_: *mut ISteamClient,
        hSteamUser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamMatchmakingServers;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamGenericInterface(
        self_: *mut ISteamClient,
        hSteamUser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamUserStats(
        self_: *mut ISteamClient,
        hSteamUser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamUserStats;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamGameServerStats(
        self_: *mut ISteamClient,
        hSteamuser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamGameServerStats;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamApps(
        self_: *mut ISteamClient,
        hSteamUser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamApps;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamNetworking(
        self_: *mut ISteamClient,
        hSteamUser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamNetworking;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamRemoteStorage(
        self_: *mut ISteamClient,
        hSteamuser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamRemoteStorage;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamScreenshots(
        self_: *mut ISteamClient,
        hSteamuser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamScreenshots;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamGameSearch(
        self_: *mut ISteamClient,
        hSteamuser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamGameSearch;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetIPCCallCount(self_: *mut ISteamClient) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_SetWarningMessageHook(
        self_: *mut ISteamClient,
        pFunction: SteamAPIWarningMessageHook_t,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamClient_BShutdownIfAllPipesClosed(self_: *mut ISteamClient) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamHTTP(
        self_: *mut ISteamClient,
        hSteamuser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamHTTP;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamController(
        self_: *mut ISteamClient,
        hSteamUser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamController;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamUGC(
        self_: *mut ISteamClient,
        hSteamUser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamUGC;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamAppList(
        self_: *mut ISteamClient,
        hSteamUser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamAppList;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamMusic(
        self_: *mut ISteamClient,
        hSteamuser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamMusic;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamMusicRemote(
        self_: *mut ISteamClient,
        hSteamuser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamMusicRemote;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamHTMLSurface(
        self_: *mut ISteamClient,
        hSteamuser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamHTMLSurface;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamInventory(
        self_: *mut ISteamClient,
        hSteamuser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamInventory;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamVideo(
        self_: *mut ISteamClient,
        hSteamuser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamVideo;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamParentalSettings(
        self_: *mut ISteamClient,
        hSteamuser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamParentalSettings;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamInput(
        self_: *mut ISteamClient,
        hSteamUser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamInput;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamParties(
        self_: *mut ISteamClient,
        hSteamUser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamParties;
}
extern "C" {
    pub fn SteamAPI_ISteamClient_GetISteamRemotePlay(
        self_: *mut ISteamClient,
        hSteamUser: HSteamUser,
        hSteamPipe: HSteamPipe,
        pchVersion: *const ::std::os::raw::c_char,
    ) -> *mut ISteamRemotePlay;
}
extern "C" {
    pub fn SteamAPI_SteamUser_v021() -> *mut ISteamUser;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_GetHSteamUser(self_: *mut ISteamUser) -> HSteamUser;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_BLoggedOn(self_: *mut ISteamUser) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_GetSteamID(self_: *mut ISteamUser) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_InitiateGameConnection(
        self_: *mut ISteamUser,
        pAuthBlob: *mut ::std::os::raw::c_void,
        cbMaxAuthBlob: ::std::os::raw::c_int,
        steamIDGameServer: uint64_steamid,
        unIPServer: uint32,
        usPortServer: uint16,
        bSecure: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_TerminateGameConnection(
        self_: *mut ISteamUser,
        unIPServer: uint32,
        usPortServer: uint16,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamUser_TrackAppUsageEvent(
        self_: *mut ISteamUser,
        gameID: uint64_gameid,
        eAppUsageEvent: ::std::os::raw::c_int,
        pchExtraInfo: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamUser_GetUserDataFolder(
        self_: *mut ISteamUser,
        pchBuffer: *mut ::std::os::raw::c_char,
        cubBuffer: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_StartVoiceRecording(self_: *mut ISteamUser);
}
extern "C" {
    pub fn SteamAPI_ISteamUser_StopVoiceRecording(self_: *mut ISteamUser);
}
extern "C" {
    pub fn SteamAPI_ISteamUser_GetAvailableVoice(
        self_: *mut ISteamUser,
        pcbCompressed: *mut uint32,
        pcbUncompressed_Deprecated: *mut uint32,
        nUncompressedVoiceDesiredSampleRate_Deprecated: uint32,
    ) -> EVoiceResult;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_GetVoice(
        self_: *mut ISteamUser,
        bWantCompressed: bool,
        pDestBuffer: *mut ::std::os::raw::c_void,
        cbDestBufferSize: uint32,
        nBytesWritten: *mut uint32,
        bWantUncompressed_Deprecated: bool,
        pUncompressedDestBuffer_Deprecated: *mut ::std::os::raw::c_void,
        cbUncompressedDestBufferSize_Deprecated: uint32,
        nUncompressBytesWritten_Deprecated: *mut uint32,
        nUncompressedVoiceDesiredSampleRate_Deprecated: uint32,
    ) -> EVoiceResult;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_DecompressVoice(
        self_: *mut ISteamUser,
        pCompressed: *const ::std::os::raw::c_void,
        cbCompressed: uint32,
        pDestBuffer: *mut ::std::os::raw::c_void,
        cbDestBufferSize: uint32,
        nBytesWritten: *mut uint32,
        nDesiredSampleRate: uint32,
    ) -> EVoiceResult;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_GetVoiceOptimalSampleRate(self_: *mut ISteamUser) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_GetAuthSessionTicket(
        self_: *mut ISteamUser,
        pTicket: *mut ::std::os::raw::c_void,
        cbMaxTicket: ::std::os::raw::c_int,
        pcbTicket: *mut uint32,
    ) -> HAuthTicket;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_BeginAuthSession(
        self_: *mut ISteamUser,
        pAuthTicket: *const ::std::os::raw::c_void,
        cbAuthTicket: ::std::os::raw::c_int,
        steamID: uint64_steamid,
    ) -> EBeginAuthSessionResult;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_EndAuthSession(self_: *mut ISteamUser, steamID: uint64_steamid);
}
extern "C" {
    pub fn SteamAPI_ISteamUser_CancelAuthTicket(self_: *mut ISteamUser, hAuthTicket: HAuthTicket);
}
extern "C" {
    pub fn SteamAPI_ISteamUser_UserHasLicenseForApp(
        self_: *mut ISteamUser,
        steamID: uint64_steamid,
        appID: AppId_t,
    ) -> EUserHasLicenseForAppResult;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_BIsBehindNAT(self_: *mut ISteamUser) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_AdvertiseGame(
        self_: *mut ISteamUser,
        steamIDGameServer: uint64_steamid,
        unIPServer: uint32,
        usPortServer: uint16,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamUser_RequestEncryptedAppTicket(
        self_: *mut ISteamUser,
        pDataToInclude: *mut ::std::os::raw::c_void,
        cbDataToInclude: ::std::os::raw::c_int,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_GetEncryptedAppTicket(
        self_: *mut ISteamUser,
        pTicket: *mut ::std::os::raw::c_void,
        cbMaxTicket: ::std::os::raw::c_int,
        pcbTicket: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_GetGameBadgeLevel(
        self_: *mut ISteamUser,
        nSeries: ::std::os::raw::c_int,
        bFoil: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_GetPlayerSteamLevel(self_: *mut ISteamUser)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_RequestStoreAuthURL(
        self_: *mut ISteamUser,
        pchRedirectURL: *const ::std::os::raw::c_char,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_BIsPhoneVerified(self_: *mut ISteamUser) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_BIsTwoFactorEnabled(self_: *mut ISteamUser) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_BIsPhoneIdentifying(self_: *mut ISteamUser) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_BIsPhoneRequiringVerification(self_: *mut ISteamUser) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_GetMarketEligibility(self_: *mut ISteamUser) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_GetDurationControl(self_: *mut ISteamUser) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUser_BSetDurationControlOnlineState(
        self_: *mut ISteamUser,
        eNewState: EDurationControlOnlineState,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamFriends_v017() -> *mut ISteamFriends;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetPersonaName(
        self_: *mut ISteamFriends,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_SetPersonaName(
        self_: *mut ISteamFriends,
        pchPersonaName: *const ::std::os::raw::c_char,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetPersonaState(self_: *mut ISteamFriends) -> EPersonaState;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendCount(
        self_: *mut ISteamFriends,
        iFriendFlags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendByIndex(
        self_: *mut ISteamFriends,
        iFriend: ::std::os::raw::c_int,
        iFriendFlags: ::std::os::raw::c_int,
    ) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendRelationship(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
    ) -> EFriendRelationship;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendPersonaState(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
    ) -> EPersonaState;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendPersonaName(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendGamePlayed(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
        pFriendGameInfo: *mut FriendGameInfo_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendPersonaNameHistory(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
        iPersonaName: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendSteamLevel(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetPlayerNickname(
        self_: *mut ISteamFriends,
        steamIDPlayer: uint64_steamid,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendsGroupCount(
        self_: *mut ISteamFriends,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendsGroupIDByIndex(
        self_: *mut ISteamFriends,
        iFG: ::std::os::raw::c_int,
    ) -> FriendsGroupID_t;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendsGroupName(
        self_: *mut ISteamFriends,
        friendsGroupID: FriendsGroupID_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendsGroupMembersCount(
        self_: *mut ISteamFriends,
        friendsGroupID: FriendsGroupID_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendsGroupMembersList(
        self_: *mut ISteamFriends,
        friendsGroupID: FriendsGroupID_t,
        pOutSteamIDMembers: *mut CSteamID,
        nMembersCount: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_HasFriend(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
        iFriendFlags: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetClanCount(self_: *mut ISteamFriends) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetClanByIndex(
        self_: *mut ISteamFriends,
        iClan: ::std::os::raw::c_int,
    ) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetClanName(
        self_: *mut ISteamFriends,
        steamIDClan: uint64_steamid,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetClanTag(
        self_: *mut ISteamFriends,
        steamIDClan: uint64_steamid,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetClanActivityCounts(
        self_: *mut ISteamFriends,
        steamIDClan: uint64_steamid,
        pnOnline: *mut ::std::os::raw::c_int,
        pnInGame: *mut ::std::os::raw::c_int,
        pnChatting: *mut ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_DownloadClanActivityCounts(
        self_: *mut ISteamFriends,
        psteamIDClans: *mut CSteamID,
        cClansToRequest: ::std::os::raw::c_int,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendCountFromSource(
        self_: *mut ISteamFriends,
        steamIDSource: uint64_steamid,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendFromSourceByIndex(
        self_: *mut ISteamFriends,
        steamIDSource: uint64_steamid,
        iFriend: ::std::os::raw::c_int,
    ) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_IsUserInSource(
        self_: *mut ISteamFriends,
        steamIDUser: uint64_steamid,
        steamIDSource: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_SetInGameVoiceSpeaking(
        self_: *mut ISteamFriends,
        steamIDUser: uint64_steamid,
        bSpeaking: bool,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_ActivateGameOverlay(
        self_: *mut ISteamFriends,
        pchDialog: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_ActivateGameOverlayToUser(
        self_: *mut ISteamFriends,
        pchDialog: *const ::std::os::raw::c_char,
        steamID: uint64_steamid,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_ActivateGameOverlayToWebPage(
        self_: *mut ISteamFriends,
        pchURL: *const ::std::os::raw::c_char,
        eMode: EActivateGameOverlayToWebPageMode,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_ActivateGameOverlayToStore(
        self_: *mut ISteamFriends,
        nAppID: AppId_t,
        eFlag: EOverlayToStoreFlag,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_SetPlayedWith(
        self_: *mut ISteamFriends,
        steamIDUserPlayedWith: uint64_steamid,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_ActivateGameOverlayInviteDialog(
        self_: *mut ISteamFriends,
        steamIDLobby: uint64_steamid,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetSmallFriendAvatar(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetMediumFriendAvatar(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetLargeFriendAvatar(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_RequestUserInformation(
        self_: *mut ISteamFriends,
        steamIDUser: uint64_steamid,
        bRequireNameOnly: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_RequestClanOfficerList(
        self_: *mut ISteamFriends,
        steamIDClan: uint64_steamid,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetClanOwner(
        self_: *mut ISteamFriends,
        steamIDClan: uint64_steamid,
    ) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetClanOfficerCount(
        self_: *mut ISteamFriends,
        steamIDClan: uint64_steamid,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetClanOfficerByIndex(
        self_: *mut ISteamFriends,
        steamIDClan: uint64_steamid,
        iOfficer: ::std::os::raw::c_int,
    ) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetUserRestrictions(self_: *mut ISteamFriends) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_SetRichPresence(
        self_: *mut ISteamFriends,
        pchKey: *const ::std::os::raw::c_char,
        pchValue: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_ClearRichPresence(self_: *mut ISteamFriends);
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendRichPresence(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
        pchKey: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendRichPresenceKeyCount(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendRichPresenceKeyByIndex(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
        iKey: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_RequestFriendRichPresence(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_InviteUserToGame(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
        pchConnectString: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetCoplayFriendCount(
        self_: *mut ISteamFriends,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetCoplayFriend(
        self_: *mut ISteamFriends,
        iCoplayFriend: ::std::os::raw::c_int,
    ) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendCoplayTime(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendCoplayGame(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
    ) -> AppId_t;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_JoinClanChatRoom(
        self_: *mut ISteamFriends,
        steamIDClan: uint64_steamid,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_LeaveClanChatRoom(
        self_: *mut ISteamFriends,
        steamIDClan: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetClanChatMemberCount(
        self_: *mut ISteamFriends,
        steamIDClan: uint64_steamid,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetChatMemberByIndex(
        self_: *mut ISteamFriends,
        steamIDClan: uint64_steamid,
        iUser: ::std::os::raw::c_int,
    ) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_SendClanChatMessage(
        self_: *mut ISteamFriends,
        steamIDClanChat: uint64_steamid,
        pchText: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetClanChatMessage(
        self_: *mut ISteamFriends,
        steamIDClanChat: uint64_steamid,
        iMessage: ::std::os::raw::c_int,
        prgchText: *mut ::std::os::raw::c_void,
        cchTextMax: ::std::os::raw::c_int,
        peChatEntryType: *mut EChatEntryType,
        psteamidChatter: *mut CSteamID,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_IsClanChatAdmin(
        self_: *mut ISteamFriends,
        steamIDClanChat: uint64_steamid,
        steamIDUser: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_IsClanChatWindowOpenInSteam(
        self_: *mut ISteamFriends,
        steamIDClanChat: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_OpenClanChatWindowInSteam(
        self_: *mut ISteamFriends,
        steamIDClanChat: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_CloseClanChatWindowInSteam(
        self_: *mut ISteamFriends,
        steamIDClanChat: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_SetListenForFriendsMessages(
        self_: *mut ISteamFriends,
        bInterceptEnabled: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_ReplyToFriendMessage(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
        pchMsgToSend: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFriendMessage(
        self_: *mut ISteamFriends,
        steamIDFriend: uint64_steamid,
        iMessageID: ::std::os::raw::c_int,
        pvData: *mut ::std::os::raw::c_void,
        cubData: ::std::os::raw::c_int,
        peChatEntryType: *mut EChatEntryType,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetFollowerCount(
        self_: *mut ISteamFriends,
        steamID: uint64_steamid,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_IsFollowing(
        self_: *mut ISteamFriends,
        steamID: uint64_steamid,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_EnumerateFollowingList(
        self_: *mut ISteamFriends,
        unStartIndex: uint32,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_IsClanPublic(
        self_: *mut ISteamFriends,
        steamIDClan: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_IsClanOfficialGameGroup(
        self_: *mut ISteamFriends,
        steamIDClan: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_GetNumChatsWithUnreadPriorityMessages(
        self_: *mut ISteamFriends,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_ActivateGameOverlayRemotePlayTogetherInviteDialog(
        self_: *mut ISteamFriends,
        steamIDLobby: uint64_steamid,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_RegisterProtocolInOverlayBrowser(
        self_: *mut ISteamFriends,
        pchProtocol: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamFriends_ActivateGameOverlayInviteDialogConnectString(
        self_: *mut ISteamFriends,
        pchConnectString: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_SteamUtils_v010() -> *mut ISteamUtils;
}
extern "C" {
    pub fn SteamAPI_SteamGameServerUtils_v010() -> *mut ISteamUtils;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetSecondsSinceAppActive(self_: *mut ISteamUtils) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetSecondsSinceComputerActive(self_: *mut ISteamUtils) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetConnectedUniverse(self_: *mut ISteamUtils) -> EUniverse;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetServerRealTime(self_: *mut ISteamUtils) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetIPCountry(
        self_: *mut ISteamUtils,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetImageSize(
        self_: *mut ISteamUtils,
        iImage: ::std::os::raw::c_int,
        pnWidth: *mut uint32,
        pnHeight: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetImageRGBA(
        self_: *mut ISteamUtils,
        iImage: ::std::os::raw::c_int,
        pubDest: *mut uint8,
        nDestBufferSize: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetCurrentBatteryPower(self_: *mut ISteamUtils) -> uint8;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetAppID(self_: *mut ISteamUtils) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_SetOverlayNotificationPosition(
        self_: *mut ISteamUtils,
        eNotificationPosition: ENotificationPosition,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_IsAPICallCompleted(
        self_: *mut ISteamUtils,
        hSteamAPICall: SteamAPICall_t,
        pbFailed: *mut bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetAPICallFailureReason(
        self_: *mut ISteamUtils,
        hSteamAPICall: SteamAPICall_t,
    ) -> ESteamAPICallFailure;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetAPICallResult(
        self_: *mut ISteamUtils,
        hSteamAPICall: SteamAPICall_t,
        pCallback: *mut ::std::os::raw::c_void,
        cubCallback: ::std::os::raw::c_int,
        iCallbackExpected: ::std::os::raw::c_int,
        pbFailed: *mut bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetIPCCallCount(self_: *mut ISteamUtils) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_SetWarningMessageHook(
        self_: *mut ISteamUtils,
        pFunction: SteamAPIWarningMessageHook_t,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_IsOverlayEnabled(self_: *mut ISteamUtils) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_BOverlayNeedsPresent(self_: *mut ISteamUtils) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_CheckFileSignature(
        self_: *mut ISteamUtils,
        szFileName: *const ::std::os::raw::c_char,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_ShowGamepadTextInput(
        self_: *mut ISteamUtils,
        eInputMode: EGamepadTextInputMode,
        eLineInputMode: EGamepadTextInputLineMode,
        pchDescription: *const ::std::os::raw::c_char,
        unCharMax: uint32,
        pchExistingText: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetEnteredGamepadTextLength(self_: *mut ISteamUtils) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetEnteredGamepadTextInput(
        self_: *mut ISteamUtils,
        pchText: *mut ::std::os::raw::c_char,
        cchText: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetSteamUILanguage(
        self_: *mut ISteamUtils,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_IsSteamRunningInVR(self_: *mut ISteamUtils) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_SetOverlayNotificationInset(
        self_: *mut ISteamUtils,
        nHorizontalInset: ::std::os::raw::c_int,
        nVerticalInset: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_IsSteamInBigPictureMode(self_: *mut ISteamUtils) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_StartVRDashboard(self_: *mut ISteamUtils);
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_IsVRHeadsetStreamingEnabled(self_: *mut ISteamUtils) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_SetVRHeadsetStreamingEnabled(
        self_: *mut ISteamUtils,
        bEnabled: bool,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_IsSteamChinaLauncher(self_: *mut ISteamUtils) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_InitFilterText(
        self_: *mut ISteamUtils,
        unFilterOptions: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_FilterText(
        self_: *mut ISteamUtils,
        eContext: ETextFilteringContext,
        sourceSteamID: uint64_steamid,
        pchInputMessage: *const ::std::os::raw::c_char,
        pchOutFilteredText: *mut ::std::os::raw::c_char,
        nByteSizeOutFilteredText: uint32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamUtils_GetIPv6ConnectivityState(
        self_: *mut ISteamUtils,
        eProtocol: ESteamIPv6ConnectivityProtocol,
    ) -> ESteamIPv6ConnectivityState;
}
extern "C" {
    pub fn SteamAPI_SteamMatchmaking_v009() -> *mut ISteamMatchmaking;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_GetFavoriteGameCount(
        self_: *mut ISteamMatchmaking,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_GetFavoriteGame(
        self_: *mut ISteamMatchmaking,
        iGame: ::std::os::raw::c_int,
        pnAppID: *mut AppId_t,
        pnIP: *mut uint32,
        pnConnPort: *mut uint16,
        pnQueryPort: *mut uint16,
        punFlags: *mut uint32,
        pRTime32LastPlayedOnServer: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_AddFavoriteGame(
        self_: *mut ISteamMatchmaking,
        nAppID: AppId_t,
        nIP: uint32,
        nConnPort: uint16,
        nQueryPort: uint16,
        unFlags: uint32,
        rTime32LastPlayedOnServer: uint32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_RemoveFavoriteGame(
        self_: *mut ISteamMatchmaking,
        nAppID: AppId_t,
        nIP: uint32,
        nConnPort: uint16,
        nQueryPort: uint16,
        unFlags: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_RequestLobbyList(
        self_: *mut ISteamMatchmaking,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_AddRequestLobbyListStringFilter(
        self_: *mut ISteamMatchmaking,
        pchKeyToMatch: *const ::std::os::raw::c_char,
        pchValueToMatch: *const ::std::os::raw::c_char,
        eComparisonType: ELobbyComparison,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_AddRequestLobbyListNumericalFilter(
        self_: *mut ISteamMatchmaking,
        pchKeyToMatch: *const ::std::os::raw::c_char,
        nValueToMatch: ::std::os::raw::c_int,
        eComparisonType: ELobbyComparison,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_AddRequestLobbyListNearValueFilter(
        self_: *mut ISteamMatchmaking,
        pchKeyToMatch: *const ::std::os::raw::c_char,
        nValueToBeCloseTo: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_AddRequestLobbyListFilterSlotsAvailable(
        self_: *mut ISteamMatchmaking,
        nSlotsAvailable: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_AddRequestLobbyListDistanceFilter(
        self_: *mut ISteamMatchmaking,
        eLobbyDistanceFilter: ELobbyDistanceFilter,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_AddRequestLobbyListResultCountFilter(
        self_: *mut ISteamMatchmaking,
        cMaxResults: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_AddRequestLobbyListCompatibleMembersFilter(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_GetLobbyByIndex(
        self_: *mut ISteamMatchmaking,
        iLobby: ::std::os::raw::c_int,
    ) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_CreateLobby(
        self_: *mut ISteamMatchmaking,
        eLobbyType: ELobbyType,
        cMaxMembers: ::std::os::raw::c_int,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_JoinLobby(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_LeaveLobby(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_InviteUserToLobby(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        steamIDInvitee: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_GetNumLobbyMembers(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_GetLobbyMemberByIndex(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        iMember: ::std::os::raw::c_int,
    ) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_GetLobbyData(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        pchKey: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_SetLobbyData(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        pchKey: *const ::std::os::raw::c_char,
        pchValue: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_GetLobbyDataCount(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_GetLobbyDataByIndex(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        iLobbyData: ::std::os::raw::c_int,
        pchKey: *mut ::std::os::raw::c_char,
        cchKeyBufferSize: ::std::os::raw::c_int,
        pchValue: *mut ::std::os::raw::c_char,
        cchValueBufferSize: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_DeleteLobbyData(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        pchKey: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_GetLobbyMemberData(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        steamIDUser: uint64_steamid,
        pchKey: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_SetLobbyMemberData(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        pchKey: *const ::std::os::raw::c_char,
        pchValue: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_SendLobbyChatMsg(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        pvMsgBody: *const ::std::os::raw::c_void,
        cubMsgBody: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_GetLobbyChatEntry(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        iChatID: ::std::os::raw::c_int,
        pSteamIDUser: *mut CSteamID,
        pvData: *mut ::std::os::raw::c_void,
        cubData: ::std::os::raw::c_int,
        peChatEntryType: *mut EChatEntryType,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_RequestLobbyData(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_SetLobbyGameServer(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        unGameServerIP: uint32,
        unGameServerPort: uint16,
        steamIDGameServer: uint64_steamid,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_GetLobbyGameServer(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        punGameServerIP: *mut uint32,
        punGameServerPort: *mut uint16,
        psteamIDGameServer: *mut CSteamID,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_SetLobbyMemberLimit(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        cMaxMembers: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_GetLobbyMemberLimit(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_SetLobbyType(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        eLobbyType: ELobbyType,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_SetLobbyJoinable(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        bLobbyJoinable: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_GetLobbyOwner(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
    ) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_SetLobbyOwner(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        steamIDNewOwner: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmaking_SetLinkedLobby(
        self_: *mut ISteamMatchmaking,
        steamIDLobby: uint64_steamid,
        steamIDLobbyDependent: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServerListResponse_ServerResponded(
        self_: *mut ISteamMatchmakingServerListResponse,
        hRequest: HServerListRequest,
        iServer: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServerListResponse_ServerFailedToRespond(
        self_: *mut ISteamMatchmakingServerListResponse,
        hRequest: HServerListRequest,
        iServer: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServerListResponse_RefreshComplete(
        self_: *mut ISteamMatchmakingServerListResponse,
        hRequest: HServerListRequest,
        response: EMatchMakingServerResponse,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingPingResponse_ServerResponded(
        self_: *mut ISteamMatchmakingPingResponse,
        server: *mut gameserveritem_t,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingPingResponse_ServerFailedToRespond(
        self_: *mut ISteamMatchmakingPingResponse,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingPlayersResponse_AddPlayerToList(
        self_: *mut ISteamMatchmakingPlayersResponse,
        pchName: *const ::std::os::raw::c_char,
        nScore: ::std::os::raw::c_int,
        flTimePlayed: f32,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingPlayersResponse_PlayersFailedToRespond(
        self_: *mut ISteamMatchmakingPlayersResponse,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingPlayersResponse_PlayersRefreshComplete(
        self_: *mut ISteamMatchmakingPlayersResponse,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingRulesResponse_RulesResponded(
        self_: *mut ISteamMatchmakingRulesResponse,
        pchRule: *const ::std::os::raw::c_char,
        pchValue: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingRulesResponse_RulesFailedToRespond(
        self_: *mut ISteamMatchmakingRulesResponse,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingRulesResponse_RulesRefreshComplete(
        self_: *mut ISteamMatchmakingRulesResponse,
    );
}
extern "C" {
    pub fn SteamAPI_SteamMatchmakingServers_v002() -> *mut ISteamMatchmakingServers;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_RequestInternetServerList(
        self_: *mut ISteamMatchmakingServers,
        iApp: AppId_t,
        ppchFilters: *mut *mut MatchMakingKeyValuePair_t,
        nFilters: uint32,
        pRequestServersResponse: *mut ISteamMatchmakingServerListResponse,
    ) -> HServerListRequest;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_RequestLANServerList(
        self_: *mut ISteamMatchmakingServers,
        iApp: AppId_t,
        pRequestServersResponse: *mut ISteamMatchmakingServerListResponse,
    ) -> HServerListRequest;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_RequestFriendsServerList(
        self_: *mut ISteamMatchmakingServers,
        iApp: AppId_t,
        ppchFilters: *mut *mut MatchMakingKeyValuePair_t,
        nFilters: uint32,
        pRequestServersResponse: *mut ISteamMatchmakingServerListResponse,
    ) -> HServerListRequest;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_RequestFavoritesServerList(
        self_: *mut ISteamMatchmakingServers,
        iApp: AppId_t,
        ppchFilters: *mut *mut MatchMakingKeyValuePair_t,
        nFilters: uint32,
        pRequestServersResponse: *mut ISteamMatchmakingServerListResponse,
    ) -> HServerListRequest;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_RequestHistoryServerList(
        self_: *mut ISteamMatchmakingServers,
        iApp: AppId_t,
        ppchFilters: *mut *mut MatchMakingKeyValuePair_t,
        nFilters: uint32,
        pRequestServersResponse: *mut ISteamMatchmakingServerListResponse,
    ) -> HServerListRequest;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_RequestSpectatorServerList(
        self_: *mut ISteamMatchmakingServers,
        iApp: AppId_t,
        ppchFilters: *mut *mut MatchMakingKeyValuePair_t,
        nFilters: uint32,
        pRequestServersResponse: *mut ISteamMatchmakingServerListResponse,
    ) -> HServerListRequest;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_ReleaseRequest(
        self_: *mut ISteamMatchmakingServers,
        hServerListRequest: HServerListRequest,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_GetServerDetails(
        self_: *mut ISteamMatchmakingServers,
        hRequest: HServerListRequest,
        iServer: ::std::os::raw::c_int,
    ) -> *mut gameserveritem_t;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_CancelQuery(
        self_: *mut ISteamMatchmakingServers,
        hRequest: HServerListRequest,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_RefreshQuery(
        self_: *mut ISteamMatchmakingServers,
        hRequest: HServerListRequest,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_IsRefreshing(
        self_: *mut ISteamMatchmakingServers,
        hRequest: HServerListRequest,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_GetServerCount(
        self_: *mut ISteamMatchmakingServers,
        hRequest: HServerListRequest,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_RefreshServer(
        self_: *mut ISteamMatchmakingServers,
        hRequest: HServerListRequest,
        iServer: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_PingServer(
        self_: *mut ISteamMatchmakingServers,
        unIP: uint32,
        usPort: uint16,
        pRequestServersResponse: *mut ISteamMatchmakingPingResponse,
    ) -> HServerQuery;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_PlayerDetails(
        self_: *mut ISteamMatchmakingServers,
        unIP: uint32,
        usPort: uint16,
        pRequestServersResponse: *mut ISteamMatchmakingPlayersResponse,
    ) -> HServerQuery;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_ServerRules(
        self_: *mut ISteamMatchmakingServers,
        unIP: uint32,
        usPort: uint16,
        pRequestServersResponse: *mut ISteamMatchmakingRulesResponse,
    ) -> HServerQuery;
}
extern "C" {
    pub fn SteamAPI_ISteamMatchmakingServers_CancelServerQuery(
        self_: *mut ISteamMatchmakingServers,
        hServerQuery: HServerQuery,
    );
}
extern "C" {
    pub fn SteamAPI_SteamGameSearch_v001() -> *mut ISteamGameSearch;
}
extern "C" {
    pub fn SteamAPI_ISteamGameSearch_AddGameSearchParams(
        self_: *mut ISteamGameSearch,
        pchKeyToFind: *const ::std::os::raw::c_char,
        pchValuesToFind: *const ::std::os::raw::c_char,
    ) -> EGameSearchErrorCode_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameSearch_SearchForGameWithLobby(
        self_: *mut ISteamGameSearch,
        steamIDLobby: uint64_steamid,
        nPlayerMin: ::std::os::raw::c_int,
        nPlayerMax: ::std::os::raw::c_int,
    ) -> EGameSearchErrorCode_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameSearch_SearchForGameSolo(
        self_: *mut ISteamGameSearch,
        nPlayerMin: ::std::os::raw::c_int,
        nPlayerMax: ::std::os::raw::c_int,
    ) -> EGameSearchErrorCode_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameSearch_AcceptGame(
        self_: *mut ISteamGameSearch,
    ) -> EGameSearchErrorCode_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameSearch_DeclineGame(
        self_: *mut ISteamGameSearch,
    ) -> EGameSearchErrorCode_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameSearch_RetrieveConnectionDetails(
        self_: *mut ISteamGameSearch,
        steamIDHost: uint64_steamid,
        pchConnectionDetails: *mut ::std::os::raw::c_char,
        cubConnectionDetails: ::std::os::raw::c_int,
    ) -> EGameSearchErrorCode_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameSearch_EndGameSearch(
        self_: *mut ISteamGameSearch,
    ) -> EGameSearchErrorCode_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameSearch_SetGameHostParams(
        self_: *mut ISteamGameSearch,
        pchKey: *const ::std::os::raw::c_char,
        pchValue: *const ::std::os::raw::c_char,
    ) -> EGameSearchErrorCode_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameSearch_SetConnectionDetails(
        self_: *mut ISteamGameSearch,
        pchConnectionDetails: *const ::std::os::raw::c_char,
        cubConnectionDetails: ::std::os::raw::c_int,
    ) -> EGameSearchErrorCode_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameSearch_RequestPlayersForGame(
        self_: *mut ISteamGameSearch,
        nPlayerMin: ::std::os::raw::c_int,
        nPlayerMax: ::std::os::raw::c_int,
        nMaxTeamSize: ::std::os::raw::c_int,
    ) -> EGameSearchErrorCode_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameSearch_HostConfirmGameStart(
        self_: *mut ISteamGameSearch,
        ullUniqueGameID: uint64,
    ) -> EGameSearchErrorCode_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameSearch_CancelRequestPlayersForGame(
        self_: *mut ISteamGameSearch,
    ) -> EGameSearchErrorCode_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameSearch_SubmitPlayerResult(
        self_: *mut ISteamGameSearch,
        ullUniqueGameID: uint64,
        steamIDPlayer: uint64_steamid,
        EPlayerResult: EPlayerResult_t,
    ) -> EGameSearchErrorCode_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameSearch_EndGame(
        self_: *mut ISteamGameSearch,
        ullUniqueGameID: uint64,
    ) -> EGameSearchErrorCode_t;
}
extern "C" {
    pub fn SteamAPI_SteamParties_v002() -> *mut ISteamParties;
}
extern "C" {
    pub fn SteamAPI_ISteamParties_GetNumActiveBeacons(self_: *mut ISteamParties) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamParties_GetBeaconByIndex(
        self_: *mut ISteamParties,
        unIndex: uint32,
    ) -> PartyBeaconID_t;
}
extern "C" {
    pub fn SteamAPI_ISteamParties_GetBeaconDetails(
        self_: *mut ISteamParties,
        ulBeaconID: PartyBeaconID_t,
        pSteamIDBeaconOwner: *mut CSteamID,
        pLocation: *mut SteamPartyBeaconLocation_t,
        pchMetadata: *mut ::std::os::raw::c_char,
        cchMetadata: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamParties_JoinParty(
        self_: *mut ISteamParties,
        ulBeaconID: PartyBeaconID_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamParties_GetNumAvailableBeaconLocations(
        self_: *mut ISteamParties,
        puNumLocations: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamParties_GetAvailableBeaconLocations(
        self_: *mut ISteamParties,
        pLocationList: *mut SteamPartyBeaconLocation_t,
        uMaxNumLocations: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamParties_CreateBeacon(
        self_: *mut ISteamParties,
        unOpenSlots: uint32,
        pBeaconLocation: *mut SteamPartyBeaconLocation_t,
        pchConnectString: *const ::std::os::raw::c_char,
        pchMetadata: *const ::std::os::raw::c_char,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamParties_OnReservationCompleted(
        self_: *mut ISteamParties,
        ulBeacon: PartyBeaconID_t,
        steamIDUser: uint64_steamid,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamParties_CancelReservation(
        self_: *mut ISteamParties,
        ulBeacon: PartyBeaconID_t,
        steamIDUser: uint64_steamid,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamParties_ChangeNumOpenSlots(
        self_: *mut ISteamParties,
        ulBeacon: PartyBeaconID_t,
        unOpenSlots: uint32,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamParties_DestroyBeacon(
        self_: *mut ISteamParties,
        ulBeacon: PartyBeaconID_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamParties_GetBeaconLocationData(
        self_: *mut ISteamParties,
        BeaconLocation: SteamPartyBeaconLocation_t,
        eData: ESteamPartyBeaconLocationData,
        pchDataStringOut: *mut ::std::os::raw::c_char,
        cchDataStringOut: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamRemoteStorage_v014() -> *mut ISteamRemoteStorage;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_FileWrite(
        self_: *mut ISteamRemoteStorage,
        pchFile: *const ::std::os::raw::c_char,
        pvData: *const ::std::os::raw::c_void,
        cubData: int32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_FileRead(
        self_: *mut ISteamRemoteStorage,
        pchFile: *const ::std::os::raw::c_char,
        pvData: *mut ::std::os::raw::c_void,
        cubDataToRead: int32,
    ) -> int32;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_FileWriteAsync(
        self_: *mut ISteamRemoteStorage,
        pchFile: *const ::std::os::raw::c_char,
        pvData: *const ::std::os::raw::c_void,
        cubData: uint32,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_FileReadAsync(
        self_: *mut ISteamRemoteStorage,
        pchFile: *const ::std::os::raw::c_char,
        nOffset: uint32,
        cubToRead: uint32,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_FileReadAsyncComplete(
        self_: *mut ISteamRemoteStorage,
        hReadCall: SteamAPICall_t,
        pvBuffer: *mut ::std::os::raw::c_void,
        cubToRead: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_FileForget(
        self_: *mut ISteamRemoteStorage,
        pchFile: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_FileDelete(
        self_: *mut ISteamRemoteStorage,
        pchFile: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_FileShare(
        self_: *mut ISteamRemoteStorage,
        pchFile: *const ::std::os::raw::c_char,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_SetSyncPlatforms(
        self_: *mut ISteamRemoteStorage,
        pchFile: *const ::std::os::raw::c_char,
        eRemoteStoragePlatform: ERemoteStoragePlatform,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_FileWriteStreamOpen(
        self_: *mut ISteamRemoteStorage,
        pchFile: *const ::std::os::raw::c_char,
    ) -> UGCFileWriteStreamHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_FileWriteStreamWriteChunk(
        self_: *mut ISteamRemoteStorage,
        writeHandle: UGCFileWriteStreamHandle_t,
        pvData: *const ::std::os::raw::c_void,
        cubData: int32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_FileWriteStreamClose(
        self_: *mut ISteamRemoteStorage,
        writeHandle: UGCFileWriteStreamHandle_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_FileWriteStreamCancel(
        self_: *mut ISteamRemoteStorage,
        writeHandle: UGCFileWriteStreamHandle_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_FileExists(
        self_: *mut ISteamRemoteStorage,
        pchFile: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_FilePersisted(
        self_: *mut ISteamRemoteStorage,
        pchFile: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_GetFileSize(
        self_: *mut ISteamRemoteStorage,
        pchFile: *const ::std::os::raw::c_char,
    ) -> int32;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_GetFileTimestamp(
        self_: *mut ISteamRemoteStorage,
        pchFile: *const ::std::os::raw::c_char,
    ) -> int64;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_GetSyncPlatforms(
        self_: *mut ISteamRemoteStorage,
        pchFile: *const ::std::os::raw::c_char,
    ) -> ERemoteStoragePlatform;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_GetFileCount(self_: *mut ISteamRemoteStorage) -> int32;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_GetFileNameAndSize(
        self_: *mut ISteamRemoteStorage,
        iFile: ::std::os::raw::c_int,
        pnFileSizeInBytes: *mut int32,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_GetQuota(
        self_: *mut ISteamRemoteStorage,
        pnTotalBytes: *mut uint64,
        puAvailableBytes: *mut uint64,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_IsCloudEnabledForAccount(
        self_: *mut ISteamRemoteStorage,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_IsCloudEnabledForApp(
        self_: *mut ISteamRemoteStorage,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_SetCloudEnabledForApp(
        self_: *mut ISteamRemoteStorage,
        bEnabled: bool,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_UGCDownload(
        self_: *mut ISteamRemoteStorage,
        hContent: UGCHandle_t,
        unPriority: uint32,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_GetUGCDownloadProgress(
        self_: *mut ISteamRemoteStorage,
        hContent: UGCHandle_t,
        pnBytesDownloaded: *mut int32,
        pnBytesExpected: *mut int32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_GetUGCDetails(
        self_: *mut ISteamRemoteStorage,
        hContent: UGCHandle_t,
        pnAppID: *mut AppId_t,
        ppchName: *mut *mut ::std::os::raw::c_char,
        pnFileSizeInBytes: *mut int32,
        pSteamIDOwner: *mut CSteamID,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_UGCRead(
        self_: *mut ISteamRemoteStorage,
        hContent: UGCHandle_t,
        pvData: *mut ::std::os::raw::c_void,
        cubDataToRead: int32,
        cOffset: uint32,
        eAction: EUGCReadAction,
    ) -> int32;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_GetCachedUGCCount(self_: *mut ISteamRemoteStorage)
        -> int32;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_GetCachedUGCHandle(
        self_: *mut ISteamRemoteStorage,
        iCachedContent: int32,
    ) -> UGCHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_PublishWorkshopFile(
        self_: *mut ISteamRemoteStorage,
        pchFile: *const ::std::os::raw::c_char,
        pchPreviewFile: *const ::std::os::raw::c_char,
        nConsumerAppId: AppId_t,
        pchTitle: *const ::std::os::raw::c_char,
        pchDescription: *const ::std::os::raw::c_char,
        eVisibility: ERemoteStoragePublishedFileVisibility,
        pTags: *mut SteamParamStringArray_t,
        eWorkshopFileType: EWorkshopFileType,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_CreatePublishedFileUpdateRequest(
        self_: *mut ISteamRemoteStorage,
        unPublishedFileId: PublishedFileId_t,
    ) -> PublishedFileUpdateHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_UpdatePublishedFileFile(
        self_: *mut ISteamRemoteStorage,
        updateHandle: PublishedFileUpdateHandle_t,
        pchFile: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_UpdatePublishedFilePreviewFile(
        self_: *mut ISteamRemoteStorage,
        updateHandle: PublishedFileUpdateHandle_t,
        pchPreviewFile: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_UpdatePublishedFileTitle(
        self_: *mut ISteamRemoteStorage,
        updateHandle: PublishedFileUpdateHandle_t,
        pchTitle: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_UpdatePublishedFileDescription(
        self_: *mut ISteamRemoteStorage,
        updateHandle: PublishedFileUpdateHandle_t,
        pchDescription: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_UpdatePublishedFileVisibility(
        self_: *mut ISteamRemoteStorage,
        updateHandle: PublishedFileUpdateHandle_t,
        eVisibility: ERemoteStoragePublishedFileVisibility,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_UpdatePublishedFileTags(
        self_: *mut ISteamRemoteStorage,
        updateHandle: PublishedFileUpdateHandle_t,
        pTags: *mut SteamParamStringArray_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_CommitPublishedFileUpdate(
        self_: *mut ISteamRemoteStorage,
        updateHandle: PublishedFileUpdateHandle_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_GetPublishedFileDetails(
        self_: *mut ISteamRemoteStorage,
        unPublishedFileId: PublishedFileId_t,
        unMaxSecondsOld: uint32,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_DeletePublishedFile(
        self_: *mut ISteamRemoteStorage,
        unPublishedFileId: PublishedFileId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_EnumerateUserPublishedFiles(
        self_: *mut ISteamRemoteStorage,
        unStartIndex: uint32,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_SubscribePublishedFile(
        self_: *mut ISteamRemoteStorage,
        unPublishedFileId: PublishedFileId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_EnumerateUserSubscribedFiles(
        self_: *mut ISteamRemoteStorage,
        unStartIndex: uint32,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_UnsubscribePublishedFile(
        self_: *mut ISteamRemoteStorage,
        unPublishedFileId: PublishedFileId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_UpdatePublishedFileSetChangeDescription(
        self_: *mut ISteamRemoteStorage,
        updateHandle: PublishedFileUpdateHandle_t,
        pchChangeDescription: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_GetPublishedItemVoteDetails(
        self_: *mut ISteamRemoteStorage,
        unPublishedFileId: PublishedFileId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_UpdateUserPublishedItemVote(
        self_: *mut ISteamRemoteStorage,
        unPublishedFileId: PublishedFileId_t,
        bVoteUp: bool,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_GetUserPublishedItemVoteDetails(
        self_: *mut ISteamRemoteStorage,
        unPublishedFileId: PublishedFileId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_EnumerateUserSharedWorkshopFiles(
        self_: *mut ISteamRemoteStorage,
        steamId: uint64_steamid,
        unStartIndex: uint32,
        pRequiredTags: *mut SteamParamStringArray_t,
        pExcludedTags: *mut SteamParamStringArray_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_PublishVideo(
        self_: *mut ISteamRemoteStorage,
        eVideoProvider: EWorkshopVideoProvider,
        pchVideoAccount: *const ::std::os::raw::c_char,
        pchVideoIdentifier: *const ::std::os::raw::c_char,
        pchPreviewFile: *const ::std::os::raw::c_char,
        nConsumerAppId: AppId_t,
        pchTitle: *const ::std::os::raw::c_char,
        pchDescription: *const ::std::os::raw::c_char,
        eVisibility: ERemoteStoragePublishedFileVisibility,
        pTags: *mut SteamParamStringArray_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_SetUserPublishedFileAction(
        self_: *mut ISteamRemoteStorage,
        unPublishedFileId: PublishedFileId_t,
        eAction: EWorkshopFileAction,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_EnumeratePublishedFilesByUserAction(
        self_: *mut ISteamRemoteStorage,
        eAction: EWorkshopFileAction,
        unStartIndex: uint32,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_EnumeratePublishedWorkshopFiles(
        self_: *mut ISteamRemoteStorage,
        eEnumerationType: EWorkshopEnumerationType,
        unStartIndex: uint32,
        unCount: uint32,
        unDays: uint32,
        pTags: *mut SteamParamStringArray_t,
        pUserTags: *mut SteamParamStringArray_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemoteStorage_UGCDownloadToLocation(
        self_: *mut ISteamRemoteStorage,
        hContent: UGCHandle_t,
        pchLocation: *const ::std::os::raw::c_char,
        unPriority: uint32,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_SteamUserStats_v012() -> *mut ISteamUserStats;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_RequestCurrentStats(self_: *mut ISteamUserStats) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetStatInt32(
        self_: *mut ISteamUserStats,
        pchName: *const ::std::os::raw::c_char,
        pData: *mut int32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetStatFloat(
        self_: *mut ISteamUserStats,
        pchName: *const ::std::os::raw::c_char,
        pData: *mut f32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_SetStatInt32(
        self_: *mut ISteamUserStats,
        pchName: *const ::std::os::raw::c_char,
        nData: int32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_SetStatFloat(
        self_: *mut ISteamUserStats,
        pchName: *const ::std::os::raw::c_char,
        fData: f32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_UpdateAvgRateStat(
        self_: *mut ISteamUserStats,
        pchName: *const ::std::os::raw::c_char,
        flCountThisSession: f32,
        dSessionLength: f64,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetAchievement(
        self_: *mut ISteamUserStats,
        pchName: *const ::std::os::raw::c_char,
        pbAchieved: *mut bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_SetAchievement(
        self_: *mut ISteamUserStats,
        pchName: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_ClearAchievement(
        self_: *mut ISteamUserStats,
        pchName: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetAchievementAndUnlockTime(
        self_: *mut ISteamUserStats,
        pchName: *const ::std::os::raw::c_char,
        pbAchieved: *mut bool,
        punUnlockTime: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_StoreStats(self_: *mut ISteamUserStats) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetAchievementIcon(
        self_: *mut ISteamUserStats,
        pchName: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetAchievementDisplayAttribute(
        self_: *mut ISteamUserStats,
        pchName: *const ::std::os::raw::c_char,
        pchKey: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_IndicateAchievementProgress(
        self_: *mut ISteamUserStats,
        pchName: *const ::std::os::raw::c_char,
        nCurProgress: uint32,
        nMaxProgress: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetNumAchievements(self_: *mut ISteamUserStats) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetAchievementName(
        self_: *mut ISteamUserStats,
        iAchievement: uint32,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_RequestUserStats(
        self_: *mut ISteamUserStats,
        steamIDUser: uint64_steamid,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetUserStatInt32(
        self_: *mut ISteamUserStats,
        steamIDUser: uint64_steamid,
        pchName: *const ::std::os::raw::c_char,
        pData: *mut int32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetUserStatFloat(
        self_: *mut ISteamUserStats,
        steamIDUser: uint64_steamid,
        pchName: *const ::std::os::raw::c_char,
        pData: *mut f32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetUserAchievement(
        self_: *mut ISteamUserStats,
        steamIDUser: uint64_steamid,
        pchName: *const ::std::os::raw::c_char,
        pbAchieved: *mut bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetUserAchievementAndUnlockTime(
        self_: *mut ISteamUserStats,
        steamIDUser: uint64_steamid,
        pchName: *const ::std::os::raw::c_char,
        pbAchieved: *mut bool,
        punUnlockTime: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_ResetAllStats(
        self_: *mut ISteamUserStats,
        bAchievementsToo: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_FindOrCreateLeaderboard(
        self_: *mut ISteamUserStats,
        pchLeaderboardName: *const ::std::os::raw::c_char,
        eLeaderboardSortMethod: ELeaderboardSortMethod,
        eLeaderboardDisplayType: ELeaderboardDisplayType,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_FindLeaderboard(
        self_: *mut ISteamUserStats,
        pchLeaderboardName: *const ::std::os::raw::c_char,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetLeaderboardName(
        self_: *mut ISteamUserStats,
        hSteamLeaderboard: SteamLeaderboard_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetLeaderboardEntryCount(
        self_: *mut ISteamUserStats,
        hSteamLeaderboard: SteamLeaderboard_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetLeaderboardSortMethod(
        self_: *mut ISteamUserStats,
        hSteamLeaderboard: SteamLeaderboard_t,
    ) -> ELeaderboardSortMethod;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetLeaderboardDisplayType(
        self_: *mut ISteamUserStats,
        hSteamLeaderboard: SteamLeaderboard_t,
    ) -> ELeaderboardDisplayType;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_DownloadLeaderboardEntries(
        self_: *mut ISteamUserStats,
        hSteamLeaderboard: SteamLeaderboard_t,
        eLeaderboardDataRequest: ELeaderboardDataRequest,
        nRangeStart: ::std::os::raw::c_int,
        nRangeEnd: ::std::os::raw::c_int,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_DownloadLeaderboardEntriesForUsers(
        self_: *mut ISteamUserStats,
        hSteamLeaderboard: SteamLeaderboard_t,
        prgUsers: *mut CSteamID,
        cUsers: ::std::os::raw::c_int,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetDownloadedLeaderboardEntry(
        self_: *mut ISteamUserStats,
        hSteamLeaderboardEntries: SteamLeaderboardEntries_t,
        index: ::std::os::raw::c_int,
        pLeaderboardEntry: *mut LeaderboardEntry_t,
        pDetails: *mut int32,
        cDetailsMax: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_UploadLeaderboardScore(
        self_: *mut ISteamUserStats,
        hSteamLeaderboard: SteamLeaderboard_t,
        eLeaderboardUploadScoreMethod: ELeaderboardUploadScoreMethod,
        nScore: int32,
        pScoreDetails: *const int32,
        cScoreDetailsCount: ::std::os::raw::c_int,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_AttachLeaderboardUGC(
        self_: *mut ISteamUserStats,
        hSteamLeaderboard: SteamLeaderboard_t,
        hUGC: UGCHandle_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetNumberOfCurrentPlayers(
        self_: *mut ISteamUserStats,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_RequestGlobalAchievementPercentages(
        self_: *mut ISteamUserStats,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetMostAchievedAchievementInfo(
        self_: *mut ISteamUserStats,
        pchName: *mut ::std::os::raw::c_char,
        unNameBufLen: uint32,
        pflPercent: *mut f32,
        pbAchieved: *mut bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetNextMostAchievedAchievementInfo(
        self_: *mut ISteamUserStats,
        iIteratorPrevious: ::std::os::raw::c_int,
        pchName: *mut ::std::os::raw::c_char,
        unNameBufLen: uint32,
        pflPercent: *mut f32,
        pbAchieved: *mut bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetAchievementAchievedPercent(
        self_: *mut ISteamUserStats,
        pchName: *const ::std::os::raw::c_char,
        pflPercent: *mut f32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_RequestGlobalStats(
        self_: *mut ISteamUserStats,
        nHistoryDays: ::std::os::raw::c_int,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetGlobalStatInt64(
        self_: *mut ISteamUserStats,
        pchStatName: *const ::std::os::raw::c_char,
        pData: *mut int64,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetGlobalStatDouble(
        self_: *mut ISteamUserStats,
        pchStatName: *const ::std::os::raw::c_char,
        pData: *mut f64,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetGlobalStatHistoryInt64(
        self_: *mut ISteamUserStats,
        pchStatName: *const ::std::os::raw::c_char,
        pData: *mut int64,
        cubData: uint32,
    ) -> int32;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetGlobalStatHistoryDouble(
        self_: *mut ISteamUserStats,
        pchStatName: *const ::std::os::raw::c_char,
        pData: *mut f64,
        cubData: uint32,
    ) -> int32;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetAchievementProgressLimitsInt32(
        self_: *mut ISteamUserStats,
        pchName: *const ::std::os::raw::c_char,
        pnMinProgress: *mut int32,
        pnMaxProgress: *mut int32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUserStats_GetAchievementProgressLimitsFloat(
        self_: *mut ISteamUserStats,
        pchName: *const ::std::os::raw::c_char,
        pfMinProgress: *mut f32,
        pfMaxProgress: *mut f32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamApps_v008() -> *mut ISteamApps;
}
extern "C" {
    pub fn SteamAPI_SteamGameServerApps_v008() -> *mut ISteamApps;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_BIsSubscribed(self_: *mut ISteamApps) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_BIsLowViolence(self_: *mut ISteamApps) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_BIsCybercafe(self_: *mut ISteamApps) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_BIsVACBanned(self_: *mut ISteamApps) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_GetCurrentGameLanguage(
        self_: *mut ISteamApps,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_GetAvailableGameLanguages(
        self_: *mut ISteamApps,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_BIsSubscribedApp(self_: *mut ISteamApps, appID: AppId_t) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_BIsDlcInstalled(self_: *mut ISteamApps, appID: AppId_t) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_GetEarliestPurchaseUnixTime(
        self_: *mut ISteamApps,
        nAppID: AppId_t,
    ) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_BIsSubscribedFromFreeWeekend(self_: *mut ISteamApps) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_GetDLCCount(self_: *mut ISteamApps) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_BGetDLCDataByIndex(
        self_: *mut ISteamApps,
        iDLC: ::std::os::raw::c_int,
        pAppID: *mut AppId_t,
        pbAvailable: *mut bool,
        pchName: *mut ::std::os::raw::c_char,
        cchNameBufferSize: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_InstallDLC(self_: *mut ISteamApps, nAppID: AppId_t);
}
extern "C" {
    pub fn SteamAPI_ISteamApps_UninstallDLC(self_: *mut ISteamApps, nAppID: AppId_t);
}
extern "C" {
    pub fn SteamAPI_ISteamApps_RequestAppProofOfPurchaseKey(
        self_: *mut ISteamApps,
        nAppID: AppId_t,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamApps_GetCurrentBetaName(
        self_: *mut ISteamApps,
        pchName: *mut ::std::os::raw::c_char,
        cchNameBufferSize: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_MarkContentCorrupt(
        self_: *mut ISteamApps,
        bMissingFilesOnly: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_GetInstalledDepots(
        self_: *mut ISteamApps,
        appID: AppId_t,
        pvecDepots: *mut DepotId_t,
        cMaxDepots: uint32,
    ) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_GetAppInstallDir(
        self_: *mut ISteamApps,
        appID: AppId_t,
        pchFolder: *mut ::std::os::raw::c_char,
        cchFolderBufferSize: uint32,
    ) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_BIsAppInstalled(self_: *mut ISteamApps, appID: AppId_t) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_GetAppOwner(self_: *mut ISteamApps) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_GetLaunchQueryParam(
        self_: *mut ISteamApps,
        pchKey: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_GetDlcDownloadProgress(
        self_: *mut ISteamApps,
        nAppID: AppId_t,
        punBytesDownloaded: *mut uint64,
        punBytesTotal: *mut uint64,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_GetAppBuildId(self_: *mut ISteamApps) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_RequestAllProofOfPurchaseKeys(self_: *mut ISteamApps);
}
extern "C" {
    pub fn SteamAPI_ISteamApps_GetFileDetails(
        self_: *mut ISteamApps,
        pszFileName: *const ::std::os::raw::c_char,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_GetLaunchCommandLine(
        self_: *mut ISteamApps,
        pszCommandLine: *mut ::std::os::raw::c_char,
        cubCommandLine: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_BIsSubscribedFromFamilySharing(self_: *mut ISteamApps) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamApps_BIsTimedTrial(
        self_: *mut ISteamApps,
        punSecondsAllowed: *mut uint32,
        punSecondsPlayed: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamNetworking_v006() -> *mut ISteamNetworking;
}
extern "C" {
    pub fn SteamAPI_SteamGameServerNetworking_v006() -> *mut ISteamNetworking;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_SendP2PPacket(
        self_: *mut ISteamNetworking,
        steamIDRemote: uint64_steamid,
        pubData: *const ::std::os::raw::c_void,
        cubData: uint32,
        eP2PSendType: EP2PSend,
        nChannel: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_IsP2PPacketAvailable(
        self_: *mut ISteamNetworking,
        pcubMsgSize: *mut uint32,
        nChannel: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_ReadP2PPacket(
        self_: *mut ISteamNetworking,
        pubDest: *mut ::std::os::raw::c_void,
        cubDest: uint32,
        pcubMsgSize: *mut uint32,
        psteamIDRemote: *mut CSteamID,
        nChannel: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_AcceptP2PSessionWithUser(
        self_: *mut ISteamNetworking,
        steamIDRemote: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_CloseP2PSessionWithUser(
        self_: *mut ISteamNetworking,
        steamIDRemote: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_CloseP2PChannelWithUser(
        self_: *mut ISteamNetworking,
        steamIDRemote: uint64_steamid,
        nChannel: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_GetP2PSessionState(
        self_: *mut ISteamNetworking,
        steamIDRemote: uint64_steamid,
        pConnectionState: *mut P2PSessionState_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_AllowP2PPacketRelay(
        self_: *mut ISteamNetworking,
        bAllow: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_CreateListenSocket(
        self_: *mut ISteamNetworking,
        nVirtualP2PPort: ::std::os::raw::c_int,
        nIP: SteamIPAddress_t,
        nPort: uint16,
        bAllowUseOfPacketRelay: bool,
    ) -> SNetListenSocket_t;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_CreateP2PConnectionSocket(
        self_: *mut ISteamNetworking,
        steamIDTarget: uint64_steamid,
        nVirtualPort: ::std::os::raw::c_int,
        nTimeoutSec: ::std::os::raw::c_int,
        bAllowUseOfPacketRelay: bool,
    ) -> SNetSocket_t;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_CreateConnectionSocket(
        self_: *mut ISteamNetworking,
        nIP: SteamIPAddress_t,
        nPort: uint16,
        nTimeoutSec: ::std::os::raw::c_int,
    ) -> SNetSocket_t;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_DestroySocket(
        self_: *mut ISteamNetworking,
        hSocket: SNetSocket_t,
        bNotifyRemoteEnd: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_DestroyListenSocket(
        self_: *mut ISteamNetworking,
        hSocket: SNetListenSocket_t,
        bNotifyRemoteEnd: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_SendDataOnSocket(
        self_: *mut ISteamNetworking,
        hSocket: SNetSocket_t,
        pubData: *mut ::std::os::raw::c_void,
        cubData: uint32,
        bReliable: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_IsDataAvailableOnSocket(
        self_: *mut ISteamNetworking,
        hSocket: SNetSocket_t,
        pcubMsgSize: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_RetrieveDataFromSocket(
        self_: *mut ISteamNetworking,
        hSocket: SNetSocket_t,
        pubDest: *mut ::std::os::raw::c_void,
        cubDest: uint32,
        pcubMsgSize: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_IsDataAvailable(
        self_: *mut ISteamNetworking,
        hListenSocket: SNetListenSocket_t,
        pcubMsgSize: *mut uint32,
        phSocket: *mut SNetSocket_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_RetrieveData(
        self_: *mut ISteamNetworking,
        hListenSocket: SNetListenSocket_t,
        pubDest: *mut ::std::os::raw::c_void,
        cubDest: uint32,
        pcubMsgSize: *mut uint32,
        phSocket: *mut SNetSocket_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_GetSocketInfo(
        self_: *mut ISteamNetworking,
        hSocket: SNetSocket_t,
        pSteamIDRemote: *mut CSteamID,
        peSocketStatus: *mut ::std::os::raw::c_int,
        punIPRemote: *mut SteamIPAddress_t,
        punPortRemote: *mut uint16,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_GetListenSocketInfo(
        self_: *mut ISteamNetworking,
        hListenSocket: SNetListenSocket_t,
        pnIP: *mut SteamIPAddress_t,
        pnPort: *mut uint16,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_GetSocketConnectionType(
        self_: *mut ISteamNetworking,
        hSocket: SNetSocket_t,
    ) -> ESNetSocketConnectionType;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworking_GetMaxPacketSize(
        self_: *mut ISteamNetworking,
        hSocket: SNetSocket_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_SteamScreenshots_v003() -> *mut ISteamScreenshots;
}
extern "C" {
    pub fn SteamAPI_ISteamScreenshots_WriteScreenshot(
        self_: *mut ISteamScreenshots,
        pubRGB: *mut ::std::os::raw::c_void,
        cubRGB: uint32,
        nWidth: ::std::os::raw::c_int,
        nHeight: ::std::os::raw::c_int,
    ) -> ScreenshotHandle;
}
extern "C" {
    pub fn SteamAPI_ISteamScreenshots_AddScreenshotToLibrary(
        self_: *mut ISteamScreenshots,
        pchFilename: *const ::std::os::raw::c_char,
        pchThumbnailFilename: *const ::std::os::raw::c_char,
        nWidth: ::std::os::raw::c_int,
        nHeight: ::std::os::raw::c_int,
    ) -> ScreenshotHandle;
}
extern "C" {
    pub fn SteamAPI_ISteamScreenshots_TriggerScreenshot(self_: *mut ISteamScreenshots);
}
extern "C" {
    pub fn SteamAPI_ISteamScreenshots_HookScreenshots(self_: *mut ISteamScreenshots, bHook: bool);
}
extern "C" {
    pub fn SteamAPI_ISteamScreenshots_SetLocation(
        self_: *mut ISteamScreenshots,
        hScreenshot: ScreenshotHandle,
        pchLocation: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamScreenshots_TagUser(
        self_: *mut ISteamScreenshots,
        hScreenshot: ScreenshotHandle,
        steamID: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamScreenshots_TagPublishedFile(
        self_: *mut ISteamScreenshots,
        hScreenshot: ScreenshotHandle,
        unPublishedFileID: PublishedFileId_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamScreenshots_IsScreenshotsHooked(self_: *mut ISteamScreenshots) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamScreenshots_AddVRScreenshotToLibrary(
        self_: *mut ISteamScreenshots,
        eType: EVRScreenshotType,
        pchFilename: *const ::std::os::raw::c_char,
        pchVRFilename: *const ::std::os::raw::c_char,
    ) -> ScreenshotHandle;
}
extern "C" {
    pub fn SteamAPI_SteamMusic_v001() -> *mut ISteamMusic;
}
extern "C" {
    pub fn SteamAPI_ISteamMusic_BIsEnabled(self_: *mut ISteamMusic) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusic_BIsPlaying(self_: *mut ISteamMusic) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusic_GetPlaybackStatus(self_: *mut ISteamMusic) -> AudioPlayback_Status;
}
extern "C" {
    pub fn SteamAPI_ISteamMusic_Play(self_: *mut ISteamMusic);
}
extern "C" {
    pub fn SteamAPI_ISteamMusic_Pause(self_: *mut ISteamMusic);
}
extern "C" {
    pub fn SteamAPI_ISteamMusic_PlayPrevious(self_: *mut ISteamMusic);
}
extern "C" {
    pub fn SteamAPI_ISteamMusic_PlayNext(self_: *mut ISteamMusic);
}
extern "C" {
    pub fn SteamAPI_ISteamMusic_SetVolume(self_: *mut ISteamMusic, flVolume: f32);
}
extern "C" {
    pub fn SteamAPI_ISteamMusic_GetVolume(self_: *mut ISteamMusic) -> f32;
}
extern "C" {
    pub fn SteamAPI_SteamMusicRemote_v001() -> *mut ISteamMusicRemote;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_RegisterSteamMusicRemote(
        self_: *mut ISteamMusicRemote,
        pchName: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_DeregisterSteamMusicRemote(
        self_: *mut ISteamMusicRemote,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_BIsCurrentMusicRemote(self_: *mut ISteamMusicRemote) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_BActivationSuccess(
        self_: *mut ISteamMusicRemote,
        bValue: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_SetDisplayName(
        self_: *mut ISteamMusicRemote,
        pchDisplayName: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_SetPNGIcon_64x64(
        self_: *mut ISteamMusicRemote,
        pvBuffer: *mut ::std::os::raw::c_void,
        cbBufferLength: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_EnablePlayPrevious(
        self_: *mut ISteamMusicRemote,
        bValue: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_EnablePlayNext(
        self_: *mut ISteamMusicRemote,
        bValue: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_EnableShuffled(
        self_: *mut ISteamMusicRemote,
        bValue: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_EnableLooped(
        self_: *mut ISteamMusicRemote,
        bValue: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_EnableQueue(
        self_: *mut ISteamMusicRemote,
        bValue: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_EnablePlaylists(
        self_: *mut ISteamMusicRemote,
        bValue: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_UpdatePlaybackStatus(
        self_: *mut ISteamMusicRemote,
        nStatus: AudioPlayback_Status,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_UpdateShuffled(
        self_: *mut ISteamMusicRemote,
        bValue: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_UpdateLooped(
        self_: *mut ISteamMusicRemote,
        bValue: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_UpdateVolume(
        self_: *mut ISteamMusicRemote,
        flValue: f32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_CurrentEntryWillChange(self_: *mut ISteamMusicRemote)
        -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_CurrentEntryIsAvailable(
        self_: *mut ISteamMusicRemote,
        bAvailable: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_UpdateCurrentEntryText(
        self_: *mut ISteamMusicRemote,
        pchText: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_UpdateCurrentEntryElapsedSeconds(
        self_: *mut ISteamMusicRemote,
        nValue: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_UpdateCurrentEntryCoverArt(
        self_: *mut ISteamMusicRemote,
        pvBuffer: *mut ::std::os::raw::c_void,
        cbBufferLength: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_CurrentEntryDidChange(self_: *mut ISteamMusicRemote) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_QueueWillChange(self_: *mut ISteamMusicRemote) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_ResetQueueEntries(self_: *mut ISteamMusicRemote) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_SetQueueEntry(
        self_: *mut ISteamMusicRemote,
        nID: ::std::os::raw::c_int,
        nPosition: ::std::os::raw::c_int,
        pchEntryText: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_SetCurrentQueueEntry(
        self_: *mut ISteamMusicRemote,
        nID: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_QueueDidChange(self_: *mut ISteamMusicRemote) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_PlaylistWillChange(self_: *mut ISteamMusicRemote) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_ResetPlaylistEntries(self_: *mut ISteamMusicRemote) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_SetPlaylistEntry(
        self_: *mut ISteamMusicRemote,
        nID: ::std::os::raw::c_int,
        nPosition: ::std::os::raw::c_int,
        pchEntryText: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_SetCurrentPlaylistEntry(
        self_: *mut ISteamMusicRemote,
        nID: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamMusicRemote_PlaylistDidChange(self_: *mut ISteamMusicRemote) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamHTTP_v003() -> *mut ISteamHTTP;
}
extern "C" {
    pub fn SteamAPI_SteamGameServerHTTP_v003() -> *mut ISteamHTTP;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_CreateHTTPRequest(
        self_: *mut ISteamHTTP,
        eHTTPRequestMethod: EHTTPMethod,
        pchAbsoluteURL: *const ::std::os::raw::c_char,
    ) -> HTTPRequestHandle;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_SetHTTPRequestContextValue(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        ulContextValue: uint64,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_SetHTTPRequestNetworkActivityTimeout(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        unTimeoutSeconds: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_SetHTTPRequestHeaderValue(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        pchHeaderName: *const ::std::os::raw::c_char,
        pchHeaderValue: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_SetHTTPRequestGetOrPostParameter(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        pchParamName: *const ::std::os::raw::c_char,
        pchParamValue: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_SendHTTPRequest(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        pCallHandle: *mut SteamAPICall_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_SendHTTPRequestAndStreamResponse(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        pCallHandle: *mut SteamAPICall_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_DeferHTTPRequest(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_PrioritizeHTTPRequest(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_GetHTTPResponseHeaderSize(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        pchHeaderName: *const ::std::os::raw::c_char,
        unResponseHeaderSize: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_GetHTTPResponseHeaderValue(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        pchHeaderName: *const ::std::os::raw::c_char,
        pHeaderValueBuffer: *mut uint8,
        unBufferSize: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_GetHTTPResponseBodySize(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        unBodySize: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_GetHTTPResponseBodyData(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        pBodyDataBuffer: *mut uint8,
        unBufferSize: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_GetHTTPStreamingResponseBodyData(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        cOffset: uint32,
        pBodyDataBuffer: *mut uint8,
        unBufferSize: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_ReleaseHTTPRequest(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_GetHTTPDownloadProgressPct(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        pflPercentOut: *mut f32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_SetHTTPRequestRawPostBody(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        pchContentType: *const ::std::os::raw::c_char,
        pubBody: *mut uint8,
        unBodyLen: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_CreateCookieContainer(
        self_: *mut ISteamHTTP,
        bAllowResponsesToModify: bool,
    ) -> HTTPCookieContainerHandle;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_ReleaseCookieContainer(
        self_: *mut ISteamHTTP,
        hCookieContainer: HTTPCookieContainerHandle,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_SetCookie(
        self_: *mut ISteamHTTP,
        hCookieContainer: HTTPCookieContainerHandle,
        pchHost: *const ::std::os::raw::c_char,
        pchUrl: *const ::std::os::raw::c_char,
        pchCookie: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_SetHTTPRequestCookieContainer(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        hCookieContainer: HTTPCookieContainerHandle,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_SetHTTPRequestUserAgentInfo(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        pchUserAgentInfo: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_SetHTTPRequestRequiresVerifiedCertificate(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        bRequireVerifiedCertificate: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_SetHTTPRequestAbsoluteTimeoutMS(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        unMilliseconds: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTTP_GetHTTPRequestWasTimedOut(
        self_: *mut ISteamHTTP,
        hRequest: HTTPRequestHandle,
        pbWasTimedOut: *mut bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamInput_v002() -> *mut ISteamInput;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_Init(self_: *mut ISteamInput) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_Shutdown(self_: *mut ISteamInput) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_RunFrame(self_: *mut ISteamInput);
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetConnectedControllers(
        self_: *mut ISteamInput,
        handlesOut: *mut InputHandle_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetActionSetHandle(
        self_: *mut ISteamInput,
        pszActionSetName: *const ::std::os::raw::c_char,
    ) -> InputActionSetHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_ActivateActionSet(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
        actionSetHandle: InputActionSetHandle_t,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetCurrentActionSet(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
    ) -> InputActionSetHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_ActivateActionSetLayer(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
        actionSetLayerHandle: InputActionSetHandle_t,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamInput_DeactivateActionSetLayer(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
        actionSetLayerHandle: InputActionSetHandle_t,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamInput_DeactivateAllActionSetLayers(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetActiveActionSetLayers(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
        handlesOut: *mut InputActionSetHandle_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetDigitalActionHandle(
        self_: *mut ISteamInput,
        pszActionName: *const ::std::os::raw::c_char,
    ) -> InputDigitalActionHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetDigitalActionData(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
        digitalActionHandle: InputDigitalActionHandle_t,
    ) -> InputDigitalActionData_t;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetDigitalActionOrigins(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
        actionSetHandle: InputActionSetHandle_t,
        digitalActionHandle: InputDigitalActionHandle_t,
        originsOut: *mut EInputActionOrigin,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetAnalogActionHandle(
        self_: *mut ISteamInput,
        pszActionName: *const ::std::os::raw::c_char,
    ) -> InputAnalogActionHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetAnalogActionData(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
        analogActionHandle: InputAnalogActionHandle_t,
    ) -> InputAnalogActionData_t;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetAnalogActionOrigins(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
        actionSetHandle: InputActionSetHandle_t,
        analogActionHandle: InputAnalogActionHandle_t,
        originsOut: *mut EInputActionOrigin,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetGlyphForActionOrigin(
        self_: *mut ISteamInput,
        eOrigin: EInputActionOrigin,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetStringForActionOrigin(
        self_: *mut ISteamInput,
        eOrigin: EInputActionOrigin,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_StopAnalogActionMomentum(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
        eAction: InputAnalogActionHandle_t,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetMotionData(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
    ) -> InputMotionData_t;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_TriggerVibration(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
        usLeftSpeed: ::std::os::raw::c_ushort,
        usRightSpeed: ::std::os::raw::c_ushort,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamInput_SetLEDColor(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
        nColorR: uint8,
        nColorG: uint8,
        nColorB: uint8,
        nFlags: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamInput_TriggerHapticPulse(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
        eTargetPad: ESteamControllerPad,
        usDurationMicroSec: ::std::os::raw::c_ushort,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamInput_TriggerRepeatedHapticPulse(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
        eTargetPad: ESteamControllerPad,
        usDurationMicroSec: ::std::os::raw::c_ushort,
        usOffMicroSec: ::std::os::raw::c_ushort,
        unRepeat: ::std::os::raw::c_ushort,
        nFlags: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamInput_ShowBindingPanel(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetInputTypeForHandle(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
    ) -> ESteamInputType;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetControllerForGamepadIndex(
        self_: *mut ISteamInput,
        nIndex: ::std::os::raw::c_int,
    ) -> InputHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetGamepadIndexForController(
        self_: *mut ISteamInput,
        ulinputHandle: InputHandle_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetStringForXboxOrigin(
        self_: *mut ISteamInput,
        eOrigin: EXboxOrigin,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetGlyphForXboxOrigin(
        self_: *mut ISteamInput,
        eOrigin: EXboxOrigin,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetActionOriginFromXboxOrigin(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
        eOrigin: EXboxOrigin,
    ) -> EInputActionOrigin;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_TranslateActionOrigin(
        self_: *mut ISteamInput,
        eDestinationInputType: ESteamInputType,
        eSourceOrigin: EInputActionOrigin,
    ) -> EInputActionOrigin;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetDeviceBindingRevision(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
        pMajor: *mut ::std::os::raw::c_int,
        pMinor: *mut ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInput_GetRemotePlaySessionID(
        self_: *mut ISteamInput,
        inputHandle: InputHandle_t,
    ) -> uint32;
}
extern "C" {
    pub fn SteamAPI_SteamController_v008() -> *mut ISteamController;
}
extern "C" {
    pub fn SteamAPI_ISteamController_Init(self_: *mut ISteamController) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamController_Shutdown(self_: *mut ISteamController) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamController_RunFrame(self_: *mut ISteamController);
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetConnectedControllers(
        self_: *mut ISteamController,
        handlesOut: *mut ControllerHandle_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetActionSetHandle(
        self_: *mut ISteamController,
        pszActionSetName: *const ::std::os::raw::c_char,
    ) -> ControllerActionSetHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamController_ActivateActionSet(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
        actionSetHandle: ControllerActionSetHandle_t,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetCurrentActionSet(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
    ) -> ControllerActionSetHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamController_ActivateActionSetLayer(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
        actionSetLayerHandle: ControllerActionSetHandle_t,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamController_DeactivateActionSetLayer(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
        actionSetLayerHandle: ControllerActionSetHandle_t,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamController_DeactivateAllActionSetLayers(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetActiveActionSetLayers(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
        handlesOut: *mut ControllerActionSetHandle_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetDigitalActionHandle(
        self_: *mut ISteamController,
        pszActionName: *const ::std::os::raw::c_char,
    ) -> ControllerDigitalActionHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetDigitalActionData(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
        digitalActionHandle: ControllerDigitalActionHandle_t,
    ) -> InputDigitalActionData_t;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetDigitalActionOrigins(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
        actionSetHandle: ControllerActionSetHandle_t,
        digitalActionHandle: ControllerDigitalActionHandle_t,
        originsOut: *mut EControllerActionOrigin,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetAnalogActionHandle(
        self_: *mut ISteamController,
        pszActionName: *const ::std::os::raw::c_char,
    ) -> ControllerAnalogActionHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetAnalogActionData(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
        analogActionHandle: ControllerAnalogActionHandle_t,
    ) -> InputAnalogActionData_t;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetAnalogActionOrigins(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
        actionSetHandle: ControllerActionSetHandle_t,
        analogActionHandle: ControllerAnalogActionHandle_t,
        originsOut: *mut EControllerActionOrigin,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetGlyphForActionOrigin(
        self_: *mut ISteamController,
        eOrigin: EControllerActionOrigin,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetStringForActionOrigin(
        self_: *mut ISteamController,
        eOrigin: EControllerActionOrigin,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamController_StopAnalogActionMomentum(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
        eAction: ControllerAnalogActionHandle_t,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetMotionData(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
    ) -> InputMotionData_t;
}
extern "C" {
    pub fn SteamAPI_ISteamController_TriggerHapticPulse(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
        eTargetPad: ESteamControllerPad,
        usDurationMicroSec: ::std::os::raw::c_ushort,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamController_TriggerRepeatedHapticPulse(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
        eTargetPad: ESteamControllerPad,
        usDurationMicroSec: ::std::os::raw::c_ushort,
        usOffMicroSec: ::std::os::raw::c_ushort,
        unRepeat: ::std::os::raw::c_ushort,
        nFlags: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamController_TriggerVibration(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
        usLeftSpeed: ::std::os::raw::c_ushort,
        usRightSpeed: ::std::os::raw::c_ushort,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamController_SetLEDColor(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
        nColorR: uint8,
        nColorG: uint8,
        nColorB: uint8,
        nFlags: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamController_ShowBindingPanel(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetInputTypeForHandle(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
    ) -> ESteamInputType;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetControllerForGamepadIndex(
        self_: *mut ISteamController,
        nIndex: ::std::os::raw::c_int,
    ) -> ControllerHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetGamepadIndexForController(
        self_: *mut ISteamController,
        ulControllerHandle: ControllerHandle_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetStringForXboxOrigin(
        self_: *mut ISteamController,
        eOrigin: EXboxOrigin,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetGlyphForXboxOrigin(
        self_: *mut ISteamController,
        eOrigin: EXboxOrigin,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetActionOriginFromXboxOrigin(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
        eOrigin: EXboxOrigin,
    ) -> EControllerActionOrigin;
}
extern "C" {
    pub fn SteamAPI_ISteamController_TranslateActionOrigin(
        self_: *mut ISteamController,
        eDestinationInputType: ESteamInputType,
        eSourceOrigin: EControllerActionOrigin,
    ) -> EControllerActionOrigin;
}
extern "C" {
    pub fn SteamAPI_ISteamController_GetControllerBindingRevision(
        self_: *mut ISteamController,
        controllerHandle: ControllerHandle_t,
        pMajor: *mut ::std::os::raw::c_int,
        pMinor: *mut ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamUGC_v015() -> *mut ISteamUGC;
}
extern "C" {
    pub fn SteamAPI_SteamGameServerUGC_v015() -> *mut ISteamUGC;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_CreateQueryUserUGCRequest(
        self_: *mut ISteamUGC,
        unAccountID: AccountID_t,
        eListType: EUserUGCList,
        eMatchingUGCType: EUGCMatchingUGCType,
        eSortOrder: EUserUGCListSortOrder,
        nCreatorAppID: AppId_t,
        nConsumerAppID: AppId_t,
        unPage: uint32,
    ) -> UGCQueryHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_CreateQueryAllUGCRequestPage(
        self_: *mut ISteamUGC,
        eQueryType: EUGCQuery,
        eMatchingeMatchingUGCTypeFileType: EUGCMatchingUGCType,
        nCreatorAppID: AppId_t,
        nConsumerAppID: AppId_t,
        unPage: uint32,
    ) -> UGCQueryHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_CreateQueryAllUGCRequestCursor(
        self_: *mut ISteamUGC,
        eQueryType: EUGCQuery,
        eMatchingeMatchingUGCTypeFileType: EUGCMatchingUGCType,
        nCreatorAppID: AppId_t,
        nConsumerAppID: AppId_t,
        pchCursor: *const ::std::os::raw::c_char,
    ) -> UGCQueryHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_CreateQueryUGCDetailsRequest(
        self_: *mut ISteamUGC,
        pvecPublishedFileID: *mut PublishedFileId_t,
        unNumPublishedFileIDs: uint32,
    ) -> UGCQueryHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SendQueryUGCRequest(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetQueryUGCResult(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        index: uint32,
        pDetails: *mut SteamUGCDetails_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetQueryUGCNumTags(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        index: uint32,
    ) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetQueryUGCTag(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        index: uint32,
        indexTag: uint32,
        pchValue: *mut ::std::os::raw::c_char,
        cchValueSize: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetQueryUGCTagDisplayName(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        index: uint32,
        indexTag: uint32,
        pchValue: *mut ::std::os::raw::c_char,
        cchValueSize: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetQueryUGCPreviewURL(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        index: uint32,
        pchURL: *mut ::std::os::raw::c_char,
        cchURLSize: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetQueryUGCMetadata(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        index: uint32,
        pchMetadata: *mut ::std::os::raw::c_char,
        cchMetadatasize: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetQueryUGCChildren(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        index: uint32,
        pvecPublishedFileID: *mut PublishedFileId_t,
        cMaxEntries: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetQueryUGCStatistic(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        index: uint32,
        eStatType: EItemStatistic,
        pStatValue: *mut uint64,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetQueryUGCNumAdditionalPreviews(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        index: uint32,
    ) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetQueryUGCAdditionalPreview(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        index: uint32,
        previewIndex: uint32,
        pchURLOrVideoID: *mut ::std::os::raw::c_char,
        cchURLSize: uint32,
        pchOriginalFileName: *mut ::std::os::raw::c_char,
        cchOriginalFileNameSize: uint32,
        pPreviewType: *mut EItemPreviewType,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetQueryUGCNumKeyValueTags(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        index: uint32,
    ) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetQueryUGCKeyValueTag(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        index: uint32,
        keyValueTagIndex: uint32,
        pchKey: *mut ::std::os::raw::c_char,
        cchKeySize: uint32,
        pchValue: *mut ::std::os::raw::c_char,
        cchValueSize: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetQueryFirstUGCKeyValueTag(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        index: uint32,
        pchKey: *const ::std::os::raw::c_char,
        pchValue: *mut ::std::os::raw::c_char,
        cchValueSize: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_ReleaseQueryUGCRequest(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_AddRequiredTag(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        pTagName: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_AddRequiredTagGroup(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        pTagGroups: *const SteamParamStringArray_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_AddExcludedTag(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        pTagName: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetReturnOnlyIDs(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        bReturnOnlyIDs: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetReturnKeyValueTags(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        bReturnKeyValueTags: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetReturnLongDescription(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        bReturnLongDescription: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetReturnMetadata(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        bReturnMetadata: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetReturnChildren(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        bReturnChildren: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetReturnAdditionalPreviews(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        bReturnAdditionalPreviews: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetReturnTotalOnly(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        bReturnTotalOnly: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetReturnPlaytimeStats(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        unDays: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetLanguage(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        pchLanguage: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetAllowCachedResponse(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        unMaxAgeSeconds: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetCloudFileNameFilter(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        pMatchCloudFileName: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetMatchAnyTag(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        bMatchAnyTag: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetSearchText(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        pSearchText: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetRankedByTrendDays(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        unDays: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_AddRequiredKeyValueTag(
        self_: *mut ISteamUGC,
        handle: UGCQueryHandle_t,
        pKey: *const ::std::os::raw::c_char,
        pValue: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_RequestUGCDetails(
        self_: *mut ISteamUGC,
        nPublishedFileID: PublishedFileId_t,
        unMaxAgeSeconds: uint32,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_CreateItem(
        self_: *mut ISteamUGC,
        nConsumerAppId: AppId_t,
        eFileType: EWorkshopFileType,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_StartItemUpdate(
        self_: *mut ISteamUGC,
        nConsumerAppId: AppId_t,
        nPublishedFileID: PublishedFileId_t,
    ) -> UGCUpdateHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetItemTitle(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        pchTitle: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetItemDescription(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        pchDescription: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetItemUpdateLanguage(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        pchLanguage: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetItemMetadata(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        pchMetaData: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetItemVisibility(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        eVisibility: ERemoteStoragePublishedFileVisibility,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetItemTags(
        self_: *mut ISteamUGC,
        updateHandle: UGCUpdateHandle_t,
        pTags: *const SteamParamStringArray_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetItemContent(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        pszContentFolder: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetItemPreview(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        pszPreviewFile: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetAllowLegacyUpload(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        bAllowLegacyUpload: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_RemoveAllItemKeyValueTags(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_RemoveItemKeyValueTags(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        pchKey: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_AddItemKeyValueTag(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        pchKey: *const ::std::os::raw::c_char,
        pchValue: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_AddItemPreviewFile(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        pszPreviewFile: *const ::std::os::raw::c_char,
        type_: EItemPreviewType,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_AddItemPreviewVideo(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        pszVideoID: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_UpdateItemPreviewFile(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        index: uint32,
        pszPreviewFile: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_UpdateItemPreviewVideo(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        index: uint32,
        pszVideoID: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_RemoveItemPreview(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        index: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SubmitItemUpdate(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        pchChangeNote: *const ::std::os::raw::c_char,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetItemUpdateProgress(
        self_: *mut ISteamUGC,
        handle: UGCUpdateHandle_t,
        punBytesProcessed: *mut uint64,
        punBytesTotal: *mut uint64,
    ) -> EItemUpdateStatus;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SetUserItemVote(
        self_: *mut ISteamUGC,
        nPublishedFileID: PublishedFileId_t,
        bVoteUp: bool,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetUserItemVote(
        self_: *mut ISteamUGC,
        nPublishedFileID: PublishedFileId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_AddItemToFavorites(
        self_: *mut ISteamUGC,
        nAppId: AppId_t,
        nPublishedFileID: PublishedFileId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_RemoveItemFromFavorites(
        self_: *mut ISteamUGC,
        nAppId: AppId_t,
        nPublishedFileID: PublishedFileId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SubscribeItem(
        self_: *mut ISteamUGC,
        nPublishedFileID: PublishedFileId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_UnsubscribeItem(
        self_: *mut ISteamUGC,
        nPublishedFileID: PublishedFileId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetNumSubscribedItems(self_: *mut ISteamUGC) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetSubscribedItems(
        self_: *mut ISteamUGC,
        pvecPublishedFileID: *mut PublishedFileId_t,
        cMaxEntries: uint32,
    ) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetItemState(
        self_: *mut ISteamUGC,
        nPublishedFileID: PublishedFileId_t,
    ) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetItemInstallInfo(
        self_: *mut ISteamUGC,
        nPublishedFileID: PublishedFileId_t,
        punSizeOnDisk: *mut uint64,
        pchFolder: *mut ::std::os::raw::c_char,
        cchFolderSize: uint32,
        punTimeStamp: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetItemDownloadInfo(
        self_: *mut ISteamUGC,
        nPublishedFileID: PublishedFileId_t,
        punBytesDownloaded: *mut uint64,
        punBytesTotal: *mut uint64,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_DownloadItem(
        self_: *mut ISteamUGC,
        nPublishedFileID: PublishedFileId_t,
        bHighPriority: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_BInitWorkshopForGameServer(
        self_: *mut ISteamUGC,
        unWorkshopDepotID: DepotId_t,
        pszFolder: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_SuspendDownloads(self_: *mut ISteamUGC, bSuspend: bool);
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_StartPlaytimeTracking(
        self_: *mut ISteamUGC,
        pvecPublishedFileID: *mut PublishedFileId_t,
        unNumPublishedFileIDs: uint32,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_StopPlaytimeTracking(
        self_: *mut ISteamUGC,
        pvecPublishedFileID: *mut PublishedFileId_t,
        unNumPublishedFileIDs: uint32,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_StopPlaytimeTrackingForAllItems(
        self_: *mut ISteamUGC,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_AddDependency(
        self_: *mut ISteamUGC,
        nParentPublishedFileID: PublishedFileId_t,
        nChildPublishedFileID: PublishedFileId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_RemoveDependency(
        self_: *mut ISteamUGC,
        nParentPublishedFileID: PublishedFileId_t,
        nChildPublishedFileID: PublishedFileId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_AddAppDependency(
        self_: *mut ISteamUGC,
        nPublishedFileID: PublishedFileId_t,
        nAppID: AppId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_RemoveAppDependency(
        self_: *mut ISteamUGC,
        nPublishedFileID: PublishedFileId_t,
        nAppID: AppId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_GetAppDependencies(
        self_: *mut ISteamUGC,
        nPublishedFileID: PublishedFileId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamUGC_DeleteItem(
        self_: *mut ISteamUGC,
        nPublishedFileID: PublishedFileId_t,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_SteamAppList_v001() -> *mut ISteamAppList;
}
extern "C" {
    pub fn SteamAPI_ISteamAppList_GetNumInstalledApps(self_: *mut ISteamAppList) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamAppList_GetInstalledApps(
        self_: *mut ISteamAppList,
        pvecAppID: *mut AppId_t,
        unMaxAppIDs: uint32,
    ) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamAppList_GetAppName(
        self_: *mut ISteamAppList,
        nAppID: AppId_t,
        pchName: *mut ::std::os::raw::c_char,
        cchNameMax: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamAppList_GetAppInstallDir(
        self_: *mut ISteamAppList,
        nAppID: AppId_t,
        pchDirectory: *mut ::std::os::raw::c_char,
        cchNameMax: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamAppList_GetAppBuildId(
        self_: *mut ISteamAppList,
        nAppID: AppId_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_SteamHTMLSurface_v005() -> *mut ISteamHTMLSurface;
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_Init(self_: *mut ISteamHTMLSurface) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_Shutdown(self_: *mut ISteamHTMLSurface) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_CreateBrowser(
        self_: *mut ISteamHTMLSurface,
        pchUserAgent: *const ::std::os::raw::c_char,
        pchUserCSS: *const ::std::os::raw::c_char,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_RemoveBrowser(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_LoadURL(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        pchURL: *const ::std::os::raw::c_char,
        pchPostData: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_SetSize(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        unWidth: uint32,
        unHeight: uint32,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_StopLoad(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_Reload(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_GoBack(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_GoForward(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_AddHeader(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        pchKey: *const ::std::os::raw::c_char,
        pchValue: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_ExecuteJavascript(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        pchScript: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_MouseUp(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        eMouseButton: ISteamHTMLSurface_EHTMLMouseButton,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_MouseDown(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        eMouseButton: ISteamHTMLSurface_EHTMLMouseButton,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_MouseDoubleClick(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        eMouseButton: ISteamHTMLSurface_EHTMLMouseButton,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_MouseMove(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_MouseWheel(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        nDelta: int32,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_KeyDown(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        nNativeKeyCode: uint32,
        eHTMLKeyModifiers: ISteamHTMLSurface_EHTMLKeyModifiers,
        bIsSystemKey: bool,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_KeyUp(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        nNativeKeyCode: uint32,
        eHTMLKeyModifiers: ISteamHTMLSurface_EHTMLKeyModifiers,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_KeyChar(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        cUnicodeChar: uint32,
        eHTMLKeyModifiers: ISteamHTMLSurface_EHTMLKeyModifiers,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_SetHorizontalScroll(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        nAbsolutePixelScroll: uint32,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_SetVerticalScroll(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        nAbsolutePixelScroll: uint32,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_SetKeyFocus(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        bHasKeyFocus: bool,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_ViewSource(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_CopyToClipboard(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_PasteFromClipboard(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_Find(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        pchSearchStr: *const ::std::os::raw::c_char,
        bCurrentlyInFind: bool,
        bReverse: bool,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_StopFind(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_GetLinkAtPosition(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        x: ::std::os::raw::c_int,
        y: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_SetCookie(
        self_: *mut ISteamHTMLSurface,
        pchHostname: *const ::std::os::raw::c_char,
        pchKey: *const ::std::os::raw::c_char,
        pchValue: *const ::std::os::raw::c_char,
        pchPath: *const ::std::os::raw::c_char,
        nExpires: RTime32,
        bSecure: bool,
        bHTTPOnly: bool,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_SetPageScaleFactor(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        flZoom: f32,
        nPointX: ::std::os::raw::c_int,
        nPointY: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_SetBackgroundMode(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        bBackgroundMode: bool,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_SetDPIScalingFactor(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        flDPIScaling: f32,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_OpenDeveloperTools(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_AllowStartRequest(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        bAllowed: bool,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_JSDialogResponse(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        bResult: bool,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamHTMLSurface_FileLoadDialogResponse(
        self_: *mut ISteamHTMLSurface,
        unBrowserHandle: HHTMLBrowser,
        pchSelectedFiles: *mut *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_SteamInventory_v003() -> *mut ISteamInventory;
}
extern "C" {
    pub fn SteamAPI_SteamGameServerInventory_v003() -> *mut ISteamInventory;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_GetResultStatus(
        self_: *mut ISteamInventory,
        resultHandle: SteamInventoryResult_t,
    ) -> EResult;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_GetResultItems(
        self_: *mut ISteamInventory,
        resultHandle: SteamInventoryResult_t,
        pOutItemsArray: *mut SteamItemDetails_t,
        punOutItemsArraySize: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_GetResultItemProperty(
        self_: *mut ISteamInventory,
        resultHandle: SteamInventoryResult_t,
        unItemIndex: uint32,
        pchPropertyName: *const ::std::os::raw::c_char,
        pchValueBuffer: *mut ::std::os::raw::c_char,
        punValueBufferSizeOut: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_GetResultTimestamp(
        self_: *mut ISteamInventory,
        resultHandle: SteamInventoryResult_t,
    ) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_CheckResultSteamID(
        self_: *mut ISteamInventory,
        resultHandle: SteamInventoryResult_t,
        steamIDExpected: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_DestroyResult(
        self_: *mut ISteamInventory,
        resultHandle: SteamInventoryResult_t,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_GetAllItems(
        self_: *mut ISteamInventory,
        pResultHandle: *mut SteamInventoryResult_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_GetItemsByID(
        self_: *mut ISteamInventory,
        pResultHandle: *mut SteamInventoryResult_t,
        pInstanceIDs: *const SteamItemInstanceID_t,
        unCountInstanceIDs: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_SerializeResult(
        self_: *mut ISteamInventory,
        resultHandle: SteamInventoryResult_t,
        pOutBuffer: *mut ::std::os::raw::c_void,
        punOutBufferSize: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_DeserializeResult(
        self_: *mut ISteamInventory,
        pOutResultHandle: *mut SteamInventoryResult_t,
        pBuffer: *const ::std::os::raw::c_void,
        unBufferSize: uint32,
        bRESERVED_MUST_BE_FALSE: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_GenerateItems(
        self_: *mut ISteamInventory,
        pResultHandle: *mut SteamInventoryResult_t,
        pArrayItemDefs: *const SteamItemDef_t,
        punArrayQuantity: *const uint32,
        unArrayLength: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_GrantPromoItems(
        self_: *mut ISteamInventory,
        pResultHandle: *mut SteamInventoryResult_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_AddPromoItem(
        self_: *mut ISteamInventory,
        pResultHandle: *mut SteamInventoryResult_t,
        itemDef: SteamItemDef_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_AddPromoItems(
        self_: *mut ISteamInventory,
        pResultHandle: *mut SteamInventoryResult_t,
        pArrayItemDefs: *const SteamItemDef_t,
        unArrayLength: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_ConsumeItem(
        self_: *mut ISteamInventory,
        pResultHandle: *mut SteamInventoryResult_t,
        itemConsume: SteamItemInstanceID_t,
        unQuantity: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_ExchangeItems(
        self_: *mut ISteamInventory,
        pResultHandle: *mut SteamInventoryResult_t,
        pArrayGenerate: *const SteamItemDef_t,
        punArrayGenerateQuantity: *const uint32,
        unArrayGenerateLength: uint32,
        pArrayDestroy: *const SteamItemInstanceID_t,
        punArrayDestroyQuantity: *const uint32,
        unArrayDestroyLength: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_TransferItemQuantity(
        self_: *mut ISteamInventory,
        pResultHandle: *mut SteamInventoryResult_t,
        itemIdSource: SteamItemInstanceID_t,
        unQuantity: uint32,
        itemIdDest: SteamItemInstanceID_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_SendItemDropHeartbeat(self_: *mut ISteamInventory);
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_TriggerItemDrop(
        self_: *mut ISteamInventory,
        pResultHandle: *mut SteamInventoryResult_t,
        dropListDefinition: SteamItemDef_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_TradeItems(
        self_: *mut ISteamInventory,
        pResultHandle: *mut SteamInventoryResult_t,
        steamIDTradePartner: uint64_steamid,
        pArrayGive: *const SteamItemInstanceID_t,
        pArrayGiveQuantity: *const uint32,
        nArrayGiveLength: uint32,
        pArrayGet: *const SteamItemInstanceID_t,
        pArrayGetQuantity: *const uint32,
        nArrayGetLength: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_LoadItemDefinitions(self_: *mut ISteamInventory) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_GetItemDefinitionIDs(
        self_: *mut ISteamInventory,
        pItemDefIDs: *mut SteamItemDef_t,
        punItemDefIDsArraySize: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_GetItemDefinitionProperty(
        self_: *mut ISteamInventory,
        iDefinition: SteamItemDef_t,
        pchPropertyName: *const ::std::os::raw::c_char,
        pchValueBuffer: *mut ::std::os::raw::c_char,
        punValueBufferSizeOut: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_RequestEligiblePromoItemDefinitionsIDs(
        self_: *mut ISteamInventory,
        steamID: uint64_steamid,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_GetEligiblePromoItemDefinitionIDs(
        self_: *mut ISteamInventory,
        steamID: uint64_steamid,
        pItemDefIDs: *mut SteamItemDef_t,
        punItemDefIDsArraySize: *mut uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_StartPurchase(
        self_: *mut ISteamInventory,
        pArrayItemDefs: *const SteamItemDef_t,
        punArrayQuantity: *const uint32,
        unArrayLength: uint32,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_RequestPrices(self_: *mut ISteamInventory) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_GetNumItemsWithPrices(self_: *mut ISteamInventory) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_GetItemsWithPrices(
        self_: *mut ISteamInventory,
        pArrayItemDefs: *mut SteamItemDef_t,
        pCurrentPrices: *mut uint64,
        pBasePrices: *mut uint64,
        unArrayLength: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_GetItemPrice(
        self_: *mut ISteamInventory,
        iDefinition: SteamItemDef_t,
        pCurrentPrice: *mut uint64,
        pBasePrice: *mut uint64,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_StartUpdateProperties(
        self_: *mut ISteamInventory,
    ) -> SteamInventoryUpdateHandle_t;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_RemoveProperty(
        self_: *mut ISteamInventory,
        handle: SteamInventoryUpdateHandle_t,
        nItemID: SteamItemInstanceID_t,
        pchPropertyName: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_SetPropertyString(
        self_: *mut ISteamInventory,
        handle: SteamInventoryUpdateHandle_t,
        nItemID: SteamItemInstanceID_t,
        pchPropertyName: *const ::std::os::raw::c_char,
        pchPropertyValue: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_SetPropertyBool(
        self_: *mut ISteamInventory,
        handle: SteamInventoryUpdateHandle_t,
        nItemID: SteamItemInstanceID_t,
        pchPropertyName: *const ::std::os::raw::c_char,
        bValue: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_SetPropertyInt64(
        self_: *mut ISteamInventory,
        handle: SteamInventoryUpdateHandle_t,
        nItemID: SteamItemInstanceID_t,
        pchPropertyName: *const ::std::os::raw::c_char,
        nValue: int64,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_SetPropertyFloat(
        self_: *mut ISteamInventory,
        handle: SteamInventoryUpdateHandle_t,
        nItemID: SteamItemInstanceID_t,
        pchPropertyName: *const ::std::os::raw::c_char,
        flValue: f32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_SubmitUpdateProperties(
        self_: *mut ISteamInventory,
        handle: SteamInventoryUpdateHandle_t,
        pResultHandle: *mut SteamInventoryResult_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamInventory_InspectItem(
        self_: *mut ISteamInventory,
        pResultHandle: *mut SteamInventoryResult_t,
        pchItemToken: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamVideo_v002() -> *mut ISteamVideo;
}
extern "C" {
    pub fn SteamAPI_ISteamVideo_GetVideoURL(self_: *mut ISteamVideo, unVideoAppID: AppId_t);
}
extern "C" {
    pub fn SteamAPI_ISteamVideo_IsBroadcasting(
        self_: *mut ISteamVideo,
        pnNumViewers: *mut ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamVideo_GetOPFSettings(self_: *mut ISteamVideo, unVideoAppID: AppId_t);
}
extern "C" {
    pub fn SteamAPI_ISteamVideo_GetOPFStringForApp(
        self_: *mut ISteamVideo,
        unVideoAppID: AppId_t,
        pchBuffer: *mut ::std::os::raw::c_char,
        pnBufferSize: *mut int32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamParentalSettings_v001() -> *mut ISteamParentalSettings;
}
extern "C" {
    pub fn SteamAPI_ISteamParentalSettings_BIsParentalLockEnabled(
        self_: *mut ISteamParentalSettings,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamParentalSettings_BIsParentalLockLocked(
        self_: *mut ISteamParentalSettings,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamParentalSettings_BIsAppBlocked(
        self_: *mut ISteamParentalSettings,
        nAppID: AppId_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamParentalSettings_BIsAppInBlockList(
        self_: *mut ISteamParentalSettings,
        nAppID: AppId_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamParentalSettings_BIsFeatureBlocked(
        self_: *mut ISteamParentalSettings,
        eFeature: EParentalFeature,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamParentalSettings_BIsFeatureInBlockList(
        self_: *mut ISteamParentalSettings,
        eFeature: EParentalFeature,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamRemotePlay_v001() -> *mut ISteamRemotePlay;
}
extern "C" {
    pub fn SteamAPI_ISteamRemotePlay_GetSessionCount(self_: *mut ISteamRemotePlay) -> uint32;
}
extern "C" {
    pub fn SteamAPI_ISteamRemotePlay_GetSessionID(
        self_: *mut ISteamRemotePlay,
        iSessionIndex: ::std::os::raw::c_int,
    ) -> RemotePlaySessionID_t;
}
extern "C" {
    pub fn SteamAPI_ISteamRemotePlay_GetSessionSteamID(
        self_: *mut ISteamRemotePlay,
        unSessionID: RemotePlaySessionID_t,
    ) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_ISteamRemotePlay_GetSessionClientName(
        self_: *mut ISteamRemotePlay,
        unSessionID: RemotePlaySessionID_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_ISteamRemotePlay_GetSessionClientFormFactor(
        self_: *mut ISteamRemotePlay,
        unSessionID: RemotePlaySessionID_t,
    ) -> ESteamDeviceFormFactor;
}
extern "C" {
    pub fn SteamAPI_ISteamRemotePlay_BGetSessionClientResolution(
        self_: *mut ISteamRemotePlay,
        unSessionID: RemotePlaySessionID_t,
        pnResolutionX: *mut ::std::os::raw::c_int,
        pnResolutionY: *mut ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamRemotePlay_BSendRemotePlayTogetherInvite(
        self_: *mut ISteamRemotePlay,
        steamIDFriend: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingMessages_SteamAPI_v002() -> *mut ISteamNetworkingMessages;
}
extern "C" {
    pub fn SteamAPI_SteamGameServerNetworkingMessages_SteamAPI_v002(
    ) -> *mut ISteamNetworkingMessages;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingMessages_SendMessageToUser(
        self_: *mut ISteamNetworkingMessages,
        identityRemote: *const SteamNetworkingIdentity,
        pubData: *const ::std::os::raw::c_void,
        cubData: uint32,
        nSendFlags: ::std::os::raw::c_int,
        nRemoteChannel: ::std::os::raw::c_int,
    ) -> EResult;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingMessages_ReceiveMessagesOnChannel(
        self_: *mut ISteamNetworkingMessages,
        nLocalChannel: ::std::os::raw::c_int,
        ppOutMessages: *mut *mut SteamNetworkingMessage_t,
        nMaxMessages: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingMessages_AcceptSessionWithUser(
        self_: *mut ISteamNetworkingMessages,
        identityRemote: *const SteamNetworkingIdentity,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingMessages_CloseSessionWithUser(
        self_: *mut ISteamNetworkingMessages,
        identityRemote: *const SteamNetworkingIdentity,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingMessages_CloseChannelWithUser(
        self_: *mut ISteamNetworkingMessages,
        identityRemote: *const SteamNetworkingIdentity,
        nLocalChannel: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingMessages_GetSessionConnectionInfo(
        self_: *mut ISteamNetworkingMessages,
        identityRemote: *const SteamNetworkingIdentity,
        pConnectionInfo: *mut SteamNetConnectionInfo_t,
        pQuickStatus: *mut SteamNetworkingQuickConnectionStatus,
    ) -> ESteamNetworkingConnectionState;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingSockets_SteamAPI_v009() -> *mut ISteamNetworkingSockets;
}
extern "C" {
    pub fn SteamAPI_SteamGameServerNetworkingSockets_SteamAPI_v009() -> *mut ISteamNetworkingSockets;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_CreateListenSocketIP(
        self_: *mut ISteamNetworkingSockets,
        localAddress: *const SteamNetworkingIPAddr,
        nOptions: ::std::os::raw::c_int,
        pOptions: *const SteamNetworkingConfigValue_t,
    ) -> HSteamListenSocket;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_ConnectByIPAddress(
        self_: *mut ISteamNetworkingSockets,
        address: *const SteamNetworkingIPAddr,
        nOptions: ::std::os::raw::c_int,
        pOptions: *const SteamNetworkingConfigValue_t,
    ) -> HSteamNetConnection;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_CreateListenSocketP2P(
        self_: *mut ISteamNetworkingSockets,
        nLocalVirtualPort: ::std::os::raw::c_int,
        nOptions: ::std::os::raw::c_int,
        pOptions: *const SteamNetworkingConfigValue_t,
    ) -> HSteamListenSocket;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_ConnectP2P(
        self_: *mut ISteamNetworkingSockets,
        identityRemote: *const SteamNetworkingIdentity,
        nRemoteVirtualPort: ::std::os::raw::c_int,
        nOptions: ::std::os::raw::c_int,
        pOptions: *const SteamNetworkingConfigValue_t,
    ) -> HSteamNetConnection;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_AcceptConnection(
        self_: *mut ISteamNetworkingSockets,
        hConn: HSteamNetConnection,
    ) -> EResult;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_CloseConnection(
        self_: *mut ISteamNetworkingSockets,
        hPeer: HSteamNetConnection,
        nReason: ::std::os::raw::c_int,
        pszDebug: *const ::std::os::raw::c_char,
        bEnableLinger: bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_CloseListenSocket(
        self_: *mut ISteamNetworkingSockets,
        hSocket: HSteamListenSocket,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_SetConnectionUserData(
        self_: *mut ISteamNetworkingSockets,
        hPeer: HSteamNetConnection,
        nUserData: int64,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_GetConnectionUserData(
        self_: *mut ISteamNetworkingSockets,
        hPeer: HSteamNetConnection,
    ) -> int64;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_SetConnectionName(
        self_: *mut ISteamNetworkingSockets,
        hPeer: HSteamNetConnection,
        pszName: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_GetConnectionName(
        self_: *mut ISteamNetworkingSockets,
        hPeer: HSteamNetConnection,
        pszName: *mut ::std::os::raw::c_char,
        nMaxLen: ::std::os::raw::c_int,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_SendMessageToConnection(
        self_: *mut ISteamNetworkingSockets,
        hConn: HSteamNetConnection,
        pData: *const ::std::os::raw::c_void,
        cbData: uint32,
        nSendFlags: ::std::os::raw::c_int,
        pOutMessageNumber: *mut int64,
    ) -> EResult;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_SendMessages(
        self_: *mut ISteamNetworkingSockets,
        nMessages: ::std::os::raw::c_int,
        pMessages: *const *mut SteamNetworkingMessage_t,
        pOutMessageNumberOrResult: *mut int64,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_FlushMessagesOnConnection(
        self_: *mut ISteamNetworkingSockets,
        hConn: HSteamNetConnection,
    ) -> EResult;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_ReceiveMessagesOnConnection(
        self_: *mut ISteamNetworkingSockets,
        hConn: HSteamNetConnection,
        ppOutMessages: *mut *mut SteamNetworkingMessage_t,
        nMaxMessages: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_GetConnectionInfo(
        self_: *mut ISteamNetworkingSockets,
        hConn: HSteamNetConnection,
        pInfo: *mut SteamNetConnectionInfo_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_GetQuickConnectionStatus(
        self_: *mut ISteamNetworkingSockets,
        hConn: HSteamNetConnection,
        pStats: *mut SteamNetworkingQuickConnectionStatus,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_GetDetailedConnectionStatus(
        self_: *mut ISteamNetworkingSockets,
        hConn: HSteamNetConnection,
        pszBuf: *mut ::std::os::raw::c_char,
        cbBuf: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_GetListenSocketAddress(
        self_: *mut ISteamNetworkingSockets,
        hSocket: HSteamListenSocket,
        address: *mut SteamNetworkingIPAddr,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_CreateSocketPair(
        self_: *mut ISteamNetworkingSockets,
        pOutConnection1: *mut HSteamNetConnection,
        pOutConnection2: *mut HSteamNetConnection,
        bUseNetworkLoopback: bool,
        pIdentity1: *const SteamNetworkingIdentity,
        pIdentity2: *const SteamNetworkingIdentity,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_GetIdentity(
        self_: *mut ISteamNetworkingSockets,
        pIdentity: *mut SteamNetworkingIdentity,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_InitAuthentication(
        self_: *mut ISteamNetworkingSockets,
    ) -> ESteamNetworkingAvailability;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_GetAuthenticationStatus(
        self_: *mut ISteamNetworkingSockets,
        pDetails: *mut SteamNetAuthenticationStatus_t,
    ) -> ESteamNetworkingAvailability;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_CreatePollGroup(
        self_: *mut ISteamNetworkingSockets,
    ) -> HSteamNetPollGroup;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_DestroyPollGroup(
        self_: *mut ISteamNetworkingSockets,
        hPollGroup: HSteamNetPollGroup,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_SetConnectionPollGroup(
        self_: *mut ISteamNetworkingSockets,
        hConn: HSteamNetConnection,
        hPollGroup: HSteamNetPollGroup,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_ReceiveMessagesOnPollGroup(
        self_: *mut ISteamNetworkingSockets,
        hPollGroup: HSteamNetPollGroup,
        ppOutMessages: *mut *mut SteamNetworkingMessage_t,
        nMaxMessages: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_ReceivedRelayAuthTicket(
        self_: *mut ISteamNetworkingSockets,
        pvTicket: *const ::std::os::raw::c_void,
        cbTicket: ::std::os::raw::c_int,
        pOutParsedTicket: *mut SteamDatagramRelayAuthTicket,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_FindRelayAuthTicketForServer(
        self_: *mut ISteamNetworkingSockets,
        identityGameServer: *const SteamNetworkingIdentity,
        nRemoteVirtualPort: ::std::os::raw::c_int,
        pOutParsedTicket: *mut SteamDatagramRelayAuthTicket,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_ConnectToHostedDedicatedServer(
        self_: *mut ISteamNetworkingSockets,
        identityTarget: *const SteamNetworkingIdentity,
        nRemoteVirtualPort: ::std::os::raw::c_int,
        nOptions: ::std::os::raw::c_int,
        pOptions: *const SteamNetworkingConfigValue_t,
    ) -> HSteamNetConnection;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_GetHostedDedicatedServerPort(
        self_: *mut ISteamNetworkingSockets,
    ) -> uint16;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_GetHostedDedicatedServerPOPID(
        self_: *mut ISteamNetworkingSockets,
    ) -> SteamNetworkingPOPID;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_GetHostedDedicatedServerAddress(
        self_: *mut ISteamNetworkingSockets,
        pRouting: *mut SteamDatagramHostedAddress,
    ) -> EResult;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_CreateHostedDedicatedServerListenSocket(
        self_: *mut ISteamNetworkingSockets,
        nLocalVirtualPort: ::std::os::raw::c_int,
        nOptions: ::std::os::raw::c_int,
        pOptions: *const SteamNetworkingConfigValue_t,
    ) -> HSteamListenSocket;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_GetGameCoordinatorServerLogin(
        self_: *mut ISteamNetworkingSockets,
        pLoginInfo: *mut SteamDatagramGameCoordinatorServerLogin,
        pcbSignedBlob: *mut ::std::os::raw::c_int,
        pBlob: *mut ::std::os::raw::c_void,
    ) -> EResult;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_ConnectP2PCustomSignaling(
        self_: *mut ISteamNetworkingSockets,
        pSignaling: *mut ISteamNetworkingConnectionSignaling,
        pPeerIdentity: *const SteamNetworkingIdentity,
        nRemoteVirtualPort: ::std::os::raw::c_int,
        nOptions: ::std::os::raw::c_int,
        pOptions: *const SteamNetworkingConfigValue_t,
    ) -> HSteamNetConnection;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_ReceivedP2PCustomSignal(
        self_: *mut ISteamNetworkingSockets,
        pMsg: *const ::std::os::raw::c_void,
        cbMsg: ::std::os::raw::c_int,
        pContext: *mut ISteamNetworkingSignalingRecvContext,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_GetCertificateRequest(
        self_: *mut ISteamNetworkingSockets,
        pcbBlob: *mut ::std::os::raw::c_int,
        pBlob: *mut ::std::os::raw::c_void,
        errMsg: *mut SteamNetworkingErrMsg,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_SetCertificate(
        self_: *mut ISteamNetworkingSockets,
        pCertificate: *const ::std::os::raw::c_void,
        cbCertificate: ::std::os::raw::c_int,
        errMsg: *mut SteamNetworkingErrMsg,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingSockets_RunCallbacks(self_: *mut ISteamNetworkingSockets);
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingUtils_SteamAPI_v003() -> *mut ISteamNetworkingUtils;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_AllocateMessage(
        self_: *mut ISteamNetworkingUtils,
        cbAllocateBuffer: ::std::os::raw::c_int,
    ) -> *mut SteamNetworkingMessage_t;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_InitRelayNetworkAccess(self_: *mut ISteamNetworkingUtils);
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_GetRelayNetworkStatus(
        self_: *mut ISteamNetworkingUtils,
        pDetails: *mut SteamRelayNetworkStatus_t,
    ) -> ESteamNetworkingAvailability;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_GetLocalPingLocation(
        self_: *mut ISteamNetworkingUtils,
        result: *mut SteamNetworkPingLocation_t,
    ) -> f32;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_EstimatePingTimeBetweenTwoLocations(
        self_: *mut ISteamNetworkingUtils,
        location1: *const SteamNetworkPingLocation_t,
        location2: *const SteamNetworkPingLocation_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_EstimatePingTimeFromLocalHost(
        self_: *mut ISteamNetworkingUtils,
        remoteLocation: *const SteamNetworkPingLocation_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_ConvertPingLocationToString(
        self_: *mut ISteamNetworkingUtils,
        location: *const SteamNetworkPingLocation_t,
        pszBuf: *mut ::std::os::raw::c_char,
        cchBufSize: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_ParsePingLocationString(
        self_: *mut ISteamNetworkingUtils,
        pszString: *const ::std::os::raw::c_char,
        result: *mut SteamNetworkPingLocation_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_CheckPingDataUpToDate(
        self_: *mut ISteamNetworkingUtils,
        flMaxAgeSeconds: f32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_GetPingToDataCenter(
        self_: *mut ISteamNetworkingUtils,
        popID: SteamNetworkingPOPID,
        pViaRelayPoP: *mut SteamNetworkingPOPID,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_GetDirectPingToPOP(
        self_: *mut ISteamNetworkingUtils,
        popID: SteamNetworkingPOPID,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_GetPOPCount(
        self_: *mut ISteamNetworkingUtils,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_GetPOPList(
        self_: *mut ISteamNetworkingUtils,
        list: *mut SteamNetworkingPOPID,
        nListSz: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_GetLocalTimestamp(
        self_: *mut ISteamNetworkingUtils,
    ) -> SteamNetworkingMicroseconds;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SetDebugOutputFunction(
        self_: *mut ISteamNetworkingUtils,
        eDetailLevel: ESteamNetworkingSocketsDebugOutputType,
        pfnFunc: FSteamNetworkingSocketsDebugOutput,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SetGlobalConfigValueInt32(
        self_: *mut ISteamNetworkingUtils,
        eValue: ESteamNetworkingConfigValue,
        val: int32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SetGlobalConfigValueFloat(
        self_: *mut ISteamNetworkingUtils,
        eValue: ESteamNetworkingConfigValue,
        val: f32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SetGlobalConfigValueString(
        self_: *mut ISteamNetworkingUtils,
        eValue: ESteamNetworkingConfigValue,
        val: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SetGlobalConfigValuePtr(
        self_: *mut ISteamNetworkingUtils,
        eValue: ESteamNetworkingConfigValue,
        val: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SetConnectionConfigValueInt32(
        self_: *mut ISteamNetworkingUtils,
        hConn: HSteamNetConnection,
        eValue: ESteamNetworkingConfigValue,
        val: int32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SetConnectionConfigValueFloat(
        self_: *mut ISteamNetworkingUtils,
        hConn: HSteamNetConnection,
        eValue: ESteamNetworkingConfigValue,
        val: f32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SetConnectionConfigValueString(
        self_: *mut ISteamNetworkingUtils,
        hConn: HSteamNetConnection,
        eValue: ESteamNetworkingConfigValue,
        val: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SetGlobalCallback_SteamNetConnectionStatusChanged(
        self_: *mut ISteamNetworkingUtils,
        fnCallback: FnSteamNetConnectionStatusChanged,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SetGlobalCallback_SteamNetAuthenticationStatusChanged(
        self_: *mut ISteamNetworkingUtils,
        fnCallback: FnSteamNetAuthenticationStatusChanged,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SetGlobalCallback_SteamRelayNetworkStatusChanged(
        self_: *mut ISteamNetworkingUtils,
        fnCallback: FnSteamRelayNetworkStatusChanged,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SetGlobalCallback_MessagesSessionRequest(
        self_: *mut ISteamNetworkingUtils,
        fnCallback: FnSteamNetworkingMessagesSessionRequest,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SetGlobalCallback_MessagesSessionFailed(
        self_: *mut ISteamNetworkingUtils,
        fnCallback: FnSteamNetworkingMessagesSessionFailed,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SetConfigValue(
        self_: *mut ISteamNetworkingUtils,
        eValue: ESteamNetworkingConfigValue,
        eScopeType: ESteamNetworkingConfigScope,
        scopeObj: isize,
        eDataType: ESteamNetworkingConfigDataType,
        pArg: *const ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SetConfigValueStruct(
        self_: *mut ISteamNetworkingUtils,
        opt: *const SteamNetworkingConfigValue_t,
        eScopeType: ESteamNetworkingConfigScope,
        scopeObj: isize,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_GetConfigValue(
        self_: *mut ISteamNetworkingUtils,
        eValue: ESteamNetworkingConfigValue,
        eScopeType: ESteamNetworkingConfigScope,
        scopeObj: isize,
        pOutDataType: *mut ESteamNetworkingConfigDataType,
        pResult: *mut ::std::os::raw::c_void,
        cbResult: *mut size_t,
    ) -> ESteamNetworkingGetConfigValueResult;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_GetConfigValueInfo(
        self_: *mut ISteamNetworkingUtils,
        eValue: ESteamNetworkingConfigValue,
        pOutName: *mut *const ::std::os::raw::c_char,
        pOutDataType: *mut ESteamNetworkingConfigDataType,
        pOutScope: *mut ESteamNetworkingConfigScope,
        pOutNextValue: *mut ESteamNetworkingConfigValue,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_GetFirstConfigValue(
        self_: *mut ISteamNetworkingUtils,
    ) -> ESteamNetworkingConfigValue;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SteamNetworkingIPAddr_ToString(
        self_: *mut ISteamNetworkingUtils,
        addr: *const SteamNetworkingIPAddr,
        buf: *mut ::std::os::raw::c_char,
        cbBuf: uint32,
        bWithPort: bool,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SteamNetworkingIPAddr_ParseString(
        self_: *mut ISteamNetworkingUtils,
        pAddr: *mut SteamNetworkingIPAddr,
        pszStr: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SteamNetworkingIdentity_ToString(
        self_: *mut ISteamNetworkingUtils,
        identity: *const SteamNetworkingIdentity,
        buf: *mut ::std::os::raw::c_char,
        cbBuf: uint32,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamNetworkingUtils_SteamNetworkingIdentity_ParseString(
        self_: *mut ISteamNetworkingUtils,
        pIdentity: *mut SteamNetworkingIdentity,
        pszStr: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamGameServer_v013() -> *mut ISteamGameServer;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetProduct(
        self_: *mut ISteamGameServer,
        pszProduct: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetGameDescription(
        self_: *mut ISteamGameServer,
        pszGameDescription: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetModDir(
        self_: *mut ISteamGameServer,
        pszModDir: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetDedicatedServer(
        self_: *mut ISteamGameServer,
        bDedicated: bool,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_LogOn(
        self_: *mut ISteamGameServer,
        pszToken: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_LogOnAnonymous(self_: *mut ISteamGameServer);
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_LogOff(self_: *mut ISteamGameServer);
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_BLoggedOn(self_: *mut ISteamGameServer) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_BSecure(self_: *mut ISteamGameServer) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_GetSteamID(self_: *mut ISteamGameServer) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_WasRestartRequested(self_: *mut ISteamGameServer) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetMaxPlayerCount(
        self_: *mut ISteamGameServer,
        cPlayersMax: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetBotPlayerCount(
        self_: *mut ISteamGameServer,
        cBotplayers: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetServerName(
        self_: *mut ISteamGameServer,
        pszServerName: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetMapName(
        self_: *mut ISteamGameServer,
        pszMapName: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetPasswordProtected(
        self_: *mut ISteamGameServer,
        bPasswordProtected: bool,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetSpectatorPort(
        self_: *mut ISteamGameServer,
        unSpectatorPort: uint16,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetSpectatorServerName(
        self_: *mut ISteamGameServer,
        pszSpectatorServerName: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_ClearAllKeyValues(self_: *mut ISteamGameServer);
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetKeyValue(
        self_: *mut ISteamGameServer,
        pKey: *const ::std::os::raw::c_char,
        pValue: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetGameTags(
        self_: *mut ISteamGameServer,
        pchGameTags: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetGameData(
        self_: *mut ISteamGameServer,
        pchGameData: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetRegion(
        self_: *mut ISteamGameServer,
        pszRegion: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SendUserConnectAndAuthenticate(
        self_: *mut ISteamGameServer,
        unIPClient: uint32,
        pvAuthBlob: *const ::std::os::raw::c_void,
        cubAuthBlobSize: uint32,
        pSteamIDUser: *mut CSteamID,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_CreateUnauthenticatedUserConnection(
        self_: *mut ISteamGameServer,
    ) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SendUserDisconnect(
        self_: *mut ISteamGameServer,
        steamIDUser: uint64_steamid,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_BUpdateUserData(
        self_: *mut ISteamGameServer,
        steamIDUser: uint64_steamid,
        pchPlayerName: *const ::std::os::raw::c_char,
        uScore: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_GetAuthSessionTicket(
        self_: *mut ISteamGameServer,
        pTicket: *mut ::std::os::raw::c_void,
        cbMaxTicket: ::std::os::raw::c_int,
        pcbTicket: *mut uint32,
    ) -> HAuthTicket;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_BeginAuthSession(
        self_: *mut ISteamGameServer,
        pAuthTicket: *const ::std::os::raw::c_void,
        cbAuthTicket: ::std::os::raw::c_int,
        steamID: uint64_steamid,
    ) -> EBeginAuthSessionResult;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_EndAuthSession(
        self_: *mut ISteamGameServer,
        steamID: uint64_steamid,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_CancelAuthTicket(
        self_: *mut ISteamGameServer,
        hAuthTicket: HAuthTicket,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_UserHasLicenseForApp(
        self_: *mut ISteamGameServer,
        steamID: uint64_steamid,
        appID: AppId_t,
    ) -> EUserHasLicenseForAppResult;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_RequestUserGroupStatus(
        self_: *mut ISteamGameServer,
        steamIDUser: uint64_steamid,
        steamIDGroup: uint64_steamid,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_GetGameplayStats(self_: *mut ISteamGameServer);
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_GetServerReputation(
        self_: *mut ISteamGameServer,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_GetPublicIP(self_: *mut ISteamGameServer) -> SteamIPAddress_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_HandleIncomingPacket(
        self_: *mut ISteamGameServer,
        pData: *const ::std::os::raw::c_void,
        cbData: ::std::os::raw::c_int,
        srcIP: uint32,
        srcPort: uint16,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_GetNextOutgoingPacket(
        self_: *mut ISteamGameServer,
        pOut: *mut ::std::os::raw::c_void,
        cbMaxOut: ::std::os::raw::c_int,
        pNetAdr: *mut uint32,
        pPort: *mut uint16,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_EnableHeartbeats(self_: *mut ISteamGameServer, bActive: bool);
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_SetHeartbeatInterval(
        self_: *mut ISteamGameServer,
        iHeartbeatInterval: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_ForceHeartbeat(self_: *mut ISteamGameServer);
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_AssociateWithClan(
        self_: *mut ISteamGameServer,
        steamIDClan: uint64_steamid,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServer_ComputeNewPlayerCompatibility(
        self_: *mut ISteamGameServer,
        steamIDNewPlayer: uint64_steamid,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_SteamGameServerStats_v001() -> *mut ISteamGameServerStats;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServerStats_RequestUserStats(
        self_: *mut ISteamGameServerStats,
        steamIDUser: uint64_steamid,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServerStats_GetUserStatInt32(
        self_: *mut ISteamGameServerStats,
        steamIDUser: uint64_steamid,
        pchName: *const ::std::os::raw::c_char,
        pData: *mut int32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServerStats_GetUserStatFloat(
        self_: *mut ISteamGameServerStats,
        steamIDUser: uint64_steamid,
        pchName: *const ::std::os::raw::c_char,
        pData: *mut f32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServerStats_GetUserAchievement(
        self_: *mut ISteamGameServerStats,
        steamIDUser: uint64_steamid,
        pchName: *const ::std::os::raw::c_char,
        pbAchieved: *mut bool,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServerStats_SetUserStatInt32(
        self_: *mut ISteamGameServerStats,
        steamIDUser: uint64_steamid,
        pchName: *const ::std::os::raw::c_char,
        nData: int32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServerStats_SetUserStatFloat(
        self_: *mut ISteamGameServerStats,
        steamIDUser: uint64_steamid,
        pchName: *const ::std::os::raw::c_char,
        fData: f32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServerStats_UpdateUserAvgRateStat(
        self_: *mut ISteamGameServerStats,
        steamIDUser: uint64_steamid,
        pchName: *const ::std::os::raw::c_char,
        flCountThisSession: f32,
        dSessionLength: f64,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServerStats_SetUserAchievement(
        self_: *mut ISteamGameServerStats,
        steamIDUser: uint64_steamid,
        pchName: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServerStats_ClearUserAchievement(
        self_: *mut ISteamGameServerStats,
        steamIDUser: uint64_steamid,
        pchName: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_ISteamGameServerStats_StoreUserStats(
        self_: *mut ISteamGameServerStats,
        steamIDUser: uint64_steamid,
    ) -> SteamAPICall_t;
}
extern "C" {
    pub fn SteamAPI_SteamIPAddress_t_IsSet(self_: *mut SteamIPAddress_t) -> bool;
}
extern "C" {
    pub fn SteamAPI_MatchMakingKeyValuePair_t_Construct(self_: *mut MatchMakingKeyValuePair_t);
}
extern "C" {
    pub fn SteamAPI_servernetadr_t_Construct(self_: *mut servernetadr_t);
}
extern "C" {
    pub fn SteamAPI_servernetadr_t_Init(
        self_: *mut servernetadr_t,
        ip: ::std::os::raw::c_uint,
        usQueryPort: uint16,
        usConnectionPort: uint16,
    );
}
extern "C" {
    pub fn SteamAPI_servernetadr_t_GetQueryPort(self_: *mut servernetadr_t) -> uint16;
}
extern "C" {
    pub fn SteamAPI_servernetadr_t_SetQueryPort(self_: *mut servernetadr_t, usPort: uint16);
}
extern "C" {
    pub fn SteamAPI_servernetadr_t_GetConnectionPort(self_: *mut servernetadr_t) -> uint16;
}
extern "C" {
    pub fn SteamAPI_servernetadr_t_SetConnectionPort(self_: *mut servernetadr_t, usPort: uint16);
}
extern "C" {
    pub fn SteamAPI_servernetadr_t_GetIP(self_: *mut servernetadr_t) -> uint32;
}
extern "C" {
    pub fn SteamAPI_servernetadr_t_SetIP(self_: *mut servernetadr_t, unIP: uint32);
}
extern "C" {
    pub fn SteamAPI_servernetadr_t_GetConnectionAddressString(
        self_: *mut servernetadr_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_servernetadr_t_GetQueryAddressString(
        self_: *mut servernetadr_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_servernetadr_t_IsLessThan(
        self_: *mut servernetadr_t,
        netadr: *const servernetadr_t,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_servernetadr_t_Assign(self_: *mut servernetadr_t, that: *const servernetadr_t);
}
extern "C" {
    pub fn SteamAPI_gameserveritem_t_Construct(self_: *mut gameserveritem_t);
}
extern "C" {
    pub fn SteamAPI_gameserveritem_t_GetName(
        self_: *mut gameserveritem_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_gameserveritem_t_SetName(
        self_: *mut gameserveritem_t,
        pName: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIPAddr_Clear(self_: *mut SteamNetworkingIPAddr);
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIPAddr_IsIPv6AllZeros(self_: *mut SteamNetworkingIPAddr)
        -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIPAddr_SetIPv6(
        self_: *mut SteamNetworkingIPAddr,
        ipv6: *const uint8,
        nPort: uint16,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIPAddr_SetIPv4(
        self_: *mut SteamNetworkingIPAddr,
        nIP: uint32,
        nPort: uint16,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIPAddr_IsIPv4(self_: *mut SteamNetworkingIPAddr) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIPAddr_GetIPv4(self_: *mut SteamNetworkingIPAddr) -> uint32;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIPAddr_SetIPv6LocalHost(
        self_: *mut SteamNetworkingIPAddr,
        nPort: uint16,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIPAddr_IsLocalHost(self_: *mut SteamNetworkingIPAddr) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIPAddr_ToString(
        self_: *mut SteamNetworkingIPAddr,
        buf: *mut ::std::os::raw::c_char,
        cbBuf: uint32,
        bWithPort: bool,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIPAddr_ParseString(
        self_: *mut SteamNetworkingIPAddr,
        pszStr: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIPAddr_IsEqualTo(
        self_: *mut SteamNetworkingIPAddr,
        x: *const SteamNetworkingIPAddr,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_Clear(self_: *mut SteamNetworkingIdentity);
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_IsInvalid(self_: *mut SteamNetworkingIdentity) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_SetSteamID(
        self_: *mut SteamNetworkingIdentity,
        steamID: uint64_steamid,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_GetSteamID(
        self_: *mut SteamNetworkingIdentity,
    ) -> uint64_steamid;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_SetSteamID64(
        self_: *mut SteamNetworkingIdentity,
        steamID: uint64,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_GetSteamID64(
        self_: *mut SteamNetworkingIdentity,
    ) -> uint64;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_SetXboxPairwiseID(
        self_: *mut SteamNetworkingIdentity,
        pszString: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_GetXboxPairwiseID(
        self_: *mut SteamNetworkingIdentity,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_SetPSNID(
        self_: *mut SteamNetworkingIdentity,
        id: uint64,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_GetPSNID(self_: *mut SteamNetworkingIdentity)
        -> uint64;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_SetStadiaID(
        self_: *mut SteamNetworkingIdentity,
        id: uint64,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_GetStadiaID(
        self_: *mut SteamNetworkingIdentity,
    ) -> uint64;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_SetIPAddr(
        self_: *mut SteamNetworkingIdentity,
        addr: *const SteamNetworkingIPAddr,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_GetIPAddr(
        self_: *mut SteamNetworkingIdentity,
    ) -> *const SteamNetworkingIPAddr;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_SetLocalHost(self_: *mut SteamNetworkingIdentity);
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_IsLocalHost(
        self_: *mut SteamNetworkingIdentity,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_SetGenericString(
        self_: *mut SteamNetworkingIdentity,
        pszString: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_GetGenericString(
        self_: *mut SteamNetworkingIdentity,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_SetGenericBytes(
        self_: *mut SteamNetworkingIdentity,
        data: *const ::std::os::raw::c_void,
        cbLen: uint32,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_GetGenericBytes(
        self_: *mut SteamNetworkingIdentity,
        cbLen: *mut ::std::os::raw::c_int,
    ) -> *const uint8;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_IsEqualTo(
        self_: *mut SteamNetworkingIdentity,
        x: *const SteamNetworkingIdentity,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_ToString(
        self_: *mut SteamNetworkingIdentity,
        buf: *mut ::std::os::raw::c_char,
        cbBuf: uint32,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentity_ParseString(
        self_: *mut SteamNetworkingIdentity,
        pszStr: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingMessage_t_Release(self_: *mut SteamNetworkingMessage_t);
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingConfigValue_t_SetInt32(
        self_: *mut SteamNetworkingConfigValue_t,
        eVal: ESteamNetworkingConfigValue,
        data: i32,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingConfigValue_t_SetInt64(
        self_: *mut SteamNetworkingConfigValue_t,
        eVal: ESteamNetworkingConfigValue,
        data: i64,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingConfigValue_t_SetFloat(
        self_: *mut SteamNetworkingConfigValue_t,
        eVal: ESteamNetworkingConfigValue,
        data: f32,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingConfigValue_t_SetPtr(
        self_: *mut SteamNetworkingConfigValue_t,
        eVal: ESteamNetworkingConfigValue,
        data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingConfigValue_t_SetString(
        self_: *mut SteamNetworkingConfigValue_t,
        eVal: ESteamNetworkingConfigValue,
        data: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingPOPIDRender_c_str(
        self_: *mut SteamNetworkingPOPIDRender,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIdentityRender_c_str(
        self_: *mut SteamNetworkingIdentityRender,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_SteamNetworkingIPAddrRender_c_str(
        self_: *mut SteamNetworkingIPAddrRender,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn SteamAPI_SteamDatagramHostedAddress_Clear(self_: *mut SteamDatagramHostedAddress);
}
extern "C" {
    pub fn SteamAPI_SteamDatagramHostedAddress_GetPopID(
        self_: *mut SteamDatagramHostedAddress,
    ) -> SteamNetworkingPOPID;
}
extern "C" {
    pub fn SteamAPI_SteamDatagramHostedAddress_SetDevAddress(
        self_: *mut SteamDatagramHostedAddress,
        nIP: uint32,
        nPort: uint16,
        popid: SteamNetworkingPOPID,
    );
}
#[repr(i32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum EServerMode {
    eServerModeInvalid = 0,
    eServerModeNoAuthentication = 1,
    eServerModeAuthentication = 2,
    eServerModeAuthenticationAndSecure = 3,
}
extern "C" {
    pub fn SteamGameServer_Shutdown();
}
extern "C" {
    pub fn SteamGameServer_BSecure() -> bool;
}
extern "C" {
    pub fn SteamGameServer_GetSteamID() -> uint64;
}
extern "C" {
    pub fn SteamInternal_GameServer_Init(
        unIP: uint32,
        usLegacySteamPort: uint16,
        usGamePort: uint16,
        usQueryPort: uint16,
        eServerMode: EServerMode,
        pchVersionString: *const ::std::os::raw::c_char,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __crt_locale_data {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __crt_multibyte_data {
    pub _address: u8,
}
