A crate for interacting with the steam API

[![Build status](https://github.com/dindybutts/steam-api/actions/workflows/ci.yml/badge.svg)](https://github.com/dindybutts/steam-api/actions)
[![Crates.io](https://img.shields.io/crates/v/steam-api.svg)](https://crates.io/crates/steam-api)
[![Docs.rs](https://docs.rs/steam-api/badge.svg)](https://docs.rs/steam-api/)


```bash
# Running the example
API_KEY=XXXXXXXXXXXXXXXXXXX cargo run --example example_program

# Running the tests
API_KEY=XXXXXXXXXXXXXXXXXXX cargo test
```

## Example usage
```rust
let api_key = std::env::var("API_KEY")?;

let steamids = vec![
	"76561198421169032", // My profile
];

for i in &steam_api::get_profile_info(&steamids, &api_key)?.user {
    println!("Persona name: {}", i.personaname);
    println!("Player level: {}", i.player_level);
}
```

## API Key
Get your API Key [here](https://steamcommunity.com/dev/apikey)
