#[macro_export] macro_rules!
bx { ($var:expr) => (Box::new($var)); }

#[macro_export] macro_rules!
s { ($var:expr) => (String::from($var)); }

pub type Handle<T> = std::io::Result<T>;
pub type Maybe<T> = Option<T>;
pub type text = &'static str;

pub fn ERROR<T>(a: &'static str) -> Handle<T> {
    use std::io::*;
    Err(Error::new(ErrorKind::Other, a))
}

pub fn type_of<T>(_: &T) {
    println!("{}", std::any::type_name::<T>())
}
