#[macro_export] macro_rules!
hide {
    (- $a:expr; $($arg:tt)*) => ($($arg)*);
    ($($arg:tt)*) => ($($arg)*);
}

#[macro_export] macro_rules!
show {
    ($($arg:expr),*) => {
        $(print!("{:?} ", $arg);)*
        println!("");
    };
}

#[macro_export] macro_rules!
typer {
    ($($vi:vis $name:ident = $typ:ty),*) => {
        $($vi type $name = $typ;)*
    };
    ($($vi:vis $name:ident = $typ:ty),*; $($a:tt)*) => {
        $($vi type $name = $typ;)*
    };
}
