# Contributing guide

Thanks for considering contributing to the `stdext`! Here's a banana for you: 🍌

If you are missing some functionality in the Rust standard library, but don't want
to bother yourself with all the associated routines (writing RFC, defending it, implementing,
waiting for it to be stabilized...), feel free to create a pull request to this repo.

## Adding new functionality

The ideal pull request will satisfy the following criteria:

- Does not contain any hate (any form of discrimination, politics, offence, etc).
- Has an explanation why this functionality is useful for a generic audience.
- Covers the introduced code with tests and documentation.
- Does not rely on external dependencies (for any kind of complex functionality consider creating your
  own library, this crate is for minor improvements only).

All the rules (except for the first one) are discussible if you can provide a heavy reasoning for it.

## Requesting the functionality

If you don't want to implement the feature, but still feel that is missing in `std`, feel free to open
a feature request issue. I'll try to implement it myself once I have the time.

## Other contributions

Refactoring, improving documentation, adding tests and other kinds of improvements are really appreciated
as well.
