/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct UserRole {
  #[serde(rename = "role")]
  role: Option<String>,
  #[serde(rename = "roleStatus")]
  role_status: Option<String>,
  #[serde(rename = "userEmail")]
  user_email: Option<String>
}

impl UserRole {
  pub fn new() -> UserRole {
    UserRole {
      role: None,
      role_status: None,
      user_email: None
    }
  }

  pub fn set_role(&mut self, role: String) {
    self.role = Some(role);
  }

  pub fn with_role(mut self, role: String) -> UserRole {
    self.role = Some(role);
    self
  }

  pub fn role(&self) -> Option<&String> {
    self.role.as_ref()
  }

  pub fn reset_role(&mut self) {
    self.role = None;
  }

  pub fn set_role_status(&mut self, role_status: String) {
    self.role_status = Some(role_status);
  }

  pub fn with_role_status(mut self, role_status: String) -> UserRole {
    self.role_status = Some(role_status);
    self
  }

  pub fn role_status(&self) -> Option<&String> {
    self.role_status.as_ref()
  }

  pub fn reset_role_status(&mut self) {
    self.role_status = None;
  }

  pub fn set_user_email(&mut self, user_email: String) {
    self.user_email = Some(user_email);
  }

  pub fn with_user_email(mut self, user_email: String) -> UserRole {
    self.user_email = Some(user_email);
    self
  }

  pub fn user_email(&self) -> Option<&String> {
    self.user_email.as_ref()
  }

  pub fn reset_user_email(&mut self) {
    self.user_email = None;
  }

}



