/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct NotificationIntegration {
  #[serde(rename = "applicability")]
  applicability: Option<String>,
  #[serde(rename = "createDate")]
  create_date: Option<String>,
  #[serde(rename = "createdByOwner")]
  created_by_owner: Option<bool>,
  #[serde(rename = "creatorId")]
  creator_id: Option<i64>,
  #[serde(rename = "id")]
  id: Option<i64>,
  #[serde(rename = "integrationType")]
  integration_type: Option<String>,
  #[serde(rename = "name")]
  name: Option<String>,
  #[serde(rename = "params")]
  params: Option<::std::collections::HashMap<String, String>>,
  #[serde(rename = "state")]
  state: Option<String>,
  #[serde(rename = "userId")]
  user_id: Option<i64>
}

impl NotificationIntegration {
  pub fn new() -> NotificationIntegration {
    NotificationIntegration {
      applicability: None,
      create_date: None,
      created_by_owner: None,
      creator_id: None,
      id: None,
      integration_type: None,
      name: None,
      params: None,
      state: None,
      user_id: None
    }
  }

  pub fn set_applicability(&mut self, applicability: String) {
    self.applicability = Some(applicability);
  }

  pub fn with_applicability(mut self, applicability: String) -> NotificationIntegration {
    self.applicability = Some(applicability);
    self
  }

  pub fn applicability(&self) -> Option<&String> {
    self.applicability.as_ref()
  }

  pub fn reset_applicability(&mut self) {
    self.applicability = None;
  }

  pub fn set_create_date(&mut self, create_date: String) {
    self.create_date = Some(create_date);
  }

  pub fn with_create_date(mut self, create_date: String) -> NotificationIntegration {
    self.create_date = Some(create_date);
    self
  }

  pub fn create_date(&self) -> Option<&String> {
    self.create_date.as_ref()
  }

  pub fn reset_create_date(&mut self) {
    self.create_date = None;
  }

  pub fn set_created_by_owner(&mut self, created_by_owner: bool) {
    self.created_by_owner = Some(created_by_owner);
  }

  pub fn with_created_by_owner(mut self, created_by_owner: bool) -> NotificationIntegration {
    self.created_by_owner = Some(created_by_owner);
    self
  }

  pub fn created_by_owner(&self) -> Option<&bool> {
    self.created_by_owner.as_ref()
  }

  pub fn reset_created_by_owner(&mut self) {
    self.created_by_owner = None;
  }

  pub fn set_creator_id(&mut self, creator_id: i64) {
    self.creator_id = Some(creator_id);
  }

  pub fn with_creator_id(mut self, creator_id: i64) -> NotificationIntegration {
    self.creator_id = Some(creator_id);
    self
  }

  pub fn creator_id(&self) -> Option<&i64> {
    self.creator_id.as_ref()
  }

  pub fn reset_creator_id(&mut self) {
    self.creator_id = None;
  }

  pub fn set_id(&mut self, id: i64) {
    self.id = Some(id);
  }

  pub fn with_id(mut self, id: i64) -> NotificationIntegration {
    self.id = Some(id);
    self
  }

  pub fn id(&self) -> Option<&i64> {
    self.id.as_ref()
  }

  pub fn reset_id(&mut self) {
    self.id = None;
  }

  pub fn set_integration_type(&mut self, integration_type: String) {
    self.integration_type = Some(integration_type);
  }

  pub fn with_integration_type(mut self, integration_type: String) -> NotificationIntegration {
    self.integration_type = Some(integration_type);
    self
  }

  pub fn integration_type(&self) -> Option<&String> {
    self.integration_type.as_ref()
  }

  pub fn reset_integration_type(&mut self) {
    self.integration_type = None;
  }

  pub fn set_name(&mut self, name: String) {
    self.name = Some(name);
  }

  pub fn with_name(mut self, name: String) -> NotificationIntegration {
    self.name = Some(name);
    self
  }

  pub fn name(&self) -> Option<&String> {
    self.name.as_ref()
  }

  pub fn reset_name(&mut self) {
    self.name = None;
  }

  pub fn set_params(&mut self, params: ::std::collections::HashMap<String, String>) {
    self.params = Some(params);
  }

  pub fn with_params(mut self, params: ::std::collections::HashMap<String, String>) -> NotificationIntegration {
    self.params = Some(params);
    self
  }

  pub fn params(&self) -> Option<&::std::collections::HashMap<String, String>> {
    self.params.as_ref()
  }

  pub fn reset_params(&mut self) {
    self.params = None;
  }

  pub fn set_state(&mut self, state: String) {
    self.state = Some(state);
  }

  pub fn with_state(mut self, state: String) -> NotificationIntegration {
    self.state = Some(state);
    self
  }

  pub fn state(&self) -> Option<&String> {
    self.state.as_ref()
  }

  pub fn reset_state(&mut self) {
    self.state = None;
  }

  pub fn set_user_id(&mut self, user_id: i64) {
    self.user_id = Some(user_id);
  }

  pub fn with_user_id(mut self, user_id: i64) -> NotificationIntegration {
    self.user_id = Some(user_id);
    self
  }

  pub fn user_id(&self) -> Option<&i64> {
    self.user_id.as_ref()
  }

  pub fn reset_user_id(&mut self) {
    self.user_id = None;
  }

}



