/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct ChargesDetailsResponseDto {
  #[serde(rename = "app")]
  app: Option<::models::App>,
  #[serde(rename = "chargeBase")]
  charge_base: Option<String>,
  #[serde(rename = "dayUsageData")]
  day_usage_data: Option<Vec<::models::DayUsageData>>,
  #[serde(rename = "monthlyFeeAmount")]
  monthly_fee_amount: Option<f32>,
  #[serde(rename = "periodFeePeriods")]
  period_fee_periods: Option<Vec<::models::MinPeriodFeePeriod>>,
  #[serde(rename = "totalAmount")]
  total_amount: Option<f32>,
  #[serde(rename = "usageAmount")]
  usage_amount: Option<f32>
}

impl ChargesDetailsResponseDto {
  pub fn new() -> ChargesDetailsResponseDto {
    ChargesDetailsResponseDto {
      app: None,
      charge_base: None,
      day_usage_data: None,
      monthly_fee_amount: None,
      period_fee_periods: None,
      total_amount: None,
      usage_amount: None
    }
  }

  pub fn set_app(&mut self, app: ::models::App) {
    self.app = Some(app);
  }

  pub fn with_app(mut self, app: ::models::App) -> ChargesDetailsResponseDto {
    self.app = Some(app);
    self
  }

  pub fn app(&self) -> Option<&::models::App> {
    self.app.as_ref()
  }

  pub fn reset_app(&mut self) {
    self.app = None;
  }

  pub fn set_charge_base(&mut self, charge_base: String) {
    self.charge_base = Some(charge_base);
  }

  pub fn with_charge_base(mut self, charge_base: String) -> ChargesDetailsResponseDto {
    self.charge_base = Some(charge_base);
    self
  }

  pub fn charge_base(&self) -> Option<&String> {
    self.charge_base.as_ref()
  }

  pub fn reset_charge_base(&mut self) {
    self.charge_base = None;
  }

  pub fn set_day_usage_data(&mut self, day_usage_data: Vec<::models::DayUsageData>) {
    self.day_usage_data = Some(day_usage_data);
  }

  pub fn with_day_usage_data(mut self, day_usage_data: Vec<::models::DayUsageData>) -> ChargesDetailsResponseDto {
    self.day_usage_data = Some(day_usage_data);
    self
  }

  pub fn day_usage_data(&self) -> Option<&Vec<::models::DayUsageData>> {
    self.day_usage_data.as_ref()
  }

  pub fn reset_day_usage_data(&mut self) {
    self.day_usage_data = None;
  }

  pub fn set_monthly_fee_amount(&mut self, monthly_fee_amount: f32) {
    self.monthly_fee_amount = Some(monthly_fee_amount);
  }

  pub fn with_monthly_fee_amount(mut self, monthly_fee_amount: f32) -> ChargesDetailsResponseDto {
    self.monthly_fee_amount = Some(monthly_fee_amount);
    self
  }

  pub fn monthly_fee_amount(&self) -> Option<&f32> {
    self.monthly_fee_amount.as_ref()
  }

  pub fn reset_monthly_fee_amount(&mut self) {
    self.monthly_fee_amount = None;
  }

  pub fn set_period_fee_periods(&mut self, period_fee_periods: Vec<::models::MinPeriodFeePeriod>) {
    self.period_fee_periods = Some(period_fee_periods);
  }

  pub fn with_period_fee_periods(mut self, period_fee_periods: Vec<::models::MinPeriodFeePeriod>) -> ChargesDetailsResponseDto {
    self.period_fee_periods = Some(period_fee_periods);
    self
  }

  pub fn period_fee_periods(&self) -> Option<&Vec<::models::MinPeriodFeePeriod>> {
    self.period_fee_periods.as_ref()
  }

  pub fn reset_period_fee_periods(&mut self) {
    self.period_fee_periods = None;
  }

  pub fn set_total_amount(&mut self, total_amount: f32) {
    self.total_amount = Some(total_amount);
  }

  pub fn with_total_amount(mut self, total_amount: f32) -> ChargesDetailsResponseDto {
    self.total_amount = Some(total_amount);
    self
  }

  pub fn total_amount(&self) -> Option<&f32> {
    self.total_amount.as_ref()
  }

  pub fn reset_total_amount(&mut self) {
    self.total_amount = None;
  }

  pub fn set_usage_amount(&mut self, usage_amount: f32) {
    self.usage_amount = Some(usage_amount);
  }

  pub fn with_usage_amount(mut self, usage_amount: f32) -> ChargesDetailsResponseDto {
    self.usage_amount = Some(usage_amount);
    self
  }

  pub fn usage_amount(&self) -> Option<&f32> {
    self.usage_amount.as_ref()
  }

  pub fn reset_usage_amount(&mut self) {
    self.usage_amount = None;
  }

}



