/* 
 * Sematext Cloud API
 *
 * API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 */


#[allow(unused_imports)]
use serde_json::Value;

#[derive(Debug, Serialize, Deserialize)]
pub struct AlertNotification {
  #[serde(rename = "appName")]
  app_name: Option<String>,
  #[serde(rename = "appType")]
  app_type: Option<String>,
  #[serde(rename = "backToNormal")]
  back_to_normal: Option<bool>,
  #[serde(rename = "createTime")]
  create_time: Option<String>,
  #[serde(rename = "sent")]
  sent: Option<bool>,
  #[serde(rename = "text")]
  text: Option<String>,
  #[serde(rename = "when")]
  when: Option<String>
}

impl AlertNotification {
  pub fn new() -> AlertNotification {
    AlertNotification {
      app_name: None,
      app_type: None,
      back_to_normal: None,
      create_time: None,
      sent: None,
      text: None,
      when: None
    }
  }

  pub fn set_app_name(&mut self, app_name: String) {
    self.app_name = Some(app_name);
  }

  pub fn with_app_name(mut self, app_name: String) -> AlertNotification {
    self.app_name = Some(app_name);
    self
  }

  pub fn app_name(&self) -> Option<&String> {
    self.app_name.as_ref()
  }

  pub fn reset_app_name(&mut self) {
    self.app_name = None;
  }

  pub fn set_app_type(&mut self, app_type: String) {
    self.app_type = Some(app_type);
  }

  pub fn with_app_type(mut self, app_type: String) -> AlertNotification {
    self.app_type = Some(app_type);
    self
  }

  pub fn app_type(&self) -> Option<&String> {
    self.app_type.as_ref()
  }

  pub fn reset_app_type(&mut self) {
    self.app_type = None;
  }

  pub fn set_back_to_normal(&mut self, back_to_normal: bool) {
    self.back_to_normal = Some(back_to_normal);
  }

  pub fn with_back_to_normal(mut self, back_to_normal: bool) -> AlertNotification {
    self.back_to_normal = Some(back_to_normal);
    self
  }

  pub fn back_to_normal(&self) -> Option<&bool> {
    self.back_to_normal.as_ref()
  }

  pub fn reset_back_to_normal(&mut self) {
    self.back_to_normal = None;
  }

  pub fn set_create_time(&mut self, create_time: String) {
    self.create_time = Some(create_time);
  }

  pub fn with_create_time(mut self, create_time: String) -> AlertNotification {
    self.create_time = Some(create_time);
    self
  }

  pub fn create_time(&self) -> Option<&String> {
    self.create_time.as_ref()
  }

  pub fn reset_create_time(&mut self) {
    self.create_time = None;
  }

  pub fn set_sent(&mut self, sent: bool) {
    self.sent = Some(sent);
  }

  pub fn with_sent(mut self, sent: bool) -> AlertNotification {
    self.sent = Some(sent);
    self
  }

  pub fn sent(&self) -> Option<&bool> {
    self.sent.as_ref()
  }

  pub fn reset_sent(&mut self) {
    self.sent = None;
  }

  pub fn set_text(&mut self, text: String) {
    self.text = Some(text);
  }

  pub fn with_text(mut self, text: String) -> AlertNotification {
    self.text = Some(text);
    self
  }

  pub fn text(&self) -> Option<&String> {
    self.text.as_ref()
  }

  pub fn reset_text(&mut self) {
    self.text = None;
  }

  pub fn set_when(&mut self, when: String) {
    self.when = Some(when);
  }

  pub fn with_when(mut self, when: String) -> AlertNotification {
    self.when = Some(when);
    self
  }

  pub fn when(&self) -> Option<&String> {
    self.when.as_ref()
  }

  pub fn reset_when(&mut self) {
    self.when = None;
  }

}



