// Generated by Hebron at 1/1/2022 6:43:55 AM

use crate::*;
use c_runtime;
use std;

#[derive(Debug, Copy, Clone)]
pub struct stbi__zbuf {
    pub zbuffer: *mut u8,
    pub zbuffer_end: *mut u8,
    pub num_bits: i32,
    pub code_buffer: u32,
    pub zout: *mut i8,
    pub zout_start: *mut i8,
    pub zout_end: *mut i8,
    pub z_expandable: i32,
    pub z_length: stbi__zhuffman,
    pub z_distance: stbi__zhuffman,
}

#[derive(Debug, Copy, Clone)]
pub struct stbi__zhuffman {
    pub fast: [u16; 512],
    pub firstcode: [u16; 16],
    pub maxcode: [i32; 17],
    pub firstsymbol: [u16; 16],
    pub size: [u8; 288],
    pub value: [u16; 288],
}

impl std::default::Default for stbi__zbuf {
    fn default() -> Self {
        stbi__zbuf {
            zbuffer: std::ptr::null_mut(),
            zbuffer_end: std::ptr::null_mut(),
            num_bits: 0,
            code_buffer: 0,
            zout: std::ptr::null_mut(),
            zout_start: std::ptr::null_mut(),
            zout_end: std::ptr::null_mut(),
            z_expandable: 0,
            z_length: stbi__zhuffman::default(),
            z_distance: stbi__zhuffman::default(),
        }
    }
}

impl std::default::Default for stbi__zhuffman {
    fn default() -> Self {
        stbi__zhuffman {
            fast: [0; 512],
            firstcode: [0; 16],
            maxcode: [0; 17],
            firstsymbol: [0; 16],
            size: [0; 288],
            value: [0; 288],
        }
    }
}

pub unsafe fn stbi__compute_huffman_codes(mut a: *mut stbi__zbuf) -> i32 {
    let mut z_codelength: stbi__zhuffman = stbi__zhuffman::default();
    let mut lencodes: [u8; 455] = [0; 455];
    let mut codelength_sizes: [u8; 19] = [0; 19];
    let mut i: i32 = 0;
    let mut n: i32 = 0;
    let mut hlit: i32 = ((stbi__zreceive(a, 5) + ((257) as u32)) as i32);
    let mut hdist: i32 = ((stbi__zreceive(a, 5) + ((1) as u32)) as i32);
    let mut hclen: i32 = ((stbi__zreceive(a, 4) + ((4) as u32)) as i32);
    let mut ntot: i32 = hlit + hdist;
    c_runtime::memset(
        ((codelength_sizes.as_mut_ptr()) as *mut u8),
        0,
        19 * std::mem::size_of::<u8>() as u64,
    );
    i = ((0) as i32);
    while (i < hclen) {
        let mut s: i32 = ((stbi__zreceive(a, 3)) as i32);
        codelength_sizes[(stbi__compute_huffman_codes_length_dezigzag[(i) as usize]) as usize] =
            ((s) as u8);
        c_runtime::preInc(&mut i);
    }
    if stbi__zbuild_huffman(
        ((&mut z_codelength) as *mut stbi__zhuffman),
        ((codelength_sizes.as_mut_ptr()) as *mut u8),
        19,
    ) == 0
    {
        return ((0) as i32);
    }
    n = ((0) as i32);
    while (n < ntot) {
        let mut c: i32 = stbi__zhuffman_decode(a, ((&mut z_codelength) as *mut stbi__zhuffman));
        if c < 0 || c >= 19 {
            return ((stbi__err("bad codelengths")) as i32);
        }
        if c < 16 {
            lencodes[(c_runtime::postInc(&mut n)) as usize] = ((c) as u8);
        } else {
            let mut fill: u8 = ((0) as u8);
            if c == 16 {
                c = ((stbi__zreceive(a, 2) + ((3) as u32)) as i32);
                if n == 0 {
                    return ((stbi__err("bad codelengths")) as i32);
                }
                fill = ((lencodes[(n - 1) as usize]) as u8);
            } else {
                if c == 17 {
                    c = ((stbi__zreceive(a, 3) + ((3) as u32)) as i32);
                } else {
                    if c == 18 {
                        c = ((stbi__zreceive(a, 7) + ((11) as u32)) as i32);
                    } else {
                        return ((stbi__err("bad codelengths")) as i32);
                    }
                }
            }
            if ntot - n < c {
                return ((stbi__err("bad codelengths")) as i32);
            }
            c_runtime::memset(
                (lencodes.as_mut_ptr()).offset((n) as isize),
                ((fill) as i32),
                ((c) as u64),
            );
            n += ((c) as i32);
        }
    }
    if n != ntot {
        return ((stbi__err("bad codelengths")) as i32);
    }
    if stbi__zbuild_huffman(
        ((&mut (*a).z_length) as *mut stbi__zhuffman),
        ((lencodes.as_mut_ptr()) as *mut u8),
        hlit,
    ) == 0
    {
        return ((0) as i32);
    }
    if stbi__zbuild_huffman(
        ((&mut (*a).z_distance) as *mut stbi__zhuffman),
        (lencodes.as_mut_ptr()).offset((hlit) as isize),
        hdist,
    ) == 0
    {
        return ((0) as i32);
    }
    return ((1) as i32);
}

pub unsafe fn stbi__do_zlib(
    mut a: *mut stbi__zbuf,
    mut obuf: *mut i8,
    mut olen: i32,
    mut exp: i32,
    mut parse_header: i32,
) -> i32 {
    (*a).zout_start = obuf;
    (*a).zout = obuf;
    (*a).zout_end = (obuf).offset((olen) as isize);
    (*a).z_expandable = ((exp) as i32);
    return ((stbi__parse_zlib(a, parse_header)) as i32);
}

pub unsafe fn stbi__fill_bits(mut z: *mut stbi__zbuf) {
    while (true) {
        if (*z).code_buffer >= (1 << (*z).num_bits) {
            (*z).zbuffer = (*z).zbuffer_end;
            return;
        }
        (*z).code_buffer |= (((stbi__zget8(z)) as u32) << (*z).num_bits);
        (*z).num_bits += ((8) as i32);
        if !((*z).num_bits <= 24) {
            break;
        }
    }
}

pub unsafe fn stbi__parse_huffman_block(mut a: *mut stbi__zbuf) -> i32 {
    let mut zout: *mut i8 = (*a).zout;
    while (true) {
        let mut z: i32 = stbi__zhuffman_decode(a, ((&mut (*a).z_length) as *mut stbi__zhuffman));
        if z < 256 {
            if z < 0 {
                return ((stbi__err("bad huffman code")) as i32);
            }
            if zout >= (*a).zout_end {
                if stbi__zexpand(a, zout, 1) == 0 {
                    return ((0) as i32);
                }
                zout = (*a).zout;
            }
            *c_runtime::postIncPtr(&mut zout) = ((z) as i8);
        } else {
            let mut p: *mut u8 = std::ptr::null_mut();
            let mut len: i32 = 0;
            let mut dist: i32 = 0;
            if z == 256 {
                (*a).zout = zout;
                return ((1) as i32);
            }
            z -= ((257) as i32);
            len = ((stbi__zlength_base[(z) as usize]) as i32);
            if (stbi__zlength_extra[(z) as usize]) != 0 {
                len += ((stbi__zreceive(a, stbi__zlength_extra[(z) as usize])) as i32);
            }
            z = ((stbi__zhuffman_decode(a, ((&mut (*a).z_distance) as *mut stbi__zhuffman)))
                as i32);
            if z < 0 {
                return ((stbi__err("bad huffman code")) as i32);
            }
            dist = ((stbi__zdist_base[(z) as usize]) as i32);
            if (stbi__zdist_extra[(z) as usize]) != 0 {
                dist += ((stbi__zreceive(a, stbi__zdist_extra[(z) as usize])) as i32);
            }
            if ((zout) as usize) - (((*a).zout_start) as usize) < dist as usize {
                return stbi__err("bad dist");
            }
            if (zout).offset((len) as isize) > (*a).zout_end {
                if stbi__zexpand(a, zout, len) == 0 {
                    return ((0) as i32);
                }
                zout = (*a).zout;
            }
            p = (((zout).offset(-((dist) as isize))) as *mut u8);
            if dist == 1 {
                let mut v: u8 = *p;
                if (len) != 0 {
                    while (true) {
                        *c_runtime::postIncPtr(&mut zout) = ((v) as i8);
                        if !((c_runtime::preDec(&mut len)) != 0) {
                            break;
                        }
                    }
                }
            } else {
                if (len) != 0 {
                    while (true) {
                        *c_runtime::postIncPtr(&mut zout) =
                            ((*c_runtime::postIncPtr(&mut p)) as i8);
                        if !((c_runtime::preDec(&mut len)) != 0) {
                            break;
                        }
                    }
                }
            }
        }
    }

    return 0;
}

pub unsafe fn stbi__parse_uncompressed_block(mut a: *mut stbi__zbuf) -> i32 {
    let mut header: [u8; 4] = [0; 4];
    let mut len: i32 = 0;
    let mut nlen: i32 = 0;
    let mut k: i32 = 0;
    if ((*a).num_bits & 7) != 0 {
        stbi__zreceive(a, (*a).num_bits & 7);
    }
    k = ((0) as i32);
    while ((*a).num_bits > 0) {
        header[(c_runtime::postInc(&mut k)) as usize] = (((*a).code_buffer & ((255) as u32)) as u8);
        (*a).code_buffer >>= 8;
        (*a).num_bits -= ((8) as i32);
    }
    if (*a).num_bits < 0 {
        return ((stbi__err("zlib corrupt")) as i32);
    }
    while (k < 4) {
        header[(c_runtime::postInc(&mut k)) as usize] = ((stbi__zget8(a)) as u8);
    }
    len = (((header[(1) as usize]) as i32) * 256 + ((header[(0) as usize]) as i32));
    nlen = (((header[(3) as usize]) as i32) * 256 + ((header[(2) as usize]) as i32));
    if nlen != (len ^ 0xffff) {
        return ((stbi__err("zlib corrupt")) as i32);
    }
    if ((*a).zbuffer).offset((len) as isize) > (*a).zbuffer_end {
        return ((stbi__err("read past buffer")) as i32);
    }
    if ((*a).zout).offset((len) as isize) > (*a).zout_end {
        if stbi__zexpand(a, (*a).zout, len) == 0 {
            return ((0) as i32);
        }
    }
    c_runtime::memcpy((((*a).zout) as *mut u8), (*a).zbuffer, ((len) as u64));
    (*a).zbuffer = (*a).zbuffer.offset((len) as isize);
    (*a).zout = (*a).zout.offset((len) as isize);
    return ((1) as i32);
}

pub unsafe fn stbi__parse_zlib(mut a: *mut stbi__zbuf, mut parse_header: i32) -> i32 {
    let mut _final_: i32 = 0;
    let mut _type_: i32 = 0;
    if (parse_header) != 0 {
        if stbi__parse_zlib_header(a) == 0 {
            return ((0) as i32);
        }
    }
    (*a).num_bits = ((0) as i32);
    (*a).code_buffer = ((0) as u32);
    while (true) {
        _final_ = ((stbi__zreceive(a, 1)) as i32);
        _type_ = ((stbi__zreceive(a, 2)) as i32);
        if _type_ == 0 {
            if stbi__parse_uncompressed_block(a) == 0 {
                return ((0) as i32);
            }
        } else {
            if _type_ == 3 {
                return ((0) as i32);
            } else {
                if _type_ == 1 {
                    if stbi__zbuild_huffman(
                        ((&mut (*a).z_length) as *mut stbi__zhuffman),
                        ((stbi__zdefault_length.as_mut_ptr()) as *mut u8),
                        288,
                    ) == 0
                    {
                        return ((0) as i32);
                    }
                    if stbi__zbuild_huffman(
                        ((&mut (*a).z_distance) as *mut stbi__zhuffman),
                        ((stbi__zdefault_distance.as_mut_ptr()) as *mut u8),
                        32,
                    ) == 0
                    {
                        return ((0) as i32);
                    }
                } else {
                    if stbi__compute_huffman_codes(a) == 0 {
                        return ((0) as i32);
                    }
                }
                if stbi__parse_huffman_block(a) == 0 {
                    return ((0) as i32);
                }
            }
        }
        if !(_final_ == 0) {
            break;
        }
    }

    return ((1) as i32);
}

pub unsafe fn stbi__parse_zlib_header(mut a: *mut stbi__zbuf) -> i32 {
    let mut cmf: i32 = ((stbi__zget8(a)) as i32);
    let mut cm: i32 = cmf & 15;
    let mut flg: i32 = ((stbi__zget8(a)) as i32);
    if (stbi__zeof(a)) != 0 {
        return ((stbi__err("bad zlib header")) as i32);
    }
    if (cmf * 256 + flg) % 31 != 0 {
        return ((stbi__err("bad zlib header")) as i32);
    }
    if (flg & 32) != 0 {
        return ((stbi__err("no preset dict")) as i32);
    }
    if cm != 8 {
        return ((stbi__err("bad compression")) as i32);
    }
    return ((1) as i32);
}

pub unsafe fn stbi__zbuild_huffman(
    mut z: *mut stbi__zhuffman,
    mut sizelist: *mut u8,
    mut num: i32,
) -> i32 {
    let mut i: i32 = 0;
    let mut k: i32 = 0;
    let mut code: i32 = 0;
    let mut next_code: [i32; 16] = [0; 16];
    let mut sizes: [i32; 17] = [0; 17];
    c_runtime::memset(
        ((sizes.as_mut_ptr()) as *mut u8),
        0,
        17 * std::mem::size_of::<i32>() as u64,
    );
    c_runtime::memset(
        (((*z).fast.as_mut_ptr()) as *mut u8),
        0,
        512 * std::mem::size_of::<u16>() as u64,
    );
    i = ((0) as i32);
    while (i < num) {
        c_runtime::preInc(&mut sizes[(*sizelist.offset((i) as isize)) as usize]);
        c_runtime::preInc(&mut i);
    }
    sizes[(0) as usize] = ((0) as i32);
    i = ((1) as i32);
    while (i < 16) {
        if sizes[(i) as usize] > (1 << i) {
            return ((stbi__err("bad sizes")) as i32);
        }
        c_runtime::preInc(&mut i);
    }
    code = ((0) as i32);
    i = ((1) as i32);
    while (i < 16) {
        next_code[(i) as usize] = ((code) as i32);
        (*z).firstcode[(i) as usize] = ((code) as u16);
        (*z).firstsymbol[(i) as usize] = ((k) as u16);
        code = ((code + sizes[(i) as usize]) as i32);
        if (sizes[(i) as usize]) != 0 {
            if code - 1 >= (1 << i) {
                return ((stbi__err("bad codelengths")) as i32);
            }
        }
        (*z).maxcode[(i) as usize] = ((code << (16 - i)) as i32);
        code <<= 1;
        k += ((sizes[(i) as usize]) as i32);
        c_runtime::preInc(&mut i);
    }
    (*z).maxcode[(16) as usize] = ((0x10000) as i32);
    i = ((0) as i32);
    while (i < num) {
        let mut s: i32 = ((*sizelist.offset((i) as isize)) as i32);
        if (s) != 0 {
            let mut c: i32 = next_code[(s) as usize] - (((*z).firstcode[(s) as usize]) as i32)
                + (((*z).firstsymbol[(s) as usize]) as i32);
            let mut fastv: u16 = (((s << 9) | i) as u16);
            (*z).size[(c) as usize] = ((s) as u8);
            (*z).value[(c) as usize] = ((i) as u16);
            if s <= 9 {
                let mut j: i32 = stbi__bit_reverse(next_code[(s) as usize], s);
                while (j < (1 << 9)) {
                    (*z).fast[(j) as usize] = ((fastv) as u16);
                    j += ((1 << s) as i32);
                }
            }
            c_runtime::preInc(&mut next_code[(s) as usize]);
        }
        c_runtime::preInc(&mut i);
    }
    return ((1) as i32);
}

pub unsafe fn stbi__zeof(mut z: *mut stbi__zbuf) -> i32 {
    return ((if ((*z).zbuffer >= (*z).zbuffer_end) {
        1
    } else {
        0
    }) as i32);
}

pub unsafe fn stbi__zexpand(mut z: *mut stbi__zbuf, mut zout: *mut i8, mut n: i32) -> i32 {
    let mut q: *mut i8 = std::ptr::null_mut();
    let mut cur: u32 = 0;
    let mut limit: u32 = 0;
    let mut old_limit: u32 = 0;
    (*z).zout = zout;
    if (*z).z_expandable == 0 {
        return ((stbi__err("output buffer limit")) as i32);
    }
    cur = ((((*z).zout).offset(-(((*z).zout_start) as isize))) as u32);
    let hebron_tmp0 = ((((*z).zout_end).offset(-(((*z).zout_start) as isize))) as u32);
    limit = hebron_tmp0;
    old_limit = hebron_tmp0;
    if 0xffffffff - cur < ((n) as u32) {
        return ((stbi__err("outofmem")) as i32);
    }
    while (cur + ((n) as u32) > limit) {
        if limit > 0xffffffff / ((2) as u32) {
            return ((stbi__err("outofmem")) as i32);
        }
        limit *= ((2) as u32);
    }
    q = ((c_runtime::realloc((((*z).zout_start) as *mut u8), ((limit) as u64))) as *mut i8);

    if q == std::ptr::null_mut() {
        return ((stbi__err("outofmem")) as i32);
    }
    (*z).zout_start = q;
    (*z).zout = (q).offset((cur) as isize);
    (*z).zout_end = (q).offset((limit) as isize);
    return ((1) as i32);
}

pub unsafe fn stbi__zget8(mut z: *mut stbi__zbuf) -> u8 {
    return ((if (stbi__zeof(z)) != 0 {
        0
    } else {
        ((*c_runtime::postIncPtr(&mut (*z).zbuffer)) as i32)
    }) as u8);
}

pub unsafe fn stbi__zhuffman_decode(mut a: *mut stbi__zbuf, mut z: *mut stbi__zhuffman) -> i32 {
    let mut b: i32 = 0;
    let mut s: i32 = 0;
    if (*a).num_bits < 16 {
        if (stbi__zeof(a)) != 0 {
            return ((-1) as i32);
        }
        stbi__fill_bits(a);
    }
    b = (((*z).fast[((*a).code_buffer & (((1 << 9) - 1) as u32)) as usize]) as i32);
    if (b) != 0 {
        s = ((b >> 9) as i32);
        (*a).code_buffer >>= s;
        (*a).num_bits -= ((s) as i32);
        return ((b & 511) as i32);
    }
    return ((stbi__zhuffman_decode_slowpath(a, z)) as i32);
}

pub unsafe fn stbi__zhuffman_decode_slowpath(
    mut a: *mut stbi__zbuf,
    mut z: *mut stbi__zhuffman,
) -> i32 {
    let mut b: i32 = 0;
    let mut s: i32 = 0;
    let mut k: i32 = 0;
    k = (stbi__bit_reverse((((*a).code_buffer) as i32), 16));
    s = ((9 + 1) as i32);
    while (true) {
        if k < (*z).maxcode[(s) as usize] {
            break;
        }
        c_runtime::preInc(&mut s);
    }
    if s >= 16 {
        return ((-1) as i32);
    }
    b = ((k >> (16 - s)) - (((*z).firstcode[(s) as usize]) as i32)
        + (((*z).firstsymbol[(s) as usize]) as i32));
    if b >= 288 {
        return ((-1) as i32);
    }
    if (((*z).size[(b) as usize]) as i32) != s {
        return ((-1) as i32);
    }
    (*a).code_buffer >>= s;
    (*a).num_bits -= ((s) as i32);
    return (((*z).value[(b) as usize]) as i32);
}

pub unsafe fn stbi__zreceive(mut z: *mut stbi__zbuf, mut n: i32) -> u32 {
    let mut k: u32 = 0;
    if (*z).num_bits < n {
        stbi__fill_bits(z);
    }
    k = ((*z).code_buffer & (((1 << n) - 1) as u32));
    (*z).code_buffer >>= n;
    (*z).num_bits -= ((n) as i32);
    return ((k) as u32);
}

pub unsafe fn stbi_zlib_decode_buffer(
    mut obuffer: *mut i8,
    mut olen: i32,
    mut ibuffer: *mut i8,
    mut ilen: i32,
) -> i32 {
    let mut a: stbi__zbuf = stbi__zbuf::default();
    a.zbuffer = ((ibuffer) as *mut u8);
    a.zbuffer_end = ((ibuffer) as *mut u8).offset((ilen) as isize);
    if (stbi__do_zlib(((&mut a) as *mut stbi__zbuf), obuffer, olen, 0, 1)) != 0 {
        return (((a.zout).offset(-((a.zout_start) as isize))) as i32);
    } else {
        return ((-1) as i32);
    }
}

pub unsafe fn stbi_zlib_decode_malloc(
    mut buffer: *mut i8,
    mut len: i32,
    mut outlen: *mut i32,
) -> *mut i8 {
    return stbi_zlib_decode_malloc_guesssize(buffer, len, 16384, outlen);
}

pub unsafe fn stbi_zlib_decode_malloc_guesssize(
    mut buffer: *mut i8,
    mut len: i32,
    mut initial_size: i32,
    mut outlen: *mut i32,
) -> *mut i8 {
    let mut a: stbi__zbuf = stbi__zbuf::default();
    let mut p: *mut i8 = ((stbi__malloc(((initial_size) as u64))) as *mut i8);
    if p == std::ptr::null_mut() {
        return std::ptr::null_mut();
    }
    a.zbuffer = ((buffer) as *mut u8);
    a.zbuffer_end = ((buffer) as *mut u8).offset((len) as isize);
    if (stbi__do_zlib(((&mut a) as *mut stbi__zbuf), p, initial_size, 1, 1)) != 0 {
        if (outlen) != std::ptr::null_mut() {
            *outlen = (((a.zout).offset(-((a.zout_start) as isize))) as i32);
        }
        return a.zout_start;
    } else {
        c_runtime::free(((a.zout_start) as *mut u8));
        return std::ptr::null_mut();
    }
}

pub unsafe fn stbi_zlib_decode_malloc_guesssize_headerflag(
    mut buffer: *mut i8,
    mut len: i32,
    mut initial_size: i32,
    mut outlen: *mut i32,
    mut parse_header: i32,
) -> *mut i8 {
    let mut a: stbi__zbuf = stbi__zbuf::default();
    let mut p: *mut i8 = ((stbi__malloc(((initial_size) as u64))) as *mut i8);
    if p == std::ptr::null_mut() {
        return std::ptr::null_mut();
    }
    a.zbuffer = ((buffer) as *mut u8);
    a.zbuffer_end = ((buffer) as *mut u8).offset((len) as isize);
    if (stbi__do_zlib(
        ((&mut a) as *mut stbi__zbuf),
        p,
        initial_size,
        1,
        parse_header,
    )) != 0
    {
        if (outlen) != std::ptr::null_mut() {
            *outlen = (((a.zout).offset(-((a.zout_start) as isize))) as i32);
        }
        return a.zout_start;
    } else {
        c_runtime::free(((a.zout_start) as *mut u8));
        return std::ptr::null_mut();
    }
}

pub unsafe fn stbi_zlib_decode_noheader_buffer(
    mut obuffer: *mut i8,
    mut olen: i32,
    mut ibuffer: *mut i8,
    mut ilen: i32,
) -> i32 {
    let mut a: stbi__zbuf = stbi__zbuf::default();
    a.zbuffer = ((ibuffer) as *mut u8);
    a.zbuffer_end = ((ibuffer) as *mut u8).offset((ilen) as isize);
    if (stbi__do_zlib(((&mut a) as *mut stbi__zbuf), obuffer, olen, 0, 0)) != 0 {
        return (((a.zout).offset(-((a.zout_start) as isize))) as i32);
    } else {
        return ((-1) as i32);
    }
}

pub unsafe fn stbi_zlib_decode_noheader_malloc(
    mut buffer: *mut i8,
    mut len: i32,
    mut outlen: *mut i32,
) -> *mut i8 {
    let mut a: stbi__zbuf = stbi__zbuf::default();
    let mut p: *mut i8 = ((stbi__malloc(((16384) as u64))) as *mut i8);
    if p == std::ptr::null_mut() {
        return std::ptr::null_mut();
    }
    a.zbuffer = ((buffer) as *mut u8);
    a.zbuffer_end = ((buffer) as *mut u8).offset((len) as isize);
    if (stbi__do_zlib(((&mut a) as *mut stbi__zbuf), p, 16384, 1, 0)) != 0 {
        if (outlen) != std::ptr::null_mut() {
            *outlen = (((a.zout).offset(-((a.zout_start) as isize))) as i32);
        }
        return a.zout_start;
    } else {
        c_runtime::free(((a.zout_start) as *mut u8));
        return std::ptr::null_mut();
    }
}
