// Generated by Hebron at 1/1/2022 6:43:55 AM

use crate::*;
use c_runtime;
use std;

#[derive(Debug, Copy, Clone)]
pub struct stbi__bmp_data {
    pub bpp: i32,
    pub offset: i32,
    pub hsz: i32,
    pub mr: u32,
    pub mg: u32,
    pub mb: u32,
    pub ma: u32,
    pub all_a: u32,
    pub extra_read: i32,
}

impl std::default::Default for stbi__bmp_data {
    fn default() -> Self {
        stbi__bmp_data {
            bpp: 0,
            offset: 0,
            hsz: 0,
            mr: 0,
            mg: 0,
            mb: 0,
            ma: 0,
            all_a: 0,
            extra_read: 0,
        }
    }
}

pub unsafe fn stbi__bmp_info(
    mut s: *mut stbi__context,
    mut x: *mut i32,
    mut y: *mut i32,
    mut comp: *mut i32,
) -> i32 {
    let mut p: *mut u8 = std::ptr::null_mut();
    let mut info: stbi__bmp_data = stbi__bmp_data::default();
    info.all_a = ((255) as u32);
    p = stbi__bmp_parse_header(s, ((&mut info) as *mut stbi__bmp_data));
    if p == std::ptr::null_mut() {
        stbi__rewind(s);
        return ((0) as i32);
    }
    if (x) != std::ptr::null_mut() {
        *x = (((*s).img_x) as i32);
    }
    if (y) != std::ptr::null_mut() {
        *y = (((*s).img_y) as i32);
    }
    if (comp) != std::ptr::null_mut() {
        if info.bpp == 24 && info.ma == 0xff000000 {
            *comp = ((3) as i32);
        } else {
            *comp = ((if (info.ma) != 0 { 4 } else { 3 }) as i32);
        }
    }
    return ((1) as i32);
}

pub unsafe fn stbi__bmp_load(
    mut s: *mut stbi__context,
    mut x: *mut i32,
    mut y: *mut i32,
    mut comp: *mut i32,
    mut req_comp: i32,
    mut ri: *mut stbi__result_info,
) -> *mut u8 {
    let mut out: *mut u8 = std::ptr::null_mut();
    let mut mr: u32 = ((0) as u32);
    let mut mg: u32 = ((0) as u32);
    let mut mb: u32 = ((0) as u32);
    let mut ma: u32 = ((0) as u32);
    let mut all_a: u32 = 0;
    let mut pal: [[u8; 256]; 4] = [[0; 256]; 4];
    let mut psize: i32 = 0;
    let mut i: i32 = 0;
    let mut j: i32 = 0;
    let mut width: i32 = 0;
    let mut flip_vertically: i32 = 0;
    let mut pad: i32 = 0;
    let mut target: i32 = 0;
    let mut info: stbi__bmp_data = stbi__bmp_data::default();

    info.all_a = ((255) as u32);
    if stbi__bmp_parse_header(s, ((&mut info) as *mut stbi__bmp_data)) == std::ptr::null_mut() {
        return std::ptr::null_mut();
    }
    flip_vertically = if (((*s).img_y) as i32) > 0 { 1 } else { 0 };
    (*s).img_y = ((c_runtime::abs((((*s).img_y) as i32))) as u32);
    if (*s).img_y > ((1 << 24) as u32) {
        return (((if (stbi__err("too large")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    if (*s).img_x > ((1 << 24) as u32) {
        return (((if (stbi__err("too large")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    mr = ((info.mr) as u32);
    mg = ((info.mg) as u32);
    mb = ((info.mb) as u32);
    ma = ((info.ma) as u32);
    all_a = ((info.all_a) as u32);
    if info.hsz == 12 {
        if info.bpp < 24 {
            psize = (((info.offset - info.extra_read - 24) / 3) as i32);
        }
    } else {
        if info.bpp < 16 {
            psize = (((info.offset - info.extra_read - info.hsz) >> 2) as i32);
        }
    }
    if info.bpp == 24 && ma == 0xff000000 {
        (*s).img_n = ((3) as i32);
    } else {
        (*s).img_n = ((if (ma) != 0 { 4 } else { 3 }) as i32);
    }
    if (req_comp) != 0 && req_comp >= 3 {
        target = ((req_comp) as i32);
    } else {
        target = (((*s).img_n) as i32);
    }
    if stbi__mad3sizes_valid(target, (((*s).img_x) as i32), (((*s).img_y) as i32), 0) == 0 {
        return (((if (stbi__err("too large")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    out = stbi__malloc_mad3(target, (((*s).img_x) as i32), (((*s).img_y) as i32), 0);
    if out == std::ptr::null_mut() {
        return (((if (stbi__err("outofmem")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    if info.bpp < 16 {
        let mut z: i32 = 0;
        if psize == 0 || psize > 256 {
            c_runtime::free(out);
            return (((if (stbi__err("invalid")) != 0 {
                (0)
            } else {
                (0)
            }) as u64) as *mut u8);
        }
        i = ((0) as i32);
        while (i < psize) {
            pal[(i) as usize][(2) as usize] = ((stbi__get8(s)) as u8);
            pal[(i) as usize][(1) as usize] = ((stbi__get8(s)) as u8);
            pal[(i) as usize][(0) as usize] = ((stbi__get8(s)) as u8);
            if info.hsz != 12 {
                stbi__get8(s);
            }
            pal[(i) as usize][(3) as usize] = ((255) as u8);
            c_runtime::preInc(&mut i);
        }
        stbi__skip(
            s,
            info.offset - info.extra_read - info.hsz - psize * (if info.hsz == 12 { 3 } else { 4 }),
        );
        if info.bpp == 1 {
            width = ((((*s).img_x + ((7) as u32)) >> 3) as i32);
        } else {
            if info.bpp == 4 {
                width = ((((*s).img_x + ((1) as u32)) >> 1) as i32);
            } else {
                if info.bpp == 8 {
                    width = (((*s).img_x) as i32);
                } else {
                    c_runtime::free(out);
                    return (((if (stbi__err("bad bpp")) != 0 {
                        (0)
                    } else {
                        (0)
                    }) as u64) as *mut u8);
                }
            }
        }
        pad = (((-width) & 3) as i32);
        if info.bpp == 1 {
            j = ((0) as i32);
            while (j < (((*s).img_y) as i32)) {
                let mut bit_offset: i32 = 7;
                let mut v: i32 = ((stbi__get8(s)) as i32);
                i = ((0) as i32);
                while (i < (((*s).img_x) as i32)) {
                    let mut color: i32 = (v >> bit_offset) & 0x1;
                    *out.offset((c_runtime::postInc(&mut z)) as isize) =
                        ((pal[(color) as usize][(0) as usize]) as u8);
                    *out.offset((c_runtime::postInc(&mut z)) as isize) =
                        ((pal[(color) as usize][(1) as usize]) as u8);
                    *out.offset((c_runtime::postInc(&mut z)) as isize) =
                        ((pal[(color) as usize][(2) as usize]) as u8);
                    if target == 4 {
                        *out.offset((c_runtime::postInc(&mut z)) as isize) = ((255) as u8);
                    }
                    if i + 1 == (((*s).img_x) as i32) {
                        break;
                    }
                    if (c_runtime::preDec(&mut bit_offset)) < 0 {
                        bit_offset = ((7) as i32);
                        v = ((stbi__get8(s)) as i32);
                    }
                    c_runtime::preInc(&mut i);
                }
                stbi__skip(s, pad);
                c_runtime::preInc(&mut j);
            }
        } else {
            j = ((0) as i32);
            while (j < (((*s).img_y) as i32)) {
                i = ((0) as i32);
                while (i < (((*s).img_x) as i32)) {
                    let mut v: i32 = ((stbi__get8(s)) as i32);
                    let mut v2: i32 = 0;
                    if info.bpp == 4 {
                        v2 = ((v & 15) as i32);
                        v >>= 4;
                    }
                    *out.offset((c_runtime::postInc(&mut z)) as isize) =
                        ((pal[(v) as usize][(0) as usize]) as u8);
                    *out.offset((c_runtime::postInc(&mut z)) as isize) =
                        ((pal[(v) as usize][(1) as usize]) as u8);
                    *out.offset((c_runtime::postInc(&mut z)) as isize) =
                        ((pal[(v) as usize][(2) as usize]) as u8);
                    if target == 4 {
                        *out.offset((c_runtime::postInc(&mut z)) as isize) = ((255) as u8);
                    }
                    if i + 1 == (((*s).img_x) as i32) {
                        break;
                    }
                    v = (if (info.bpp == 8) {
                        ((stbi__get8(s)) as i32)
                    } else {
                        v2
                    });
                    *out.offset((c_runtime::postInc(&mut z)) as isize) =
                        ((pal[(v) as usize][(0) as usize]) as u8);
                    *out.offset((c_runtime::postInc(&mut z)) as isize) =
                        ((pal[(v) as usize][(1) as usize]) as u8);
                    *out.offset((c_runtime::postInc(&mut z)) as isize) =
                        ((pal[(v) as usize][(2) as usize]) as u8);
                    if target == 4 {
                        *out.offset((c_runtime::postInc(&mut z)) as isize) = ((255) as u8);
                    }
                    i += ((2) as i32);
                }
                stbi__skip(s, pad);
                c_runtime::preInc(&mut j);
            }
        }
    } else {
        let mut rshift: i32 = 0;
        let mut gshift: i32 = 0;
        let mut bshift: i32 = 0;
        let mut ashift: i32 = 0;
        let mut rcount: i32 = 0;
        let mut gcount: i32 = 0;
        let mut bcount: i32 = 0;
        let mut acount: i32 = 0;
        let mut z: i32 = 0;
        let mut easy: i32 = 0;
        stbi__skip(s, info.offset - info.extra_read - info.hsz);
        if info.bpp == 24 {
            width = ((((3) as u32) * (*s).img_x) as i32);
        } else {
            if info.bpp == 16 {
                width = ((((2) as u32) * (*s).img_x) as i32);
            } else {
                width = ((0) as i32);
            }
        }
        pad = (((-width) & 3) as i32);
        if info.bpp == 24 {
            easy = ((1) as i32);
        } else {
            if info.bpp == 32 {
                if mb == ((0xff) as u32)
                    && mg == ((0xff00) as u32)
                    && mr == ((0x00ff0000) as u32)
                    && ma == 0xff000000
                {
                    easy = ((2) as i32);
                }
            }
        }
        if easy == 0 {
            if mr == 0 || mg == 0 || mb == 0 {
                c_runtime::free(out);
                return (((if (stbi__err("bad masks")) != 0 {
                    (0)
                } else {
                    (0)
                }) as u64) as *mut u8);
            }
            rshift = ((stbi__high_bit(mr) - 7) as i32);
            rcount = ((stbi__bitcount(mr)) as i32);
            gshift = ((stbi__high_bit(mg) - 7) as i32);
            gcount = ((stbi__bitcount(mg)) as i32);
            bshift = ((stbi__high_bit(mb) - 7) as i32);
            bcount = ((stbi__bitcount(mb)) as i32);
            ashift = ((stbi__high_bit(ma) - 7) as i32);
            acount = ((stbi__bitcount(ma)) as i32);
            if rcount > 8 || gcount > 8 || bcount > 8 || acount > 8 {
                c_runtime::free(out);
                return (((if (stbi__err("bad masks")) != 0 {
                    (0)
                } else {
                    (0)
                }) as u64) as *mut u8);
            }
        }
        j = ((0) as i32);
        while (j < (((*s).img_y) as i32)) {
            if (easy) != 0 {
                i = ((0) as i32);
                while (i < (((*s).img_x) as i32)) {
                    let mut a: u8 = 0;
                    *out.offset((z + 2) as isize) = ((stbi__get8(s)) as u8);
                    *out.offset((z + 1) as isize) = ((stbi__get8(s)) as u8);
                    *out.offset((z + 0) as isize) = ((stbi__get8(s)) as u8);
                    z += ((3) as i32);
                    a = ((if easy == 2 {
                        ((stbi__get8(s)) as i32)
                    } else {
                        255
                    }) as u8);
                    all_a |= ((a) as u32);
                    if target == 4 {
                        *out.offset((c_runtime::postInc(&mut z)) as isize) = ((a) as u8);
                    }
                    c_runtime::preInc(&mut i);
                }
            } else {
                let mut bpp: i32 = info.bpp;
                i = ((0) as i32);
                while (i < (((*s).img_x) as i32)) {
                    let mut v: u32 = (if bpp == 16 {
                        ((stbi__get16le(s)) as u32)
                    } else {
                        stbi__get32le(s)
                    });
                    let mut a: u32 = 0;
                    *out.offset((c_runtime::postInc(&mut z)) as isize) =
                        (((stbi__shiftsigned(v & mr, rshift, rcount)) & 255) as u8);
                    *out.offset((c_runtime::postInc(&mut z)) as isize) =
                        (((stbi__shiftsigned(v & mg, gshift, gcount)) & 255) as u8);
                    *out.offset((c_runtime::postInc(&mut z)) as isize) =
                        (((stbi__shiftsigned(v & mb, bshift, bcount)) & 255) as u8);
                    a = ((if (ma) != 0 {
                        stbi__shiftsigned(v & ma, ashift, acount)
                    } else {
                        255
                    }) as u32);
                    all_a |= ((a) as u32);
                    if target == 4 {
                        *out.offset((c_runtime::postInc(&mut z)) as isize) =
                            (((a) & ((255) as u32)) as u8);
                    }
                    c_runtime::preInc(&mut i);
                }
            }
            stbi__skip(s, pad);
            c_runtime::preInc(&mut j);
        }
    }
    if target == 4 && all_a == ((0) as u32) {
        i = ((((4) as u32) * (*s).img_x * (*s).img_y - ((1) as u32)) as i32);
        while (i >= 0) {
            *out.offset((i) as isize) = ((255) as u8);
            i -= ((4) as i32);
        }
    }
    if (flip_vertically) != 0 {
        let mut t: u8 = 0;
        j = ((0) as i32);
        while (j < (((*s).img_y) as i32) >> 1) {
            let mut p1: *mut u8 =
                (out).offset((((j) as u32) * (*s).img_x * ((target) as u32)) as isize);
            let mut p2: *mut u8 = (out).offset(
                (((*s).img_y - ((1) as u32) - ((j) as u32)) * (*s).img_x * ((target) as u32))
                    as isize,
            );
            i = ((0) as i32);
            while (i < (((*s).img_x) as i32) * target) {
                t = ((*p1.offset((i) as isize)) as u8);
                *p1.offset((i) as isize) = ((*p2.offset((i) as isize)) as u8);
                *p2.offset((i) as isize) = ((t) as u8);
                c_runtime::preInc(&mut i);
            }
            c_runtime::preInc(&mut j);
        }
    }
    if (req_comp) != 0 && req_comp != target {
        out = stbi__convert_format(out, target, req_comp, (*s).img_x, (*s).img_y);
        if out == std::ptr::null_mut() {
            return out;
        }
    }
    *x = (((*s).img_x) as i32);
    *y = (((*s).img_y) as i32);
    if (comp) != std::ptr::null_mut() {
        *comp = (((*s).img_n) as i32);
    }
    return out;
}

pub unsafe fn stbi__bmp_parse_header(
    mut s: *mut stbi__context,
    mut info: *mut stbi__bmp_data,
) -> *mut u8 {
    let mut hsz: i32 = 0;
    if ((stbi__get8(s)) as i32) != 66 || ((stbi__get8(s)) as i32) != 77 {
        return (((if (stbi__err("not BMP")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    stbi__get32le(s);
    stbi__get16le(s);
    stbi__get16le(s);
    (*info).offset = ((stbi__get32le(s)) as i32);
    let hebron_tmp0 = ((stbi__get32le(s)) as i32);
    (*info).hsz = hebron_tmp0;
    hsz = hebron_tmp0;
    let hebron_tmp4 = ((0) as u32);
    (*info).mr = hebron_tmp4;
    (*info).mg = hebron_tmp4;
    (*info).mb = hebron_tmp4;
    (*info).ma = hebron_tmp4;
    (*info).extra_read = ((14) as i32);
    if (*info).offset < 0 {
        return (((if (stbi__err("bad BMP")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    if hsz != 12 && hsz != 40 && hsz != 56 && hsz != 108 && hsz != 124 {
        return (((if (stbi__err("unknown BMP")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    if hsz == 12 {
        (*s).img_x = ((stbi__get16le(s)) as u32);
        (*s).img_y = ((stbi__get16le(s)) as u32);
    } else {
        (*s).img_x = ((stbi__get32le(s)) as u32);
        (*s).img_y = ((stbi__get32le(s)) as u32);
    }
    if stbi__get16le(s) != 1 {
        return (((if (stbi__err("bad BMP")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    (*info).bpp = ((stbi__get16le(s)) as i32);
    if hsz != 12 {
        let mut compress: i32 = ((stbi__get32le(s)) as i32);
        if compress == 1 || compress == 2 {
            return (((if (stbi__err("BMP RLE")) != 0 {
                (0)
            } else {
                (0)
            }) as u64) as *mut u8);
        }
        if compress >= 4 {
            return (((if (stbi__err("BMP JPEG/PNG")) != 0 {
                (0)
            } else {
                (0)
            }) as u64) as *mut u8);
        }
        if compress == 3 && (*info).bpp != 16 && (*info).bpp != 32 {
            return (((if (stbi__err("bad BMP")) != 0 {
                (0)
            } else {
                (0)
            }) as u64) as *mut u8);
        }
        stbi__get32le(s);
        stbi__get32le(s);
        stbi__get32le(s);
        stbi__get32le(s);
        stbi__get32le(s);
        if hsz == 40 || hsz == 56 {
            if hsz == 56 {
                stbi__get32le(s);
                stbi__get32le(s);
                stbi__get32le(s);
                stbi__get32le(s);
            }
            if (*info).bpp == 16 || (*info).bpp == 32 {
                if compress == 0 {
                    stbi__bmp_set_mask_defaults(info, compress);
                } else {
                    if compress == 3 {
                        (*info).mr = ((stbi__get32le(s)) as u32);
                        (*info).mg = ((stbi__get32le(s)) as u32);
                        (*info).mb = ((stbi__get32le(s)) as u32);
                        (*info).extra_read += ((12) as i32);
                        if (*info).mr == (*info).mg && (*info).mg == (*info).mb {
                            return (((if (stbi__err("bad BMP")) != 0 {
                                (0)
                            } else {
                                (0)
                            }) as u64) as *mut u8);
                        }
                    } else {
                        return (((if (stbi__err("bad BMP")) != 0 {
                            (0)
                        } else {
                            (0)
                        }) as u64) as *mut u8);
                    }
                }
            }
        } else {
            let mut i: i32 = 0;
            if hsz != 108 && hsz != 124 {
                return (((if (stbi__err("bad BMP")) != 0 {
                    (0)
                } else {
                    (0)
                }) as u64) as *mut u8);
            }
            (*info).mr = ((stbi__get32le(s)) as u32);
            (*info).mg = ((stbi__get32le(s)) as u32);
            (*info).mb = ((stbi__get32le(s)) as u32);
            (*info).ma = ((stbi__get32le(s)) as u32);
            if compress != 3 {
                stbi__bmp_set_mask_defaults(info, compress);
            }
            stbi__get32le(s);
            i = ((0) as i32);
            while (i < 12) {
                stbi__get32le(s);
                c_runtime::preInc(&mut i);
            }
            if hsz == 124 {
                stbi__get32le(s);
                stbi__get32le(s);
                stbi__get32le(s);
                stbi__get32le(s);
            }
        }
    }
    return ((1) as *mut u8);
}

pub unsafe fn stbi__bmp_set_mask_defaults(mut info: *mut stbi__bmp_data, mut compress: i32) -> i32 {
    if compress == 3 {
        return ((1) as i32);
    }
    if compress == 0 {
        if (*info).bpp == 16 {
            (*info).mr = ((31 << 10) as u32);
            (*info).mg = ((31 << 5) as u32);
            (*info).mb = ((31 << 0) as u32);
        } else {
            if (*info).bpp == 32 {
                (*info).mr = ((0xff << 16) as u32);
                (*info).mg = ((0xff << 8) as u32);
                (*info).mb = ((0xff << 0) as u32);
                (*info).ma = ((0xff << 24) as u32);
                (*info).all_a = ((0) as u32);
            } else {
                let hebron_tmp3 = ((0) as u32);
                (*info).mr = hebron_tmp3;
                (*info).mg = hebron_tmp3;
                (*info).mb = hebron_tmp3;
                (*info).ma = hebron_tmp3;
            }
        }
        return ((1) as i32);
    }
    return ((0) as i32);
}

pub unsafe fn stbi__bmp_test(mut s: *mut stbi__context) -> i32 {
    let mut r: i32 = stbi__bmp_test_raw(s);
    stbi__rewind(s);
    return ((r) as i32);
}

pub unsafe fn stbi__bmp_test_raw(mut s: *mut stbi__context) -> i32 {
    let mut r: i32 = 0;
    let mut sz: i32 = 0;
    if ((stbi__get8(s)) as i32) != 66 {
        return ((0) as i32);
    }
    if ((stbi__get8(s)) as i32) != 77 {
        return ((0) as i32);
    }
    stbi__get32le(s);
    stbi__get16le(s);
    stbi__get16le(s);
    stbi__get32le(s);
    sz = ((stbi__get32le(s)) as i32);
    r = ((if sz == 12 || sz == 40 || sz == 56 || sz == 108 || sz == 124 {
        1
    } else {
        0
    }) as i32);
    return ((r) as i32);
}
