// Generated by Hebron at 1/1/2022 6:43:55 AM

use crate::*;
use c_runtime;
use std;

pub unsafe fn stbi__tga_get_comp(
    mut bits_per_pixel: i32,
    mut is_grey: i32,
    mut is_rgb16: *mut i32,
) -> i32 {
    if (is_rgb16) != std::ptr::null_mut() {
        *is_rgb16 = ((0) as i32);
    }
    {
        if bits_per_pixel == 8 {
            return ((STBI_grey) as i32);
        } else if bits_per_pixel == 16 || bits_per_pixel == 15 {
            if bits_per_pixel == 16 && is_grey != 0 {
                return ((STBI_grey_alpha) as i32);
            }
            if (is_rgb16) != std::ptr::null_mut() {
                *is_rgb16 = ((1) as i32);
            }
            return ((STBI_rgb) as i32);
        } else if bits_per_pixel == 24 || bits_per_pixel == 32 {
            return ((bits_per_pixel / 8) as i32);
        } else {
            return ((0) as i32);
        }
    }

    return 0;
}

pub unsafe fn stbi__tga_info(
    mut s: *mut stbi__context,
    mut x: *mut i32,
    mut y: *mut i32,
    mut comp: *mut i32,
) -> i32 {
    let mut tga_w: i32 = 0;
    let mut tga_h: i32 = 0;
    let mut tga_comp: i32 = 0;
    let mut tga_image_type: i32 = 0;
    let mut tga_bits_per_pixel: i32 = 0;
    let mut tga_colormap_bpp: i32 = 0;
    let mut sz: i32 = 0;
    let mut tga_colormap_type: i32 = 0;
    stbi__get8(s);
    tga_colormap_type = ((stbi__get8(s)) as i32);
    if tga_colormap_type > 1 {
        stbi__rewind(s);
        return ((0) as i32);
    }
    tga_image_type = ((stbi__get8(s)) as i32);
    if tga_colormap_type == 1 {
        if tga_image_type != 1 && tga_image_type != 9 {
            stbi__rewind(s);
            return ((0) as i32);
        }
        stbi__skip(s, 4);
        sz = ((stbi__get8(s)) as i32);
        if (sz != 8) && (sz != 15) && (sz != 16) && (sz != 24) && (sz != 32) {
            stbi__rewind(s);
            return ((0) as i32);
        }
        stbi__skip(s, 4);
        tga_colormap_bpp = ((sz) as i32);
    } else {
        if (tga_image_type != 2)
            && (tga_image_type != 3)
            && (tga_image_type != 10)
            && (tga_image_type != 11)
        {
            stbi__rewind(s);
            return ((0) as i32);
        }
        stbi__skip(s, 9);
        tga_colormap_bpp = ((0) as i32);
    }
    tga_w = ((stbi__get16le(s)) as i32);
    if tga_w < 1 {
        stbi__rewind(s);
        return ((0) as i32);
    }
    tga_h = ((stbi__get16le(s)) as i32);
    if tga_h < 1 {
        stbi__rewind(s);
        return ((0) as i32);
    }
    tga_bits_per_pixel = ((stbi__get8(s)) as i32);
    stbi__get8(s);
    if tga_colormap_bpp != 0 {
        if (tga_bits_per_pixel != 8) && (tga_bits_per_pixel != 16) {
            stbi__rewind(s);
            return ((0) as i32);
        }
        tga_comp = ((stbi__tga_get_comp(tga_colormap_bpp, 0, ((std::ptr::null_mut()) as *mut i32)))
            as i32);
    } else {
        tga_comp = ((stbi__tga_get_comp(
            tga_bits_per_pixel,
            if (tga_image_type == 3) || (tga_image_type == 11) {
                1
            } else {
                0
            },
            ((std::ptr::null_mut()) as *mut i32),
        )) as i32);
    }
    if tga_comp == 0 {
        stbi__rewind(s);
        return ((0) as i32);
    }
    if (x) != std::ptr::null_mut() {
        *x = ((tga_w) as i32);
    }
    if (y) != std::ptr::null_mut() {
        *y = ((tga_h) as i32);
    }
    if (comp) != std::ptr::null_mut() {
        *comp = ((tga_comp) as i32);
    }
    return ((1) as i32);
}

pub unsafe fn stbi__tga_load(
    mut s: *mut stbi__context,
    mut x: *mut i32,
    mut y: *mut i32,
    mut comp: *mut i32,
    mut req_comp: i32,
    mut ri: *mut stbi__result_info,
) -> *mut u8 {
    let mut tga_offset: i32 = ((stbi__get8(s)) as i32);
    let mut tga_indexed: i32 = ((stbi__get8(s)) as i32);
    let mut tga_image_type: i32 = ((stbi__get8(s)) as i32);
    let mut tga_is_RLE: i32 = 0;
    let mut tga_palette_start: i32 = stbi__get16le(s);
    let mut tga_palette_len: i32 = stbi__get16le(s);
    let mut tga_palette_bits: i32 = ((stbi__get8(s)) as i32);
    let mut tga_x_origin: i32 = stbi__get16le(s);
    let mut tga_y_origin: i32 = stbi__get16le(s);
    let mut tga_width: i32 = stbi__get16le(s);
    let mut tga_height: i32 = stbi__get16le(s);
    let mut tga_bits_per_pixel: i32 = ((stbi__get8(s)) as i32);
    let mut tga_comp: i32 = 0;
    let mut tga_rgb16: i32 = 0;
    let mut tga_inverted: i32 = ((stbi__get8(s)) as i32);
    let mut tga_data: *mut u8 = std::ptr::null_mut();
    let mut tga_palette: *mut u8 = std::ptr::null_mut();
    let mut i: i32 = 0;
    let mut j: i32 = 0;
    let mut raw_data: [u8; 4] = [0; 4];
    let mut RLE_count: i32 = 0;
    let mut RLE_repeating: i32 = 0;
    let mut read_next_pixel: i32 = 1;

    if tga_height > (1 << 24) {
        return (((if (stbi__err("too large")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    if tga_width > (1 << 24) {
        return (((if (stbi__err("too large")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    if tga_image_type >= 8 {
        tga_image_type -= ((8) as i32);
        tga_is_RLE = ((1) as i32);
    }
    tga_inverted = ((1 - ((tga_inverted >> 5) & 1)) as i32);
    if (tga_indexed) != 0 {
        tga_comp =
            ((stbi__tga_get_comp(tga_palette_bits, 0, ((&mut tga_rgb16) as *mut i32))) as i32);
    } else {
        tga_comp = ((stbi__tga_get_comp(
            tga_bits_per_pixel,
            if (tga_image_type == 3) { 1 } else { 0 },
            ((&mut tga_rgb16) as *mut i32),
        )) as i32);
    }
    if tga_comp == 0 {
        return (((if (stbi__err("bad format")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    *x = ((tga_width) as i32);
    *y = ((tga_height) as i32);
    if (comp) != std::ptr::null_mut() {
        *comp = ((tga_comp) as i32);
    }
    if stbi__mad3sizes_valid(tga_width, tga_height, tga_comp, 0) == 0 {
        return (((if (stbi__err("too large")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    tga_data = stbi__malloc_mad3(tga_width, tga_height, tga_comp, 0);
    if tga_data == std::ptr::null_mut() {
        return (((if (stbi__err("outofmem")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    stbi__skip(s, tga_offset);
    if tga_indexed == 0 && tga_is_RLE == 0 && tga_rgb16 == 0 {
        i = ((0) as i32);
        while (i < tga_height) {
            let mut row: i32 = if (tga_inverted) != 0 {
                tga_height - i - 1
            } else {
                i
            };
            let mut tga_row: *mut u8 = (tga_data).offset((row * tga_width * tga_comp) as isize);
            stbi__getn(s, tga_row, tga_width * tga_comp);
            c_runtime::preInc(&mut i);
        }
    } else {
        if (tga_indexed) != 0 {
            if tga_palette_len == 0 {
                c_runtime::free(tga_data);
                return (((if (stbi__err("bad palette")) != 0 {
                    (0)
                } else {
                    (0)
                }) as u64) as *mut u8);
            }
            stbi__skip(s, tga_palette_start);
            tga_palette = stbi__malloc_mad2(tga_palette_len, tga_comp, 0);
            if tga_palette == std::ptr::null_mut() {
                c_runtime::free(tga_data);
                return (((if (stbi__err("outofmem")) != 0 {
                    (0)
                } else {
                    (0)
                }) as u64) as *mut u8);
            }
            if (tga_rgb16) != 0 {
                let mut pal_entry: *mut u8 = tga_palette;
                i = ((0) as i32);
                while (i < tga_palette_len) {
                    stbi__tga_read_rgb16(s, pal_entry);
                    pal_entry = pal_entry.offset((tga_comp) as isize);
                    c_runtime::preInc(&mut i);
                }
            } else {
                if stbi__getn(s, tga_palette, tga_palette_len * tga_comp) == 0 {
                    c_runtime::free(tga_data);
                    c_runtime::free(tga_palette);
                    return (((if (stbi__err("bad palette")) != 0 {
                        (0)
                    } else {
                        (0)
                    }) as u64) as *mut u8);
                }
            }
        }
        i = ((0) as i32);
        while (i < tga_width * tga_height) {
            if (tga_is_RLE) != 0 {
                if RLE_count == 0 {
                    let mut RLE_cmd: i32 = ((stbi__get8(s)) as i32);
                    RLE_count = ((1 + (RLE_cmd & 127)) as i32);
                    RLE_repeating = ((RLE_cmd >> 7) as i32);
                    read_next_pixel = ((1) as i32);
                } else {
                    if RLE_repeating == 0 {
                        read_next_pixel = ((1) as i32);
                    }
                }
            } else {
                read_next_pixel = ((1) as i32);
            }
            if (read_next_pixel) != 0 {
                if (tga_indexed) != 0 {
                    let mut pal_idx: i32 = if (tga_bits_per_pixel == 8) {
                        ((stbi__get8(s)) as i32)
                    } else {
                        stbi__get16le(s)
                    };
                    if pal_idx >= tga_palette_len {
                        pal_idx = ((0) as i32);
                    }
                    pal_idx *= ((tga_comp) as i32);
                    j = ((0) as i32);
                    while (j < tga_comp) {
                        raw_data[(j) as usize] =
                            ((*tga_palette.offset((pal_idx + j) as isize)) as u8);
                        c_runtime::preInc(&mut j);
                    }
                } else {
                    if (tga_rgb16) != 0 {
                        stbi__tga_read_rgb16(s, ((raw_data.as_mut_ptr()) as *mut u8));
                    } else {
                        j = ((0) as i32);
                        while (j < tga_comp) {
                            raw_data[(j) as usize] = ((stbi__get8(s)) as u8);
                            c_runtime::preInc(&mut j);
                        }
                    }
                }
                read_next_pixel = ((0) as i32);
            }
            j = ((0) as i32);
            while (j < tga_comp) {
                *tga_data.offset((i * tga_comp + j) as isize) = ((raw_data[(j) as usize]) as u8);
                c_runtime::preInc(&mut j);
            }
            c_runtime::preDec(&mut RLE_count);
            c_runtime::preInc(&mut i);
        }
        if (tga_inverted) != 0 {
            j = ((0) as i32);
            while (j * 2 < tga_height) {
                let mut index1: i32 = j * tga_width * tga_comp;
                let mut index2: i32 = (tga_height - 1 - j) * tga_width * tga_comp;
                i = ((tga_width * tga_comp) as i32);
                while (i > 0) {
                    let mut temp: u8 = *tga_data.offset((index1) as isize);
                    *tga_data.offset((index1) as isize) =
                        ((*tga_data.offset((index2) as isize)) as u8);
                    *tga_data.offset((index2) as isize) = ((temp) as u8);
                    c_runtime::preInc(&mut index1);
                    c_runtime::preInc(&mut index2);
                    c_runtime::preDec(&mut i);
                }
                c_runtime::preInc(&mut j);
            }
        }
        if tga_palette != std::ptr::null_mut() {
            c_runtime::free(tga_palette);
        }
    }
    if tga_comp >= 3 && tga_rgb16 == 0 {
        let mut tga_pixel: *mut u8 = tga_data;
        i = ((0) as i32);
        while (i < tga_width * tga_height) {
            let mut temp: u8 = *tga_pixel.offset((0) as isize);
            *tga_pixel.offset((0) as isize) = ((*tga_pixel.offset((2) as isize)) as u8);
            *tga_pixel.offset((2) as isize) = ((temp) as u8);
            tga_pixel = tga_pixel.offset((tga_comp) as isize);
            c_runtime::preInc(&mut i);
        }
    }
    if (req_comp) != 0 && req_comp != tga_comp {
        tga_data = stbi__convert_format(
            tga_data,
            tga_comp,
            req_comp,
            ((tga_width) as u32),
            ((tga_height) as u32),
        );
    }
    let hebron_tmp7 = 0;
    tga_palette_start = hebron_tmp7;
    tga_palette_len = hebron_tmp7;
    tga_palette_bits = hebron_tmp7;
    tga_x_origin = hebron_tmp7;
    tga_y_origin = hebron_tmp7;

    return tga_data;
}

pub unsafe fn stbi__tga_read_rgb16(mut s: *mut stbi__context, mut out: *mut u8) {
    let mut px: u16 = ((stbi__get16le(s)) as u16);
    let mut fiveBitMask: u16 = ((31) as u16);
    let mut r: i32 = (((px) as i32) >> 10) & ((fiveBitMask) as i32);
    let mut g: i32 = (((px) as i32) >> 5) & ((fiveBitMask) as i32);
    let mut b: i32 = ((px) as i32) & ((fiveBitMask) as i32);
    *out.offset((0) as isize) = (((r * 255) / 31) as u8);
    *out.offset((1) as isize) = (((g * 255) / 31) as u8);
    *out.offset((2) as isize) = (((b * 255) / 31) as u8);
}

pub unsafe fn stbi__tga_test(mut s: *mut stbi__context) -> i32 {
    let mut res: i32 = 0;
    let mut sz: i32 = 0;
    let mut tga_color_type: i32 = 0;
    stbi__get8(s);
    tga_color_type = ((stbi__get8(s)) as i32);

    loop {
        if tga_color_type > 1 {
            break;
        }
        sz = ((stbi__get8(s)) as i32);
        if tga_color_type == 1 {
            if sz != 1 && sz != 9 {
                break;
            }
            stbi__skip(s, 4);
            sz = ((stbi__get8(s)) as i32);
            if (sz != 8) && (sz != 15) && (sz != 16) && (sz != 24) && (sz != 32) {
                break;
            }
            stbi__skip(s, 4);
        } else {
            if (sz != 2) && (sz != 3) && (sz != 10) && (sz != 11) {
                break;
            }
            stbi__skip(s, 9);
        }
        if stbi__get16le(s) < 1 {
            break;
        }
        if stbi__get16le(s) < 1 {
            break;
        }
        sz = ((stbi__get8(s)) as i32);
        if (tga_color_type == 1) && (sz != 8) && (sz != 16) {
            break;
        }
        if (sz != 8) && (sz != 15) && (sz != 16) && (sz != 24) && (sz != 32) {
            break;
        }
        res = ((1) as i32);
        break;
    }

    stbi__rewind(s);
    return ((res) as i32);
}
