// Generated by Hebron at 1/1/2022 6:43:55 AM

use crate::*;
use c_runtime;
use std;

pub unsafe fn stbi__psd_decode_rle(
    mut s: *mut stbi__context,
    mut p: *mut u8,
    mut pixelCount: i32,
) -> i32 {
    let mut count: i32 = 0;
    let mut nleft: i32 = 0;
    let mut len: i32 = 0;
    count = ((0) as i32);

    nleft = (pixelCount - count) as i32;
    while (nleft > 0) {
        len = ((stbi__get8(s)) as i32);
        if len == 128 {
        } else {
            if len < 128 {
                c_runtime::postInc(&mut len);
                if len > nleft {
                    return ((0) as i32);
                }
                count += ((len) as i32);
                while ((len) != 0) {
                    *p = ((stbi__get8(s)) as u8);
                    p = p.offset((4) as isize);
                    c_runtime::postDec(&mut len);
                }
            } else {
                if len > 128 {
                    let mut val: u8 = 0;
                    len = ((257 - len) as i32);
                    if len > nleft {
                        return ((0) as i32);
                    }
                    val = ((stbi__get8(s)) as u8);
                    count += ((len) as i32);
                    while ((len) != 0) {
                        *p = ((val) as u8);
                        p = p.offset((4) as isize);
                        c_runtime::postDec(&mut len);
                    }
                }
            }
        }

        nleft = (pixelCount - count) as i32;
    }
    return ((1) as i32);
}

pub unsafe fn stbi__psd_info(
    mut s: *mut stbi__context,
    mut x: *mut i32,
    mut y: *mut i32,
    mut comp: *mut i32,
) -> i32 {
    let mut channelCount: i32 = 0;
    let mut dummy: i32 = 0;
    let mut depth: i32 = 0;
    if x == std::ptr::null_mut() {
        x = &mut dummy;
    }
    if y == std::ptr::null_mut() {
        y = &mut dummy;
    }
    if comp == std::ptr::null_mut() {
        comp = &mut dummy;
    }
    if stbi__get32be(s) != ((0x38425053) as u32) {
        stbi__rewind(s);
        return ((0) as i32);
    }
    if stbi__get16be(s) != 1 {
        stbi__rewind(s);
        return ((0) as i32);
    }
    stbi__skip(s, 6);
    channelCount = ((stbi__get16be(s)) as i32);
    if channelCount < 0 || channelCount > 16 {
        stbi__rewind(s);
        return ((0) as i32);
    }
    *y = ((stbi__get32be(s)) as i32);
    *x = ((stbi__get32be(s)) as i32);
    depth = ((stbi__get16be(s)) as i32);
    if depth != 8 && depth != 16 {
        stbi__rewind(s);
        return ((0) as i32);
    }
    if stbi__get16be(s) != 3 {
        stbi__rewind(s);
        return ((0) as i32);
    }
    *comp = ((4) as i32);
    return ((1) as i32);
}

pub unsafe fn stbi__psd_is16(mut s: *mut stbi__context) -> i32 {
    let mut channelCount: i32 = 0;
    let mut depth: i32 = 0;
    if stbi__get32be(s) != ((0x38425053) as u32) {
        stbi__rewind(s);
        return ((0) as i32);
    }
    if stbi__get16be(s) != 1 {
        stbi__rewind(s);
        return ((0) as i32);
    }
    stbi__skip(s, 6);
    channelCount = ((stbi__get16be(s)) as i32);
    if channelCount < 0 || channelCount > 16 {
        stbi__rewind(s);
        return ((0) as i32);
    }

    depth = ((stbi__get16be(s)) as i32);
    if depth != 16 {
        stbi__rewind(s);
        return ((0) as i32);
    }
    return ((1) as i32);
}

pub unsafe fn stbi__psd_load(
    mut s: *mut stbi__context,
    mut x: *mut i32,
    mut y: *mut i32,
    mut comp: *mut i32,
    mut req_comp: i32,
    mut ri: *mut stbi__result_info,
    mut bpc: i32,
) -> *mut u8 {
    let mut pixelCount: i32 = 0;
    let mut channelCount: i32 = 0;
    let mut compression: i32 = 0;
    let mut channel: i32 = 0;
    let mut i: i32 = 0;
    let mut bitdepth: i32 = 0;
    let mut w: i32 = 0;
    let mut h: i32 = 0;
    let mut out: *mut u8 = std::ptr::null_mut();

    if stbi__get32be(s) != ((0x38425053) as u32) {
        return (((if (stbi__err("not PSD")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    if stbi__get16be(s) != 1 {
        return (((if (stbi__err("wrong version")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    stbi__skip(s, 6);
    channelCount = ((stbi__get16be(s)) as i32);
    if channelCount < 0 || channelCount > 16 {
        return (((if (stbi__err("wrong channel count")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    h = ((stbi__get32be(s)) as i32);
    w = ((stbi__get32be(s)) as i32);
    if h > (1 << 24) {
        return (((if (stbi__err("too large")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    if w > (1 << 24) {
        return (((if (stbi__err("too large")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    bitdepth = ((stbi__get16be(s)) as i32);
    if bitdepth != 8 && bitdepth != 16 {
        return (((if (stbi__err("unsupported bit depth")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    if stbi__get16be(s) != 3 {
        return (((if (stbi__err("wrong color format")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    stbi__skip(s, ((stbi__get32be(s)) as i32));
    stbi__skip(s, ((stbi__get32be(s)) as i32));
    stbi__skip(s, ((stbi__get32be(s)) as i32));
    compression = ((stbi__get16be(s)) as i32);
    if compression > 1 {
        return (((if (stbi__err("bad compression")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    if stbi__mad3sizes_valid(4, w, h, 0) == 0 {
        return (((if (stbi__err("too large")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    if compression == 0 && bitdepth == 16 && bpc == 16 {
        out = stbi__malloc_mad3(8, w, h, 0);
        (*ri).bits_per_channel = ((16) as i32);
    } else {
        out = stbi__malloc(((4 * w * h) as u64));
    }
    if out == std::ptr::null_mut() {
        return (((if (stbi__err("outofmem")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    pixelCount = ((w * h) as i32);
    if (compression) != 0 {
        stbi__skip(s, h * channelCount * 2);
        channel = ((0) as i32);
        while (channel < 4) {
            let mut p: *mut u8 = std::ptr::null_mut();
            p = (out).offset((channel) as isize);
            if channel >= channelCount {
                i = ((0) as i32);
                while (i < pixelCount) {
                    *p = ((if channel == 3 { 255 } else { 0 }) as u8);
                    c_runtime::postInc(&mut i);
                    p = p.offset((4) as isize);
                }
            } else {
                if stbi__psd_decode_rle(s, p, pixelCount) == 0 {
                    c_runtime::free(out);
                    return (((if (stbi__err("corrupt")) != 0 {
                        (0)
                    } else {
                        (0)
                    }) as u64) as *mut u8);
                }
            }
            c_runtime::postInc(&mut channel);
        }
    } else {
        channel = ((0) as i32);
        while (channel < 4) {
            if channel >= channelCount {
                if bitdepth == 16 && bpc == 16 {
                    let mut q: *mut u16 = ((out) as *mut u16).offset((channel) as isize);
                    let mut val: u16 = ((if channel == 3 { 65535 } else { 0 }) as u16);
                    i = ((0) as i32);
                    while (i < pixelCount) {
                        *q = ((val) as u16);
                        c_runtime::postInc(&mut i);
                        q = q.offset((4) as isize);
                    }
                } else {
                    let mut p: *mut u8 = (out).offset((channel) as isize);
                    let mut val: u8 = ((if channel == 3 { 255 } else { 0 }) as u8);
                    i = ((0) as i32);
                    while (i < pixelCount) {
                        *p = ((val) as u8);
                        c_runtime::postInc(&mut i);
                        p = p.offset((4) as isize);
                    }
                }
            } else {
                if (*ri).bits_per_channel == 16 {
                    let mut q: *mut u16 = ((out) as *mut u16).offset((channel) as isize);
                    i = ((0) as i32);
                    while (i < pixelCount) {
                        *q = ((stbi__get16be(s)) as u16);
                        c_runtime::postInc(&mut i);
                        q = q.offset((4) as isize);
                    }
                } else {
                    let mut p: *mut u8 = (out).offset((channel) as isize);
                    if bitdepth == 16 {
                        i = ((0) as i32);
                        while (i < pixelCount) {
                            *p = ((stbi__get16be(s) >> 8) as u8);
                            c_runtime::postInc(&mut i);
                            p = p.offset((4) as isize);
                        }
                    } else {
                        i = ((0) as i32);
                        while (i < pixelCount) {
                            *p = ((stbi__get8(s)) as u8);
                            c_runtime::postInc(&mut i);
                            p = p.offset((4) as isize);
                        }
                    }
                }
            }
            c_runtime::postInc(&mut channel);
        }
    }
    if channelCount >= 4 {
        if (*ri).bits_per_channel == 16 {
            i = ((0) as i32);
            while (i < w * h) {
                let mut pixel: *mut u16 = ((out) as *mut u16).offset((4 * i) as isize);
                if ((*pixel.offset((3) as isize)) as i32) != 0
                    && ((*pixel.offset((3) as isize)) as i32) != 65535
                {
                    let mut a: f32 = (((*pixel.offset((3) as isize)) as i32) as f32) / 65535.0f32;
                    let mut ra: f32 = 1.0f32 / a;
                    let mut inv_a: f32 = 65535.0f32 * (((1) as f32) - ra);
                    *pixel.offset((0) as isize) =
                        (((((*pixel.offset((0) as isize)) as i32) as f32) * ra + inv_a) as u16);
                    *pixel.offset((1) as isize) =
                        (((((*pixel.offset((1) as isize)) as i32) as f32) * ra + inv_a) as u16);
                    *pixel.offset((2) as isize) =
                        (((((*pixel.offset((2) as isize)) as i32) as f32) * ra + inv_a) as u16);
                }
                c_runtime::preInc(&mut i);
            }
        } else {
            i = ((0) as i32);
            while (i < w * h) {
                let mut pixel: *mut u8 = (out).offset((4 * i) as isize);
                if ((*pixel.offset((3) as isize)) as i32) != 0
                    && ((*pixel.offset((3) as isize)) as i32) != 255
                {
                    let mut a: f32 = (((*pixel.offset((3) as isize)) as i32) as f32) / 255.0f32;
                    let mut ra: f32 = 1.0f32 / a;
                    let mut inv_a: f32 = 255.0f32 * (((1) as f32) - ra);
                    *pixel.offset((0) as isize) =
                        (((((*pixel.offset((0) as isize)) as i32) as f32) * ra + inv_a) as u8);
                    *pixel.offset((1) as isize) =
                        (((((*pixel.offset((1) as isize)) as i32) as f32) * ra + inv_a) as u8);
                    *pixel.offset((2) as isize) =
                        (((((*pixel.offset((2) as isize)) as i32) as f32) * ra + inv_a) as u8);
                }
                c_runtime::preInc(&mut i);
            }
        }
    }
    if (req_comp) != 0 && req_comp != 4 {
        if (*ri).bits_per_channel == 16 {
            out = ((stbi__convert_format16(
                (((out) as *mut u16) as *mut u16),
                4,
                req_comp,
                ((w) as u32),
                ((h) as u32),
            )) as *mut u8);
        } else {
            out = stbi__convert_format(out, 4, req_comp, ((w) as u32), ((h) as u32));
        }
        if out == std::ptr::null_mut() {
            return out;
        }
    }
    if (comp) != std::ptr::null_mut() {
        *comp = ((4) as i32);
    }
    *y = ((h) as i32);
    *x = ((w) as i32);
    return out;
}

pub unsafe fn stbi__psd_test(mut s: *mut stbi__context) -> i32 {
    let mut r: i32 = if stbi__get32be(s) == ((0x38425053) as u32) {
        1
    } else {
        0
    };
    stbi__rewind(s);
    return ((r) as i32);
}
