// Generated by Hebron at 1/1/2022 6:43:55 AM

use crate::*;
use c_runtime;
use std;

pub const STBI__F_avg: i32 = 3;

pub const STBI__F_avg_first: i32 = 5;

pub const STBI__F_none: i32 = 0;

pub const STBI__F_paeth: i32 = 4;

pub const STBI__F_paeth_first: i32 = 6;

pub const STBI__F_sub: i32 = 1;

pub const STBI__F_up: i32 = 2;

pub static mut stbi__check_png_header_png_sig: [u8; 8] = [
    ((137) as u8),
    ((80) as u8),
    ((78) as u8),
    ((71) as u8),
    ((13) as u8),
    ((10) as u8),
    ((26) as u8),
    ((10) as u8),
];

#[derive(Debug, Copy, Clone)]
pub struct stbi__png {
    pub s: *mut stbi__context,
    pub idata: *mut u8,
    pub expanded: *mut u8,
    pub out: *mut u8,
    pub depth: i32,
}

#[derive(Debug, Copy, Clone)]
pub struct stbi__pngchunk {
    pub length: u32,
    pub _type_: u32,
}

impl std::default::Default for stbi__png {
    fn default() -> Self {
        stbi__png {
            s: std::ptr::null_mut(),
            idata: std::ptr::null_mut(),
            expanded: std::ptr::null_mut(),
            out: std::ptr::null_mut(),
            depth: 0,
        }
    }
}

impl std::default::Default for stbi__pngchunk {
    fn default() -> Self {
        stbi__pngchunk {
            length: 0,
            _type_: 0,
        }
    }
}

pub unsafe fn stbi__check_png_header(mut s: *mut stbi__context) -> i32 {
    let mut i: i32 = 0;
    i = ((0) as i32);
    while (i < 8) {
        if ((stbi__get8(s)) as i32) != ((stbi__check_png_header_png_sig[(i) as usize]) as i32) {
            return ((stbi__err("bad png sig")) as i32);
        }
        c_runtime::preInc(&mut i);
    }
    return ((1) as i32);
}

pub unsafe fn stbi__compute_transparency(
    mut z: *mut stbi__png,
    mut tc: [u8; 3],
    mut out_n: i32,
) -> i32 {
    let mut s: *mut stbi__context = (*z).s;
    let mut i: u32 = 0;
    let mut pixel_count: u32 = (*s).img_x * (*s).img_y;
    let mut p: *mut u8 = (*z).out;

    if out_n == 2 {
        i = ((0) as u32);
        while (i < pixel_count) {
            *p.offset((1) as isize) =
                ((if ((*p.offset((0) as isize)) as i32) == ((tc[(0) as usize]) as i32) {
                    0
                } else {
                    255
                }) as u8);
            p = p.offset((2) as isize);
            c_runtime::preInc(&mut i);
        }
    } else {
        i = ((0) as u32);
        while (i < pixel_count) {
            if ((*p.offset((0) as isize)) as i32) == ((tc[(0) as usize]) as i32)
                && ((*p.offset((1) as isize)) as i32) == ((tc[(1) as usize]) as i32)
                && ((*p.offset((2) as isize)) as i32) == ((tc[(2) as usize]) as i32)
            {
                *p.offset((3) as isize) = ((0) as u8);
            }
            p = p.offset((4) as isize);
            c_runtime::preInc(&mut i);
        }
    }
    return ((1) as i32);
}

pub unsafe fn stbi__compute_transparency16(
    mut z: *mut stbi__png,
    mut tc: [u16; 3],
    mut out_n: i32,
) -> i32 {
    let mut s: *mut stbi__context = (*z).s;
    let mut i: u32 = 0;
    let mut pixel_count: u32 = (*s).img_x * (*s).img_y;
    let mut p: *mut u16 = (((*z).out) as *mut u16);

    if out_n == 2 {
        i = ((0) as u32);
        while (i < pixel_count) {
            *p.offset((1) as isize) =
                ((if ((*p.offset((0) as isize)) as i32) == ((tc[(0) as usize]) as i32) {
                    0
                } else {
                    65535
                }) as u16);
            p = p.offset((2) as isize);
            c_runtime::preInc(&mut i);
        }
    } else {
        i = ((0) as u32);
        while (i < pixel_count) {
            if ((*p.offset((0) as isize)) as i32) == ((tc[(0) as usize]) as i32)
                && ((*p.offset((1) as isize)) as i32) == ((tc[(1) as usize]) as i32)
                && ((*p.offset((2) as isize)) as i32) == ((tc[(2) as usize]) as i32)
            {
                *p.offset((3) as isize) = ((0) as u16);
            }
            p = p.offset((4) as isize);
            c_runtime::preInc(&mut i);
        }
    }
    return ((1) as i32);
}

pub unsafe fn stbi__create_png_image(
    mut a: *mut stbi__png,
    mut image_data: *mut u8,
    mut image_data_len: u32,
    mut out_n: i32,
    mut depth: i32,
    mut color: i32,
    mut interlaced: i32,
) -> i32 {
    let mut bytes: i32 = (if depth == 16 { 2 } else { 1 });
    let mut out_bytes: i32 = out_n * bytes;
    let mut _final_: *mut u8 = std::ptr::null_mut();
    let mut p: i32 = 0;
    if interlaced == 0 {
        return ((stbi__create_png_image_raw(
            a,
            image_data,
            image_data_len,
            out_n,
            (*(*a).s).img_x,
            (*(*a).s).img_y,
            depth,
            color,
        )) as i32);
    }
    _final_ = stbi__malloc_mad3(
        (((*(*a).s).img_x) as i32),
        (((*(*a).s).img_y) as i32),
        out_bytes,
        0,
    );
    if _final_ == std::ptr::null_mut() {
        return ((stbi__err("outofmem")) as i32);
    }
    p = ((0) as i32);
    while (p < 7) {
        let mut xorig: [i32; 7] = [0, 4, 0, 2, 0, 1, 0];
        let mut yorig: [i32; 7] = [0, 0, 4, 0, 2, 0, 1];
        let mut xspc: [i32; 7] = [8, 8, 4, 4, 2, 2, 1];
        let mut yspc: [i32; 7] = [8, 8, 8, 4, 4, 2, 2];
        let mut i: i32 = 0;
        let mut j: i32 = 0;
        let mut x: i32 = 0;
        let mut y: i32 = 0;
        x = ((((*(*a).s).img_x - ((xorig[(p) as usize]) as u32) + ((xspc[(p) as usize]) as u32)
            - ((1) as u32))
            / ((xspc[(p) as usize]) as u32)) as i32);
        y = ((((*(*a).s).img_y - ((yorig[(p) as usize]) as u32) + ((yspc[(p) as usize]) as u32)
            - ((1) as u32))
            / ((yspc[(p) as usize]) as u32)) as i32);
        if (x) != 0 && (y) != 0 {
            let mut img_len: u32 = (((((((*(*a).s).img_n * x * depth) + 7) >> 3) + 1) * y) as u32);
            if stbi__create_png_image_raw(
                a,
                image_data,
                image_data_len,
                out_n,
                ((x) as u32),
                ((y) as u32),
                depth,
                color,
            ) == 0
            {
                c_runtime::free(_final_);
                return ((0) as i32);
            }
            j = ((0) as i32);
            while (j < y) {
                i = ((0) as i32);
                while (i < x) {
                    let mut out_y: i32 = j * yspc[(p) as usize] + yorig[(p) as usize];
                    let mut out_x: i32 = i * xspc[(p) as usize] + xorig[(p) as usize];
                    c_runtime::memcpy(
                        ((_final_).offset(
                            (((out_y) as u32) * (*(*a).s).img_x * ((out_bytes) as u32)) as isize,
                        ))
                        .offset((out_x * out_bytes) as isize),
                        ((*a).out).offset(((j * x + i) * out_bytes) as isize),
                        ((out_bytes) as u64),
                    );
                    c_runtime::preInc(&mut i);
                }
                c_runtime::preInc(&mut j);
            }
            c_runtime::free((*a).out);
            image_data = image_data.offset((img_len) as isize);
            image_data_len -= ((img_len) as u32);
        }
        c_runtime::preInc(&mut p);
    }
    (*a).out = _final_;
    return ((1) as i32);
}

pub unsafe fn stbi__create_png_image_raw(
    mut a: *mut stbi__png,
    mut raw: *mut u8,
    mut raw_len: u32,
    mut out_n: i32,
    mut x: u32,
    mut y: u32,
    mut depth: i32,
    mut color: i32,
) -> i32 {
    let mut bytes: i32 = (if depth == 16 { 2 } else { 1 });
    let mut s: *mut stbi__context = (*a).s;
    let mut i: u32 = 0;
    let mut j: u32 = 0;
    let mut stride: u32 = x * ((out_n) as u32) * ((bytes) as u32);
    let mut img_len: u32 = 0;
    let mut img_width_bytes: u32 = 0;
    let mut k: i32 = 0;
    let mut img_n: i32 = (*s).img_n;
    let mut output_bytes: i32 = out_n * bytes;
    let mut filter_bytes: i32 = img_n * bytes;
    let mut width: i32 = ((x) as i32);

    (*a).out = stbi__malloc_mad3(((x) as i32), ((y) as i32), output_bytes, 0);
    if (*a).out == std::ptr::null_mut() {
        return ((stbi__err("outofmem")) as i32);
    }
    if stbi__mad3sizes_valid(img_n, ((x) as i32), depth, 7) == 0 {
        return ((stbi__err("too large")) as i32);
    }
    img_width_bytes = (((((img_n) as u32) * x * ((depth) as u32)) + ((7) as u32)) >> 3);
    img_len = ((img_width_bytes + ((1) as u32)) * y);
    if raw_len < img_len {
        return ((stbi__err("not enough pixels")) as i32);
    }
    j = ((0) as u32);
    while (j < y) {
        let mut cur: *mut u8 = ((*a).out).offset((stride * j) as isize);
        let mut prior: *mut u8 = std::ptr::null_mut();
        let mut filter: i32 = ((*c_runtime::postIncPtr(&mut raw)) as i32);
        if filter > 4 {
            return ((stbi__err("invalid filter")) as i32);
        }
        if depth < 8 {
            if img_width_bytes > x {
                return ((stbi__err("invalid width")) as i32);
            }
            cur = cur.offset((x * ((out_n) as u32) - img_width_bytes) as isize);
            filter_bytes = ((1) as i32);
            width = ((img_width_bytes) as i32);
        }
        prior = (cur).offset(-((stride) as isize));
        if j == ((0) as u32) {
            filter = ((first_row_filter[(filter) as usize]) as i32);
        }
        k = ((0) as i32);
        while (k < filter_bytes) {
            {
                if filter == STBI__F_none {
                    *cur.offset((k) as isize) = ((*raw.offset((k) as isize)) as u8);
                } else if filter == STBI__F_sub {
                    *cur.offset((k) as isize) = ((*raw.offset((k) as isize)) as u8);
                } else if filter == STBI__F_up {
                    *cur.offset((k) as isize) = (((((*raw.offset((k) as isize)) as i32)
                        + ((*prior.offset((k) as isize)) as i32))
                        & 255) as u8);
                } else if filter == STBI__F_avg {
                    *cur.offset((k) as isize) = (((((*raw.offset((k) as isize)) as i32)
                        + (((*prior.offset((k) as isize)) as i32) >> 1))
                        & 255) as u8);
                } else if filter == STBI__F_paeth {
                    *cur.offset((k) as isize) = (((((*raw.offset((k) as isize)) as i32)
                        + stbi__paeth(0, ((*prior.offset((k) as isize)) as i32), 0))
                        & 255) as u8);
                } else if filter == STBI__F_avg_first {
                    *cur.offset((k) as isize) = ((*raw.offset((k) as isize)) as u8);
                } else if filter == STBI__F_paeth_first {
                    *cur.offset((k) as isize) = ((*raw.offset((k) as isize)) as u8);
                }
            }
            c_runtime::preInc(&mut k);
        }
        if depth == 8 {
            if img_n != out_n {
                *cur.offset((img_n) as isize) = ((255) as u8);
            }
            raw = raw.offset((img_n) as isize);
            cur = cur.offset((out_n) as isize);
            prior = prior.offset((out_n) as isize);
        } else {
            if depth == 16 {
                if img_n != out_n {
                    *cur.offset((filter_bytes) as isize) = ((255) as u8);
                    *cur.offset((filter_bytes + 1) as isize) = ((255) as u8);
                }
                raw = raw.offset((filter_bytes) as isize);
                cur = cur.offset((output_bytes) as isize);
                prior = prior.offset((output_bytes) as isize);
            } else {
                raw = raw.offset((1) as isize);
                cur = cur.offset((1) as isize);
                prior = prior.offset((1) as isize);
            }
        }
        if depth < 8 || img_n == out_n {
            let mut nk: i32 = (width - 1) * filter_bytes;
            {
                if filter == STBI__F_none {
                    c_runtime::memcpy(cur, raw, ((nk) as u64));
                } else if filter == STBI__F_sub {
                    k = ((0) as i32);
                    while (k < nk) {
                        *cur.offset((k) as isize) = (((((*raw.offset((k) as isize)) as i32)
                            + ((*cur.offset((k - filter_bytes) as isize)) as i32))
                            & 255) as u8);
                        c_runtime::preInc(&mut k);
                    }
                } else if filter == STBI__F_up {
                    k = ((0) as i32);
                    while (k < nk) {
                        *cur.offset((k) as isize) = (((((*raw.offset((k) as isize)) as i32)
                            + ((*prior.offset((k) as isize)) as i32))
                            & 255) as u8);
                        c_runtime::preInc(&mut k);
                    }
                } else if filter == STBI__F_avg {
                    k = ((0) as i32);
                    while (k < nk) {
                        *cur.offset((k) as isize) = (((((*raw.offset((k) as isize)) as i32)
                            + ((((*prior.offset((k) as isize)) as i32)
                                + ((*cur.offset((k - filter_bytes) as isize)) as i32))
                                >> 1))
                            & 255) as u8);
                        c_runtime::preInc(&mut k);
                    }
                } else if filter == STBI__F_paeth {
                    k = ((0) as i32);
                    while (k < nk) {
                        *cur.offset((k) as isize) = (((((*raw.offset((k) as isize)) as i32)
                            + stbi__paeth(
                                ((*cur.offset((k - filter_bytes) as isize)) as i32),
                                ((*prior.offset((k) as isize)) as i32),
                                ((*prior.offset((k - filter_bytes) as isize)) as i32),
                            ))
                            & 255) as u8);
                        c_runtime::preInc(&mut k);
                    }
                } else if filter == STBI__F_avg_first {
                    k = ((0) as i32);
                    while (k < nk) {
                        *cur.offset((k) as isize) = (((((*raw.offset((k) as isize)) as i32)
                            + (((*cur.offset((k - filter_bytes) as isize)) as i32) >> 1))
                            & 255) as u8);
                        c_runtime::preInc(&mut k);
                    }
                } else if filter == STBI__F_paeth_first {
                    k = ((0) as i32);
                    while (k < nk) {
                        *cur.offset((k) as isize) = (((((*raw.offset((k) as isize)) as i32)
                            + stbi__paeth(
                                ((*cur.offset((k - filter_bytes) as isize)) as i32),
                                0,
                                0,
                            ))
                            & 255) as u8);
                        c_runtime::preInc(&mut k);
                    }
                }
            }
            raw = raw.offset((nk) as isize);
        } else {
            {
                if filter == STBI__F_none {
                    i = (x - ((1) as u32));
                    while (i >= ((1) as u32)) {
                        k = ((0) as i32);
                        while (k < filter_bytes) {
                            *cur.offset((k) as isize) = ((*raw.offset((k) as isize)) as u8);
                            c_runtime::preInc(&mut k);
                        }
                        c_runtime::preDec(&mut i);
                        *cur.offset((filter_bytes) as isize) = ((255) as u8);
                        raw = raw.offset((filter_bytes) as isize);
                        cur = cur.offset((output_bytes) as isize);
                        prior = prior.offset((output_bytes) as isize);
                    }
                } else if filter == STBI__F_sub {
                    i = (x - ((1) as u32));
                    while (i >= ((1) as u32)) {
                        k = ((0) as i32);
                        while (k < filter_bytes) {
                            *cur.offset((k) as isize) = (((((*raw.offset((k) as isize)) as i32)
                                + ((*cur.offset((k - output_bytes) as isize)) as i32))
                                & 255)
                                as u8);
                            c_runtime::preInc(&mut k);
                        }
                        c_runtime::preDec(&mut i);
                        *cur.offset((filter_bytes) as isize) = ((255) as u8);
                        raw = raw.offset((filter_bytes) as isize);
                        cur = cur.offset((output_bytes) as isize);
                        prior = prior.offset((output_bytes) as isize);
                    }
                } else if filter == STBI__F_up {
                    i = (x - ((1) as u32));
                    while (i >= ((1) as u32)) {
                        k = ((0) as i32);
                        while (k < filter_bytes) {
                            *cur.offset((k) as isize) = (((((*raw.offset((k) as isize)) as i32)
                                + ((*prior.offset((k) as isize)) as i32))
                                & 255)
                                as u8);
                            c_runtime::preInc(&mut k);
                        }
                        c_runtime::preDec(&mut i);
                        *cur.offset((filter_bytes) as isize) = ((255) as u8);
                        raw = raw.offset((filter_bytes) as isize);
                        cur = cur.offset((output_bytes) as isize);
                        prior = prior.offset((output_bytes) as isize);
                    }
                } else if filter == STBI__F_avg {
                    i = (x - ((1) as u32));
                    while (i >= ((1) as u32)) {
                        k = ((0) as i32);
                        while (k < filter_bytes) {
                            *cur.offset((k) as isize) = (((((*raw.offset((k) as isize)) as i32)
                                + ((((*prior.offset((k) as isize)) as i32)
                                    + ((*cur.offset((k - output_bytes) as isize)) as i32))
                                    >> 1))
                                & 255)
                                as u8);
                            c_runtime::preInc(&mut k);
                        }
                        c_runtime::preDec(&mut i);
                        *cur.offset((filter_bytes) as isize) = ((255) as u8);
                        raw = raw.offset((filter_bytes) as isize);
                        cur = cur.offset((output_bytes) as isize);
                        prior = prior.offset((output_bytes) as isize);
                    }
                } else if filter == STBI__F_paeth {
                    i = (x - ((1) as u32));
                    while (i >= ((1) as u32)) {
                        k = ((0) as i32);
                        while (k < filter_bytes) {
                            *cur.offset((k) as isize) = (((((*raw.offset((k) as isize)) as i32)
                                + stbi__paeth(
                                    ((*cur.offset((k - output_bytes) as isize)) as i32),
                                    ((*prior.offset((k) as isize)) as i32),
                                    ((*prior.offset((k - output_bytes) as isize)) as i32),
                                ))
                                & 255)
                                as u8);
                            c_runtime::preInc(&mut k);
                        }
                        c_runtime::preDec(&mut i);
                        *cur.offset((filter_bytes) as isize) = ((255) as u8);
                        raw = raw.offset((filter_bytes) as isize);
                        cur = cur.offset((output_bytes) as isize);
                        prior = prior.offset((output_bytes) as isize);
                    }
                } else if filter == STBI__F_avg_first {
                    i = (x - ((1) as u32));
                    while (i >= ((1) as u32)) {
                        k = ((0) as i32);
                        while (k < filter_bytes) {
                            *cur.offset((k) as isize) = (((((*raw.offset((k) as isize)) as i32)
                                + (((*cur.offset((k - output_bytes) as isize)) as i32) >> 1))
                                & 255)
                                as u8);
                            c_runtime::preInc(&mut k);
                        }
                        c_runtime::preDec(&mut i);
                        *cur.offset((filter_bytes) as isize) = ((255) as u8);
                        raw = raw.offset((filter_bytes) as isize);
                        cur = cur.offset((output_bytes) as isize);
                        prior = prior.offset((output_bytes) as isize);
                    }
                } else if filter == STBI__F_paeth_first {
                    i = (x - ((1) as u32));
                    while (i >= ((1) as u32)) {
                        k = ((0) as i32);
                        while (k < filter_bytes) {
                            *cur.offset((k) as isize) = (((((*raw.offset((k) as isize)) as i32)
                                + stbi__paeth(
                                    ((*cur.offset((k - output_bytes) as isize)) as i32),
                                    0,
                                    0,
                                ))
                                & 255)
                                as u8);
                            c_runtime::preInc(&mut k);
                        }
                        c_runtime::preDec(&mut i);
                        *cur.offset((filter_bytes) as isize) = ((255) as u8);
                        raw = raw.offset((filter_bytes) as isize);
                        cur = cur.offset((output_bytes) as isize);
                        prior = prior.offset((output_bytes) as isize);
                    }
                }
            }
            if depth == 16 {
                cur = ((*a).out).offset((stride * j) as isize);
                i = ((0) as u32);
                while (i < x) {
                    *cur.offset((filter_bytes + 1) as isize) = ((255) as u8);
                    c_runtime::preInc(&mut i);
                    cur = cur.offset((output_bytes) as isize);
                }
            }
        }
        c_runtime::preInc(&mut j);
    }
    if depth < 8 {
        j = ((0) as u32);
        while (j < y) {
            let mut cur: *mut u8 = ((*a).out).offset((stride * j) as isize);
            let mut _in_: *mut u8 = ((((*a).out).offset((stride * j) as isize))
                .offset((x * ((out_n) as u32)) as isize))
            .offset(-((img_width_bytes) as isize));
            let mut scale: u8 = ((if (color == 0) {
                ((stbi__depth_scale_table[(depth) as usize]) as i32)
            } else {
                1
            }) as u8);
            if depth == 4 {
                k = ((x * ((img_n) as u32)) as i32);
                while (k >= 2) {
                    *c_runtime::postIncPtr(&mut cur) =
                        ((((scale) as i32) * (((*_in_) as i32) >> 4)) as u8);
                    *c_runtime::postIncPtr(&mut cur) =
                        ((((scale) as i32) * (((*_in_) as i32) & 0x0f)) as u8);
                    k -= ((2) as i32);
                    c_runtime::preIncPtr(&mut _in_);
                }
                if k > 0 {
                    *c_runtime::postIncPtr(&mut cur) =
                        ((((scale) as i32) * (((*_in_) as i32) >> 4)) as u8);
                }
            } else {
                if depth == 2 {
                    k = ((x * ((img_n) as u32)) as i32);
                    while (k >= 4) {
                        *c_runtime::postIncPtr(&mut cur) =
                            ((((scale) as i32) * (((*_in_) as i32) >> 6)) as u8);
                        *c_runtime::postIncPtr(&mut cur) =
                            ((((scale) as i32) * ((((*_in_) as i32) >> 4) & 0x03)) as u8);
                        *c_runtime::postIncPtr(&mut cur) =
                            ((((scale) as i32) * ((((*_in_) as i32) >> 2) & 0x03)) as u8);
                        *c_runtime::postIncPtr(&mut cur) =
                            ((((scale) as i32) * (((*_in_) as i32) & 0x03)) as u8);
                        k -= ((4) as i32);
                        c_runtime::preIncPtr(&mut _in_);
                    }
                    if k > 0 {
                        *c_runtime::postIncPtr(&mut cur) =
                            ((((scale) as i32) * (((*_in_) as i32) >> 6)) as u8);
                    }
                    if k > 1 {
                        *c_runtime::postIncPtr(&mut cur) =
                            ((((scale) as i32) * ((((*_in_) as i32) >> 4) & 0x03)) as u8);
                    }
                    if k > 2 {
                        *c_runtime::postIncPtr(&mut cur) =
                            ((((scale) as i32) * ((((*_in_) as i32) >> 2) & 0x03)) as u8);
                    }
                } else {
                    if depth == 1 {
                        k = ((x * ((img_n) as u32)) as i32);
                        while (k >= 8) {
                            *c_runtime::postIncPtr(&mut cur) =
                                ((((scale) as i32) * (((*_in_) as i32) >> 7)) as u8);
                            *c_runtime::postIncPtr(&mut cur) =
                                ((((scale) as i32) * ((((*_in_) as i32) >> 6) & 0x01)) as u8);
                            *c_runtime::postIncPtr(&mut cur) =
                                ((((scale) as i32) * ((((*_in_) as i32) >> 5) & 0x01)) as u8);
                            *c_runtime::postIncPtr(&mut cur) =
                                ((((scale) as i32) * ((((*_in_) as i32) >> 4) & 0x01)) as u8);
                            *c_runtime::postIncPtr(&mut cur) =
                                ((((scale) as i32) * ((((*_in_) as i32) >> 3) & 0x01)) as u8);
                            *c_runtime::postIncPtr(&mut cur) =
                                ((((scale) as i32) * ((((*_in_) as i32) >> 2) & 0x01)) as u8);
                            *c_runtime::postIncPtr(&mut cur) =
                                ((((scale) as i32) * ((((*_in_) as i32) >> 1) & 0x01)) as u8);
                            *c_runtime::postIncPtr(&mut cur) =
                                ((((scale) as i32) * (((*_in_) as i32) & 0x01)) as u8);
                            k -= ((8) as i32);
                            c_runtime::preIncPtr(&mut _in_);
                        }
                        if k > 0 {
                            *c_runtime::postIncPtr(&mut cur) =
                                ((((scale) as i32) * (((*_in_) as i32) >> 7)) as u8);
                        }
                        if k > 1 {
                            *c_runtime::postIncPtr(&mut cur) =
                                ((((scale) as i32) * ((((*_in_) as i32) >> 6) & 0x01)) as u8);
                        }
                        if k > 2 {
                            *c_runtime::postIncPtr(&mut cur) =
                                ((((scale) as i32) * ((((*_in_) as i32) >> 5) & 0x01)) as u8);
                        }
                        if k > 3 {
                            *c_runtime::postIncPtr(&mut cur) =
                                ((((scale) as i32) * ((((*_in_) as i32) >> 4) & 0x01)) as u8);
                        }
                        if k > 4 {
                            *c_runtime::postIncPtr(&mut cur) =
                                ((((scale) as i32) * ((((*_in_) as i32) >> 3) & 0x01)) as u8);
                        }
                        if k > 5 {
                            *c_runtime::postIncPtr(&mut cur) =
                                ((((scale) as i32) * ((((*_in_) as i32) >> 2) & 0x01)) as u8);
                        }
                        if k > 6 {
                            *c_runtime::postIncPtr(&mut cur) =
                                ((((scale) as i32) * ((((*_in_) as i32) >> 1) & 0x01)) as u8);
                        }
                    }
                }
            }
            if img_n != out_n {
                let mut q: i32 = 0;
                cur = ((*a).out).offset((stride * j) as isize);
                if img_n == 1 {
                    q = ((x - ((1) as u32)) as i32);
                    while (q >= 0) {
                        *cur.offset((q * 2 + 1) as isize) = ((255) as u8);
                        *cur.offset((q * 2 + 0) as isize) = ((*cur.offset((q) as isize)) as u8);
                        c_runtime::preDec(&mut q);
                    }
                } else {
                    q = ((x - ((1) as u32)) as i32);
                    while (q >= 0) {
                        *cur.offset((q * 4 + 3) as isize) = ((255) as u8);
                        *cur.offset((q * 4 + 2) as isize) =
                            ((*cur.offset((q * 3 + 2) as isize)) as u8);
                        *cur.offset((q * 4 + 1) as isize) =
                            ((*cur.offset((q * 3 + 1) as isize)) as u8);
                        *cur.offset((q * 4 + 0) as isize) =
                            ((*cur.offset((q * 3 + 0) as isize)) as u8);
                        c_runtime::preDec(&mut q);
                    }
                }
            }
            c_runtime::preInc(&mut j);
        }
    } else {
        if depth == 16 {
            let mut cur: *mut u8 = (*a).out;
            let mut cur16: *mut u16 = ((cur) as *mut u16);
            i = ((0) as u32);
            while (i < x * y * ((out_n) as u32)) {
                *cur16 = (((((*cur.offset((0) as isize)) as i32) << 8)
                    | ((*cur.offset((1) as isize)) as i32)) as u16);
                c_runtime::preInc(&mut i);
                c_runtime::postIncPtr(&mut cur16);
                cur = cur.offset((2) as isize);
            }
        }
    }
    return ((1) as i32);
}

pub unsafe fn stbi__de_iphone(mut z: *mut stbi__png) {
    let mut s: *mut stbi__context = (*z).s;
    let mut i: u32 = 0;
    let mut pixel_count: u32 = (*s).img_x * (*s).img_y;
    let mut p: *mut u8 = (*z).out;
    if (*s).img_out_n == 3 {
        i = ((0) as u32);
        while (i < pixel_count) {
            let mut t: u8 = *p.offset((0) as isize);
            *p.offset((0) as isize) = ((*p.offset((2) as isize)) as u8);
            *p.offset((2) as isize) = ((t) as u8);
            p = p.offset((3) as isize);
            c_runtime::preInc(&mut i);
        }
    } else {
        if (if (stbi__unpremultiply_on_load_set) != 0 {
            stbi__unpremultiply_on_load_local
        } else {
            stbi__unpremultiply_on_load_global
        }) != 0
        {
            i = ((0) as u32);
            while (i < pixel_count) {
                let mut a: u8 = *p.offset((3) as isize);
                let mut t: u8 = *p.offset((0) as isize);
                if (a) != 0 {
                    let mut half: u8 = ((((a) as i32) / 2) as u8);
                    *p.offset((0) as isize) = (((((*p.offset((2) as isize)) as i32) * 255
                        + ((half) as i32))
                        / ((a) as i32)) as u8);
                    *p.offset((1) as isize) = (((((*p.offset((1) as isize)) as i32) * 255
                        + ((half) as i32))
                        / ((a) as i32)) as u8);
                    *p.offset((2) as isize) =
                        (((((t) as i32) * 255 + ((half) as i32)) / ((a) as i32)) as u8);
                } else {
                    *p.offset((0) as isize) = ((*p.offset((2) as isize)) as u8);
                    *p.offset((2) as isize) = ((t) as u8);
                }
                p = p.offset((4) as isize);
                c_runtime::preInc(&mut i);
            }
        } else {
            i = ((0) as u32);
            while (i < pixel_count) {
                let mut t: u8 = *p.offset((0) as isize);
                *p.offset((0) as isize) = ((*p.offset((2) as isize)) as u8);
                *p.offset((2) as isize) = ((t) as u8);
                p = p.offset((4) as isize);
                c_runtime::preInc(&mut i);
            }
        }
    }
}

pub unsafe fn stbi__do_png(
    mut p: *mut stbi__png,
    mut x: *mut i32,
    mut y: *mut i32,
    mut n: *mut i32,
    mut req_comp: i32,
    mut ri: *mut stbi__result_info,
) -> *mut u8 {
    let mut result: *mut u8 = std::ptr::null_mut();
    if req_comp < 0 || req_comp > 4 {
        return (((if (stbi__err("bad req_comp")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    if (stbi__parse_png_file(p, STBI__SCAN_load, req_comp)) != 0 {
        if (*p).depth <= 8 {
            (*ri).bits_per_channel = ((8) as i32);
        } else {
            if (*p).depth == 16 {
                (*ri).bits_per_channel = ((16) as i32);
            } else {
                return (((if (stbi__err("bad bits_per_channel")) != 0 {
                    (0)
                } else {
                    (0)
                }) as u64) as *mut u8);
            }
        }
        result = (*p).out;
        (*p).out = std::ptr::null_mut();
        if (req_comp) != 0 && req_comp != (*(*p).s).img_out_n {
            if (*ri).bits_per_channel == 8 {
                result = stbi__convert_format(
                    result,
                    (*(*p).s).img_out_n,
                    req_comp,
                    (*(*p).s).img_x,
                    (*(*p).s).img_y,
                );
            } else {
                result = stbi__convert_format16(
                    (((result) as *mut u16) as *mut u16),
                    (*(*p).s).img_out_n,
                    req_comp,
                    (*(*p).s).img_x,
                    (*(*p).s).img_y,
                ) as *mut u8;
            }
            (*(*p).s).img_out_n = ((req_comp) as i32);
            if result == std::ptr::null_mut() {
                return result;
            }
        }
        *x = (((*(*p).s).img_x) as i32);
        *y = (((*(*p).s).img_y) as i32);
        if (n) != std::ptr::null_mut() {
            *n = (((*(*p).s).img_n) as i32);
        }
    }
    c_runtime::free((*p).out);
    (*p).out = std::ptr::null_mut();
    c_runtime::free((*p).expanded);
    (*p).expanded = std::ptr::null_mut();
    c_runtime::free((*p).idata);
    (*p).idata = std::ptr::null_mut();
    return result;
}

pub unsafe fn stbi__expand_png_palette(
    mut a: *mut stbi__png,
    mut palette: *mut u8,
    mut len: i32,
    mut pal_img_n: i32,
) -> i32 {
    let mut i: u32 = 0;
    let mut pixel_count: u32 = (*(*a).s).img_x * (*(*a).s).img_y;
    let mut p: *mut u8 = std::ptr::null_mut();
    let mut temp_out: *mut u8 = std::ptr::null_mut();
    let mut orig: *mut u8 = (*a).out;
    p = stbi__malloc_mad2(((pixel_count) as i32), pal_img_n, 0);
    if p == std::ptr::null_mut() {
        return ((stbi__err("outofmem")) as i32);
    }
    temp_out = p;
    if pal_img_n == 3 {
        i = ((0) as u32);
        while (i < pixel_count) {
            let mut n: i32 = ((*orig.offset((i) as isize)) as i32) * 4;
            *p.offset((0) as isize) = ((*palette.offset((n) as isize)) as u8);
            *p.offset((1) as isize) = ((*palette.offset((n + 1) as isize)) as u8);
            *p.offset((2) as isize) = ((*palette.offset((n + 2) as isize)) as u8);
            p = p.offset((3) as isize);
            c_runtime::preInc(&mut i);
        }
    } else {
        i = ((0) as u32);
        while (i < pixel_count) {
            let mut n: i32 = ((*orig.offset((i) as isize)) as i32) * 4;
            *p.offset((0) as isize) = ((*palette.offset((n) as isize)) as u8);
            *p.offset((1) as isize) = ((*palette.offset((n + 1) as isize)) as u8);
            *p.offset((2) as isize) = ((*palette.offset((n + 2) as isize)) as u8);
            *p.offset((3) as isize) = ((*palette.offset((n + 3) as isize)) as u8);
            p = p.offset((4) as isize);
            c_runtime::preInc(&mut i);
        }
    }
    c_runtime::free((*a).out);
    (*a).out = temp_out;

    return ((1) as i32);
}

pub unsafe fn stbi__get_chunk_header(mut s: *mut stbi__context) -> stbi__pngchunk {
    let mut c: stbi__pngchunk = stbi__pngchunk::default();
    c.length = ((stbi__get32be(s)) as u32);
    c._type_ = ((stbi__get32be(s)) as u32);
    return ((c) as stbi__pngchunk);
}

pub unsafe fn stbi__parse_png_file(mut z: *mut stbi__png, mut scan: i32, mut req_comp: i32) -> i32 {
    let mut palette: [u8; 1024] = [0; 1024];
    let mut pal_img_n: u8 = ((0) as u8);
    let mut has_trans: u8 = ((0) as u8);
    let mut tc: [u8; 3] = [0; 3];
    let mut tc16: [u16; 3] = [0; 3];
    let mut ioff: u32 = ((0) as u32);
    let mut idata_limit: u32 = ((0) as u32);
    let mut i: u32 = 0;
    let mut pal_len: u32 = ((0) as u32);
    let mut first: i32 = 1;
    let mut k: i32 = 0;
    let mut interlace: i32 = 0;
    let mut color: i32 = 0;
    let mut is_iphone: i32 = 0;
    let mut s: *mut stbi__context = (*z).s;
    (*z).expanded = std::ptr::null_mut();
    (*z).idata = std::ptr::null_mut();
    (*z).out = std::ptr::null_mut();
    if stbi__check_png_header(s) == 0 {
        return ((0) as i32);
    }
    if scan == STBI__SCAN_type {
        return ((1) as i32);
    };
    while (true) {
        let mut c: stbi__pngchunk = stbi__get_chunk_header(s);
        {
            if c._type_
                == ((((67) as u32) << 24)
                    + (((103) as u32) << 16)
                    + (((66) as u32) << 8)
                    + ((73) as u32))
            {
                is_iphone = ((1) as i32);
                stbi__skip(s, ((c.length) as i32));
            } else if c._type_
                == ((((73) as u32) << 24)
                    + (((72) as u32) << 16)
                    + (((68) as u32) << 8)
                    + ((82) as u32))
            {
                {
                    let mut comp: i32 = 0;
                    let mut filter: i32 = 0;
                    if first == 0 {
                        return ((stbi__err("multiple IHDR")) as i32);
                    }
                    first = ((0) as i32);
                    if c.length != ((13) as u32) {
                        return ((stbi__err("bad IHDR len")) as i32);
                    }
                    (*s).img_x = ((stbi__get32be(s)) as u32);
                    (*s).img_y = ((stbi__get32be(s)) as u32);
                    if (*s).img_y > ((1 << 24) as u32) {
                        return ((stbi__err("too large")) as i32);
                    }
                    if (*s).img_x > ((1 << 24) as u32) {
                        return ((stbi__err("too large")) as i32);
                    }
                    (*z).depth = ((stbi__get8(s)) as i32);
                    if (*z).depth != 1
                        && (*z).depth != 2
                        && (*z).depth != 4
                        && (*z).depth != 8
                        && (*z).depth != 16
                    {
                        return ((stbi__err("1/2/4/8/16-bit only")) as i32);
                    }
                    color = ((stbi__get8(s)) as i32);
                    if color > 6 {
                        return ((stbi__err("bad ctype")) as i32);
                    }
                    if color == 3 && (*z).depth == 16 {
                        return ((stbi__err("bad ctype")) as i32);
                    }
                    if color == 3 {
                        pal_img_n = ((3) as u8);
                    } else {
                        if (color & 1) != 0 {
                            return ((stbi__err("bad ctype")) as i32);
                        }
                    }
                    comp = ((stbi__get8(s)) as i32);
                    if (comp) != 0 {
                        return ((stbi__err("bad comp method")) as i32);
                    }
                    filter = ((stbi__get8(s)) as i32);
                    if (filter) != 0 {
                        return ((stbi__err("bad filter method")) as i32);
                    }
                    interlace = ((stbi__get8(s)) as i32);
                    if interlace > 1 {
                        return ((stbi__err("bad interlace method")) as i32);
                    }
                    if (*s).img_x == 0 || (*s).img_y == 0 {
                        return ((stbi__err("0-pixel image")) as i32);
                    }
                    if pal_img_n == 0 {
                        (*s).img_n = (((if (color & 2) != 0 { 3 } else { 1 })
                            + (if (color & 4) != 0 { 1 } else { 0 }))
                            as i32);
                        if ((1 << 30) as u32) / (*s).img_x / (((*s).img_n) as u32) < (*s).img_y {
                            return ((stbi__err("too large")) as i32);
                        }
                        if scan == STBI__SCAN_header {
                            return ((1) as i32);
                        }
                    } else {
                        (*s).img_n = ((1) as i32);
                        if ((1 << 30) as u32) / (*s).img_x / ((4) as u32) < (*s).img_y {
                            return ((stbi__err("too large")) as i32);
                        }
                    }
                }
            } else if c._type_
                == ((((80) as u32) << 24)
                    + (((76) as u32) << 16)
                    + (((84) as u32) << 8)
                    + ((69) as u32))
            {
                {
                    if (first) != 0 {
                        return ((stbi__err("first not IHDR")) as i32);
                    }
                    if c.length > ((256 * 3) as u32) {
                        return ((stbi__err("invalid PLTE")) as i32);
                    }
                    pal_len = (c.length / ((3) as u32));
                    if pal_len * ((3) as u32) != c.length {
                        return ((stbi__err("invalid PLTE")) as i32);
                    }
                    i = ((0) as u32);
                    while (i < pal_len) {
                        palette[(i * ((4) as u32) + ((0) as u32)) as usize] =
                            ((stbi__get8(s)) as u8);
                        palette[(i * ((4) as u32) + ((1) as u32)) as usize] =
                            ((stbi__get8(s)) as u8);
                        palette[(i * ((4) as u32) + ((2) as u32)) as usize] =
                            ((stbi__get8(s)) as u8);
                        palette[(i * ((4) as u32) + ((3) as u32)) as usize] = ((255) as u8);
                        c_runtime::preInc(&mut i);
                    }
                }
            } else if c._type_
                == ((((116) as u32) << 24)
                    + (((82) as u32) << 16)
                    + (((78) as u32) << 8)
                    + ((83) as u32))
            {
                {
                    if (first) != 0 {
                        return ((stbi__err("first not IHDR")) as i32);
                    }
                    if ((*z).idata) != std::ptr::null_mut() {
                        return ((stbi__err("tRNS after IDAT")) as i32);
                    }
                    if (pal_img_n) != 0 {
                        if scan == STBI__SCAN_header {
                            (*s).img_n = ((4) as i32);
                            return ((1) as i32);
                        }
                        if pal_len == ((0) as u32) {
                            return ((stbi__err("tRNS before PLTE")) as i32);
                        }
                        if c.length > pal_len {
                            return ((stbi__err("bad tRNS len")) as i32);
                        }
                        pal_img_n = ((4) as u8);
                        i = ((0) as u32);
                        while (i < c.length) {
                            palette[(i * ((4) as u32) + ((3) as u32)) as usize] =
                                ((stbi__get8(s)) as u8);
                            c_runtime::preInc(&mut i);
                        }
                    } else {
                        if ((*s).img_n & 1) == 0 {
                            return ((stbi__err("tRNS with alpha")) as i32);
                        }
                        if c.length != (((*s).img_n) as u32) * ((2) as u32) {
                            return ((stbi__err("bad tRNS len")) as i32);
                        }
                        has_trans = ((1) as u8);
                        if (*z).depth == 16 {
                            k = ((0) as i32);
                            while (k < (*s).img_n) {
                                tc16[(k) as usize] = ((stbi__get16be(s)) as u16);
                                c_runtime::preInc(&mut k);
                            }
                        } else {
                            k = ((0) as i32);
                            while (k < (*s).img_n) {
                                tc[(k) as usize] = (((((stbi__get16be(s) & 255) as u8) as i32)
                                    * ((stbi__depth_scale_table[((*z).depth) as usize]) as i32))
                                    as u8);
                                c_runtime::preInc(&mut k);
                            }
                        }
                    }
                }
            } else if c._type_
                == ((((73) as u32) << 24)
                    + (((68) as u32) << 16)
                    + (((65) as u32) << 8)
                    + ((84) as u32))
            {
                {
                    if (first) != 0 {
                        return ((stbi__err("first not IHDR")) as i32);
                    }
                    if ((pal_img_n) as i32) != 0 && pal_len == 0 {
                        return ((stbi__err("no PLTE")) as i32);
                    }
                    if scan == STBI__SCAN_header {
                        (*s).img_n = ((pal_img_n) as i32);
                        return ((1) as i32);
                    }
                    if ((ioff + c.length) as i32) < ((ioff) as i32) {
                        return ((0) as i32);
                    }
                    if ioff + c.length > idata_limit {
                        let mut idata_limit_old: u32 = idata_limit;
                        let mut p: *mut u8 = std::ptr::null_mut();
                        if idata_limit == ((0) as u32) {
                            idata_limit = (if c.length > ((4096) as u32) {
                                c.length
                            } else {
                                ((4096) as u32)
                            });
                        }
                        while (ioff + c.length > idata_limit) {
                            idata_limit *= ((2) as u32);
                        }
                        p = c_runtime::realloc((*z).idata, ((idata_limit) as u64));
                        if p == std::ptr::null_mut() {
                            return ((stbi__err("outofmem")) as i32);
                        }
                        (*z).idata = p;
                    }
                    if stbi__getn(s, ((*z).idata).offset((ioff) as isize), ((c.length) as i32)) == 0
                    {
                        return ((stbi__err("outofdata")) as i32);
                    }
                    ioff += ((c.length) as u32);
                }
            } else if c._type_
                == ((((73) as u32) << 24)
                    + (((69) as u32) << 16)
                    + (((78) as u32) << 8)
                    + ((68) as u32))
            {
                {
                    let mut raw_len: u32 = 0;
                    let mut bpl: u32 = 0;
                    if (first) != 0 {
                        return ((stbi__err("first not IHDR")) as i32);
                    }
                    if scan != STBI__SCAN_load {
                        return ((1) as i32);
                    }
                    if (*z).idata == std::ptr::null_mut() {
                        return ((stbi__err("no IDAT")) as i32);
                    }
                    bpl = (((*s).img_x * (((*z).depth) as u32) + ((7) as u32)) / ((8) as u32));
                    raw_len = (bpl * (*s).img_y * (((*s).img_n) as u32) + (*s).img_y);
                    (*z).expanded = ((stbi_zlib_decode_malloc_guesssize_headerflag(
                        (((*z).idata) as *mut i8),
                        ((ioff) as i32),
                        ((raw_len) as i32),
                        (((&mut raw_len) as *mut u32) as *mut i32),
                        !is_iphone,
                    )) as *mut u8);
                    if (*z).expanded == std::ptr::null_mut() {
                        return ((0) as i32);
                    }
                    c_runtime::free((*z).idata);
                    (*z).idata = std::ptr::null_mut();
                    if (req_comp == (*s).img_n + 1 && req_comp != 3 && pal_img_n == 0)
                        || ((has_trans) as i32) != 0
                    {
                        (*s).img_out_n = (((*s).img_n + 1) as i32);
                    } else {
                        (*s).img_out_n = (((*s).img_n) as i32);
                    }
                    if stbi__create_png_image(
                        z,
                        (*z).expanded,
                        raw_len,
                        (*s).img_out_n,
                        (*z).depth,
                        color,
                        interlace,
                    ) == 0
                    {
                        return ((0) as i32);
                    }
                    if (has_trans) != 0 {
                        if (*z).depth == 16 {
                            if stbi__compute_transparency16(z, tc16, (*s).img_out_n) == 0 {
                                return ((0) as i32);
                            }
                        } else {
                            if stbi__compute_transparency(z, tc, (*s).img_out_n) == 0 {
                                return ((0) as i32);
                            }
                        }
                    }
                    if (is_iphone) != 0
                        && (if (stbi__de_iphone_flag_set) != 0 {
                            stbi__de_iphone_flag_local
                        } else {
                            stbi__de_iphone_flag_global
                        }) != 0
                        && (*s).img_out_n > 2
                    {
                        stbi__de_iphone(z);
                    }
                    if (pal_img_n) != 0 {
                        (*s).img_n = ((pal_img_n) as i32);
                        (*s).img_out_n = ((pal_img_n) as i32);
                        if req_comp >= 3 {
                            (*s).img_out_n = ((req_comp) as i32);
                        }
                        if stbi__expand_png_palette(
                            z,
                            ((palette.as_mut_ptr()) as *mut u8),
                            ((pal_len) as i32),
                            (*s).img_out_n,
                        ) == 0
                        {
                            return ((0) as i32);
                        }
                    } else {
                        if (has_trans) != 0 {
                            c_runtime::preInc(&mut (*s).img_n);
                        }
                    }
                    c_runtime::free((*z).expanded);
                    (*z).expanded = std::ptr::null_mut();
                    stbi__get32be(s);
                    return ((1) as i32);
                }
            } else {
                if (first) != 0 {
                    return ((stbi__err("first not IHDR")) as i32);
                }
                if (c._type_ & ((1 << 29) as u32)) == ((0) as u32) {
                    stbi__parse_png_file_invalid_chunk[(0) as usize] =
                        ((((c._type_ >> 24) & ((255) as u32)) as u8) as i8);
                    stbi__parse_png_file_invalid_chunk[(1) as usize] =
                        ((((c._type_ >> 16) & ((255) as u32)) as u8) as i8);
                    stbi__parse_png_file_invalid_chunk[(2) as usize] =
                        ((((c._type_ >> 8) & ((255) as u32)) as u8) as i8);
                    stbi__parse_png_file_invalid_chunk[(3) as usize] =
                        ((((c._type_ >> 0) & ((255) as u32)) as u8) as i8);
                    return ((stbi__err("aaa")) as i32);
                }
                stbi__skip(s, ((c.length) as i32));
            }
        }
        stbi__get32be(s);
    }

    return 0;
}

pub unsafe fn stbi__png_info(
    mut s: *mut stbi__context,
    mut x: *mut i32,
    mut y: *mut i32,
    mut comp: *mut i32,
) -> i32 {
    let mut p: stbi__png = stbi__png::default();
    p.s = s;
    return ((stbi__png_info_raw(((&mut p) as *mut stbi__png), x, y, comp)) as i32);
}

pub unsafe fn stbi__png_info_raw(
    mut p: *mut stbi__png,
    mut x: *mut i32,
    mut y: *mut i32,
    mut comp: *mut i32,
) -> i32 {
    if stbi__parse_png_file(p, STBI__SCAN_header, 0) == 0 {
        stbi__rewind((*p).s);
        return ((0) as i32);
    }
    if (x) != std::ptr::null_mut() {
        *x = (((*(*p).s).img_x) as i32);
    }
    if (y) != std::ptr::null_mut() {
        *y = (((*(*p).s).img_y) as i32);
    }
    if (comp) != std::ptr::null_mut() {
        *comp = (((*(*p).s).img_n) as i32);
    }
    return ((1) as i32);
}

pub unsafe fn stbi__png_is16(mut s: *mut stbi__context) -> i32 {
    let mut p: stbi__png = stbi__png::default();
    p.s = s;
    if stbi__png_info_raw(
        ((&mut p) as *mut stbi__png),
        ((std::ptr::null_mut()) as *mut i32),
        ((std::ptr::null_mut()) as *mut i32),
        ((std::ptr::null_mut()) as *mut i32),
    ) == 0
    {
        return ((0) as i32);
    }
    if p.depth != 16 {
        stbi__rewind(((p.s) as *mut stbi__context));
        return ((0) as i32);
    }
    return ((1) as i32);
}

pub unsafe fn stbi__png_load(
    mut s: *mut stbi__context,
    mut x: *mut i32,
    mut y: *mut i32,
    mut comp: *mut i32,
    mut req_comp: i32,
    mut ri: *mut stbi__result_info,
) -> *mut u8 {
    let mut p: stbi__png = stbi__png::default();
    p.s = s;
    return stbi__do_png(((&mut p) as *mut stbi__png), x, y, comp, req_comp, ri);
}

pub unsafe fn stbi__png_test(mut s: *mut stbi__context) -> i32 {
    let mut r: i32 = 0;
    r = ((stbi__check_png_header(s)) as i32);
    stbi__rewind(s);
    return ((r) as i32);
}
