// Generated by Hebron at 1/1/2022 6:43:55 AM

use crate::*;
use c_runtime;
use std;

#[derive(Debug, Copy, Clone)]
pub struct stbi__huffman {
    pub fast: [u8; 512],
    pub code: [u16; 256],
    pub values: [u8; 256],
    pub size: [u8; 257],
    pub maxcode: [u32; 18],
    pub delta: [i32; 17],
}

#[derive(Debug, Copy, Clone)]
pub struct stbi__jpeg {
    pub s: *mut stbi__context,
    pub huff_dc: [stbi__huffman; 4],
    pub huff_ac: [stbi__huffman; 4],
    pub dequant: [[u16; 64]; 4],
    pub fast_ac: [[i16; 512]; 4],
    pub img_h_max: i32,
    pub img_v_max: i32,
    pub img_mcu_x: i32,
    pub img_mcu_y: i32,
    pub img_mcu_w: i32,
    pub img_mcu_h: i32,
    pub img_comp: [stbi__jpeg_unnamed1; 4],
    pub code_buffer: u32,
    pub code_bits: i32,
    pub marker: u8,
    pub nomore: i32,
    pub progressive: i32,
    pub spec_start: i32,
    pub spec_end: i32,
    pub succ_high: i32,
    pub succ_low: i32,
    pub eob_run: i32,
    pub jfif: i32,
    pub app14_color_transform: i32,
    pub rgb: i32,
    pub scan_n: i32,
    pub order: [i32; 4],
    pub restart_interval: i32,
    pub todo: i32,
    pub idct_block_kernel: Option<unsafe fn(arg0: *mut u8, arg1: i32, arg2: *mut i16)>,
    pub YCbCr_to_RGB_kernel: Option<
        unsafe fn(arg0: *mut u8, arg1: *mut u8, arg2: *mut u8, arg3: *mut u8, arg4: i32, arg5: i32),
    >,
    pub resample_row_hv_2_kernel: Option<
        unsafe fn(arg0: *mut u8, arg1: *mut u8, arg2: *mut u8, arg3: i32, arg4: i32) -> *mut u8,
    >,
}

#[derive(Debug, Copy, Clone)]
pub struct stbi__jpeg_unnamed1 {
    pub id: i32,
    pub h: i32,
    pub v: i32,
    pub tq: i32,
    pub hd: i32,
    pub ha: i32,
    pub dc_pred: i32,
    pub x: i32,
    pub y: i32,
    pub w2: i32,
    pub h2: i32,
    pub data: *mut u8,
    pub raw_data: *mut u8,
    pub raw_coeff: *mut u8,
    pub linebuf: *mut u8,
    pub coeff: *mut i16,
    pub coeff_w: i32,
    pub coeff_h: i32,
}

#[derive(Debug, Copy, Clone)]
pub struct stbi__resample {
    pub resample: Option<
        unsafe fn(arg0: *mut u8, arg1: *mut u8, arg2: *mut u8, arg3: i32, arg4: i32) -> *mut u8,
    >,
    pub line0: *mut u8,
    pub line1: *mut u8,
    pub hs: i32,
    pub vs: i32,
    pub w_lores: i32,
    pub ystep: i32,
    pub ypos: i32,
}

impl std::default::Default for stbi__huffman {
    fn default() -> Self {
        stbi__huffman {
            fast: [0; 512],
            code: [0; 256],
            values: [0; 256],
            size: [0; 257],
            maxcode: [0; 18],
            delta: [0; 17],
        }
    }
}

impl std::default::Default for stbi__jpeg {
    fn default() -> Self {
        stbi__jpeg {
            s: std::ptr::null_mut(),
            huff_dc: [stbi__huffman::default(); 4],
            huff_ac: [stbi__huffman::default(); 4],
            dequant: [[0; 64]; 4],
            fast_ac: [[0; 512]; 4],
            img_h_max: 0,
            img_v_max: 0,
            img_mcu_x: 0,
            img_mcu_y: 0,
            img_mcu_w: 0,
            img_mcu_h: 0,
            img_comp: [stbi__jpeg_unnamed1::default(); 4],
            code_buffer: 0,
            code_bits: 0,
            marker: 0,
            nomore: 0,
            progressive: 0,
            spec_start: 0,
            spec_end: 0,
            succ_high: 0,
            succ_low: 0,
            eob_run: 0,
            jfif: 0,
            app14_color_transform: 0,
            rgb: 0,
            scan_n: 0,
            order: [0; 4],
            restart_interval: 0,
            todo: 0,
            idct_block_kernel: None,
            YCbCr_to_RGB_kernel: None,
            resample_row_hv_2_kernel: None,
        }
    }
}

impl std::default::Default for stbi__jpeg_unnamed1 {
    fn default() -> Self {
        stbi__jpeg_unnamed1 {
            id: 0,
            h: 0,
            v: 0,
            tq: 0,
            hd: 0,
            ha: 0,
            dc_pred: 0,
            x: 0,
            y: 0,
            w2: 0,
            h2: 0,
            data: std::ptr::null_mut(),
            raw_data: std::ptr::null_mut(),
            raw_coeff: std::ptr::null_mut(),
            linebuf: std::ptr::null_mut(),
            coeff: std::ptr::null_mut(),
            coeff_w: 0,
            coeff_h: 0,
        }
    }
}

impl std::default::Default for stbi__resample {
    fn default() -> Self {
        stbi__resample {
            resample: None,
            line0: std::ptr::null_mut(),
            line1: std::ptr::null_mut(),
            hs: 0,
            vs: 0,
            w_lores: 0,
            ystep: 0,
            ypos: 0,
        }
    }
}

pub unsafe fn load_jpeg_image(
    mut z: *mut stbi__jpeg,
    mut out_x: *mut i32,
    mut out_y: *mut i32,
    mut comp: *mut i32,
    mut req_comp: i32,
) -> *mut u8 {
    let mut n: i32 = 0;
    let mut decode_n: i32 = 0;
    let mut is_rgb: i32 = 0;
    (*(*z).s).img_n = ((0) as i32);
    if req_comp < 0 || req_comp > 4 {
        return (((if (stbi__err("bad req_comp")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
    if stbi__decode_jpeg_image(z) == 0 {
        stbi__cleanup_jpeg(z);
        return std::ptr::null_mut();
    }
    n = ((if (req_comp) != 0 {
        req_comp
    } else {
        if (*(*z).s).img_n >= 3 {
            3
        } else {
            1
        }
    }) as i32);
    is_rgb = ((if (*(*z).s).img_n == 3
        && ((*z).rgb == 3 || ((*z).app14_color_transform == 0 && (*z).jfif == 0))
    {
        1
    } else {
        0
    }) as i32);
    if (*(*z).s).img_n == 3 && n < 3 && is_rgb == 0 {
        decode_n = ((1) as i32);
    } else {
        decode_n = (((*(*z).s).img_n) as i32);
    }
    if decode_n <= 0 {
        stbi__cleanup_jpeg(z);
        return std::ptr::null_mut();
    }
    {
        let mut k: i32 = 0;
        let mut i: u32 = 0;
        let mut j: u32 = 0;
        let mut output: *mut u8 = std::ptr::null_mut();
        let mut coutput: [*mut u8; 4] = [
            std::ptr::null_mut(),
            std::ptr::null_mut(),
            std::ptr::null_mut(),
            std::ptr::null_mut(),
        ];
        let mut res_comp: [stbi__resample; 4] = [stbi__resample::default(); 4];
        k = ((0) as i32);
        while (k < decode_n) {
            let mut r: *mut stbi__resample = &mut res_comp[(k) as usize];
            (*z).img_comp[(k) as usize].linebuf =
                stbi__malloc((((*(*z).s).img_x + ((3) as u32)) as u64));
            if (*z).img_comp[(k) as usize].linebuf == std::ptr::null_mut() {
                stbi__cleanup_jpeg(z);
                return (((if (stbi__err("outofmem")) != 0 {
                    (0)
                } else {
                    (0)
                }) as u64) as *mut u8);
            }
            (*r).hs = (((*z).img_h_max / (*z).img_comp[(k) as usize].h) as i32);
            (*r).vs = (((*z).img_v_max / (*z).img_comp[(k) as usize].v) as i32);
            (*r).ystep = (((*r).vs >> 1) as i32);
            (*r).w_lores = ((((*(*z).s).img_x + (((*r).hs) as u32) - ((1) as u32))
                / (((*r).hs) as u32)) as i32);
            (*r).ypos = ((0) as i32);
            let hebron_tmp0 = (*z).img_comp[(k) as usize].data;
            (*r).line0 = hebron_tmp0;
            (*r).line1 = hebron_tmp0;
            if (*r).hs == 1 && (*r).vs == 1 {
                (*r).resample = Some(resample_row_1);
            } else {
                if (*r).hs == 1 && (*r).vs == 2 {
                    (*r).resample = Some(stbi__resample_row_v_2);
                } else {
                    if (*r).hs == 2 && (*r).vs == 1 {
                        (*r).resample = Some(stbi__resample_row_h_2);
                    } else {
                        if (*r).hs == 2 && (*r).vs == 2 {
                            (*r).resample = (*z).resample_row_hv_2_kernel;
                        } else {
                            (*r).resample = Some(stbi__resample_row_generic);
                        }
                    }
                }
            }
            c_runtime::preInc(&mut k);
        }
        output = stbi__malloc_mad3(n, (((*(*z).s).img_x) as i32), (((*(*z).s).img_y) as i32), 1);
        if output == std::ptr::null_mut() {
            stbi__cleanup_jpeg(z);
            return (((if (stbi__err("outofmem")) != 0 {
                (0)
            } else {
                (0)
            }) as u64) as *mut u8);
        }
        j = ((0) as u32);
        while (j < (*(*z).s).img_y) {
            let mut out: *mut u8 = (output).offset((((n) as u32) * (*(*z).s).img_x * j) as isize);
            k = ((0) as i32);
            while (k < decode_n) {
                let mut r: *mut stbi__resample = &mut res_comp[(k) as usize];
                let mut y_bot: i32 = if (*r).ystep >= ((*r).vs >> 1) { 1 } else { 0 };
                coutput[(k) as usize] = ((*r).resample.unwrap())(
                    (*z).img_comp[(k) as usize].linebuf,
                    ((if (y_bot) != 0 { (*r).line1 } else { (*r).line0 }) as *mut u8),
                    ((if (y_bot) != 0 { (*r).line0 } else { (*r).line1 }) as *mut u8),
                    (*r).w_lores,
                    (*r).hs,
                );
                if c_runtime::preInc(&mut (*r).ystep) >= (*r).vs {
                    (*r).ystep = ((0) as i32);
                    (*r).line0 = (*r).line1;
                    if c_runtime::preInc(&mut (*r).ypos) < (*z).img_comp[(k) as usize].y {
                        (*r).line1 = (*r).line1.offset(((*z).img_comp[(k) as usize].w2) as isize);
                    }
                }
                c_runtime::preInc(&mut k);
            }
            if n >= 3 {
                let mut y: *mut u8 = coutput[(0) as usize];
                if (*(*z).s).img_n == 3 {
                    if (is_rgb) != 0 {
                        i = ((0) as u32);
                        while (i < (*(*z).s).img_x) {
                            *out.offset((0) as isize) = ((*y.offset((i) as isize)) as u8);
                            *out.offset((1) as isize) =
                                ((*coutput[(1) as usize].offset((i) as isize)) as u8);
                            *out.offset((2) as isize) =
                                ((*coutput[(2) as usize].offset((i) as isize)) as u8);
                            *out.offset((3) as isize) = ((255) as u8);
                            out = out.offset((n) as isize);
                            c_runtime::preInc(&mut i);
                        }
                    } else {
                        ((*z).YCbCr_to_RGB_kernel.unwrap())(
                            out,
                            y,
                            coutput[(1) as usize],
                            coutput[(2) as usize],
                            (((*(*z).s).img_x) as i32),
                            n,
                        );
                    }
                } else {
                    if (*(*z).s).img_n == 4 {
                        if (*z).app14_color_transform == 0 {
                            i = ((0) as u32);
                            while (i < (*(*z).s).img_x) {
                                let mut m: u8 = *coutput[(3) as usize].offset((i) as isize);
                                *out.offset((0) as isize) = ((stbi__blinn_8x8(
                                    *coutput[(0) as usize].offset((i) as isize),
                                    m,
                                ))
                                    as u8);
                                *out.offset((1) as isize) = ((stbi__blinn_8x8(
                                    *coutput[(1) as usize].offset((i) as isize),
                                    m,
                                ))
                                    as u8);
                                *out.offset((2) as isize) = ((stbi__blinn_8x8(
                                    *coutput[(2) as usize].offset((i) as isize),
                                    m,
                                ))
                                    as u8);
                                *out.offset((3) as isize) = ((255) as u8);
                                out = out.offset((n) as isize);
                                c_runtime::preInc(&mut i);
                            }
                        } else {
                            if (*z).app14_color_transform == 2 {
                                ((*z).YCbCr_to_RGB_kernel.unwrap())(
                                    out,
                                    y,
                                    coutput[(1) as usize],
                                    coutput[(2) as usize],
                                    (((*(*z).s).img_x) as i32),
                                    n,
                                );
                                i = ((0) as u32);
                                while (i < (*(*z).s).img_x) {
                                    let mut m: u8 = *coutput[(3) as usize].offset((i) as isize);
                                    *out.offset((0) as isize) = (stbi__blinn_8x8(
                                        ((255 - ((*out.offset((0) as isize)) as i32)) as u8),
                                        m,
                                    ));
                                    *out.offset((1) as isize) = (stbi__blinn_8x8(
                                        ((255 - ((*out.offset((1) as isize)) as i32)) as u8),
                                        m,
                                    ));
                                    *out.offset((2) as isize) = (stbi__blinn_8x8(
                                        ((255 - ((*out.offset((2) as isize)) as i32)) as u8),
                                        m,
                                    ));
                                    out = out.offset((n) as isize);
                                    c_runtime::preInc(&mut i);
                                }
                            } else {
                                ((*z).YCbCr_to_RGB_kernel.unwrap())(
                                    out,
                                    y,
                                    coutput[(1) as usize],
                                    coutput[(2) as usize],
                                    (((*(*z).s).img_x) as i32),
                                    n,
                                );
                            }
                        }
                    } else {
                        i = ((0) as u32);
                        while (i < (*(*z).s).img_x) {
                            let hebron_tmp2 = *y.offset((i) as isize);
                            *out.offset((0) as isize) = hebron_tmp2;
                            *out.offset((1) as isize) = hebron_tmp2;
                            *out.offset((2) as isize) = hebron_tmp2;
                            *out.offset((3) as isize) = ((255) as u8);
                            out = out.offset((n) as isize);
                            c_runtime::preInc(&mut i);
                        }
                    }
                }
            } else {
                if (is_rgb) != 0 {
                    if n == 1 {
                        i = ((0) as u32);
                        while (i < (*(*z).s).img_x) {
                            *c_runtime::postIncPtr(&mut out) = ((stbi__compute_y(
                                ((*coutput[(0) as usize].offset((i) as isize)) as i32),
                                ((*coutput[(1) as usize].offset((i) as isize)) as i32),
                                ((*coutput[(2) as usize].offset((i) as isize)) as i32),
                            ))
                                as u8);
                            c_runtime::preInc(&mut i);
                        }
                    } else {
                        i = ((0) as u32);
                        while (i < (*(*z).s).img_x) {
                            *out.offset((0) as isize) = ((stbi__compute_y(
                                ((*coutput[(0) as usize].offset((i) as isize)) as i32),
                                ((*coutput[(1) as usize].offset((i) as isize)) as i32),
                                ((*coutput[(2) as usize].offset((i) as isize)) as i32),
                            )) as u8);
                            *out.offset((1) as isize) = ((255) as u8);
                            c_runtime::preInc(&mut i);
                            out = out.offset((2) as isize);
                        }
                    }
                } else {
                    if (*(*z).s).img_n == 4 && (*z).app14_color_transform == 0 {
                        i = ((0) as u32);
                        while (i < (*(*z).s).img_x) {
                            let mut m: u8 = *coutput[(3) as usize].offset((i) as isize);
                            let mut r: u8 =
                                stbi__blinn_8x8(*coutput[(0) as usize].offset((i) as isize), m);
                            let mut g: u8 =
                                stbi__blinn_8x8(*coutput[(1) as usize].offset((i) as isize), m);
                            let mut b: u8 =
                                stbi__blinn_8x8(*coutput[(2) as usize].offset((i) as isize), m);
                            *out.offset((0) as isize) =
                                ((stbi__compute_y(((r) as i32), ((g) as i32), ((b) as i32))) as u8);
                            *out.offset((1) as isize) = ((255) as u8);
                            out = out.offset((n) as isize);
                            c_runtime::preInc(&mut i);
                        }
                    } else {
                        if (*(*z).s).img_n == 4 && (*z).app14_color_transform == 2 {
                            i = ((0) as u32);
                            while (i < (*(*z).s).img_x) {
                                *out.offset((0) as isize) = ((stbi__blinn_8x8(
                                    ((255 - ((*coutput[(0) as usize].offset((i) as isize)) as i32))
                                        as u8),
                                    *coutput[(3) as usize].offset((i) as isize),
                                ))
                                    as u8);
                                *out.offset((1) as isize) = ((255) as u8);
                                out = out.offset((n) as isize);
                                c_runtime::preInc(&mut i);
                            }
                        } else {
                            let mut y: *mut u8 = coutput[(0) as usize];
                            if n == 1 {
                                i = ((0) as u32);
                                while (i < (*(*z).s).img_x) {
                                    *out.offset((i) as isize) = ((*y.offset((i) as isize)) as u8);
                                    c_runtime::preInc(&mut i);
                                }
                            } else {
                                i = ((0) as u32);
                                while (i < (*(*z).s).img_x) {
                                    *c_runtime::postIncPtr(&mut out) =
                                        ((*y.offset((i) as isize)) as u8);
                                    *c_runtime::postIncPtr(&mut out) = ((255) as u8);
                                    c_runtime::preInc(&mut i);
                                }
                            }
                        }
                    }
                }
            }
            c_runtime::preInc(&mut j);
        }
        stbi__cleanup_jpeg(z);
        *out_x = (((*(*z).s).img_x) as i32);
        *out_y = (((*(*z).s).img_y) as i32);
        if (comp) != std::ptr::null_mut() {
            *comp = ((if (*(*z).s).img_n >= 3 { 3 } else { 1 }) as i32);
        }
        return output;
    }
}

pub unsafe fn resample_row_1(
    mut out: *mut u8,
    mut in_near: *mut u8,
    mut in_far: *mut u8,
    mut w: i32,
    mut hs: i32,
) -> *mut u8 {
    return in_near;
}

pub unsafe fn stbi__build_fast_ac(mut fast_ac: *mut i16, mut h: *mut stbi__huffman) {
    let mut i: i32 = 0;
    i = ((0) as i32);
    while (i < (1 << 9)) {
        let mut fast: u8 = (*h).fast[(i) as usize];
        *fast_ac.offset((i) as isize) = ((0) as i16);
        if ((fast) as i32) < 255 {
            let mut rs: i32 = (((*h).values[(fast) as usize]) as i32);
            let mut run: i32 = (rs >> 4) & 15;
            let mut magbits: i32 = rs & 15;
            let mut len: i32 = (((*h).size[(fast) as usize]) as i32);
            if (magbits) != 0 && len + magbits <= 9 {
                let mut k: i32 = ((i << len) & ((1 << 9) - 1)) >> (9 - magbits);
                let mut m: i32 = 1 << (magbits - 1);
                if k < m {
                    k += (((!0 << magbits) + ((1) as u32)) as i32);
                }
                if k >= -128 && k <= 127 {
                    *fast_ac.offset((i) as isize) =
                        (((k * 256) + (run * 16) + (len + magbits)) as i16);
                }
            }
        }
        c_runtime::preInc(&mut i);
    }
}

pub unsafe fn stbi__build_huffman(mut h: *mut stbi__huffman, mut count: *mut i32) -> i32 {
    let mut i: i32 = 0;
    let mut j: i32 = 0;
    let mut k: i32 = 0;
    let mut code: u32 = 0;
    i = ((0) as i32);
    while (i < 16) {
        j = ((0) as i32);
        while (j < *count.offset((i) as isize)) {
            (*h).size[(c_runtime::postInc(&mut k)) as usize] = ((i + 1) as u8);
            c_runtime::preInc(&mut j);
        }
        c_runtime::preInc(&mut i);
    }
    (*h).size[(k) as usize] = ((0) as u8);
    code = ((0) as u32);
    k = ((0) as i32);
    j = ((1) as i32);
    while (j <= 16) {
        (*h).delta[(j) as usize] = k - (code as i32);
        if (((*h).size[(k) as usize]) as i32) == j {
            while ((((*h).size[(k) as usize]) as i32) == j) {
                (*h).code[(c_runtime::postInc(&mut k)) as usize] =
                    ((c_runtime::postInc(&mut code)) as u16);
            }
            if code - ((1) as u32) >= (1 << j) {
                return ((stbi__err("bad code lengths")) as i32);
            }
        }
        (*h).maxcode[(j) as usize] = ((code << (16 - j)) as u32);
        code <<= 1;
        c_runtime::preInc(&mut j);
    }
    (*h).maxcode[(j) as usize] = ((0xffffffff) as u32);
    c_runtime::memset((*h).fast.as_mut_ptr(), 255, ((1 << 9) as u64));
    i = ((0) as i32);
    while (i < k) {
        let mut s: i32 = (((*h).size[(i) as usize]) as i32);
        if s <= 9 {
            let mut c: i32 = (((*h).code[(i) as usize]) as i32) << (9 - s);
            let mut m: i32 = 1 << (9 - s);
            j = ((0) as i32);
            while (j < m) {
                (*h).fast[(c + j) as usize] = ((i) as u8);
                c_runtime::preInc(&mut j);
            }
        }
        c_runtime::preInc(&mut i);
    }
    return ((1) as i32);
}

pub unsafe fn stbi__cleanup_jpeg(mut j: *mut stbi__jpeg) {
    stbi__free_jpeg_components(j, (*(*j).s).img_n, 0);
}

pub unsafe fn stbi__decode_jpeg_header(mut z: *mut stbi__jpeg, mut scan: i32) -> i32 {
    let mut m: i32 = 0;
    (*z).jfif = ((0) as i32);
    (*z).app14_color_transform = ((-1) as i32);
    (*z).marker = ((0xff) as u8);
    m = ((stbi__get_marker(z)) as i32);
    if !((m) == 0xd8) {
        return ((stbi__err("no SOI")) as i32);
    }
    if scan == STBI__SCAN_type {
        return ((1) as i32);
    }
    m = ((stbi__get_marker(z)) as i32);
    while (!((m) == 0xc0 || (m) == 0xc1 || (m) == 0xc2)) {
        if stbi__process_marker(z, m) == 0 {
            return ((0) as i32);
        }
        m = ((stbi__get_marker(z)) as i32);
        while (m == 0xff) {
            if (stbi__at_eof((*z).s)) != 0 {
                return ((stbi__err("no SOF")) as i32);
            }
            m = ((stbi__get_marker(z)) as i32);
        }
    }
    (*z).progressive = ((if (m) == 0xc2 { 1 } else { 0 }) as i32);
    if stbi__process_frame_header(z, scan) == 0 {
        return ((0) as i32);
    }
    return ((1) as i32);
}

pub unsafe fn stbi__decode_jpeg_image(mut j: *mut stbi__jpeg) -> i32 {
    let mut m: i32 = 0;
    m = ((0) as i32);
    while (m < 4) {
        (*j).img_comp[(m) as usize].raw_data = std::ptr::null_mut();
        (*j).img_comp[(m) as usize].raw_coeff = std::ptr::null_mut();
        c_runtime::postInc(&mut m);
    }
    (*j).restart_interval = ((0) as i32);
    if stbi__decode_jpeg_header(j, STBI__SCAN_load) == 0 {
        return ((0) as i32);
    }
    m = ((stbi__get_marker(j)) as i32);
    while (!((m) == 0xd9)) {
        if ((m) == 0xda) {
            if stbi__process_scan_header(j) == 0 {
                return ((0) as i32);
            }
            if stbi__parse_entropy_coded_data(j) == 0 {
                return ((0) as i32);
            }
            if (((*j).marker) as i32) == 0xff {
                while (stbi__at_eof((*j).s) == 0) {
                    let mut x: i32 = ((stbi__get8((*j).s)) as i32);
                    if x == 255 {
                        (*j).marker = ((stbi__get8((*j).s)) as u8);
                        break;
                    }
                }
            }
        } else {
            if ((m) == 0xdc) {
                let mut Ld: i32 = stbi__get16be((*j).s);
                let mut NL: u32 = ((stbi__get16be((*j).s)) as u32);
                if Ld != 4 {
                    return ((stbi__err("bad DNL len")) as i32);
                }
                if NL != (*(*j).s).img_y {
                    return ((stbi__err("bad DNL height")) as i32);
                }
            } else {
                if stbi__process_marker(j, m) == 0 {
                    return ((0) as i32);
                }
            }
        }
        m = ((stbi__get_marker(j)) as i32);
    }
    if ((*j).progressive) != 0 {
        stbi__jpeg_finish(j);
    }
    return ((1) as i32);
}

pub unsafe fn stbi__extend_receive(mut j: *mut stbi__jpeg, mut n: i32) -> i32 {
    let mut k: u32 = 0;
    let mut sgn: i32 = 0;
    if (*j).code_bits < n {
        stbi__grow_buffer_unsafe(j);
    }
    sgn = (((*j).code_buffer >> 31) as i32);
    k = ((c_runtime::_lrotl((*j).code_buffer, n)) as u32);
    (*j).code_buffer = ((k & !stbi__bmask[(n) as usize]) as u32);
    k &= ((stbi__bmask[(n) as usize]) as u32);
    (*j).code_bits -= ((n) as i32);
    return ((k + ((stbi__jbias[(n) as usize] & (sgn - 1)) as u32)) as i32);
}

pub unsafe fn stbi__free_jpeg_components(
    mut z: *mut stbi__jpeg,
    mut ncomp: i32,
    mut why: i32,
) -> i32 {
    let mut i: i32 = 0;
    i = ((0) as i32);
    while (i < ncomp) {
        if ((*z).img_comp[(i) as usize].raw_data) != std::ptr::null_mut() {
            c_runtime::free((*z).img_comp[(i) as usize].raw_data);
            (*z).img_comp[(i) as usize].raw_data = std::ptr::null_mut();
            (*z).img_comp[(i) as usize].data = std::ptr::null_mut();
        }
        if ((*z).img_comp[(i) as usize].raw_coeff) != std::ptr::null_mut() {
            c_runtime::free((*z).img_comp[(i) as usize].raw_coeff);
            (*z).img_comp[(i) as usize].raw_coeff = std::ptr::null_mut();
            (*z).img_comp[(i) as usize].coeff = ((std::ptr::null_mut()) as *mut i16);
        }
        if ((*z).img_comp[(i) as usize].linebuf) != std::ptr::null_mut() {
            c_runtime::free((*z).img_comp[(i) as usize].linebuf);
            (*z).img_comp[(i) as usize].linebuf = std::ptr::null_mut();
        }
        c_runtime::preInc(&mut i);
    }
    return ((why) as i32);
}

pub unsafe fn stbi__get_marker(mut j: *mut stbi__jpeg) -> u8 {
    let mut x: u8 = 0;
    if (((*j).marker) as i32) != 0xff {
        x = (((*j).marker) as u8);
        (*j).marker = ((0xff) as u8);
        return ((x) as u8);
    }
    x = ((stbi__get8((*j).s)) as u8);
    if ((x) as i32) != 0xff {
        return ((0xff) as u8);
    }
    while (((x) as i32) == 0xff) {
        x = ((stbi__get8((*j).s)) as u8);
    }
    return ((x) as u8);
}

pub unsafe fn stbi__grow_buffer_unsafe(mut j: *mut stbi__jpeg) {
    while (true) {
        let mut b: u32 = ((if ((*j).nomore) != 0 {
            0
        } else {
            ((stbi__get8((*j).s)) as i32)
        }) as u32);
        if b == ((0xff) as u32) {
            let mut c: i32 = ((stbi__get8((*j).s)) as i32);
            while (c == 0xff) {
                c = ((stbi__get8((*j).s)) as i32);
            }
            if c != 0 {
                (*j).marker = ((c) as u8);
                (*j).nomore = ((1) as i32);
                return;
            }
        }
        (*j).code_buffer |= ((b << (24 - (*j).code_bits)) as u32);
        (*j).code_bits += ((8) as i32);
        if !((*j).code_bits <= 24) {
            break;
        }
    }
}

pub unsafe fn stbi__idct_block(mut out: *mut u8, mut out_stride: i32, mut data: *mut i16) {
    let mut i: i32 = 0;
    let mut val: [i32; 64] = [0; 64];
    let mut v: *mut i32 = val.as_mut_ptr();
    let mut o: *mut u8 = std::ptr::null_mut();
    let mut d: *mut i16 = data;
    i = ((0) as i32);
    while (i < 8) {
        if ((*d.offset((8) as isize)) as i32) == 0
            && ((*d.offset((16) as isize)) as i32) == 0
            && ((*d.offset((24) as isize)) as i32) == 0
            && ((*d.offset((32) as isize)) as i32) == 0
            && ((*d.offset((40) as isize)) as i32) == 0
            && ((*d.offset((48) as isize)) as i32) == 0
            && ((*d.offset((56) as isize)) as i32) == 0
        {
            let mut dcterm: i32 = ((*d.offset((0) as isize)) as i32) * 4;
            let hebron_tmp63 = dcterm;
            *v.offset((0) as isize) = hebron_tmp63;
            *v.offset((8) as isize) = hebron_tmp63;
            *v.offset((16) as isize) = hebron_tmp63;
            *v.offset((24) as isize) = hebron_tmp63;
            *v.offset((32) as isize) = hebron_tmp63;
            *v.offset((40) as isize) = hebron_tmp63;
            *v.offset((48) as isize) = hebron_tmp63;
            *v.offset((56) as isize) = hebron_tmp63;
        } else {
            let mut t0: i32 = 0;
            let mut t1: i32 = 0;
            let mut t2: i32 = 0;
            let mut t3: i32 = 0;
            let mut p1: i32 = 0;
            let mut p2: i32 = 0;
            let mut p3: i32 = 0;
            let mut p4: i32 = 0;
            let mut p5: i32 = 0;
            let mut x0: i32 = 0;
            let mut x1: i32 = 0;
            let mut x2: i32 = 0;
            let mut x3: i32 = 0;
            p2 = ((*d.offset((16) as isize)) as i32);
            p3 = ((*d.offset((48) as isize)) as i32);
            p1 = ((p2 + p3) * (((((0.5411961f32) * ((4096) as f32)) as f64) + 0.532) as i32));
            t2 = (p1 + p3 * (((((-1.847759065f32) * ((4096) as f32)) as f64) + 0.532) as i32));
            t3 = (p1 + p2 * (((((0.765366865f32) * ((4096) as f32)) as f64) + 0.532) as i32));
            p2 = ((*d.offset((0) as isize)) as i32);
            p3 = ((*d.offset((32) as isize)) as i32);
            t0 = (((p2 + p3) * 4096) as i32);
            t1 = (((p2 - p3) * 4096) as i32);
            x0 = ((t0 + t3) as i32);
            x3 = ((t0 - t3) as i32);
            x1 = ((t1 + t2) as i32);
            x2 = ((t1 - t2) as i32);
            t0 = ((*d.offset((56) as isize)) as i32);
            t1 = ((*d.offset((40) as isize)) as i32);
            t2 = ((*d.offset((24) as isize)) as i32);
            t3 = ((*d.offset((8) as isize)) as i32);
            p3 = ((t0 + t2) as i32);
            p4 = ((t1 + t3) as i32);
            p1 = ((t0 + t3) as i32);
            p2 = ((t1 + t2) as i32);
            p5 = ((p3 + p4) * (((((1.175875602f32) * ((4096) as f32)) as f64) + 0.532) as i32));
            t0 = (t0 * (((((0.298631336f32) * ((4096) as f32)) as f64) + 0.532) as i32));
            t1 = (t1 * (((((2.053119869f32) * ((4096) as f32)) as f64) + 0.532) as i32));
            t2 = (t2 * (((((3.072711026f32) * ((4096) as f32)) as f64) + 0.532) as i32));
            t3 = (t3 * (((((1.501321110f32) * ((4096) as f32)) as f64) + 0.532) as i32));
            p1 = (p5 + p1 * (((((-0.899976223f32) * ((4096) as f32)) as f64) + 0.532) as i32));
            p2 = (p5 + p2 * (((((-2.562915447f32) * ((4096) as f32)) as f64) + 0.532) as i32));
            p3 = (p3 * (((((-1.961570560f32) * ((4096) as f32)) as f64) + 0.532) as i32));
            p4 = (p4 * (((((-0.390180644f32) * ((4096) as f32)) as f64) + 0.532) as i32));
            t3 += ((p1 + p4) as i32);
            t2 += ((p2 + p3) as i32);
            t1 += ((p2 + p4) as i32);
            t0 += ((p1 + p3) as i32);
            x0 += ((512) as i32);
            x1 += ((512) as i32);
            x2 += ((512) as i32);
            x3 += ((512) as i32);
            *v.offset((0) as isize) = (((x0 + t3) >> 10) as i32);
            *v.offset((56) as isize) = (((x0 - t3) >> 10) as i32);
            *v.offset((8) as isize) = (((x1 + t2) >> 10) as i32);
            *v.offset((48) as isize) = (((x1 - t2) >> 10) as i32);
            *v.offset((16) as isize) = (((x2 + t1) >> 10) as i32);
            *v.offset((40) as isize) = (((x2 - t1) >> 10) as i32);
            *v.offset((24) as isize) = (((x3 + t0) >> 10) as i32);
            *v.offset((32) as isize) = (((x3 - t0) >> 10) as i32);
        }
        c_runtime::preInc(&mut i);
        c_runtime::preIncPtr(&mut d);
        c_runtime::preIncPtr(&mut v);
    }
    i = ((0) as i32);
    v = val.as_mut_ptr();
    o = out;
    while (i < 8) {
        let mut t0: i32 = 0;
        let mut t1: i32 = 0;
        let mut t2: i32 = 0;
        let mut t3: i32 = 0;
        let mut p1: i32 = 0;
        let mut p2: i32 = 0;
        let mut p3: i32 = 0;
        let mut p4: i32 = 0;
        let mut p5: i32 = 0;
        let mut x0: i32 = 0;
        let mut x1: i32 = 0;
        let mut x2: i32 = 0;
        let mut x3: i32 = 0;
        p2 = ((*v.offset((2) as isize)) as i32);
        p3 = ((*v.offset((6) as isize)) as i32);
        p1 = ((p2 + p3) * (((((0.5411961f32) * ((4096) as f32)) as f64) + 0.532) as i32));
        t2 = (p1 + p3 * (((((-1.847759065f32) * ((4096) as f32)) as f64) + 0.532) as i32));
        t3 = (p1 + p2 * (((((0.765366865f32) * ((4096) as f32)) as f64) + 0.532) as i32));
        p2 = ((*v.offset((0) as isize)) as i32);
        p3 = ((*v.offset((4) as isize)) as i32);
        t0 = (((p2 + p3) * 4096) as i32);
        t1 = (((p2 - p3) * 4096) as i32);
        x0 = ((t0 + t3) as i32);
        x3 = ((t0 - t3) as i32);
        x1 = ((t1 + t2) as i32);
        x2 = ((t1 - t2) as i32);
        t0 = ((*v.offset((7) as isize)) as i32);
        t1 = ((*v.offset((5) as isize)) as i32);
        t2 = ((*v.offset((3) as isize)) as i32);
        t3 = ((*v.offset((1) as isize)) as i32);
        p3 = ((t0 + t2) as i32);
        p4 = ((t1 + t3) as i32);
        p1 = ((t0 + t3) as i32);
        p2 = ((t1 + t2) as i32);
        p5 = ((p3 + p4) * (((((1.175875602f32) * ((4096) as f32)) as f64) + 0.532) as i32));
        t0 = (t0 * (((((0.298631336f32) * ((4096) as f32)) as f64) + 0.532) as i32));
        t1 = (t1 * (((((2.053119869f32) * ((4096) as f32)) as f64) + 0.532) as i32));
        t2 = (t2 * (((((3.072711026f32) * ((4096) as f32)) as f64) + 0.532) as i32));
        t3 = (t3 * (((((1.501321110f32) * ((4096) as f32)) as f64) + 0.532) as i32));
        p1 = (p5 + p1 * (((((-0.899976223f32) * ((4096) as f32)) as f64) + 0.532) as i32));
        p2 = (p5 + p2 * (((((-2.562915447f32) * ((4096) as f32)) as f64) + 0.532) as i32));
        p3 = (p3 * (((((-1.961570560f32) * ((4096) as f32)) as f64) + 0.532) as i32));
        p4 = (p4 * (((((-0.390180644f32) * ((4096) as f32)) as f64) + 0.532) as i32));
        t3 += ((p1 + p4) as i32);
        t2 += ((p2 + p3) as i32);
        t1 += ((p2 + p4) as i32);
        t0 += ((p1 + p3) as i32);
        x0 += ((65536 + (128 << 17)) as i32);
        x1 += ((65536 + (128 << 17)) as i32);
        x2 += ((65536 + (128 << 17)) as i32);
        x3 += ((65536 + (128 << 17)) as i32);
        *o.offset((0) as isize) = ((stbi__clamp((x0 + t3) >> 17)) as u8);
        *o.offset((7) as isize) = ((stbi__clamp((x0 - t3) >> 17)) as u8);
        *o.offset((1) as isize) = ((stbi__clamp((x1 + t2) >> 17)) as u8);
        *o.offset((6) as isize) = ((stbi__clamp((x1 - t2) >> 17)) as u8);
        *o.offset((2) as isize) = ((stbi__clamp((x2 + t1) >> 17)) as u8);
        *o.offset((5) as isize) = ((stbi__clamp((x2 - t1) >> 17)) as u8);
        *o.offset((3) as isize) = ((stbi__clamp((x3 + t0) >> 17)) as u8);
        *o.offset((4) as isize) = ((stbi__clamp((x3 - t0) >> 17)) as u8);
        c_runtime::preInc(&mut i);
        v = v.offset((8) as isize);
        o = o.offset((out_stride) as isize);
    }
}

pub unsafe fn stbi__jpeg_decode_block(
    mut j: *mut stbi__jpeg,
    mut data: *mut i16,
    mut hdc: *mut stbi__huffman,
    mut hac: *mut stbi__huffman,
    mut fac: *mut i16,
    mut b: i32,
    mut dequant: *mut u16,
) -> i32 {
    let mut diff: i32 = 0;
    let mut dc: i32 = 0;
    let mut k: i32 = 0;
    let mut t: i32 = 0;
    if (*j).code_bits < 16 {
        stbi__grow_buffer_unsafe(j);
    }
    t = ((stbi__jpeg_huff_decode(j, hdc)) as i32);
    if t < 0 || t > 15 {
        return ((stbi__err("bad huffman code")) as i32);
    }
    c_runtime::memset(
        ((data) as *mut u8),
        0,
        ((64) as u64) * std::mem::size_of::<i16>() as u64,
    );
    diff = ((if (t) != 0 {
        stbi__extend_receive(j, t)
    } else {
        0
    }) as i32);
    dc = (((*j).img_comp[(b) as usize].dc_pred + diff) as i32);
    (*j).img_comp[(b) as usize].dc_pred = ((dc) as i32);
    *data.offset(0) = ((dc * ((*dequant.offset((0) as isize)) as i32)) as i16);
    k = ((1) as i32);
    while (true) {
        let mut zig: u32 = 0;
        let mut c: i32 = 0;
        let mut r: i32 = 0;
        let mut s: i32 = 0;
        if (*j).code_bits < 16 {
            stbi__grow_buffer_unsafe(j);
        }
        c = ((((*j).code_buffer >> (32 - 9)) & (((1 << 9) - 1) as u32)) as i32);
        r = ((*fac.offset((c) as isize)) as i32);
        if (r) != 0 {
            k += (((r >> 4) & 15) as i32);
            s = ((r & 15) as i32);
            (*j).code_buffer <<= s;
            (*j).code_bits -= ((s) as i32);
            zig = ((stbi__jpeg_dezigzag[(c_runtime::postInc(&mut k)) as usize]) as u32);
            *data.offset(zig as isize) =
                (((r >> 8) * ((*dequant.offset((zig) as isize)) as i32)) as i16);
        } else {
            let mut rs: i32 = stbi__jpeg_huff_decode(j, hac);
            if rs < 0 {
                return ((stbi__err("bad huffman code")) as i32);
            }
            s = ((rs & 15) as i32);
            r = ((rs >> 4) as i32);
            if s == 0 {
                if rs != 0xf0 {
                    break;
                }
                k += ((16) as i32);
            } else {
                k += ((r) as i32);
                zig = ((stbi__jpeg_dezigzag[(c_runtime::postInc(&mut k)) as usize]) as u32);
                *data.offset(zig as isize) = ((stbi__extend_receive(j, s)
                    * ((*dequant.offset((zig) as isize)) as i32))
                    as i16);
            }
        }
        if !(k < 64) {
            break;
        }
    }

    return ((1) as i32);
}

pub unsafe fn stbi__jpeg_decode_block_prog_ac(
    mut j: *mut stbi__jpeg,
    mut data: *mut i16,
    mut hac: *mut stbi__huffman,
    mut fac: *mut i16,
) -> i32 {
    let mut k: i32 = 0;
    if (*j).spec_start == 0 {
        return ((stbi__err("can't merge dc and ac")) as i32);
    }
    if (*j).succ_high == 0 {
        let mut shift: i32 = (*j).succ_low;
        if ((*j).eob_run) != 0 {
            c_runtime::preDec(&mut (*j).eob_run);
            return ((1) as i32);
        }
        k = (((*j).spec_start) as i32);
        while (true) {
            let mut zig: u32 = 0;
            let mut c: i32 = 0;
            let mut r: i32 = 0;
            let mut s: i32 = 0;
            if (*j).code_bits < 16 {
                stbi__grow_buffer_unsafe(j);
            }
            c = ((((*j).code_buffer >> (32 - 9)) & (((1 << 9) - 1) as u32)) as i32);
            r = ((*fac.offset((c) as isize)) as i32);
            if (r) != 0 {
                k += (((r >> 4) & 15) as i32);
                s = ((r & 15) as i32);
                (*j).code_buffer <<= s;
                (*j).code_bits -= ((s) as i32);
                zig = ((stbi__jpeg_dezigzag[(c_runtime::postInc(&mut k)) as usize]) as u32);
                *data.offset(zig as isize) = (((r >> 8) * (1 << shift)) as i16);
            } else {
                let mut rs: i32 = stbi__jpeg_huff_decode(j, hac);
                if rs < 0 {
                    return ((stbi__err("bad huffman code")) as i32);
                }
                s = ((rs & 15) as i32);
                r = ((rs >> 4) as i32);
                if s == 0 {
                    if r < 15 {
                        (*j).eob_run = ((1 << r) as i32);
                        if (r) != 0 {
                            (*j).eob_run += ((stbi__jpeg_get_bits(j, r)) as i32);
                        }
                        c_runtime::preDec(&mut (*j).eob_run);
                        break;
                    }
                    k += ((16) as i32);
                } else {
                    k += ((r) as i32);
                    zig = ((stbi__jpeg_dezigzag[(c_runtime::postInc(&mut k)) as usize]) as u32);
                    *data.offset(zig as isize) =
                        ((stbi__extend_receive(j, s) * (1 << shift)) as i16);
                }
            }
            if !(k <= (*j).spec_end) {
                break;
            }
        }
    } else {
        let mut bit: i16 = ((1 << (*j).succ_low) as i16);
        if ((*j).eob_run) != 0 {
            c_runtime::preDec(&mut (*j).eob_run);
            k = (((*j).spec_start) as i32);
            while (k <= (*j).spec_end) {
                let mut p: *mut i16 = data.offset((stbi__jpeg_dezigzag[(k) as usize]) as isize);
                if ((*p) as i32) != 0 {
                    if (stbi__jpeg_get_bit(j)) != 0 {
                        if (((*p) as i32) & ((bit) as i32)) == 0 {
                            if ((*p) as i32) > 0 {
                                *p += (((bit) as i32) as i16);
                            } else {
                                *p -= (((bit) as i32) as i16);
                            }
                        }
                    }
                }
                c_runtime::preInc(&mut k);
            }
        } else {
            k = (((*j).spec_start) as i32);
            while (true) {
                let mut r: i32 = 0;
                let mut s: i32 = 0;
                let mut rs: i32 = stbi__jpeg_huff_decode(j, hac);
                if rs < 0 {
                    return ((stbi__err("bad huffman code")) as i32);
                }
                s = ((rs & 15) as i32);
                r = ((rs >> 4) as i32);
                if s == 0 {
                    if r < 15 {
                        (*j).eob_run = (((1 << r) - 1) as i32);
                        if (r) != 0 {
                            (*j).eob_run += ((stbi__jpeg_get_bits(j, r)) as i32);
                        }
                        r = ((64) as i32);
                    } else {
                    }
                } else {
                    if s != 1 {
                        return ((stbi__err("bad huffman code")) as i32);
                    }
                    if (stbi__jpeg_get_bit(j)) != 0 {
                        s = ((bit) as i32);
                    } else {
                        s = (-((bit) as i32));
                    }
                }
                while (k <= (*j).spec_end) {
                    let mut p: *mut i16 = data.offset(
                        (stbi__jpeg_dezigzag[(c_runtime::postInc(&mut k)) as usize]) as isize,
                    );
                    if ((*p) as i32) != 0 {
                        if (stbi__jpeg_get_bit(j)) != 0 {
                            if (((*p) as i32) & ((bit) as i32)) == 0 {
                                if ((*p) as i32) > 0 {
                                    *p += (((bit) as i32) as i16);
                                } else {
                                    *p -= (((bit) as i32) as i16);
                                }
                            }
                        }
                    } else {
                        if r == 0 {
                            *p = ((s) as i16);
                            break;
                        }
                        c_runtime::preDec(&mut r);
                    }
                }
                if !(k <= (*j).spec_end) {
                    break;
                }
            }
        }
    }
    return ((1) as i32);
}

pub unsafe fn stbi__jpeg_decode_block_prog_dc(
    mut j: *mut stbi__jpeg,
    mut data: *mut i16,
    mut hdc: *mut stbi__huffman,
    mut b: i32,
) -> i32 {
    let mut diff: i32 = 0;
    let mut dc: i32 = 0;
    let mut t: i32 = 0;
    if (*j).spec_end != 0 {
        return ((stbi__err("can't merge dc and ac")) as i32);
    }
    if (*j).code_bits < 16 {
        stbi__grow_buffer_unsafe(j);
    }
    if (*j).succ_high == 0 {
        c_runtime::memset(
            ((data) as *mut u8),
            0,
            ((64) as u64) * std::mem::size_of::<i16>() as u64,
        );
        t = ((stbi__jpeg_huff_decode(j, hdc)) as i32);
        if t < 0 || t > 15 {
            return ((stbi__err("can't merge dc and ac")) as i32);
        }
        diff = ((if (t) != 0 {
            stbi__extend_receive(j, t)
        } else {
            0
        }) as i32);
        dc = (((*j).img_comp[(b) as usize].dc_pred + diff) as i32);
        (*j).img_comp[(b) as usize].dc_pred = ((dc) as i32);
        *data.offset(0) = ((dc * (1 << (*j).succ_low)) as i16);
    } else {
        if (stbi__jpeg_get_bit(j)) != 0 {
            *data.offset(0) += ((((1 << (*j).succ_low) as i16) as i32) as i16);
        }
    }
    return ((1) as i32);
}

pub unsafe fn stbi__jpeg_dequantize(mut data: *mut i16, mut dequant: *mut u16) {
    let mut i: i32 = 0;
    i = ((0) as i32);
    while (i < 64) {
        *data.offset((i) as isize) *= (((*dequant.offset((i) as isize)) as i32) as i16);
        c_runtime::preInc(&mut i);
    }
}

pub unsafe fn stbi__jpeg_finish(mut z: *mut stbi__jpeg) {
    if ((*z).progressive) != 0 {
        let mut i: i32 = 0;
        let mut j: i32 = 0;
        let mut n: i32 = 0;
        n = ((0) as i32);
        while (n < (*(*z).s).img_n) {
            let mut w: i32 = ((*z).img_comp[(n) as usize].x + 7) >> 3;
            let mut h: i32 = ((*z).img_comp[(n) as usize].y + 7) >> 3;
            j = ((0) as i32);
            while (j < h) {
                i = ((0) as i32);
                while (i < w) {
                    let mut data: *mut i16 = ((*z).img_comp[(n) as usize].coeff)
                        .offset((64 * (i + j * (*z).img_comp[(n) as usize].coeff_w)) as isize);
                    stbi__jpeg_dequantize(
                        data,
                        ((*z).dequant[((*z).img_comp[(n) as usize].tq) as usize]).as_mut_ptr(),
                    );
                    ((*z).idct_block_kernel.unwrap())(
                        (((*z).img_comp[(n) as usize].data)
                            .offset(((*z).img_comp[(n) as usize].w2 * j * 8) as isize))
                        .offset((i * 8) as isize),
                        (*z).img_comp[(n) as usize].w2,
                        data,
                    );
                    c_runtime::preInc(&mut i);
                }
                c_runtime::preInc(&mut j);
            }
            c_runtime::preInc(&mut n);
        }
    }
}

pub unsafe fn stbi__jpeg_get_bit(mut j: *mut stbi__jpeg) -> i32 {
    let mut k: u32 = 0;
    if (*j).code_bits < 1 {
        stbi__grow_buffer_unsafe(j);
    }
    k = (((*j).code_buffer) as u32);
    (*j).code_buffer <<= 1;
    c_runtime::preDec(&mut (*j).code_bits);
    return ((k & 0x80000000) as i32);
}

pub unsafe fn stbi__jpeg_get_bits(mut j: *mut stbi__jpeg, mut n: i32) -> i32 {
    let mut k: u32 = 0;
    if (*j).code_bits < n {
        stbi__grow_buffer_unsafe(j);
    }
    k = ((c_runtime::_lrotl((*j).code_buffer, n)) as u32);
    (*j).code_buffer = ((k & !stbi__bmask[(n) as usize]) as u32);
    k &= ((stbi__bmask[(n) as usize]) as u32);
    (*j).code_bits -= ((n) as i32);
    return ((k) as i32);
}

pub unsafe fn stbi__jpeg_huff_decode(mut j: *mut stbi__jpeg, mut h: *mut stbi__huffman) -> i32 {
    let mut temp: u32 = 0;
    let mut c: i32 = 0;
    let mut k: i32 = 0;
    if (*j).code_bits < 16 {
        stbi__grow_buffer_unsafe(j);
    }
    c = ((((*j).code_buffer >> (32 - 9)) & (((1 << 9) - 1) as u32)) as i32);
    k = (((*h).fast[(c) as usize]) as i32);
    if k < 255 {
        let mut s: i32 = (((*h).size[(k) as usize]) as i32);
        if s > (*j).code_bits {
            return ((-1) as i32);
        }
        (*j).code_buffer <<= s;
        (*j).code_bits -= ((s) as i32);
        return (((*h).values[(k) as usize]) as i32);
    }
    temp = (((*j).code_buffer >> 16) as u32);
    k = ((9 + 1) as i32);
    while (true) {
        if temp < (*h).maxcode[(k) as usize] {
            break;
        }
        c_runtime::preInc(&mut k);
    }
    if k == 17 {
        (*j).code_bits -= ((16) as i32);
        return ((-1) as i32);
    }
    if k > (*j).code_bits {
        return ((-1) as i32);
    }

    let a = (((*j).code_buffer >> (32 - k)) & stbi__bmask[(k) as usize]) as i32;
    let b = ((*h).delta[(k) as usize]) as i32;
    c = a + b;

    (*j).code_bits -= ((k) as i32);
    (*j).code_buffer <<= k;
    return (((*h).values[(c) as usize]) as i32);
}

pub unsafe fn stbi__jpeg_info(
    mut s: *mut stbi__context,
    mut x: *mut i32,
    mut y: *mut i32,
    mut comp: *mut i32,
) -> i32 {
    let mut result: i32 = 0;
    let mut j: *mut stbi__jpeg =
        ((stbi__malloc(std::mem::size_of::<stbi__jpeg>() as u64)) as *mut stbi__jpeg);
    if j == std::ptr::null_mut() {
        return ((stbi__err("outofmem")) as i32);
    }
    (*j).s = s;
    result = ((stbi__jpeg_info_raw(j, x, y, comp)) as i32);
    c_runtime::free(((j) as *mut u8));
    return ((result) as i32);
}

pub unsafe fn stbi__jpeg_info_raw(
    mut j: *mut stbi__jpeg,
    mut x: *mut i32,
    mut y: *mut i32,
    mut comp: *mut i32,
) -> i32 {
    if stbi__decode_jpeg_header(j, STBI__SCAN_header) == 0 {
        stbi__rewind((*j).s);
        return ((0) as i32);
    }
    if (x) != std::ptr::null_mut() {
        *x = (((*(*j).s).img_x) as i32);
    }
    if (y) != std::ptr::null_mut() {
        *y = (((*(*j).s).img_y) as i32);
    }
    if (comp) != std::ptr::null_mut() {
        *comp = ((if (*(*j).s).img_n >= 3 { 3 } else { 1 }) as i32);
    }
    return ((1) as i32);
}

pub unsafe fn stbi__jpeg_load(
    mut s: *mut stbi__context,
    mut x: *mut i32,
    mut y: *mut i32,
    mut comp: *mut i32,
    mut req_comp: i32,
    mut ri: *mut stbi__result_info,
) -> *mut u8 {
    let mut result: *mut u8 = std::ptr::null_mut();
    let mut j: *mut stbi__jpeg =
        ((stbi__malloc(std::mem::size_of::<stbi__jpeg>() as u64)) as *mut stbi__jpeg);
    if j == std::ptr::null_mut() {
        return (((if (stbi__err("outofmem")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }

    (*j).s = s;
    stbi__setup_jpeg(j);
    result = load_jpeg_image(j, x, y, comp, req_comp);
    c_runtime::free(((j) as *mut u8));
    return result;
}

pub unsafe fn stbi__jpeg_reset(mut j: *mut stbi__jpeg) {
    (*j).code_bits = ((0) as i32);
    (*j).code_buffer = ((0) as u32);
    (*j).nomore = ((0) as i32);
    let hebron_tmp3 = 0;
    (*j).img_comp[(0) as usize].dc_pred = hebron_tmp3;
    (*j).img_comp[(1) as usize].dc_pred = hebron_tmp3;
    (*j).img_comp[(2) as usize].dc_pred = hebron_tmp3;
    (*j).img_comp[(3) as usize].dc_pred = hebron_tmp3;
    (*j).marker = ((0xff) as u8);
    (*j).todo = ((if ((*j).restart_interval) != 0 {
        (*j).restart_interval
    } else {
        0x7fffffff
    }) as i32);
    (*j).eob_run = ((0) as i32);
}

pub unsafe fn stbi__jpeg_test(mut s: *mut stbi__context) -> i32 {
    let mut r: i32 = 0;
    let mut j: *mut stbi__jpeg =
        ((stbi__malloc(std::mem::size_of::<stbi__jpeg>() as u64)) as *mut stbi__jpeg);
    if j == std::ptr::null_mut() {
        return ((stbi__err("outofmem")) as i32);
    }
    (*j).s = s;
    stbi__setup_jpeg(j);
    r = ((stbi__decode_jpeg_header(j, STBI__SCAN_type)) as i32);
    stbi__rewind(s);
    c_runtime::free(((j) as *mut u8));
    return ((r) as i32);
}

pub unsafe fn stbi__parse_entropy_coded_data(mut z: *mut stbi__jpeg) -> i32 {
    stbi__jpeg_reset(z);
    if (*z).progressive == 0 {
        if (*z).scan_n == 1 {
            let mut i: i32 = 0;
            let mut j: i32 = 0;
            let mut data: [i16; 64] = [0; 64];
            let mut n: i32 = (*z).order[(0) as usize];
            let mut w: i32 = ((*z).img_comp[(n) as usize].x + 7) >> 3;
            let mut h: i32 = ((*z).img_comp[(n) as usize].y + 7) >> 3;
            j = ((0) as i32);
            while (j < h) {
                i = ((0) as i32);
                while (i < w) {
                    let mut ha: i32 = (*z).img_comp[(n) as usize].ha;
                    if stbi__jpeg_decode_block(
                        z,
                        ((data.as_mut_ptr()) as *mut i16),
                        ((*z).huff_dc)
                            .as_mut_ptr()
                            .offset(((*z).img_comp[(n) as usize].hd) as isize),
                        ((*z).huff_ac).as_mut_ptr().offset((ha) as isize),
                        ((*z).fast_ac[(ha) as usize]).as_mut_ptr(),
                        n,
                        ((*z).dequant[((*z).img_comp[(n) as usize].tq) as usize]).as_mut_ptr(),
                    ) == 0
                    {
                        return ((0) as i32);
                    }
                    ((*z).idct_block_kernel.unwrap())(
                        (((*z).img_comp[(n) as usize].data)
                            .offset(((*z).img_comp[(n) as usize].w2 * j * 8) as isize))
                        .offset((i * 8) as isize),
                        (*z).img_comp[(n) as usize].w2,
                        ((data.as_mut_ptr()) as *mut i16),
                    );
                    if c_runtime::preDec(&mut (*z).todo) <= 0 {
                        if (*z).code_bits < 24 {
                            stbi__grow_buffer_unsafe(z);
                        }
                        if !((((*z).marker) as i32) >= 0xd0 && (((*z).marker) as i32) <= 0xd7) {
                            return ((1) as i32);
                        }
                        stbi__jpeg_reset(z);
                    }
                    c_runtime::preInc(&mut i);
                }
                c_runtime::preInc(&mut j);
            }
            return ((1) as i32);
        } else {
            let mut i: i32 = 0;
            let mut j: i32 = 0;
            let mut k: i32 = 0;
            let mut x: i32 = 0;
            let mut y: i32 = 0;
            let mut data: [i16; 64] = [0; 64];
            j = ((0) as i32);
            while (j < (*z).img_mcu_y) {
                i = ((0) as i32);
                while (i < (*z).img_mcu_x) {
                    k = ((0) as i32);
                    while (k < (*z).scan_n) {
                        let mut n: i32 = (*z).order[(k) as usize];
                        y = ((0) as i32);
                        while (y < (*z).img_comp[(n) as usize].v) {
                            x = ((0) as i32);
                            while (x < (*z).img_comp[(n) as usize].h) {
                                let mut x2: i32 = (i * (*z).img_comp[(n) as usize].h + x) * 8;
                                let mut y2: i32 = (j * (*z).img_comp[(n) as usize].v + y) * 8;
                                let mut ha: i32 = (*z).img_comp[(n) as usize].ha;
                                if stbi__jpeg_decode_block(
                                    z,
                                    ((data.as_mut_ptr()) as *mut i16),
                                    ((*z).huff_dc)
                                        .as_mut_ptr()
                                        .offset(((*z).img_comp[(n) as usize].hd) as isize),
                                    ((*z).huff_ac).as_mut_ptr().offset((ha) as isize),
                                    ((*z).fast_ac[(ha) as usize]).as_mut_ptr(),
                                    n,
                                    ((*z).dequant[((*z).img_comp[(n) as usize].tq) as usize])
                                        .as_mut_ptr(),
                                ) == 0
                                {
                                    return ((0) as i32);
                                }
                                ((*z).idct_block_kernel.unwrap())(
                                    (((*z).img_comp[(n) as usize].data)
                                        .offset(((*z).img_comp[(n) as usize].w2 * y2) as isize))
                                    .offset((x2) as isize),
                                    (*z).img_comp[(n) as usize].w2,
                                    ((data.as_mut_ptr()) as *mut i16),
                                );
                                c_runtime::preInc(&mut x);
                            }
                            c_runtime::preInc(&mut y);
                        }
                        c_runtime::preInc(&mut k);
                    }
                    if c_runtime::preDec(&mut (*z).todo) <= 0 {
                        if (*z).code_bits < 24 {
                            stbi__grow_buffer_unsafe(z);
                        }
                        if !((((*z).marker) as i32) >= 0xd0 && (((*z).marker) as i32) <= 0xd7) {
                            return ((1) as i32);
                        }
                        stbi__jpeg_reset(z);
                    }
                    c_runtime::preInc(&mut i);
                }
                c_runtime::preInc(&mut j);
            }
            return ((1) as i32);
        }
    } else {
        if (*z).scan_n == 1 {
            let mut i: i32 = 0;
            let mut j: i32 = 0;
            let mut n: i32 = (*z).order[(0) as usize];
            let mut w: i32 = ((*z).img_comp[(n) as usize].x + 7) >> 3;
            let mut h: i32 = ((*z).img_comp[(n) as usize].y + 7) >> 3;
            j = ((0) as i32);
            while (j < h) {
                i = ((0) as i32);
                while (i < w) {
                    let mut data: *mut i16 = ((*z).img_comp[(n) as usize].coeff)
                        .offset((64 * (i + j * (*z).img_comp[(n) as usize].coeff_w)) as isize);
                    if (*z).spec_start == 0 {
                        if stbi__jpeg_decode_block_prog_dc(
                            z,
                            data,
                            ((&mut (*z).huff_dc[((*z).img_comp[(n) as usize].hd) as usize])
                                as *mut stbi__huffman),
                            n,
                        ) == 0
                        {
                            return ((0) as i32);
                        }
                    } else {
                        let mut ha: i32 = (*z).img_comp[(n) as usize].ha;
                        if stbi__jpeg_decode_block_prog_ac(
                            z,
                            data,
                            ((&mut (*z).huff_ac[(ha) as usize]) as *mut stbi__huffman),
                            ((*z).fast_ac[(ha) as usize]).as_mut_ptr(),
                        ) == 0
                        {
                            return ((0) as i32);
                        }
                    }
                    if c_runtime::preDec(&mut (*z).todo) <= 0 {
                        if (*z).code_bits < 24 {
                            stbi__grow_buffer_unsafe(z);
                        }
                        if !((((*z).marker) as i32) >= 0xd0 && (((*z).marker) as i32) <= 0xd7) {
                            return ((1) as i32);
                        }
                        stbi__jpeg_reset(z);
                    }
                    c_runtime::preInc(&mut i);
                }
                c_runtime::preInc(&mut j);
            }
            return ((1) as i32);
        } else {
            let mut i: i32 = 0;
            let mut j: i32 = 0;
            let mut k: i32 = 0;
            let mut x: i32 = 0;
            let mut y: i32 = 0;
            j = ((0) as i32);
            while (j < (*z).img_mcu_y) {
                i = ((0) as i32);
                while (i < (*z).img_mcu_x) {
                    k = ((0) as i32);
                    while (k < (*z).scan_n) {
                        let mut n: i32 = (*z).order[(k) as usize];
                        y = ((0) as i32);
                        while (y < (*z).img_comp[(n) as usize].v) {
                            x = ((0) as i32);
                            while (x < (*z).img_comp[(n) as usize].h) {
                                let mut x2: i32 = (i * (*z).img_comp[(n) as usize].h + x);
                                let mut y2: i32 = (j * (*z).img_comp[(n) as usize].v + y);
                                let mut data: *mut i16 = ((*z).img_comp[(n) as usize].coeff)
                                    .offset(
                                        (64 * (x2 + y2 * (*z).img_comp[(n) as usize].coeff_w))
                                            as isize,
                                    );
                                if stbi__jpeg_decode_block_prog_dc(
                                    z,
                                    data,
                                    ((&mut (*z).huff_dc[((*z).img_comp[(n) as usize].hd) as usize])
                                        as *mut stbi__huffman),
                                    n,
                                ) == 0
                                {
                                    return ((0) as i32);
                                }
                                c_runtime::preInc(&mut x);
                            }
                            c_runtime::preInc(&mut y);
                        }
                        c_runtime::preInc(&mut k);
                    }
                    if c_runtime::preDec(&mut (*z).todo) <= 0 {
                        if (*z).code_bits < 24 {
                            stbi__grow_buffer_unsafe(z);
                        }
                        if !((((*z).marker) as i32) >= 0xd0 && (((*z).marker) as i32) <= 0xd7) {
                            return ((1) as i32);
                        }
                        stbi__jpeg_reset(z);
                    }
                    c_runtime::preInc(&mut i);
                }
                c_runtime::preInc(&mut j);
            }
            return ((1) as i32);
        }
    }
}

pub unsafe fn stbi__process_frame_header(mut z: *mut stbi__jpeg, mut scan: i32) -> i32 {
    let mut s: *mut stbi__context = (*z).s;
    let mut Lf: i32 = 0;
    let mut p: i32 = 0;
    let mut i: i32 = 0;
    let mut q: i32 = 0;
    let mut h_max: i32 = 1;
    let mut v_max: i32 = 1;
    let mut c: i32 = 0;
    Lf = ((stbi__get16be(s)) as i32);
    if Lf < 11 {
        return ((stbi__err("bad SOF len")) as i32);
    }
    p = ((stbi__get8(s)) as i32);
    if p != 8 {
        return ((stbi__err("only 8-bit")) as i32);
    }
    (*s).img_y = ((stbi__get16be(s)) as u32);
    if (*s).img_y == ((0) as u32) {
        return ((stbi__err("no header height")) as i32);
    }
    (*s).img_x = ((stbi__get16be(s)) as u32);
    if (*s).img_x == ((0) as u32) {
        return ((stbi__err("0 width")) as i32);
    }
    if (*s).img_y > ((1 << 24) as u32) {
        return ((stbi__err("too large")) as i32);
    }
    if (*s).img_x > ((1 << 24) as u32) {
        return ((stbi__err("too large")) as i32);
    }
    c = ((stbi__get8(s)) as i32);
    if c != 3 && c != 1 && c != 4 {
        return ((stbi__err("bad component count")) as i32);
    }
    (*s).img_n = ((c) as i32);
    i = ((0) as i32);
    while (i < c) {
        (*z).img_comp[(i) as usize].data = std::ptr::null_mut();
        (*z).img_comp[(i) as usize].linebuf = std::ptr::null_mut();
        c_runtime::preInc(&mut i);
    }
    if Lf != 8 + 3 * (*s).img_n {
        return ((stbi__err("bad SOF len")) as i32);
    }
    (*z).rgb = ((0) as i32);
    i = ((0) as i32);
    while (i < (*s).img_n) {
        (*z).img_comp[(i) as usize].id = ((stbi__get8(s)) as i32);
        if (*s).img_n == 3
            && (*z).img_comp[(i) as usize].id
                == ((stbi__process_frame_header_rgb[(i) as usize]) as i32)
        {
            c_runtime::preInc(&mut (*z).rgb);
        }
        q = ((stbi__get8(s)) as i32);
        (*z).img_comp[(i) as usize].h = ((q >> 4) as i32);
        if (*z).img_comp[(i) as usize].h == 0 || (*z).img_comp[(i) as usize].h > 4 {
            return ((stbi__err("bad H")) as i32);
        }
        (*z).img_comp[(i) as usize].v = ((q & 15) as i32);
        if (*z).img_comp[(i) as usize].v == 0 || (*z).img_comp[(i) as usize].v > 4 {
            return ((stbi__err("bad V")) as i32);
        }
        (*z).img_comp[(i) as usize].tq = ((stbi__get8(s)) as i32);
        if (*z).img_comp[(i) as usize].tq > 3 {
            return ((stbi__err("bad TQ")) as i32);
        }
        c_runtime::preInc(&mut i);
    }
    if scan != STBI__SCAN_load {
        return ((1) as i32);
    }
    if stbi__mad3sizes_valid((((*s).img_x) as i32), (((*s).img_y) as i32), (*s).img_n, 0) == 0 {
        return ((stbi__err("too large")) as i32);
    }
    i = ((0) as i32);
    while (i < (*s).img_n) {
        if (*z).img_comp[(i) as usize].h > h_max {
            h_max = (((*z).img_comp[(i) as usize].h) as i32);
        }
        if (*z).img_comp[(i) as usize].v > v_max {
            v_max = (((*z).img_comp[(i) as usize].v) as i32);
        }
        c_runtime::preInc(&mut i);
    }
    i = ((0) as i32);
    while (i < (*s).img_n) {
        if h_max % (*z).img_comp[(i) as usize].h != 0 {
            return ((stbi__err("bad H")) as i32);
        }
        if v_max % (*z).img_comp[(i) as usize].v != 0 {
            return ((stbi__err("bad V")) as i32);
        }
        c_runtime::preInc(&mut i);
    }
    (*z).img_h_max = ((h_max) as i32);
    (*z).img_v_max = ((v_max) as i32);
    (*z).img_mcu_w = ((h_max * 8) as i32);
    (*z).img_mcu_h = ((v_max * 8) as i32);
    (*z).img_mcu_x = ((((*s).img_x + (((*z).img_mcu_w) as u32) - ((1) as u32))
        / (((*z).img_mcu_w) as u32)) as i32);
    (*z).img_mcu_y = ((((*s).img_y + (((*z).img_mcu_h) as u32) - ((1) as u32))
        / (((*z).img_mcu_h) as u32)) as i32);
    i = ((0) as i32);
    while (i < (*s).img_n) {
        (*z).img_comp[(i) as usize].x = ((((*s).img_x * (((*z).img_comp[(i) as usize].h) as u32)
            + ((h_max) as u32)
            - ((1) as u32))
            / ((h_max) as u32)) as i32);
        (*z).img_comp[(i) as usize].y = ((((*s).img_y * (((*z).img_comp[(i) as usize].v) as u32)
            + ((v_max) as u32)
            - ((1) as u32))
            / ((v_max) as u32)) as i32);
        (*z).img_comp[(i) as usize].w2 =
            (((*z).img_mcu_x * (*z).img_comp[(i) as usize].h * 8) as i32);
        (*z).img_comp[(i) as usize].h2 =
            (((*z).img_mcu_y * (*z).img_comp[(i) as usize].v * 8) as i32);
        (*z).img_comp[(i) as usize].coeff = ((std::ptr::null_mut()) as *mut i16);
        (*z).img_comp[(i) as usize].raw_coeff = std::ptr::null_mut();
        (*z).img_comp[(i) as usize].linebuf = std::ptr::null_mut();
        (*z).img_comp[(i) as usize].raw_data = stbi__malloc_mad2(
            (*z).img_comp[(i) as usize].w2,
            (*z).img_comp[(i) as usize].h2,
            15,
        );
        if (*z).img_comp[(i) as usize].raw_data == std::ptr::null_mut() {
            return stbi__free_jpeg_components(z, i + 1, ((stbi__err("outofmem")) as i32));
        }
        (*z).img_comp[(i) as usize].data = ((((((*z).img_comp[(i) as usize].raw_data) as u64)
            + ((15) as u64))
            & ((!15) as u64)) as *mut u8);
        if ((*z).progressive) != 0 {
            (*z).img_comp[(i) as usize].coeff_w = (((*z).img_comp[(i) as usize].w2 / 8) as i32);
            (*z).img_comp[(i) as usize].coeff_h = (((*z).img_comp[(i) as usize].h2 / 8) as i32);
            (*z).img_comp[(i) as usize].raw_coeff = stbi__malloc_mad3(
                (*z).img_comp[(i) as usize].w2,
                (*z).img_comp[(i) as usize].h2,
                ((std::mem::size_of::<i16>() as u64) as i32),
                15,
            );
            if (*z).img_comp[(i) as usize].raw_coeff == std::ptr::null_mut() {
                return stbi__free_jpeg_components(z, i + 1, ((stbi__err("outofmem")) as i32));
            }
            (*z).img_comp[(i) as usize].coeff =
                ((((((*z).img_comp[(i) as usize].raw_coeff) as u64) + ((15) as u64))
                    & ((!15) as u64)) as *mut i16);
        }
        c_runtime::preInc(&mut i);
    }
    return ((1) as i32);
}

pub unsafe fn stbi__process_marker(mut z: *mut stbi__jpeg, mut m: i32) -> i32 {
    let mut L: i32 = 0;
    {
        if m == 0xff {
            return ((stbi__err("expected marker")) as i32);
        } else if m == 0xDD {
            if stbi__get16be((*z).s) != 4 {
                return ((stbi__err("bad DRI len")) as i32);
            }
            (*z).restart_interval = ((stbi__get16be((*z).s)) as i32);
            return ((1) as i32);
        } else if m == 0xDB {
            L = ((stbi__get16be((*z).s) - 2) as i32);
            while (L > 0) {
                let mut q: i32 = ((stbi__get8((*z).s)) as i32);
                let mut p: i32 = q >> 4;
                let mut sixteen: i32 = if (p != 0) { 1 } else { 0 };
                let mut t: i32 = q & 15;
                let mut i: i32 = 0;
                if p != 0 && p != 1 {
                    return ((stbi__err("bad DQT type")) as i32);
                }
                if t > 3 {
                    return ((stbi__err("bad DQT table")) as i32);
                }
                i = ((0) as i32);
                while (i < 64) {
                    (*z).dequant[(t) as usize][(stbi__jpeg_dezigzag[(i) as usize]) as usize] =
                        ((if (sixteen) != 0 {
                            stbi__get16be((*z).s)
                        } else {
                            ((stbi__get8((*z).s)) as i32)
                        }) as u16);
                    c_runtime::preInc(&mut i);
                }
                L -= ((if (sixteen) != 0 { 129 } else { 65 }) as i32);
            }
            return ((if L == 0 { 1 } else { 0 }) as i32);
        } else if m == 0xC4 {
            L = ((stbi__get16be((*z).s) - 2) as i32);
            while (L > 0) {
                let mut v: *mut u8 = std::ptr::null_mut();
                let mut sizes: [i32; 16] = [0; 16];
                let mut i: i32 = 0;
                let mut n: i32 = 0;
                let mut q: i32 = ((stbi__get8((*z).s)) as i32);
                let mut tc: i32 = q >> 4;
                let mut th: i32 = q & 15;
                if tc > 1 || th > 3 {
                    return ((stbi__err("bad DHT header")) as i32);
                }
                i = ((0) as i32);
                while (i < 16) {
                    sizes[(i) as usize] = ((stbi__get8((*z).s)) as i32);
                    n += ((sizes[(i) as usize]) as i32);
                    c_runtime::preInc(&mut i);
                }
                L -= ((17) as i32);
                if tc == 0 {
                    if stbi__build_huffman(
                        ((*z).huff_dc).as_mut_ptr().offset((th) as isize),
                        ((sizes.as_mut_ptr()) as *mut i32),
                    ) == 0
                    {
                        return ((0) as i32);
                    }
                    v = (*z).huff_dc[(th) as usize].values.as_mut_ptr();
                } else {
                    if stbi__build_huffman(
                        ((*z).huff_ac).as_mut_ptr().offset((th) as isize),
                        ((sizes.as_mut_ptr()) as *mut i32),
                    ) == 0
                    {
                        return ((0) as i32);
                    }
                    v = (*z).huff_ac[(th) as usize].values.as_mut_ptr();
                }
                i = ((0) as i32);
                while (i < n) {
                    *v.offset((i) as isize) = ((stbi__get8((*z).s)) as u8);
                    c_runtime::preInc(&mut i);
                }
                if tc != 0 {
                    stbi__build_fast_ac(
                        ((*z).fast_ac[(th) as usize]).as_mut_ptr(),
                        ((*z).huff_ac).as_mut_ptr().offset((th) as isize),
                    );
                }
                L -= ((n) as i32);
            }
            return ((if L == 0 { 1 } else { 0 }) as i32);
        }
    }
    if (m >= 0xE0 && m <= 0xEF) || m == 0xFE {
        L = ((stbi__get16be((*z).s)) as i32);
        if L < 2 {
            if m == 0xFE {
                return ((stbi__err("bad COM len")) as i32);
            } else {
                return ((stbi__err("bad APP len")) as i32);
            }
        }
        L -= ((2) as i32);
        if m == 0xE0 && L >= 5 {
            let mut ok: i32 = 1;
            let mut i: i32 = 0;
            i = ((0) as i32);
            while (i < 5) {
                if ((stbi__get8((*z).s)) as i32)
                    != ((stbi__process_marker_tag[(i) as usize]) as i32)
                {
                    ok = ((0) as i32);
                }
                c_runtime::preInc(&mut i);
            }
            L -= ((5) as i32);
            if (ok) != 0 {
                (*z).jfif = ((1) as i32);
            }
        } else {
            if m == 0xEE && L >= 12 {
                let mut ok: i32 = 1;
                let mut i: i32 = 0;
                i = ((0) as i32);
                while (i < 6) {
                    if ((stbi__get8((*z).s)) as i32)
                        != ((stbi__process_marker_tag[(i) as usize]) as i32)
                    {
                        ok = ((0) as i32);
                    }
                    c_runtime::preInc(&mut i);
                }
                L -= ((6) as i32);
                if (ok) != 0 {
                    stbi__get8((*z).s);
                    stbi__get16be((*z).s);
                    stbi__get16be((*z).s);
                    (*z).app14_color_transform = ((stbi__get8((*z).s)) as i32);
                    L -= ((6) as i32);
                }
            }
        }
        stbi__skip((*z).s, L);
        return ((1) as i32);
    }
    return ((stbi__err("unknown marker")) as i32);
}

pub unsafe fn stbi__process_scan_header(mut z: *mut stbi__jpeg) -> i32 {
    let mut i: i32 = 0;
    let mut Ls: i32 = stbi__get16be((*z).s);
    (*z).scan_n = ((stbi__get8((*z).s)) as i32);
    if (*z).scan_n < 1 || (*z).scan_n > 4 || (*z).scan_n > (*(*z).s).img_n {
        return ((stbi__err("bad SOS component count")) as i32);
    }
    if Ls != 6 + 2 * (*z).scan_n {
        return ((stbi__err("bad SOS len")) as i32);
    }
    i = ((0) as i32);
    while (i < (*z).scan_n) {
        let mut id: i32 = ((stbi__get8((*z).s)) as i32);
        let mut which: i32 = 0;
        let mut q: i32 = ((stbi__get8((*z).s)) as i32);
        which = ((0) as i32);
        while (which < (*(*z).s).img_n) {
            if (*z).img_comp[(which) as usize].id == id {
                break;
            }
            c_runtime::preInc(&mut which);
        }
        if which == (*(*z).s).img_n {
            return ((0) as i32);
        }
        (*z).img_comp[(which) as usize].hd = ((q >> 4) as i32);
        if (*z).img_comp[(which) as usize].hd > 3 {
            return ((stbi__err("bad DC huff")) as i32);
        }
        (*z).img_comp[(which) as usize].ha = ((q & 15) as i32);
        if (*z).img_comp[(which) as usize].ha > 3 {
            return ((stbi__err("bad AC huff")) as i32);
        }
        (*z).order[(i) as usize] = ((which) as i32);
        c_runtime::preInc(&mut i);
    }
    {
        let mut aa: i32 = 0;
        (*z).spec_start = ((stbi__get8((*z).s)) as i32);
        (*z).spec_end = ((stbi__get8((*z).s)) as i32);
        aa = ((stbi__get8((*z).s)) as i32);
        (*z).succ_high = ((aa >> 4) as i32);
        (*z).succ_low = ((aa & 15) as i32);
        if ((*z).progressive) != 0 {
            if (*z).spec_start > 63
                || (*z).spec_end > 63
                || (*z).spec_start > (*z).spec_end
                || (*z).succ_high > 13
                || (*z).succ_low > 13
            {
                return ((stbi__err("bad SOS")) as i32);
            }
        } else {
            if (*z).spec_start != 0 {
                return ((stbi__err("bad SOS")) as i32);
            }
            if (*z).succ_high != 0 || (*z).succ_low != 0 {
                return ((stbi__err("bad SOS")) as i32);
            }
            (*z).spec_end = ((63) as i32);
        }
    }

    return ((1) as i32);
}

pub unsafe fn stbi__resample_row_generic(
    mut out: *mut u8,
    mut in_near: *mut u8,
    mut in_far: *mut u8,
    mut w: i32,
    mut hs: i32,
) -> *mut u8 {
    let mut i: i32 = 0;
    let mut j: i32 = 0;

    i = ((0) as i32);
    while (i < w) {
        j = ((0) as i32);
        while (j < hs) {
            *out.offset((i * hs + j) as isize) = ((*in_near.offset((i) as isize)) as u8);
            c_runtime::preInc(&mut j);
        }
        c_runtime::preInc(&mut i);
    }
    return out;
}

pub unsafe fn stbi__resample_row_h_2(
    mut out: *mut u8,
    mut in_near: *mut u8,
    mut in_far: *mut u8,
    mut w: i32,
    mut hs: i32,
) -> *mut u8 {
    let mut i: i32 = 0;
    let mut input: *mut u8 = in_near;
    if w == 1 {
        let hebron_tmp0 = *input.offset((0) as isize);
        *out.offset((0) as isize) = hebron_tmp0;
        *out.offset((1) as isize) = hebron_tmp0;
        return out;
    }
    *out.offset((0) as isize) = ((*input.offset((0) as isize)) as u8);
    *out.offset((1) as isize) =
        (((((*input.offset((0) as isize)) as i32) * 3 + ((*input.offset((1) as isize)) as i32) + 2)
            >> 2) as u8);
    i = ((1) as i32);
    while (i < w - 1) {
        let mut n: i32 = 3 * ((*input.offset((i) as isize)) as i32) + 2;
        *out.offset((i * 2 + 0) as isize) =
            (((n + ((*input.offset((i - 1) as isize)) as i32)) >> 2) as u8);
        *out.offset((i * 2 + 1) as isize) =
            (((n + ((*input.offset((i + 1) as isize)) as i32)) >> 2) as u8);
        c_runtime::preInc(&mut i);
    }
    *out.offset((i * 2 + 0) as isize) = (((((*input.offset((w - 2) as isize)) as i32) * 3
        + ((*input.offset((w - 1) as isize)) as i32)
        + 2)
        >> 2) as u8);
    *out.offset((i * 2 + 1) as isize) = ((*input.offset((w - 1) as isize)) as u8);

    return out;
}

pub unsafe fn stbi__resample_row_hv_2(
    mut out: *mut u8,
    mut in_near: *mut u8,
    mut in_far: *mut u8,
    mut w: i32,
    mut hs: i32,
) -> *mut u8 {
    let mut i: i32 = 0;
    let mut t0: i32 = 0;
    let mut t1: i32 = 0;
    if w == 1 {
        let hebron_tmp0 = (((3 * ((*in_near.offset((0) as isize)) as i32)
            + ((*in_far.offset((0) as isize)) as i32)
            + 2)
            >> 2) as u8);
        *out.offset((0) as isize) = hebron_tmp0;
        *out.offset((1) as isize) = hebron_tmp0;
        return out;
    }
    t1 = (3 * ((*in_near.offset((0) as isize)) as i32) + ((*in_far.offset((0) as isize)) as i32));
    *out.offset((0) as isize) = (((t1 + 2) >> 2) as u8);
    i = ((1) as i32);
    while (i < w) {
        t0 = ((t1) as i32);
        t1 = (3 * ((*in_near.offset((i) as isize)) as i32)
            + ((*in_far.offset((i) as isize)) as i32));
        *out.offset((i * 2 - 1) as isize) = (((3 * t0 + t1 + 8) >> 4) as u8);
        *out.offset((i * 2) as isize) = (((3 * t1 + t0 + 8) >> 4) as u8);
        c_runtime::preInc(&mut i);
    }
    *out.offset((w * 2 - 1) as isize) = (((t1 + 2) >> 2) as u8);

    return out;
}

pub unsafe fn stbi__resample_row_v_2(
    mut out: *mut u8,
    mut in_near: *mut u8,
    mut in_far: *mut u8,
    mut w: i32,
    mut hs: i32,
) -> *mut u8 {
    let mut i: i32 = 0;

    i = ((0) as i32);
    while (i < w) {
        *out.offset((i) as isize) = (((3 * ((*in_near.offset((i) as isize)) as i32)
            + ((*in_far.offset((i) as isize)) as i32)
            + 2)
            >> 2) as u8);
        c_runtime::preInc(&mut i);
    }
    return out;
}

pub unsafe fn stbi__setup_jpeg(mut j: *mut stbi__jpeg) {
    (*j).idct_block_kernel = Some(stbi__idct_block);
    (*j).YCbCr_to_RGB_kernel = Some(stbi__YCbCr_to_RGB_row);
    (*j).resample_row_hv_2_kernel = Some(stbi__resample_row_hv_2);
}

pub unsafe fn stbi__YCbCr_to_RGB_row(
    mut out: *mut u8,
    mut y: *mut u8,
    mut pcb: *mut u8,
    mut pcr: *mut u8,
    mut count: i32,
    mut step: i32,
) {
    let mut i: i32 = 0;
    i = ((0) as i32);
    while (i < count) {
        let mut y_fixed: i32 = (((*y.offset((i) as isize)) as i32) << 20) + (1 << 19);
        let mut r: i32 = 0;
        let mut g: i32 = 0;
        let mut b: i32 = 0;
        let mut cr: i32 = ((*pcr.offset((i) as isize)) as i32) - 128;
        let mut cb: i32 = ((*pcb.offset((i) as isize)) as i32) - 128;
        r = (y_fixed + cr * ((((1.40200f32) * 4096.0f32 + 0.5f32) as i32) << 8));
        g = ((((y_fixed + (cr * -((((0.71414f32) * 4096.0f32 + 0.5f32) as i32) << 8))) as i32)
            + (((cb * -((((0.34414f32) * 4096.0f32 + 0.5f32) as i32) << 8)) as u32) & 0xffff0000)
                as i32) as i32);
        b = (y_fixed + cb * ((((1.77200f32) * 4096.0f32 + 0.5f32) as i32) << 8));
        r >>= 20;
        g >>= 20;
        b >>= 20;
        if ((r) as u32) > ((255) as u32) {
            if r < 0 {
                r = ((0) as i32);
            } else {
                r = ((255) as i32);
            }
        }
        if ((g) as u32) > ((255) as u32) {
            if g < 0 {
                g = ((0) as i32);
            } else {
                g = ((255) as i32);
            }
        }
        if ((b) as u32) > ((255) as u32) {
            if b < 0 {
                b = ((0) as i32);
            } else {
                b = ((255) as i32);
            }
        }
        *out.offset((0) as isize) = ((r) as u8);
        *out.offset((1) as isize) = ((g) as u8);
        *out.offset((2) as isize) = ((b) as u8);
        *out.offset((3) as isize) = ((255) as u8);
        out = out.offset((step) as isize);
        c_runtime::preInc(&mut i);
    }
}
