// Generated by Hebron at 1/1/2022 6:43:55 AM

use crate::*;
use c_runtime;
use std;

#[derive(Debug, Copy, Clone)]
pub struct stbi__gif {
    pub w: i32,
    pub h: i32,
    pub out: *mut u8,
    pub background: *mut u8,
    pub history: *mut u8,
    pub flags: i32,
    pub bgindex: i32,
    pub ratio: i32,
    pub transparent: i32,
    pub eflags: i32,
    pub pal: [[u8; 256]; 4],
    pub lpal: [[u8; 256]; 4],
    pub codes: [stbi__gif_lzw; 8192],
    pub color_table: *mut u8,
    pub parse: i32,
    pub step: i32,
    pub lflags: i32,
    pub start_x: i32,
    pub start_y: i32,
    pub max_x: i32,
    pub max_y: i32,
    pub cur_x: i32,
    pub cur_y: i32,
    pub line_size: i32,
    pub delay: i32,
}

#[derive(Debug, Copy, Clone)]
pub struct stbi__gif_lzw {
    pub prefix: i16,
    pub first: u8,
    pub suffix: u8,
}

impl std::default::Default for stbi__gif {
    fn default() -> Self {
        stbi__gif {
            w: 0,
            h: 0,
            out: std::ptr::null_mut(),
            background: std::ptr::null_mut(),
            history: std::ptr::null_mut(),
            flags: 0,
            bgindex: 0,
            ratio: 0,
            transparent: 0,
            eflags: 0,
            pal: [[0; 256]; 4],
            lpal: [[0; 256]; 4],
            codes: [stbi__gif_lzw::default(); 8192],
            color_table: std::ptr::null_mut(),
            parse: 0,
            step: 0,
            lflags: 0,
            start_x: 0,
            start_y: 0,
            max_x: 0,
            max_y: 0,
            cur_x: 0,
            cur_y: 0,
            line_size: 0,
            delay: 0,
        }
    }
}

impl std::default::Default for stbi__gif_lzw {
    fn default() -> Self {
        stbi__gif_lzw {
            prefix: 0,
            first: 0,
            suffix: 0,
        }
    }
}

pub unsafe fn stbi__gif_header(
    mut s: *mut stbi__context,
    mut g: *mut stbi__gif,
    mut comp: *mut i32,
    mut is_info: i32,
) -> i32 {
    let mut version: u8 = 0;
    if ((stbi__get8(s)) as i32) != 71
        || ((stbi__get8(s)) as i32) != 73
        || ((stbi__get8(s)) as i32) != 70
        || ((stbi__get8(s)) as i32) != 56
    {
        return ((stbi__err("not GIF")) as i32);
    }
    version = ((stbi__get8(s)) as u8);
    if ((version) as i32) != 55 && ((version) as i32) != 57 {
        return ((stbi__err("not GIF")) as i32);
    }
    if ((stbi__get8(s)) as i32) != 97 {
        return ((stbi__err("not GIF")) as i32);
    }
    stbi__g_failure_reason = "";
    (*g).w = ((stbi__get16le(s)) as i32);
    (*g).h = ((stbi__get16le(s)) as i32);
    (*g).flags = ((stbi__get8(s)) as i32);
    (*g).bgindex = ((stbi__get8(s)) as i32);
    (*g).ratio = ((stbi__get8(s)) as i32);
    (*g).transparent = ((-1) as i32);
    if (*g).w > (1 << 24) {
        return ((stbi__err("too large")) as i32);
    }
    if (*g).h > (1 << 24) {
        return ((stbi__err("too large")) as i32);
    }
    if comp != ((std::ptr::null_mut()) as *mut i32) {
        *comp = ((4) as i32);
    }
    if (is_info) != 0 {
        return ((1) as i32);
    }
    if ((*g).flags & 0x80) != 0 {
        stbi__gif_parse_colortable(s, (*g).pal, 2 << ((*g).flags & 7), -1);
    }
    return ((1) as i32);
}

pub unsafe fn stbi__gif_info(
    mut s: *mut stbi__context,
    mut x: *mut i32,
    mut y: *mut i32,
    mut comp: *mut i32,
) -> i32 {
    return ((stbi__gif_info_raw(s, x, y, comp)) as i32);
}

pub unsafe fn stbi__gif_info_raw(
    mut s: *mut stbi__context,
    mut x: *mut i32,
    mut y: *mut i32,
    mut comp: *mut i32,
) -> i32 {
    let mut g: *mut stbi__gif =
        ((stbi__malloc(std::mem::size_of::<stbi__gif>() as u64)) as *mut stbi__gif);
    if g == std::ptr::null_mut() {
        return ((stbi__err("outofmem")) as i32);
    }
    if stbi__gif_header(s, g, comp, 1) == 0 {
        c_runtime::free(((g) as *mut u8));
        stbi__rewind(s);
        return ((0) as i32);
    }
    if (x) != std::ptr::null_mut() {
        *x = (((*g).w) as i32);
    }
    if (y) != std::ptr::null_mut() {
        *y = (((*g).h) as i32);
    }
    c_runtime::free(((g) as *mut u8));
    return ((1) as i32);
}

pub unsafe fn stbi__gif_load(
    mut s: *mut stbi__context,
    mut x: *mut i32,
    mut y: *mut i32,
    mut comp: *mut i32,
    mut req_comp: i32,
    mut ri: *mut stbi__result_info,
) -> *mut u8 {
    let mut u: *mut u8 = ((std::ptr::null_mut()) as *mut u8);
    let mut g: stbi__gif = stbi__gif::default();
    c_runtime::memset(
        (((&mut g) as *mut stbi__gif) as *mut u8),
        0,
        std::mem::size_of::<stbi__gif>() as u64,
    );

    u = stbi__gif_load_next(
        s,
        ((&mut g) as *mut stbi__gif),
        comp,
        req_comp,
        (((std::ptr::null_mut()) as *mut u8) as *mut u8),
    );
    if u == ((s) as *mut u8) {
        u = ((std::ptr::null_mut()) as *mut u8);
    }
    if (u) != std::ptr::null_mut() {
        *x = ((g.w) as i32);
        *y = ((g.h) as i32);
        if (req_comp) != 0 && req_comp != 4 {
            u = stbi__convert_format(u, 4, req_comp, ((g.w) as u32), ((g.h) as u32));
        }
    } else {
        if (g.out) != std::ptr::null_mut() {
            c_runtime::free(g.out);
        }
    }
    c_runtime::free(g.history);
    c_runtime::free(g.background);
    return u;
}

pub unsafe fn stbi__gif_load_next(
    mut s: *mut stbi__context,
    mut g: *mut stbi__gif,
    mut comp: *mut i32,
    mut req_comp: i32,
    mut two_back: *mut u8,
) -> *mut u8 {
    let mut dispose: i32 = 0;
    let mut first_frame: i32 = 0;
    let mut pi: i32 = 0;
    let mut pcount: i32 = 0;

    first_frame = ((0) as i32);
    if (*g).out == ((std::ptr::null_mut()) as *mut u8) {
        if stbi__gif_header(s, g, comp, 0) == 0 {
            return ((std::ptr::null_mut()) as *mut u8);
        }
        if stbi__mad3sizes_valid(4, (*g).w, (*g).h, 0) == 0 {
            return (((if (stbi__err("too large")) != 0 {
                (0)
            } else {
                (0)
            }) as u64) as *mut u8);
        }
        pcount = (((*g).w * (*g).h) as i32);
        (*g).out = stbi__malloc(((4 * pcount) as u64));
        (*g).background = stbi__malloc(((4 * pcount) as u64));
        (*g).history = stbi__malloc(((pcount) as u64));
        if (*g).out == std::ptr::null_mut()
            || (*g).background == std::ptr::null_mut()
            || (*g).history == std::ptr::null_mut()
        {
            return (((if (stbi__err("outofmem")) != 0 {
                (0)
            } else {
                (0)
            }) as u64) as *mut u8);
        }
        c_runtime::memset((*g).out, 0x00, ((4 * pcount) as u64));
        c_runtime::memset((*g).background, 0x00, ((4 * pcount) as u64));
        c_runtime::memset((*g).history, 0x00, ((pcount) as u64));
        first_frame = ((1) as i32);
    } else {
        dispose = ((((*g).eflags & 0x1C) >> 2) as i32);
        pcount = (((*g).w * (*g).h) as i32);
        if (dispose == 3) && (two_back == ((std::ptr::null_mut()) as *mut u8)) {
            dispose = ((2) as i32);
        }
        if dispose == 3 {
            pi = ((0) as i32);
            while (pi < pcount) {
                if (*(*g).history.offset((pi) as isize)) != 0 {
                    c_runtime::memcpy(
                        &mut *(*g).out.offset((pi * 4) as isize),
                        &mut *two_back.offset((pi * 4) as isize),
                        ((4) as u64),
                    );
                }
                c_runtime::preInc(&mut pi);
            }
        } else {
            if dispose == 2 {
                pi = ((0) as i32);
                while (pi < pcount) {
                    if (*(*g).history.offset((pi) as isize)) != 0 {
                        c_runtime::memcpy(
                            &mut *(*g).out.offset((pi * 4) as isize),
                            &mut *(*g).background.offset((pi * 4) as isize),
                            ((4) as u64),
                        );
                    }
                    c_runtime::preInc(&mut pi);
                }
            } else {
            }
        }
        c_runtime::memcpy((*g).background, (*g).out, ((4 * (*g).w * (*g).h) as u64));
    }
    c_runtime::memset((*g).history, 0x00, (((*g).w * (*g).h) as u64));
    while (true) {
        let mut tag: i32 = ((stbi__get8(s)) as i32);
        {
            if tag == 0x2C {
                {
                    let mut x: i32 = 0;
                    let mut y: i32 = 0;
                    let mut w: i32 = 0;
                    let mut h: i32 = 0;
                    let mut o: *mut u8 = std::ptr::null_mut();
                    x = ((stbi__get16le(s)) as i32);
                    y = ((stbi__get16le(s)) as i32);
                    w = ((stbi__get16le(s)) as i32);
                    h = ((stbi__get16le(s)) as i32);
                    if ((x + w) > ((*g).w)) || ((y + h) > ((*g).h)) {
                        return (((if (stbi__err("bad Image Descriptor")) != 0 {
                            (0)
                        } else {
                            (0)
                        }) as u64) as *mut u8);
                    }
                    (*g).line_size = (((*g).w * 4) as i32);
                    (*g).start_x = ((x * 4) as i32);
                    (*g).start_y = ((y * (*g).line_size) as i32);
                    (*g).max_x = (((*g).start_x + w * 4) as i32);
                    (*g).max_y = (((*g).start_y + h * (*g).line_size) as i32);
                    (*g).cur_x = (((*g).start_x) as i32);
                    (*g).cur_y = (((*g).start_y) as i32);
                    if w == 0 {
                        (*g).cur_y = (((*g).max_y) as i32);
                    }
                    (*g).lflags = ((stbi__get8(s)) as i32);
                    if ((*g).lflags & 0x40) != 0 {
                        (*g).step = ((8 * (*g).line_size) as i32);
                        (*g).parse = ((3) as i32);
                    } else {
                        (*g).step = (((*g).line_size) as i32);
                        (*g).parse = ((0) as i32);
                    }
                    if ((*g).lflags & 0x80) != 0 {
                        stbi__gif_parse_colortable(
                            s,
                            (*g).lpal,
                            2 << ((*g).lflags & 7),
                            if ((*g).eflags & 0x01) != 0 {
                                (*g).transparent
                            } else {
                                -1
                            },
                        );

                        (*g).color_table = (*g).lpal[0].as_mut_ptr();
                    } else {
                        if ((*g).flags & 0x80) != 0 {
                            (*g).color_table = (*g).pal[0].as_mut_ptr();
                        } else {
                            return (((if (stbi__err("missing color table")) != 0 {
                                (0)
                            } else {
                                (0)
                            }) as u64) as *mut u8);
                        }
                    }
                    o = stbi__process_gif_raster(s, g);
                    if o == std::ptr::null_mut() {
                        return std::ptr::null_mut();
                    }
                    pcount = (((*g).w * (*g).h) as i32);
                    if (first_frame) != 0 && ((*g).bgindex > 0) {
                        pi = ((0) as i32);
                        while (pi < pcount) {
                            if ((*(*g).history.offset((pi) as isize)) as i32) == 0 {
                                (*g).pal[((*g).bgindex) as usize][(3) as usize] = ((255) as u8);
                                c_runtime::memcpy(
                                    &mut *(*g).out.offset((pi * 4) as isize),
                                    ((&mut (*g).pal[((*g).bgindex) as usize]) as *mut u8),
                                    ((4) as u64),
                                );
                            }
                            c_runtime::preInc(&mut pi);
                        }
                    }
                    return o;
                }
            } else if tag == 0x21 {
                {
                    let mut len: i32 = 0;
                    let mut ext: i32 = ((stbi__get8(s)) as i32);
                    if ext == 0xF9 {
                        len = ((stbi__get8(s)) as i32);
                        if len == 4 {
                            (*g).eflags = ((stbi__get8(s)) as i32);
                            (*g).delay = ((10 * stbi__get16le(s)) as i32);
                            if (*g).transparent >= 0 {
                                (*g).pal[((*g).transparent) as usize][(3) as usize] = ((255) as u8);
                            }
                            if ((*g).eflags & 0x01) != 0 {
                                (*g).transparent = ((stbi__get8(s)) as i32);
                                if (*g).transparent >= 0 {
                                    (*g).pal[((*g).transparent) as usize][(3) as usize] =
                                        ((0) as u8);
                                }
                            } else {
                                stbi__skip(s, 1);
                                (*g).transparent = ((-1) as i32);
                            }
                        } else {
                            stbi__skip(s, len);
                        }
                    }

                    len = (stbi__get8(s)) as i32;
                    while (len != 0) {
                        stbi__skip(s, len);
                        len = (stbi__get8(s)) as i32;
                    }
                }
            } else if tag == 0x3B {
                return ((s) as *mut u8);
            } else {
                return (((if (stbi__err("unknown code")) != 0 {
                    (0)
                } else {
                    (0)
                }) as u64) as *mut u8);
            }
        }
    }

    return std::ptr::null_mut();
}

pub unsafe fn stbi__gif_parse_colortable(
    mut s: *mut stbi__context,
    mut pal: [[u8; 256]; 4],
    mut num_entries: i32,
    mut transp: i32,
) {
    let mut i: i32 = 0;
    i = ((0) as i32);
    while (i < num_entries) {
        pal[(i) as usize][(2) as usize] = ((stbi__get8(s)) as u8);
        pal[(i) as usize][(1) as usize] = ((stbi__get8(s)) as u8);
        pal[(i) as usize][(0) as usize] = ((stbi__get8(s)) as u8);
        pal[(i) as usize][(3) as usize] = ((if transp == i { 0 } else { 255 }) as u8);
        c_runtime::preInc(&mut i);
    }
}

pub unsafe fn stbi__gif_test(mut s: *mut stbi__context) -> i32 {
    let mut r: i32 = stbi__gif_test_raw(s);
    stbi__rewind(s);
    return ((r) as i32);
}

pub unsafe fn stbi__gif_test_raw(mut s: *mut stbi__context) -> i32 {
    let mut sz: i32 = 0;
    if ((stbi__get8(s)) as i32) != 71
        || ((stbi__get8(s)) as i32) != 73
        || ((stbi__get8(s)) as i32) != 70
        || ((stbi__get8(s)) as i32) != 56
    {
        return ((0) as i32);
    }
    sz = ((stbi__get8(s)) as i32);
    if sz != 57 && sz != 55 {
        return ((0) as i32);
    }
    if ((stbi__get8(s)) as i32) != 97 {
        return ((0) as i32);
    }
    return ((1) as i32);
}

pub unsafe fn stbi__load_gif_main(
    mut s: *mut stbi__context,
    mut delays: *mut *mut i32,
    mut x: *mut i32,
    mut y: *mut i32,
    mut z: *mut i32,
    mut comp: *mut i32,
    mut req_comp: i32,
) -> *mut u8 {
    if (stbi__gif_test(s)) != 0 {
        let mut layers: i32 = 0;
        let mut u: *mut u8 = ((std::ptr::null_mut()) as *mut u8);
        let mut out: *mut u8 = ((std::ptr::null_mut()) as *mut u8);
        let mut two_back: *mut u8 = ((std::ptr::null_mut()) as *mut u8);
        let mut g: stbi__gif = stbi__gif::default();
        let mut stride: i32 = 0;
        let mut out_size: i32 = 0;
        let mut delays_size: i32 = 0;
        c_runtime::memset(
            (((&mut g) as *mut stbi__gif) as *mut u8),
            0,
            std::mem::size_of::<stbi__gif>() as u64,
        );
        if (delays) != std::ptr::null_mut() {
            *delays = ((std::ptr::null_mut()) as *mut i32);
        }
        while (true) {
            u = stbi__gif_load_next(s, ((&mut g) as *mut stbi__gif), comp, req_comp, two_back);
            if u == ((s) as *mut u8) {
                u = ((std::ptr::null_mut()) as *mut u8);
            }
            if (u) != std::ptr::null_mut() {
                *x = ((g.w) as i32);
                *y = ((g.h) as i32);
                c_runtime::preInc(&mut layers);
                stride = ((g.w * g.h * 4) as i32);
                if (out) != std::ptr::null_mut() {
                    let mut tmp: *mut u8 = c_runtime::realloc(out, ((layers * stride) as u64));
                    if tmp == std::ptr::null_mut() {
                        return stbi__load_gif_main_outofmem(
                            ((&mut g) as *mut stbi__gif),
                            out,
                            delays,
                        );
                    } else {
                        out = tmp;
                        out_size = ((layers * stride) as i32);
                    }
                    if (delays) != std::ptr::null_mut() {
                        let mut new_delays: *mut i32 = ((c_runtime::realloc(
                            ((*delays) as *mut u8),
                            std::mem::size_of::<i32>() as u64 * ((layers) as u64),
                        )) as *mut i32);
                        if new_delays == std::ptr::null_mut() {
                            return stbi__load_gif_main_outofmem(
                                ((&mut g) as *mut stbi__gif),
                                out,
                                delays,
                            );
                        }
                        *delays = new_delays;
                        delays_size =
                            ((((layers) as u64) * std::mem::size_of::<i32>() as u64) as i32);
                    }
                } else {
                    out = stbi__malloc(((layers * stride) as u64));
                    if out == std::ptr::null_mut() {
                        return stbi__load_gif_main_outofmem(
                            ((&mut g) as *mut stbi__gif),
                            out,
                            delays,
                        );
                    }
                    out_size = ((layers * stride) as i32);
                    if (delays) != std::ptr::null_mut() {
                        *delays =
                            ((stbi__malloc(((layers) as u64) * std::mem::size_of::<i32>() as u64))
                                as *mut i32);
                        if *delays == std::ptr::null_mut() {
                            return stbi__load_gif_main_outofmem(
                                ((&mut g) as *mut stbi__gif),
                                out,
                                delays,
                            );
                        }
                        delays_size =
                            ((((layers) as u64) * std::mem::size_of::<i32>() as u64) as i32);
                    }
                }
                c_runtime::memcpy(
                    (out).offset(((layers - 1) * stride) as isize),
                    u,
                    ((stride) as u64),
                );
                if layers >= 2 {
                    two_back = (out).offset(-((2 * stride) as isize));
                }
                if (delays) != std::ptr::null_mut() {
                    *(*delays).offset((((layers) as u32) - 1) as isize) = ((g.delay) as i32);
                }
            }
            if !(u != ((std::ptr::null_mut()) as *mut u8)) {
                break;
            }
        }
        c_runtime::free(g.out);
        c_runtime::free(g.history);
        c_runtime::free(g.background);
        if (req_comp) != 0 && req_comp != 4 {
            out = stbi__convert_format(out, 4, req_comp, ((layers * g.w) as u32), ((g.h) as u32));
        }
        *z = ((layers) as i32);
        return out;
    } else {
        return (((if (stbi__err("not GIF")) != 0 {
            (0)
        } else {
            (0)
        }) as u64) as *mut u8);
    }
}

pub unsafe fn stbi__load_gif_main_outofmem(
    mut g: *mut stbi__gif,
    mut out: *mut u8,
    mut delays: *mut *mut i32,
) -> *mut u8 {
    c_runtime::free((*g).out);
    c_runtime::free((*g).history);
    c_runtime::free((*g).background);
    if (out) != std::ptr::null_mut() {
        c_runtime::free(out);
    }
    if (delays) != std::ptr::null_mut() && (*delays) != std::ptr::null_mut() {
        c_runtime::free(((*delays) as *mut u8));
    }
    return (((if (stbi__err("outofmem")) != 0 {
        (0)
    } else {
        (0)
    }) as u64) as *mut u8);
}

pub unsafe fn stbi__out_gif_code(mut g: *mut stbi__gif, mut code: u16) {
    let mut p: *mut u8 = std::ptr::null_mut();
    let mut c: *mut u8 = std::ptr::null_mut();
    let mut idx: i32 = 0;
    if (((*g).codes[(code) as usize].prefix) as i32) >= 0 {
        stbi__out_gif_code(g, (((*g).codes[(code) as usize].prefix) as u16));
    }
    if (*g).cur_y >= (*g).max_y {
        return;
    }
    idx = (((*g).cur_x + (*g).cur_y) as i32);
    p = &mut *(*g).out.offset((idx) as isize);
    *(*g).history.offset((idx / 4) as isize) = ((1) as u8);
    c = &mut *(*g)
        .color_table
        .offset(((((*g).codes[(code) as usize].suffix) as i32) * 4) as isize);
    if ((*c.offset((3) as isize)) as i32) > 128 {
        *p.offset((0) as isize) = ((*c.offset((2) as isize)) as u8);
        *p.offset((1) as isize) = ((*c.offset((1) as isize)) as u8);
        *p.offset((2) as isize) = ((*c.offset((0) as isize)) as u8);
        *p.offset((3) as isize) = ((*c.offset((3) as isize)) as u8);
    }
    (*g).cur_x += ((4) as i32);
    if (*g).cur_x >= (*g).max_x {
        (*g).cur_x = (((*g).start_x) as i32);
        (*g).cur_y += (((*g).step) as i32);
        while ((*g).cur_y >= (*g).max_y && (*g).parse > 0) {
            (*g).step = (((1 << (*g).parse) * (*g).line_size) as i32);
            (*g).cur_y = (((*g).start_y + ((*g).step >> 1)) as i32);
            c_runtime::preDec(&mut (*g).parse);
        }
    }
}

pub unsafe fn stbi__process_gif_raster(
    mut s: *mut stbi__context,
    mut g: *mut stbi__gif,
) -> *mut u8 {
    let mut lzw_cs: u8 = 0;
    let mut len: i32 = 0;
    let mut init_code: i32 = 0;
    let mut first: u32 = 0;
    let mut codesize: i32 = 0;
    let mut codemask: i32 = 0;
    let mut avail: i32 = 0;
    let mut oldcode: i32 = 0;
    let mut bits: i32 = 0;
    let mut valid_bits: i32 = 0;
    let mut clear: i32 = 0;
    let mut p: *mut stbi__gif_lzw = std::ptr::null_mut();
    lzw_cs = ((stbi__get8(s)) as u8);
    if ((lzw_cs) as i32) > 12 {
        return std::ptr::null_mut();
    }
    clear = (1 << ((lzw_cs) as i32));
    first = ((1) as u32);
    codesize = (((lzw_cs) as i32) + 1);
    codemask = (((1 << codesize) - 1) as i32);
    bits = ((0) as i32);
    valid_bits = ((0) as i32);
    init_code = ((0) as i32);
    while (init_code < clear) {
        (*g).codes[(init_code) as usize].prefix = ((-1) as i16);
        (*g).codes[(init_code) as usize].first = ((init_code) as u8);
        (*g).codes[(init_code) as usize].suffix = ((init_code) as u8);
        c_runtime::postInc(&mut init_code);
    }
    avail = ((clear + 2) as i32);
    oldcode = ((-1) as i32);
    len = ((0) as i32);
    while (true) {
        if valid_bits < codesize {
            if len == 0 {
                len = ((stbi__get8(s)) as i32);
                if len == 0 {
                    return (*g).out;
                }
            }
            c_runtime::preDec(&mut len);
            bits |= (((stbi__get8(s)) as i32) << valid_bits);
            valid_bits += ((8) as i32);
        } else {
            let mut code: i32 = bits & codemask;
            bits >>= codesize;
            valid_bits -= ((codesize) as i32);
            if code == clear {
                codesize = (((lzw_cs) as i32) + 1);
                codemask = (((1 << codesize) - 1) as i32);
                avail = ((clear + 2) as i32);
                oldcode = ((-1) as i32);
                first = ((0) as u32);
            } else {
                if code == clear + 1 {
                    stbi__skip(s, len);
                    len = stbi__get8(s) as i32;
                    while (len > 0) {
                        stbi__skip(s, len);
                        len = stbi__get8(s) as i32;
                    }
                    return (*g).out;
                } else {
                    if code <= avail {
                        if (first) != 0 {
                            return (((if (stbi__err("no clear code")) != 0 {
                                (0)
                            } else {
                                (0)
                            }) as u64) as *mut u8);
                        }
                        if oldcode >= 0 {
                            p = &mut (*g).codes[(c_runtime::postInc(&mut avail)) as usize];
                            if avail > 8192 {
                                return (((if (stbi__err("too many codes")) != 0 {
                                    (0)
                                } else {
                                    (0)
                                }) as u64) as *mut u8);
                            }
                            (*p).prefix = ((oldcode) as i16);
                            (*p).first = (((*g).codes[(oldcode) as usize].first) as u8);
                            (*p).suffix = ((if (code == avail) {
                                (((*p).first) as i32)
                            } else {
                                (((*g).codes[(code) as usize].first) as i32)
                            }) as u8);
                        } else {
                            if code == avail {
                                return (((if (stbi__err("illegal code in raster")) != 0 {
                                    (0)
                                } else {
                                    (0)
                                }) as u64) as *mut u8);
                            }
                        }
                        stbi__out_gif_code(g, ((code) as u16));
                        if (avail & codemask) == 0 && avail <= 0x0FFF {
                            c_runtime::postInc(&mut codesize);
                            codemask = (((1 << codesize) - 1) as i32);
                        }
                        oldcode = ((code) as i32);
                    } else {
                        return (((if (stbi__err("illegal code in raster")) != 0 {
                            (0)
                        } else {
                            (0)
                        }) as u64) as *mut u8);
                    }
                }
            }
        }
    }

    return std::ptr::null_mut();
}
