use std::collections::HashMap;
use strum_macros::EnumString;

#[derive(Debug)]
pub struct StbNodes {
    pub map: HashMap<i32, StbNode>,
}

impl StbNodes {
    pub fn new() -> StbNodes {
        StbNodes {
            map: HashMap::new(),
        }
    }

    pub fn insert(&mut self, key: i32, value: StbNode) {
        self.map.insert(key, value);
    }

    pub fn get(&self, key: i32) -> Option<&StbNode> {
        self.map.get(&key)
    }
}

#[derive(Debug)]
pub struct StbNode {
    pub x: f64,
    pub y: f64,
    pub z: f64,
    pub kind: StbNodeKind,
    pub id_member: Option<i32>,
}

#[derive(Debug, EnumString)]
pub enum StbNodeKind {
    #[strum(serialize = "ON_GIRDER")]
    OnGirder,
    #[strum(serialize = "ON_BEAM")]
    OnBeam,
    #[strum(serialize = "ON_COLUMN")]
    OnColumn,
    #[strum(serialize = "ON_POST")]
    OnPost,
    #[strum(serialize = "ON_GRID")]
    OnGrid,
    #[strum(serialize = "ON_CANTI")]
    OnCanti,
    #[strum(serialize = "ON_SLAB")]
    OnSlab,
    #[strum(serialize = "OTHER")]
    Other,
}
