
# This file was @generated by crate2nix 0.10.0 with the command:
#   "generate"
# See https://github.com/kolloch/crate2nix for more info.

{ nixpkgs ? <nixpkgs>
, pkgs ? import nixpkgs { config = {}; }
, lib ? pkgs.lib
, stdenv ? pkgs.stdenv
, buildRustCrateForPkgs ? if buildRustCrate != null
    then lib.warn "crate2nix: Passing `buildRustCrate` as argument to Cargo.nix is deprecated. If you don't customize `buildRustCrate`, replace `callPackage ./Cargo.nix {}` by `import ./Cargo.nix { inherit pkgs; }`, and if you need to customize `buildRustCrate`, use `buildRustCrateForPkgs` instead." (_: buildRustCrate)
    else pkgs: pkgs.buildRustCrate
  # Deprecated
, buildRustCrate ? null
  # This is used as the `crateOverrides` argument for `buildRustCrate`.
, defaultCrateOverrides ? pkgs.defaultCrateOverrides
  # The features to enable for the root_crate or the workspace_members.
, rootFeatures ? [ "default" ]
  # If true, throw errors instead of issueing deprecation warnings.
, strictDeprecation ? false
  # Used for conditional compilation based on CPU feature detection.
, targetFeatures ? []
  # Whether to perform release builds: longer compile times, faster binaries.
, release ? true
  # Additional crate2nix configuration if it exists.
, crateConfig
  ? if builtins.pathExists ./crate-config.nix
    then pkgs.callPackage ./crate-config.nix {}
    else {}
}:

rec {
  #
  # "public" attributes that we attempt to keep stable with new versions of crate2nix.
  #

  rootCrate = rec {
    packageId = "stateright";

    # Use this attribute to refer to the derivation building your root crate package.
    # You can override the features with rootCrate.build.override { features = [ "default" "feature1" ... ]; }.
    build = internal.buildRustCrateWithFeatures {
      inherit packageId;
    };

    # Debug support which might change between releases.
    # File a bug if you depend on any for non-debug work!
    debug = internal.debugCrate { inherit packageId; };
  };
  # Refer your crate build derivation by name here.
  # You can override the features with
  # workspaceMembers."${crateName}".build.override { features = [ "default" "feature1" ... ]; }.
  workspaceMembers = {
    "stateright" = rec {
      packageId = "stateright";
      build = internal.buildRustCrateWithFeatures {
        packageId = "stateright";
      };

      # Debug support which might change between releases.
      # File a bug if you depend on any for non-debug work!
      debug = internal.debugCrate { inherit packageId; };
    };
  };

  # A derivation that joins the outputs of all workspace members together.
  allWorkspaceMembers = pkgs.symlinkJoin {
      name = "all-workspace-members";
      paths =
        let members = builtins.attrValues workspaceMembers;
        in builtins.map (m: m.build) members;
  };

  #
  # "internal" ("private") attributes that may change in every new version of crate2nix.
  #

  internal = rec {
    # Build and dependency information for crates.
    # Many of the fields are passed one-to-one to buildRustCrate.
    #
    # Noteworthy:
    # * `dependencies`/`buildDependencies`: similar to the corresponding fields for buildRustCrate.
    #   but with additional information which is used during dependency/feature resolution.
    # * `resolvedDependencies`: the selected default features reported by cargo - only included for debugging.
    # * `devDependencies` as of now not used by `buildRustCrate` but used to
    #   inject test dependencies into the build

    crates = {
      "actix-codec" = rec {
        crateName = "actix-codec";
        version = "0.1.2";
        edition = "2018";
        sha256 = "0lv42xf57y3kwy8nl2a9pkz35yvbspd9250virfr7p069fpi2b4z";
        libName = "actix_codec";
        authors = [
          "Nikolay Kim <fafhrd91@gmail.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "tokio-codec";
            packageId = "tokio-codec";
          }
          {
            name = "tokio-io";
            packageId = "tokio-io";
          }
        ];

      };
      "actix-connect" = rec {
        crateName = "actix-connect";
        version = "0.2.5";
        edition = "2018";
        sha256 = "187whz05gjkp9pcza4i714v0a8yxlg3jdrzii7gaqsxl9fyykbcz";
        libName = "actix_connect";
        authors = [
          "Nikolay Kim <fafhrd91@gmail.com>"
        ];
        dependencies = [
          {
            name = "actix-codec";
            packageId = "actix-codec";
          }
          {
            name = "actix-rt";
            packageId = "actix-rt";
          }
          {
            name = "actix-service";
            packageId = "actix-service";
          }
          {
            name = "actix-utils";
            packageId = "actix-utils";
          }
          {
            name = "derive_more";
            packageId = "derive_more";
          }
          {
            name = "either";
            packageId = "either";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "http";
            packageId = "http";
            optional = true;
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "tokio-current-thread";
            packageId = "tokio-current-thread";
          }
          {
            name = "tokio-tcp";
            packageId = "tokio-tcp";
          }
          {
            name = "trust-dns-resolver";
            packageId = "trust-dns-resolver";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "uri" ];
          "rust-tls" = [ "rustls" "tokio-rustls" "webpki" ];
          "ssl" = [ "openssl" "tokio-openssl" ];
          "uri" = [ "http" ];
        };
        resolvedDefaultFeatures = [ "default" "http" "uri" ];
      };
      "actix-http" = rec {
        crateName = "actix-http";
        version = "0.2.11";
        edition = "2018";
        sha256 = "0fdi9pi33am22qbqni5dn2in11xfbchgsjnm9ws0s918rmvhzdgw";
        libName = "actix_http";
        authors = [
          "Nikolay Kim <fafhrd91@gmail.com>"
        ];
        dependencies = [
          {
            name = "actix-codec";
            packageId = "actix-codec";
          }
          {
            name = "actix-connect";
            packageId = "actix-connect";
          }
          {
            name = "actix-server-config";
            packageId = "actix-server-config";
          }
          {
            name = "actix-service";
            packageId = "actix-service";
          }
          {
            name = "actix-threadpool";
            packageId = "actix-threadpool";
          }
          {
            name = "actix-utils";
            packageId = "actix-utils";
          }
          {
            name = "base64";
            packageId = "base64";
          }
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "brotli2";
            packageId = "brotli2";
            optional = true;
          }
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "chrono";
            packageId = "chrono";
          }
          {
            name = "copyless";
            packageId = "copyless";
          }
          {
            name = "derive_more";
            packageId = "derive_more";
          }
          {
            name = "either";
            packageId = "either";
          }
          {
            name = "encoding_rs";
            packageId = "encoding_rs";
          }
          {
            name = "failure";
            packageId = "failure";
            optional = true;
          }
          {
            name = "flate2";
            packageId = "flate2";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "h2";
            packageId = "h2";
          }
          {
            name = "hashbrown";
            packageId = "hashbrown 0.6.3";
          }
          {
            name = "http";
            packageId = "http";
          }
          {
            name = "httparse";
            packageId = "httparse";
          }
          {
            name = "indexmap";
            packageId = "indexmap";
          }
          {
            name = "language-tags";
            packageId = "language-tags";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "mime";
            packageId = "mime";
          }
          {
            name = "percent-encoding";
            packageId = "percent-encoding 2.1.0";
          }
          {
            name = "rand";
            packageId = "rand 0.7.3";
          }
          {
            name = "regex";
            packageId = "regex";
          }
          {
            name = "serde";
            packageId = "serde";
          }
          {
            name = "serde_json";
            packageId = "serde_json";
          }
          {
            name = "serde_urlencoded";
            packageId = "serde_urlencoded";
          }
          {
            name = "sha1";
            packageId = "sha1";
          }
          {
            name = "slab";
            packageId = "slab";
          }
          {
            name = "time";
            packageId = "time";
          }
          {
            name = "tokio-current-thread";
            packageId = "tokio-current-thread";
          }
          {
            name = "tokio-tcp";
            packageId = "tokio-tcp";
          }
          {
            name = "tokio-timer";
            packageId = "tokio-timer";
          }
          {
            name = "trust-dns-resolver";
            packageId = "trust-dns-resolver";
            usesDefaultFeatures = false;
          }
        ];
        devDependencies = [
          {
            name = "actix-connect";
            packageId = "actix-connect";
            features = [ "ssl" ];
          }
          {
            name = "tokio-tcp";
            packageId = "tokio-tcp";
          }
        ];
        features = {
          "brotli" = [ "brotli2" ];
          "fail" = [ "failure" ];
          "flate2-rust" = [ "flate2/rust_backend" ];
          "flate2-zlib" = [ "flate2/miniz-sys" ];
          "rust-tls" = [ "rustls" "webpki-roots" "actix-connect/rust-tls" ];
          "secure-cookies" = [ "ring" ];
          "ssl" = [ "openssl" "actix-connect/ssl" ];
        };
        resolvedDefaultFeatures = [ "brotli" "brotli2" "default" "fail" "failure" "flate2" "flate2-zlib" ];
      };
      "actix-router" = rec {
        crateName = "actix-router";
        version = "0.1.5";
        edition = "2018";
        sha256 = "1xyc0kzawfwjfiw4znb7xx6hh4r7nnwjq44i08fjc1724ysln8i3";
        libName = "actix_router";
        authors = [
          "Nikolay Kim <fafhrd91@gmail.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "http";
            packageId = "http";
            optional = true;
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "regex";
            packageId = "regex";
          }
          {
            name = "serde";
            packageId = "serde";
          }
          {
            name = "string";
            packageId = "string";
          }
        ];
        devDependencies = [
          {
            name = "http";
            packageId = "http";
          }
        ];
        features = {
          "default" = [ "http" ];
        };
        resolvedDefaultFeatures = [ "default" "http" ];
      };
      "actix-rt" = rec {
        crateName = "actix-rt";
        version = "0.2.6";
        edition = "2018";
        sha256 = "13h9dph54lhxlzcz6wxmsv96qqpbh1dzr4365gn84gb00qfxmjc8";
        libName = "actix_rt";
        authors = [
          "Nikolay Kim <fafhrd91@gmail.com>"
        ];
        dependencies = [
          {
            name = "actix-threadpool";
            packageId = "actix-threadpool";
          }
          {
            name = "copyless";
            packageId = "copyless";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "tokio-current-thread";
            packageId = "tokio-current-thread";
          }
          {
            name = "tokio-executor";
            packageId = "tokio-executor";
          }
          {
            name = "tokio-reactor";
            packageId = "tokio-reactor";
          }
          {
            name = "tokio-timer";
            packageId = "tokio-timer";
          }
        ];

      };
      "actix-server" = rec {
        crateName = "actix-server";
        version = "0.6.1";
        edition = "2018";
        sha256 = "19b2sl8dz01xfrynmf4iixq4a15g0gk1z43lby7762ldmws6aqnx";
        libName = "actix_server";
        authors = [
          "Nikolay Kim <fafhrd91@gmail.com>"
        ];
        dependencies = [
          {
            name = "actix-rt";
            packageId = "actix-rt";
          }
          {
            name = "actix-server-config";
            packageId = "actix-server-config";
          }
          {
            name = "actix-service";
            packageId = "actix-service";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "mio";
            packageId = "mio";
          }
          {
            name = "net2";
            packageId = "net2";
          }
          {
            name = "num_cpus";
            packageId = "num_cpus";
          }
          {
            name = "slab";
            packageId = "slab";
          }
          {
            name = "tokio-io";
            packageId = "tokio-io";
          }
          {
            name = "tokio-reactor";
            packageId = "tokio-reactor";
          }
          {
            name = "tokio-signal";
            packageId = "tokio-signal";
          }
          {
            name = "tokio-tcp";
            packageId = "tokio-tcp";
          }
          {
            name = "tokio-timer";
            packageId = "tokio-timer";
          }
        ];
        features = {
          "rust-tls" = [ "rustls" "tokio-rustls" "webpki" "webpki-roots" "actix-server-config/rust-tls" ];
          "ssl" = [ "openssl" "tokio-openssl" "actix-server-config/ssl" ];
          "tls" = [ "native-tls" ];
          "uds" = [ "mio-uds" "tokio-uds" "actix-server-config/uds" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "actix-server-config" = rec {
        crateName = "actix-server-config";
        version = "0.1.2";
        edition = "2018";
        sha256 = "0c7zp4l63n5skljbpq6j0a0avdjv6w067bdc5ca96bb8kjc38fj8";
        libName = "actix_server_config";
        authors = [
          "Nikolay Kim <fafhrd91@gmail.com>"
        ];
        dependencies = [
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "tokio-io";
            packageId = "tokio-io";
          }
          {
            name = "tokio-tcp";
            packageId = "tokio-tcp";
          }
        ];
        features = {
          "rust-tls" = [ "rustls" "tokio-rustls" ];
          "ssl" = [ "tokio-openssl" ];
          "uds" = [ "tokio-uds" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "actix-service" = rec {
        crateName = "actix-service";
        version = "0.4.2";
        edition = "2018";
        sha256 = "0gvpw11hcr1zmi5qzq3np6qzd0j51mdxn7yfgmzgyhc8ja7b99dw";
        libName = "actix_service";
        authors = [
          "Nikolay Kim <fafhrd91@gmail.com>"
        ];
        dependencies = [
          {
            name = "futures";
            packageId = "futures";
          }
        ];

      };
      "actix-testing" = rec {
        crateName = "actix-testing";
        version = "0.1.0";
        edition = "2018";
        sha256 = "1w9p7wv2n2wda8ph3ahp8fqslmbh12vs206l4i49jl37mjbiw05g";
        libName = "actix_testing";
        authors = [
          "Nikolay Kim <fafhrd91@gmail.com>"
        ];
        dependencies = [
          {
            name = "actix-rt";
            packageId = "actix-rt";
          }
          {
            name = "actix-server";
            packageId = "actix-server";
          }
          {
            name = "actix-server-config";
            packageId = "actix-server-config";
          }
          {
            name = "actix-service";
            packageId = "actix-service";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "net2";
            packageId = "net2";
          }
          {
            name = "tokio-reactor";
            packageId = "tokio-reactor";
          }
          {
            name = "tokio-tcp";
            packageId = "tokio-tcp";
          }
        ];

      };
      "actix-threadpool" = rec {
        crateName = "actix-threadpool";
        version = "0.1.2";
        edition = "2018";
        sha256 = "0pfk6k09cdw0w63wh8glqm6bvqz0hlqwhyqvdfw6yzns2dfyhnkb";
        libName = "actix_threadpool";
        authors = [
          "Nikolay Kim <fafhrd91@gmail.com>"
        ];
        dependencies = [
          {
            name = "derive_more";
            packageId = "derive_more";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "num_cpus";
            packageId = "num_cpus";
          }
          {
            name = "parking_lot";
            packageId = "parking_lot 0.9.0";
          }
          {
            name = "threadpool";
            packageId = "threadpool";
          }
        ];

      };
      "actix-utils" = rec {
        crateName = "actix-utils";
        version = "0.4.7";
        edition = "2018";
        sha256 = "15bv06z7pccnmh067l5zj0fvpmfagnil7lvznnl3fp4gjh4k334h";
        libName = "actix_utils";
        authors = [
          "Nikolay Kim <fafhrd91@gmail.com>"
        ];
        dependencies = [
          {
            name = "actix-codec";
            packageId = "actix-codec";
          }
          {
            name = "actix-service";
            packageId = "actix-service";
          }
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "either";
            packageId = "either";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "tokio-current-thread";
            packageId = "tokio-current-thread";
          }
          {
            name = "tokio-timer";
            packageId = "tokio-timer";
          }
        ];

      };
      "actix-web" = rec {
        crateName = "actix-web";
        version = "1.0.9";
        edition = "2018";
        sha256 = "00wvayn7v2s61hylisr53f48s2bzg8jp3bmrqh1vkb6vgjb1nfmg";
        libName = "actix_web";
        authors = [
          "Nikolay Kim <fafhrd91@gmail.com>"
        ];
        dependencies = [
          {
            name = "actix-codec";
            packageId = "actix-codec";
          }
          {
            name = "actix-http";
            packageId = "actix-http";
          }
          {
            name = "actix-router";
            packageId = "actix-router";
          }
          {
            name = "actix-rt";
            packageId = "actix-rt";
          }
          {
            name = "actix-server";
            packageId = "actix-server";
          }
          {
            name = "actix-server-config";
            packageId = "actix-server-config";
          }
          {
            name = "actix-service";
            packageId = "actix-service";
          }
          {
            name = "actix-testing";
            packageId = "actix-testing";
          }
          {
            name = "actix-threadpool";
            packageId = "actix-threadpool";
          }
          {
            name = "actix-utils";
            packageId = "actix-utils";
          }
          {
            name = "actix-web-codegen";
            packageId = "actix-web-codegen";
          }
          {
            name = "awc";
            packageId = "awc";
            optional = true;
          }
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "derive_more";
            packageId = "derive_more";
          }
          {
            name = "encoding_rs";
            packageId = "encoding_rs";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "hashbrown";
            packageId = "hashbrown 0.6.3";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "mime";
            packageId = "mime";
          }
          {
            name = "net2";
            packageId = "net2";
          }
          {
            name = "parking_lot";
            packageId = "parking_lot 0.9.0";
          }
          {
            name = "regex";
            packageId = "regex";
          }
          {
            name = "serde";
            packageId = "serde";
            features = [ "derive" ];
          }
          {
            name = "serde_json";
            packageId = "serde_json";
          }
          {
            name = "serde_urlencoded";
            packageId = "serde_urlencoded";
          }
          {
            name = "time";
            packageId = "time";
          }
          {
            name = "url";
            packageId = "url 2.2.2";
          }
        ];
        features = {
          "brotli" = [ "actix-http/brotli" ];
          "client" = [ "awc" ];
          "default" = [ "brotli" "flate2-zlib" "client" "fail" ];
          "fail" = [ "actix-http/fail" ];
          "flate2-rust" = [ "actix-http/flate2-rust" ];
          "flate2-zlib" = [ "actix-http/flate2-zlib" ];
          "rust-tls" = [ "rustls" "actix-server/rust-tls" "awc/rust-tls" ];
          "secure-cookies" = [ "actix-http/secure-cookies" ];
          "ssl" = [ "openssl" "actix-server/ssl" "awc/ssl" ];
          "uds" = [ "actix-server/uds" ];
        };
        resolvedDefaultFeatures = [ "awc" "brotli" "client" "default" "fail" "flate2-zlib" ];
      };
      "actix-web-codegen" = rec {
        crateName = "actix-web-codegen";
        version = "0.1.3";
        edition = "2018";
        sha256 = "1frs0id6k1vjczhnfhwh8q8birp27imlvgi6jylfxh911r9372h6";
        procMacro = true;
        authors = [
          "Nikolay Kim <fafhrd91@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 1.0.32";
          }
          {
            name = "quote";
            packageId = "quote 1.0.10";
          }
          {
            name = "syn";
            packageId = "syn 1.0.82";
            features = [ "full" "parsing" ];
          }
        ];

      };
      "addr2line" = rec {
        crateName = "addr2line";
        version = "0.17.0";
        edition = "2015";
        sha256 = "0sw16zqy6w0ar633z69m7lw6gb0k1y7xj3387a8wly43ij5div5r";
        dependencies = [
          {
            name = "gimli";
            packageId = "gimli";
            usesDefaultFeatures = false;
            features = [ "read" ];
          }
        ];
        features = {
          "default" = [ "rustc-demangle" "cpp_demangle" "std-object" "fallible-iterator" "smallvec" ];
          "rustc-dep-of-std" = [ "core" "alloc" "compiler_builtins" "gimli/rustc-dep-of-std" ];
          "std" = [ "gimli/std" ];
          "std-object" = [ "std" "object" "object/std" "object/compression" "gimli/endian-reader" ];
        };
      };
      "adler" = rec {
        crateName = "adler";
        version = "1.0.2";
        edition = "2015";
        sha256 = "1zim79cvzd5yrkzl3nyfx0avijwgk9fqv3yrscdy1cc79ih02qpj";
        authors = [
          "Jonas Schievink <jonasschievink@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
        };
      };
      "ahash 0.2.19" = rec {
        crateName = "ahash";
        version = "0.2.19";
        edition = "2018";
        sha256 = "1yzdrxaq99zfy0niq5i3cz5jv569s3s6z5q2cxcg08y6prh1nri9";
        authors = [
          "Tom Kaitchuck <Tom.Kaitchuck@gmail.com>"
        ];
        dependencies = [
          {
            name = "const-random";
            packageId = "const-random";
            optional = true;
          }
        ];
        features = {
          "compile-time-rng" = [ "const-random" ];
          "default" = [ "compile-time-rng" ];
        };
        resolvedDefaultFeatures = [ "compile-time-rng" "const-random" ];
      };
      "ahash 0.3.8" = rec {
        crateName = "ahash";
        version = "0.3.8";
        edition = "2018";
        sha256 = "05qjnr0wccch0gg2kghg0xyh8qd5gfqd15q9dd6r1lamcs375zg8";
        authors = [
          "Tom Kaitchuck <Tom.Kaitchuck@gmail.com>"
        ];
        dependencies = [
          {
            name = "const-random";
            packageId = "const-random";
            optional = true;
          }
        ];
        features = {
          "compile-time-rng" = [ "const-random" ];
          "default" = [ "compile-time-rng" "std" ];
        };
        resolvedDefaultFeatures = [ "compile-time-rng" "const-random" "default" "std" ];
      };
      "aho-corasick" = rec {
        crateName = "aho-corasick";
        version = "0.7.18";
        edition = "2018";
        sha256 = "0vv50b3nvkhyy7x7ip19qnsq11bqlnffkmj2yx2xlyk5wzawydqy";
        libName = "aho_corasick";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "memchr";
            packageId = "memchr";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "memchr/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "atty" = rec {
        crateName = "atty";
        version = "0.2.14";
        edition = "2015";
        sha256 = "1s7yslcs6a28c5vz7jwj63lkfgyx8mx99fdirlhi9lbhhzhrpcyr";
        authors = [
          "softprops <d.tangren@gmail.com>"
        ];
        dependencies = [
          {
            name = "hermit-abi";
            packageId = "hermit-abi";
            target = { target, features }: (target."os" == "hermit");
          }
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "consoleapi" "processenv" "minwinbase" "minwindef" "winbase" ];
          }
        ];

      };
      "autocfg 0.1.7" = rec {
        crateName = "autocfg";
        version = "0.1.7";
        edition = "2015";
        sha256 = "1chwgimpx5z7xbag7krr9d8asxfqbh683qhgl9kn3hxk2l0djj8x";
        authors = [
          "Josh Stone <cuviper@gmail.com>"
        ];

      };
      "autocfg 1.0.1" = rec {
        crateName = "autocfg";
        version = "1.0.1";
        edition = "2015";
        sha256 = "0jj6i9zn4gjl03kjvziqdji6rwx8ykz8zk2ngpc331z2g3fk3c6d";
        authors = [
          "Josh Stone <cuviper@gmail.com>"
        ];

      };
      "awc" = rec {
        crateName = "awc";
        version = "0.2.8";
        edition = "2018";
        sha256 = "1i5qinnh37bwpx86m2yyq1q1bnsa31vlwlz7942bzlwd4y1m56ay";
        authors = [
          "Nikolay Kim <fafhrd91@gmail.com>"
        ];
        dependencies = [
          {
            name = "actix-codec";
            packageId = "actix-codec";
          }
          {
            name = "actix-http";
            packageId = "actix-http";
          }
          {
            name = "actix-service";
            packageId = "actix-service";
          }
          {
            name = "base64";
            packageId = "base64";
          }
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "derive_more";
            packageId = "derive_more";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "mime";
            packageId = "mime";
          }
          {
            name = "percent-encoding";
            packageId = "percent-encoding 2.1.0";
          }
          {
            name = "rand";
            packageId = "rand 0.7.3";
          }
          {
            name = "serde";
            packageId = "serde";
          }
          {
            name = "serde_json";
            packageId = "serde_json";
          }
          {
            name = "serde_urlencoded";
            packageId = "serde_urlencoded";
          }
          {
            name = "tokio-timer";
            packageId = "tokio-timer";
          }
        ];
        devDependencies = [
          {
            name = "actix-http";
            packageId = "actix-http";
            features = [ "ssl" ];
          }
          {
            name = "rand";
            packageId = "rand 0.7.3";
          }
        ];
        features = {
          "brotli" = [ "actix-http/brotli" ];
          "default" = [ "brotli" "flate2-zlib" ];
          "flate2-rust" = [ "actix-http/flate2-rust" ];
          "flate2-zlib" = [ "actix-http/flate2-zlib" ];
          "rust-tls" = [ "rustls" "actix-http/rust-tls" ];
          "ssl" = [ "openssl" "actix-http/ssl" ];
        };
        resolvedDefaultFeatures = [ "brotli" "default" "flate2-zlib" ];
      };
      "backtrace" = rec {
        crateName = "backtrace";
        version = "0.3.63";
        edition = "2018";
        sha256 = "1dp1dik2riphgslibafp3kzj95f8kgx42wkh4qghc4v5pbc2j5ij";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "addr2line";
            packageId = "addr2line";
            usesDefaultFeatures = false;
          }
          {
            name = "cfg-if";
            packageId = "cfg-if 1.0.0";
          }
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
          }
          {
            name = "miniz_oxide";
            packageId = "miniz_oxide";
            usesDefaultFeatures = false;
          }
          {
            name = "object";
            packageId = "object";
            usesDefaultFeatures = false;
            features = [ "read_core" "elf" "macho" "pe" "unaligned" "archive" ];
          }
          {
            name = "rustc-demangle";
            packageId = "rustc-demangle";
          }
        ];
        buildDependencies = [
          {
            name = "cc";
            packageId = "cc";
          }
        ];
        features = {
          "default" = [ "std" ];
          "serialize-rustc" = [ "rustc-serialize" ];
          "serialize-serde" = [ "serde" ];
          "verify-winapi" = [ "winapi/dbghelp" "winapi/handleapi" "winapi/libloaderapi" "winapi/memoryapi" "winapi/minwindef" "winapi/processthreadsapi" "winapi/synchapi" "winapi/tlhelp32" "winapi/winbase" "winapi/winnt" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "base64" = rec {
        crateName = "base64";
        version = "0.10.1";
        edition = "2015";
        sha256 = "13k6bvd3n6dm7jqn9x918w65dd9xhx454bqphbnv0bkd6n9dj98b";
        authors = [
          "Alice Maz <alice@alicemaz.com>"
          "Marshall Pierce <marshall@mpierce.org>"
        ];
        dependencies = [
          {
            name = "byteorder";
            packageId = "byteorder";
          }
        ];

      };
      "bitflags" = rec {
        crateName = "bitflags";
        version = "1.3.2";
        edition = "2018";
        sha256 = "12ki6w8gn1ldq7yz9y680llwk5gmrhrzszaa17g1sbrw2r2qvwxy";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "brotli-sys" = rec {
        crateName = "brotli-sys";
        version = "0.3.2";
        edition = "2015";
        sha256 = "1kdfdbcba6zwa13xpjwgiplblkdf6vigxjbwwp6l2ascbylxwia4";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
          }
        ];
        buildDependencies = [
          {
            name = "cc";
            packageId = "cc";
          }
        ];

      };
      "brotli2" = rec {
        crateName = "brotli2";
        version = "0.3.2";
        edition = "2015";
        sha256 = "13jnhpmfkqy2xar4lxrsk3rx3i12bgnarnsxq4arhc6yxb1kdc0c";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "brotli-sys";
            packageId = "brotli-sys";
          }
          {
            name = "libc";
            packageId = "libc";
          }
        ];

      };
      "byteorder" = rec {
        crateName = "byteorder";
        version = "1.4.3";
        edition = "2018";
        sha256 = "0456lv9xi1a5bcm32arknf33ikv76p3fr9yzki4lb2897p2qkh8l";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "bytes" = rec {
        crateName = "bytes";
        version = "0.4.12";
        edition = "2015";
        sha256 = "0768a55q2fsqdjsvcv98ndg9dq7w2g44dvq1avhwpxrdzbydyvr0";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "byteorder";
            packageId = "byteorder";
          }
          {
            name = "iovec";
            packageId = "iovec";
          }
        ];
        features = {
          "i128" = [ "byteorder/i128" ];
        };
      };
      "cc" = rec {
        crateName = "cc";
        version = "1.0.72";
        edition = "2018";
        crateBin = [];
        sha256 = "1vl50h2qh0nh0iddzj6gd1pnxnxpvwmbfxc30578c1pajmxi7a92";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "parallel" = [ "jobserver" ];
        };
      };
      "cfg-if 0.1.10" = rec {
        crateName = "cfg-if";
        version = "0.1.10";
        edition = "2018";
        sha256 = "08h80ihs74jcyp24cd75wwabygbbdgl05k6p5dmq8akbr78vv1a7";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
        };
      };
      "cfg-if 1.0.0" = rec {
        crateName = "cfg-if";
        version = "1.0.0";
        edition = "2018";
        sha256 = "1za0vb97n4brpzpv8lsbnzmq5r8f2b0cpqqr0sy8h5bn751xxwds";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
        };
      };
      "choice" = rec {
        crateName = "choice";
        version = "0.0.2";
        edition = "2018";
        sha256 = "0lv58s9zw2irvqzg9szjrp85d088bn25rnisjcm61byy4741zdx3";
        authors = [
          "Jonathan Nadal <jon.nadal@gmail.com>"
        ];

      };
      "chrono" = rec {
        crateName = "chrono";
        version = "0.4.19";
        edition = "2015";
        sha256 = "0wyfl6c00vhfl562spnfcna3zkw8jqvcp652m9iskhl8j26dc2k7";
        authors = [
          "Kang Seonghoon <public+rust@mearie.org>"
          "Brandon W Maister <quodlibetor@gmail.com>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            optional = true;
          }
          {
            name = "num-integer";
            packageId = "num-integer";
            usesDefaultFeatures = false;
          }
          {
            name = "num-traits";
            packageId = "num-traits";
            usesDefaultFeatures = false;
          }
          {
            name = "time";
            packageId = "time";
            optional = true;
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            optional = true;
            target = { target, features }: (target."windows" or false);
            features = [ "std" "minwinbase" "minwindef" "timezoneapi" ];
          }
        ];
        features = {
          "clock" = [ "libc" "std" "winapi" ];
          "default" = [ "clock" "std" "oldtime" ];
          "oldtime" = [ "time" ];
          "unstable-locales" = [ "pure-rust-locales" "alloc" ];
          "wasmbind" = [ "wasm-bindgen" "js-sys" ];
        };
        resolvedDefaultFeatures = [ "clock" "default" "libc" "oldtime" "std" "time" "winapi" ];
      };
      "cloudabi" = rec {
        crateName = "cloudabi";
        version = "0.0.3";
        edition = "2015";
        sha256 = "0kxcg83jlihy0phnd2g8c2c303px3l2p3pkjz357ll6llnd5pz6x";
        libPath = "cloudabi.rs";
        authors = [
          "Nuxi (https://nuxi.nl/) and contributors"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
            optional = true;
          }
        ];
        features = {
          "default" = [ "bitflags" ];
        };
        resolvedDefaultFeatures = [ "bitflags" "default" ];
      };
      "const-random" = rec {
        crateName = "const-random";
        version = "0.1.13";
        edition = "2018";
        sha256 = "1i3pmhmmcdw3rr1pv1p9yhm4danm5r156cpy7w30pa0s05fxk47m";
        authors = [
          "Tom Kaitchuck <Tom.Kaitchuck@gmail.com>"
        ];
        dependencies = [
          {
            name = "const-random-macro";
            packageId = "const-random-macro";
          }
          {
            name = "proc-macro-hack";
            packageId = "proc-macro-hack";
          }
        ];

      };
      "const-random-macro" = rec {
        crateName = "const-random-macro";
        version = "0.1.13";
        edition = "2018";
        sha256 = "0h7vvskw1pw5x44sbl74gsi8ydvrj5kaixpjqzxvz8h0s0knwpv1";
        procMacro = true;
        authors = [
          "Tom Kaitchuck <Tom.Kaitchuck@gmail.com>"
        ];
        dependencies = [
          {
            name = "getrandom";
            packageId = "getrandom 0.2.3";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "proc-macro-hack";
            packageId = "proc-macro-hack";
          }
          {
            name = "tiny-keccak";
            packageId = "tiny-keccak";
            features = [ "sha3" ];
          }
        ];

      };
      "copyless" = rec {
        crateName = "copyless";
        version = "0.1.5";
        edition = "2018";
        sha256 = "0dmmxsq3m0i6g9s2kj96n777qhmm7vjgv4r7agc2v6w6bl7rdpx2";
        authors = [
          "Dzmitry Malyshau <kvarkus@gmail.com>"
        ];

      };
      "crc32fast" = rec {
        crateName = "crc32fast";
        version = "1.3.0";
        edition = "2015";
        sha256 = "0di8ip18srxbva7dvz8y9rqmmc43s1lc3nasl4fgr17az86jk33k";
        authors = [
          "Sam Rijs <srijs@airpost.net>"
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 1.0.0";
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "crossbeam-utils" = rec {
        crateName = "crossbeam-utils";
        version = "0.7.2";
        edition = "2015";
        sha256 = "1a31wbrda1320gj2a6az1lin2d34xfc3xf88da4c17qy5lxcgiy3";
        authors = [
          "The Crossbeam Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 0.1.10";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
            optional = true;
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg 1.0.1";
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "lazy_static" ];
        };
        resolvedDefaultFeatures = [ "default" "lazy_static" "std" ];
      };
      "crunchy" = rec {
        crateName = "crunchy";
        version = "0.2.2";
        edition = "2015";
        sha256 = "1dx9mypwd5mpfbbajm78xcrg5lirqk7934ik980mmaffg3hdm0bs";
        authors = [
          "Vurich <jackefransham@hotmail.co.uk>"
        ];
        features = {
          "default" = [ "limit_128" ];
        };
        resolvedDefaultFeatures = [ "default" "limit_128" ];
      };
      "dashmap" = rec {
        crateName = "dashmap";
        version = "3.11.10";
        edition = "2018";
        sha256 = "1ddrjj4khb0s263pw278g5dvbhaid40611h123s9w5shr0phw9hg";
        authors = [
          "Acrimon <joel.wejdenstal@gmail.com>"
        ];
        dependencies = [
          {
            name = "ahash";
            packageId = "ahash 0.3.8";
          }
          {
            name = "cfg-if";
            packageId = "cfg-if 0.1.10";
          }
          {
            name = "num_cpus";
            packageId = "num_cpus";
          }
        ];
        features = {
          "no_std" = [ "hashbrown" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "derive_more" = rec {
        crateName = "derive_more";
        version = "0.15.0";
        edition = "2015";
        sha256 = "1zks5bn7hmqfz927spmridk9bvy7ly4f38vls331x4hc4hq1653s";
        procMacro = true;
        authors = [
          "Jelte Fennema <github-tech@jeltef.nl>"
        ];
        dependencies = [
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2 0.4.30";
          }
          {
            name = "quote";
            packageId = "quote 0.6.13";
          }
          {
            name = "regex";
            packageId = "regex";
          }
          {
            name = "syn";
            packageId = "syn 0.15.44";
            features = [ "extra-traits" ];
          }
        ];
        buildDependencies = [
          {
            name = "rustc_version";
            packageId = "rustc_version";
          }
        ];
        features = {
        };
      };
      "dtoa" = rec {
        crateName = "dtoa";
        version = "0.4.8";
        edition = "2015";
        sha256 = "1c5j0wz118dhrczx6spc5za7dnbfxablr4adyahg9aknrsc9i2an";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];

      };
      "either" = rec {
        crateName = "either";
        version = "1.6.1";
        edition = "2015";
        sha256 = "0mwl9vngqf5jvrhmhn9x60kr5hivxyjxbmby2pybncxfqhf4z3g7";
        authors = [
          "bluss"
        ];
        features = {
          "default" = [ "use_std" ];
        };
        resolvedDefaultFeatures = [ "default" "use_std" ];
      };
      "encoding_rs" = rec {
        crateName = "encoding_rs";
        version = "0.8.29";
        edition = "2018";
        sha256 = "0in7l50j06qmzzwk0h6bs5kdlyj5zyx9ab745lrzd60v1adahkm7";
        authors = [
          "Henri Sivonen <hsivonen@hsivonen.fi>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 1.0.0";
          }
        ];
        features = {
          "default" = [ "alloc" ];
          "fast-legacy-encode" = [ "fast-hangul-encode" "fast-hanja-encode" "fast-kanji-encode" "fast-gb-hanzi-encode" "fast-big5-hanzi-encode" ];
          "simd-accel" = [ "packed_simd" "packed_simd/into_bits" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" ];
      };
      "enum-as-inner" = rec {
        crateName = "enum-as-inner";
        version = "0.2.1";
        edition = "2018";
        sha256 = "0zg3h7k3g1z7a9ayqy63sk302d4dg5g2h274ddv80mj4jxn2cn1x";
        procMacro = true;
        authors = [
          "Benjamin Fry <benjaminfry@me.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 0.4.30";
          }
          {
            name = "quote";
            packageId = "quote 0.6.13";
          }
          {
            name = "syn";
            packageId = "syn 0.15.44";
          }
        ];

      };
      "env_logger" = rec {
        crateName = "env_logger";
        version = "0.7.1";
        edition = "2018";
        sha256 = "0djx8h8xfib43g5w94r1m1mkky5spcw4wblzgnhiyg5vnfxknls4";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "atty";
            packageId = "atty";
            optional = true;
          }
          {
            name = "humantime";
            packageId = "humantime";
            optional = true;
          }
          {
            name = "log";
            packageId = "log";
            features = [ "std" ];
          }
          {
            name = "regex";
            packageId = "regex";
            optional = true;
          }
          {
            name = "termcolor";
            packageId = "termcolor";
            optional = true;
          }
        ];
        features = {
          "default" = [ "termcolor" "atty" "humantime" "regex" ];
        };
        resolvedDefaultFeatures = [ "atty" "default" "humantime" "regex" "termcolor" ];
      };
      "failure" = rec {
        crateName = "failure";
        version = "0.1.8";
        edition = "2015";
        sha256 = "11jg1wmbkijrs6bk9fqnbrm9zf0850whnqpgnxyswbn0dk8rnbnk";
        authors = [
          "Without Boats <boats@mozilla.com>"
        ];
        dependencies = [
          {
            name = "backtrace";
            packageId = "backtrace";
            optional = true;
          }
          {
            name = "failure_derive";
            packageId = "failure_derive";
            optional = true;
          }
        ];
        features = {
          "default" = [ "std" "derive" ];
          "derive" = [ "failure_derive" ];
          "std" = [ "backtrace" ];
        };
        resolvedDefaultFeatures = [ "backtrace" "default" "derive" "failure_derive" "std" ];
      };
      "failure_derive" = rec {
        crateName = "failure_derive";
        version = "0.1.8";
        edition = "2015";
        sha256 = "1936adqqk080439kx2bjf1bds7h89sg6wcif4jw0syndcv3s6kda";
        procMacro = true;
        authors = [
          "Without Boats <woboats@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 1.0.32";
          }
          {
            name = "quote";
            packageId = "quote 1.0.10";
          }
          {
            name = "syn";
            packageId = "syn 1.0.82";
          }
          {
            name = "synstructure";
            packageId = "synstructure";
          }
        ];
        features = {
        };
      };
      "flate2" = rec {
        crateName = "flate2";
        version = "1.0.22";
        edition = "2018";
        sha256 = "0gy5iwfqylb2f0dd9n7r8w2xwbzlrqlsairvyj2w9jf1jzl8hs8y";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "Josh Triplett <josh@joshtriplett.org>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 1.0.0";
          }
          {
            name = "crc32fast";
            packageId = "crc32fast";
          }
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "miniz-sys";
            packageId = "miniz-sys";
            optional = true;
          }
          {
            name = "miniz_oxide";
            packageId = "miniz_oxide";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "miniz_oxide";
            packageId = "miniz_oxide";
            usesDefaultFeatures = false;
            target = { target, features }: ((target."arch" == "wasm32") && (!(target."os" == "emscripten")));
          }
        ];
        features = {
          "cloudflare_zlib" = [ "any_zlib" "cloudflare-zlib-sys" ];
          "default" = [ "rust_backend" ];
          "rust_backend" = [ "miniz_oxide" ];
          "tokio" = [ "tokio-io" "futures" ];
          "zlib" = [ "any_zlib" "libz-sys" ];
          "zlib-ng-compat" = [ "zlib" "libz-sys/zlib-ng" ];
        };
        resolvedDefaultFeatures = [ "miniz-sys" ];
      };
      "fnv" = rec {
        crateName = "fnv";
        version = "1.0.7";
        edition = "2015";
        sha256 = "1hc2mcqha06aibcaza94vbi81j6pr9a1bbxrxjfhc91zin8yr7iz";
        libPath = "lib.rs";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "form_urlencoded" = rec {
        crateName = "form_urlencoded";
        version = "1.0.1";
        edition = "2018";
        sha256 = "1491fmakavcmsjbm3q6iy0bhmn9l422jasdhzx5hkljgza3mmhjz";
        authors = [
          "The rust-url developers"
        ];
        dependencies = [
          {
            name = "matches";
            packageId = "matches";
          }
          {
            name = "percent-encoding";
            packageId = "percent-encoding 2.1.0";
          }
        ];

      };
      "fuchsia-cprng" = rec {
        crateName = "fuchsia-cprng";
        version = "0.1.1";
        edition = "2018";
        sha256 = "1fnkqrbz7ixxzsb04bsz9p0zzazanma8znfdqjvh39n14vapfvx0";
        authors = [
          "Erick Tryzelaar <etryzelaar@google.com>"
        ];

      };
      "fuchsia-zircon" = rec {
        crateName = "fuchsia-zircon";
        version = "0.3.3";
        edition = "2015";
        sha256 = "10jxc5ks1x06gpd0xg51kcjrxr35nj6qhx2zlc5n7bmskv3675rf";
        authors = [
          "Raph Levien <raph@google.com>"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "fuchsia-zircon-sys";
            packageId = "fuchsia-zircon-sys";
          }
        ];

      };
      "fuchsia-zircon-sys" = rec {
        crateName = "fuchsia-zircon-sys";
        version = "0.3.3";
        edition = "2015";
        sha256 = "19zp2085qsyq2bh1gvcxq1lb8w6v6jj9kbdkhpdjrl95fypakjix";
        authors = [
          "Raph Levien <raph@google.com>"
        ];

      };
      "futures" = rec {
        crateName = "futures";
        version = "0.1.31";
        edition = "2015";
        sha256 = "0y46qbmhi37dqkch8dlfq5aninqpzqgrr98awkb3rn4fxww1lirs";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "use_std" "with-deprecated" ];
        };
        resolvedDefaultFeatures = [ "default" "use_std" "with-deprecated" ];
      };
      "getrandom 0.1.16" = rec {
        crateName = "getrandom";
        version = "0.1.16";
        edition = "2018";
        sha256 = "1kjzmz60qx9mn615ks1akjbf36n3lkv27zfwbcam0fzmj56wphwg";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 1.0.0";
          }
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "wasi";
            packageId = "wasi 0.9.0+wasi-snapshot-preview1";
            target = { target, features }: (target."os" == "wasi");
          }
        ];
        features = {
          "rustc-dep-of-std" = [ "compiler_builtins" "core" ];
          "test-in-browser" = [ "wasm-bindgen" ];
          "wasm-bindgen" = [ "bindgen" "js-sys" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "getrandom 0.2.3" = rec {
        crateName = "getrandom";
        version = "0.2.3";
        edition = "2018";
        sha256 = "0lr7mnkvnzdh1xxmwmhhbm4gwg29k3m2rzhpjmjm4k2jcfa9kkbz";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 1.0.0";
          }
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "wasi";
            packageId = "wasi 0.10.2+wasi-snapshot-preview1";
            target = { target, features }: (target."os" == "wasi");
          }
        ];
        features = {
          "js" = [ "wasm-bindgen" "js-sys" ];
          "rustc-dep-of-std" = [ "compiler_builtins" "core" "libc/rustc-dep-of-std" "wasi/rustc-dep-of-std" ];
        };
      };
      "gimli" = rec {
        crateName = "gimli";
        version = "0.26.1";
        edition = "2018";
        sha256 = "1m0vi36ypv4gx9gzcw6y456yqnlypizhwlcqrmg6vkwd0lnkgk3q";
        features = {
          "default" = [ "read" "write" "std" "fallible-iterator" "endian-reader" ];
          "endian-reader" = [ "read" "stable_deref_trait" ];
          "read" = [ "read-core" ];
          "rustc-dep-of-std" = [ "core" "alloc" "compiler_builtins" ];
          "std" = [ "fallible-iterator/std" "stable_deref_trait/std" ];
          "write" = [ "indexmap" ];
        };
        resolvedDefaultFeatures = [ "read" "read-core" ];
      };
      "h2" = rec {
        crateName = "h2";
        version = "0.1.26";
        edition = "2015";
        sha256 = "0qn457y8xh03p7c7cpk76r22gqpyqxc58g5022j3iya7d0j4rcx5";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "byteorder";
            packageId = "byteorder";
          }
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "fnv";
            packageId = "fnv";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "http";
            packageId = "http";
          }
          {
            name = "indexmap";
            packageId = "indexmap";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "slab";
            packageId = "slab";
          }
          {
            name = "string";
            packageId = "string";
          }
          {
            name = "tokio-io";
            packageId = "tokio-io";
          }
        ];
        features = {
        };
      };
      "hashbrown 0.11.2" = rec {
        crateName = "hashbrown";
        version = "0.11.2";
        edition = "2018";
        sha256 = "0vkjsf5nzs7qcia5ya79j9sq2p1caz4crrncr1675wwyj3ag0pmb";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        features = {
          "ahash-compile-time-rng" = [ "ahash/compile-time-rng" ];
          "default" = [ "ahash" "inline-more" ];
          "rustc-dep-of-std" = [ "nightly" "core" "compiler_builtins" "alloc" "rustc-internal-api" ];
        };
        resolvedDefaultFeatures = [ "raw" ];
      };
      "hashbrown 0.6.3" = rec {
        crateName = "hashbrown";
        version = "0.6.3";
        edition = "2018";
        sha256 = "1bbf9k46v57zi41m6hjwn83rjldyipv5zwxmdsa7a9c1rb876q4f";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        dependencies = [
          {
            name = "ahash";
            packageId = "ahash 0.2.19";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg 0.1.7";
          }
        ];
        features = {
          "ahash-compile-time-rng" = [ "ahash/compile-time-rng" ];
          "default" = [ "ahash" "ahash-compile-time-rng" "inline-more" ];
          "rustc-dep-of-std" = [ "nightly" "core" "compiler_builtins" "alloc" "rustc-internal-api" ];
        };
        resolvedDefaultFeatures = [ "ahash" "ahash-compile-time-rng" "default" "inline-more" ];
      };
      "hermit-abi" = rec {
        crateName = "hermit-abi";
        version = "0.1.19";
        edition = "2018";
        sha256 = "0cxcm8093nf5fyn114w8vxbrbcyvv91d4015rdnlgfll7cs6gd32";
        authors = [
          "Stefan Lankes"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "compiler_builtins/rustc-dep-of-std" "libc/rustc-dep-of-std" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "hostname" = rec {
        crateName = "hostname";
        version = "0.3.1";
        edition = "2015";
        sha256 = "0rz8yf70cvzl3nry71m4bz9w6x4j9kdz3qng6pnwhk2h20z1qwrw";
        authors = [
          "fengcen <fengcen.love@gmail.com>"
          "svartalf <self@svartalf.info>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: ((target."unix" or false) || (target."os" == "redox"));
          }
          {
            name = "match_cfg";
            packageId = "match_cfg";
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."os" == "windows");
            features = [ "sysinfoapi" ];
          }
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "http" = rec {
        crateName = "http";
        version = "0.1.21";
        edition = "2015";
        sha256 = "1w21xnhd8f48zvbmm5njg2y1nb4p08ppn8r0cs2xi5d8wgnzbk6n";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "Carl Lerche <me@carllerche.com>"
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "fnv";
            packageId = "fnv";
          }
          {
            name = "itoa";
            packageId = "itoa";
          }
        ];

      };
      "httparse" = rec {
        crateName = "httparse";
        version = "1.5.1";
        edition = "2015";
        sha256 = "00smbrgb9vyzbbj3j5d66iarjl5x2wpfwkmhcy5nizylw7dlzndc";
        authors = [
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "humantime" = rec {
        crateName = "humantime";
        version = "1.3.0";
        edition = "2015";
        sha256 = "0krwgbf35pd46xvkqg14j070vircsndabahahlv3rwhflpy4q06z";
        authors = [
          "Paul Colomiets <paul@colomiets.name>"
        ];
        dependencies = [
          {
            name = "quick-error";
            packageId = "quick-error";
          }
        ];

      };
      "id-set" = rec {
        crateName = "id-set";
        version = "0.2.2";
        edition = "2015";
        sha256 = "0r4jshsamlkd2999hkg89jn84vdw714bl68iagw6qia6cggzlcwn";
        authors = [
          "Andrew Hickman <andrew.hickman1@sky.com>"
        ];

      };
      "idna 0.1.5" = rec {
        crateName = "idna";
        version = "0.1.5";
        edition = "2015";
        sha256 = "0kl4gs5kaydn4v07c6ka33spm9qdh2np0x7iw7g5zd8z1c7rxw1q";
        authors = [
          "The rust-url developers"
        ];
        dependencies = [
          {
            name = "matches";
            packageId = "matches";
          }
          {
            name = "unicode-bidi";
            packageId = "unicode-bidi";
          }
          {
            name = "unicode-normalization";
            packageId = "unicode-normalization";
          }
        ];

      };
      "idna 0.2.3" = rec {
        crateName = "idna";
        version = "0.2.3";
        edition = "2018";
        sha256 = "1y7ca2w5qp9msgl57n03zqp78gq1bk2crqzg6kv7a542mdphm2j1";
        authors = [
          "The rust-url developers"
        ];
        dependencies = [
          {
            name = "matches";
            packageId = "matches";
          }
          {
            name = "unicode-bidi";
            packageId = "unicode-bidi";
          }
          {
            name = "unicode-normalization";
            packageId = "unicode-normalization";
          }
        ];

      };
      "indexmap" = rec {
        crateName = "indexmap";
        version = "1.7.0";
        edition = "2018";
        sha256 = "19b2zwfajhsfcgny0clv8y4jppy704znfhv8nv2dw9a18l2kcqxw";
        authors = [
          "bluss"
          "Josh Stone <cuviper@gmail.com>"
        ];
        dependencies = [
          {
            name = "hashbrown";
            packageId = "hashbrown 0.11.2";
            usesDefaultFeatures = false;
            features = [ "raw" ];
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg 1.0.1";
          }
        ];
        features = {
          "serde-1" = [ "serde" ];
        };
      };
      "instant" = rec {
        crateName = "instant";
        version = "0.1.12";
        edition = "2018";
        sha256 = "0b2bx5qdlwayriidhrag8vhy10kdfimfhmb3jnjmsz2h9j1bwnvs";
        authors = [
          "sebcrozet <developer@crozet.re>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 1.0.0";
          }
        ];
        features = {
          "wasm-bindgen" = [ "js-sys" "wasm-bindgen_rs" "web-sys" ];
        };
      };
      "iovec" = rec {
        crateName = "iovec";
        version = "0.1.4";
        edition = "2015";
        sha256 = "0ph73qygwx8i0mblrf110cj59l00gkmsgrpzz1rm85syz5pymcxj";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" or false);
          }
        ];

      };
      "ipconfig" = rec {
        crateName = "ipconfig";
        version = "0.2.2";
        edition = "2018";
        sha256 = "1mzsagc6bk3i3fpggqlq8am5rxn4hgs297rsaya90w79xj5g3qpp";
        authors = [
          "Liran Ringel <liranringel@gmail.com>"
        ];
        dependencies = [
          {
            name = "socket2";
            packageId = "socket2";
            target = { target, features }: (target."windows" or false);
          }
          {
            name = "widestring";
            packageId = "widestring";
            target = { target, features }: (target."windows" or false);
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
          }
          {
            name = "winreg";
            packageId = "winreg";
            target = { target, features }: (target."windows" or false);
          }
        ];

      };
      "itoa" = rec {
        crateName = "itoa";
        version = "0.4.8";
        edition = "2015";
        sha256 = "1m1dairwyx8kfxi7ab3b5jc71z1vigh9w4shnhiajji9avzr26dp";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "kernel32-sys" = rec {
        crateName = "kernel32-sys";
        version = "0.2.2";
        edition = "2015";
        sha256 = "1389av0601a9yz8dvx5zha9vmkd6ik7ax0idpb032d28555n41vm";
        libName = "kernel32";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi 0.2.8";
          }
        ];
        buildDependencies = [
          {
            name = "winapi-build";
            packageId = "winapi-build";
          }
        ];

      };
      "language-tags" = rec {
        crateName = "language-tags";
        version = "0.2.2";
        edition = "2015";
        sha256 = "16hrjdpa827carq5x4b8zhas24d8kg4s16m6nmmn1kb7cr5qh7d9";
        authors = [
          "Pyfisch <pyfisch@gmail.com>"
        ];
        features = {
          "heap_size" = [ "heapsize" "heapsize_plugin" ];
        };
      };
      "lazy_static" = rec {
        crateName = "lazy_static";
        version = "1.4.0";
        edition = "2015";
        sha256 = "0in6ikhw8mgl33wjv6q6xfrb5b9jr16q8ygjy803fay4zcisvaz2";
        authors = [
          "Marvin Löbel <loebel.marvin@gmail.com>"
        ];
        features = {
          "spin_no_std" = [ "spin" ];
        };
      };
      "libc" = rec {
        crateName = "libc";
        version = "0.2.108";
        edition = "2015";
        sha256 = "06finl0p44lvqyw7s0qgc7bgmdz771gfg6bmmxlyrcbngsss28c5";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "align" "rustc-std-workspace-core" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "align" "default" "std" ];
      };
      "linked-hash-map" = rec {
        crateName = "linked-hash-map";
        version = "0.5.4";
        edition = "2015";
        sha256 = "1ww8zsraqnvrsknd315481185igwkx5n14xnhq5i8216z65b7fbz";
        authors = [
          "Stepan Koltsov <stepan.koltsov@gmail.com>"
          "Andrew Paseltiner <apaseltiner@gmail.com>"
        ];
        features = {
          "heapsize_impl" = [ "heapsize" ];
          "serde_impl" = [ "serde" "serde_test" ];
        };
      };
      "lock_api 0.3.4" = rec {
        crateName = "lock_api";
        version = "0.3.4";
        edition = "2018";
        sha256 = "0xgc5dzmajh0akbh5d6d7rj9mh5rzpk74pyrc946v2ixgakj9nn4";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        dependencies = [
          {
            name = "scopeguard";
            packageId = "scopeguard";
            usesDefaultFeatures = false;
          }
        ];
        features = {
        };
      };
      "lock_api 0.4.5" = rec {
        crateName = "lock_api";
        version = "0.4.5";
        edition = "2018";
        sha256 = "028izfyraynijd9h9x5miv1vmg6sjnw1v95wgm7f4xlr7h4lsaki";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        dependencies = [
          {
            name = "scopeguard";
            packageId = "scopeguard";
            usesDefaultFeatures = false;
          }
        ];
        features = {
        };
      };
      "log" = rec {
        crateName = "log";
        version = "0.4.14";
        edition = "2015";
        sha256 = "04175hv0v62shd82qydq58a48k3bjijmk54v38zgqlbxqkkbpfai";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 1.0.0";
          }
        ];
        features = {
          "kv_unstable" = [ "value-bag" ];
          "kv_unstable_serde" = [ "kv_unstable_std" "value-bag/serde" "serde" ];
          "kv_unstable_std" = [ "std" "kv_unstable" "value-bag/error" ];
          "kv_unstable_sval" = [ "kv_unstable" "value-bag/sval" "sval" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "lru-cache" = rec {
        crateName = "lru-cache";
        version = "0.1.2";
        edition = "2015";
        sha256 = "071viv6g2p3akwqmfb3c8vsycs5n7kr17b70l7la071jv0d4zqii";
        authors = [
          "Stepan Koltsov <stepan.koltsov@gmail.com>"
        ];
        dependencies = [
          {
            name = "linked-hash-map";
            packageId = "linked-hash-map";
          }
        ];
        features = {
          "heapsize_impl" = [ "heapsize" "linked-hash-map/heapsize_impl" ];
        };
      };
      "match_cfg" = rec {
        crateName = "match_cfg";
        version = "0.1.0";
        edition = "2015";
        sha256 = "1r5j3zqc3qr8ybcx95bk8q57mkizmgmffj5lmicd4i8d9riyigpz";
        authors = [
          "gnzlbg <gonzalobg88@gmail.com>"
        ];
        features = {
          "default" = [ "use_core" ];
        };
        resolvedDefaultFeatures = [ "default" "use_core" ];
      };
      "matches" = rec {
        crateName = "matches";
        version = "0.1.9";
        edition = "2015";
        sha256 = "0gw5ib38jfgyyah8nyyxr036grqv1arkf1srgfa4h386dav7iqx3";
        libPath = "lib.rs";
        authors = [
          "Simon Sapin <simon.sapin@exyr.org>"
        ];

      };
      "maybe-uninit" = rec {
        crateName = "maybe-uninit";
        version = "2.0.0";
        edition = "2015";
        sha256 = "004y0nzmpfdrhz251278341z6ql34iv1k6dp1h6af7d6nd6jwc30";
        authors = [
          "est31 <MTest31@outlook.com>"
          "The Rust Project Developers"
        ];

      };
      "memchr" = rec {
        crateName = "memchr";
        version = "2.4.1";
        edition = "2018";
        sha256 = "0smq8xzd40njqpfzv5mghigj91fzlfrfg842iz8x0wqvw2dw731h";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
          "bluss"
        ];
        features = {
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "mime" = rec {
        crateName = "mime";
        version = "0.3.16";
        edition = "2015";
        sha256 = "13dcm9lh01hdwfjcg74ppljyjfj1c6w3a3cwkhxf0w8wa37cfq1a";
        authors = [
          "Sean McArthur <sean@seanmonstar.com>"
        ];

      };
      "miniz-sys" = rec {
        crateName = "miniz-sys";
        version = "0.1.12";
        edition = "2015";
        sha256 = "00l2r4anm8g35x0js2zfdnwfbrih9m43vphdpb77c5ga3kjkm7hy";
        libName = "miniz_sys";
        libPath = "lib.rs";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
          }
        ];
        buildDependencies = [
          {
            name = "cc";
            packageId = "cc";
          }
        ];

      };
      "miniz_oxide" = rec {
        crateName = "miniz_oxide";
        version = "0.4.4";
        edition = "2018";
        sha256 = "0jsfv00hl5rmx1nijn59sr9jmjd4rjnjhh4kdjy8d187iklih9d9";
        authors = [
          "Frommi <daniil.liferenko@gmail.com>"
          "oyvindln <oyvindln@users.noreply.github.com>"
        ];
        dependencies = [
          {
            name = "adler";
            packageId = "adler";
            usesDefaultFeatures = false;
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg 1.0.1";
          }
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "alloc" "compiler_builtins" "adler/rustc-dep-of-std" ];
        };
      };
      "mio" = rec {
        crateName = "mio";
        version = "0.6.23";
        edition = "2015";
        sha256 = "1i2c1vl8lr45apkh8xbh9k56ihfsmqff5l7s2fya7whvp7sndzaa";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 0.1.10";
          }
          {
            name = "fuchsia-zircon";
            packageId = "fuchsia-zircon";
            target = { target, features }: (target."os" == "fuchsia");
          }
          {
            name = "fuchsia-zircon-sys";
            packageId = "fuchsia-zircon-sys";
            target = { target, features }: (target."os" == "fuchsia");
          }
          {
            name = "iovec";
            packageId = "iovec";
          }
          {
            name = "kernel32-sys";
            packageId = "kernel32-sys";
            target = { target, features }: (target."windows" or false);
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "miow";
            packageId = "miow";
            target = { target, features }: (target."windows" or false);
          }
          {
            name = "net2";
            packageId = "net2";
          }
          {
            name = "slab";
            packageId = "slab";
          }
          {
            name = "winapi";
            packageId = "winapi 0.2.8";
            target = { target, features }: (target."windows" or false);
          }
        ];
        features = {
          "default" = [ "with-deprecated" ];
        };
        resolvedDefaultFeatures = [ "default" "with-deprecated" ];
      };
      "mio-uds" = rec {
        crateName = "mio-uds";
        version = "0.6.8";
        edition = "2015";
        sha256 = "1w36w09gd8as1mah80wdy0kgpshmphmljj68gij34hvdnag6kjxg";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "iovec";
            packageId = "iovec";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "mio";
            packageId = "mio";
            target = { target, features }: (target."unix" or false);
          }
        ];

      };
      "miow" = rec {
        crateName = "miow";
        version = "0.2.2";
        edition = "2015";
        sha256 = "0kcl8rnv0bhiarcdakik670w8fnxzlxhi1ys7152sck68510in7b";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "kernel32-sys";
            packageId = "kernel32-sys";
          }
          {
            name = "net2";
            packageId = "net2";
            usesDefaultFeatures = false;
          }
          {
            name = "winapi";
            packageId = "winapi 0.2.8";
          }
          {
            name = "ws2_32-sys";
            packageId = "ws2_32-sys";
          }
        ];

      };
      "net2" = rec {
        crateName = "net2";
        version = "0.2.37";
        edition = "2015";
        sha256 = "1bk8jp0i12gvhrlaqbfq19ancja70r1rg3sywbhjl0385g8k05ir";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 0.1.10";
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: ((target."os" == "redox") || (target."unix" or false) || (target."os" == "wasi"));
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "handleapi" "winsock2" "ws2def" "ws2ipdef" "ws2tcpip" ];
          }
        ];
        features = {
          "default" = [ "duration" ];
        };
        resolvedDefaultFeatures = [ "default" "duration" ];
      };
      "nohash-hasher" = rec {
        crateName = "nohash-hasher";
        version = "0.2.0";
        edition = "2018";
        sha256 = "0lf4p6k01w4wm7zn4grnihzj8s7zd5qczjmzng7wviwxawih5x9b";
        authors = [
          "Parity Technologies <admin@parity.io>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "num-integer" = rec {
        crateName = "num-integer";
        version = "0.1.44";
        edition = "2015";
        sha256 = "1nq152y3304as1iai95hqz8prqnc94lks1s7q05sfjdmcf56kk6j";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "num-traits";
            packageId = "num-traits";
            usesDefaultFeatures = false;
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg 1.0.1";
          }
        ];
        features = {
          "default" = [ "std" ];
          "i128" = [ "num-traits/i128" ];
          "std" = [ "num-traits/std" ];
        };
      };
      "num-traits" = rec {
        crateName = "num-traits";
        version = "0.2.14";
        edition = "2015";
        sha256 = "144j176s2p76azy2ngk2vkdzgwdc0bc8c93jhki8c9fsbknb2r4s";
        authors = [
          "The Rust Project Developers"
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg 1.0.1";
          }
        ];
        features = {
          "default" = [ "std" ];
        };
      };
      "num_cpus" = rec {
        crateName = "num_cpus";
        version = "1.13.0";
        edition = "2015";
        sha256 = "1cv6yxhz2zbnwn8pn1yn8grg7zsnd523947fby41a737aqvryj85";
        authors = [
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        dependencies = [
          {
            name = "hermit-abi";
            packageId = "hermit-abi";
            target = { target, features }: (((target."arch" == "x86_64") || (target."arch" == "aarch64")) && (target."os" == "hermit"));
          }
          {
            name = "libc";
            packageId = "libc";
          }
        ];

      };
      "object" = rec {
        crateName = "object";
        version = "0.27.1";
        edition = "2018";
        sha256 = "1ygv9zgi9wz6q5f2z9xn72i0c97jjr1dgj30kbyicdhxk8zivb37";
        dependencies = [
          {
            name = "memchr";
            packageId = "memchr";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "all" = [ "read" "write" "std" "compression" "wasm" ];
          "compression" = [ "flate2" "std" ];
          "default" = [ "read" "compression" ];
          "doc" = [ "read_core" "write_core" "std" "compression" "archive" "coff" "elf" "macho" "pe" "wasm" ];
          "pe" = [ "coff" ];
          "read" = [ "read_core" "archive" "coff" "elf" "macho" "pe" "unaligned" ];
          "rustc-dep-of-std" = [ "core" "compiler_builtins" "alloc" "memchr/rustc-dep-of-std" ];
          "std" = [ "memchr/std" ];
          "wasm" = [ "wasmparser" ];
          "write" = [ "write_core" "coff" "elf" "macho" "pe" ];
          "write_core" = [ "crc32fast" "indexmap/std" "std" ];
        };
        resolvedDefaultFeatures = [ "archive" "coff" "elf" "macho" "pe" "read_core" "unaligned" ];
      };
      "parking_lot 0.11.2" = rec {
        crateName = "parking_lot";
        version = "0.11.2";
        edition = "2018";
        sha256 = "16gzf41bxmm10x82bla8d6wfppy9ym3fxsmdjyvn61m66s0bf5vx";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        dependencies = [
          {
            name = "instant";
            packageId = "instant";
          }
          {
            name = "lock_api";
            packageId = "lock_api 0.4.5";
          }
          {
            name = "parking_lot_core";
            packageId = "parking_lot_core 0.8.5";
          }
        ];
        features = {
          "arc_lock" = [ "lock_api/arc_lock" ];
          "deadlock_detection" = [ "parking_lot_core/deadlock_detection" ];
          "nightly" = [ "parking_lot_core/nightly" "lock_api/nightly" ];
          "owning_ref" = [ "lock_api/owning_ref" ];
          "serde" = [ "lock_api/serde" ];
          "stdweb" = [ "instant/stdweb" ];
          "wasm-bindgen" = [ "instant/wasm-bindgen" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "parking_lot 0.9.0" = rec {
        crateName = "parking_lot";
        version = "0.9.0";
        edition = "2018";
        sha256 = "0lk2vq3hp88ygpgsrypdr3ss71fidnqbykva0csgxhmn5scb2hpq";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        dependencies = [
          {
            name = "lock_api";
            packageId = "lock_api 0.3.4";
          }
          {
            name = "parking_lot_core";
            packageId = "parking_lot_core 0.6.2";
          }
        ];
        buildDependencies = [
          {
            name = "rustc_version";
            packageId = "rustc_version";
          }
        ];
        features = {
          "deadlock_detection" = [ "parking_lot_core/deadlock_detection" ];
          "nightly" = [ "parking_lot_core/nightly" "lock_api/nightly" ];
          "owning_ref" = [ "lock_api/owning_ref" ];
          "serde" = [ "lock_api/serde" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "parking_lot_core 0.6.2" = rec {
        crateName = "parking_lot_core";
        version = "0.6.2";
        edition = "2018";
        sha256 = "0ay67dpnrn68ryyvp720m9i8hzp189fd4d6slrs1lvmcwywv2xmq";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 0.1.10";
          }
          {
            name = "cloudabi";
            packageId = "cloudabi";
            target = { target, features }: (target."os" == "cloudabi");
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "redox_syscall";
            packageId = "redox_syscall 0.1.57";
            target = { target, features }: (target."os" == "redox");
          }
          {
            name = "smallvec";
            packageId = "smallvec 0.6.14";
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "winnt" "ntstatus" "minwindef" "winerror" "winbase" "errhandlingapi" "handleapi" ];
          }
        ];
        buildDependencies = [
          {
            name = "rustc_version";
            packageId = "rustc_version";
          }
        ];
        features = {
          "deadlock_detection" = [ "petgraph" "thread-id" "backtrace" ];
        };
      };
      "parking_lot_core 0.8.5" = rec {
        crateName = "parking_lot_core";
        version = "0.8.5";
        edition = "2018";
        sha256 = "05ij4zxsylx99srbq8qd1k2wiwaq8krkf9y4cqkhvb5wjca8wvnp";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 1.0.0";
          }
          {
            name = "instant";
            packageId = "instant";
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "redox_syscall";
            packageId = "redox_syscall 0.2.10";
            target = { target, features }: (target."os" == "redox");
          }
          {
            name = "smallvec";
            packageId = "smallvec 1.7.0";
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "winnt" "ntstatus" "minwindef" "winerror" "winbase" "errhandlingapi" "handleapi" ];
          }
        ];
        features = {
          "deadlock_detection" = [ "petgraph" "thread-id" "backtrace" ];
        };
      };
      "percent-encoding 1.0.1" = rec {
        crateName = "percent-encoding";
        version = "1.0.1";
        edition = "2015";
        sha256 = "0cgq08v1fvr6bs5fvy390cz830lq4fak8havdasdacxcw790s09i";
        libPath = "lib.rs";
        authors = [
          "The rust-url developers"
        ];

      };
      "percent-encoding 2.1.0" = rec {
        crateName = "percent-encoding";
        version = "2.1.0";
        edition = "2015";
        sha256 = "0bp3zrsk3kr47fbpipyczidbbx4g54lzxdm77ni1i3qws10mdzfl";
        libPath = "lib.rs";
        authors = [
          "The rust-url developers"
        ];

      };
      "pico-args" = rec {
        crateName = "pico-args";
        version = "0.4.2";
        edition = "2018";
        sha256 = "0s646i0pbcck300rqldb21m151zxp66m3mdskha063blrfbcv2yv";
        authors = [
          "Evgeniy Reizner <razrfalcon@gmail.com>"
        ];
        features = {
          "default" = [ "eq-separator" ];
        };
        resolvedDefaultFeatures = [ "default" "eq-separator" ];
      };
      "ppv-lite86" = rec {
        crateName = "ppv-lite86";
        version = "0.2.15";
        edition = "2018";
        sha256 = "1fimwnyyh3wx33r5s77lw5g5vcxhw1p5j60pdvbbwr8l374gn37d";
        authors = [
          "The CryptoCorrosion Contributors"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "simd" "std" ];
      };
      "proc-macro-hack" = rec {
        crateName = "proc-macro-hack";
        version = "0.5.19";
        edition = "2018";
        sha256 = "1rg0kzsj7lj00qj602d3h77spwfz48vixn1wbjp7a4yrq65w9w6v";
        procMacro = true;
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];

      };
      "proc-macro2 0.4.30" = rec {
        crateName = "proc-macro2";
        version = "0.4.30";
        edition = "2015";
        sha256 = "0nd71fl24sys066jrha6j7i34nfkjv44yzw8yww9742wmc8j0gfg";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "unicode-xid";
            packageId = "unicode-xid 0.1.0";
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "proc-macro2 1.0.32" = rec {
        crateName = "proc-macro2";
        version = "1.0.32";
        edition = "2018";
        sha256 = "0hqbxlvhiaybakl1gai3mgps1dxsmxricxsr2rfdrh222z0qql5s";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "unicode-xid";
            packageId = "unicode-xid 0.2.2";
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "quick-error" = rec {
        crateName = "quick-error";
        version = "1.2.3";
        edition = "2015";
        sha256 = "1q6za3v78hsspisc197bg3g7rpc989qycy8ypr8ap8igv10ikl51";
        authors = [
          "Paul Colomiets <paul@colomiets.name>"
          "Colin Kiegel <kiegel@gmx.de>"
        ];

      };
      "quote 0.6.13" = rec {
        crateName = "quote";
        version = "0.6.13";
        edition = "2015";
        sha256 = "1qgqq48jymp5h4y082aanf25hrw6bpb678xh3zw993qfhxmkpqkc";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 0.4.30";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
          "proc-macro" = [ "proc-macro2/proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "quote 1.0.10" = rec {
        crateName = "quote";
        version = "1.0.10";
        edition = "2018";
        sha256 = "01ff7a76f871ggnby57iagw6499vci4bihcr11g6bqzjlp38rg1q";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 1.0.32";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
          "proc-macro" = [ "proc-macro2/proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "rand 0.6.5" = rec {
        crateName = "rand";
        version = "0.6.5";
        edition = "2015";
        sha256 = "1jl4449jcl4wgmzld6ffwqj5gwxrp8zvx8w573g1z368qg6xlwbd";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "rand_chacha";
            packageId = "rand_chacha 0.1.1";
          }
          {
            name = "rand_core";
            packageId = "rand_core 0.4.2";
          }
          {
            name = "rand_hc";
            packageId = "rand_hc 0.1.0";
          }
          {
            name = "rand_isaac";
            packageId = "rand_isaac";
          }
          {
            name = "rand_jitter";
            packageId = "rand_jitter";
          }
          {
            name = "rand_os";
            packageId = "rand_os";
            optional = true;
          }
          {
            name = "rand_pcg";
            packageId = "rand_pcg";
          }
          {
            name = "rand_xorshift";
            packageId = "rand_xorshift";
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "minwindef" "ntsecapi" "profileapi" "winnt" ];
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg 0.1.7";
          }
        ];
        features = {
          "alloc" = [ "rand_core/alloc" ];
          "default" = [ "std" ];
          "nightly" = [ "simd_support" ];
          "serde1" = [ "rand_core/serde1" "rand_isaac/serde1" "rand_xorshift/serde1" ];
          "simd_support" = [ "packed_simd" ];
          "std" = [ "rand_core/std" "alloc" "rand_os" "rand_jitter/std" ];
          "stdweb" = [ "rand_os/stdweb" ];
          "wasm-bindgen" = [ "rand_os/wasm-bindgen" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "rand_os" "std" ];
      };
      "rand 0.7.3" = rec {
        crateName = "rand";
        version = "0.7.3";
        edition = "2018";
        sha256 = "00sdaimkbz491qgi6qxkv582yivl32m2jd401kzbn94vsiwicsva";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "getrandom";
            packageId = "getrandom 0.1.16";
            rename = "getrandom_package";
            optional = true;
          }
          {
            name = "libc";
            packageId = "libc";
            optional = true;
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "rand_chacha";
            packageId = "rand_chacha 0.2.2";
            usesDefaultFeatures = false;
            target = { target, features }: (!(target."os" == "emscripten"));
          }
          {
            name = "rand_core";
            packageId = "rand_core 0.5.1";
          }
          {
            name = "rand_hc";
            packageId = "rand_hc 0.2.0";
            target = { target, features }: (target."os" == "emscripten");
          }
        ];
        devDependencies = [
          {
            name = "rand_hc";
            packageId = "rand_hc 0.2.0";
          }
        ];
        features = {
          "alloc" = [ "rand_core/alloc" ];
          "default" = [ "std" ];
          "getrandom" = [ "getrandom_package" "rand_core/getrandom" ];
          "nightly" = [ "simd_support" ];
          "simd_support" = [ "packed_simd" ];
          "small_rng" = [ "rand_pcg" ];
          "std" = [ "rand_core/std" "rand_chacha/std" "alloc" "getrandom" "libc" ];
          "stdweb" = [ "getrandom_package/stdweb" ];
          "wasm-bindgen" = [ "getrandom_package/wasm-bindgen" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "getrandom" "getrandom_package" "libc" "std" ];
      };
      "rand_chacha 0.1.1" = rec {
        crateName = "rand_chacha";
        version = "0.1.1";
        edition = "2015";
        sha256 = "1vxwyzs4fy1ffjc8l00fsyygpiss135irjf7nyxgq2v0lqf3lvam";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.3.1";
            usesDefaultFeatures = false;
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg 0.1.7";
          }
        ];

      };
      "rand_chacha 0.2.2" = rec {
        crateName = "rand_chacha";
        version = "0.2.2";
        edition = "2018";
        sha256 = "00il36fkdbsmpr99p9ksmmp6dn1md7rmnwmz0rr77jbrca2yvj7l";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
          "The CryptoCorrosion Contributors"
        ];
        dependencies = [
          {
            name = "ppv-lite86";
            packageId = "ppv-lite86";
            usesDefaultFeatures = false;
            features = [ "simd" ];
          }
          {
            name = "rand_core";
            packageId = "rand_core 0.5.1";
          }
        ];
        features = {
          "default" = [ "std" "simd" ];
          "std" = [ "ppv-lite86/std" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "rand_core 0.3.1" = rec {
        crateName = "rand_core";
        version = "0.3.1";
        edition = "2015";
        sha256 = "0jzdgszfa4bliigiy4hi66k7fs3gfwi2qxn8vik84ph77fwdwvvs";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.4.2";
          }
        ];
        features = {
          "alloc" = [ "rand_core/alloc" ];
          "default" = [ "std" ];
          "serde1" = [ "rand_core/serde1" ];
          "std" = [ "rand_core/std" ];
        };
      };
      "rand_core 0.4.2" = rec {
        crateName = "rand_core";
        version = "0.4.2";
        edition = "2015";
        sha256 = "1p09ynysrq1vcdlmcqnapq4qakl2yd1ng3kxh3qscpx09k2a6cww";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        features = {
          "serde1" = [ "serde" "serde_derive" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "std" ];
      };
      "rand_core 0.5.1" = rec {
        crateName = "rand_core";
        version = "0.5.1";
        edition = "2018";
        sha256 = "06bdvx08v3rkz451cm7z59xwwqn1rkfh6v9ay77b14f8dwlybgch";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "getrandom";
            packageId = "getrandom 0.1.16";
            optional = true;
          }
        ];
        features = {
          "serde1" = [ "serde" ];
          "std" = [ "alloc" "getrandom" "getrandom/std" ];
        };
        resolvedDefaultFeatures = [ "alloc" "getrandom" "std" ];
      };
      "rand_hc 0.1.0" = rec {
        crateName = "rand_hc";
        version = "0.1.0";
        edition = "2015";
        sha256 = "1i0vl8q5ddvvy0x8hf1zxny393miyzxkwqnw31ifg6p0gdy6fh3v";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.3.1";
            usesDefaultFeatures = false;
          }
        ];

      };
      "rand_hc 0.2.0" = rec {
        crateName = "rand_hc";
        version = "0.2.0";
        edition = "2018";
        sha256 = "0g31sqwpmsirdlwr0svnacr4dbqyz339im4ssl9738cjgfpjjcfa";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.5.1";
          }
        ];

      };
      "rand_isaac" = rec {
        crateName = "rand_isaac";
        version = "0.1.1";
        edition = "2015";
        sha256 = "027flpjr4znx2csxk7gxb7vrf9c7y5mydmvg5az2afgisp4rgnfy";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.3.1";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "serde1" = [ "serde" "serde_derive" "rand_core/serde1" ];
        };
      };
      "rand_jitter" = rec {
        crateName = "rand_jitter";
        version = "0.1.4";
        edition = "2015";
        sha256 = "16z387y46bfz3csc42zxbjq89vcr1axqacncvv8qhyy93p4xarhi";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: ((target."os" == "macos") || (target."os" == "ios"));
          }
          {
            name = "rand_core";
            packageId = "rand_core 0.4.2";
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."os" == "windows");
            features = [ "profileapi" ];
          }
        ];
        features = {
          "std" = [ "rand_core/std" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "rand_os" = rec {
        crateName = "rand_os";
        version = "0.1.3";
        edition = "2015";
        sha256 = "0wahppm0s64gkr2vmhcgwc0lij37in1lgfxg5rbgqlz0l5vgcxbv";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "cloudabi";
            packageId = "cloudabi";
            target = { target, features }: (target."os" == "cloudabi");
          }
          {
            name = "fuchsia-cprng";
            packageId = "fuchsia-cprng";
            target = { target, features }: (target."os" == "fuchsia");
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "rand_core";
            packageId = "rand_core 0.4.2";
            features = [ "std" ];
          }
          {
            name = "rdrand";
            packageId = "rdrand";
            target = { target, features }: (target."env" == "sgx");
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "minwindef" "ntsecapi" "winnt" ];
          }
        ];

      };
      "rand_pcg" = rec {
        crateName = "rand_pcg";
        version = "0.1.2";
        edition = "2015";
        sha256 = "0i0bdla18a8x4jn1w0fxsbs3jg7ajllz6azmch1zw33r06dv1ydb";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.4.2";
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg 0.1.7";
          }
        ];
        features = {
          "serde1" = [ "serde" "serde_derive" ];
        };
      };
      "rand_xorshift" = rec {
        crateName = "rand_xorshift";
        version = "0.1.1";
        edition = "2015";
        sha256 = "0p2x8nr00hricpi2m6ca5vysiha7ybnghz79yqhhx6sl4gkfkxyb";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.3.1";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "serde1" = [ "serde" "serde_derive" ];
        };
      };
      "rdrand" = rec {
        crateName = "rdrand";
        version = "0.4.0";
        edition = "2015";
        sha256 = "1cjq0kwx1bk7jx3kzyciiish5gqsj7620dm43dc52sr8fzmm9037";
        authors = [
          "Simonas Kazlauskas <rdrand@kazlauskas.me>"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core 0.3.1";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "redox_syscall 0.1.57" = rec {
        crateName = "redox_syscall";
        version = "0.1.57";
        edition = "2015";
        sha256 = "1kh59fpwy33w9nwd5iyc283yglq8pf2s41hnhvl48iax9mz0zk21";
        libName = "syscall";
        authors = [
          "Jeremy Soller <jackpot51@gmail.com>"
        ];

      };
      "redox_syscall 0.2.10" = rec {
        crateName = "redox_syscall";
        version = "0.2.10";
        edition = "2018";
        sha256 = "1zq36bhw4c6xig340ja1jmr36iy0d3djp8smsabxx71676bg70w3";
        libName = "syscall";
        authors = [
          "Jeremy Soller <jackpot51@gmail.com>"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
        ];

      };
      "regex" = rec {
        crateName = "regex";
        version = "1.5.4";
        edition = "2018";
        sha256 = "0qf479kjbmb582h4d1d6gfl75h0j8aq2nrdi5wg6zdcy6llqcynh";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "aho-corasick";
            packageId = "aho-corasick";
            optional = true;
          }
          {
            name = "memchr";
            packageId = "memchr";
            optional = true;
          }
          {
            name = "regex-syntax";
            packageId = "regex-syntax";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" "perf" "unicode" "regex-syntax/default" ];
          "perf" = [ "perf-cache" "perf-dfa" "perf-inline" "perf-literal" ];
          "perf-literal" = [ "aho-corasick" "memchr" ];
          "unicode" = [ "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" "regex-syntax/unicode" ];
          "unicode-age" = [ "regex-syntax/unicode-age" ];
          "unicode-bool" = [ "regex-syntax/unicode-bool" ];
          "unicode-case" = [ "regex-syntax/unicode-case" ];
          "unicode-gencat" = [ "regex-syntax/unicode-gencat" ];
          "unicode-perl" = [ "regex-syntax/unicode-perl" ];
          "unicode-script" = [ "regex-syntax/unicode-script" ];
          "unicode-segment" = [ "regex-syntax/unicode-segment" ];
          "unstable" = [ "pattern" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "aho-corasick" "default" "memchr" "perf" "perf-cache" "perf-dfa" "perf-inline" "perf-literal" "std" "unicode" "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" ];
      };
      "regex-syntax" = rec {
        crateName = "regex-syntax";
        version = "0.6.25";
        edition = "2018";
        sha256 = "16y87hz1bxmmz6kk360cxwfm3jnbsxb3x4zw9x1gzz7khic2i5zl";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
          "default" = [ "unicode" ];
          "unicode" = [ "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" ];
        };
        resolvedDefaultFeatures = [ "default" "unicode" "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" ];
      };
      "resolv-conf" = rec {
        crateName = "resolv-conf";
        version = "0.6.3";
        edition = "2015";
        sha256 = "0jlzifww1h7j23jnjj49xz8q0fpd9rqpd0ks8c4y651vgw9lx0qi";
        libName = "resolv_conf";
        authors = [
          "paul@colomiets.name"
        ];
        dependencies = [
          {
            name = "hostname";
            packageId = "hostname";
            optional = true;
          }
          {
            name = "quick-error";
            packageId = "quick-error";
          }
        ];
        features = {
          "system" = [ "hostname" ];
        };
        resolvedDefaultFeatures = [ "hostname" "system" ];
      };
      "rustc-demangle" = rec {
        crateName = "rustc-demangle";
        version = "0.1.21";
        edition = "2015";
        sha256 = "0hn3xyd2n3bg3jnc5a5jbzll32n4r5a65bqzs287l30m5c53xw3y";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
        };
      };
      "rustc_version" = rec {
        crateName = "rustc_version";
        version = "0.2.3";
        edition = "2015";
        sha256 = "02h3x57lcr8l2pm0a645s9whdh33pn5cnrwvn5cb57vcrc53x3hk";
        authors = [
          "Marvin Löbel <loebel.marvin@gmail.com>"
        ];
        dependencies = [
          {
            name = "semver";
            packageId = "semver";
          }
        ];

      };
      "ryu" = rec {
        crateName = "ryu";
        version = "1.0.6";
        edition = "2018";
        sha256 = "0s35bwagycbzwmbj0fngm4jljnan272cz12i84kbmfbalssi75iw";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        features = {
        };
      };
      "scopeguard" = rec {
        crateName = "scopeguard";
        version = "1.1.0";
        edition = "2015";
        sha256 = "1kbqm85v43rq92vx7hfiay6pmcga03vrjbbfwqpyj3pwsg3b16nj";
        authors = [
          "bluss"
        ];
        features = {
          "default" = [ "use_std" ];
        };
      };
      "semver" = rec {
        crateName = "semver";
        version = "0.9.0";
        edition = "2015";
        sha256 = "00q4lkcj0rrgbhviv9sd4p6qmdsipkwkbra7rh11jrhq5kpvjzhx";
        authors = [
          "Steve Klabnik <steve@steveklabnik.com>"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "semver-parser";
            packageId = "semver-parser";
          }
        ];
        features = {
          "ci" = [ "serde" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "semver-parser" = rec {
        crateName = "semver-parser";
        version = "0.7.0";
        edition = "2015";
        sha256 = "18vhypw6zgccnrlm5ps1pwa0khz7ry927iznpr88b87cagr1v2iq";
        authors = [
          "Steve Klabnik <steve@steveklabnik.com>"
        ];

      };
      "serde" = rec {
        crateName = "serde";
        version = "1.0.130";
        edition = "2015";
        sha256 = "04y9s1mxcxakg9bhfdiff9w4zzprk6m6dazcpmpi8nfg6zg0cbgi";
        authors = [
          "Erick Tryzelaar <erick.tryzelaar@gmail.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "serde_derive";
            packageId = "serde_derive";
            optional = true;
          }
        ];
        devDependencies = [
          {
            name = "serde_derive";
            packageId = "serde_derive";
          }
        ];
        features = {
          "default" = [ "std" ];
          "derive" = [ "serde_derive" ];
        };
        resolvedDefaultFeatures = [ "default" "derive" "rc" "serde_derive" "std" ];
      };
      "serde_derive" = rec {
        crateName = "serde_derive";
        version = "1.0.130";
        edition = "2015";
        sha256 = "12shxhi47db54i4j44ic2nl299x5p89ngna0w3m6854nn4d1mg6p";
        procMacro = true;
        authors = [
          "Erick Tryzelaar <erick.tryzelaar@gmail.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 1.0.32";
          }
          {
            name = "quote";
            packageId = "quote 1.0.10";
          }
          {
            name = "syn";
            packageId = "syn 1.0.82";
          }
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "serde_json" = rec {
        crateName = "serde_json";
        version = "1.0.72";
        edition = "2018";
        sha256 = "09xmy9iycl8r8bkrgbbxbwbjwj5dii3bbhk812wnzyidgy1s1zyh";
        authors = [
          "Erick Tryzelaar <erick.tryzelaar@gmail.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "itoa";
            packageId = "itoa";
            usesDefaultFeatures = false;
          }
          {
            name = "ryu";
            packageId = "ryu";
          }
          {
            name = "serde";
            packageId = "serde";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "alloc" = [ "serde/alloc" ];
          "default" = [ "std" ];
          "preserve_order" = [ "indexmap" ];
          "std" = [ "serde/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "serde_urlencoded" = rec {
        crateName = "serde_urlencoded";
        version = "0.6.1";
        edition = "2015";
        sha256 = "15rcwfkff0md5i231m2ym5756ksw1mkh5b5g2rw72wsc5mzdgicy";
        authors = [
          "Anthony Ramine <n.oxyde@gmail.com>"
        ];
        dependencies = [
          {
            name = "dtoa";
            packageId = "dtoa";
          }
          {
            name = "itoa";
            packageId = "itoa";
          }
          {
            name = "serde";
            packageId = "serde";
          }
          {
            name = "url";
            packageId = "url 2.2.2";
          }
        ];

      };
      "sha1" = rec {
        crateName = "sha1";
        version = "0.6.0";
        edition = "2015";
        sha256 = "03gs2q4m67rn2p8xcdfxhip6mpgahdwm12bnb3vh90ahv9grhy95";
        authors = [
          "Armin Ronacher <armin.ronacher@active-4.com>"
        ];
        features = {
        };
      };
      "signal-hook-registry" = rec {
        crateName = "signal-hook-registry";
        version = "1.4.0";
        edition = "2015";
        sha256 = "1c2mhijg54y6c1zi4630yki1vpq3z96ljfnsrdy0rb64ilr767p5";
        authors = [
          "Michal 'vorner' Vaner <vorner@vorner.cz>"
          "Masaki Hara <ackie.h.gmai@gmail.com>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
          }
        ];

      };
      "slab" = rec {
        crateName = "slab";
        version = "0.4.5";
        edition = "2018";
        sha256 = "1ddg01hf8h4bpfm027h0snhb7jfcs1jzi497083y13q13vyr3vwx";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "smallvec 0.6.14" = rec {
        crateName = "smallvec";
        version = "0.6.14";
        edition = "2015";
        sha256 = "1q4hz0ssnv24s6fq5kfp2wzrrprrrjiwc42a0h7s7nwym3mwlzxr";
        libPath = "lib.rs";
        authors = [
          "Simon Sapin <simon.sapin@exyr.org>"
        ];
        dependencies = [
          {
            name = "maybe-uninit";
            packageId = "maybe-uninit";
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "smallvec 1.7.0" = rec {
        crateName = "smallvec";
        version = "1.7.0";
        edition = "2018";
        sha256 = "02gka690j8l12gl50ifg7axqnx1m6v6d1byaq0wl3fx66p3vdjhy";
        authors = [
          "The Servo Project Developers"
        ];
        features = {
          "const_new" = [ "const_generics" ];
        };
      };
      "socket2" = rec {
        crateName = "socket2";
        version = "0.3.19";
        edition = "2018";
        sha256 = "0vldz14mxqxnjqb6an2pj7mgclv7nrk45cpscwq7g3fj2c0mfbhj";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 1.0.0";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" or false);
            features = [ "align" ];
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "handleapi" "ws2def" "ws2ipdef" "ws2tcpip" "minwindef" ];
          }
        ];
        features = {
        };
      };
      "stateright" = rec {
        crateName = "stateright";
        version = "0.28.0";
        edition = "2018";
        src = lib.cleanSourceWith { filter = sourceFilter;  src = ./.; };
        authors = [
          "Jonathan Nadal <jon.nadal@gmail.com>"
        ];
        dependencies = [
          {
            name = "actix-web";
            packageId = "actix-web";
          }
          {
            name = "ahash";
            packageId = "ahash 0.3.8";
          }
          {
            name = "choice";
            packageId = "choice";
          }
          {
            name = "crossbeam-utils";
            packageId = "crossbeam-utils";
          }
          {
            name = "dashmap";
            packageId = "dashmap";
          }
          {
            name = "id-set";
            packageId = "id-set";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "nohash-hasher";
            packageId = "nohash-hasher";
          }
          {
            name = "parking_lot";
            packageId = "parking_lot 0.11.2";
          }
          {
            name = "rand";
            packageId = "rand 0.7.3";
          }
          {
            name = "serde";
            packageId = "serde";
            features = [ "rc" ];
          }
        ];
        devDependencies = [
          {
            name = "env_logger";
            packageId = "env_logger";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "num_cpus";
            packageId = "num_cpus";
          }
          {
            name = "pico-args";
            packageId = "pico-args";
          }
          {
            name = "serde_json";
            packageId = "serde_json";
          }
        ];

      };
      "string" = rec {
        crateName = "string";
        version = "0.2.1";
        edition = "2015";
        sha256 = "0vaxz85ja52fn66akgvggb29wqa5bpj3y38syykpr1pbrjzi8hfj";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
            optional = true;
          }
        ];
        features = {
          "default" = [ "bytes" ];
        };
        resolvedDefaultFeatures = [ "bytes" "default" ];
      };
      "syn 0.15.44" = rec {
        crateName = "syn";
        version = "0.15.44";
        edition = "2015";
        sha256 = "1id5g6x6zihv3j7hwrw3m1jp636bg8dpi671r7zy3jvpkavb794w";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 0.4.30";
            usesDefaultFeatures = false;
          }
          {
            name = "quote";
            packageId = "quote 0.6.13";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "unicode-xid";
            packageId = "unicode-xid 0.1.0";
          }
        ];
        features = {
          "default" = [ "derive" "parsing" "printing" "clone-impls" "proc-macro" ];
          "printing" = [ "quote" ];
          "proc-macro" = [ "proc-macro2/proc-macro" "quote/proc-macro" ];
        };
        resolvedDefaultFeatures = [ "clone-impls" "default" "derive" "extra-traits" "parsing" "printing" "proc-macro" "quote" ];
      };
      "syn 1.0.82" = rec {
        crateName = "syn";
        version = "1.0.82";
        edition = "2018";
        sha256 = "0ncx7gg5mvd16q5xf77hgk09nwmfq0ppsn0vgc9x9jv0pg85vbwd";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 1.0.32";
            usesDefaultFeatures = false;
          }
          {
            name = "quote";
            packageId = "quote 1.0.10";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "unicode-xid";
            packageId = "unicode-xid 0.2.2";
          }
        ];
        features = {
          "default" = [ "derive" "parsing" "printing" "clone-impls" "proc-macro" ];
          "printing" = [ "quote" ];
          "proc-macro" = [ "proc-macro2/proc-macro" "quote/proc-macro" ];
          "test" = [ "syn-test-suite/all-features" ];
        };
        resolvedDefaultFeatures = [ "clone-impls" "default" "derive" "extra-traits" "full" "parsing" "printing" "proc-macro" "quote" "visit" ];
      };
      "synstructure" = rec {
        crateName = "synstructure";
        version = "0.12.6";
        edition = "2018";
        sha256 = "03r1lydbf3japnlpc4wka7y90pmz1i0danaj3f9a7b431akdlszk";
        authors = [
          "Nika Layzell <nika@thelayzells.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2 1.0.32";
            usesDefaultFeatures = false;
          }
          {
            name = "quote";
            packageId = "quote 1.0.10";
            usesDefaultFeatures = false;
          }
          {
            name = "syn";
            packageId = "syn 1.0.82";
            usesDefaultFeatures = false;
            features = [ "derive" "parsing" "printing" "clone-impls" "visit" "extra-traits" ];
          }
          {
            name = "unicode-xid";
            packageId = "unicode-xid 0.2.2";
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
          "proc-macro" = [ "proc-macro2/proc-macro" "syn/proc-macro" "quote/proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "termcolor" = rec {
        crateName = "termcolor";
        version = "1.1.2";
        edition = "2018";
        sha256 = "1x65i1ny4m6z1by62ra6wdcrd557p2ysm866x0pg60zby2cxizid";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi-util";
            packageId = "winapi-util";
            target = { target, features }: (target."windows" or false);
          }
        ];

      };
      "threadpool" = rec {
        crateName = "threadpool";
        version = "1.8.1";
        edition = "2015";
        sha256 = "1amgfyzvynbm8pacniivzq9r0fh3chhs7kijic81j76l6c5ycl6h";
        authors = [
          "The Rust Project Developers"
          "Corey Farwell <coreyf@rwell.org>"
          "Stefan Schindler <dns2utf8@estada.ch>"
        ];
        dependencies = [
          {
            name = "num_cpus";
            packageId = "num_cpus";
          }
        ];

      };
      "time" = rec {
        crateName = "time";
        version = "0.1.43";
        edition = "2015";
        sha256 = "0f14wrgxj7ya2v4msg5mni7046bsm2angm7cn3pd3yv04gpm12na";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "std" "minwinbase" "minwindef" "ntdef" "profileapi" "sysinfoapi" "timezoneapi" ];
          }
        ];
        devDependencies = [
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            features = [ "std" "processthreadsapi" "winbase" ];
          }
        ];

      };
      "tiny-keccak" = rec {
        crateName = "tiny-keccak";
        version = "2.0.2";
        edition = "2018";
        sha256 = "0dq2x0hjffmixgyf6xv9wgsbcxkd65ld0wrfqmagji8a829kg79c";
        authors = [
          "debris <marek.kotewicz@gmail.com>"
        ];
        dependencies = [
          {
            name = "crunchy";
            packageId = "crunchy";
          }
        ];
        features = {
          "fips202" = [ "keccak" "shake" "sha3" ];
          "kmac" = [ "cshake" ];
          "parallel_hash" = [ "cshake" ];
          "sp800" = [ "cshake" "kmac" "tuple_hash" ];
          "tuple_hash" = [ "cshake" ];
        };
        resolvedDefaultFeatures = [ "default" "sha3" ];
      };
      "tinyvec" = rec {
        crateName = "tinyvec";
        version = "1.5.1";
        edition = "2018";
        sha256 = "1lnqnva56673r0d40586rkzyl2qqcz19wm29q8h5a95n89d1s71c";
        authors = [
          "Lokathor <zefria@gmail.com>"
        ];
        dependencies = [
          {
            name = "tinyvec_macros";
            packageId = "tinyvec_macros";
            optional = true;
          }
        ];
        features = {
          "alloc" = [ "tinyvec_macros" ];
          "real_blackbox" = [ "criterion/real_blackbox" ];
          "rustc_1_55" = [ "rustc_1_40" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "tinyvec_macros" ];
      };
      "tinyvec_macros" = rec {
        crateName = "tinyvec_macros";
        version = "0.1.0";
        edition = "2018";
        sha256 = "0p5zvgbas5nh403fbxica819mf3g83n8g2hzpfazfr56w6klv9yd";
        authors = [
          "Soveu <marx.tomasz@gmail.com>"
        ];

      };
      "tokio-codec" = rec {
        crateName = "tokio-codec";
        version = "0.1.2";
        edition = "2015";
        sha256 = "0swpfngcb331lzggk6j68yks6w0bnw35vpl4hv8p03msc239kci5";
        authors = [
          "Carl Lerche <me@carllerche.com>"
          "Bryan Burgers <bryan@burgers.io>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "tokio-io";
            packageId = "tokio-io";
          }
        ];

      };
      "tokio-current-thread" = rec {
        crateName = "tokio-current-thread";
        version = "0.1.7";
        edition = "2015";
        sha256 = "03p2w316ha0irgzvy37njx9hl71133gcrmrq4801w4rzm0r0xpmi";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "tokio-executor";
            packageId = "tokio-executor";
          }
        ];

      };
      "tokio-executor" = rec {
        crateName = "tokio-executor";
        version = "0.1.10";
        edition = "2015";
        sha256 = "0w8n78d2vixs1vghqc4wy9w0d1h6qkli51c1yzhzbns88n7inbgv";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "crossbeam-utils";
            packageId = "crossbeam-utils";
          }
          {
            name = "futures";
            packageId = "futures";
          }
        ];

      };
      "tokio-io" = rec {
        crateName = "tokio-io";
        version = "0.1.13";
        edition = "2015";
        sha256 = "0x06zyzinans1pn90g6i150lgixijdf1cg8y2gipjd09ms58dz2p";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "log";
            packageId = "log";
          }
        ];

      };
      "tokio-reactor" = rec {
        crateName = "tokio-reactor";
        version = "0.1.12";
        edition = "2015";
        sha256 = "0l8klnd41q55f3ialzz0lb7s5bfwa38nh86sa9vai2xsqh75kg09";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "crossbeam-utils";
            packageId = "crossbeam-utils";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "mio";
            packageId = "mio";
          }
          {
            name = "num_cpus";
            packageId = "num_cpus";
          }
          {
            name = "parking_lot";
            packageId = "parking_lot 0.9.0";
          }
          {
            name = "slab";
            packageId = "slab";
          }
          {
            name = "tokio-executor";
            packageId = "tokio-executor";
          }
          {
            name = "tokio-io";
            packageId = "tokio-io";
          }
          {
            name = "tokio-sync";
            packageId = "tokio-sync";
          }
        ];
        devDependencies = [
          {
            name = "num_cpus";
            packageId = "num_cpus";
          }
        ];

      };
      "tokio-signal" = rec {
        crateName = "tokio-signal";
        version = "0.2.9";
        edition = "2015";
        sha256 = "04pz3awjxnh73g288n2mhl5n2ymqrfkkvfhw699i044gaip4rhyh";
        authors = [
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "mio";
            packageId = "mio";
          }
          {
            name = "mio-uds";
            packageId = "mio-uds";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "signal-hook-registry";
            packageId = "signal-hook-registry";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "tokio-executor";
            packageId = "tokio-executor";
          }
          {
            name = "tokio-io";
            packageId = "tokio-io";
          }
          {
            name = "tokio-reactor";
            packageId = "tokio-reactor";
          }
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "consoleapi" "minwindef" "wincon" ];
          }
        ];

      };
      "tokio-sync" = rec {
        crateName = "tokio-sync";
        version = "0.1.8";
        edition = "2015";
        sha256 = "1vkxz0y7qf9sshfpxvn506pvxy4vza8piavd8p64y5n85cam1zpd";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "fnv";
            packageId = "fnv";
          }
          {
            name = "futures";
            packageId = "futures";
          }
        ];

      };
      "tokio-tcp" = rec {
        crateName = "tokio-tcp";
        version = "0.1.4";
        edition = "2015";
        sha256 = "0whzqnkyfym1ipzznibyjl3j9281walq4n0q5xs2xdz3cvniipwq";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "iovec";
            packageId = "iovec";
          }
          {
            name = "mio";
            packageId = "mio";
          }
          {
            name = "tokio-io";
            packageId = "tokio-io";
          }
          {
            name = "tokio-reactor";
            packageId = "tokio-reactor";
          }
        ];

      };
      "tokio-timer" = rec {
        crateName = "tokio-timer";
        version = "0.2.13";
        edition = "2015";
        sha256 = "15pjjj6daks3sii8p24a509b0dapl2kyk740nwfgz59w64nly14k";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "crossbeam-utils";
            packageId = "crossbeam-utils";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "slab";
            packageId = "slab";
          }
          {
            name = "tokio-executor";
            packageId = "tokio-executor";
          }
        ];

      };
      "tokio-udp" = rec {
        crateName = "tokio-udp";
        version = "0.1.6";
        edition = "2015";
        sha256 = "10hdcnxdp0dxvj44jl1nrrpg30jbisqclbqs0f5w6f8bc47b3872";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "mio";
            packageId = "mio";
          }
          {
            name = "tokio-codec";
            packageId = "tokio-codec";
          }
          {
            name = "tokio-io";
            packageId = "tokio-io";
          }
          {
            name = "tokio-reactor";
            packageId = "tokio-reactor";
          }
        ];

      };
      "trust-dns-proto" = rec {
        crateName = "trust-dns-proto";
        version = "0.7.4";
        edition = "2018";
        sha256 = "0099dm57nnizx4apik9sh3mnvr7rp9mivc903v8xss13dkgynnam";
        libName = "trust_dns_proto";
        authors = [
          "Benjamin Fry <benjaminfry@me.com>"
        ];
        dependencies = [
          {
            name = "byteorder";
            packageId = "byteorder";
          }
          {
            name = "enum-as-inner";
            packageId = "enum-as-inner";
          }
          {
            name = "failure";
            packageId = "failure";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "idna";
            packageId = "idna 0.1.5";
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "rand";
            packageId = "rand 0.6.5";
          }
          {
            name = "smallvec";
            packageId = "smallvec 0.6.14";
          }
          {
            name = "socket2";
            packageId = "socket2";
          }
          {
            name = "tokio-executor";
            packageId = "tokio-executor";
          }
          {
            name = "tokio-io";
            packageId = "tokio-io";
          }
          {
            name = "tokio-reactor";
            packageId = "tokio-reactor";
          }
          {
            name = "tokio-tcp";
            packageId = "tokio-tcp";
          }
          {
            name = "tokio-timer";
            packageId = "tokio-timer";
          }
          {
            name = "tokio-udp";
            packageId = "tokio-udp";
          }
          {
            name = "url";
            packageId = "url 1.7.2";
          }
        ];
        features = {
          "dnssec" = [ "data-encoding" ];
          "dnssec-openssl" = [ "dnssec" "openssl" ];
          "dnssec-ring" = [ "dnssec" "ring" "untrusted" ];
          "mdns" = [ "socket2/reuseport" ];
          "serde-config" = [ "serde" ];
        };
      };
      "trust-dns-resolver" = rec {
        crateName = "trust-dns-resolver";
        version = "0.11.1";
        edition = "2015";
        sha256 = "0fd0w2zsdwlsag27fsg0fzyd7j7niw0r22rwh2c5fdmsipjr56bc";
        libName = "trust_dns_resolver";
        authors = [
          "Benjamin Fry <benjaminfry@me.com>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if 0.1.10";
          }
          {
            name = "failure";
            packageId = "failure";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "ipconfig";
            packageId = "ipconfig";
            target = { target, features }: (target."windows" or false);
          }
          {
            name = "lazy_static";
            packageId = "lazy_static";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "lru-cache";
            packageId = "lru-cache";
          }
          {
            name = "resolv-conf";
            packageId = "resolv-conf";
            features = [ "system" ];
          }
          {
            name = "smallvec";
            packageId = "smallvec 0.6.14";
          }
          {
            name = "tokio-executor";
            packageId = "tokio-executor";
          }
          {
            name = "trust-dns-proto";
            packageId = "trust-dns-proto";
          }
        ];
        features = {
          "default" = [ "tokio" ];
          "dns-over-https-rustls" = [ "trust-dns-https" "dns-over-rustls" "dns-over-https" ];
          "dns-over-native-tls" = [ "dns-over-tls" "trust-dns-native-tls" ];
          "dns-over-openssl" = [ "dns-over-tls" "trust-dns-openssl" ];
          "dns-over-rustls" = [ "dns-over-tls" "rustls" "trust-dns-rustls" "webpki-roots" ];
          "dnssec-openssl" = [ "dnssec" "trust-dns-proto/dnssec-openssl" ];
          "dnssec-ring" = [ "dnssec" "trust-dns-proto/dnssec-ring" ];
          "mdns" = [ "trust-dns-proto/mdns" ];
          "serde-config" = [ "serde" "trust-dns-proto/serde-config" ];
        };
      };
      "unicode-bidi" = rec {
        crateName = "unicode-bidi";
        version = "0.3.7";
        edition = "2018";
        sha256 = "13v7v8pp7mdqqf0ypk73va78c3b4xzpryvbls9p47nz3cd34008s";
        libName = "unicode_bidi";
        authors = [
          "The Servo Project Developers"
        ];
        features = {
          "default" = [ "std" ];
          "flame_it" = [ "flame" "flamer" ];
          "with_serde" = [ "serde" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "unicode-normalization" = rec {
        crateName = "unicode-normalization";
        version = "0.1.19";
        edition = "2018";
        sha256 = "1yabhmg8zlcksda3ajly9hpbzqgbhknxwch8dwkfkaa1569r0ifm";
        authors = [
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        dependencies = [
          {
            name = "tinyvec";
            packageId = "tinyvec";
            features = [ "alloc" ];
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "unicode-xid 0.1.0" = rec {
        crateName = "unicode-xid";
        version = "0.1.0";
        edition = "2015";
        sha256 = "1z57lqh4s18rr4x0j4fw4fmp9hf9346h0kmdgqsqx0fhjr3k0wpw";
        authors = [
          "erick.tryzelaar <erick.tryzelaar@gmail.com>"
          "kwantam <kwantam@gmail.com>"
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "unicode-xid 0.2.2" = rec {
        crateName = "unicode-xid";
        version = "0.2.2";
        edition = "2015";
        sha256 = "1wrkgcw557v311dkdb6n2hrix9dm2qdsb1zpw7pn79l03zb85jwc";
        authors = [
          "erick.tryzelaar <erick.tryzelaar@gmail.com>"
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "url 1.7.2" = rec {
        crateName = "url";
        version = "1.7.2";
        edition = "2015";
        sha256 = "0nim1c90mxpi9wgdw2xh8dqd72vlklwlzam436akcrhjac6pqknx";
        authors = [
          "The rust-url developers"
        ];
        dependencies = [
          {
            name = "idna";
            packageId = "idna 0.1.5";
          }
          {
            name = "matches";
            packageId = "matches";
          }
          {
            name = "percent-encoding";
            packageId = "percent-encoding 1.0.1";
          }
        ];
        features = {
          "heap_size" = [ "heapsize" ];
          "query_encoding" = [ "encoding" ];
        };
      };
      "url 2.2.2" = rec {
        crateName = "url";
        version = "2.2.2";
        edition = "2018";
        sha256 = "132pzpvfvpw33gjlzqd55n5iag9qddzffq8qbp1myfykna1w61x5";
        authors = [
          "The rust-url developers"
        ];
        dependencies = [
          {
            name = "form_urlencoded";
            packageId = "form_urlencoded";
          }
          {
            name = "idna";
            packageId = "idna 0.2.3";
          }
          {
            name = "matches";
            packageId = "matches";
          }
          {
            name = "percent-encoding";
            packageId = "percent-encoding 2.1.0";
          }
        ];

      };
      "wasi 0.10.2+wasi-snapshot-preview1" = rec {
        crateName = "wasi";
        version = "0.10.2+wasi-snapshot-preview1";
        edition = "2018";
        sha256 = "1ii7nff4y1mpcrxzzvbpgxm7a1nn3szjf1n21jnx37c2g6dbsvzx";
        authors = [
          "The Cranelift Project Developers"
        ];
        features = {
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "compiler_builtins" "core" "rustc-std-workspace-alloc" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "wasi 0.9.0+wasi-snapshot-preview1" = rec {
        crateName = "wasi";
        version = "0.9.0+wasi-snapshot-preview1";
        edition = "2018";
        sha256 = "06g5v3vrdapfzvfq662cij7v8a1flwr2my45nnncdv2galrdzkfc";
        authors = [
          "The Cranelift Project Developers"
        ];
        features = {
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "compiler_builtins" "core" "rustc-std-workspace-alloc" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "widestring" = rec {
        crateName = "widestring";
        version = "0.4.3";
        edition = "2015";
        sha256 = "0z3ba8qrxb62vpfgk7n2xs2grm9kdaj1cz4q8s0gs8fx8h0r8s61";
        authors = [
          "Kathryn Long <squeeself@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "std" ];
      };
      "winapi 0.2.8" = rec {
        crateName = "winapi";
        version = "0.2.8";
        edition = "2015";
        sha256 = "0yh816lh6lf56dpsgxy189c2ai1z3j8mw9si6izqb6wsjkbcjz8n";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];

      };
      "winapi 0.3.9" = rec {
        crateName = "winapi";
        version = "0.3.9";
        edition = "2015";
        sha256 = "06gl025x418lchw1wxj64ycr7gha83m44cjr5sarhynd9xkrm0sw";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi-i686-pc-windows-gnu";
            packageId = "winapi-i686-pc-windows-gnu";
            target = { target, features }: (stdenv.hostPlatform.config == "i686-pc-windows-gnu");
          }
          {
            name = "winapi-x86_64-pc-windows-gnu";
            packageId = "winapi-x86_64-pc-windows-gnu";
            target = { target, features }: (stdenv.hostPlatform.config == "x86_64-pc-windows-gnu");
          }
        ];
        features = {
          "debug" = [ "impl-debug" ];
        };
        resolvedDefaultFeatures = [ "consoleapi" "errhandlingapi" "fileapi" "handleapi" "impl-debug" "impl-default" "minwinbase" "minwindef" "ntdef" "ntsecapi" "ntstatus" "processenv" "profileapi" "std" "sysinfoapi" "timezoneapi" "winbase" "wincon" "winerror" "winnt" "winreg" "winsock2" "ws2def" "ws2ipdef" "ws2tcpip" ];
      };
      "winapi-build" = rec {
        crateName = "winapi-build";
        version = "0.1.1";
        edition = "2015";
        sha256 = "1g4rqsgjky0a7530qajn2bbfcrl2v0zb39idgdws9b1l7gp5wc9d";
        libName = "build";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];

      };
      "winapi-i686-pc-windows-gnu" = rec {
        crateName = "winapi-i686-pc-windows-gnu";
        version = "0.4.0";
        edition = "2015";
        sha256 = "1dmpa6mvcvzz16zg6d5vrfy4bxgg541wxrcip7cnshi06v38ffxc";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];

      };
      "winapi-util" = rec {
        crateName = "winapi-util";
        version = "0.1.5";
        edition = "2018";
        sha256 = "0y71bp7f6d536czj40dhqk0d55wfbbwqfp2ymqf1an5ibgl6rv3h";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            target = { target, features }: (target."windows" or false);
            features = [ "std" "consoleapi" "errhandlingapi" "fileapi" "minwindef" "processenv" "winbase" "wincon" "winerror" "winnt" ];
          }
        ];

      };
      "winapi-x86_64-pc-windows-gnu" = rec {
        crateName = "winapi-x86_64-pc-windows-gnu";
        version = "0.4.0";
        edition = "2015";
        sha256 = "0gqq64czqb64kskjryj8isp62m2sgvx25yyj3kpc2myh85w24bki";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];

      };
      "winreg" = rec {
        crateName = "winreg";
        version = "0.6.2";
        edition = "2015";
        sha256 = "1jdcqr6zmvwyrp87h48miasfdvv16gjsb60rc8dy2kqwb3mnv65j";
        authors = [
          "Igor Shaula <gentoo90@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi 0.3.9";
            features = [ "impl-default" "impl-debug" "minwindef" "minwinbase" "timezoneapi" "winerror" "winnt" "winreg" "handleapi" ];
          }
        ];
        features = {
          "serialization-serde" = [ "transactions" "serde" ];
          "transactions" = [ "winapi/ktmw32" ];
        };
      };
      "ws2_32-sys" = rec {
        crateName = "ws2_32-sys";
        version = "0.2.1";
        edition = "2015";
        sha256 = "0ppscg5qfqaw0gzwv2a4nhn5bn01ff9iwn6ysqnzm4n8s3myz76m";
        libName = "ws2_32";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi 0.2.8";
          }
        ];
        buildDependencies = [
          {
            name = "winapi-build";
            packageId = "winapi-build";
          }
        ];

      };
    };

    #
# crate2nix/default.nix (excerpt start)
#

  /* Target (platform) data for conditional dependencies.
    This corresponds roughly to what buildRustCrate is setting.
  */
  defaultTarget = {
    unix = true;
    windows = false;
    fuchsia = true;
    test = false;

    # This doesn't appear to be officially documented anywhere yet.
    # See https://github.com/rust-lang-nursery/rust-forge/issues/101.
    os =
      if stdenv.hostPlatform.isDarwin
      then "macos"
      else stdenv.hostPlatform.parsed.kernel.name;
    arch = stdenv.hostPlatform.parsed.cpu.name;
    family = "unix";
    env = "gnu";
    endian =
      if stdenv.hostPlatform.parsed.cpu.significantByte.name == "littleEndian"
      then "little" else "big";
    pointer_width = toString stdenv.hostPlatform.parsed.cpu.bits;
    vendor = stdenv.hostPlatform.parsed.vendor.name;
    debug_assertions = false;
  };

  /* Filters common temp files and build files. */
  # TODO(pkolloch): Substitute with gitignore filter
  sourceFilter = name: type:
    let
      baseName = builtins.baseNameOf (builtins.toString name);
    in
      ! (
        # Filter out git
        baseName == ".gitignore"
        || (type == "directory" && baseName == ".git")

        # Filter out build results
        || (
          type == "directory" && (
            baseName == "target"
            || baseName == "_site"
            || baseName == ".sass-cache"
            || baseName == ".jekyll-metadata"
            || baseName == "build-artifacts"
          )
        )

        # Filter out nix-build result symlinks
        || (
          type == "symlink" && lib.hasPrefix "result" baseName
        )

        # Filter out IDE config
        || (
          type == "directory" && (
            baseName == ".idea" || baseName == ".vscode"
          )
        ) || lib.hasSuffix ".iml" baseName

        # Filter out nix build files
        || baseName == "Cargo.nix"

        # Filter out editor backup / swap files.
        || lib.hasSuffix "~" baseName
        || builtins.match "^\\.sw[a-z]$$" baseName != null
        || builtins.match "^\\..*\\.sw[a-z]$$" baseName != null
        || lib.hasSuffix ".tmp" baseName
        || lib.hasSuffix ".bak" baseName
        || baseName == "tests.nix"
      );

  /* Returns a crate which depends on successful test execution
    of crate given as the second argument.

    testCrateFlags: list of flags to pass to the test exectuable
    testInputs: list of packages that should be available during test execution
  */
  crateWithTest = { crate, testCrate, testCrateFlags, testInputs, testPreRun, testPostRun }:
    assert builtins.typeOf testCrateFlags == "list";
    assert builtins.typeOf testInputs == "list";
    assert builtins.typeOf testPreRun == "string";
    assert builtins.typeOf testPostRun == "string";
    let
      # override the `crate` so that it will build and execute tests instead of
      # building the actual lib and bin targets We just have to pass `--test`
      # to rustc and it will do the right thing.  We execute the tests and copy
      # their log and the test executables to $out for later inspection.
      test =
        let
          drv = testCrate.override
            (
              _: {
                buildTests = true;
              }
            );
          # If the user hasn't set any pre/post commands, we don't want to
          # insert empty lines. This means that any existing users of crate2nix
          # don't get a spurious rebuild unless they set these explicitly.
          testCommand = pkgs.lib.concatStringsSep "\n"
            (pkgs.lib.filter (s: s != "") [
              testPreRun
              "$f $testCrateFlags 2>&1 | tee -a $out"
              testPostRun
            ]);
        in
        pkgs.runCommand "run-tests-${testCrate.name}"
          {
            inherit testCrateFlags;
            buildInputs = testInputs;
          } ''
          set -ex

          export RUST_BACKTRACE=1

          # recreate a file hierarchy as when running tests with cargo

          # the source for test data
          ${pkgs.xorg.lndir}/bin/lndir ${crate.src}

          # build outputs
          testRoot=target/debug
          mkdir -p $testRoot

          # executables of the crate
          # we copy to prevent std::env::current_exe() to resolve to a store location
          for i in ${crate}/bin/*; do
            cp "$i" "$testRoot"
          done
          chmod +w -R .

          # test harness executables are suffixed with a hash, like cargo does
          # this allows to prevent name collision with the main
          # executables of the crate
          hash=$(basename $out)
          for file in ${drv}/tests/*; do
            f=$testRoot/$(basename $file)-$hash
            cp $file $f
            ${testCommand}
          done
        '';
    in
    pkgs.runCommand "${crate.name}-linked"
      {
        inherit (crate) outputs crateName;
        passthru = (crate.passthru or { }) // {
          inherit test;
        };
      } ''
      echo tested by ${test}
      ${lib.concatMapStringsSep "\n" (output: "ln -s ${crate.${output}} ${"$"}${output}") crate.outputs}
    '';

  /* A restricted overridable version of builtRustCratesWithFeatures. */
  buildRustCrateWithFeatures =
    { packageId
    , features ? rootFeatures
    , crateOverrides ? defaultCrateOverrides
    , buildRustCrateForPkgsFunc ? null
    , runTests ? false
    , testCrateFlags ? [ ]
    , testInputs ? [ ]
      # Any command to run immediatelly before a test is executed.
    , testPreRun ? ""
      # Any command run immediatelly after a test is executed.
    , testPostRun ? ""
    }:
    lib.makeOverridable
      (
        { features
        , crateOverrides
        , runTests
        , testCrateFlags
        , testInputs
        , testPreRun
        , testPostRun
        }:
        let
          buildRustCrateForPkgsFuncOverriden =
            if buildRustCrateForPkgsFunc != null
            then buildRustCrateForPkgsFunc
            else
              (
                if crateOverrides == pkgs.defaultCrateOverrides
                then buildRustCrateForPkgs
                else
                  pkgs: (buildRustCrateForPkgs pkgs).override {
                    defaultCrateOverrides = crateOverrides;
                  }
              );
          builtRustCrates = builtRustCratesWithFeatures {
            inherit packageId features;
            buildRustCrateForPkgsFunc = buildRustCrateForPkgsFuncOverriden;
            runTests = false;
          };
          builtTestRustCrates = builtRustCratesWithFeatures {
            inherit packageId features;
            buildRustCrateForPkgsFunc = buildRustCrateForPkgsFuncOverriden;
            runTests = true;
          };
          drv = builtRustCrates.crates.${packageId};
          testDrv = builtTestRustCrates.crates.${packageId};
          derivation =
            if runTests then
              crateWithTest
                {
                  crate = drv;
                  testCrate = testDrv;
                  inherit testCrateFlags testInputs testPreRun testPostRun;
                }
            else drv;
        in
        derivation
      )
      { inherit features crateOverrides runTests testCrateFlags testInputs testPreRun testPostRun; };

  /* Returns an attr set with packageId mapped to the result of buildRustCrateForPkgsFunc
    for the corresponding crate.
  */
  builtRustCratesWithFeatures =
    { packageId
    , features
    , crateConfigs ? crates
    , buildRustCrateForPkgsFunc
    , runTests
    , target ? defaultTarget
    } @ args:
      assert (builtins.isAttrs crateConfigs);
      assert (builtins.isString packageId);
      assert (builtins.isList features);
      assert (builtins.isAttrs target);
      assert (builtins.isBool runTests);
      let
        rootPackageId = packageId;
        mergedFeatures = mergePackageFeatures
          (
            args // {
              inherit rootPackageId;
              target = target // { test = runTests; };
            }
          );
        # Memoize built packages so that reappearing packages are only built once.
        builtByPackageIdByPkgs = mkBuiltByPackageIdByPkgs pkgs;
        mkBuiltByPackageIdByPkgs = pkgs:
          let
            self = {
              crates = lib.mapAttrs (packageId: value: buildByPackageIdForPkgsImpl self pkgs packageId) crateConfigs;
              build = mkBuiltByPackageIdByPkgs pkgs.buildPackages;
            };
          in
          self;
        buildByPackageIdForPkgsImpl = self: pkgs: packageId:
          let
            features = mergedFeatures."${packageId}" or [ ];
            crateConfig' = crateConfigs."${packageId}";
            crateConfig =
              builtins.removeAttrs crateConfig' [ "resolvedDefaultFeatures" "devDependencies" ];
            devDependencies =
              lib.optionals
                (runTests && packageId == rootPackageId)
                (crateConfig'.devDependencies or [ ]);
            dependencies =
              dependencyDerivations {
                inherit features target;
                buildByPackageId = depPackageId:
                  # proc_macro crates must be compiled for the build architecture
                  if crateConfigs.${depPackageId}.procMacro or false
                  then self.build.crates.${depPackageId}
                  else self.crates.${depPackageId};
                dependencies =
                  (crateConfig.dependencies or [ ])
                  ++ devDependencies;
              };
            buildDependencies =
              dependencyDerivations {
                inherit features target;
                buildByPackageId = depPackageId:
                  self.build.crates.${depPackageId};
                dependencies = crateConfig.buildDependencies or [ ];
              };
            filterEnabledDependenciesForThis = dependencies: filterEnabledDependencies {
              inherit dependencies features target;
            };
            dependenciesWithRenames =
              lib.filter (d: d ? "rename")
                (
                  filterEnabledDependenciesForThis
                    (
                      (crateConfig.buildDependencies or [ ])
                      ++ (crateConfig.dependencies or [ ])
                      ++ devDependencies
                    )
                );
            # Crate renames have the form:
            #
            # {
            #    crate_name = [
            #       { version = "1.2.3"; rename = "crate_name01"; }
            #    ];
            #    # ...
            # }
            crateRenames =
              let
                grouped =
                  lib.groupBy
                    (dependency: dependency.name)
                    dependenciesWithRenames;
                versionAndRename = dep:
                  let
                    package = crateConfigs."${dep.packageId}";
                  in
                  { inherit (dep) rename; version = package.version; };
              in
              lib.mapAttrs (name: choices: builtins.map versionAndRename choices) grouped;
          in
          buildRustCrateForPkgsFunc pkgs
            (
              crateConfig // {
                src = crateConfig.src or (
                  pkgs.fetchurl rec {
                    name = "${crateConfig.crateName}-${crateConfig.version}.tar.gz";
                    # https://www.pietroalbini.org/blog/downloading-crates-io/
                    # Not rate-limited, CDN URL.
                    url = "https://static.crates.io/crates/${crateConfig.crateName}/${crateConfig.crateName}-${crateConfig.version}.crate";
                    sha256 =
                      assert (lib.assertMsg (crateConfig ? sha256) "Missing sha256 for ${name}");
                      crateConfig.sha256;
                  }
                );
                extraRustcOpts = lib.lists.optional (targetFeatures != [ ]) "-C target-feature=${lib.concatMapStringsSep "," (x: "+${x}") targetFeatures}";
                inherit features dependencies buildDependencies crateRenames release;
              }
            );
      in
      builtByPackageIdByPkgs;

  /* Returns the actual derivations for the given dependencies. */
  dependencyDerivations =
    { buildByPackageId
    , features
    , dependencies
    , target
    }:
      assert (builtins.isList features);
      assert (builtins.isList dependencies);
      assert (builtins.isAttrs target);
      let
        enabledDependencies = filterEnabledDependencies {
          inherit dependencies features target;
        };
        depDerivation = dependency: buildByPackageId dependency.packageId;
      in
      map depDerivation enabledDependencies;

  /* Returns a sanitized version of val with all values substituted that cannot
    be serialized as JSON.
  */
  sanitizeForJson = val:
    if builtins.isAttrs val
    then lib.mapAttrs (n: v: sanitizeForJson v) val
    else if builtins.isList val
    then builtins.map sanitizeForJson val
    else if builtins.isFunction val
    then "function"
    else val;

  /* Returns various tools to debug a crate. */
  debugCrate = { packageId, target ? defaultTarget }:
    assert (builtins.isString packageId);
    let
      debug = rec {
        # The built tree as passed to buildRustCrate.
        buildTree = buildRustCrateWithFeatures {
          buildRustCrateForPkgsFunc = _: lib.id;
          inherit packageId;
        };
        sanitizedBuildTree = sanitizeForJson buildTree;
        dependencyTree = sanitizeForJson
          (
            buildRustCrateWithFeatures {
              buildRustCrateForPkgsFunc = _: crate: {
                "01_crateName" = crate.crateName or false;
                "02_features" = crate.features or [ ];
                "03_dependencies" = crate.dependencies or [ ];
              };
              inherit packageId;
            }
          );
        mergedPackageFeatures = mergePackageFeatures {
          features = rootFeatures;
          inherit packageId target;
        };
        diffedDefaultPackageFeatures = diffDefaultPackageFeatures {
          inherit packageId target;
        };
      };
    in
    { internal = debug; };

  /* Returns differences between cargo default features and crate2nix default
    features.

    This is useful for verifying the feature resolution in crate2nix.
  */
  diffDefaultPackageFeatures =
    { crateConfigs ? crates
    , packageId
    , target
    }:
      assert (builtins.isAttrs crateConfigs);
      let
        prefixValues = prefix: lib.mapAttrs (n: v: { "${prefix}" = v; });
        mergedFeatures =
          prefixValues
            "crate2nix"
            (mergePackageFeatures { inherit crateConfigs packageId target; features = [ "default" ]; });
        configs = prefixValues "cargo" crateConfigs;
        combined = lib.foldAttrs (a: b: a // b) { } [ mergedFeatures configs ];
        onlyInCargo =
          builtins.attrNames
            (lib.filterAttrs (n: v: !(v ? "crate2nix") && (v ? "cargo")) combined);
        onlyInCrate2Nix =
          builtins.attrNames
            (lib.filterAttrs (n: v: (v ? "crate2nix") && !(v ? "cargo")) combined);
        differentFeatures = lib.filterAttrs
          (
            n: v:
              (v ? "crate2nix")
              && (v ? "cargo")
              && (v.crate2nix.features or [ ]) != (v."cargo".resolved_default_features or [ ])
          )
          combined;
      in
      builtins.toJSON {
        inherit onlyInCargo onlyInCrate2Nix differentFeatures;
      };

  /* Returns an attrset mapping packageId to the list of enabled features.

    If multiple paths to a dependency enable different features, the
    corresponding feature sets are merged. Features in rust are additive.
  */
  mergePackageFeatures =
    { crateConfigs ? crates
    , packageId
    , rootPackageId ? packageId
    , features ? rootFeatures
    , dependencyPath ? [ crates.${packageId}.crateName ]
    , featuresByPackageId ? { }
    , target
      # Adds devDependencies to the crate with rootPackageId.
    , runTests ? false
    , ...
    } @ args:
      assert (builtins.isAttrs crateConfigs);
      assert (builtins.isString packageId);
      assert (builtins.isString rootPackageId);
      assert (builtins.isList features);
      assert (builtins.isList dependencyPath);
      assert (builtins.isAttrs featuresByPackageId);
      assert (builtins.isAttrs target);
      assert (builtins.isBool runTests);
      let
        crateConfig = crateConfigs."${packageId}" or (builtins.throw "Package not found: ${packageId}");
        expandedFeatures = expandFeatures (crateConfig.features or { }) features;
        enabledFeatures = enableFeatures (crateConfig.dependencies or [ ]) expandedFeatures;
        depWithResolvedFeatures = dependency:
          let
            packageId = dependency.packageId;
            features = dependencyFeatures enabledFeatures dependency;
          in
          { inherit packageId features; };
        resolveDependencies = cache: path: dependencies:
          assert (builtins.isAttrs cache);
          assert (builtins.isList dependencies);
          let
            enabledDependencies = filterEnabledDependencies {
              inherit dependencies target;
              features = enabledFeatures;
            };
            directDependencies = map depWithResolvedFeatures enabledDependencies;
            foldOverCache = op: lib.foldl op cache directDependencies;
          in
          foldOverCache
            (
              cache: { packageId, features }:
                let
                  cacheFeatures = cache.${packageId} or [ ];
                  combinedFeatures = sortedUnique (cacheFeatures ++ features);
                in
                if cache ? ${packageId} && cache.${packageId} == combinedFeatures
                then cache
                else
                  mergePackageFeatures {
                    features = combinedFeatures;
                    featuresByPackageId = cache;
                    inherit crateConfigs packageId target runTests rootPackageId;
                  }
            );
        cacheWithSelf =
          let
            cacheFeatures = featuresByPackageId.${packageId} or [ ];
            combinedFeatures = sortedUnique (cacheFeatures ++ enabledFeatures);
          in
          featuresByPackageId // {
            "${packageId}" = combinedFeatures;
          };
        cacheWithDependencies =
          resolveDependencies cacheWithSelf "dep"
            (
              crateConfig.dependencies or [ ]
              ++ lib.optionals
                (runTests && packageId == rootPackageId)
                (crateConfig.devDependencies or [ ])
            );
        cacheWithAll =
          resolveDependencies
            cacheWithDependencies "build"
            (crateConfig.buildDependencies or [ ]);
      in
      cacheWithAll;

  /* Returns the enabled dependencies given the enabled features. */
  filterEnabledDependencies = { dependencies, features, target }:
    assert (builtins.isList dependencies);
    assert (builtins.isList features);
    assert (builtins.isAttrs target);

    lib.filter
      (
        dep:
        let
          targetFunc = dep.target or (features: true);
        in
        targetFunc { inherit features target; }
        && (
          !(dep.optional or false)
          || builtins.any (doesFeatureEnableDependency dep) features
        )
      )
      dependencies;

  /* Returns whether the given feature should enable the given dependency. */
  doesFeatureEnableDependency = { name, rename ? null, ... }: feature:
    let
      prefix = "${name}/";
      len = builtins.stringLength prefix;
      startsWithPrefix = builtins.substring 0 len feature == prefix;
    in
    (rename == null && feature == name)
    || (rename != null && rename == feature)
    || startsWithPrefix;

  /* Returns the expanded features for the given inputFeatures by applying the
    rules in featureMap.

    featureMap is an attribute set which maps feature names to lists of further
    feature names to enable in case this feature is selected.
  */
  expandFeatures = featureMap: inputFeatures:
    assert (builtins.isAttrs featureMap);
    assert (builtins.isList inputFeatures);
    let
      expandFeature = feature:
        assert (builtins.isString feature);
        [ feature ] ++ (expandFeatures featureMap (featureMap."${feature}" or [ ]));
      outFeatures = lib.concatMap expandFeature inputFeatures;
    in
    sortedUnique outFeatures;

  /* This function adds optional dependencies as features if they are enabled
    indirectly by dependency features. This function mimics Cargo's behavior
    described in a note at:
    https://doc.rust-lang.org/nightly/cargo/reference/features.html#dependency-features
  */
  enableFeatures = dependencies: features:
    assert (builtins.isList features);
    assert (builtins.isList dependencies);
    let
      additionalFeatures = lib.concatMap
        (
          dependency:
            assert (builtins.isAttrs dependency);
            let
              enabled = builtins.any (doesFeatureEnableDependency dependency) features;
            in
            if (dependency.optional or false) && enabled then [ dependency.name ] else [ ]
        )
        dependencies;
    in
    sortedUnique (features ++ additionalFeatures);

  /*
    Returns the actual features for the given dependency.

    features: The features of the crate that refers this dependency.
  */
  dependencyFeatures = features: dependency:
    assert (builtins.isList features);
    assert (builtins.isAttrs dependency);
    let
      defaultOrNil =
        if dependency.usesDefaultFeatures or true
        then [ "default" ]
        else [ ];
      explicitFeatures = dependency.features or [ ];
      additionalDependencyFeatures =
        let
          dependencyPrefix = (dependency.rename or dependency.name) + "/";
          dependencyFeatures =
            builtins.filter (f: lib.hasPrefix dependencyPrefix f) features;
        in
        builtins.map (lib.removePrefix dependencyPrefix) dependencyFeatures;
    in
    defaultOrNil ++ explicitFeatures ++ additionalDependencyFeatures;

  /* Sorts and removes duplicates from a list of strings. */
  sortedUnique = features:
    assert (builtins.isList features);
    assert (builtins.all builtins.isString features);
    let
      outFeaturesSet = lib.foldl (set: feature: set // { "${feature}" = 1; }) { } features;
      outFeaturesUnique = builtins.attrNames outFeaturesSet;
    in
    builtins.sort (a: b: a < b) outFeaturesUnique;

  deprecationWarning = message: value:
    if strictDeprecation
    then builtins.throw "strictDeprecation enabled, aborting: ${message}"
    else builtins.trace message value;

  #
  # crate2nix/default.nix (excerpt end)
  #
  };
}

