//
// Copyright (c) 2021 RepliXio Ltd. All rights reserved.
// Use is subject to license terms.
//

use serde::{Deserialize, Serialize};
use structopt::StructOpt;

#[derive(Debug, Default, Serialize, Deserialize, PartialEq, StructOpt)]
#[serde(rename_all = "UPPERCASE")]
pub(crate) struct AzureCredentials {
    // #[structopt(help = "Azure Tenant ID", long, requires_all = &["azure_client_id", "azure_client_secret"])]
    #[structopt(help = "Azure Tenant ID", long)]
    azure_tenant_id: String,
    #[structopt(help = "Azure Client ID", long)]
    azure_client_id: String,
    #[structopt(help = "Azure Client Secret", long)]
    azure_client_secret: String,
}

#[cfg(test)]
mod tests {
    use serde_json as json;

    use super::*;

    #[test]
    fn deserialize() {
        let azure = AzureCredentials::default();

        let azure = json::to_value(azure).unwrap();
        assert!(azure.is_object());
        assert!(azure.get("AZURE_TENANT_ID").is_some());
        assert!(azure.get("AZURE_CLIENT_ID").is_some());
        assert!(azure.get("AZURE_CLIENT_SECRET").is_some());
        assert!(azure.get("azure_client_secret").is_none());
    }
}
