//
// Copyright (c) 2021 RepliXio Ltd. All rights reserved.
// Use is subject to license terms.
//

use cluster::{ClusterSpec, StatehubCluster};
use k8s_openapi::apiextensions_apiserver::pkg::apis::apiextensions::v1::CustomResourceDefinition;
use kube::CustomResourceExt;
use kube::ResourceExt;

use super::*;

impl Kubectl {
    pub(super) async fn install_crd(&self) -> anyhow::Result<CustomResourceDefinition> {
        let mut crd = StatehubCluster::crd();
        let crds = self.api::<CustomResourceDefinition>().await?;
        let name = crd.name();
        if let Ok(existing) = crds.get(&name).await {
            crd.meta_mut().resource_version = existing.resource_version();
        }

        let pp = self.post_params();

        let crd = if crd.resource_version().is_some() {
            crds.replace(&name, &pp, &crd).await?
        } else {
            crds.create(&pp, &crd).await?
        };
        Ok(crd)
    }

    pub(super) async fn create_statehub_cluster_crd(
        &self,
        name: &v0::ClusterName,
        namespace: &str,
    ) -> anyhow::Result<StatehubCluster> {
        let namespace = namespace.to_string();
        let spec = ClusterSpec { namespace };
        let mut cluster = StatehubCluster::new(name, spec);
        let clusters = self.api::<StatehubCluster>().await?;
        if let Ok(existing) = clusters.get(name).await {
            cluster.meta_mut().resource_version = existing.resource_version();
        }

        let pp = self.post_params();

        let cluster = if cluster.resource_version().is_some() {
            clusters.replace(name, &pp, &cluster).await?
        } else {
            clusters.create(&pp, &cluster).await?
        };
        Ok(cluster)
    }
}
