//
// Copyright (c) 2021 RepliXio Ltd. All rights reserved.
// Use is subject to license terms.
//

use kube::Resource;

use super::*;

pub trait RoleBindingExt: super::ResourceExt {
    fn new(name: impl ToString, role: &rbacv1::Role) -> Self;
    #[must_use]
    fn subjects(self, subjects: impl IntoIterator<Item = rbacv1::Subject>) -> Self;
}

impl RoleBindingExt for rbacv1::RoleBinding {
    fn new(name: impl ToString, role: &rbacv1::Role) -> Self {
        let metadata = Self::metadata(name);
        let role_ref = rbacv1::RoleRef {
            api_group: rbacv1::Role::group(&()).to_string(),
            kind: rbacv1::Role::kind(&()).to_string(),
            name: role.name(),
        };
        Self {
            metadata,
            role_ref,
            // subjects: todo!(),
            ..Self::default()
        }
    }

    fn subjects(self, subjects: impl IntoIterator<Item = rbacv1::Subject>) -> Self {
        let subjects = Some(subjects.into_iter().collect());
        Self { subjects, ..self }
    }
}
