//
// Copyright (c) 2021 RepliXio Ltd. All rights reserved.
// Use is subject to license terms.
//

use super::*;

pub trait ContainerExt {
    fn new(name: impl ToString) -> Self;
    fn env(self, env: impl IntoIterator<Item = (impl ToString, impl ToString)>) -> Self;
    fn image(self, image: impl ToString) -> Self;
    fn image_pull_policy_always(self) -> Self;
    fn image_pull_policy_never(self) -> Self;
}

impl ContainerExt for corev1::Container {
    fn new(name: impl ToString) -> Self {
        let name = name.to_string();
        Self {
            name,
            // args: todo!(),
            // command: todo!(),
            // env: todo!(),
            // env_from: todo!(),
            // image: todo!(),
            // image_pull_policy: todo!(),
            // lifecycle: todo!(),
            // liveness_probe: todo!(),
            // ports: todo!(),
            // readiness_probe: todo!(),
            // resources: todo!(),
            // security_context: todo!(),
            // startup_probe: todo!(),
            // stdin: todo!(),
            // stdin_once: todo!(),
            // termination_message_path: todo!(),
            // termination_message_policy: todo!(),
            // tty: todo!(),
            // volume_devices: todo!(),
            // volume_mounts: todo!(),
            // working_dir: todo!(),
            ..Self::default()
        }
    }

    fn env(self, env: impl IntoIterator<Item = (impl ToString, impl ToString)>) -> Self {
        let env = Some(
            env.into_iter()
                .map(|(name, value)| corev1::EnvVar::value(name, value))
                .collect(),
        );
        Self { env, ..self }
    }

    fn image(self, image: impl ToString) -> Self {
        let image = Some(image.to_string());
        Self { image, ..self }
    }

    fn image_pull_policy_always(self) -> Self {
        let image_pull_policy = Some(String::from("Always"));
        Self {
            image_pull_policy,
            ..self
        }
    }

    fn image_pull_policy_never(self) -> Self {
        let image_pull_policy = Some(String::from("Never"));
        Self {
            image_pull_policy,
            ..self
        }
    }
}
