//
// Copyright (c) 2021 RepliXio Ltd. All rights reserved.
// Use is subject to license terms.
//

use super::*;

pub trait EnvVarExt {
    fn value(name: impl ToString, value: impl ToString) -> Self;
}

impl EnvVarExt for corev1::EnvVar {
    fn value(name: impl ToString, value: impl ToString) -> Self {
        let name = name.to_string();
        let value = Some(value.to_string());
        Self {
            name,
            value,
            value_from: None,
        }
    }
}
